/* TextButton.c generated by valac 0.26.2, the Vala compiler
 * generated from TextButton.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;
typedef struct _TextButtonPrivate TextButtonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TextButton {
	GtkButton parent_instance;
	TextButtonPrivate * priv;
};

struct _TextButtonClass {
	GtkButtonClass parent_class;
};


static gpointer text_button_parent_class = NULL;

GType text_button_get_type (void) G_GNUC_CONST;
enum  {
	TEXT_BUTTON_DUMMY_PROPERTY,
	TEXT_BUTTON_READ_ONLY
};
TextButton* text_button_new (const gchar* label);
TextButton* text_button_construct (GType object_type, const gchar* label);
void text_button_set_markup (TextButton* self, const gchar* text);
void text_button_set_read_only (TextButton* self, gboolean value);
static void _vala_text_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


TextButton* text_button_construct (GType object_type, const gchar* label) {
	TextButton * self = NULL;
	const gchar* _tmp0_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (TextButton*) g_object_new (object_type, NULL);
	_tmp0_ = label;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = label;
		gtk_button_set_label (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), _tmp1_);
	}
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "text-only-button");
	return self;
}


TextButton* text_button_new (const gchar* label) {
	return text_button_construct (TYPE_TEXT_BUTTON, label);
}


/**
   * Adds a GtkLabel to the Button using the given text as markup.
   * If the button already contains another child, that will either be replaced if it's
   * no instance of GtkLabel, or - if it's a GtkLabel already - be reused.
   *
   * @param text The markup to use(see pango markup)
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void text_button_set_markup (TextButton* self, const gchar* text) {
	GtkLabel* label = NULL;
	GtkWidget* child = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkContainer* _tmp18_ = NULL;
	GtkContainer* _tmp19_ = NULL;
	g_return_if_fail (IS_TEXT_BUTTON (self));
	g_return_if_fail (text != NULL);
	label = NULL;
	_tmp0_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	child = _tmp1_;
	_tmp2_ = child;
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_ = NULL;
		_tmp3_ = child;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_label_get_type ())) {
			GtkWidget* _tmp4_ = NULL;
			GtkLabel* _tmp5_ = NULL;
			GtkLabel* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			_tmp4_ = child;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_label_get_type (), GtkLabel));
			_g_object_unref0 (label);
			label = _tmp5_;
			_tmp6_ = label;
			_tmp7_ = text;
			gtk_label_set_markup (_tmp6_, _tmp7_);
		} else {
			GtkWidget* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GtkLabel* _tmp10_ = NULL;
			_tmp8_ = child;
			gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp8_);
			_tmp9_ = text;
			_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
			g_object_ref_sink (_tmp10_);
			_g_object_unref0 (label);
			label = _tmp10_;
		}
	} else {
		const gchar* _tmp11_ = NULL;
		GtkLabel* _tmp12_ = NULL;
		_tmp11_ = text;
		_tmp12_ = (GtkLabel*) gtk_label_new (_tmp11_);
		g_object_ref_sink (_tmp12_);
		_g_object_unref0 (label);
		label = _tmp12_;
	}
	_tmp13_ = label;
	gtk_label_set_use_markup (_tmp13_, TRUE);
	_tmp14_ = label;
	gtk_label_set_justify (_tmp14_, GTK_JUSTIFY_CENTER);
	_tmp15_ = label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp16_ = label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp17_ = label;
	_tmp18_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	_tmp19_ = _tmp18_;
	if (_tmp19_ == NULL) {
		GtkLabel* _tmp20_ = NULL;
		_tmp20_ = label;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (child);
	_g_object_unref0 (label);
}


void text_button_set_read_only (TextButton* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_TEXT_BUTTON (self));
	_tmp0_ = value;
	if (_tmp0_) {
		GtkStyleContext* _tmp1_ = NULL;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp1_, "readonly-text-only-button");
	} else {
		GtkStyleContext* _tmp2_ = NULL;
		_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp2_, "readonly-text-only-button");
	}
	_tmp3_ = value;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), !_tmp3_);
	g_object_notify ((GObject *) self, "read-only");
}


static void text_button_class_init (TextButtonClass * klass) {
	text_button_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->set_property = _vala_text_button_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TEXT_BUTTON_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void text_button_instance_init (TextButton * self) {
}


GType text_button_get_type (void) {
	static volatile gsize text_button_type_id__volatile = 0;
	if (g_once_init_enter (&text_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TextButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) text_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TextButton), 0, (GInstanceInitFunc) text_button_instance_init, NULL };
		GType text_button_type_id;
		text_button_type_id = g_type_register_static (gtk_button_get_type (), "TextButton", &g_define_type_info, 0);
		g_once_init_leave (&text_button_type_id__volatile, text_button_type_id);
	}
	return text_button_type_id__volatile;
}


static void _vala_text_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TextButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TEXT_BUTTON, TextButton);
	switch (property_id) {
		case TEXT_BUTTON_READ_ONLY:
		text_button_set_read_only (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



