/* Account.c generated by valac 0.30.0, the Vala compiler
 * generated from Account.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <rest/oauth-proxy.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <glib/gstdio.h>
#include <libsoup/soup.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
typedef struct _AccountPrivate AccountPrivate;

#define TYPE_FILTER (filter_get_type ())
#define FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER, Filter))
#define FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER, FilterClass))
#define IS_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER))
#define IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER))
#define FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER, FilterClass))

typedef struct _Filter Filter;
typedef struct _FilterClass FilterClass;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_USER_COUNTER (user_counter_get_type ())
#define USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COUNTER, UserCounter))
#define USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COUNTER, UserCounterClass))
#define IS_USER_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COUNTER))
#define IS_USER_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COUNTER))
#define USER_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COUNTER, UserCounterClass))

typedef struct _UserCounter UserCounter;
typedef struct _UserCounterClass UserCounterClass;

#define TYPE_USER_EVENT_RECEIVER (user_event_receiver_get_type ())
#define USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiver))
#define USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))
#define IS_USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_EVENT_RECEIVER))
#define IS_USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_EVENT_RECEIVER))
#define USER_EVENT_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))

typedef struct _UserEventReceiver UserEventReceiver;
typedef struct _UserEventReceiverClass UserEventReceiverClass;
#define _sql_database_unref0(var) ((var == NULL) ? NULL : (var = (sql_database_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _sql_select_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_select_statement_unref (var), NULL)))

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;
typedef struct _Block4Data Block4Data;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())
typedef struct _AccountQueryUserInfoByScreenNameData AccountQueryUserInfoByScreenNameData;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block5Data Block5Data;
typedef struct _AccountInitInformationData AccountInitInformationData;
typedef struct _AccountLoadIdArrayData AccountLoadIdArrayData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _sql_update_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_update_statement_unref (var), NULL)))
typedef struct _AccountUpdateAvatarData AccountUpdateAvatarData;

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;
#define _sql_insert_statement_unref0(var) ((var == NULL) ? NULL : (var = (sql_insert_statement_unref (var), NULL)))

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GeeArrayList* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _AccountPrivate {
	gint64 _id;
	SqlDatabase* _db;
	gchar* _screen_name;
	gchar* _name;
	gchar* _avatar_url;
	gchar* _banner_url;
	gchar* _website;
	gchar* _description;
	cairo_surface_t* _avatar_small;
	cairo_surface_t* _avatar;
	OAuthProxy* _proxy;
	UserStream* _user_stream;
	UserCounter* _user_counter;
	UserEventReceiver* event_receiver;
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _Block4Data {
	int _ref_count_;
	Account* self;
	TextEntity* urls;
	gint urls_length1;
	gint _urls_size_;
	gpointer _async_data_;
};

typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;

struct _AccountQueryUserInfoByScreenNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* self;
	gchar* screen_name;
	Block4Data* _data4_;
	OAuthProxy* _tmp0_;
	RestProxyCall* call;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	const gchar* _tmp5_;
	RestProxyCall* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	RestProxyCall* _tmp9_;
	gint64 _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	JsonNode* root_node;
	JsonNode* _tmp14_;
	RestProxyCall* _tmp15_;
	JsonNode* _tmp16_;
	JsonNode* _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	gboolean values_changed;
	JsonObject* root;
	JsonNode* _tmp20_;
	JsonObject* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	gint64 _tmp24_;
	const gchar* _tmp25_;
	JsonObject* _tmp26_;
	const gchar* _tmp27_;
	JsonObject* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	JsonObject* _tmp31_;
	const gchar* _tmp32_;
	gchar* old_screen_name;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	JsonObject* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	JsonArray* desc_urls;
	JsonObject* _tmp39_;
	JsonObject* _tmp40_;
	JsonObject* _tmp41_;
	JsonArray* _tmp42_;
	JsonArray* _tmp43_;
	JsonArray* _tmp44_;
	guint _tmp45_;
	TextEntity* _tmp46_;
	JsonArray* _tmp47_;
	JsonObject* _tmp48_;
	const gchar* _tmp49_;
	TextEntity* _tmp50_;
	gint _tmp50__length1;
	gchar* _tmp51_;
	gchar* _tmp52_;
	JsonObject* _tmp53_;
	gboolean _tmp54_;
	JsonObject* _tmp55_;
	const gchar* _tmp56_;
	JsonObject* _tmp57_;
	JsonObject* _tmp58_;
	gboolean _tmp59_;
	JsonObject* _tmp60_;
	JsonObject* _tmp61_;
	JsonObject* _tmp62_;
	JsonArray* _tmp63_;
	JsonObject* _tmp64_;
	const gchar* _tmp65_;
	gchar* avatar_url;
	JsonObject* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gboolean _tmp69_;
	const gchar* _tmp70_;
	gboolean _tmp71_;
	gboolean _tmp72_;
	SqlDatabase* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	cairo_surface_t* _tmp76_;
	cairo_surface_t* _tmp77_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	Account* self;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _AccountInitInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* self;
	Block5Data* _data5_;
	Collect* _tmp0_;
};

struct _AccountLoadIdArrayData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* self;
	Collect* collect_obj;
	gchar* function;
	gboolean direct;
	JsonArray* result;
	RestProxyCall* call;
	OAuthProxy* _tmp0_;
	RestProxyCall* _tmp1_;
	RestProxyCall* _tmp2_;
	const gchar* _tmp3_;
	RestProxyCall* _tmp4_;
	JsonNode* root;
	JsonNode* _tmp5_;
	RestProxyCall* _tmp6_;
	JsonNode* _tmp7_;
	JsonNode* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	Collect* _tmp11_;
	gboolean _tmp12_;
	JsonNode* _tmp13_;
	JsonArray* _tmp14_;
	JsonArray* _tmp15_;
	JsonNode* _tmp16_;
	JsonObject* _tmp17_;
	JsonArray* _tmp18_;
	JsonArray* _tmp19_;
	GError * _inner_error_;
};

struct _Block6Data {
	int _ref_count_;
	Account* self;
	gchar* dest_path;
	gchar* big_dest;
	gchar* url;
	gpointer _async_data_;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	SoupMessage* msg;
};

struct _AccountUpdateAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Account* self;
	gchar* url;
	gboolean result;
	Block6Data* _data6_;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	Block7Data* _data7_;
	const gchar* _tmp31_;
	SoupMessage* _tmp32_;
	SoupSession* _tmp33_;
	SoupMessage* _tmp34_;
	SoupMessage* _tmp35_;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};


static gpointer account_parent_class = NULL;
static GSList* account_accounts;
static GSList* account_accounts = NULL;
extern SoupSession* SOUP_SESSION;
extern SqlDatabase* corebird_db;

GType account_get_type (void) G_GNUC_CONST;
GType filter_get_type (void) G_GNUC_CONST;
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType user_counter_get_type (void) G_GNUC_CONST;
GType user_event_receiver_get_type (void) G_GNUC_CONST;
#define ACCOUNT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT, AccountPrivate))
enum  {
	ACCOUNT_DUMMY_PROPERTY,
	ACCOUNT_ID,
	ACCOUNT_DB,
	ACCOUNT_SCREEN_NAME,
	ACCOUNT_NAME,
	ACCOUNT_AVATAR_URL,
	ACCOUNT_BANNER_URL,
	ACCOUNT_WEBSITE,
	ACCOUNT_DESCRIPTION,
	ACCOUNT_AVATAR_SMALL,
	ACCOUNT_AVATAR,
	ACCOUNT_PROXY,
	ACCOUNT_USER_STREAM,
	ACCOUNT_USER_COUNTER
};
#define ACCOUNT_DUMMY "screen_name"
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
static void account_set_id (Account* self, gint64 value);
void account_set_screen_name (Account* self, const gchar* value);
void account_set_name (Account* self, const gchar* value);
UserEventReceiver* user_event_receiver_new (Account* account);
UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account);
void account_init_database (Account* self);
SqlDatabase* account_get_db (Account* self);
gchar* dirs_config (const gchar* path);
gint64 account_get_id (Account* self);
#define DATADIR "/usr/share/corebird/"
#define SQL_ACCOUNTS_INIT_FILE DATADIR "/sql/accounts/Create.%d.sql"
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file);
static void account_set_db (Account* self, SqlDatabase* value);
UserCounter* user_counter_new (void);
UserCounter* user_counter_construct (GType object_type);
static void account_set_user_counter (Account* self, UserCounter* value);
UserCounter* account_get_user_counter (Account* self);
void user_counter_load (UserCounter* self, SqlDatabase* db);
static void account_load_filters (Account* self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
OAuthProxy* account_get_proxy (Account* self);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
static void account_set_proxy (Account* self, OAuthProxy* value);
UserStream* user_stream_new (Account* account);
UserStream* user_stream_construct (GType object_type, Account* account);
static void account_set_user_stream (Account* self, UserStream* value);
UserStream* account_get_user_stream (Account* self);
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
void user_stream_register (UserStream* self, IMessageReceiver* receiver);
gpointer sql_select_statement_ref (gpointer instance);
void sql_select_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_select_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_select_statement (GValue* value, gpointer v_object);
void sql_value_take_select_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_select_statement (const GValue* value);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean ___lambda16_ (Account* self, gchar** vals, int vals_length1);
void user_stream_set_token (UserStream* self, const gchar* value);
void user_stream_set_token_secret (UserStream* self, const gchar* value);
static gboolean ____lambda16__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
const gchar* account_get_screen_name (Account* self);
void account_uninit (Account* self);
void user_stream_stop (UserStream* self);
gint user_counter_save (UserCounter* self, SqlDatabase* db);
void account_load_avatar (Account* self);
cairo_surface_t* load_surface (const gchar* path);
static void account_set_avatar_small (Account* self, cairo_surface_t* value);
static void account_set_avatar (Account* self, cairo_surface_t* value);
const gchar* account_get_name (Account* self);
cairo_surface_t* account_get_avatar (Account* self);
cairo_surface_t* account_get_avatar_small (Account* self);
void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar);
cairo_surface_t* scale_surface (cairo_surface_t* input, gint output_width, gint output_height);
void write_surface (cairo_surface_t* surface, const gchar* path);
static void account_query_user_info_by_screen_name_data_free (gpointer _data);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
static gboolean account_query_user_info_by_screen_name_co (AccountQueryUserInfoByScreenNameData* _data_);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void _vala_TextEntity_array_free (TextEntity* array, gint array_length);
static void block4_data_unref (void * _userdata_);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void account_query_user_info_by_screen_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
static void __lambda19_ (Block4Data* _data4_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda19__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
GType transform_flags_get_type (void) G_GNUC_CONST;
gchar* text_transform_transform (const gchar* text, TextEntity* entities, int entities_length1, TransformFlags flags, guint media_count, gint64 quote_id);
void account_set_description (Account* self, const gchar* value);
static void account_set_banner_url (Account* self, const gchar* value);
void account_set_website (Account* self, const gchar* value);
static void account_update_avatar (Account* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean account_update_avatar_finish (Account* self, GAsyncResult* _res_);
void account_save_info (Account* self);
static void account_init_information_data_free (gpointer _data);
void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_init_information_finish (Account* self, GAsyncResult* _res_);
static gboolean account_init_information_co (AccountInitInformationData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda21_ (Block5Data* _data5_);
static void ___lambda21__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static void __lambda22_ (Block5Data* _data5_);
void collect_emit (Collect* self, GError* _error_);
static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_load_id_array (Account* self, Collect* collect_obj, const gchar* function, gboolean direct, GAsyncReadyCallback _callback_, gpointer _user_data_);
static JsonArray* account_load_id_array_finish (Account* self, GAsyncResult* _res_);
static void __lambda23_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
void account_set_disabled_rts (Account* self, JsonArray* disabled_rts_array);
static void ___lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda24_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
void account_set_blocked (Account* self, JsonArray* blocked_array);
static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda25_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res);
void account_set_muted (Account* self, JsonArray* muted_array);
static void ___lambda25__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_load_id_array_data_free (gpointer _data);
static gboolean account_load_id_array_co (AccountLoadIdArrayData* _data_);
static void account_load_id_array_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void account_update_avatar_data_free (gpointer _data);
static gboolean account_update_avatar_co (AccountUpdateAvatarData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
const gchar* account_get_avatar_url (Account* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda20_ (Block7Data* _data7_, SoupSession* _s, SoupMessage* _msg);
gchar* utils_get_file_type (const gchar* path);
void account_set_avatar_url (Account* self, const gchar* value);
gpointer sql_update_statement_ref (gpointer instance);
void sql_update_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_update_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_update_statement (GValue* value, gpointer v_object);
void sql_value_take_update_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_update_statement (const GValue* value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_where_eqi (SqlUpdateStatement* self, const gchar* col, gint64 iv);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static void ____lambda20__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self);
gpointer sql_insert_statement_ref (gpointer instance);
void sql_insert_statement_unref (gpointer instance);
GParamSpec* sql_param_spec_insert_statement (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_insert_statement (GValue* value, gpointer v_object);
void sql_value_take_insert_statement (GValue* value, gpointer v_object);
gpointer sql_value_get_insert_statement (const GValue* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_replace (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_vali64 (SqlInsertStatement* self, const gchar* col_name, gint64 col_value);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
static gboolean __lambda15_ (Account* self, gchar** cols, int cols_length1);
Filter* filter_new (const gchar* expression);
Filter* filter_construct (GType object_type, const gchar* expression);
void filter_set_id (Filter* self, gint value);
static gboolean ___lambda15__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void account_add_filter (Account* self, Filter* f);
GType tweet_get_type (void) G_GNUC_CONST;
gboolean account_filter_matches (Account* self, Tweet* t);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType media_get_type (void) G_GNUC_CONST;
gboolean filter_matches (Filter* self, const gchar* test_text);
gchar* tweet_get_real_text (Tweet* self);
void account_set_friends (Account* self, JsonArray* friends_array);
gboolean account_follows_id (Account* self, gint64 user_id);
void account_follow_id (Account* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
static gint64* _vala_array_dup1 (gint64* self, int length);
void account_mute_id (Account* self, gint64 id);
void account_unmute_id (Account* self, gint64 id);
static gint64* _vala_array_dup2 (gint64* self, int length);
void account_block_id (Account* self, gint64 id);
void account_unblock_id (Account* self, gint64 id);
static gint64* _vala_array_dup3 (gint64* self, int length);
void account_add_disabled_rts_id (Account* self, gint64 user_id);
void account_remove_disabled_rts_id (Account* self, gint64 user_id);
static gint64* _vala_array_dup4 (gint64* self, int length);
gboolean account_blocked_or_muted (Account* self, gint64 user_id);
GSList* account_list_accounts (void);
static void account_lookup_accounts (void);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static gboolean __lambda41_ (gchar** vals, int vals_length1);
static gboolean ___lambda41__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void account_add_account (Account* acc);
void account_remove_account (const gchar* screen_name);
Account* account_query_account (const gchar* screen_name);
Account* account_query_account_by_id (gint64 id);
const gchar* account_get_banner_url (Account* self);
const gchar* account_get_website (Account* self);
const gchar* account_get_description (Account* self);
static void g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void account_finalize (GObject* obj);
static void _vala_account_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_account_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name) {
	Account * self = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	UserEventReceiver* _tmp4_ = NULL;
	g_return_val_if_fail (screen_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (Account*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	account_set_id (self, _tmp0_);
	_tmp1_ = screen_name;
	account_set_screen_name (self, _tmp1_);
	_tmp2_ = name;
	account_set_name (self, _tmp2_);
	_tmp3_ = gee_array_list_new (TYPE_FILTER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->filters);
	self->filters = _tmp3_;
	_tmp4_ = user_event_receiver_new (self);
	_g_object_unref0 (self->priv->event_receiver);
	self->priv->event_receiver = _tmp4_;
	return self;
}


Account* account_new (gint64 id, const gchar* screen_name, const gchar* name) {
	return account_construct (TYPE_ACCOUNT, id, screen_name, name);
}


/**
   * Initializes the database. All account databases are VersionedDatabases
   * and are stored in accounts/ID.db.
   *
   */
void account_init_database (Account* self) {
	SqlDatabase* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	SqlDatabase* _tmp8_ = NULL;
	SqlDatabase* _tmp9_ = NULL;
	UserCounter* _tmp10_ = NULL;
	UserCounter* _tmp11_ = NULL;
	UserCounter* _tmp12_ = NULL;
	SqlDatabase* _tmp13_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->priv->_db;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->_id;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("accounts/", _tmp3_, ".db", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = dirs_config (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = sql_database_new (_tmp7_, SQL_ACCOUNTS_INIT_FILE);
	_tmp9_ = _tmp8_;
	account_set_db (self, _tmp9_);
	_sql_database_unref0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp10_ = user_counter_new ();
	_tmp11_ = _tmp10_;
	account_set_user_counter (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->_user_counter;
	_tmp13_ = self->priv->_db;
	user_counter_load (_tmp12_, _tmp13_);
	account_load_filters (self);
}


/**
   * Initializes the RestProxy object.
   *
   * @param load_secrets If set to true, the token and token_secret will be loaded
   *                     from the account's database.
   * @param force        If set to true, we will simply force to create a new
   *                     RestProxy object.
   */
static gboolean ___lambda16_ (Account* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	OAuthProxy* _tmp0_ = NULL;
	UserStream* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp3_ = NULL;
	OAuthProxy* _tmp4_ = NULL;
	UserStream* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	_tmp0_ = self->priv->_proxy;
	_tmp1_ = self->priv->_user_stream;
	_tmp2_ = vals;
	_tmp2__length1 = vals_length1;
	_tmp3_ = _tmp2_[0];
	user_stream_set_token (_tmp1_, _tmp3_);
	oauth_proxy_set_token (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->_proxy;
	_tmp5_ = self->priv->_user_stream;
	_tmp6_ = vals;
	_tmp6__length1 = vals_length1;
	_tmp7_ = _tmp6_[1];
	user_stream_set_token_secret (_tmp5_, _tmp7_);
	oauth_proxy_set_token_secret (_tmp4_, _tmp7_);
	result = FALSE;
	return result;
}


static gboolean ____lambda16__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = ___lambda16_ ((Account*) self, vals, vals_length1);
	return result;
}


void account_init_proxy (Account* self, gboolean load_secrets, gboolean force) {
	gboolean _tmp0_ = FALSE;
	OAuthProxy* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	OAuthProxy* _tmp7_ = NULL;
	OAuthProxy* _tmp8_ = NULL;
	UserStream* _tmp9_ = NULL;
	UserStream* _tmp10_ = NULL;
	UserStream* _tmp11_ = NULL;
	UserEventReceiver* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->priv->_proxy;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = force;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = settings_get_consumer_key ();
	_tmp4_ = _tmp3_;
	_tmp5_ = settings_get_consumer_secret ();
	_tmp6_ = _tmp5_;
	_tmp7_ = (OAuthProxy*) oauth_proxy_new (_tmp4_, _tmp6_, "https://api.twitter.com/", FALSE);
	_tmp8_ = _tmp7_;
	account_set_proxy (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp9_ = user_stream_new (self);
	_tmp10_ = _tmp9_;
	account_set_user_stream (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->_user_stream;
	_tmp12_ = self->priv->event_receiver;
	user_stream_register (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_IMESSAGE_RECEIVER, IMessageReceiver));
	_tmp13_ = load_secrets;
	if (_tmp13_) {
		gint n_rows = 0;
		SqlDatabase* _tmp14_ = NULL;
		SqlSelectStatement* _tmp15_ = NULL;
		SqlSelectStatement* _tmp16_ = NULL;
		SqlSelectStatement* _tmp17_ = NULL;
		SqlSelectStatement* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		account_init_database (self);
		_tmp14_ = self->priv->_db;
		_tmp15_ = sql_database_select (_tmp14_, "common");
		_tmp16_ = _tmp15_;
		_tmp17_ = sql_select_statement_cols (_tmp16_, "token", "token_secret", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = sql_select_statement_run (_tmp18_, ____lambda16__sql_select_callback, self);
		_tmp20_ = _tmp19_;
		_sql_select_statement_unref0 (_tmp18_);
		_sql_select_statement_unref0 (_tmp16_);
		n_rows = _tmp20_;
		_tmp21_ = n_rows;
		if (_tmp21_ < 1) {
			const gchar* _tmp22_ = NULL;
			_tmp22_ = self->priv->_screen_name;
			g_critical ("Account.vala:95: Could not load token{_secret} for user %s", _tmp22_);
		}
	}
}


void account_uninit (Account* self) {
	UserStream* _tmp0_ = NULL;
	UserCounter* _tmp1_ = NULL;
	SqlDatabase* _tmp2_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	account_set_proxy (self, NULL);
	_tmp0_ = self->priv->_user_stream;
	user_stream_stop (_tmp0_);
	_tmp1_ = self->priv->_user_counter;
	_tmp2_ = self->priv->_db;
	user_counter_save (_tmp1_, _tmp2_);
	account_set_user_stream (self, NULL);
}


/**
   * Loads the small and normally sized avatars from disk.
   * Normal: accounts/ID.png
   * Small:  accounts/ID_small.png
   */
void account_load_avatar (Account* self) {
	gchar* small_path = NULL;
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* path = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	cairo_surface_t* _tmp14_ = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_surface_t* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	cairo_surface_t* _tmp20_ = NULL;
	cairo_surface_t* _tmp21_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->priv->_id;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("accounts/", _tmp2_, "_small.png", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = dirs_config (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	small_path = _tmp6_;
	_tmp7_ = self->priv->_id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("accounts/", _tmp9_, ".png", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = dirs_config (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	path = _tmp13_;
	_tmp14_ = load_surface (small_path);
	_tmp15_ = _tmp14_;
	account_set_avatar_small (self, _tmp15_);
	_cairo_surface_destroy0 (_tmp15_);
	_tmp16_ = load_surface (path);
	_tmp17_ = _tmp16_;
	account_set_avatar (self, _tmp17_);
	_cairo_surface_destroy0 (_tmp17_);
	_tmp18_ = self->priv->_screen_name;
	_tmp19_ = self->priv->_name;
	_tmp20_ = self->priv->_avatar;
	_tmp21_ = self->priv->_avatar_small;
	g_signal_emit_by_name (self, "info-changed", _tmp18_, _tmp19_, _tmp20_, _tmp21_);
	_g_free0 (path);
	_g_free0 (small_path);
}


void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar) {
	gchar* path = NULL;
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* small_path = NULL;
	gint64 _tmp7_ = 0LL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	cairo_surface_t* avatar = NULL;
	cairo_surface_t* _tmp14_ = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_surface_t* avatar_small = NULL;
	cairo_surface_t* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (new_avatar != NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("accounts/", _tmp2_, ".png", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = dirs_config (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	path = _tmp6_;
	_tmp7_ = self->priv->_id;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("accounts/", _tmp9_, "_small.png", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = dirs_config (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	small_path = _tmp13_;
	_tmp14_ = new_avatar;
	_tmp15_ = scale_surface ((cairo_surface_t*) _tmp14_, 48, 48);
	avatar = _tmp15_;
	_tmp16_ = new_avatar;
	_tmp17_ = scale_surface ((cairo_surface_t*) _tmp16_, 24, 24);
	avatar_small = _tmp17_;
	write_surface (avatar, path);
	write_surface (avatar_small, small_path);
	account_set_avatar (self, avatar);
	account_set_avatar_small (self, avatar_small);
	_cairo_surface_destroy0 (avatar_small);
	_cairo_surface_destroy0 (avatar);
	_g_free0 (small_path);
	_g_free0 (path);
}


static void account_query_user_info_by_screen_name_data_free (gpointer _data) {
	AccountQueryUserInfoByScreenNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->screen_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountQueryUserInfoByScreenNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountQueryUserInfoByScreenNameData* _data_;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (AccountQueryUserInfoByScreenNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, account_query_user_info_by_screen_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, account_query_user_info_by_screen_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = screen_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->screen_name);
	_data_->screen_name = _tmp2_;
	account_query_user_info_by_screen_name_co (_data_);
}


void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_) {
	AccountQueryUserInfoByScreenNameData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Download the appropriate user info from the Twitter server,
   * updating the local information stored in this class' local variables
   * and the information stored in the account's database file.
   *
   * @param screen_name The screen name to use for the API call or null in
   *                    which case the ID will be used.
   */
static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void _vala_TextEntity_array_free (TextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			text_entity_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Account* self;
		self = _data4_->self;
		_data4_->urls = (_vala_TextEntity_array_free (_data4_->urls, _data4_->urls_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void account_query_user_info_by_screen_name_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AccountQueryUserInfoByScreenNameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	account_query_user_info_by_screen_name_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda19_ (Block4Data* _data4_, JsonArray* arr, guint index, JsonNode* node) {
	Account* self;
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp3_ = NULL;
	JsonArray* _tmp4_ = NULL;
	TextEntity* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	guint _tmp6_ = 0U;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp8_ = 0LL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	TextEntity _tmp11_ = {0};
	TextEntity _tmp12_ = {0};
	self = _data4_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = json_object_get_array_member (obj, "indices");
	_tmp4_ = _json_array_ref0 (_tmp3_);
	indices = _tmp4_;
	_tmp5_ = _data4_->urls;
	_tmp5__length1 = _data4_->urls_length1;
	_tmp6_ = index;
	_tmp7_ = json_array_get_int_element (indices, (guint) 0);
	_tmp8_ = json_array_get_int_element (indices, (guint) 1);
	_tmp9_ = json_object_get_string_member (obj, "expanded_url");
	_tmp10_ = g_strdup (_tmp9_);
	memset (&_tmp11_, 0, sizeof (TextEntity));
	_tmp11_.from = (guint) ((gint) _tmp7_);
	_tmp11_.to = (guint) ((gint) _tmp8_);
	_g_free0 (_tmp11_.display_text);
	_tmp11_.display_text = _tmp10_;
	_g_free0 (_tmp11_.target);
	_tmp11_.target = NULL;
	text_entity_destroy (&_tmp5_[_tmp6_]);
	_tmp5_[_tmp6_] = _tmp11_;
	_tmp12_ = _tmp5_[_tmp6_];
	_json_array_unref0 (indices);
	_json_object_unref0 (obj);
}


static void ___lambda19__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda19_ (self, array, index_, element_node);
}


static gboolean account_query_user_info_by_screen_name_co (AccountQueryUserInfoByScreenNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data4_ = g_slice_new0 (Block4Data);
	_data_->_data4_->_ref_count_ = 1;
	_data_->_data4_->self = g_object_ref (_data_->self);
	_data_->_data4_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_proxy;
	if (_data_->_tmp0_ == NULL) {
		g_error ("Account.vala:146: Proxy not initied");
	}
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->_proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/users/show.json");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->screen_name;
	if (_data_->_tmp5_ != NULL) {
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->call;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->screen_name;
		rest_proxy_call_add_param (_data_->_tmp6_, "screen_name", _data_->_tmp7_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->screen_name;
		account_set_screen_name (_data_->self, _data_->_tmp8_);
	} else {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->call;
		_data_->_tmp10_ = 0LL;
		_data_->_tmp10_ = _data_->self->priv->_id;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		rest_proxy_call_add_param (_data_->_tmp9_, "user_id", _data_->_tmp12_);
		_g_free0 (_data_->_tmp12_);
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "skip_status", "true");
	_data_->root_node = NULL;
	{
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp15_, account_query_user_info_by_screen_name_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp14_ = _data_->_tmp16_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->_tmp14_;
		_data_->_tmp14_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp17_;
		__vala_JsonNode_free0 (_data_->_tmp14_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->e;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning ("Account.vala:163: %s", _data_->_tmp19_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		block4_data_unref (_data_->_data4_);
		_data_->_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->values_changed = FALSE;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = _data_->root_node;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = json_node_get_object (_data_->_tmp20_);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _json_object_ref0 (_data_->_tmp21_);
	_data_->root = _data_->_tmp22_;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = _data_->root;
	_data_->_tmp24_ = 0LL;
	_data_->_tmp24_ = json_object_get_int_member (_data_->_tmp23_, "id");
	account_set_id (_data_->self, _data_->_tmp24_);
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->self->priv->_name;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->root;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = json_object_get_string_member (_data_->_tmp26_, "name");
	if (g_strcmp0 (_data_->_tmp25_, _data_->_tmp27_) != 0) {
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->root;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = json_object_get_string_member (_data_->_tmp28_, "name");
		account_set_name (_data_->self, _data_->_tmp29_);
		_data_->values_changed = TRUE;
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->self->priv->_screen_name;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->root;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = json_object_get_string_member (_data_->_tmp31_, "screen_name");
	if (g_strcmp0 (_data_->_tmp30_, _data_->_tmp32_) != 0) {
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->self->priv->_screen_name;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = g_strdup (_data_->_tmp33_);
		_data_->old_screen_name = _data_->_tmp34_;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->root;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = json_object_get_string_member (_data_->_tmp35_, "screen_name");
		account_set_screen_name (_data_->self, _data_->_tmp36_);
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->old_screen_name;
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->self->priv->_screen_name;
		utils_update_startup_account (_data_->_tmp37_, _data_->_tmp38_);
		_data_->values_changed = TRUE;
		_g_free0 (_data_->old_screen_name);
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->root;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = json_object_get_object_member (_data_->_tmp39_, "entities");
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = json_object_get_object_member (_data_->_tmp40_, "description");
	_data_->_tmp42_ = NULL;
	_data_->_tmp42_ = json_object_get_array_member (_data_->_tmp41_, "urls");
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = _json_array_ref0 (_data_->_tmp42_);
	_data_->desc_urls = _data_->_tmp43_;
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = _data_->desc_urls;
	_data_->_tmp45_ = 0U;
	_data_->_tmp45_ = json_array_get_length (_data_->_tmp44_);
	_data_->_tmp46_ = NULL;
	_data_->_tmp46_ = g_new0 (TextEntity, _data_->_tmp45_);
	_data_->_data4_->urls = _data_->_tmp46_;
	_data_->_data4_->urls_length1 = _data_->_tmp45_;
	_data_->_data4_->_urls_size_ = _data_->_data4_->urls_length1;
	_data_->_tmp47_ = NULL;
	_data_->_tmp47_ = _data_->desc_urls;
	json_array_foreach_element (_data_->_tmp47_, ___lambda19__json_array_foreach, _data_->_data4_);
	_data_->_tmp48_ = NULL;
	_data_->_tmp48_ = _data_->root;
	_data_->_tmp49_ = NULL;
	_data_->_tmp49_ = json_object_get_string_member (_data_->_tmp48_, "description");
	_data_->_tmp50_ = NULL;
	_data_->_tmp50__length1 = 0;
	_data_->_tmp50_ = _data_->_data4_->urls;
	_data_->_tmp50__length1 = _data_->_data4_->urls_length1;
	_data_->_tmp51_ = NULL;
	_data_->_tmp51_ = text_transform_transform (_data_->_tmp49_, _data_->_tmp50_, _data_->_tmp50__length1, TRANSFORM_FLAGS_EXPAND_LINKS, (guint) 0, (gint64) -1);
	_data_->_tmp52_ = NULL;
	_data_->_tmp52_ = _data_->_tmp51_;
	account_set_description (_data_->self, _data_->_tmp52_);
	_g_free0 (_data_->_tmp52_);
	_data_->_tmp53_ = NULL;
	_data_->_tmp53_ = _data_->root;
	_data_->_tmp54_ = FALSE;
	_data_->_tmp54_ = json_object_has_member (_data_->_tmp53_, "profile_banner_url");
	if (_data_->_tmp54_) {
		_data_->_tmp55_ = NULL;
		_data_->_tmp55_ = _data_->root;
		_data_->_tmp56_ = NULL;
		_data_->_tmp56_ = json_object_get_string_member (_data_->_tmp55_, "profile_banner_url");
		account_set_banner_url (_data_->self, _data_->_tmp56_);
	}
	_data_->_tmp57_ = NULL;
	_data_->_tmp57_ = _data_->root;
	_data_->_tmp58_ = NULL;
	_data_->_tmp58_ = json_object_get_object_member (_data_->_tmp57_, "entities");
	_data_->_tmp59_ = FALSE;
	_data_->_tmp59_ = json_object_has_member (_data_->_tmp58_, "url");
	if (_data_->_tmp59_) {
		_data_->_tmp60_ = NULL;
		_data_->_tmp60_ = _data_->root;
		_data_->_tmp61_ = NULL;
		_data_->_tmp61_ = json_object_get_object_member (_data_->_tmp60_, "entities");
		_data_->_tmp62_ = NULL;
		_data_->_tmp62_ = json_object_get_object_member (_data_->_tmp61_, "url");
		_data_->_tmp63_ = NULL;
		_data_->_tmp63_ = json_object_get_array_member (_data_->_tmp62_, "urls");
		_data_->_tmp64_ = NULL;
		_data_->_tmp64_ = json_array_get_object_element (_data_->_tmp63_, (guint) 0);
		_data_->_tmp65_ = NULL;
		_data_->_tmp65_ = json_object_get_string_member (_data_->_tmp64_, "expanded_url");
		account_set_website (_data_->self, _data_->_tmp65_);
	} else {
		account_set_website (_data_->self, "");
	}
	_data_->_tmp66_ = NULL;
	_data_->_tmp66_ = _data_->root;
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = json_object_get_string_member (_data_->_tmp66_, "profile_image_url");
	_data_->_tmp68_ = NULL;
	_data_->_tmp68_ = g_strdup (_data_->_tmp67_);
	_data_->avatar_url = _data_->_tmp68_;
	_data_->_tmp69_ = FALSE;
	_data_->_tmp69_ = _data_->values_changed;
	_data_->_tmp70_ = NULL;
	_data_->_tmp70_ = _data_->avatar_url;
	_data_->_state_ = 2;
	account_update_avatar (_data_->self, _data_->_tmp70_, account_query_user_info_by_screen_name_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp71_ = FALSE;
	_data_->_tmp71_ = account_update_avatar_finish (_data_->self, _data_->_res_);
	_data_->values_changed = _data_->_tmp69_ | _data_->_tmp71_;
	_data_->_tmp72_ = FALSE;
	_data_->_tmp72_ = _data_->values_changed;
	if (_data_->_tmp72_) {
		_data_->_tmp73_ = NULL;
		_data_->_tmp73_ = _data_->self->priv->_db;
		if (_data_->_tmp73_ != NULL) {
			account_save_info (_data_->self);
		}
		_data_->_tmp74_ = NULL;
		_data_->_tmp74_ = _data_->self->priv->_screen_name;
		_data_->_tmp75_ = NULL;
		_data_->_tmp75_ = _data_->self->priv->_name;
		_data_->_tmp76_ = NULL;
		_data_->_tmp76_ = _data_->self->priv->_avatar_small;
		_data_->_tmp77_ = NULL;
		_data_->_tmp77_ = _data_->self->priv->_avatar;
		g_signal_emit_by_name (_data_->self, "info-changed", _data_->_tmp74_, _data_->_tmp75_, _data_->_tmp76_, _data_->_tmp77_);
	}
	_g_free0 (_data_->avatar_url);
	_json_array_unref0 (_data_->desc_urls);
	_json_object_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	block4_data_unref (_data_->_data4_);
	_data_->_data4_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void account_init_information_data_free (gpointer _data) {
	AccountInitInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountInitInformationData, _data_);
}


void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountInitInformationData* _data_;
	Account* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AccountInitInformationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, account_init_information);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, account_init_information_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	account_init_information_co (_data_);
}


void account_init_information_finish (Account* self, GAsyncResult* _res_) {
	AccountInitInformationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Account* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda21_ (Block5Data* _data5_) {
	Account* self;
	self = _data5_->self;
	account_init_information_co (_data5_->_async_data_);
}


static void ___lambda21__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda21_ (self);
}


static void __lambda22_ (Block5Data* _data5_) {
	Account* self;
	self = _data5_->self;
	collect_emit (_data5_->collect_obj, NULL);
}


static void ___lambda22__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda22_ (self);
	block5_data_unref (self);
}


static void __lambda23_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	Account* self;
	JsonArray* arr = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonArray* _tmp1_ = NULL;
	JsonArray* _tmp2_ = NULL;
	self = _data5_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = account_load_id_array_finish (self, _tmp0_);
	arr = _tmp1_;
	_tmp2_ = arr;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_ = NULL;
		_tmp3_ = arr;
		account_set_disabled_rts (self, _tmp3_);
		collect_emit (_data5_->collect_obj, NULL);
	}
	_json_array_unref0 (arr);
}


static void ___lambda23__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda23_ (self, source_object, res);
	block5_data_unref (self);
}


static void __lambda24_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	Account* self;
	JsonArray* arr = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonArray* _tmp1_ = NULL;
	JsonArray* _tmp2_ = NULL;
	self = _data5_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = account_load_id_array_finish (self, _tmp0_);
	arr = _tmp1_;
	_tmp2_ = arr;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_ = NULL;
		_tmp3_ = arr;
		account_set_blocked (self, _tmp3_);
		collect_emit (_data5_->collect_obj, NULL);
	}
	_json_array_unref0 (arr);
}


static void ___lambda24__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda24_ (self, source_object, res);
	block5_data_unref (self);
}


static void __lambda25_ (Block5Data* _data5_, GObject* obj, GAsyncResult* res) {
	Account* self;
	JsonArray* arr = NULL;
	GAsyncResult* _tmp0_ = NULL;
	JsonArray* _tmp1_ = NULL;
	JsonArray* _tmp2_ = NULL;
	self = _data5_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = account_load_id_array_finish (self, _tmp0_);
	arr = _tmp1_;
	_tmp2_ = arr;
	if (_tmp2_ != NULL) {
		JsonArray* _tmp3_ = NULL;
		_tmp3_ = arr;
		account_set_muted (self, _tmp3_);
		collect_emit (_data5_->collect_obj, NULL);
	}
	_json_array_unref0 (arr);
}


static void ___lambda25__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda25_ (self, source_object, res);
	block5_data_unref (self);
}


static gboolean account_init_information_co (AccountInitInformationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = collect_new (4);
	_data_->_data5_->collect_obj = _data_->_tmp0_;
	g_signal_connect_data (_data_->_data5_->collect_obj, "finished", (GCallback) ___lambda21__collect_finished, block5_data_ref (_data_->_data5_), (GClosureNotify) block5_data_unref, 0);
	account_query_user_info_by_screen_name (_data_->self, NULL, ___lambda22__gasync_ready_callback, block5_data_ref (_data_->_data5_));
	account_load_id_array (_data_->self, _data_->_data5_->collect_obj, "1.1/friendships/no_retweets/ids.json", TRUE, ___lambda23__gasync_ready_callback, block5_data_ref (_data_->_data5_));
	account_load_id_array (_data_->self, _data_->_data5_->collect_obj, "1.1/blocks/ids.json", FALSE, ___lambda24__gasync_ready_callback, block5_data_ref (_data_->_data5_));
	account_load_id_array (_data_->self, _data_->_data5_->collect_obj, "1.1/mutes/users/ids.json", FALSE, ___lambda25__gasync_ready_callback, block5_data_ref (_data_->_data5_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void account_load_id_array_data_free (gpointer _data) {
	AccountLoadIdArrayData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->collect_obj);
	_g_free0 (_data_->function);
	_json_array_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountLoadIdArrayData, _data_);
}


static void account_load_id_array (Account* self, Collect* collect_obj, const gchar* function, gboolean direct, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountLoadIdArrayData* _data_;
	Account* _tmp0_ = NULL;
	Collect* _tmp1_ = NULL;
	Collect* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	_data_ = g_slice_new0 (AccountLoadIdArrayData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, account_load_id_array);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, account_load_id_array_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = collect_obj;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->collect_obj);
	_data_->collect_obj = _tmp2_;
	_tmp3_ = function;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->function);
	_data_->function = _tmp4_;
	_tmp5_ = direct;
	_data_->direct = _tmp5_;
	account_load_id_array_co (_data_);
}


static JsonArray* account_load_id_array_finish (Account* self, GAsyncResult* _res_) {
	JsonArray* result;
	AccountLoadIdArrayData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void account_load_id_array_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AccountLoadIdArrayData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	account_load_id_array_co (_data_);
}


static gboolean account_load_id_array_co (AccountLoadIdArrayData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_proxy;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->call;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->function;
	rest_proxy_call_set_function (_data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->root = NULL;
	{
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp6_, account_load_id_array_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp5_ = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp5_;
		_data_->_tmp5_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp8_;
		__vala_JsonNode_free0 (_data_->_tmp5_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_warning ("Account.vala:271: %s", _data_->_tmp10_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->collect_obj;
		collect_emit (_data_->_tmp11_, NULL);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally4:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp12_ = FALSE;
	_data_->_tmp12_ = _data_->direct;
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->root;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = json_node_get_array (_data_->_tmp13_);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _json_array_ref0 (_data_->_tmp14_);
		_data_->result = _data_->_tmp15_;
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->root;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = json_node_get_object (_data_->_tmp16_);
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = json_object_get_array_member (_data_->_tmp17_, "ids");
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _json_array_ref0 (_data_->_tmp18_);
		_data_->result = _data_->_tmp19_;
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void account_update_avatar_data_free (gpointer _data) {
	AccountUpdateAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AccountUpdateAvatarData, _data_);
}


static void account_update_avatar (Account* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AccountUpdateAvatarData* _data_;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (AccountUpdateAvatarData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, account_update_avatar);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, account_update_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = url;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->url);
	_data_->url = _tmp2_;
	account_update_avatar_co (_data_);
}


static gboolean account_update_avatar_finish (Account* self, GAsyncResult* _res_) {
	gboolean result;
	AccountUpdateAvatarData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


/**
   * Updates the account's avatar picture.
   * This means that the new avatar will be downloaded if necessary and
   * scaled appropriately.
   *
   * @param url The url of the (possibly) new avatar(optional).
   */
static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		Account* self;
		self = _data6_->self;
		_g_free0 (_data6_->big_dest);
		_g_free0 (_data6_->dest_path);
		_g_free0 (_data6_->url);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		Account* self;
		self = _data7_->_data6_->self;
		_g_object_unref0 (_data7_->msg);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}


static void ___lambda20_ (Block7Data* _data7_, SoupSession* _s, SoupMessage* _msg) {
	Block6Data* _data6_;
	Account* self;
	GMemoryInputStream* data_stream = NULL;
	SoupMessage* _tmp0_ = NULL;
	SoupMessageBody* _tmp1_ = NULL;
	guint8* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GMemoryInputStream* _tmp3_ = NULL;
	gchar* type = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp38_ = NULL;
	SqlDatabase* _tmp39_ = NULL;
	SqlUpdateStatement* _tmp40_ = NULL;
	SqlUpdateStatement* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	SqlUpdateStatement* _tmp43_ = NULL;
	SqlUpdateStatement* _tmp44_ = NULL;
	gint64 _tmp45_ = 0LL;
	SqlUpdateStatement* _tmp46_ = NULL;
	SqlUpdateStatement* _tmp47_ = NULL;
	GError * _inner_error_ = NULL;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	g_return_if_fail (SOUP_IS_SESSION (_s));
	g_return_if_fail (SOUP_IS_MESSAGE (_msg));
	_tmp0_ = _data7_->msg;
	_tmp1_ = _tmp0_->response_body;
	_tmp2_ = _tmp1_->data;
	_tmp2__length1 = _tmp1_->length;
	_tmp1_->data = NULL;
	_tmp1_->length = 0;
	_tmp3_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp2_, _tmp2__length1, NULL);
	data_stream = _tmp3_;
	_tmp4_ = _data6_->url;
	_tmp5_ = utils_get_file_type (_tmp4_);
	type = _tmp5_;
	{
		GdkPixbuf* _tmp6_ = NULL;
		GMemoryInputStream* _tmp7_ = NULL;
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GMemoryInputStream* _tmp13_ = NULL;
		gdouble scale_x = 0.0;
		GdkPixbuf* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gdouble scale_y = 0.0;
		GdkPixbuf* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		GdkPixbuf* scaled_pixbuf = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		GdkPixbuf* _tmp21_ = NULL;
		GdkPixbuf* _tmp22_ = NULL;
		GdkPixbuf* _tmp23_ = NULL;
		gdouble _tmp24_ = 0.0;
		gdouble _tmp25_ = 0.0;
		GdkPixbuf* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		GdkPixbuf* _tmp30_ = NULL;
		cairo_surface_t* _tmp31_ = NULL;
		cairo_surface_t* _tmp32_ = NULL;
		GdkPixbuf* _tmp33_ = NULL;
		cairo_surface_t* _tmp34_ = NULL;
		cairo_surface_t* _tmp35_ = NULL;
		_tmp7_ = data_stream;
		_tmp8_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, G_TYPE_INPUT_STREAM, GInputStream), NULL, &_inner_error_);
		_tmp6_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp9_;
		_tmp10_ = pixbuf;
		_tmp11_ = _data6_->big_dest;
		_tmp12_ = type;
		gdk_pixbuf_save (_tmp10_, _tmp11_, _tmp12_, &_inner_error_, NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch5_g_error;
		}
		_tmp13_ = data_stream;
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, G_TYPE_INPUT_STREAM, GInputStream), NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp6_);
			goto __catch5_g_error;
		}
		_tmp14_ = pixbuf;
		_tmp15_ = gdk_pixbuf_get_width (_tmp14_);
		scale_x = 24.0 / _tmp15_;
		_tmp16_ = pixbuf;
		_tmp17_ = gdk_pixbuf_get_height (_tmp16_);
		scale_y = 24.0 / _tmp17_;
		_tmp18_ = pixbuf;
		_tmp19_ = gdk_pixbuf_get_has_alpha (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, _tmp20_, 8, 24, 24);
		scaled_pixbuf = _tmp21_;
		_tmp22_ = pixbuf;
		_tmp23_ = scaled_pixbuf;
		_tmp24_ = scale_x;
		_tmp25_ = scale_y;
		gdk_pixbuf_scale (_tmp22_, _tmp23_, 0, 0, 24, 24, (gdouble) 0, (gdouble) 0, _tmp24_, _tmp25_, GDK_INTERP_HYPER);
		_tmp26_ = scaled_pixbuf;
		_tmp27_ = _data6_->dest_path;
		_tmp28_ = type;
		gdk_pixbuf_save (_tmp26_, _tmp27_, _tmp28_, &_inner_error_, NULL);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (scaled_pixbuf);
			_g_object_unref0 (_tmp6_);
			goto __catch5_g_error;
		}
		_tmp29_ = _data6_->dest_path;
		g_debug ("Account.vala:319: saving to %s", _tmp29_);
		_tmp30_ = scaled_pixbuf;
		_tmp31_ = gdk_cairo_surface_create_from_pixbuf (_tmp30_, 1, NULL);
		_tmp32_ = _tmp31_;
		account_set_avatar_small (self, _tmp32_);
		_cairo_surface_destroy0 (_tmp32_);
		_tmp33_ = pixbuf;
		_tmp34_ = gdk_cairo_surface_create_from_pixbuf (_tmp33_, 1, NULL);
		_tmp35_ = _tmp34_;
		account_set_avatar (self, _tmp35_);
		_cairo_surface_destroy0 (_tmp35_);
		_g_object_unref0 (scaled_pixbuf);
		_g_object_unref0 (_tmp6_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_critical ("Account.vala:323: %s", _tmp37_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pixbuf);
		_g_free0 (type);
		_g_object_unref0 (data_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp38_ = _data6_->url;
	account_set_avatar_url (self, _tmp38_);
	_tmp39_ = corebird_db;
	_tmp40_ = sql_database_update (_tmp39_, "accounts");
	_tmp41_ = _tmp40_;
	_tmp42_ = _data6_->url;
	_tmp43_ = sql_update_statement_val (_tmp41_, "avatar_url", _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = self->priv->_id;
	_tmp46_ = sql_update_statement_where_eqi (_tmp44_, "id", _tmp45_);
	_tmp47_ = _tmp46_;
	sql_update_statement_run (_tmp47_);
	_sql_update_statement_unref0 (_tmp47_);
	_sql_update_statement_unref0 (_tmp44_);
	_sql_update_statement_unref0 (_tmp41_);
	account_update_avatar_co (_data6_->_async_data_);
	_g_object_unref0 (pixbuf);
	_g_free0 (type);
	_g_object_unref0 (data_stream);
}


static void ____lambda20__soup_session_callback (SoupSession* session, SoupMessage* msg, gpointer self) {
	___lambda20_ (self, session, msg);
	block7_data_unref (self);
}


static gboolean account_update_avatar_co (AccountUpdateAvatarData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->url;
	_g_free0 (_data_->_data6_->url);
	_data_->_data6_->url = _data_->_tmp0_;
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp1_ = 0LL;
	_data_->_tmp1_ = _data_->self->priv->_id;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strconcat ("accounts/", _data_->_tmp3_, "_small.png", NULL);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = dirs_config (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_g_free0 (_data_->_tmp3_);
	_data_->_data6_->dest_path = _data_->_tmp7_;
	_data_->_tmp8_ = 0LL;
	_data_->_tmp8_ = _data_->self->priv->_id;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strconcat ("accounts/", _data_->_tmp10_, ".png", NULL);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = dirs_config (_data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	_g_free0 (_data_->_tmp12_);
	_g_free0 (_data_->_tmp10_);
	_data_->_data6_->big_dest = _data_->_tmp14_;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_data6_->url;
	_data_->_tmp17_ = 0;
	_data_->_tmp17_ = strlen (_data_->_tmp16_);
	_data_->_tmp18_ = 0;
	_data_->_tmp18_ = _data_->_tmp17_;
	if (_data_->_tmp18_ > 0) {
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_data6_->url;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->self->priv->_avatar_url;
		_data_->_tmp15_ = g_strcmp0 (_data_->_tmp19_, _data_->_tmp20_) == 0;
	} else {
		_data_->_tmp15_ = FALSE;
	}
	if (_data_->_tmp15_) {
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_data6_->dest_path;
		_data_->_tmp23_ = FALSE;
		_data_->_tmp23_ = g_file_test (_data_->_tmp22_, G_FILE_TEST_EXISTS);
		if (_data_->_tmp23_) {
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->_data6_->big_dest;
			_data_->_tmp25_ = FALSE;
			_data_->_tmp25_ = g_file_test (_data_->_tmp24_, G_FILE_TEST_EXISTS);
			_data_->_tmp21_ = _data_->_tmp25_;
		} else {
			_data_->_tmp21_ = FALSE;
		}
		if (_data_->_tmp21_) {
			_data_->result = FALSE;
			block6_data_unref (_data_->_data6_);
			_data_->_data6_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = _data_->_data6_->url;
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->self->priv->_avatar_url;
	g_debug ("Account.vala:301: Using %s to update the avatar(old: %s)", _data_->_tmp26_, _data_->_tmp27_);
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->_data6_->url;
	_data_->_tmp29_ = 0;
	_data_->_tmp29_ = strlen (_data_->_tmp28_);
	_data_->_tmp30_ = 0;
	_data_->_tmp30_ = _data_->_tmp29_;
	if (_data_->_tmp30_ > 0) {
		_data_->_data7_ = g_slice_new0 (Block7Data);
		_data_->_data7_->_ref_count_ = 1;
		_data_->_data7_->_data6_ = block6_data_ref (_data_->_data6_);
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->_data6_->url;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = soup_message_new ("GET", _data_->_tmp31_);
		_data_->_data7_->msg = _data_->_tmp32_;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = SOUP_SESSION;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_data7_->msg;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _g_object_ref0 (_data_->_tmp34_);
		soup_session_queue_message (_data_->_tmp33_, _data_->_tmp35_, ____lambda20__soup_session_callback, block7_data_ref (_data_->_data7_));
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->result = TRUE;
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
		block6_data_unref (_data_->_data6_);
		_data_->_data6_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("Account.vala:332: Not implemented yet");
	}
	_data_->result = FALSE;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Saves the account info both in the account's database and in the
   * global one.
   */
void account_save_info (Account* self) {
	SqlDatabase* _tmp0_ = NULL;
	SqlInsertStatement* _tmp1_ = NULL;
	SqlInsertStatement* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	SqlInsertStatement* _tmp4_ = NULL;
	SqlInsertStatement* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	SqlInsertStatement* _tmp7_ = NULL;
	SqlInsertStatement* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	SqlInsertStatement* _tmp10_ = NULL;
	SqlInsertStatement* _tmp11_ = NULL;
	SqlDatabase* _tmp12_ = NULL;
	SqlInsertStatement* _tmp13_ = NULL;
	SqlInsertStatement* _tmp14_ = NULL;
	gint64 _tmp15_ = 0LL;
	SqlInsertStatement* _tmp16_ = NULL;
	SqlInsertStatement* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	SqlInsertStatement* _tmp19_ = NULL;
	SqlInsertStatement* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	SqlInsertStatement* _tmp22_ = NULL;
	SqlInsertStatement* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	SqlInsertStatement* _tmp25_ = NULL;
	SqlInsertStatement* _tmp26_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->priv->_db;
	_tmp1_ = sql_database_replace (_tmp0_, "info");
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_id;
	_tmp4_ = sql_insert_statement_vali64 (_tmp2_, "id", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_screen_name;
	_tmp7_ = sql_insert_statement_val (_tmp5_, "screen_name", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_name;
	_tmp10_ = sql_insert_statement_val (_tmp8_, "name", _tmp9_);
	_tmp11_ = _tmp10_;
	sql_insert_statement_run (_tmp11_);
	_sql_insert_statement_unref0 (_tmp11_);
	_sql_insert_statement_unref0 (_tmp8_);
	_sql_insert_statement_unref0 (_tmp5_);
	_sql_insert_statement_unref0 (_tmp2_);
	_tmp12_ = corebird_db;
	_tmp13_ = sql_database_replace (_tmp12_, "accounts");
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_id;
	_tmp16_ = sql_insert_statement_vali64 (_tmp14_, "id", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_screen_name;
	_tmp19_ = sql_insert_statement_val (_tmp17_, "screen_name", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->_name;
	_tmp22_ = sql_insert_statement_val (_tmp20_, "name", _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->_avatar_url;
	_tmp25_ = sql_insert_statement_val (_tmp23_, "avatar_url", _tmp24_);
	_tmp26_ = _tmp25_;
	sql_insert_statement_run (_tmp26_);
	_sql_insert_statement_unref0 (_tmp26_);
	_sql_insert_statement_unref0 (_tmp23_);
	_sql_insert_statement_unref0 (_tmp20_);
	_sql_insert_statement_unref0 (_tmp17_);
	_sql_insert_statement_unref0 (_tmp14_);
}


/**
   * Load all the filters from the database.
   */
static gboolean __lambda15_ (Account* self, gchar** cols, int cols_length1) {
	gboolean result = FALSE;
	Filter* f = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	Filter* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GeeArrayList* _tmp6_ = NULL;
	_tmp0_ = cols;
	_tmp0__length1 = cols_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = filter_new (_tmp1_);
	f = _tmp2_;
	_tmp3_ = cols;
	_tmp3__length1 = cols_length1;
	_tmp4_ = _tmp3_[1];
	_tmp5_ = atoi (_tmp4_);
	filter_set_id (f, _tmp5_);
	_tmp6_ = self->filters;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), f);
	result = TRUE;
	_g_object_unref0 (f);
	return result;
}


static gboolean ___lambda15__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda15_ ((Account*) self, vals, vals_length1);
	return result;
}


static void account_load_filters (Account* self) {
	SqlDatabase* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	SqlSelectStatement* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->priv->_db;
	_tmp1_ = sql_database_select (_tmp0_, "filters");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_select_statement_cols (_tmp2_, "content", "id", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = sql_select_statement_order (_tmp4_, "id");
	_tmp6_ = _tmp5_;
	sql_select_statement_run (_tmp6_, ___lambda15__sql_select_callback, self);
	_sql_select_statement_unref0 (_tmp6_);
	_sql_select_statement_unref0 (_tmp4_);
	_sql_select_statement_unref0 (_tmp2_);
}


void account_add_filter (Account* self, Filter* f) {
	GeeArrayList* _tmp0_ = NULL;
	Filter* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (IS_FILTER (f));
	_tmp0_ = self->filters;
	_tmp1_ = f;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp1_);
	_g_object_unref0 (f);
}


/**
   * Checks if any of the filters associated to this acount match
   * the given tweet.
   *
   * @param t The tweet to check for
   *
   * @return true iff at least one of the filters match, false otherwise.
   */
gboolean account_filter_matches (Account* self, Tweet* t) {
	gboolean result = FALSE;
	Tweet* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	UserIdentity _tmp2_ = {0};
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	g_return_val_if_fail (IS_TWEET (t), FALSE);
	_tmp0_ = t;
	_tmp1_ = _tmp0_->source_tweet;
	_tmp2_ = _tmp1_->author;
	_tmp3_ = _tmp2_.id;
	_tmp4_ = self->priv->_id;
	if (_tmp3_ == _tmp4_) {
		result = FALSE;
		return result;
	}
	{
		GeeArrayList* _f_list = NULL;
		GeeArrayList* _tmp5_ = NULL;
		GeeArrayList* _tmp6_ = NULL;
		gint _f_size = 0;
		GeeArrayList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _f_index = 0;
		_tmp5_ = self->filters;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_f_list = _tmp6_;
		_tmp7_ = _f_list;
		_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp9_ = _tmp8_;
		_f_size = _tmp9_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			Filter* f = NULL;
			GeeArrayList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			Filter* _tmp16_ = NULL;
			Tweet* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			_tmp10_ = _f_index;
			_f_index = _tmp10_ + 1;
			_tmp11_ = _f_index;
			_tmp12_ = _f_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _f_list;
			_tmp14_ = _f_index;
			_tmp15_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp14_);
			f = (Filter*) _tmp15_;
			_tmp16_ = f;
			_tmp17_ = t;
			_tmp18_ = tweet_get_real_text (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = filter_matches (_tmp16_, _tmp19_);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			if (_tmp21_) {
				result = TRUE;
				_g_object_unref0 (f);
				_g_object_unref0 (_f_list);
				return result;
			}
			_g_object_unref0 (f);
		}
		_g_object_unref0 (_f_list);
	}
	result = FALSE;
	return result;
}


void account_set_friends (Account* self, JsonArray* friends_array) {
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint64* _tmp2_ = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (friends_array != NULL);
	_tmp0_ = friends_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->friends = (g_free (self->friends), NULL);
	self->friends = _tmp2_;
	self->friends_length1 = _tmp1_;
	_tmp3_ = self->friends;
	_tmp3__length1 = self->friends_length1;
	g_debug ("Account.vala:394: Adding %d friends...", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				JsonArray* _tmp7_ = NULL;
				guint _tmp8_ = 0U;
				gint64* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				JsonArray* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gint64 _tmp13_ = 0LL;
				gint64 _tmp14_ = 0LL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = friends_array;
				_tmp8_ = json_array_get_length (_tmp7_);
				if (!(((guint) _tmp6_) < _tmp8_)) {
					break;
				}
				_tmp9_ = self->friends;
				_tmp9__length1 = self->friends_length1;
				_tmp10_ = i;
				_tmp11_ = friends_array;
				_tmp12_ = i;
				_tmp13_ = json_array_get_int_element (_tmp11_, (guint) _tmp12_);
				_tmp9_[_tmp10_] = _tmp13_;
				_tmp14_ = _tmp9_[_tmp10_];
			}
		}
	}
}


gboolean account_follows_id (Account* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	_tmp0_ = self->friends;
	_tmp0__length1 = self->friends_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp1_ = 0LL;
				gint64 _tmp2_ = 0LL;
				_tmp1_ = id;
				_tmp2_ = user_id;
				if (_tmp1_ == _tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


void account_follow_id (Account* self, gint64 user_id) {
	gint64* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint64* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->friends;
	_tmp0__length1 = self->friends_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->friends = g_renew (gint64, self->friends, _tmp0__length1 + 1);
	(_tmp1_ > self->friends_length1) ? memset (self->friends + self->friends_length1, 0, sizeof (gint64) * (_tmp1_ - self->friends_length1)) : NULL;
	self->friends_length1 = _tmp1_;
	_tmp2_ = self->friends;
	_tmp2__length1 = self->friends_length1;
	_tmp3_ = self->friends;
	_tmp3__length1 = self->friends_length1;
	_tmp4_ = user_id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup1 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_unfollow_id (Account* self, gint64 user_id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint64* new_friends = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64* _tmp4_ = NULL;
	gint new_friends_length1 = 0;
	gint _new_friends_size_ = 0;
	gint o = 0;
	gboolean found = FALSE;
	gboolean _tmp20_ = FALSE;
	gint64* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint64* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->friends;
	_tmp1__length1 = self->friends_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->friends;
		_tmp2__length1 = self->friends_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:415: friends == null");
		return;
	}
	_tmp3_ = self->friends;
	_tmp3__length1 = self->friends_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1);
	new_friends = _tmp4_;
	new_friends_length1 = _tmp3__length1;
	_new_friends_size_ = new_friends_length1;
	o = 0;
	found = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint64* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gint64* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gint64* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				gint _tmp19_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->friends;
				_tmp8__length1 = self->friends_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->friends;
				_tmp9__length1 = self->friends_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = user_id;
				if (_tmp11_ == _tmp12_) {
					found = TRUE;
					continue;
				}
				_tmp13_ = new_friends;
				_tmp13__length1 = new_friends_length1;
				_tmp14_ = o;
				_tmp15_ = self->friends;
				_tmp15__length1 = self->friends_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = found;
	if (_tmp20_) {
		gint64* _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		gint _tmp22_ = 0;
		_tmp21_ = new_friends;
		_tmp21__length1 = new_friends_length1;
		_tmp22_ = _tmp21__length1 - 1;
		new_friends = g_renew (gint64, new_friends, _tmp21__length1 - 1);
		(_tmp22_ > new_friends_length1) ? memset (new_friends + new_friends_length1, 0, sizeof (gint64) * (_tmp22_ - new_friends_length1)) : NULL;
		new_friends_length1 = _tmp22_;
		_new_friends_size_ = _tmp22_;
	}
	_tmp23_ = new_friends;
	_tmp23__length1 = new_friends_length1;
	_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup1 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
	_tmp24__length1 = _tmp23__length1;
	self->friends = (g_free (self->friends), NULL);
	self->friends = _tmp24_;
	self->friends_length1 = _tmp24__length1;
	new_friends = (g_free (new_friends), NULL);
}


void account_set_muted (Account* self, JsonArray* muted_array) {
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint64* _tmp2_ = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (muted_array != NULL);
	_tmp0_ = muted_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->muted = (g_free (self->muted), NULL);
	self->muted = _tmp2_;
	self->muted_length1 = _tmp1_;
	_tmp3_ = self->muted;
	_tmp3__length1 = self->muted_length1;
	g_debug ("Account.vala:438: Add %d muted ids", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint64* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				JsonArray* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->muted;
				_tmp7__length1 = self->muted_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->muted;
				_tmp8__length1 = self->muted_length1;
				_tmp9_ = i;
				_tmp10_ = muted_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_int_element (_tmp10_, (guint) _tmp11_);
				_tmp8_[_tmp9_] = _tmp12_;
				_tmp13_ = _tmp8_[_tmp9_];
			}
		}
	}
}


void account_mute_id (Account* self, gint64 id) {
	gint64* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint64* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->muted;
	_tmp0__length1 = self->muted_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->muted = g_renew (gint64, self->muted, _tmp0__length1 + 1);
	(_tmp1_ > self->muted_length1) ? memset (self->muted + self->muted_length1, 0, sizeof (gint64) * (_tmp1_ - self->muted_length1)) : NULL;
	self->muted_length1 = _tmp1_;
	_tmp2_ = self->muted;
	_tmp2__length1 = self->muted_length1;
	_tmp3_ = self->muted;
	_tmp3__length1 = self->muted_length1;
	_tmp4_ = id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup2 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_unmute_id (Account* self, gint64 id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint64* new_muted = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64* _tmp4_ = NULL;
	gint new_muted_length1 = 0;
	gint _new_muted_size_ = 0;
	gint o = 0;
	gint64* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint64* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->muted;
	_tmp1__length1 = self->muted_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->muted;
		_tmp2__length1 = self->muted_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:451: muted == null");
		return;
	}
	_tmp3_ = self->muted;
	_tmp3__length1 = self->muted_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1 - 1);
	new_muted = _tmp4_;
	new_muted_length1 = _tmp3__length1 - 1;
	_new_muted_size_ = new_muted_length1;
	o = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint64* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gint64* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gint64* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				gint _tmp19_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->muted;
				_tmp8__length1 = self->muted_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->muted;
				_tmp9__length1 = self->muted_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = id;
				if (_tmp11_ == _tmp12_) {
					continue;
				}
				_tmp13_ = self->muted;
				_tmp13__length1 = self->muted_length1;
				_tmp14_ = o;
				_tmp15_ = self->muted;
				_tmp15__length1 = self->muted_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = new_muted;
	_tmp20__length1 = new_muted_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup2 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	self->muted = (g_free (self->muted), NULL);
	self->muted = _tmp21_;
	self->muted_length1 = _tmp21__length1;
	new_muted = (g_free (new_muted), NULL);
}


void account_set_blocked (Account* self, JsonArray* blocked_array) {
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint64* _tmp2_ = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (blocked_array != NULL);
	_tmp0_ = blocked_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->blocked = (g_free (self->blocked), NULL);
	self->blocked = _tmp2_;
	self->blocked_length1 = _tmp1_;
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	g_debug ("Account.vala:469: Add %d blocked ids", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint64* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				JsonArray* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->blocked;
				_tmp7__length1 = self->blocked_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->blocked;
				_tmp8__length1 = self->blocked_length1;
				_tmp9_ = i;
				_tmp10_ = blocked_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_int_element (_tmp10_, (guint) _tmp11_);
				_tmp8_[_tmp9_] = _tmp12_;
				_tmp13_ = _tmp8_[_tmp9_];
			}
		}
	}
}


void account_block_id (Account* self, gint64 id) {
	gint64* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint64* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->blocked;
	_tmp0__length1 = self->blocked_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->blocked = g_renew (gint64, self->blocked, _tmp0__length1 + 1);
	(_tmp1_ > self->blocked_length1) ? memset (self->blocked + self->blocked_length1, 0, sizeof (gint64) * (_tmp1_ - self->blocked_length1)) : NULL;
	self->blocked_length1 = _tmp1_;
	_tmp2_ = self->blocked;
	_tmp2__length1 = self->blocked_length1;
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	_tmp4_ = id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup3 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_unblock_id (Account* self, gint64 id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint64* new_blocked = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64* _tmp4_ = NULL;
	gint new_blocked_length1 = 0;
	gint _new_blocked_size_ = 0;
	gint o = 0;
	gint64* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint64* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->blocked;
	_tmp1__length1 = self->blocked_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->blocked;
		_tmp2__length1 = self->blocked_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:482: blocked == null");
		return;
	}
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1 - 1);
	new_blocked = _tmp4_;
	new_blocked_length1 = _tmp3__length1 - 1;
	_new_blocked_size_ = new_blocked_length1;
	o = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint64* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gint64* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gint64* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				gint _tmp19_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->blocked;
				_tmp8__length1 = self->blocked_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->blocked;
				_tmp9__length1 = self->blocked_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = id;
				if (_tmp11_ == _tmp12_) {
					continue;
				}
				_tmp13_ = self->blocked;
				_tmp13__length1 = self->blocked_length1;
				_tmp14_ = o;
				_tmp15_ = self->blocked;
				_tmp15__length1 = self->blocked_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = new_blocked;
	_tmp20__length1 = new_blocked_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup3 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	self->blocked = (g_free (self->blocked), NULL);
	self->blocked = _tmp21_;
	self->blocked_length1 = _tmp21__length1;
	new_blocked = (g_free (new_blocked), NULL);
}


void account_set_disabled_rts (Account* self, JsonArray* disabled_rts_array) {
	JsonArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gint64* _tmp2_ = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	g_return_if_fail (disabled_rts_array != NULL);
	_tmp0_ = disabled_rts_array;
	_tmp1_ = json_array_get_length (_tmp0_);
	_tmp2_ = g_new0 (gint64, _tmp1_);
	self->disabled_rts = (g_free (self->disabled_rts), NULL);
	self->disabled_rts = _tmp2_;
	self->disabled_rts_length1 = _tmp1_;
	_tmp3_ = self->disabled_rts;
	_tmp3__length1 = self->disabled_rts_length1;
	g_debug ("Account.vala:500: Add %d disabled_rts ids", _tmp3__length1);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint64* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				JsonArray* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->disabled_rts;
				_tmp7__length1 = self->disabled_rts_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = self->disabled_rts;
				_tmp8__length1 = self->disabled_rts_length1;
				_tmp9_ = i;
				_tmp10_ = disabled_rts_array;
				_tmp11_ = i;
				_tmp12_ = json_array_get_int_element (_tmp10_, (guint) _tmp11_);
				_tmp8_[_tmp9_] = _tmp12_;
				_tmp13_ = _tmp8_[_tmp9_];
			}
		}
	}
}


void account_add_disabled_rts_id (Account* self, gint64 user_id) {
	gint64* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	gint64* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = self->disabled_rts;
	_tmp0__length1 = self->disabled_rts_length1;
	_tmp1_ = _tmp0__length1 + 1;
	self->disabled_rts = g_renew (gint64, self->disabled_rts, _tmp0__length1 + 1);
	(_tmp1_ > self->disabled_rts_length1) ? memset (self->disabled_rts + self->disabled_rts_length1, 0, sizeof (gint64) * (_tmp1_ - self->disabled_rts_length1)) : NULL;
	self->disabled_rts_length1 = _tmp1_;
	_tmp2_ = self->disabled_rts;
	_tmp2__length1 = self->disabled_rts_length1;
	_tmp3_ = self->disabled_rts;
	_tmp3__length1 = self->disabled_rts_length1;
	_tmp4_ = self->priv->_id;
	_tmp2_[_tmp3__length1 - 1] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3__length1 - 1];
}


static gint64* _vala_array_dup4 (gint64* self, int length) {
	return g_memdup (self, length * sizeof (gint64));
}


void account_remove_disabled_rts_id (Account* self, gint64 user_id) {
	gboolean _tmp0_ = FALSE;
	gint64* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint64* new_disabled_rts = NULL;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint64* _tmp4_ = NULL;
	gint new_disabled_rts_length1 = 0;
	gint _new_disabled_rts_size_ = 0;
	gint o = 0;
	gint64* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint64* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp1_ = self->disabled_rts;
	_tmp1__length1 = self->disabled_rts_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->disabled_rts;
		_tmp2__length1 = self->disabled_rts_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		g_warning ("Account.vala:513: disabled_rts == null");
		return;
	}
	_tmp3_ = self->disabled_rts;
	_tmp3__length1 = self->disabled_rts_length1;
	_tmp4_ = g_new0 (gint64, _tmp3__length1 - 1);
	new_disabled_rts = _tmp4_;
	new_disabled_rts_length1 = _tmp3__length1 - 1;
	_new_disabled_rts_size_ = new_disabled_rts_length1;
	o = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint64* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint64* _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gint64* _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				gint64* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				gint _tmp19_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->disabled_rts;
				_tmp8__length1 = self->disabled_rts_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = self->disabled_rts;
				_tmp9__length1 = self->disabled_rts_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = self->priv->_id;
				if (_tmp11_ == _tmp12_) {
					continue;
				}
				_tmp13_ = self->disabled_rts;
				_tmp13__length1 = self->disabled_rts_length1;
				_tmp14_ = o;
				_tmp15_ = self->disabled_rts;
				_tmp15__length1 = self->disabled_rts_length1;
				_tmp16_ = i;
				_tmp17_ = _tmp15_[_tmp16_];
				_tmp13_[_tmp14_] = _tmp17_;
				_tmp18_ = _tmp13_[_tmp14_];
				_tmp19_ = o;
				o = _tmp19_ + 1;
			}
		}
	}
	_tmp20_ = new_disabled_rts;
	_tmp20__length1 = new_disabled_rts_length1;
	_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup4 (_tmp20_, _tmp20__length1) : ((gpointer) _tmp20_);
	_tmp21__length1 = _tmp20__length1;
	self->disabled_rts = (g_free (self->disabled_rts), NULL);
	self->disabled_rts = _tmp21_;
	self->disabled_rts_length1 = _tmp21__length1;
	new_disabled_rts = (g_free (new_disabled_rts), NULL);
}


gboolean account_blocked_or_muted (Account* self, gint64 user_id) {
	gboolean result = FALSE;
	gint64* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint64* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (IS_ACCOUNT (self), FALSE);
	_tmp0_ = self->muted;
	_tmp0__length1 = self->muted_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp0_;
		id_collection_length1 = _tmp0__length1;
		for (id_it = 0; id_it < _tmp0__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp1_ = 0LL;
				gint64 _tmp2_ = 0LL;
				_tmp1_ = id;
				_tmp2_ = user_id;
				if (_tmp1_ == _tmp2_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	_tmp3_ = self->blocked;
	_tmp3__length1 = self->blocked_length1;
	{
		gint64* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp3_;
		id_collection_length1 = _tmp3__length1;
		for (id_it = 0; id_it < _tmp3__length1; id_it = id_it + 1) {
			gint64 id = 0LL;
			id = id_collection[id_it];
			{
				gint64 _tmp4_ = 0LL;
				gint64 _tmp5_ = 0LL;
				_tmp4_ = id;
				_tmp5_ = user_id;
				if (_tmp4_ == _tmp5_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


/**
   * Simply returns a list of user-specified accounts.
   * The list is lazily loaded from the database
   *
   * @return A singly-linked list of accounts
   */
GSList* account_list_accounts (void) {
	GSList* result = NULL;
	GSList* _tmp0_ = NULL;
	GSList* _tmp1_ = NULL;
	_tmp0_ = account_accounts;
	if (_tmp0_ == NULL) {
		account_lookup_accounts ();
	}
	_tmp1_ = account_accounts;
	result = _tmp1_;
	return result;
}


/**
   * Look up the accounts. Each account has a <id>.db in ~/.corebird/accounts/
   * The accounts are initialized with only their screen_name and their ID.
   */
static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda41_ (gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	Account* acc = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	const gchar* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = int64_parse (_tmp1_);
	_tmp3_ = vals;
	_tmp3__length1 = vals_length1;
	_tmp4_ = _tmp3_[1];
	_tmp5_ = vals;
	_tmp5__length1 = vals_length1;
	_tmp6_ = _tmp5_[2];
	_tmp7_ = account_new (_tmp2_, _tmp4_, _tmp6_);
	acc = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[3];
	account_set_avatar_url (acc, _tmp9_);
	account_load_avatar (acc);
	_tmp10_ = _g_object_ref0 (acc);
	account_accounts = g_slist_append (account_accounts, _tmp10_);
	result = TRUE;
	_g_object_unref0 (acc);
	return result;
}


static gboolean ___lambda41__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda41_ (vals, vals_length1);
	return result;
}


static void account_lookup_accounts (void) {
	SqlDatabase* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	SqlSelectStatement* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	__g_slist_free__g_object_unref0_0 (account_accounts);
	account_accounts = NULL;
	_tmp0_ = corebird_db;
	_tmp1_ = sql_database_select (_tmp0_, "accounts");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_select_statement_cols (_tmp2_, "id", "screen_name", "name", "avatar_url", NULL);
	_tmp4_ = _tmp3_;
	sql_select_statement_run (_tmp4_, ___lambda41__sql_select_callback, NULL);
	_sql_select_statement_unref0 (_tmp4_);
	_sql_select_statement_unref0 (_tmp2_);
}


/**
   * Adds the given account to the end of the current account list.
   *
   * @param acc The account to add.
   */
void account_add_account (Account* acc) {
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = acc;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	account_accounts = g_slist_append (account_accounts, _tmp1_);
}


/**
   * Removes the acccunt with th given screen name from the account list.
   *
   * @param screen_name The screen name of the account to remove.
   */
void account_remove_account (const gchar* screen_name) {
	GSList* _tmp0_ = NULL;
	g_return_if_fail (screen_name != NULL);
	_tmp0_ = account_accounts;
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			Account* _tmp1_ = NULL;
			Account* a = NULL;
			_tmp1_ = _g_object_ref0 ((Account*) a_it->data);
			a = _tmp1_;
			{
				Account* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				_tmp2_ = a;
				_tmp3_ = _tmp2_->priv->_screen_name;
				_tmp4_ = screen_name;
				if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
					Account* _tmp5_ = NULL;
					_tmp5_ = a;
					account_accounts = g_slist_remove (account_accounts, _tmp5_);
					_g_object_unref0 (a);
					return;
				}
				_g_object_unref0 (a);
			}
		}
	}
}


/**
   * Returns an unowned reference to the account with the given screen name.
   *
   * @param screen_name The screen name of the account to return
   * @return An unowned reference to the account object with the given screen name or
   *         null of no such instance could be found.
   */
Account* account_query_account (const gchar* screen_name) {
	Account* result = NULL;
	GSList* _tmp0_ = NULL;
	g_return_val_if_fail (screen_name != NULL, NULL);
	_tmp0_ = account_accounts;
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			Account* a = NULL;
			a = (Account*) a_it->data;
			{
				const gchar* _tmp1_ = NULL;
				Account* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				_tmp1_ = screen_name;
				_tmp2_ = a;
				_tmp3_ = _tmp2_->priv->_screen_name;
				if (g_strcmp0 (_tmp1_, _tmp3_) == 0) {
					Account* _tmp4_ = NULL;
					_tmp4_ = a;
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


Account* account_query_account_by_id (gint64 id) {
	Account* result = NULL;
	GSList* _tmp0_ = NULL;
	_tmp0_ = account_accounts;
	{
		GSList* a_collection = NULL;
		GSList* a_it = NULL;
		a_collection = _tmp0_;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			Account* a = NULL;
			a = (Account*) a_it->data;
			{
				gint64 _tmp1_ = 0LL;
				Account* _tmp2_ = NULL;
				gint64 _tmp3_ = 0LL;
				_tmp1_ = id;
				_tmp2_ = a;
				_tmp3_ = _tmp2_->priv->_id;
				if (_tmp1_ == _tmp3_) {
					Account* _tmp4_ = NULL;
					_tmp4_ = a;
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


gint64 account_get_id (Account* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_ACCOUNT (self), 0LL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void account_set_id (Account* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


SqlDatabase* account_get_db (Account* self) {
	SqlDatabase* result;
	SqlDatabase* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_db;
	result = _tmp0_;
	return result;
}


static gpointer _sql_database_ref0 (gpointer self) {
	return self ? sql_database_ref (self) : NULL;
}


static void account_set_db (Account* self, SqlDatabase* value) {
	SqlDatabase* _tmp0_ = NULL;
	SqlDatabase* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = _sql_database_ref0 (_tmp0_);
	_sql_database_unref0 (self->priv->_db);
	self->priv->_db = _tmp1_;
	g_object_notify ((GObject *) self, "db");
}


const gchar* account_get_screen_name (Account* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_screen_name;
	result = _tmp0_;
	return result;
}


void account_set_screen_name (Account* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_screen_name);
	self->priv->_screen_name = _tmp1_;
	g_object_notify ((GObject *) self, "screen-name");
}


const gchar* account_get_name (Account* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void account_set_name (Account* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* account_get_avatar_url (Account* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_avatar_url;
	result = _tmp0_;
	return result;
}


void account_set_avatar_url (Account* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_avatar_url);
	self->priv->_avatar_url = _tmp1_;
	g_object_notify ((GObject *) self, "avatar-url");
}


const gchar* account_get_banner_url (Account* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_banner_url;
	result = _tmp0_;
	return result;
}


static void account_set_banner_url (Account* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_banner_url);
	self->priv->_banner_url = _tmp1_;
	g_object_notify ((GObject *) self, "banner-url");
}


const gchar* account_get_website (Account* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_website;
	result = _tmp0_;
	return result;
}


void account_set_website (Account* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_website);
	self->priv->_website = _tmp1_;
	g_object_notify ((GObject *) self, "website");
}


const gchar* account_get_description (Account* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


void account_set_description (Account* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


cairo_surface_t* account_get_avatar_small (Account* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_avatar_small;
	result = _tmp0_;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static void account_set_avatar_small (Account* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->_avatar_small);
	self->priv->_avatar_small = _tmp1_;
	g_object_notify ((GObject *) self, "avatar-small");
}


cairo_surface_t* account_get_avatar (Account* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void account_set_avatar (Account* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->_avatar);
	self->priv->_avatar = _tmp1_;
	g_object_notify ((GObject *) self, "avatar");
}


OAuthProxy* account_get_proxy (Account* self) {
	OAuthProxy* result;
	OAuthProxy* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_proxy;
	result = _tmp0_;
	return result;
}


static void account_set_proxy (Account* self, OAuthProxy* value) {
	OAuthProxy* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_proxy);
	self->priv->_proxy = _tmp1_;
	g_object_notify ((GObject *) self, "proxy");
}


UserStream* account_get_user_stream (Account* self) {
	UserStream* result;
	UserStream* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_user_stream;
	result = _tmp0_;
	return result;
}


static void account_set_user_stream (Account* self, UserStream* value) {
	UserStream* _tmp0_ = NULL;
	UserStream* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_user_stream);
	self->priv->_user_stream = _tmp1_;
	g_object_notify ((GObject *) self, "user-stream");
}


UserCounter* account_get_user_counter (Account* self) {
	UserCounter* result;
	UserCounter* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (self), NULL);
	_tmp0_ = self->priv->_user_counter;
	result = _tmp0_;
	return result;
}


static void account_set_user_counter (Account* self, UserCounter* value) {
	UserCounter* _tmp0_ = NULL;
	UserCounter* _tmp1_ = NULL;
	g_return_if_fail (IS_ACCOUNT (self));
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_user_counter);
	self->priv->_user_counter = _tmp1_;
	g_object_notify ((GObject *) self, "user-counter");
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gpointer arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_pointer (param_values + 4), data2);
}


static void account_class_init (AccountClass * klass) {
	account_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_account_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_account_set_property;
	G_OBJECT_CLASS (klass)->finalize = account_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_ID, g_param_spec_int64 ("id", "id", "id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_DB, sql_param_spec_database ("db", "db", "db", SQL_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_SCREEN_NAME, g_param_spec_string ("screen-name", "screen-name", "screen-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_AVATAR_URL, g_param_spec_string ("avatar-url", "avatar-url", "avatar-url", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_BANNER_URL, g_param_spec_string ("banner-url", "banner-url", "banner-url", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_WEBSITE, g_param_spec_string ("website", "website", "website", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_AVATAR_SMALL, g_param_spec_pointer ("avatar-small", "avatar-small", "avatar-small", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_AVATAR, g_param_spec_pointer ("avatar", "avatar", "avatar", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_PROXY, g_param_spec_object ("proxy", "proxy", "proxy", oauth_proxy_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_USER_STREAM, g_param_spec_object ("user-stream", "user-stream", "user-stream", TYPE_USER_STREAM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ACCOUNT_USER_COUNTER, g_param_spec_object ("user-counter", "user-counter", "user-counter", TYPE_USER_COUNTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("info_changed", TYPE_ACCOUNT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_POINTER, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER);
}


static void account_instance_init (Account * self) {
	self->priv = ACCOUNT_GET_PRIVATE (self);
}


static void account_finalize (GObject* obj) {
	Account * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT, Account);
	_sql_database_unref0 (self->priv->_db);
	_g_free0 (self->priv->_screen_name);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_avatar_url);
	_g_free0 (self->priv->_banner_url);
	_g_free0 (self->priv->_website);
	_g_free0 (self->priv->_description);
	_cairo_surface_destroy0 (self->priv->_avatar_small);
	_cairo_surface_destroy0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_proxy);
	_g_object_unref0 (self->priv->_user_stream);
	_g_object_unref0 (self->priv->_user_counter);
	_g_object_unref0 (self->priv->event_receiver);
	self->friends = (g_free (self->friends), NULL);
	self->blocked = (g_free (self->blocked), NULL);
	self->muted = (g_free (self->muted), NULL);
	self->disabled_rts = (g_free (self->disabled_rts), NULL);
	_g_object_unref0 (self->filters);
	G_OBJECT_CLASS (account_parent_class)->finalize (obj);
}


GType account_get_type (void) {
	static volatile gsize account_type_id__volatile = 0;
	if (g_once_init_enter (&account_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Account), 0, (GInstanceInitFunc) account_instance_init, NULL };
		GType account_type_id;
		account_type_id = g_type_register_static (G_TYPE_OBJECT, "Account", &g_define_type_info, 0);
		g_once_init_leave (&account_type_id__volatile, account_type_id);
	}
	return account_type_id__volatile;
}


static void _vala_account_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Account * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACCOUNT, Account);
	switch (property_id) {
		case ACCOUNT_ID:
		g_value_set_int64 (value, account_get_id (self));
		break;
		case ACCOUNT_DB:
		sql_value_set_database (value, account_get_db (self));
		break;
		case ACCOUNT_SCREEN_NAME:
		g_value_set_string (value, account_get_screen_name (self));
		break;
		case ACCOUNT_NAME:
		g_value_set_string (value, account_get_name (self));
		break;
		case ACCOUNT_AVATAR_URL:
		g_value_set_string (value, account_get_avatar_url (self));
		break;
		case ACCOUNT_BANNER_URL:
		g_value_set_string (value, account_get_banner_url (self));
		break;
		case ACCOUNT_WEBSITE:
		g_value_set_string (value, account_get_website (self));
		break;
		case ACCOUNT_DESCRIPTION:
		g_value_set_string (value, account_get_description (self));
		break;
		case ACCOUNT_AVATAR_SMALL:
		g_value_set_pointer (value, account_get_avatar_small (self));
		break;
		case ACCOUNT_AVATAR:
		g_value_set_pointer (value, account_get_avatar (self));
		break;
		case ACCOUNT_PROXY:
		g_value_set_object (value, account_get_proxy (self));
		break;
		case ACCOUNT_USER_STREAM:
		g_value_set_object (value, account_get_user_stream (self));
		break;
		case ACCOUNT_USER_COUNTER:
		g_value_set_object (value, account_get_user_counter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_account_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Account * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ACCOUNT, Account);
	switch (property_id) {
		case ACCOUNT_ID:
		account_set_id (self, g_value_get_int64 (value));
		break;
		case ACCOUNT_DB:
		account_set_db (self, sql_value_get_database (value));
		break;
		case ACCOUNT_SCREEN_NAME:
		account_set_screen_name (self, g_value_get_string (value));
		break;
		case ACCOUNT_NAME:
		account_set_name (self, g_value_get_string (value));
		break;
		case ACCOUNT_AVATAR_URL:
		account_set_avatar_url (self, g_value_get_string (value));
		break;
		case ACCOUNT_BANNER_URL:
		account_set_banner_url (self, g_value_get_string (value));
		break;
		case ACCOUNT_WEBSITE:
		account_set_website (self, g_value_get_string (value));
		break;
		case ACCOUNT_DESCRIPTION:
		account_set_description (self, g_value_get_string (value));
		break;
		case ACCOUNT_AVATAR_SMALL:
		account_set_avatar_small (self, g_value_get_pointer (value));
		break;
		case ACCOUNT_AVATAR:
		account_set_avatar (self, g_value_get_pointer (value));
		break;
		case ACCOUNT_PROXY:
		account_set_proxy (self, g_value_get_object (value));
		break;
		case ACCOUNT_USER_STREAM:
		account_set_user_stream (self, g_value_get_object (value));
		break;
		case ACCOUNT_USER_COUNTER:
		account_set_user_counter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



