/* Filter.c generated by valac 0.30.0, the Vala compiler
 * generated from Filter.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_FILTER (filter_get_type ())
#define FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER, Filter))
#define FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER, FilterClass))
#define IS_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER))
#define IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER))
#define FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER, FilterClass))

typedef struct _Filter Filter;
typedef struct _FilterClass FilterClass;
typedef struct _FilterPrivate FilterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _Filter {
	GObject parent_instance;
	FilterPrivate * priv;
};

struct _FilterClass {
	GObjectClass parent_class;
};

struct _FilterPrivate {
	gchar* _content;
	gint _id;
	GRegex* regex;
};


static gpointer filter_parent_class = NULL;

GType filter_get_type (void) G_GNUC_CONST;
#define FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILTER, FilterPrivate))
enum  {
	FILTER_DUMMY_PROPERTY,
	FILTER_CONTENT,
	FILTER_ID
};
Filter* filter_new (const gchar* expression);
Filter* filter_construct (GType object_type, const gchar* expression);
void filter_reset (Filter* self, const gchar* expression);
void filter_set_content (Filter* self, const gchar* value);
gboolean filter_matches (Filter* self, const gchar* test_text);
const gchar* filter_get_content (Filter* self);
gint filter_get_id (Filter* self);
void filter_set_id (Filter* self, gint value);
static void filter_finalize (GObject* obj);
static void _vala_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


Filter* filter_construct (GType object_type, const gchar* expression) {
	Filter * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (Filter*) g_object_new (object_type, NULL);
	_tmp0_ = expression;
	filter_reset (self, _tmp0_);
	return self;
}


Filter* filter_new (const gchar* expression) {
	return filter_construct (TYPE_FILTER, expression);
}


/**
   * (Re)Set the Filter's regular expression to the given one.
   *
   * @param expression The new expression.
   */
void filter_reset (Filter* self, const gchar* expression) {
	const gchar* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_FILTER (self));
	g_return_if_fail (expression != NULL);
	{
		GRegex* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GRegex* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		_tmp1_ = expression;
		_tmp2_ = g_regex_new (_tmp1_, G_REGEX_CASELESS, 0, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch50_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->regex);
		self->priv->regex = _tmp3_;
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally50;
	__catch50_g_regex_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = expression;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Filter.vala:36: Regex error for `%s`: %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally50:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = expression;
	filter_set_content (self, _tmp7_);
}


gboolean filter_matches (Filter* self, const gchar* test_text) {
	gboolean result = FALSE;
	GRegex* _tmp0_ = NULL;
	GRegex* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_FILTER (self), FALSE);
	g_return_val_if_fail (test_text != NULL, FALSE);
	_tmp0_ = self->priv->regex;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->regex;
	_tmp2_ = test_text;
	_tmp3_ = g_regex_match (_tmp1_, _tmp2_, 0, NULL);
	result = _tmp3_;
	return result;
}


const gchar* filter_get_content (Filter* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (IS_FILTER (self), NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}


void filter_set_content (Filter* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_FILTER (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp1_;
	g_object_notify ((GObject *) self, "content");
}


gint filter_get_id (Filter* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_FILTER (self), 0);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void filter_set_id (Filter* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_FILTER (self));
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void filter_class_init (FilterClass * klass) {
	filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FilterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_CONTENT, g_param_spec_string ("content", "content", "content", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void filter_instance_init (Filter * self) {
	self->priv = FILTER_GET_PRIVATE (self);
	self->priv->regex = NULL;
}


static void filter_finalize (GObject* obj) {
	Filter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILTER, Filter);
	_g_free0 (self->priv->_content);
	_g_regex_unref0 (self->priv->regex);
	G_OBJECT_CLASS (filter_parent_class)->finalize (obj);
}


GType filter_get_type (void) {
	static volatile gsize filter_type_id__volatile = 0;
	if (g_once_init_enter (&filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Filter), 0, (GInstanceInitFunc) filter_instance_init, NULL };
		GType filter_type_id;
		filter_type_id = g_type_register_static (G_TYPE_OBJECT, "Filter", &g_define_type_info, 0);
		g_once_init_leave (&filter_type_id__volatile, filter_type_id);
	}
	return filter_type_id__volatile;
}


static void _vala_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Filter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER, Filter);
	switch (property_id) {
		case FILTER_CONTENT:
		g_value_set_string (value, filter_get_content (self));
		break;
		case FILTER_ID:
		g_value_set_int (value, filter_get_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Filter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER, Filter);
	switch (property_id) {
		case FILTER_CONTENT:
		filter_set_content (self, g_value_get_string (value));
		break;
		case FILTER_ID:
		filter_set_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



