/* ITimeline.c generated by valac 0.30.0, the Vala compiler
 * generated from ITimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <cairo.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_ITIMELINE (itimeline_get_type ())
#define ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITIMELINE, ITimeline))
#define IS_ITIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITIMELINE))
#define ITIMELINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITIMELINE, ITimelineIface))

typedef struct _ITimeline ITimeline;
typedef struct _ITimelineIface ITimelineIface;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _ItimelineLoadNewestInternalData ItimelineLoadNewestInternalData;
typedef struct _ItimelineLoadOlderInternalData ItimelineLoadOlderInternalData;
typedef struct _Block14Data Block14Data;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_tool_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_tool_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	MainWindow* (*get_main_window) (IPage* self);
	void (*set_main_window) (IPage* self, MainWindow* value);
	Account* (*get_account) (IPage* self);
	void (*set_account) (IPage* self, Account* value);
};

struct _ITimelineIface {
	GTypeInterface parent_iface;
	TweetListBox* (*get_tweet_list) (ITimeline* self);
	void (*set_tweet_list) (ITimeline* self, TweetListBox* value);
	gint (*get_unread_count) (ITimeline* self);
	void (*set_unread_count) (ITimeline* self, gint value);
	DeltaUpdater* (*get_delta_updater) (ITimeline* self);
	void (*set_delta_updater) (ITimeline* self, DeltaUpdater* value);
	const gchar* (*get_function) (ITimeline* self);
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _ItimelineLoadNewestInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ITimeline* self;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp0_;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	RestProxyCall* _tmp15_;
	TweetListBox* _tmp16_;
	TweetListBox* _tmp17_;
	TweetModel* _tmp18_;
	gint64 _tmp19_;
	gint64 _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	JsonNode* root_node;
	JsonNode* _tmp23_;
	RestProxyCall* _tmp24_;
	JsonNode* _tmp25_;
	JsonNode* _tmp26_;
	GError* e;
	GError* _tmp27_;
	const gchar* _tmp28_;
	TweetListBox* _tmp29_;
	TweetListBox* _tmp30_;
	const gchar* _tmp31_;
	GError* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	JsonArray* root;
	JsonNode* _tmp36_;
	JsonArray* _tmp37_;
	JsonArray* _tmp38_;
	JsonArray* _tmp39_;
	guint _tmp40_;
	TweetListBox* _tmp41_;
	TweetListBox* _tmp42_;
	JsonArray* _tmp43_;
	TweetListBox* _tmp44_;
	TweetListBox* _tmp45_;
	MainWindow* _tmp46_;
	MainWindow* _tmp47_;
	Account* _tmp48_;
	Account* _tmp49_;
	GError * _inner_error_;
};

struct _ItimelineLoadOlderInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ITimeline* self;
	gint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp0_;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	OAuthProxy* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	RestProxyCall* _tmp8_;
	RestProxyCall* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	RestProxyCall* _tmp13_;
	RestProxyCall* _tmp14_;
	TweetListBox* _tmp15_;
	TweetListBox* _tmp16_;
	TweetModel* _tmp17_;
	gint64 _tmp18_;
	gint64 _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	JsonNode* root_node;
	JsonNode* _tmp22_;
	RestProxyCall* _tmp23_;
	JsonNode* _tmp24_;
	JsonNode* _tmp25_;
	GError* e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	JsonArray* root;
	JsonNode* _tmp28_;
	JsonArray* _tmp29_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	guint _tmp32_;
	TweetListBox* _tmp33_;
	TweetListBox* _tmp34_;
	JsonArray* _tmp35_;
	TweetListBox* _tmp36_;
	TweetListBox* _tmp37_;
	MainWindow* _tmp38_;
	MainWindow* _tmp39_;
	Account* _tmp40_;
	Account* _tmp41_;
	GError * _inner_error_;
};

struct _Block14Data {
	int _ref_count_;
	ITimeline* self;
	gdouble value;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};



GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType itimeline_get_type (void) G_GNUC_CONST;
static void itimeline_load_newest_internal_data_free (gpointer _data);
void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_);
static gboolean itimeline_load_newest_internal_co (ItimelineLoadNewestInternalData* _data_);
Account* ipage_get_account (IPage* self);
OAuthProxy* account_get_proxy (Account* self);
const gchar* itimeline_get_function (ITimeline* self);
TweetListBox* itimeline_get_tweet_list (ITimeline* self);
GType tweet_model_get_type (void) G_GNUC_CONST;
gint64 tweet_model_get_lowest_id (TweetModel* self);
void tweet_utils_load_threaded (RestProxyCall* call, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void itimeline_load_newest_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_error (TweetListBox* self, const gchar* err_msg);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, MainWindow* main_window, Account* account, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_work_array_finish (GAsyncResult* _res_);
MainWindow* ipage_get_main_window (IPage* self);
static void itimeline_load_older_internal_data_free (gpointer _data);
void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_);
static gboolean itimeline_load_older_internal_co (ItimelineLoadOlderInternalData* _data_);
static void itimeline_load_older_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void itimeline_mark_seen_on_scroll (ITimeline* self, gdouble value);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
gint itimeline_get_unread_count (ITimeline* self);
static void __lambda54_ (Block14Data* _data14_, GtkWidget* w);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
gboolean tweet_get_seen (Tweet* self);
void tweet_set_seen (Tweet* self, gboolean value);
void itimeline_set_unread_count (ITimeline* self, gint value);
static void ___lambda54__gtk_callback (GtkWidget* widget, gpointer self);
void itimeline_rerun_filters (ITimeline* self);
gboolean account_filter_matches (Account* self, Tweet* t);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
#define TWEET_HIDDEN_FILTERED ((guint) (1 << 2))
#define ITIMELINE_REST 25
void itimeline_set_tweet_list (ITimeline* self, TweetListBox* value);
DeltaUpdater* itimeline_get_delta_updater (ITimeline* self);
void itimeline_set_delta_updater (ITimeline* self, DeltaUpdater* value);


static void itimeline_load_newest_internal_data_free (gpointer _data) {
	ItimelineLoadNewestInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ItimelineLoadNewestInternalData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void itimeline_load_newest_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ItimelineLoadNewestInternalData* _data_;
	ITimeline* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ItimelineLoadNewestInternalData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, itimeline_load_newest_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, itimeline_load_newest_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	itimeline_load_newest_internal_co (_data_);
}


void itimeline_load_newest_internal_finish (ITimeline* self, GAsyncResult* _res_) {
	ItimelineLoadNewestInternalData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Default implementation for loading the newest tweets
   * from the given function of the twitter api.
   */
static void itimeline_load_newest_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ItimelineLoadNewestInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	itimeline_load_newest_internal_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean itimeline_load_newest_internal_co (ItimelineLoadNewestInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->requested_tweet_count = 28;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = account_get_proxy (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = itimeline_get_function (_data_->self);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	rest_proxy_call_set_function (_data_->_tmp5_, _data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "GET");
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->requested_tweet_count;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", _data_->_tmp10_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "contributor_details", "true");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp14_, "include_my_retweet", "true");
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->call;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = itimeline_get_tweet_list (_data_->self);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_->model;
	_data_->_tmp19_ = 0LL;
	_data_->_tmp19_ = tweet_model_get_lowest_id (_data_->_tmp18_);
	_data_->_tmp20_ = 0LL;
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp20_ - 1);
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->_tmp21_;
	rest_proxy_call_add_param (_data_->_tmp15_, "max_id", _data_->_tmp22_);
	_g_free0 (_data_->_tmp22_);
	_data_->root_node = NULL;
	{
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp24_, itimeline_load_newest_internal_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp23_ = _data_->_tmp25_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->_tmp23_;
		_data_->_tmp23_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp26_;
		__vala_JsonNode_free0 (_data_->_tmp23_);
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->e;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_message ("ITimeline.vala:50: %s", _data_->_tmp28_);
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _ ("Could not load tweets");
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->e;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->_tmp32_->message;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = g_strdup_printf ("%s\n%s", _data_->_tmp31_, _data_->_tmp33_);
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->_tmp34_;
		tweet_list_box_set_error (_data_->_tmp30_, _data_->_tmp35_);
		_g_free0 (_data_->_tmp35_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally12:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->root_node;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = json_node_get_array (_data_->_tmp36_);
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _json_array_ref0 (_data_->_tmp37_);
	_data_->root = _data_->_tmp38_;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->root;
	_data_->_tmp40_ = 0U;
	_data_->_tmp40_ = json_array_get_length (_data_->_tmp39_);
	if (_data_->_tmp40_ == ((guint) 0)) {
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->_tmp41_;
		tweet_list_box_set_empty (_data_->_tmp42_);
		_json_array_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = _data_->root;
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = itimeline_get_tweet_list (_data_->self);
	_data_->_tmp45_ = NULL;
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = NULL;
	_data_->_tmp46_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp47_ = NULL;
	_data_->_tmp47_ = _data_->_tmp46_;
	_data_->_tmp48_ = NULL;
	_data_->_tmp48_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp49_ = NULL;
	_data_->_tmp49_ = _data_->_tmp48_;
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp43_, _data_->_tmp45_, _data_->_tmp47_, _data_->_tmp49_, itimeline_load_newest_internal_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_);
	_json_array_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void itimeline_load_older_internal_data_free (gpointer _data) {
	ItimelineLoadOlderInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ItimelineLoadOlderInternalData, _data_);
}


void itimeline_load_older_internal (ITimeline* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ItimelineLoadOlderInternalData* _data_;
	ITimeline* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ItimelineLoadOlderInternalData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, itimeline_load_older_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, itimeline_load_older_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	itimeline_load_older_internal_co (_data_);
}


void itimeline_load_older_internal_finish (ITimeline* self, GAsyncResult* _res_) {
	ItimelineLoadOlderInternalData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Default implementation to load older tweets.
   *
   */
static void itimeline_load_older_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ItimelineLoadOlderInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	itimeline_load_older_internal_co (_data_);
}


static gboolean itimeline_load_older_internal_co (ItimelineLoadOlderInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->requested_tweet_count = 28;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = account_get_proxy (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp4_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = itimeline_get_function (_data_->self);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	rest_proxy_call_set_function (_data_->_tmp5_, _data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp8_, "GET");
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = _data_->requested_tweet_count;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = g_strdup_printf ("%i", _data_->_tmp10_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->_tmp11_;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", _data_->_tmp12_);
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp13_, "include_my_retweet", "true");
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = itimeline_get_tweet_list (_data_->self);
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_->model;
	_data_->_tmp18_ = 0LL;
	_data_->_tmp18_ = tweet_model_get_lowest_id (_data_->_tmp17_);
	_data_->_tmp19_ = 0LL;
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp19_ - 1);
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->_tmp20_;
	rest_proxy_call_add_param (_data_->_tmp14_, "max_id", _data_->_tmp21_);
	_g_free0 (_data_->_tmp21_);
	_data_->root_node = NULL;
	{
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp23_, itimeline_load_older_internal_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp22_ = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp22_;
		_data_->_tmp22_ = NULL;
		__vala_JsonNode_free0 (_data_->root_node);
		_data_->root_node = _data_->_tmp25_;
		__vala_JsonNode_free0 (_data_->_tmp22_);
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->e;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("ITimeline.vala:84: %s", _data_->_tmp27_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally13:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->root_node;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = json_node_get_array (_data_->_tmp28_);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _json_array_ref0 (_data_->_tmp29_);
	_data_->root = _data_->_tmp30_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->root;
	_data_->_tmp32_ = 0U;
	_data_->_tmp32_ = json_array_get_length (_data_->_tmp31_);
	if (_data_->_tmp32_ == ((guint) 0)) {
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = itimeline_get_tweet_list (_data_->self);
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _data_->_tmp33_;
		tweet_list_box_set_empty (_data_->_tmp34_);
		_json_array_unref0 (_data_->root);
		__vala_JsonNode_free0 (_data_->root_node);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp35_ = NULL;
	_data_->_tmp35_ = _data_->root;
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = itimeline_get_tweet_list (_data_->self);
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->_tmp36_;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = ipage_get_main_window (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->_tmp38_;
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, TYPE_IPAGE, IPage));
	_data_->_tmp41_ = NULL;
	_data_->_tmp41_ = _data_->_tmp40_;
	_data_->_state_ = 2;
	tweet_utils_work_array (_data_->_tmp35_, _data_->_tmp37_, _data_->_tmp39_, _data_->_tmp41_, itimeline_load_older_internal_ready, _data_);
	return FALSE;
	_state_2:
	tweet_utils_work_array_finish (_data_->_res_);
	_json_array_unref0 (_data_->root);
	__vala_JsonNode_free0 (_data_->root_node);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Mark the TweetListEntries the user has already seen.
   *
   * @param value The scrolling value as from Gtk.Adjustment
   */
static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ITimeline* self;
		self = _data14_->self;
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static void __lambda54_ (Block14Data* _data14_, GtkWidget* w) {
	ITimeline* self;
	GtkWidget* _tmp0_ = NULL;
	TweetListEntry* tle = NULL;
	GtkWidget* _tmp1_ = NULL;
	TweetListEntry* _tmp2_ = NULL;
	TweetListEntry* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkAllocation alloc = {0};
	TweetListEntry* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	GtkAllocation _tmp11_ = {0};
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	self = _data14_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry));
	tle = _tmp2_;
	_tmp3_ = tle;
	_tmp4_ = _tmp3_->tweet;
	_tmp5_ = tweet_get_seen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		_g_object_unref0 (tle);
		return;
	}
	_tmp7_ = tle;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), &_tmp8_);
	alloc = _tmp8_;
	_tmp9_ = alloc;
	_tmp10_ = _tmp9_.y;
	_tmp11_ = alloc;
	_tmp12_ = _tmp11_.height;
	_tmp13_ = _data14_->value;
	if ((_tmp10_ + (_tmp12_ / 2.0)) >= _tmp13_) {
		TweetListEntry* _tmp14_ = NULL;
		Tweet* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp14_ = tle;
		_tmp15_ = _tmp14_->tweet;
		tweet_set_seen (_tmp15_, TRUE);
		_tmp16_ = itimeline_get_unread_count (self);
		_tmp17_ = _tmp16_;
		itimeline_set_unread_count (self, _tmp17_ - 1);
	}
	_g_object_unref0 (tle);
}


static void ___lambda54__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda54_ (self, widget);
}


void itimeline_mark_seen_on_scroll (ITimeline* self, gdouble value) {
	Block14Data* _data14_;
	gdouble _tmp0_ = 0.0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TweetListBox* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = value;
	_data14_->value = _tmp0_;
	_tmp1_ = itimeline_get_unread_count (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		block14_data_unref (_data14_);
		_data14_ = NULL;
		return;
	}
	_tmp3_ = itimeline_get_tweet_list (self);
	_tmp4_ = _tmp3_;
	GTK_CONTAINER_GET_CLASS (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer))->forall (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), FALSE, ___lambda54__gtk_callback, _data14_);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


void itimeline_rerun_filters (ITimeline* self) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	_tmp0_ = itimeline_get_tweet_list (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tm = _tmp3_;
	{
		guint i = 0U;
		guint p = 0U;
		TweetModel* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		i = (guint) 0;
		_tmp4_ = tm;
		_tmp5_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_list_model_get_type (), GListModel));
		p = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				guint _tmp8_ = 0U;
				guint _tmp9_ = 0U;
				Tweet* tweet = NULL;
				TweetModel* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				GObject* _tmp12_ = NULL;
				Account* _tmp13_ = NULL;
				Account* _tmp14_ = NULL;
				Tweet* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
				Tweet* _tmp29_ = NULL;
				if (!_tmp6_) {
					guint _tmp7_ = 0U;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = p;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = tm;
				_tmp11_ = i;
				_tmp12_ = g_list_model_get_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_list_model_get_type (), GListModel), _tmp11_);
				tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_TWEET, Tweet);
				_tmp13_ = ipage_get_account (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp14_ = _tmp13_;
				_tmp15_ = tweet;
				_tmp16_ = account_filter_matches (_tmp14_, _tmp15_);
				if (_tmp16_) {
					Tweet* _tmp17_ = NULL;
					Tweet* _tmp18_ = NULL;
					guint _tmp19_ = 0U;
					Tweet* _tmp20_ = NULL;
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					_tmp17_ = tweet;
					_tmp18_ = tweet;
					_tmp19_ = _tmp18_->hidden_flags;
					_tmp18_->hidden_flags = _tmp19_ | TWEET_HIDDEN_FILTERED;
					_tmp20_ = tweet;
					_tmp21_ = tweet_get_seen (_tmp20_);
					_tmp22_ = _tmp21_;
					if (!_tmp22_) {
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
						Tweet* _tmp25_ = NULL;
						_tmp23_ = itimeline_get_unread_count (self);
						_tmp24_ = _tmp23_;
						itimeline_set_unread_count (self, _tmp24_ - 1);
						_tmp25_ = tweet;
						tweet_set_seen (_tmp25_, TRUE);
					}
				} else {
					Tweet* _tmp26_ = NULL;
					Tweet* _tmp27_ = NULL;
					guint _tmp28_ = 0U;
					_tmp26_ = tweet;
					_tmp27_ = tweet;
					_tmp28_ = _tmp27_->hidden_flags;
					_tmp27_->hidden_flags = _tmp28_ & (~TWEET_HIDDEN_FILTERED);
				}
				_tmp29_ = tweet;
				g_signal_emit_by_name (_tmp29_, "hidden-flags-changed");
				_g_object_unref0 (tweet);
			}
		}
	}
	_g_object_unref0 (tm);
}


TweetListBox* itimeline_get_tweet_list (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), NULL);
	return ITIMELINE_GET_INTERFACE (self)->get_tweet_list (self);
}


void itimeline_set_tweet_list (ITimeline* self, TweetListBox* value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_tweet_list (self, value);
}


gint itimeline_get_unread_count (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), 0);
	return ITIMELINE_GET_INTERFACE (self)->get_unread_count (self);
}


void itimeline_set_unread_count (ITimeline* self, gint value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_unread_count (self, value);
}


DeltaUpdater* itimeline_get_delta_updater (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), NULL);
	return ITIMELINE_GET_INTERFACE (self)->get_delta_updater (self);
}


void itimeline_set_delta_updater (ITimeline* self, DeltaUpdater* value) {
	g_return_if_fail (IS_ITIMELINE (self));
	ITIMELINE_GET_INTERFACE (self)->set_delta_updater (self, value);
}


const gchar* itimeline_get_function (ITimeline* self) {
	g_return_val_if_fail (IS_ITIMELINE (self), NULL);
	return ITIMELINE_GET_INTERFACE (self)->get_function (self);
}


static void itimeline_base_init (ITimelineIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/** The lowest id of any tweet in this timeline */
		g_object_interface_install_property (iface, g_param_spec_object ("tweet-list", "tweet-list", "tweet-list", TYPE_TWEET_LIST_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_object ("delta-updater", "delta-updater", "delta-updater", TYPE_DELTA_UPDATER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


/**
 * Describes everything a timeline should provide, in an abstract way.
 * Default implementations are given through the *_internal methods.
 */
GType itimeline_get_type (void) {
	static volatile gsize itimeline_type_id__volatile = 0;
	if (g_once_init_enter (&itimeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ITimelineIface), (GBaseInitFunc) itimeline_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType itimeline_type_id;
		itimeline_type_id = g_type_register_static (G_TYPE_INTERFACE, "ITimeline", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (itimeline_type_id, gtk_widget_get_type ());
		g_type_interface_add_prerequisite (itimeline_type_id, TYPE_IPAGE);
		g_once_init_leave (&itimeline_type_id__volatile, itimeline_type_id);
	}
	return itimeline_type_id__volatile;
}



