/* UserEventReceiver.c generated by valac 0.30.0, the Vala compiler
 * generated from UserEventReceiver.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <json-glib/json-glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>


#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_USER_EVENT_RECEIVER (user_event_receiver_get_type ())
#define USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiver))
#define USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))
#define IS_USER_EVENT_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_EVENT_RECEIVER))
#define IS_USER_EVENT_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_EVENT_RECEIVER))
#define USER_EVENT_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_EVENT_RECEIVER, UserEventReceiverClass))

typedef struct _UserEventReceiver UserEventReceiver;
typedef struct _UserEventReceiverClass UserEventReceiverClass;
typedef struct _UserEventReceiverPrivate UserEventReceiverPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _UserEventReceiver {
	GObject parent_instance;
	UserEventReceiverPrivate * priv;
};

struct _UserEventReceiverClass {
	GObjectClass parent_class;
};

struct _UserEventReceiverPrivate {
	Account* account;
};


static gpointer user_event_receiver_parent_class = NULL;
static IMessageReceiverIface* user_event_receiver_imessage_receiver_parent_iface = NULL;

GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType user_event_receiver_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_EVENT_RECEIVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_EVENT_RECEIVER, UserEventReceiverPrivate))
enum  {
	USER_EVENT_RECEIVER_DUMMY_PROPERTY
};
UserEventReceiver* user_event_receiver_new (Account* account);
UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account);
static void user_event_receiver_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node);
void account_follow_id (Account* self, gint64 user_id);
void account_unfollow_id (Account* self, gint64 user_id);
void account_mute_id (Account* self, gint64 id);
void account_unmute_id (Account* self, gint64 id);
void account_block_id (Account* self, gint64 id);
void account_unblock_id (Account* self, gint64 id);
gint64 account_get_id (Account* self);
const gchar* account_get_screen_name (Account* self);
void account_set_name (Account* self, const gchar* value);
void account_set_description (Account* self, const gchar* value);
void account_set_screen_name (Account* self, const gchar* value);
const gchar* account_get_name (Account* self);
cairo_surface_t* account_get_avatar_small (Account* self);
cairo_surface_t* account_get_avatar (Account* self);
void account_save_info (Account* self);
void utils_update_startup_account (const gchar* old_screen_name, const gchar* new_screen_name);
static void user_event_receiver_finalize (GObject* obj);


UserEventReceiver* user_event_receiver_construct (GType object_type, Account* account) {
	UserEventReceiver * self = NULL;
	Account* _tmp0_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (UserEventReceiver*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	return self;
}


UserEventReceiver* user_event_receiver_new (Account* account) {
	return user_event_receiver_construct (TYPE_USER_EVENT_RECEIVER, account);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void user_event_receiver_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node) {
	UserEventReceiver * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_USER_EVENT_RECEIVER, UserEventReceiver);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	switch (_tmp0_) {
		case STREAM_MESSAGE_TYPE_EVENT_FOLLOW:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp1_ = NULL;
			JsonObject* _tmp2_ = NULL;
			JsonObject* _tmp3_ = NULL;
			gint64 _tmp4_ = 0LL;
			Account* _tmp5_ = NULL;
			gint64 _tmp6_ = 0LL;
			_tmp1_ = root_node;
			_tmp2_ = json_node_get_object (_tmp1_);
			_tmp3_ = json_object_get_object_member (_tmp2_, "target");
			_tmp4_ = json_object_get_int_member (_tmp3_, "id");
			user_id = _tmp4_;
			_tmp5_ = self->priv->account;
			_tmp6_ = user_id;
			account_follow_id (_tmp5_, _tmp6_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp7_ = NULL;
			JsonObject* _tmp8_ = NULL;
			JsonObject* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			Account* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			_tmp7_ = root_node;
			_tmp8_ = json_node_get_object (_tmp7_);
			_tmp9_ = json_object_get_object_member (_tmp8_, "target");
			_tmp10_ = json_object_get_int_member (_tmp9_, "id");
			user_id = _tmp10_;
			_tmp11_ = self->priv->account;
			_tmp12_ = user_id;
			account_unfollow_id (_tmp11_, _tmp12_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_MUTE:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp13_ = NULL;
			JsonObject* _tmp14_ = NULL;
			JsonObject* _tmp15_ = NULL;
			gint64 _tmp16_ = 0LL;
			Account* _tmp17_ = NULL;
			gint64 _tmp18_ = 0LL;
			_tmp13_ = root_node;
			_tmp14_ = json_node_get_object (_tmp13_);
			_tmp15_ = json_object_get_object_member (_tmp14_, "target");
			_tmp16_ = json_object_get_int_member (_tmp15_, "id");
			user_id = _tmp16_;
			_tmp17_ = self->priv->account;
			_tmp18_ = user_id;
			account_mute_id (_tmp17_, _tmp18_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_UNMUTE:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp19_ = NULL;
			JsonObject* _tmp20_ = NULL;
			JsonObject* _tmp21_ = NULL;
			gint64 _tmp22_ = 0LL;
			Account* _tmp23_ = NULL;
			gint64 _tmp24_ = 0LL;
			_tmp19_ = root_node;
			_tmp20_ = json_node_get_object (_tmp19_);
			_tmp21_ = json_object_get_object_member (_tmp20_, "target");
			_tmp22_ = json_object_get_int_member (_tmp21_, "id");
			user_id = _tmp22_;
			_tmp23_ = self->priv->account;
			_tmp24_ = user_id;
			account_unmute_id (_tmp23_, _tmp24_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_BLOCK:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp25_ = NULL;
			JsonObject* _tmp26_ = NULL;
			JsonObject* _tmp27_ = NULL;
			gint64 _tmp28_ = 0LL;
			Account* _tmp29_ = NULL;
			gint64 _tmp30_ = 0LL;
			_tmp25_ = root_node;
			_tmp26_ = json_node_get_object (_tmp25_);
			_tmp27_ = json_object_get_object_member (_tmp26_, "target");
			_tmp28_ = json_object_get_int_member (_tmp27_, "id");
			user_id = _tmp28_;
			_tmp29_ = self->priv->account;
			_tmp30_ = user_id;
			account_block_id (_tmp29_, _tmp30_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_UNBLOCK:
		{
			gint64 user_id = 0LL;
			JsonNode* _tmp31_ = NULL;
			JsonObject* _tmp32_ = NULL;
			JsonObject* _tmp33_ = NULL;
			gint64 _tmp34_ = 0LL;
			Account* _tmp35_ = NULL;
			gint64 _tmp36_ = 0LL;
			_tmp31_ = root_node;
			_tmp32_ = json_node_get_object (_tmp31_);
			_tmp33_ = json_object_get_object_member (_tmp32_, "target");
			_tmp34_ = json_object_get_int_member (_tmp33_, "id");
			user_id = _tmp34_;
			_tmp35_ = self->priv->account;
			_tmp36_ = user_id;
			account_unblock_id (_tmp35_, _tmp36_);
			break;
		}
		case STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE:
		{
			JsonObject* user_obj = NULL;
			JsonNode* _tmp37_ = NULL;
			JsonObject* _tmp38_ = NULL;
			JsonObject* _tmp39_ = NULL;
			JsonObject* _tmp40_ = NULL;
			JsonObject* _tmp41_ = NULL;
			gint64 _tmp42_ = 0LL;
			Account* _tmp43_ = NULL;
			gint64 _tmp44_ = 0LL;
			gint64 _tmp45_ = 0LL;
			_tmp37_ = root_node;
			_tmp38_ = json_node_get_object (_tmp37_);
			_tmp39_ = json_object_get_object_member (_tmp38_, "target");
			_tmp40_ = _json_object_ref0 (_tmp39_);
			user_obj = _tmp40_;
			_tmp41_ = user_obj;
			_tmp42_ = json_object_get_int_member (_tmp41_, "id");
			_tmp43_ = self->priv->account;
			_tmp44_ = account_get_id (_tmp43_);
			_tmp45_ = _tmp44_;
			if (_tmp42_ == _tmp45_) {
				gchar* old_screen_name = NULL;
				Account* _tmp46_ = NULL;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				Account* _tmp50_ = NULL;
				JsonObject* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				Account* _tmp53_ = NULL;
				JsonObject* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				Account* _tmp56_ = NULL;
				JsonObject* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				Account* _tmp59_ = NULL;
				Account* _tmp60_ = NULL;
				const gchar* _tmp61_ = NULL;
				const gchar* _tmp62_ = NULL;
				Account* _tmp63_ = NULL;
				const gchar* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				Account* _tmp66_ = NULL;
				cairo_surface_t* _tmp67_ = NULL;
				cairo_surface_t* _tmp68_ = NULL;
				Account* _tmp69_ = NULL;
				cairo_surface_t* _tmp70_ = NULL;
				cairo_surface_t* _tmp71_ = NULL;
				Account* _tmp72_ = NULL;
				const gchar* _tmp73_ = NULL;
				Account* _tmp74_ = NULL;
				const gchar* _tmp75_ = NULL;
				const gchar* _tmp76_ = NULL;
				_tmp46_ = self->priv->account;
				_tmp47_ = account_get_screen_name (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup (_tmp48_);
				old_screen_name = _tmp49_;
				_tmp50_ = self->priv->account;
				_tmp51_ = user_obj;
				_tmp52_ = json_object_get_string_member (_tmp51_, "name");
				account_set_name (_tmp50_, _tmp52_);
				_tmp53_ = self->priv->account;
				_tmp54_ = user_obj;
				_tmp55_ = json_object_get_string_member (_tmp54_, "description");
				account_set_description (_tmp53_, _tmp55_);
				_tmp56_ = self->priv->account;
				_tmp57_ = user_obj;
				_tmp58_ = json_object_get_string_member (_tmp57_, "screen_name");
				account_set_screen_name (_tmp56_, _tmp58_);
				_tmp59_ = self->priv->account;
				_tmp60_ = self->priv->account;
				_tmp61_ = account_get_screen_name (_tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = self->priv->account;
				_tmp64_ = account_get_name (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = self->priv->account;
				_tmp67_ = account_get_avatar_small (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = self->priv->account;
				_tmp70_ = account_get_avatar (_tmp69_);
				_tmp71_ = _tmp70_;
				g_signal_emit_by_name (_tmp59_, "info-changed", _tmp62_, _tmp65_, _tmp68_, _tmp71_);
				_tmp72_ = self->priv->account;
				account_save_info (_tmp72_);
				_tmp73_ = old_screen_name;
				_tmp74_ = self->priv->account;
				_tmp75_ = account_get_screen_name (_tmp74_);
				_tmp76_ = _tmp75_;
				utils_update_startup_account (_tmp73_, _tmp76_);
				_g_free0 (old_screen_name);
			} else {
				g_warning ("UserEventReceiver.vala:78: USER_UPDATE: ids don't match");
			}
			_json_object_unref0 (user_obj);
			break;
		}
		default:
		break;
	}
}


static void user_event_receiver_class_init (UserEventReceiverClass * klass) {
	user_event_receiver_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserEventReceiverPrivate));
	G_OBJECT_CLASS (klass)->finalize = user_event_receiver_finalize;
}


static void user_event_receiver_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	user_event_receiver_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) user_event_receiver_real_stream_message_received;
}


static void user_event_receiver_instance_init (UserEventReceiver * self) {
	self->priv = USER_EVENT_RECEIVER_GET_PRIVATE (self);
}


static void user_event_receiver_finalize (GObject* obj) {
	UserEventReceiver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_EVENT_RECEIVER, UserEventReceiver);
	G_OBJECT_CLASS (user_event_receiver_parent_class)->finalize (obj);
}


GType user_event_receiver_get_type (void) {
	static volatile gsize user_event_receiver_type_id__volatile = 0;
	if (g_once_init_enter (&user_event_receiver_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserEventReceiverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_event_receiver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserEventReceiver), 0, (GInstanceInitFunc) user_event_receiver_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) user_event_receiver_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType user_event_receiver_type_id;
		user_event_receiver_type_id = g_type_register_static (G_TYPE_OBJECT, "UserEventReceiver", &g_define_type_info, 0);
		g_type_add_interface_static (user_event_receiver_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&user_event_receiver_type_id__volatile, user_event_receiver_type_id);
	}
	return user_event_receiver_type_id__volatile;
}



