/* AccountDialog.c generated by valac 0.30.0, the Vala compiler
 * generated from AccountDialog.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <rest/oauth-proxy.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <sqlite3.h>


#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
typedef struct _AccountDialogPrivate AccountDialogPrivate;

#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block83Data Block83Data;
typedef struct _Block84Data Block84Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block85Data Block85Data;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block86Data Block86Data;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _AccountDialog {
	GtkDialog parent_instance;
	AccountDialogPrivate * priv;
};

struct _AccountDialogClass {
	GtkDialogClass parent_class;
};

struct _AccountDialogPrivate {
	GtkEntry* name_entry;
	AvatarBannerWidget* avatar_banner_widget;
	GtkStack* delete_stack;
	GtkSwitch* autostart_switch;
	GtkEntry* website_entry;
	CompletionTextView* description_text_view;
	Account* account;
	gchar* old_user_name;
	gchar* old_description;
	gchar* old_website;
	GdkPixbuf* new_avatar;
	GdkPixbuf* new_banner;
};

struct _Block83Data {
	int _ref_count_;
	AccountDialog* self;
	Account* account;
};

struct _Block84Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _Block85Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};

struct _Block86Data {
	int _ref_count_;
	AccountDialog* self;
	RestProxyCall* call;
};


static gpointer account_dialog_parent_class = NULL;
extern GMenu* corebird_account_menu;
extern SqlDatabase* corebird_db;

GType account_dialog_get_type (void) G_GNUC_CONST;
GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ACCOUNT_DIALOG, AccountDialogPrivate))
enum  {
	ACCOUNT_DIALOG_DUMMY_PROPERTY
};
#define ACCOUNT_DIALOG_PAGE_NORMAL "normal"
#define ACCOUNT_DIALOG_PAGE_DELETE "delete"
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
static Block83Data* block83_data_ref (Block83Data* _data83_);
static void block83_data_unref (void * _userdata_);
const gchar* account_get_name (Account* self);
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static void account_dialog_set_transient_data (AccountDialog* self, const gchar* website, const gchar* description);
const gchar* account_get_website (Account* self);
const gchar* account_get_description (Account* self);
GSettings* settings_get (void);
const gchar* account_get_screen_name (Account* self);
static void __lambda157_ (AccountDialog* self, GdkPixbuf* p);
static void ___lambda157__avatar_banner_widget_avatar_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_avatar, gpointer self);
static void __lambda158_ (AccountDialog* self, GdkPixbuf* b);
static void ___lambda158__avatar_banner_widget_banner_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_banner, gpointer self);
OAuthProxy* account_get_proxy (Account* self);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
static void ___lambda159_ (Block83Data* _data83_, GObject* obj, GAsyncResult* res);
static void ____lambda159__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_dialog_real_response (GtkDialog* base, gint response_id);
static void account_dialog_save_data (AccountDialog* self);
static void account_dialog_delete_button_clicked_cb (AccountDialog* self);
static void _account_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block84Data* block84_data_ref (Block84Data* _data84_);
static void block84_data_unref (void * _userdata_);
static void ___lambda160_ (Block84Data* _data84_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file);
static void ____lambda160__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void account_set_name (Account* self, const gchar* value);
void account_set_description (Account* self, const gchar* value);
void account_set_website (Account* self, const gchar* value);
static Block85Data* block85_data_ref (Block85Data* _data85_);
static void block85_data_unref (void * _userdata_);
static void ___lambda161_ (Block85Data* _data85_, GObject* obj, GAsyncResult* res);
void account_set_new_avatar (Account* self, cairo_surface_t* new_avatar);
static void ____lambda161__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block86Data* block86_data_ref (Block86Data* _data86_);
static void block86_data_unref (void * _userdata_);
static void ___lambda162_ (Block86Data* _data86_, GObject* obj, GAsyncResult* res);
static void ____lambda162__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void account_dialog_delete_confirm_button_clicked_cb (AccountDialog* self);
gint64 account_get_id (Account* self);
gchar* dirs_config (const gchar* path);
gpointer sql_database_ref (gpointer instance);
void sql_database_unref (gpointer instance);
GParamSpec* sql_param_spec_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void sql_value_set_database (GValue* value, gpointer v_object);
void sql_value_take_database (GValue* value, gpointer v_object);
gpointer sql_value_get_database (const GValue* value);
GType sql_database_get_type (void) G_GNUC_CONST;
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
GType corebird_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
Account* main_window_get_account (MainWindow* self);
void main_window_change_account (MainWindow* self, Account* account, GApplication* app);
Account* account_query_account_by_id (gint64 id);
void account_remove_account (const gchar* screen_name);
static void _account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_delete_cancel_button_clicked_cb (AccountDialog* self);
static void _account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void account_dialog_autostart_switch_activate_cb (AccountDialog* self);
static void _account_dialog_autostart_switch_activate_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void account_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block83Data* block83_data_ref (Block83Data* _data83_) {
	g_atomic_int_inc (&_data83_->_ref_count_);
	return _data83_;
}


static void block83_data_unref (void * _userdata_) {
	Block83Data* _data83_;
	_data83_ = (Block83Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data83_->_ref_count_)) {
		AccountDialog* self;
		self = _data83_->self;
		_g_object_unref0 (_data83_->account);
		_g_object_unref0 (self);
		g_slice_free (Block83Data, _data83_);
	}
}


static void __lambda157_ (AccountDialog* self, GdkPixbuf* p) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (p));
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->new_avatar);
	self->priv->new_avatar = _tmp1_;
}


static void ___lambda157__avatar_banner_widget_avatar_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_avatar, gpointer self) {
	__lambda157_ ((AccountDialog*) self, new_avatar);
}


static void __lambda158_ (AccountDialog* self, GdkPixbuf* b) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (GDK_IS_PIXBUF (b));
	_tmp0_ = b;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->new_banner);
	self->priv->new_banner = _tmp1_;
}


static void ___lambda158__avatar_banner_widget_banner_changed (AvatarBannerWidget* _sender, GdkPixbuf* new_banner, gpointer self) {
	__lambda158_ ((AccountDialog*) self, new_banner);
}


static void ___lambda159_ (Block83Data* _data83_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	self = _data83_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = _data83_->account;
	_tmp1_ = account_get_website (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data83_->account;
	_tmp4_ = account_get_description (_tmp3_);
	_tmp5_ = _tmp4_;
	account_dialog_set_transient_data (self, _tmp2_, _tmp5_);
}


static void ____lambda159__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda159_ (self, source_object, res);
	block83_data_unref (self);
}


AccountDialog* account_dialog_construct (GType object_type, Account* account) {
	AccountDialog * self = NULL;
	Block83Data* _data83_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GtkSettings* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	Account* _tmp6_ = NULL;
	GtkEntry* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	AvatarBannerWidget* _tmp11_ = NULL;
	Account* _tmp12_ = NULL;
	CompletionTextView* _tmp13_ = NULL;
	Account* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkSwitch* _tmp21_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp22_ = NULL;
	GSettings* _tmp23_ = NULL;
	gchar** _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
	GtkSwitch* _tmp34_ = NULL;
	AvatarBannerWidget* _tmp35_ = NULL;
	AvatarBannerWidget* _tmp36_ = NULL;
	Account* _tmp37_ = NULL;
	OAuthProxy* _tmp38_ = NULL;
	OAuthProxy* _tmp39_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_data83_ = g_slice_new0 (Block83Data);
	_data83_->_ref_count_ = 1;
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data83_->account);
	_data83_->account = _tmp1_;
	_tmp3_ = gtk_settings_get_default ();
	g_object_get (_tmp3_, "gtk-dialogs-use-header", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = 1;
	} else {
		_tmp2_ = 0;
	}
	self = (AccountDialog*) g_object_new (object_type, "use-header-bar", _tmp2_, NULL);
	_data83_->self = g_object_ref (self);
	gtk_dialog_set_default_response (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog), (gint) GTK_RESPONSE_CLOSE);
	_tmp6_ = _data83_->account;
	self->priv->account = _tmp6_;
	_tmp7_ = self->priv->name_entry;
	_tmp8_ = _data83_->account;
	_tmp9_ = account_get_name (_tmp8_);
	_tmp10_ = _tmp9_;
	gtk_entry_set_text (_tmp7_, _tmp10_);
	_tmp11_ = self->priv->avatar_banner_widget;
	_tmp12_ = _data83_->account;
	avatar_banner_widget_set_account (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->description_text_view;
	_tmp14_ = _data83_->account;
	completion_text_view_set_account (_tmp13_, _tmp14_);
	_tmp15_ = _data83_->account;
	_tmp16_ = account_get_website (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _data83_->account;
	_tmp19_ = account_get_description (_tmp18_);
	_tmp20_ = _tmp19_;
	account_dialog_set_transient_data (self, _tmp17_, _tmp20_);
	_tmp21_ = self->priv->autostart_switch;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, G_TYPE_OBJECT, GObject));
	_tmp22_ = settings_get ();
	_tmp23_ = _tmp22_;
	_tmp25_ = _tmp24_ = g_settings_get_strv (_tmp23_, "startup-accounts");
	_tmp26_ = _tmp25_;
	_tmp26__length1 = _vala_array_length (_tmp24_);
	_g_object_unref0 (_tmp23_);
	startup_accounts = _tmp26_;
	startup_accounts_length1 = _tmp26__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp27_ = startup_accounts;
	_tmp27__length1 = startup_accounts_length1;
	{
		gchar** acc_collection = NULL;
		gint acc_collection_length1 = 0;
		gint _acc_collection_size_ = 0;
		gint acc_it = 0;
		acc_collection = _tmp27_;
		acc_collection_length1 = _tmp27__length1;
		for (acc_it = 0; acc_it < _tmp27__length1; acc_it = acc_it + 1) {
			gchar* _tmp28_ = NULL;
			gchar* acc = NULL;
			_tmp28_ = g_strdup (acc_collection[acc_it]);
			acc = _tmp28_;
			{
				const gchar* _tmp29_ = NULL;
				Account* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				_tmp29_ = acc;
				_tmp30_ = self->priv->account;
				_tmp31_ = account_get_screen_name (_tmp30_);
				_tmp32_ = _tmp31_;
				if (g_strcmp0 (_tmp29_, _tmp32_) == 0) {
					GtkSwitch* _tmp33_ = NULL;
					_tmp33_ = self->priv->autostart_switch;
					gtk_switch_set_active (_tmp33_, TRUE);
					_g_free0 (acc);
					break;
				}
				_g_free0 (acc);
			}
		}
	}
	_tmp34_ = self->priv->autostart_switch;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, G_TYPE_OBJECT, GObject));
	_tmp35_ = self->priv->avatar_banner_widget;
	g_signal_connect_object (_tmp35_, "avatar-changed", (GCallback) ___lambda157__avatar_banner_widget_avatar_changed, self, 0);
	_tmp36_ = self->priv->avatar_banner_widget;
	g_signal_connect_object (_tmp36_, "banner-changed", (GCallback) ___lambda158__avatar_banner_widget_banner_changed, self, 0);
	_tmp37_ = _data83_->account;
	_tmp38_ = account_get_proxy (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == NULL) {
		Account* _tmp40_ = NULL;
		Account* _tmp41_ = NULL;
		_tmp40_ = _data83_->account;
		account_init_proxy (_tmp40_, TRUE, FALSE);
		_tmp41_ = _data83_->account;
		account_query_user_info_by_screen_name (_tmp41_, NULL, ____lambda159__gasync_ready_callback, block83_data_ref (_data83_));
	}
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 350, 450);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	block83_data_unref (_data83_);
	_data83_ = NULL;
	return self;
}


AccountDialog* account_dialog_new (Account* account) {
	return account_dialog_construct (TYPE_ACCOUNT_DIALOG, account);
}


static void account_dialog_set_transient_data (AccountDialog* self, const gchar* website, const gchar* description) {
	const gchar* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	Account* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	CompletionTextView* _tmp23_ = NULL;
	GtkTextBuffer* _tmp24_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp1_ = self->priv->account;
	_tmp2_ = account_get_website (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp4_ = self->priv->website_entry;
	gtk_entry_set_text (_tmp4_, _tmp0_);
	_tmp5_ = self->priv->account;
	_tmp6_ = account_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->old_user_name);
	self->priv->old_user_name = _tmp8_;
	_tmp10_ = self->priv->account;
	_tmp11_ = account_get_website (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp9_ = _tmp12_;
	if (_tmp9_ == NULL) {
		_tmp9_ = "";
	}
	_tmp13_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->old_website);
	self->priv->old_website = _tmp13_;
	_tmp15_ = self->priv->account;
	_tmp16_ = account_get_description (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp14_ = _tmp17_;
	if (_tmp14_ == NULL) {
		_tmp14_ = "";
	}
	_tmp18_ = g_strdup (_tmp14_);
	_g_free0 (self->priv->old_description);
	self->priv->old_description = _tmp18_;
	_tmp20_ = self->priv->account;
	_tmp21_ = account_get_description (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp19_ = _tmp22_;
	if (_tmp19_ == NULL) {
		_tmp19_ = "";
	}
	_tmp23_ = self->priv->description_text_view;
	_tmp24_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_text_view_get_type (), GtkTextView));
	gtk_text_buffer_set_text (_tmp24_, _tmp19_, -1);
}


static void account_dialog_real_response (GtkDialog* base, gint response_id) {
	AccountDialog * self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_ACCOUNT_DIALOG, AccountDialog);
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_CLOSE)) {
		account_dialog_save_data (self);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	} else {
		gint _tmp1_ = 0;
		_tmp1_ = response_id;
		if (_tmp1_ == ((gint) GTK_RESPONSE_CANCEL)) {
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		}
	}
}


static void account_dialog_delete_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->delete_stack;
	gtk_stack_set_visible_child_name (_tmp0_, ACCOUNT_DIALOG_PAGE_DELETE);
}


static void _account_dialog_delete_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_button_clicked_cb ((AccountDialog*) self);
}


static Block84Data* block84_data_ref (Block84Data* _data84_) {
	g_atomic_int_inc (&_data84_->_ref_count_);
	return _data84_;
}


static void block84_data_unref (void * _userdata_) {
	Block84Data* _data84_;
	_data84_ = (Block84Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data84_->_ref_count_)) {
		AccountDialog* self;
		self = _data84_->self;
		_g_object_unref0 (_data84_->call);
		_g_object_unref0 (self);
		g_slice_free (Block84Data, _data84_);
	}
}


static void ___lambda160_ (Block84Data* _data84_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	GError * _inner_error_ = NULL;
	self = _data84_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data84_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch108_g_error;
		}
	}
	goto __finally108;
	__catch108_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		RestProxyCall* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("AccountDialog.vala:126: %s", _tmp3_);
		_tmp4_ = _data84_->call;
		_tmp5_ = rest_proxy_call_get_payload (_tmp4_);
		utils_show_error_object (_tmp5_, "Could not update profile", 128, "AccountDialog.vala");
		_g_error_free0 (e);
	}
	__finally108:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda160__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda160_ (self, source_object, res);
	block84_data_unref (self);
}


static Block85Data* block85_data_ref (Block85Data* _data85_) {
	g_atomic_int_inc (&_data85_->_ref_count_);
	return _data85_;
}


static void block85_data_unref (void * _userdata_) {
	Block85Data* _data85_;
	_data85_ = (Block85Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data85_->_ref_count_)) {
		AccountDialog* self;
		self = _data85_->self;
		_g_object_unref0 (_data85_->call);
		_g_object_unref0 (self);
		g_slice_free (Block85Data, _data85_);
	}
}


static void ___lambda161_ (Block85Data* _data85_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	cairo_surface_t* s = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	Account* _tmp6_ = NULL;
	cairo_surface_t* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data85_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data85_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch110_g_error;
		}
	}
	goto __finally110;
	__catch110_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data85_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		utils_show_error_object (_tmp3_, "Could not update your avatar", 160, "AccountDialog.vala");
		_g_error_free0 (e);
		return;
	}
	__finally110:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = self->priv->new_avatar;
	_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 1, NULL);
	s = _tmp5_;
	_tmp6_ = self->priv->account;
	_tmp7_ = s;
	account_set_new_avatar (_tmp6_, _tmp7_);
	_cairo_surface_destroy0 (s);
}


static void ____lambda161__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda161_ (self, source_object, res);
	block85_data_unref (self);
}


static Block86Data* block86_data_ref (Block86Data* _data86_) {
	g_atomic_int_inc (&_data86_->_ref_count_);
	return _data86_;
}


static void block86_data_unref (void * _userdata_) {
	Block86Data* _data86_;
	_data86_ = (Block86Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data86_->_ref_count_)) {
		AccountDialog* self;
		self = _data86_->self;
		_g_object_unref0 (_data86_->call);
		_g_object_unref0 (self);
		g_slice_free (Block86Data, _data86_);
	}
}


static void ___lambda162_ (Block86Data* _data86_, GObject* obj, GAsyncResult* res) {
	AccountDialog* self;
	GError * _inner_error_ = NULL;
	self = _data86_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data86_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch112_g_error;
		}
	}
	goto __finally112;
	__catch112_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data86_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		utils_show_error_object (_tmp3_, "Could not update your avatar", 192, "AccountDialog.vala");
		_g_error_free0 (e);
	}
	__finally112:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda162__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda162_ (self, source_object, res);
	block86_data_unref (self);
}


static void account_dialog_save_data (AccountDialog* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean needs_save = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean needs_init = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp28_ = FALSE;
	GdkPixbuf* _tmp66_ = NULL;
	GdkPixbuf* _tmp85_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp2_ = self->priv->old_user_name;
	_tmp3_ = self->priv->name_entry;
	_tmp4_ = gtk_entry_get_text (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp2_, _tmp5_) != 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp6_ = NULL;
		CompletionTextView* _tmp7_ = NULL;
		GtkTextBuffer* _tmp8_ = NULL;
		GtkTextBuffer* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp6_ = self->priv->old_description;
		_tmp7_ = self->priv->description_text_view;
		_tmp8_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_text_view_get_type (), GtkTextView));
		_tmp9_ = _tmp8_;
		g_object_get (_tmp9_, "text", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp1_ = g_strcmp0 (_tmp6_, _tmp12_) != 0;
		_g_free0 (_tmp12_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp13_ = NULL;
		GtkEntry* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp13_ = self->priv->old_website;
		_tmp14_ = self->priv->website_entry;
		_tmp15_ = gtk_entry_get_text (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp0_ = g_strcmp0 (_tmp13_, _tmp16_) != 0;
	}
	needs_save = _tmp0_;
	_tmp19_ = needs_save;
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		GdkPixbuf* _tmp20_ = NULL;
		_tmp20_ = self->priv->new_avatar;
		_tmp18_ = _tmp20_ != NULL;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GdkPixbuf* _tmp21_ = NULL;
		_tmp21_ = self->priv->new_banner;
		_tmp17_ = _tmp21_ != NULL;
	}
	needs_init = _tmp17_;
	_tmp23_ = needs_init;
	if (_tmp23_) {
		Account* _tmp24_ = NULL;
		OAuthProxy* _tmp25_ = NULL;
		OAuthProxy* _tmp26_ = NULL;
		_tmp24_ = self->priv->account;
		_tmp25_ = account_get_proxy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_ == NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		Account* _tmp27_ = NULL;
		_tmp27_ = self->priv->account;
		account_init_proxy (_tmp27_, TRUE, FALSE);
	}
	_tmp28_ = needs_save;
	if (_tmp28_) {
		Block84Data* _data84_;
		Account* _tmp29_ = NULL;
		OAuthProxy* _tmp30_ = NULL;
		OAuthProxy* _tmp31_ = NULL;
		RestProxyCall* _tmp32_ = NULL;
		RestProxyCall* _tmp33_ = NULL;
		RestProxyCall* _tmp34_ = NULL;
		RestProxyCall* _tmp35_ = NULL;
		GtkEntry* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		RestProxyCall* _tmp39_ = NULL;
		GtkEntry* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		RestProxyCall* _tmp43_ = NULL;
		CompletionTextView* _tmp44_ = NULL;
		GtkTextBuffer* _tmp45_ = NULL;
		GtkTextBuffer* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		RestProxyCall* _tmp50_ = NULL;
		Account* _tmp51_ = NULL;
		GtkEntry* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		Account* _tmp55_ = NULL;
		CompletionTextView* _tmp56_ = NULL;
		GtkTextBuffer* _tmp57_ = NULL;
		GtkTextBuffer* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		Account* _tmp62_ = NULL;
		GtkEntry* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		_data84_ = g_slice_new0 (Block84Data);
		_data84_->_ref_count_ = 1;
		_data84_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:115: Saving data...");
		_tmp29_ = self->priv->account;
		_tmp30_ = account_get_proxy (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, rest_proxy_get_type (), RestProxy));
		_data84_->call = _tmp32_;
		_tmp33_ = _data84_->call;
		rest_proxy_call_set_function (_tmp33_, "1.1/account/update_profile.json");
		_tmp34_ = _data84_->call;
		rest_proxy_call_set_method (_tmp34_, "POST");
		_tmp35_ = _data84_->call;
		_tmp36_ = self->priv->website_entry;
		_tmp37_ = gtk_entry_get_text (_tmp36_);
		_tmp38_ = _tmp37_;
		rest_proxy_call_add_param (_tmp35_, "url", _tmp38_);
		_tmp39_ = _data84_->call;
		_tmp40_ = self->priv->name_entry;
		_tmp41_ = gtk_entry_get_text (_tmp40_);
		_tmp42_ = _tmp41_;
		rest_proxy_call_add_param (_tmp39_, "name", _tmp42_);
		_tmp43_ = _data84_->call;
		_tmp44_ = self->priv->description_text_view;
		_tmp45_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_text_view_get_type (), GtkTextView));
		_tmp46_ = _tmp45_;
		g_object_get (_tmp46_, "text", &_tmp47_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		rest_proxy_call_add_param (_tmp43_, "description", _tmp49_);
		_g_free0 (_tmp49_);
		_tmp50_ = _data84_->call;
		rest_proxy_call_invoke_async (_tmp50_, NULL, ____lambda160__gasync_ready_callback, block84_data_ref (_data84_));
		_tmp51_ = self->priv->account;
		_tmp52_ = self->priv->name_entry;
		_tmp53_ = gtk_entry_get_text (_tmp52_);
		_tmp54_ = _tmp53_;
		account_set_name (_tmp51_, _tmp54_);
		_tmp55_ = self->priv->account;
		_tmp56_ = self->priv->description_text_view;
		_tmp57_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_text_view_get_type (), GtkTextView));
		_tmp58_ = _tmp57_;
		g_object_get (_tmp58_, "text", &_tmp59_, NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = _tmp60_;
		account_set_description (_tmp55_, _tmp61_);
		_g_free0 (_tmp61_);
		_tmp62_ = self->priv->account;
		_tmp63_ = self->priv->website_entry;
		_tmp64_ = gtk_entry_get_text (_tmp63_);
		_tmp65_ = _tmp64_;
		account_set_website (_tmp62_, _tmp65_);
		block84_data_unref (_data84_);
		_data84_ = NULL;
	}
	_tmp66_ = self->priv->new_avatar;
	if (_tmp66_ != NULL) {
		Block85Data* _data85_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		gchar* b64 = NULL;
		guint8* _tmp72_ = NULL;
		gint _tmp72__length1 = 0;
		gchar* _tmp73_ = NULL;
		Account* _tmp74_ = NULL;
		OAuthProxy* _tmp75_ = NULL;
		OAuthProxy* _tmp76_ = NULL;
		RestProxyCall* _tmp77_ = NULL;
		RestProxyCall* _tmp78_ = NULL;
		RestProxyCall* _tmp79_ = NULL;
		RestProxyCall* _tmp80_ = NULL;
		RestProxyCall* _tmp81_ = NULL;
		RestProxyCall* _tmp82_ = NULL;
		const gchar* _tmp83_ = NULL;
		RestProxyCall* _tmp84_ = NULL;
		_data85_ = g_slice_new0 (Block85Data);
		_data85_->_ref_count_ = 1;
		_data85_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:139: Updating avatar...");
		{
			GdkPixbuf* _tmp67_ = NULL;
			guint8* _tmp68_ = NULL;
			gsize _tmp69_;
			_tmp67_ = self->priv->new_avatar;
			gdk_pixbuf_save_to_buffer (_tmp67_, (gchar**) (&_tmp68_), &_tmp69_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp68_;
			buffer_length1 = _tmp69_;
			_buffer_size_ = buffer_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch109_g_error;
			}
		}
		goto __finally109;
		__catch109_g_error:
		{
			GError* e = NULL;
			GError* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp70_ = e;
			_tmp71_ = _tmp70_->message;
			g_warning ("AccountDialog.vala:144: %s", _tmp71_);
			_g_error_free0 (e);
			buffer = (g_free (buffer), NULL);
			block85_data_unref (_data85_);
			_data85_ = NULL;
			return;
		}
		__finally109:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			buffer = (g_free (buffer), NULL);
			block85_data_unref (_data85_);
			_data85_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp72_ = buffer;
		_tmp72__length1 = buffer_length1;
		_tmp73_ = g_base64_encode (_tmp72_, _tmp72__length1);
		b64 = _tmp73_;
		_tmp74_ = self->priv->account;
		_tmp75_ = account_get_proxy (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, rest_proxy_get_type (), RestProxy));
		_data85_->call = _tmp77_;
		_tmp78_ = _data85_->call;
		rest_proxy_call_set_function (_tmp78_, "1.1/account/update_profile_image.json");
		_tmp79_ = _data85_->call;
		rest_proxy_call_set_method (_tmp79_, "POST");
		_tmp80_ = _data85_->call;
		rest_proxy_call_add_param (_tmp80_, "skip_status", "true");
		_tmp81_ = _data85_->call;
		rest_proxy_call_add_param (_tmp81_, "include_entities", "false");
		_tmp82_ = _data85_->call;
		_tmp83_ = b64;
		rest_proxy_call_add_param (_tmp82_, "image", _tmp83_);
		_tmp84_ = _data85_->call;
		rest_proxy_call_invoke_async (_tmp84_, NULL, ____lambda161__gasync_ready_callback, block85_data_ref (_data85_));
		_g_free0 (b64);
		buffer = (g_free (buffer), NULL);
		block85_data_unref (_data85_);
		_data85_ = NULL;
	}
	_tmp85_ = self->priv->new_banner;
	if (_tmp85_ != NULL) {
		Block86Data* _data86_;
		guint8* buffer = NULL;
		gint buffer_length1 = 0;
		gint _buffer_size_ = 0;
		gchar* b64 = NULL;
		guint8* _tmp91_ = NULL;
		gint _tmp91__length1 = 0;
		gchar* _tmp92_ = NULL;
		Account* _tmp93_ = NULL;
		OAuthProxy* _tmp94_ = NULL;
		OAuthProxy* _tmp95_ = NULL;
		RestProxyCall* _tmp96_ = NULL;
		RestProxyCall* _tmp97_ = NULL;
		RestProxyCall* _tmp98_ = NULL;
		RestProxyCall* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		RestProxyCall* _tmp101_ = NULL;
		_data86_ = g_slice_new0 (Block86Data);
		_data86_->_ref_count_ = 1;
		_data86_->self = g_object_ref (self);
		g_debug ("AccountDialog.vala:171: Updating banner...");
		{
			GdkPixbuf* _tmp86_ = NULL;
			guint8* _tmp87_ = NULL;
			gsize _tmp88_;
			_tmp86_ = self->priv->new_banner;
			gdk_pixbuf_save_to_buffer (_tmp86_, (gchar**) (&_tmp87_), &_tmp88_, "png", &_inner_error_, NULL, NULL);
			buffer = (g_free (buffer), NULL);
			buffer = _tmp87_;
			buffer_length1 = _tmp88_;
			_buffer_size_ = buffer_length1;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch111_g_error;
			}
		}
		goto __finally111;
		__catch111_g_error:
		{
			GError* e = NULL;
			GError* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp89_ = e;
			_tmp90_ = _tmp89_->message;
			g_warning ("AccountDialog.vala:177: %s", _tmp90_);
			_g_error_free0 (e);
			buffer = (g_free (buffer), NULL);
			block86_data_unref (_data86_);
			_data86_ = NULL;
			return;
		}
		__finally111:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			buffer = (g_free (buffer), NULL);
			block86_data_unref (_data86_);
			_data86_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp91_ = buffer;
		_tmp91__length1 = buffer_length1;
		_tmp92_ = g_base64_encode (_tmp91_, _tmp91__length1);
		b64 = _tmp92_;
		_tmp93_ = self->priv->account;
		_tmp94_ = account_get_proxy (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, rest_proxy_get_type (), RestProxy));
		_data86_->call = _tmp96_;
		_tmp97_ = _data86_->call;
		rest_proxy_call_set_function (_tmp97_, "1.1/account/update_profile_banner.json");
		_tmp98_ = _data86_->call;
		rest_proxy_call_set_method (_tmp98_, "POST");
		_tmp99_ = _data86_->call;
		_tmp100_ = b64;
		rest_proxy_call_add_param (_tmp99_, "banner", _tmp100_);
		_tmp101_ = _data86_->call;
		rest_proxy_call_invoke_async (_tmp101_, NULL, ____lambda162__gasync_ready_callback, block86_data_ref (_data86_));
		_g_free0 (b64);
		buffer = (g_free (buffer), NULL);
		block86_data_unref (_data86_);
		_data86_ = NULL;
	}
}


static void account_dialog_delete_confirm_button_clicked_cb (AccountDialog* self) {
	GMenu* acc_menu = NULL;
	GMenu* _tmp0_ = NULL;
	GMenu* _tmp1_ = NULL;
	gint64 acc_id = 0LL;
	Account* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gint64 _tmp19_ = 0LL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	SqlDatabase* _tmp26_ = NULL;
	gint64 _tmp27_ = 0LL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp32_ = NULL;
	GSettings* _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gchar** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	Corebird* cb = NULL;
	GApplication* _tmp94_ = NULL;
	Corebird* _tmp95_ = NULL;
	GList* windows = NULL;
	Corebird* _tmp96_ = NULL;
	GList* _tmp97_ = NULL;
	GtkWindow* account_window = NULL;
	gint n_main_windows = 0;
	GList* _tmp98_ = NULL;
	gint _tmp112_ = 0;
	GtkWindow* _tmp113_ = NULL;
	Account* acc_to_remove = NULL;
	Account* _tmp118_ = NULL;
	gint64 _tmp119_ = 0LL;
	gint64 _tmp120_ = 0LL;
	Account* _tmp121_ = NULL;
	Account* _tmp122_ = NULL;
	Corebird* _tmp123_ = NULL;
	Account* _tmp124_ = NULL;
	const gchar* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = corebird_account_menu;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_menu_get_type (), GMenu));
	acc_menu = _tmp1_;
	_tmp2_ = self->priv->account;
	_tmp3_ = account_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	acc_id = _tmp4_;
	_tmp5_ = acc_id;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("accounts/", _tmp7_, ".db", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = dirs_config (_tmp9_);
	_tmp11_ = _tmp10_;
	g_remove (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_tmp12_ = acc_id;
	_tmp13_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat ("accounts/", _tmp14_, ".png", NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = dirs_config (_tmp16_);
	_tmp18_ = _tmp17_;
	g_remove (_tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_tmp19_ = acc_id;
	_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat ("accounts/", _tmp21_, "_small.png", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = dirs_config (_tmp23_);
	_tmp25_ = _tmp24_;
	g_remove (_tmp25_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_tmp26_ = corebird_db;
	_tmp27_ = acc_id;
	_tmp28_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strconcat ("DELETE FROM `accounts` WHERE `id`='", _tmp29_, "';", NULL);
	_tmp31_ = _tmp30_;
	sql_database_exec (_tmp26_, _tmp31_, NULL, NULL);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp32_ = settings_get ();
	_tmp33_ = _tmp32_;
	_tmp35_ = _tmp34_ = g_settings_get_strv (_tmp33_, "startup-accounts");
	_tmp36_ = _tmp35_;
	_tmp36__length1 = _vala_array_length (_tmp34_);
	_g_object_unref0 (_tmp33_);
	startup_accounts = _tmp36_;
	startup_accounts_length1 = _tmp36__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				gint _tmp39_ = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				gint _tmp42_ = 0;
				const gchar* _tmp43_ = NULL;
				Account* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				if (!_tmp37_) {
					gint _tmp38_ = 0;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				_tmp39_ = i;
				_tmp40_ = startup_accounts;
				_tmp40__length1 = startup_accounts_length1;
				if (!(_tmp39_ < _tmp40__length1)) {
					break;
				}
				_tmp41_ = startup_accounts;
				_tmp41__length1 = startup_accounts_length1;
				_tmp42_ = i;
				_tmp43_ = _tmp41_[_tmp42_];
				_tmp44_ = self->priv->account;
				_tmp45_ = account_get_screen_name (_tmp44_);
				_tmp46_ = _tmp45_;
				if (g_strcmp0 (_tmp43_, _tmp46_) == 0) {
					gchar** sa_new = NULL;
					gchar** _tmp47_ = NULL;
					gint _tmp47__length1 = 0;
					gchar** _tmp48_ = NULL;
					gint sa_new_length1 = 0;
					gint _sa_new_size_ = 0;
					GSettings* _tmp72_ = NULL;
					GSettings* _tmp73_ = NULL;
					gchar** _tmp74_ = NULL;
					gint _tmp74__length1 = 0;
					_tmp47_ = startup_accounts;
					_tmp47__length1 = startup_accounts_length1;
					_tmp48_ = g_new0 (gchar*, (_tmp47__length1 - 1) + 1);
					sa_new = _tmp48_;
					sa_new_length1 = _tmp47__length1 - 1;
					_sa_new_size_ = sa_new_length1;
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp49_ = FALSE;
							_tmp49_ = TRUE;
							while (TRUE) {
								gint _tmp51_ = 0;
								gint _tmp52_ = 0;
								gchar** _tmp53_ = NULL;
								gint _tmp53__length1 = 0;
								gint _tmp54_ = 0;
								gchar** _tmp55_ = NULL;
								gint _tmp55__length1 = 0;
								gint _tmp56_ = 0;
								const gchar* _tmp57_ = NULL;
								gchar* _tmp58_ = NULL;
								gchar* _tmp59_ = NULL;
								if (!_tmp49_) {
									gint _tmp50_ = 0;
									_tmp50_ = i;
									i = _tmp50_ + 1;
								}
								_tmp49_ = FALSE;
								_tmp51_ = x;
								_tmp52_ = i;
								if (!(_tmp51_ < _tmp52_)) {
									break;
								}
								_tmp53_ = sa_new;
								_tmp53__length1 = sa_new_length1;
								_tmp54_ = x;
								_tmp55_ = startup_accounts;
								_tmp55__length1 = startup_accounts_length1;
								_tmp56_ = x;
								_tmp57_ = _tmp55_[_tmp56_];
								_tmp58_ = g_strdup (_tmp57_);
								_g_free0 (_tmp53_[_tmp54_]);
								_tmp53_[_tmp54_] = _tmp58_;
								_tmp59_ = _tmp53_[_tmp54_];
							}
						}
					}
					{
						gint x = 0;
						gint _tmp60_ = 0;
						_tmp60_ = i;
						x = _tmp60_ + 1;
						{
							gboolean _tmp61_ = FALSE;
							_tmp61_ = TRUE;
							while (TRUE) {
								gint _tmp63_ = 0;
								gchar** _tmp64_ = NULL;
								gint _tmp64__length1 = 0;
								gchar** _tmp65_ = NULL;
								gint _tmp65__length1 = 0;
								gint _tmp66_ = 0;
								gchar** _tmp67_ = NULL;
								gint _tmp67__length1 = 0;
								gint _tmp68_ = 0;
								const gchar* _tmp69_ = NULL;
								gchar* _tmp70_ = NULL;
								gchar* _tmp71_ = NULL;
								if (!_tmp61_) {
									gint _tmp62_ = 0;
									_tmp62_ = x;
									x = _tmp62_ + 1;
								}
								_tmp61_ = FALSE;
								_tmp63_ = x;
								_tmp64_ = startup_accounts;
								_tmp64__length1 = startup_accounts_length1;
								if (!(_tmp63_ < _tmp64__length1)) {
									break;
								}
								_tmp65_ = sa_new;
								_tmp65__length1 = sa_new_length1;
								_tmp66_ = x;
								_tmp67_ = startup_accounts;
								_tmp67__length1 = startup_accounts_length1;
								_tmp68_ = x;
								_tmp69_ = _tmp67_[_tmp68_];
								_tmp70_ = g_strdup (_tmp69_);
								_g_free0 (_tmp65_[_tmp66_]);
								_tmp65_[_tmp66_] = _tmp70_;
								_tmp71_ = _tmp65_[_tmp66_];
							}
						}
					}
					_tmp72_ = settings_get ();
					_tmp73_ = _tmp72_;
					_tmp74_ = sa_new;
					_tmp74__length1 = sa_new_length1;
					g_settings_set_strv (_tmp73_, "startup-accounts", _tmp74_);
					_g_object_unref0 (_tmp73_);
					sa_new = (_vala_array_free (sa_new, sa_new_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp75_ = FALSE;
			_tmp75_ = TRUE;
			while (TRUE) {
				gint _tmp77_ = 0;
				GMenu* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				GVariant* item_name = NULL;
				GMenu* _tmp80_ = NULL;
				gint _tmp81_ = 0;
				const GVariantType* _tmp82_ = NULL;
				GVariant* _tmp83_ = NULL;
				GVariant* _tmp84_ = NULL;
				const gchar* _tmp85_ = NULL;
				Account* _tmp86_ = NULL;
				const gchar* _tmp87_ = NULL;
				const gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				gchar* _tmp90_ = NULL;
				gboolean _tmp91_ = FALSE;
				if (!_tmp75_) {
					gint _tmp76_ = 0;
					_tmp76_ = i;
					i = _tmp76_ + 1;
				}
				_tmp75_ = FALSE;
				_tmp77_ = i;
				_tmp78_ = acc_menu;
				_tmp79_ = g_menu_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, g_menu_model_get_type (), GMenuModel));
				if (!(_tmp77_ < _tmp79_)) {
					break;
				}
				_tmp80_ = acc_menu;
				_tmp81_ = i;
				_tmp82_ = G_VARIANT_TYPE_STRING;
				_tmp83_ = g_menu_model_get_item_attribute_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, g_menu_model_get_type (), GMenuModel), _tmp81_, "label", _tmp82_);
				item_name = _tmp83_;
				_tmp84_ = item_name;
				_tmp85_ = g_variant_get_string (_tmp84_, NULL);
				_tmp86_ = self->priv->account;
				_tmp87_ = account_get_screen_name (_tmp86_);
				_tmp88_ = _tmp87_;
				_tmp89_ = g_strconcat ("@", _tmp88_, NULL);
				_tmp90_ = _tmp89_;
				_tmp91_ = g_strcmp0 (_tmp85_, _tmp90_) == 0;
				_g_free0 (_tmp90_);
				if (_tmp91_) {
					GMenu* _tmp92_ = NULL;
					gint _tmp93_ = 0;
					_tmp92_ = acc_menu;
					_tmp93_ = i;
					g_menu_remove (_tmp92_, _tmp93_);
					_g_variant_unref0 (item_name);
					break;
				}
				_g_variant_unref0 (item_name);
			}
		}
	}
	_tmp94_ = g_application_get_default ();
	_tmp95_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, TYPE_COREBIRD, Corebird));
	cb = _tmp95_;
	_tmp96_ = cb;
	_tmp97_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_application_get_type (), GtkApplication));
	windows = _tmp97_;
	account_window = NULL;
	n_main_windows = 0;
	_tmp98_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp98_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp99_ = NULL;
			GtkWindow* win = NULL;
			_tmp99_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp99_;
			{
				GtkWindow* _tmp100_ = NULL;
				_tmp100_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, TYPE_MAIN_WINDOW)) {
					gint _tmp101_ = 0;
					GtkWindow* _tmp102_ = NULL;
					Account* _tmp103_ = NULL;
					Account* _tmp104_ = NULL;
					gint64 _tmp105_ = 0LL;
					gint64 _tmp106_ = 0LL;
					Account* _tmp107_ = NULL;
					gint64 _tmp108_ = 0LL;
					gint64 _tmp109_ = 0LL;
					_tmp101_ = n_main_windows;
					n_main_windows = _tmp101_ + 1;
					_tmp102_ = win;
					_tmp103_ = main_window_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, TYPE_MAIN_WINDOW, MainWindow));
					_tmp104_ = _tmp103_;
					_tmp105_ = account_get_id (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = self->priv->account;
					_tmp108_ = account_get_id (_tmp107_);
					_tmp109_ = _tmp108_;
					if (_tmp106_ == _tmp109_) {
						GtkWindow* _tmp110_ = NULL;
						GtkWindow* _tmp111_ = NULL;
						_tmp110_ = win;
						_tmp111_ = _g_object_ref0 (_tmp110_);
						_g_object_unref0 (account_window);
						account_window = _tmp111_;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp112_ = n_main_windows;
	g_debug ("AccountDialog.vala:253: Open main windows: %d", _tmp112_);
	_tmp113_ = account_window;
	if (_tmp113_ != NULL) {
		gint _tmp114_ = 0;
		_tmp114_ = n_main_windows;
		if (_tmp114_ > 1) {
			GtkWindow* _tmp115_ = NULL;
			_tmp115_ = account_window;
			gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_widget_get_type (), GtkWidget));
		} else {
			GtkWindow* _tmp116_ = NULL;
			GApplication* _tmp117_ = NULL;
			_tmp116_ = account_window;
			_tmp117_ = g_application_get_default ();
			main_window_change_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, TYPE_MAIN_WINDOW, MainWindow), NULL, _tmp117_);
		}
	}
	_tmp118_ = self->priv->account;
	_tmp119_ = account_get_id (_tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = account_query_account_by_id (_tmp120_);
	_tmp122_ = _g_object_ref0 (_tmp121_);
	acc_to_remove = _tmp122_;
	_tmp123_ = cb;
	g_signal_emit_by_name (_tmp123_, "account-removed", acc_to_remove);
	_tmp124_ = self->priv->account;
	_tmp125_ = account_get_screen_name (_tmp124_);
	_tmp126_ = _tmp125_;
	account_remove_account (_tmp126_);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (acc_to_remove);
	_g_object_unref0 (account_window);
	_g_object_unref0 (cb);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (acc_menu);
}


static void _account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_confirm_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_delete_cancel_button_clicked_cb (AccountDialog* self) {
	GtkStack* _tmp0_ = NULL;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->delete_stack;
	gtk_stack_set_visible_child_name (_tmp0_, ACCOUNT_DIALOG_PAGE_NORMAL);
}


static void _account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	account_dialog_delete_cancel_button_clicked_cb ((AccountDialog*) self);
}


static void account_dialog_autostart_switch_activate_cb (AccountDialog* self) {
	gboolean active = FALSE;
	GtkSwitch* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** startup_accounts = NULL;
	GSettings* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_ACCOUNT_DIALOG (self));
	_tmp0_ = self->priv->autostart_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	_tmp3_ = settings_get ();
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "startup-accounts");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	_g_object_unref0 (_tmp4_);
	startup_accounts = _tmp7_;
	startup_accounts_length1 = _tmp7__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp8_ = active;
	if (_tmp8_) {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gchar** new_startup_accounts = NULL;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		gchar** _tmp16_ = NULL;
		gint new_startup_accounts_length1 = 0;
		gint _new_startup_accounts_size_ = 0;
		gint i = 0;
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		Account* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		GSettings* _tmp32_ = NULL;
		GSettings* _tmp33_ = NULL;
		gchar** _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		_tmp9_ = startup_accounts;
		_tmp9__length1 = startup_accounts_length1;
		{
			gchar** acc_collection = NULL;
			gint acc_collection_length1 = 0;
			gint _acc_collection_size_ = 0;
			gint acc_it = 0;
			acc_collection = _tmp9_;
			acc_collection_length1 = _tmp9__length1;
			for (acc_it = 0; acc_it < _tmp9__length1; acc_it = acc_it + 1) {
				gchar* _tmp10_ = NULL;
				gchar* acc = NULL;
				_tmp10_ = g_strdup (acc_collection[acc_it]);
				acc = _tmp10_;
				{
					const gchar* _tmp11_ = NULL;
					Account* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					_tmp11_ = acc;
					_tmp12_ = self->priv->account;
					_tmp13_ = account_get_screen_name (_tmp12_);
					_tmp14_ = _tmp13_;
					if (g_strcmp0 (_tmp11_, _tmp14_) == 0) {
						_g_free0 (acc);
						startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
						return;
					}
					_g_free0 (acc);
				}
			}
		}
		_tmp15_ = startup_accounts;
		_tmp15__length1 = startup_accounts_length1;
		_tmp16_ = g_new0 (gchar*, (_tmp15__length1 + 1) + 1);
		new_startup_accounts = _tmp16_;
		new_startup_accounts_length1 = _tmp15__length1 + 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		i = 0;
		_tmp17_ = startup_accounts;
		_tmp17__length1 = startup_accounts_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp17_;
			s_collection_length1 = _tmp17__length1;
			for (s_it = 0; s_it < _tmp17__length1; s_it = s_it + 1) {
				gchar* _tmp18_ = NULL;
				gchar* s = NULL;
				_tmp18_ = g_strdup (s_collection[s_it]);
				s = _tmp18_;
				{
					gchar** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					const gchar* _tmp21_ = NULL;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					_tmp19_ = new_startup_accounts;
					_tmp19__length1 = new_startup_accounts_length1;
					_tmp20_ = i;
					_tmp21_ = s;
					_tmp22_ = g_strdup (_tmp21_);
					_g_free0 (_tmp19_[_tmp20_]);
					_tmp19_[_tmp20_] = _tmp22_;
					_tmp23_ = _tmp19_[_tmp20_];
					_tmp24_ = i;
					i = _tmp24_ + 1;
					_g_free0 (s);
				}
			}
		}
		_tmp25_ = new_startup_accounts;
		_tmp25__length1 = new_startup_accounts_length1;
		_tmp26_ = new_startup_accounts;
		_tmp26__length1 = new_startup_accounts_length1;
		_tmp27_ = self->priv->account;
		_tmp28_ = account_get_screen_name (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (_tmp25_[_tmp26__length1 - 1]);
		_tmp25_[_tmp26__length1 - 1] = _tmp30_;
		_tmp31_ = _tmp25_[_tmp26__length1 - 1];
		_tmp32_ = settings_get ();
		_tmp33_ = _tmp32_;
		_tmp34_ = new_startup_accounts;
		_tmp34__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp33_, "startup-accounts", _tmp34_);
		_g_object_unref0 (_tmp33_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar** new_startup_accounts = NULL;
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gchar** _tmp36_ = NULL;
		gint new_startup_accounts_length1 = 0;
		gint _new_startup_accounts_size_ = 0;
		gint i = 0;
		gchar** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		GSettings* _tmp49_ = NULL;
		GSettings* _tmp50_ = NULL;
		gchar** _tmp51_ = NULL;
		gint _tmp51__length1 = 0;
		_tmp35_ = startup_accounts;
		_tmp35__length1 = startup_accounts_length1;
		_tmp36_ = g_new0 (gchar*, (_tmp35__length1 - 1) + 1);
		new_startup_accounts = _tmp36_;
		new_startup_accounts_length1 = _tmp35__length1 - 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		i = 0;
		_tmp37_ = startup_accounts;
		_tmp37__length1 = startup_accounts_length1;
		{
			gchar** acc_collection = NULL;
			gint acc_collection_length1 = 0;
			gint _acc_collection_size_ = 0;
			gint acc_it = 0;
			acc_collection = _tmp37_;
			acc_collection_length1 = _tmp37__length1;
			for (acc_it = 0; acc_it < _tmp37__length1; acc_it = acc_it + 1) {
				gchar* _tmp38_ = NULL;
				gchar* acc = NULL;
				_tmp38_ = g_strdup (acc_collection[acc_it]);
				acc = _tmp38_;
				{
					const gchar* _tmp39_ = NULL;
					Account* _tmp40_ = NULL;
					const gchar* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					_tmp39_ = acc;
					_tmp40_ = self->priv->account;
					_tmp41_ = account_get_screen_name (_tmp40_);
					_tmp42_ = _tmp41_;
					if (g_strcmp0 (_tmp39_, _tmp42_) != 0) {
						gchar** _tmp43_ = NULL;
						gint _tmp43__length1 = 0;
						gint _tmp44_ = 0;
						const gchar* _tmp45_ = NULL;
						gchar* _tmp46_ = NULL;
						gchar* _tmp47_ = NULL;
						gint _tmp48_ = 0;
						_tmp43_ = new_startup_accounts;
						_tmp43__length1 = new_startup_accounts_length1;
						_tmp44_ = i;
						_tmp45_ = acc;
						_tmp46_ = g_strdup (_tmp45_);
						_g_free0 (_tmp43_[_tmp44_]);
						_tmp43_[_tmp44_] = _tmp46_;
						_tmp47_ = _tmp43_[_tmp44_];
						_tmp48_ = i;
						i = _tmp48_ + 1;
					}
					_g_free0 (acc);
				}
			}
		}
		_tmp49_ = settings_get ();
		_tmp50_ = _tmp49_;
		_tmp51_ = new_startup_accounts;
		_tmp51__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp50_, "startup-accounts", _tmp51_);
		_g_object_unref0 (_tmp50_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static void _account_dialog_autostart_switch_activate_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	account_dialog_autostart_switch_activate_cb ((AccountDialog*) self);
}


static void account_dialog_class_init (AccountDialogClass * klass) {
	gint AccountDialog_private_offset;
	account_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AccountDialogPrivate));
	((GtkDialogClass *) klass)->response = account_dialog_real_response;
	G_OBJECT_CLASS (klass)->finalize = account_dialog_finalize;
	AccountDialog_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/account-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_banner_widget", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, avatar_banner_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_stack", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, delete_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "autostart_switch", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, autostart_switch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "website_entry", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, website_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_text_view", FALSE, AccountDialog_private_offset + G_STRUCT_OFFSET (AccountDialogPrivate, description_text_view));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_button_clicked_cb", G_CALLBACK(_account_dialog_delete_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_confirm_button_clicked_cb", G_CALLBACK(_account_dialog_delete_confirm_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_cancel_button_clicked_cb", G_CALLBACK(_account_dialog_delete_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "autostart_switch_activate_cb", G_CALLBACK(_account_dialog_autostart_switch_activate_cb_g_object_notify));
}


static void account_dialog_instance_init (AccountDialog * self) {
	self->priv = ACCOUNT_DIALOG_GET_PRIVATE (self);
	self->priv->new_avatar = NULL;
	self->priv->new_banner = NULL;
	g_type_ensure (TYPE_AVATAR_BANNER_WIDGET);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void account_dialog_finalize (GObject* obj) {
	AccountDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ACCOUNT_DIALOG, AccountDialog);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->avatar_banner_widget);
	_g_object_unref0 (self->priv->delete_stack);
	_g_object_unref0 (self->priv->autostart_switch);
	_g_object_unref0 (self->priv->website_entry);
	_g_object_unref0 (self->priv->description_text_view);
	_g_free0 (self->priv->old_user_name);
	_g_free0 (self->priv->old_description);
	_g_free0 (self->priv->old_website);
	_g_object_unref0 (self->priv->new_avatar);
	_g_object_unref0 (self->priv->new_banner);
	G_OBJECT_CLASS (account_dialog_parent_class)->finalize (obj);
}


GType account_dialog_get_type (void) {
	static volatile gsize account_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&account_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AccountDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AccountDialog), 0, (GInstanceInitFunc) account_dialog_instance_init, NULL };
		GType account_dialog_type_id;
		account_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "AccountDialog", &g_define_type_info, 0);
		g_once_init_leave (&account_dialog_type_id__volatile, account_dialog_type_id);
	}
	return account_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



