/* dummy-persona.c generated by valac 0.27.1.3-6129, the Vala compiler
 * generated from dummy-persona.vala, do not modify */

/*
 * Copyright (C) 2013 Philip Withnall
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/small-set.h>
#include <folks-internal.h>
#include <gio/gio.h>


#define FOLKS_DUMMY_TYPE_PERSONA (folks_dummy_persona_get_type ())
#define FOLKS_DUMMY_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona))
#define FOLKS_DUMMY_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersonaClass))
#define FOLKS_DUMMY_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_DUMMY_TYPE_PERSONA))
#define FOLKS_DUMMY_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_DUMMY_TYPE_PERSONA))
#define FOLKS_DUMMY_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersonaClass))

typedef struct _FolksDummyPersona FolksDummyPersona;
typedef struct _FolksDummyPersonaClass FolksDummyPersonaClass;
typedef struct _FolksDummyPersonaPrivate FolksDummyPersonaPrivate;

#define FOLKS_DUMMY_TYPE_PERSONA_STORE (folks_dummy_persona_store_get_type ())
#define FOLKS_DUMMY_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStore))
#define FOLKS_DUMMY_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStoreClass))
#define FOLKS_DUMMY_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE))
#define FOLKS_DUMMY_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_DUMMY_TYPE_PERSONA_STORE))
#define FOLKS_DUMMY_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_DUMMY_TYPE_PERSONA_STORE, FolksDummyPersonaStoreClass))

typedef struct _FolksDummyPersonaStore FolksDummyPersonaStore;
typedef struct _FolksDummyPersonaStoreClass FolksDummyPersonaStoreClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _FolksDummyPersonaChangePropertyData FolksDummyPersonaChangePropertyData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksDummyPersona {
	FolksPersona parent_instance;
	FolksDummyPersonaPrivate * priv;
};

struct _FolksDummyPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksDummyPersonaPrivate {
	gchar** _linkable_properties;
	gint _linkable_properties_length1;
	gint __linkable_properties_size_;
	gchar** _writeable_properties;
	gint _writeable_properties_length1;
	gint __writeable_properties_size_;
	gint _property_change_delay;
};

typedef void (*FolksDummyPersonaChangePropertyCallback) (void* user_data);
struct _Block1Data {
	int _ref_count_;
	FolksDummyPersona* self;
	FolksDummyPersonaChangePropertyCallback callback;
	gpointer callback_target;
	gpointer _async_data_;
};

struct _FolksDummyPersonaChangePropertyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksDummyPersona* self;
	gchar* property_name;
	FolksDummyPersonaChangePropertyCallback callback;
	gpointer callback_target;
	Block1Data* _data1_;
	FolksDummyPersonaChangePropertyCallback _tmp0_;
	void* _tmp0__target;
	gint _tmp1_;
	FolksDummyPersonaChangePropertyCallback _tmp2_;
	void* _tmp2__target;
	gint _tmp3_;
	gint _tmp4_;
};


static gpointer folks_dummy_persona_parent_class = NULL;

GType folks_dummy_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_DUMMY_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersonaPrivate))
enum  {
	FOLKS_DUMMY_PERSONA_DUMMY_PROPERTY,
	FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES,
	FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY
};
GType folks_dummy_persona_store_get_type (void) G_GNUC_CONST;
FolksDummyPersona* folks_dummy_persona_new (FolksDummyPersonaStore* store, const gchar* contact_id, gboolean is_user, gchar** linkable_properties, int linkable_properties_length1);
FolksDummyPersona* folks_dummy_persona_construct (GType object_type, FolksDummyPersonaStore* store, const gchar* contact_id, gboolean is_user, gchar** linkable_properties, int linkable_properties_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void folks_dummy_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
void folks_dummy_persona_update_writeable_properties (FolksDummyPersona* self, gchar** writeable_properties, int writeable_properties_length1);
void folks_dummy_persona_update_linkable_properties (FolksDummyPersona* self, gchar** linkable_properties, int linkable_properties_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void folks_dummy_persona_change_property_data_free (gpointer _data);
void folks_dummy_persona_change_property (FolksDummyPersona* self, const gchar* property_name, FolksDummyPersonaChangePropertyCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_dummy_persona_change_property_finish (FolksDummyPersona* self, GAsyncResult* _res_);
static gboolean folks_dummy_persona_change_property_co (FolksDummyPersonaChangePropertyData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
gint folks_dummy_persona_get_property_change_delay (FolksDummyPersona* self);
static gboolean ____lambda4_ (Block1Data* _data1_);
static gboolean _____lambda4__gsource_func (gpointer self);
static gboolean ____lambda5_ (Block1Data* _data1_);
static gboolean _____lambda5__gsource_func (gpointer self);
void folks_dummy_persona_set_property_change_delay (FolksDummyPersona* self, gint value);
static void folks_dummy_persona_finalize (GObject* obj);
static void _vala_folks_dummy_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_dummy_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link FolksDummy.PersonaStore} ``store``,
   * with the given construct-only properties.
   *
   * The persona’s {@link Folks.Persona.writeable_properties} are initialised to
   * the given ``store``’s
   * {@link Folks.PersonaStore.always_writeable_properties}. They may be updated
   * afterwards using {@link FolksDummy.Persona.update_writeable_properties}.
   *
   * @param store the store which will contain the persona
   * @param contact_id a unique free-form string identifier for the persona
   * @param is_user ``true`` if the persona represents the user, ``false``
   * otherwise
   * @param linkable_properties an array of names of the properties which should
   * be used for linking this persona to others
   *
   * @since 0.9.7
   */
static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


FolksDummyPersona* folks_dummy_persona_construct (GType object_type, FolksDummyPersonaStore* store, const gchar* contact_id, gboolean is_user, gchar** linkable_properties, int linkable_properties_length1) {
	FolksDummyPersona * self = NULL;
	gchar* uid = NULL;
	FolksDummyPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* iid = NULL;
	FolksDummyPersonaStore* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	FolksDummyPersonaStore* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	FolksPersonaStore* _tmp18_ = NULL;
	FolksPersonaStore* _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (contact_id != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = contact_id;
	_tmp4_ = folks_persona_build_uid (BACKEND_NAME, _tmp2_, _tmp3_);
	uid = _tmp4_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ":", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = contact_id;
	_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp9_);
	iid = _tmp12_;
	_tmp13_ = contact_id;
	_tmp14_ = store;
	_tmp15_ = is_user;
	self = (FolksDummyPersona*) g_object_new (object_type, "display-id", _tmp13_, "uid", uid, "iid", iid, "store", _tmp14_, "is-user", _tmp15_, NULL);
	_tmp16_ = linkable_properties;
	_tmp16__length1 = linkable_properties_length1;
	_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup1 (_tmp16_, _tmp16__length1) : ((gpointer) _tmp16_);
	_tmp17__length1 = _tmp16__length1;
	self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_linkable_properties = _tmp17_;
	self->priv->_linkable_properties_length1 = _tmp17__length1;
	self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1;
	_tmp18_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = folks_persona_store_get_always_writeable_properties (_tmp19_, &_tmp20__length1);
	_tmp21_ = _tmp20_;
	_tmp21__length1 = _tmp20__length1;
	_tmp22_ = (_tmp21_ != NULL) ? _vala_array_dup2 (_tmp21_, _tmp21__length1) : ((gpointer) _tmp21_);
	_tmp22__length1 = _tmp21__length1;
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = _tmp22_;
	self->priv->_writeable_properties_length1 = _tmp22__length1;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
	_g_free0 (iid);
	_g_free0 (uid);
	return self;
}


FolksDummyPersona* folks_dummy_persona_new (FolksDummyPersonaStore* store, const gchar* contact_id, gboolean is_user, gchar** linkable_properties, int linkable_properties_length1) {
	return folks_dummy_persona_construct (FOLKS_DUMMY_TYPE_PERSONA, store, contact_id, is_user, linkable_properties, linkable_properties_length1);
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.7
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_dummy_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksDummyPersona * self;
	const gchar* _tmp0_ = NULL;
	self = (FolksDummyPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "im-addresses") == 0) {
		FolksImDetails* persona = NULL;
		FolksImDetails* _tmp1_ = NULL;
		FolksImDetails* _tmp2_ = NULL;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) self) : NULL);
		persona = _tmp1_;
		_tmp2_ = persona;
		_vala_assert (_tmp2_ != NULL, "persona != null");
		{
			GeeIterator* _protocol_it = NULL;
			FolksImDetails* _tmp3_ = NULL;
			GeeMultiMap* _tmp4_ = NULL;
			GeeMultiMap* _tmp5_ = NULL;
			GeeSet* _tmp6_ = NULL;
			GeeSet* _tmp7_ = NULL;
			GeeIterator* _tmp8_ = NULL;
			GeeIterator* _tmp9_ = NULL;
			_tmp3_ = persona;
			_tmp4_ = folks_im_details_get_im_addresses (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_multi_map_get_keys (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			_protocol_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				gchar* protocol = NULL;
				GeeIterator* _tmp12_ = NULL;
				gpointer _tmp13_ = NULL;
				GeeCollection* im_fds = NULL;
				FolksImDetails* _tmp14_ = NULL;
				GeeMultiMap* _tmp15_ = NULL;
				GeeMultiMap* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				GeeCollection* _tmp18_ = NULL;
				_tmp10_ = _protocol_it;
				_tmp11_ = gee_iterator_next (_tmp10_);
				if (!_tmp11_) {
					break;
				}
				_tmp12_ = _protocol_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				protocol = (gchar*) _tmp13_;
				_tmp14_ = persona;
				_tmp15_ = folks_im_details_get_im_addresses (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = protocol;
				_tmp18_ = gee_multi_map_get (_tmp16_, _tmp17_);
				im_fds = _tmp18_;
				{
					GeeIterator* _im_fd_it = NULL;
					GeeCollection* _tmp19_ = NULL;
					GeeIterator* _tmp20_ = NULL;
					_tmp19_ = im_fds;
					_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
					_im_fd_it = _tmp20_;
					while (TRUE) {
						GeeIterator* _tmp21_ = NULL;
						gboolean _tmp22_ = FALSE;
						FolksImFieldDetails* im_fd = NULL;
						GeeIterator* _tmp23_ = NULL;
						gpointer _tmp24_ = NULL;
						FolksPersonaLinkablePropertyCallback _tmp25_ = NULL;
						void* _tmp25__target = NULL;
						const gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						FolksImFieldDetails* _tmp29_ = NULL;
						gconstpointer _tmp30_ = NULL;
						const gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						_tmp21_ = _im_fd_it;
						_tmp22_ = gee_iterator_next (_tmp21_);
						if (!_tmp22_) {
							break;
						}
						_tmp23_ = _im_fd_it;
						_tmp24_ = gee_iterator_get (_tmp23_);
						im_fd = (FolksImFieldDetails*) _tmp24_;
						_tmp25_ = callback;
						_tmp25__target = callback_target;
						_tmp26_ = protocol;
						_tmp27_ = g_strconcat (_tmp26_, ":", NULL);
						_tmp28_ = _tmp27_;
						_tmp29_ = im_fd;
						_tmp30_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = g_strconcat (_tmp28_, (const gchar*) _tmp31_, NULL);
						_tmp33_ = _tmp32_;
						_tmp25_ (_tmp33_, _tmp25__target);
						_g_free0 (_tmp33_);
						_g_free0 (_tmp28_);
						_g_object_unref0 (im_fd);
					}
					_g_object_unref0 (_im_fd_it);
				}
				_g_object_unref0 (im_fds);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
		_g_object_unref0 (persona);
	} else {
		const gchar* _tmp34_ = NULL;
		_tmp34_ = prop_name;
		if (g_strcmp0 (_tmp34_, "local-ids") == 0) {
			FolksLocalIdDetails* persona = NULL;
			FolksLocalIdDetails* _tmp35_ = NULL;
			FolksLocalIdDetails* _tmp36_ = NULL;
			_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_LOCAL_ID_DETAILS) ? ((FolksLocalIdDetails*) self) : NULL);
			persona = _tmp35_;
			_tmp36_ = persona;
			_vala_assert (_tmp36_ != NULL, "persona != null");
			{
				GeeIterator* _id_it = NULL;
				FolksLocalIdDetails* _tmp37_ = NULL;
				GeeSet* _tmp38_ = NULL;
				GeeSet* _tmp39_ = NULL;
				GeeIterator* _tmp40_ = NULL;
				_tmp37_ = persona;
				_tmp38_ = folks_local_id_details_get_local_ids (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = gee_iterable_iterator ((GeeIterable*) _tmp39_);
				_id_it = _tmp40_;
				while (TRUE) {
					GeeIterator* _tmp41_ = NULL;
					gboolean _tmp42_ = FALSE;
					gchar* id = NULL;
					GeeIterator* _tmp43_ = NULL;
					gpointer _tmp44_ = NULL;
					FolksPersonaLinkablePropertyCallback _tmp45_ = NULL;
					void* _tmp45__target = NULL;
					const gchar* _tmp46_ = NULL;
					_tmp41_ = _id_it;
					_tmp42_ = gee_iterator_next (_tmp41_);
					if (!_tmp42_) {
						break;
					}
					_tmp43_ = _id_it;
					_tmp44_ = gee_iterator_get (_tmp43_);
					id = (gchar*) _tmp44_;
					_tmp45_ = callback;
					_tmp45__target = callback_target;
					_tmp46_ = id;
					_tmp45_ (_tmp46_, _tmp45__target);
					_g_free0 (id);
				}
				_g_object_unref0 (_id_it);
			}
			_g_object_unref0 (persona);
		} else {
			const gchar* _tmp47_ = NULL;
			_tmp47_ = prop_name;
			if (g_strcmp0 (_tmp47_, "web-service-addresses") == 0) {
				FolksWebServiceDetails* persona = NULL;
				FolksWebServiceDetails* _tmp48_ = NULL;
				FolksWebServiceDetails* _tmp49_ = NULL;
				_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_WEB_SERVICE_DETAILS) ? ((FolksWebServiceDetails*) self) : NULL);
				persona = _tmp48_;
				_tmp49_ = persona;
				_vala_assert (_tmp49_ != NULL, "persona != null");
				{
					GeeIterator* _web_service_it = NULL;
					FolksWebServiceDetails* _tmp50_ = NULL;
					GeeMultiMap* _tmp51_ = NULL;
					GeeMultiMap* _tmp52_ = NULL;
					GeeSet* _tmp53_ = NULL;
					GeeSet* _tmp54_ = NULL;
					GeeIterator* _tmp55_ = NULL;
					GeeIterator* _tmp56_ = NULL;
					_tmp50_ = persona;
					_tmp51_ = folks_web_service_details_get_web_service_addresses (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = gee_multi_map_get_keys (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = gee_iterable_iterator ((GeeIterable*) _tmp54_);
					_tmp56_ = _tmp55_;
					_g_object_unref0 (_tmp54_);
					_web_service_it = _tmp56_;
					while (TRUE) {
						GeeIterator* _tmp57_ = NULL;
						gboolean _tmp58_ = FALSE;
						gchar* web_service = NULL;
						GeeIterator* _tmp59_ = NULL;
						gpointer _tmp60_ = NULL;
						GeeCollection* web_service_addresses = NULL;
						FolksWebServiceDetails* _tmp61_ = NULL;
						GeeMultiMap* _tmp62_ = NULL;
						GeeMultiMap* _tmp63_ = NULL;
						const gchar* _tmp64_ = NULL;
						GeeCollection* _tmp65_ = NULL;
						_tmp57_ = _web_service_it;
						_tmp58_ = gee_iterator_next (_tmp57_);
						if (!_tmp58_) {
							break;
						}
						_tmp59_ = _web_service_it;
						_tmp60_ = gee_iterator_get (_tmp59_);
						web_service = (gchar*) _tmp60_;
						_tmp61_ = persona;
						_tmp62_ = folks_web_service_details_get_web_service_addresses (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp64_ = web_service;
						_tmp65_ = gee_multi_map_get (_tmp63_, _tmp64_);
						web_service_addresses = _tmp65_;
						{
							GeeIterator* _ws_fd_it = NULL;
							GeeCollection* _tmp66_ = NULL;
							GeeIterator* _tmp67_ = NULL;
							_tmp66_ = web_service_addresses;
							_tmp67_ = gee_iterable_iterator ((GeeIterable*) _tmp66_);
							_ws_fd_it = _tmp67_;
							while (TRUE) {
								GeeIterator* _tmp68_ = NULL;
								gboolean _tmp69_ = FALSE;
								FolksWebServiceFieldDetails* ws_fd = NULL;
								GeeIterator* _tmp70_ = NULL;
								gpointer _tmp71_ = NULL;
								FolksPersonaLinkablePropertyCallback _tmp72_ = NULL;
								void* _tmp72__target = NULL;
								const gchar* _tmp73_ = NULL;
								gchar* _tmp74_ = NULL;
								gchar* _tmp75_ = NULL;
								FolksWebServiceFieldDetails* _tmp76_ = NULL;
								gconstpointer _tmp77_ = NULL;
								const gchar* _tmp78_ = NULL;
								gchar* _tmp79_ = NULL;
								gchar* _tmp80_ = NULL;
								_tmp68_ = _ws_fd_it;
								_tmp69_ = gee_iterator_next (_tmp68_);
								if (!_tmp69_) {
									break;
								}
								_tmp70_ = _ws_fd_it;
								_tmp71_ = gee_iterator_get (_tmp70_);
								ws_fd = (FolksWebServiceFieldDetails*) _tmp71_;
								_tmp72_ = callback;
								_tmp72__target = callback_target;
								_tmp73_ = web_service;
								_tmp74_ = g_strconcat (_tmp73_, ":", NULL);
								_tmp75_ = _tmp74_;
								_tmp76_ = ws_fd;
								_tmp77_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = g_strconcat (_tmp75_, (const gchar*) _tmp78_, NULL);
								_tmp80_ = _tmp79_;
								_tmp72_ (_tmp80_, _tmp72__target);
								_g_free0 (_tmp80_);
								_g_free0 (_tmp75_);
								_g_object_unref0 (ws_fd);
							}
							_g_object_unref0 (_ws_fd_it);
						}
						_g_object_unref0 (web_service_addresses);
						_g_free0 (web_service);
					}
					_g_object_unref0 (_web_service_it);
				}
				_g_object_unref0 (persona);
			} else {
				const gchar* _tmp81_ = NULL;
				_tmp81_ = prop_name;
				if (g_strcmp0 (_tmp81_, "email-addresses") == 0) {
					FolksEmailDetails* persona = NULL;
					FolksEmailDetails* _tmp82_ = NULL;
					FolksEmailDetails* _tmp83_ = NULL;
					_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) self) : NULL);
					persona = _tmp82_;
					_tmp83_ = persona;
					_vala_assert (_tmp83_ != NULL, "persona != null");
					{
						GeeIterator* _email_it = NULL;
						FolksEmailDetails* _tmp84_ = NULL;
						GeeSet* _tmp85_ = NULL;
						GeeSet* _tmp86_ = NULL;
						GeeIterator* _tmp87_ = NULL;
						_tmp84_ = persona;
						_tmp85_ = folks_email_details_get_email_addresses (_tmp84_);
						_tmp86_ = _tmp85_;
						_tmp87_ = gee_iterable_iterator ((GeeIterable*) _tmp86_);
						_email_it = _tmp87_;
						while (TRUE) {
							GeeIterator* _tmp88_ = NULL;
							gboolean _tmp89_ = FALSE;
							FolksEmailFieldDetails* email = NULL;
							GeeIterator* _tmp90_ = NULL;
							gpointer _tmp91_ = NULL;
							FolksPersonaLinkablePropertyCallback _tmp92_ = NULL;
							void* _tmp92__target = NULL;
							FolksEmailFieldDetails* _tmp93_ = NULL;
							gconstpointer _tmp94_ = NULL;
							const gchar* _tmp95_ = NULL;
							_tmp88_ = _email_it;
							_tmp89_ = gee_iterator_next (_tmp88_);
							if (!_tmp89_) {
								break;
							}
							_tmp90_ = _email_it;
							_tmp91_ = gee_iterator_get (_tmp90_);
							email = (FolksEmailFieldDetails*) _tmp91_;
							_tmp92_ = callback;
							_tmp92__target = callback_target;
							_tmp93_ = email;
							_tmp94_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp93_);
							_tmp95_ = _tmp94_;
							_tmp92_ ((const gchar*) _tmp95_, _tmp92__target);
							_g_object_unref0 (email);
						}
						_g_object_unref0 (_email_it);
					}
					_g_object_unref0 (persona);
				} else {
					const gchar* _tmp96_ = NULL;
					FolksPersonaLinkablePropertyCallback _tmp97_ = NULL;
					void* _tmp97__target = NULL;
					_tmp96_ = prop_name;
					_tmp97_ = callback;
					_tmp97__target = callback_target;
					FOLKS_PERSONA_CLASS (folks_dummy_persona_parent_class)->linkable_property_to_links (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_PERSONA, FolksPersona), _tmp96_, _tmp97_, _tmp97__target);
				}
			}
		}
	}
}


/**
   * Update the persona’s set of writeable properties.
   *
   * Update the {@link Folks.Persona.writeable_properties} property to contain
   * the union of {@link Folks.PersonaStore.always_writeable_properties} from
   * the persona’s store, and the given ``writeable_properties``.
   *
   * This should be used to simulate a change in the backing store for the
   * persona which affects the writeability of one or more of its properties.
   *
   * @since 0.9.7
   */
void folks_dummy_persona_update_writeable_properties (FolksDummyPersona* self, gchar** writeable_properties, int writeable_properties_length1) {
	GeeHashSet* new_writeable_properties = NULL;
	GeeHashSet* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	FolksPersonaStore* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gboolean changed = FALSE;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	GeeHashSet* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	new_writeable_properties = _tmp0_;
	_tmp1_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_persona_store_get_always_writeable_properties (_tmp2_, &_tmp3__length1);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp4_;
		p_collection_length1 = _tmp4__length1;
		for (p_it = 0; p_it < _tmp4__length1; p_it = p_it + 1) {
			gchar* _tmp5_ = NULL;
			gchar* p = NULL;
			_tmp5_ = g_strdup (p_collection[p_it]);
			p = _tmp5_;
			{
				GeeHashSet* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				_tmp6_ = new_writeable_properties;
				_tmp7_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
				_g_free0 (p);
			}
		}
	}
	_tmp8_ = writeable_properties;
	_tmp8__length1 = writeable_properties_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp8_;
		p_collection_length1 = _tmp8__length1;
		for (p_it = 0; p_it < _tmp8__length1; p_it = p_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* p = NULL;
			_tmp9_ = g_strdup (p_collection[p_it]);
			p = _tmp9_;
			{
				GeeHashSet* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				_tmp10_ = new_writeable_properties;
				_tmp11_ = p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_g_free0 (p);
			}
		}
	}
	changed = FALSE;
	_tmp12_ = self->priv->_writeable_properties;
	_tmp12__length1 = self->priv->_writeable_properties_length1;
	_tmp13_ = new_writeable_properties;
	_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp12__length1 != _tmp15_) {
		changed = TRUE;
	} else {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp16_ = self->priv->_writeable_properties;
		_tmp16__length1 = self->priv->_writeable_properties_length1;
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp16_;
			p_collection_length1 = _tmp16__length1;
			for (p_it = 0; p_it < _tmp16__length1; p_it = p_it + 1) {
				gchar* _tmp17_ = NULL;
				gchar* p = NULL;
				_tmp17_ = g_strdup (p_collection[p_it]);
				p = _tmp17_;
				{
					GeeHashSet* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp18_ = new_writeable_properties;
					_tmp19_ = p;
					_tmp20_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, _tmp19_);
					if (_tmp20_ == FALSE) {
						changed = TRUE;
						_g_free0 (p);
						break;
					}
					_g_free0 (p);
				}
			}
		}
	}
	_tmp21_ = changed;
	if (_tmp21_ == TRUE) {
		GeeHashSet* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gpointer* _tmp24_ = NULL;
		_tmp22_ = new_writeable_properties;
		_tmp24_ = gee_collection_to_array ((GeeCollection*) _tmp22_, &_tmp23_);
		self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_writeable_properties = _tmp24_;
		self->priv->_writeable_properties_length1 = _tmp23_;
		self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
		g_object_notify ((GObject*) self, "writeable-properties");
	}
	_g_object_unref0 (new_writeable_properties);
}


/**
   * Update the persona’s set of linkable properties.
   *
   * Update the {@link Folks.Persona.linkable_properties} property to contain
   * the given ``linkable_properties``.
   *
   * @param linkable_properties new set of linkable property names, in lower
   * case, hyphenated form
   * @since 0.9.7
   */
static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void folks_dummy_persona_update_linkable_properties (FolksDummyPersona* self, gchar** linkable_properties, int linkable_properties_length1) {
	FolksSmallSet* new_linkable_properties = NULL;
	FolksSmallSet* _tmp0_ = NULL;
	FolksSmallSet* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	FolksSmallSet* old_linkable_properties = NULL;
	FolksSmallSet* _tmp3_ = NULL;
	FolksSmallSet* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	FolksSmallSet* _tmp6_ = NULL;
	FolksSmallSet* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	new_linkable_properties = _tmp0_;
	_tmp1_ = new_linkable_properties;
	_tmp2_ = linkable_properties;
	_tmp2__length1 = linkable_properties_length1;
	gee_collection_add_all_array ((GeeCollection*) _tmp1_, _tmp2_, _tmp2__length1);
	_tmp3_ = folks_small_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	old_linkable_properties = _tmp3_;
	_tmp4_ = old_linkable_properties;
	_tmp5_ = self->priv->_linkable_properties;
	_tmp5__length1 = self->priv->_linkable_properties_length1;
	gee_collection_add_all_array ((GeeCollection*) _tmp4_, _tmp5_, _tmp5__length1);
	_tmp6_ = old_linkable_properties;
	_tmp7_ = new_linkable_properties;
	_tmp8_ = folks_internal_equal_sets (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GeeSet*) _tmp6_, (GeeSet*) _tmp7_);
	if (!_tmp8_) {
		gchar** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp9_ = linkable_properties;
		_tmp9__length1 = linkable_properties_length1;
		_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup3 (_tmp9_, _tmp9__length1) : ((gpointer) _tmp9_);
		_tmp10__length1 = _tmp9__length1;
		self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
		self->priv->_linkable_properties = _tmp10_;
		self->priv->_linkable_properties_length1 = _tmp10__length1;
		self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1;
		g_object_notify ((GObject*) self, "linkable-properties");
	}
	_g_object_unref0 (old_linkable_properties);
	_g_object_unref0 (new_linkable_properties);
}


static void folks_dummy_persona_change_property_data_free (gpointer _data) {
	FolksDummyPersonaChangePropertyData* _data_;
	_data_ = _data;
	_g_free0 (_data_->property_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksDummyPersonaChangePropertyData, _data_);
}


void folks_dummy_persona_change_property (FolksDummyPersona* self, const gchar* property_name, FolksDummyPersonaChangePropertyCallback callback, void* callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksDummyPersonaChangePropertyData* _data_;
	FolksDummyPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	FolksDummyPersonaChangePropertyCallback _tmp3_ = NULL;
	void* _tmp3__target = NULL;
	_data_ = g_slice_new0 (FolksDummyPersonaChangePropertyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_dummy_persona_change_property);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_dummy_persona_change_property_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = property_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp2_;
	_tmp3_ = callback;
	_tmp3__target = callback_target;
	_data_->callback = _tmp3_;
	_data_->callback_target = _tmp3__target;
	folks_dummy_persona_change_property_co (_data_);
}


void folks_dummy_persona_change_property_finish (FolksDummyPersona* self, GAsyncResult* _res_) {
	FolksDummyPersonaChangePropertyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change a property in the simulated backing store.
   *
   * This triggers a property change in the simulated backing store, applying
   * the current {@link FolksDummy.Persona.property_change_delay} before calling
   * the given ``callback`` which should actually effect the property change.
   *
   * @param property_name name of the property being changed
   * @param callback callback to call once the change delay has passed
   * @since 0.9.7
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		FolksDummyPersona* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean ____lambda4_ (Block1Data* _data1_) {
	FolksDummyPersona* self;
	gboolean result = FALSE;
	FolksDummyPersonaChangePropertyCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->callback;
	_tmp0__target = _data1_->callback_target;
	_tmp0_ (_tmp0__target);
	folks_dummy_persona_change_property_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda4_ (self);
	return result;
}


static gboolean ____lambda5_ (Block1Data* _data1_) {
	FolksDummyPersona* self;
	gboolean result = FALSE;
	FolksDummyPersonaChangePropertyCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->callback;
	_tmp0__target = _data1_->callback_target;
	_tmp0_ (_tmp0__target);
	folks_dummy_persona_change_property_co (_data1_->_async_data_);
	result = FALSE;
	return result;
}


static gboolean _____lambda5__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda5_ (self);
	return result;
}


static gboolean folks_dummy_persona_change_property_co (FolksDummyPersonaChangePropertyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__target = NULL;
	_data_->_tmp0_ = _data_->callback;
	_data_->_tmp0__target = _data_->callback_target;
	_data_->_data1_->callback = _data_->_tmp0_;
	_data_->_data1_->callback_target = _data_->_tmp0__target;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp1_ = 0;
	_data_->_tmp1_ = _data_->self->priv->_property_change_delay;
	if (_data_->_tmp1_ < 0) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2__target = NULL;
		_data_->_tmp2_ = _data_->_data1_->callback;
		_data_->_tmp2__target = _data_->_data1_->callback_target;
		_data_->_tmp2_ (_data_->_tmp2__target);
	} else {
		_data_->_tmp3_ = 0;
		_data_->_tmp3_ = _data_->self->priv->_property_change_delay;
		if (_data_->_tmp3_ == 0) {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda4__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
		} else {
			_data_->_tmp4_ = 0;
			_data_->_tmp4_ = _data_->self->priv->_property_change_delay;
			g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _data_->_tmp4_, _____lambda5__gsource_func, block1_data_ref (_data_->_data1_), block1_data_unref);
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
	}
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar** folks_dummy_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksDummyPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksDummyPersona*) base;
	_tmp0_ = self->priv->_linkable_properties;
	_tmp0__length1 = self->priv->_linkable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gchar** folks_dummy_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksDummyPersona* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksDummyPersona*) base;
	_tmp0_ = self->priv->_writeable_properties;
	_tmp0__length1 = self->priv->_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


gint folks_dummy_persona_get_property_change_delay (FolksDummyPersona* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_property_change_delay;
	result = _tmp0_;
	return result;
}


void folks_dummy_persona_set_property_change_delay (FolksDummyPersona* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_property_change_delay = _tmp0_;
	g_object_notify ((GObject *) self, "property-change-delay");
}


static void folks_dummy_persona_class_init (FolksDummyPersonaClass * klass) {
	folks_dummy_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksDummyPersonaPrivate));
	((FolksPersonaClass *) klass)->linkable_property_to_links = folks_dummy_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_dummy_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = folks_dummy_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_dummy_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_dummy_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_dummy_persona_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Delay between property changes and notifications.
	   *
	   * This sets an optional delay between client code requesting a property
	   * change (e.g. by calling {@link Folks.NameDetails.change_nickname}) and the
	   * property change taking place and a {@link Object.notify} signal being
	   * emitted for it.
	   *
	   * Delays are in milliseconds. Negative delays mean that property change
	   * notifications happen synchronously in the change method. A delay of 0
	   * means that property change notifications happen in an idle callback
	   * immediately after the change method. A positive delay means that property
	   * change notifications happen that many milliseconds after the change method
	   * is called.
	   *
	   * @since 0.9.7
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY, g_param_spec_int ("property-change-delay", "property-change-delay", "property-change-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_dummy_persona_instance_init (FolksDummyPersona * self) {
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	self->priv = FOLKS_DUMMY_PERSONA_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_linkable_properties = _tmp0_;
	self->priv->_linkable_properties_length1 = 0;
	self->priv->__linkable_properties_size_ = self->priv->_linkable_properties_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->_writeable_properties = _tmp1_;
	self->priv->_writeable_properties_length1 = 0;
	self->priv->__writeable_properties_size_ = self->priv->_writeable_properties_length1;
}


static void folks_dummy_persona_finalize (GObject* obj) {
	FolksDummyPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona);
	self->priv->_linkable_properties = (_vala_array_free (self->priv->_linkable_properties, self->priv->_linkable_properties_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_writeable_properties = (_vala_array_free (self->priv->_writeable_properties, self->priv->_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (folks_dummy_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass representing a single contact.
 *
 * This mocks up a ‘thin’ persona which implements none of the available
 * property interfaces provided by libfolks, and is designed as a base class to
 * be subclassed by personas which will implement one or more of these
 * interfaces. For example, {@link FolksDummy.FullPersona} is one such subclass
 * which implements all available interfaces.
 *
 * There are two sides to this class’ interface: the normal methods required by
 * {@link Folks.Persona}, such as
 * {@link Folks.Persona.linkable_property_to_links},
 * and the backend methods which should be called by test driver code to
 * simulate changes in the backing store providing this persona, such as
 * {@link FolksDummy.Persona.update_writeable_properties}. The ``update_``,
 * ``register_`` and ``unregister_`` prefixes are commonly used for backend
 * methods.
 *
 * All property changes for contact details of subclasses of
 * {@link FolksDummy.Persona} have a configurable delay before taking effect,
 * which can be controlled by {@link FolksDummy.Persona.property_change_delay}.
 *
 * The API in {@link FolksDummy} is unstable and may change wildly. It is
 * designed mostly for use by libfolks unit tests.
 *
 * @since 0.9.7
 */
GType folks_dummy_persona_get_type (void) {
	static volatile gsize folks_dummy_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_dummy_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksDummyPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_dummy_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDummyPersona), 0, (GInstanceInitFunc) folks_dummy_persona_instance_init, NULL };
		GType folks_dummy_persona_type_id;
		folks_dummy_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksDummyPersona", &g_define_type_info, 0);
		g_once_init_leave (&folks_dummy_persona_type_id__volatile, folks_dummy_persona_type_id);
	}
	return folks_dummy_persona_type_id__volatile;
}


static void _vala_folks_dummy_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksDummyPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_DUMMY_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY:
		g_value_set_int (value, folks_dummy_persona_get_property_change_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_dummy_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksDummyPersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_DUMMY_TYPE_PERSONA, FolksDummyPersona);
	switch (property_id) {
		case FOLKS_DUMMY_PERSONA_PROPERTY_CHANGE_DELAY:
		folks_dummy_persona_set_property_change_delay (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



