/* name-details.c generated by valac 0.27.1.3-6129, the Vala compiler
 * generated from name-details.vala, do not modify */

/*
 * Copyright (C) 2011, 2013 Collabora Ltd.
 * Copyright (C) 2011, 2013 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;
typedef struct _FolksStructuredNamePrivate FolksStructuredNamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define FOLKS_TYPE_NAME_DETAILS (folks_name_details_get_type ())
#define FOLKS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetails))
#define FOLKS_IS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NAME_DETAILS))
#define FOLKS_NAME_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetailsIface))

typedef struct _FolksNameDetails FolksNameDetails;
typedef struct _FolksNameDetailsIface FolksNameDetailsIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksNameDetailsChangeStructuredNameData FolksNameDetailsChangeStructuredNameData;
typedef struct _FolksNameDetailsChangeFullNameData FolksNameDetailsChangeFullNameData;
typedef struct _FolksNameDetailsChangeNicknameData FolksNameDetailsChangeNicknameData;

struct _FolksStructuredName {
	GObject parent_instance;
	FolksStructuredNamePrivate * priv;
};

struct _FolksStructuredNameClass {
	GObjectClass parent_class;
};

struct _FolksStructuredNamePrivate {
	gchar* _family_name;
	gchar* _given_name;
	gchar* _additional_names;
	gchar* _prefixes;
	gchar* _suffixes;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR,
	FOLKS_PROPERTY_ERROR_UNAVAILABLE
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksNameDetailsIface {
	GTypeInterface parent_iface;
	void (*change_structured_name) (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_structured_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_full_name) (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_full_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_nickname) (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_nickname_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	FolksStructuredName* (*get_structured_name) (FolksNameDetails* self);
	void (*set_structured_name) (FolksNameDetails* self, FolksStructuredName* value);
	const gchar* (*get_full_name) (FolksNameDetails* self);
	void (*set_full_name) (FolksNameDetails* self, const gchar* value);
	const gchar* (*get_nickname) (FolksNameDetails* self);
	void (*set_nickname) (FolksNameDetails* self, const gchar* value);
};

struct _FolksNameDetailsChangeStructuredNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksNameDetails* self;
	FolksStructuredName* name;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};

struct _FolksNameDetailsChangeFullNameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksNameDetails* self;
	gchar* full_name;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};

struct _FolksNameDetailsChangeNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksNameDetails* self;
	gchar* nickname;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer folks_structured_name_parent_class = NULL;

GType folks_structured_name_get_type (void) G_GNUC_CONST;
#define FOLKS_STRUCTURED_NAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNamePrivate))
enum  {
	FOLKS_STRUCTURED_NAME_DUMMY_PROPERTY,
	FOLKS_STRUCTURED_NAME_FAMILY_NAME,
	FOLKS_STRUCTURED_NAME_GIVEN_NAME,
	FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES,
	FOLKS_STRUCTURED_NAME_PREFIXES,
	FOLKS_STRUCTURED_NAME_SUFFIXES
};
FolksStructuredName* folks_structured_name_new (const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes);
FolksStructuredName* folks_structured_name_construct (GType object_type, const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes);
FolksStructuredName* folks_structured_name_new_simple (const gchar* family_name, const gchar* given_name);
FolksStructuredName* folks_structured_name_construct_simple (GType object_type, const gchar* family_name, const gchar* given_name);
gboolean folks_structured_name_is_empty (FolksStructuredName* self);
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self);
const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self);
static gchar* _folks_structured_name_extract_initials (FolksStructuredName* self, const gchar* names);
gchar* folks_structured_name_to_string (FolksStructuredName* self);
gchar* folks_structured_name_to_string_with_format (FolksStructuredName* self, const gchar* name_fmt);
void folks_structured_name_set_family_name (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_given_name (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_additional_names (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_prefixes (FolksStructuredName* self, const gchar* value);
void folks_structured_name_set_suffixes (FolksStructuredName* self, const gchar* value);
static void folks_structured_name_finalize (GObject* obj);
static void _vala_folks_structured_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_structured_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GQuark folks_property_error_quark (void);
GType folks_name_details_get_type (void) G_GNUC_CONST;
static void folks_name_details_real_change_structured_name_data_free (gpointer _data);
static void folks_name_details_real_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_structured_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_name_details_real_change_structured_name_co (FolksNameDetailsChangeStructuredNameData* _data_);
static void folks_name_details_real_change_full_name_data_free (gpointer _data);
static void folks_name_details_real_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_full_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_name_details_real_change_full_name_co (FolksNameDetailsChangeFullNameData* _data_);
static void folks_name_details_real_change_nickname_data_free (gpointer _data);
static void folks_name_details_real_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_name_details_change_nickname_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_name_details_real_change_nickname_co (FolksNameDetailsChangeNicknameData* _data_);
FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self);
void folks_name_details_set_structured_name (FolksNameDetails* self, FolksStructuredName* value);
const gchar* folks_name_details_get_full_name (FolksNameDetails* self);
void folks_name_details_set_full_name (FolksNameDetails* self, const gchar* value);
const gchar* folks_name_details_get_nickname (FolksNameDetails* self);
void folks_name_details_set_nickname (FolksNameDetails* self, const gchar* value);


/**
   * Create a StructuredName.
   *
   * You can pass ``null`` if a component is not set.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @param additional_names additional names
   * @param prefixes prefixes of the name
   * @param suffixes suffixes of the name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName* folks_structured_name_construct (GType object_type, const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes) {
	FolksStructuredName * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	_tmp0_ = family_name;
	_tmp1_ = given_name;
	_tmp2_ = additional_names;
	_tmp3_ = prefixes;
	_tmp4_ = suffixes;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", _tmp0_, "given-name", _tmp1_, "additional-names", _tmp2_, "prefixes", _tmp3_, "suffixes", _tmp4_, NULL);
	return self;
}


FolksStructuredName* folks_structured_name_new (const gchar* family_name, const gchar* given_name, const gchar* additional_names, const gchar* prefixes, const gchar* suffixes) {
	return folks_structured_name_construct (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name, additional_names, prefixes, suffixes);
}


/**
   * Create a StructuredName.
   *
   * Shorthand for the common case of just having the family and given
   * name of a contact. It's equivalent to calling
   * {@link StructuredName.StructuredName} and passing ``null`` for all
   * the other components.
   *
   * @param family_name the family (last) name
   * @param given_name the given (first) name
   * @return a new StructuredName
   *
   * @since 0.3.5
   */
FolksStructuredName* folks_structured_name_construct_simple (GType object_type, const gchar* family_name, const gchar* given_name) {
	FolksStructuredName * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = family_name;
	_tmp1_ = given_name;
	self = (FolksStructuredName*) g_object_new (object_type, "family-name", _tmp0_, "given-name", _tmp1_, NULL);
	return self;
}


FolksStructuredName* folks_structured_name_new_simple (const gchar* family_name, const gchar* given_name) {
	return folks_structured_name_construct_simple (FOLKS_TYPE_STRUCTURED_NAME, family_name, given_name);
}


/**
   * Whether none of the components is set.
   *
   * @return ``true`` if all the components are the empty string, ``false``
   * otherwise.
   *
   * @since 0.3.5
   */
gboolean folks_structured_name_is_empty (FolksStructuredName* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp4_ = self->priv->_family_name;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = self->priv->_given_name;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = self->priv->_additional_names;
		_tmp2_ = g_strcmp0 (_tmp6_, "") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = self->priv->_prefixes;
		_tmp1_ = g_strcmp0 (_tmp7_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = self->priv->_suffixes;
		_tmp0_ = g_strcmp0 (_tmp8_, "") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


/**
   * Whether two StructuredNames are the same.
   *
   * @param other the other structured name to compare with
   * @return ``true`` if all the components are the same, ``false``
   * otherwise.
   *
   * @since 0.5.0
   */
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	FolksStructuredName* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp4_ = self->priv->_family_name;
	_tmp5_ = other;
	_tmp6_ = folks_structured_name_get_family_name (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp4_, _tmp7_) == 0) {
		const gchar* _tmp8_ = NULL;
		FolksStructuredName* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		_tmp8_ = self->priv->_given_name;
		_tmp9_ = other;
		_tmp10_ = folks_structured_name_get_given_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp3_ = g_strcmp0 (_tmp8_, _tmp11_) == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp12_ = NULL;
		FolksStructuredName* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp12_ = self->priv->_additional_names;
		_tmp13_ = other;
		_tmp14_ = folks_structured_name_get_additional_names (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp2_ = g_strcmp0 (_tmp12_, _tmp15_) == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp16_ = NULL;
		FolksStructuredName* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp16_ = self->priv->_prefixes;
		_tmp17_ = other;
		_tmp18_ = folks_structured_name_get_prefixes (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp1_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp20_ = NULL;
		FolksStructuredName* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		_tmp20_ = self->priv->_suffixes;
		_tmp21_ = other;
		_tmp22_ = folks_structured_name_get_suffixes (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp0_ = g_strcmp0 (_tmp20_, _tmp23_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* _folks_structured_name_extract_initials (FolksStructuredName* self, const gchar* names) {
	gchar* result = NULL;
	GString* output = NULL;
	GString* _tmp0_ = NULL;
	gboolean at_start_of_word = FALSE;
	gint index = 0;
	gunichar c = 0U;
	GString* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (names != NULL, NULL);
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	at_start_of_word = TRUE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		_tmp1_ = names;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		c = _tmp2_;
		if (!(_tmp3_ == TRUE)) {
			break;
		}
		_tmp5_ = c;
		_tmp6_ = g_unichar_isspace (_tmp5_);
		if (_tmp6_) {
			_tmp4_ = TRUE;
		} else {
			gunichar _tmp7_ = 0U;
			_tmp7_ = c;
			_tmp4_ = _tmp7_ == ((gunichar) '-');
		}
		if (_tmp4_) {
			at_start_of_word = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = at_start_of_word;
			if (_tmp8_) {
				GString* _tmp9_ = NULL;
				gunichar _tmp10_ = 0U;
				_tmp9_ = output;
				_tmp10_ = c;
				g_string_append_unichar (_tmp9_, _tmp10_);
				at_start_of_word = FALSE;
			}
		}
	}
	_tmp11_ = output;
	_tmp12_ = _tmp11_->str;
	_tmp13_ = g_strdup (_tmp12_);
	result = _tmp13_;
	_g_string_free0 (output);
	return result;
}


/**
   * Formatted version of the structured name.
   *
   * @return name formatted according to the current locale
   * @since 0.4.0
   */
gchar* folks_structured_name_to_string (FolksStructuredName* self) {
	gchar* result = NULL;
	gchar* name_fmt = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("%g%t%m%t%f");
	_tmp1_ = g_strdup (_tmp0_);
	name_fmt = _tmp1_;
	_tmp2_ = folks_structured_name_to_string_with_format (self, name_fmt);
	result = _tmp2_;
	_g_free0 (name_fmt);
	return result;
}


/**
   * Formatted version of the structured name.
   *
   * This allows a custom format string to be specified, using the placeholders
   * described on [[http://lh.2xlibre.net/values/name_fmt/]]. This ``name_fmt``
   * must almost always be translated to the current locale. (Ideally it would
   * be translated to the locale of the persona whose name is being formatted,
   * but such locale information isn’t available.)
   *
   * @param name_fmt format string for the name
   * @return name formatted according to the given format
   * @since 0.9.7
   */
gchar* folks_structured_name_to_string_with_format (FolksStructuredName* self, const gchar* name_fmt) {
	gchar* result = NULL;
	GString* output = NULL;
	GString* _tmp0_ = NULL;
	gboolean in_field_descriptor = FALSE;
	gboolean field_descriptor_romanised = FALSE;
	gboolean field_descriptor_empty = FALSE;
	gint index = 0;
	gunichar c = 0U;
	GString* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name_fmt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	in_field_descriptor = FALSE;
	field_descriptor_romanised = FALSE;
	field_descriptor_empty = TRUE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_ = NULL;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_ = FALSE;
		gunichar _tmp4_ = 0U;
		gboolean _tmp7_ = FALSE;
		_tmp1_ = name_fmt;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		c = _tmp2_;
		if (!(_tmp3_ == TRUE)) {
			break;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gunichar) '%')) {
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			_tmp5_ = in_field_descriptor;
			in_field_descriptor = !_tmp5_;
			_tmp6_ = in_field_descriptor;
			if (_tmp6_) {
				field_descriptor_romanised = FALSE;
				continue;
			}
		}
		_tmp7_ = in_field_descriptor;
		if (_tmp7_) {
			gunichar _tmp8_ = 0U;
			gchar* val = NULL;
			gchar* _tmp9_ = NULL;
			gunichar _tmp10_ = 0U;
			GString* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			_tmp8_ = c;
			if (_tmp8_ == ((gunichar) 'R')) {
				field_descriptor_romanised = TRUE;
				continue;
			}
			_tmp9_ = g_strdup ("");
			val = _tmp9_;
			_tmp10_ = c;
			if (_tmp10_ == ((gunichar) 'f')) {
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp11_ = self->priv->_family_name;
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (val);
				val = _tmp12_;
			} else {
				gunichar _tmp13_ = 0U;
				_tmp13_ = c;
				if (_tmp13_ == ((gunichar) 'F')) {
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					_tmp14_ = self->priv->_family_name;
					_tmp15_ = g_utf8_strup (_tmp14_, (gssize) (-1));
					_g_free0 (val);
					val = _tmp15_;
				} else {
					gunichar _tmp16_ = 0U;
					_tmp16_ = c;
					if (_tmp16_ == ((gunichar) 'g')) {
						const gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						_tmp17_ = self->priv->_given_name;
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (val);
						val = _tmp18_;
					} else {
						gunichar _tmp19_ = 0U;
						_tmp19_ = c;
						if (_tmp19_ == ((gunichar) 'G')) {
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							_tmp20_ = self->priv->_given_name;
							_tmp21_ = _folks_structured_name_extract_initials (self, _tmp20_);
							_g_free0 (val);
							val = _tmp21_;
						} else {
							gunichar _tmp22_ = 0U;
							_tmp22_ = c;
							if (_tmp22_ == ((gunichar) 'm')) {
								const gchar* _tmp23_ = NULL;
								gchar* _tmp24_ = NULL;
								_tmp23_ = self->priv->_additional_names;
								_tmp24_ = g_strdup (_tmp23_);
								_g_free0 (val);
								val = _tmp24_;
							} else {
								gunichar _tmp25_ = 0U;
								_tmp25_ = c;
								if (_tmp25_ == ((gunichar) 'M')) {
									const gchar* _tmp26_ = NULL;
									gchar* _tmp27_ = NULL;
									_tmp26_ = self->priv->_additional_names;
									_tmp27_ = _folks_structured_name_extract_initials (self, _tmp26_);
									_g_free0 (val);
									val = _tmp27_;
								} else {
									gboolean _tmp28_ = FALSE;
									gboolean _tmp29_ = FALSE;
									gunichar _tmp30_ = 0U;
									_tmp30_ = c;
									if (_tmp30_ == ((gunichar) 's')) {
										_tmp29_ = TRUE;
									} else {
										gunichar _tmp31_ = 0U;
										_tmp31_ = c;
										_tmp29_ = _tmp31_ == ((gunichar) 'S');
									}
									if (_tmp29_) {
										_tmp28_ = TRUE;
									} else {
										gunichar _tmp32_ = 0U;
										_tmp32_ = c;
										_tmp28_ = _tmp32_ == ((gunichar) 'd');
									}
									if (_tmp28_) {
										const gchar* _tmp33_ = NULL;
										gchar* _tmp34_ = NULL;
										_tmp33_ = self->priv->_prefixes;
										_tmp34_ = g_strdup (_tmp33_);
										_g_free0 (val);
										val = _tmp34_;
									} else {
										gunichar _tmp35_ = 0U;
										_tmp35_ = c;
										if (_tmp35_ == ((gunichar) 't')) {
											const gchar* _tmp36_ = NULL;
											gboolean _tmp37_ = FALSE;
											gchar* _tmp38_ = NULL;
											_tmp37_ = field_descriptor_empty;
											if (_tmp37_ == FALSE) {
												_tmp36_ = " ";
											} else {
												_tmp36_ = "";
											}
											_tmp38_ = g_strdup (_tmp36_);
											_g_free0 (val);
											val = _tmp38_;
										} else {
											gboolean _tmp39_ = FALSE;
											gboolean _tmp40_ = FALSE;
											gunichar _tmp41_ = 0U;
											_tmp41_ = c;
											if (_tmp41_ == ((gunichar) 'l')) {
												_tmp40_ = TRUE;
											} else {
												gunichar _tmp42_ = 0U;
												_tmp42_ = c;
												_tmp40_ = _tmp42_ == ((gunichar) 'o');
											}
											if (_tmp40_) {
												_tmp39_ = TRUE;
											} else {
												gunichar _tmp43_ = 0U;
												_tmp43_ = c;
												_tmp39_ = _tmp43_ == ((gunichar) 'p');
											}
											if (_tmp39_) {
												gchar* _tmp44_ = NULL;
												_tmp44_ = g_strdup ("");
												_g_free0 (val);
												val = _tmp44_;
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp45_ = output;
			_tmp46_ = val;
			g_string_append (_tmp45_, _tmp46_);
			in_field_descriptor = FALSE;
			_tmp47_ = val;
			field_descriptor_empty = g_strcmp0 (_tmp47_, "") == 0;
			_g_free0 (val);
		} else {
			GString* _tmp48_ = NULL;
			gunichar _tmp49_ = 0U;
			_tmp48_ = output;
			_tmp49_ = c;
			g_string_append_unichar (_tmp48_, _tmp49_);
		}
	}
	_tmp50_ = output;
	_tmp51_ = _tmp50_->str;
	_tmp52_ = g_strdup (_tmp51_);
	result = _tmp52_;
	_g_string_free0 (output);
	return result;
}


const gchar* folks_structured_name_get_family_name (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_family_name;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_family_name (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_family_name);
	self->priv->_family_name = _tmp3_;
	g_object_notify ((GObject *) self, "family-name");
}


const gchar* folks_structured_name_get_given_name (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_given_name;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_given_name (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_given_name);
	self->priv->_given_name = _tmp3_;
	g_object_notify ((GObject *) self, "given-name");
}


const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_additional_names;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_additional_names (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_additional_names);
	self->priv->_additional_names = _tmp3_;
	g_object_notify ((GObject *) self, "additional-names");
}


const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prefixes;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_prefixes (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_prefixes);
	self->priv->_prefixes = _tmp3_;
	g_object_notify ((GObject *) self, "prefixes");
}


const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_suffixes;
	result = _tmp0_;
	return result;
}


void folks_structured_name_set_suffixes (FolksStructuredName* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_suffixes);
	self->priv->_suffixes = _tmp3_;
	g_object_notify ((GObject *) self, "suffixes");
}


static void folks_structured_name_class_init (FolksStructuredNameClass * klass) {
	folks_structured_name_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksStructuredNamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_structured_name_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_structured_name_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_structured_name_finalize;
	/**
	   * The family name.
	   *
	   * The family name (also known as surname or last name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_FAMILY_NAME, g_param_spec_string ("family-name", "family-name", "family-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The given name.
	   *
	   * The family name (also known as first name) of a contact.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_GIVEN_NAME, g_param_spec_string ("given-name", "given-name", "given-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * Additional names.
	   *
	   * The additional names of a contact, for instance the contact's
	   * middle name.
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES, g_param_spec_string ("additional-names", "additional-names", "additional-names", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The prefixes of a name.
	   *
	   * The prefixes used in front of the name (for instance "Mr", "Mrs",
	   * "Doctor" or honorific titles).
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_PREFIXES, g_param_spec_string ("prefixes", "prefixes", "prefixes", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The suffixes of a name.
	   *
	   * The suffixes used after a name (for instance "PhD" or "Junior").
	   *
	   * @since 0.3.5
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_STRUCTURED_NAME_SUFFIXES, g_param_spec_string ("suffixes", "suffixes", "suffixes", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void folks_structured_name_instance_init (FolksStructuredName * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	self->priv = FOLKS_STRUCTURED_NAME_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->_family_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_given_name = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->_additional_names = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_prefixes = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->priv->_suffixes = _tmp4_;
}


static void folks_structured_name_finalize (GObject* obj) {
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	_g_free0 (self->priv->_family_name);
	_g_free0 (self->priv->_given_name);
	_g_free0 (self->priv->_additional_names);
	_g_free0 (self->priv->_prefixes);
	_g_free0 (self->priv->_suffixes);
	G_OBJECT_CLASS (folks_structured_name_parent_class)->finalize (obj);
}


/**
 * Structured name representation for human names.
 *
 * Represents a full name split in its constituent parts (given name,
 * family name, etc.). This structure corresponds to the "N" field in
 * vCards. The parts of the name are never ``null``: an empty string
 * indicates that a property is not set.
 *
 * @since 0.3.5
 */
GType folks_structured_name_get_type (void) {
	static volatile gsize folks_structured_name_type_id__volatile = 0;
	if (g_once_init_enter (&folks_structured_name_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksStructuredNameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_structured_name_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksStructuredName), 0, (GInstanceInitFunc) folks_structured_name_instance_init, NULL };
		GType folks_structured_name_type_id;
		folks_structured_name_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksStructuredName", &g_define_type_info, 0);
		g_once_init_leave (&folks_structured_name_type_id__volatile, folks_structured_name_type_id);
	}
	return folks_structured_name_type_id__volatile;
}


static void _vala_folks_structured_name_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME:
		g_value_set_string (value, folks_structured_name_get_family_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME:
		g_value_set_string (value, folks_structured_name_get_given_name (self));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES:
		g_value_set_string (value, folks_structured_name_get_additional_names (self));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES:
		g_value_set_string (value, folks_structured_name_get_prefixes (self));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES:
		g_value_set_string (value, folks_structured_name_get_suffixes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_structured_name_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksStructuredName * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
	switch (property_id) {
		case FOLKS_STRUCTURED_NAME_FAMILY_NAME:
		folks_structured_name_set_family_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_GIVEN_NAME:
		folks_structured_name_set_given_name (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_ADDITIONAL_NAMES:
		folks_structured_name_set_additional_names (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_PREFIXES:
		folks_structured_name_set_prefixes (self, g_value_get_string (value));
		break;
		case FOLKS_STRUCTURED_NAME_SUFFIXES:
		folks_structured_name_set_suffixes (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_name_details_real_change_structured_name_data_free (gpointer _data) {
	FolksNameDetailsChangeStructuredNameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeStructuredNameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_name_details_real_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksNameDetailsChangeStructuredNameData* _data_;
	FolksNameDetails* _tmp0_ = NULL;
	FolksStructuredName* _tmp1_ = NULL;
	FolksStructuredName* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksNameDetailsChangeStructuredNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_name_details_real_change_structured_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_name_details_real_change_structured_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->name);
	_data_->name = _tmp2_;
	folks_name_details_real_change_structured_name_co (_data_);
}


static void folks_name_details_real_change_structured_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FolksNameDetailsChangeStructuredNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's structured name.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.structured_name} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param name the structured name (``null`` to unset it)
   * @throws PropertyError if setting the structured name failed
   * @since 0.6.2
   */
static gboolean folks_name_details_real_change_structured_name_co (FolksNameDetailsChangeStructuredNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Structured name is not writeable on this contact.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_name_details_change_structured_name (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_structured_name (self, name, _callback_, _user_data_);
}


void folks_name_details_change_structured_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_structured_name_finish (self, _res_, error);
}


static void folks_name_details_real_change_full_name_data_free (gpointer _data) {
	FolksNameDetailsChangeFullNameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->full_name);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeFullNameData, _data_);
}


static void folks_name_details_real_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksNameDetailsChangeFullNameData* _data_;
	FolksNameDetails* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksNameDetailsChangeFullNameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_name_details_real_change_full_name);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_name_details_real_change_full_name_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = full_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->full_name);
	_data_->full_name = _tmp2_;
	folks_name_details_real_change_full_name_co (_data_);
}


static void folks_name_details_real_change_full_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FolksNameDetailsChangeFullNameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's full name.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.full_name} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param full_name the full name (empty string to unset it)
   * @throws PropertyError if setting the full name failed
   * @since 0.6.2
   */
static gboolean folks_name_details_real_change_full_name_co (FolksNameDetailsChangeFullNameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Full name is not writeable on this contact.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_name_details_change_full_name (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_full_name (self, full_name, _callback_, _user_data_);
}


void folks_name_details_change_full_name_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_full_name_finish (self, _res_, error);
}


static void folks_name_details_real_change_nickname_data_free (gpointer _data) {
	FolksNameDetailsChangeNicknameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->nickname);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksNameDetailsChangeNicknameData, _data_);
}


static void folks_name_details_real_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksNameDetailsChangeNicknameData* _data_;
	FolksNameDetails* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksNameDetailsChangeNicknameData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_name_details_real_change_nickname);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_name_details_real_change_nickname_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = nickname;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->nickname);
	_data_->nickname = _tmp2_;
	folks_name_details_real_change_nickname_co (_data_);
}


static void folks_name_details_real_change_nickname_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FolksNameDetailsChangeNicknameData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's nickname.
   *
   * It's preferred to call this rather than setting
   * {@link NameDetails.nickname} directly, as this method gives error
   * notification and will only return once the name has been written to the
   * relevant backing store (or the operation's failed).
   *
   * @param nickname the nickname (empty string to unset it)
   * @throws PropertyError if setting the nickname failed
   * @since 0.6.2
   */
static gboolean folks_name_details_real_change_nickname_co (FolksNameDetailsChangeNicknameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Nickname is not writeable on this contact.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_name_details_change_nickname (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_nickname (self, nickname, _callback_, _user_data_);
}


void folks_name_details_change_nickname_finish (FolksNameDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->change_nickname_finish (self, _res_, error);
}


FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_structured_name (self);
}


void folks_name_details_set_structured_name (FolksNameDetails* self, FolksStructuredName* value) {
	g_return_if_fail (self != NULL);
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_structured_name (self, value);
}


const gchar* folks_name_details_get_full_name (FolksNameDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_full_name (self);
}


void folks_name_details_set_full_name (FolksNameDetails* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_full_name (self, value);
}


const gchar* folks_name_details_get_nickname (FolksNameDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_NAME_DETAILS_GET_INTERFACE (self)->get_nickname (self);
}


void folks_name_details_set_nickname (FolksNameDetails* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	FOLKS_NAME_DETAILS_GET_INTERFACE (self)->set_nickname (self, value);
}


static void folks_name_details_base_init (FolksNameDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The contact name split in its constituent parts.
		   *
		   * Note that most of the time the structured name is not set (i.e.
		   * it's ``null``) or just some of the components are set.
		   * The components are immutable. To get notification of changes of
		   * the structured name, you just have to connect to the ``notify`` signal
		   * of this property.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("structured-name", "structured-name", "structured-name", FOLKS_TYPE_STRUCTURED_NAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * The full name of the contact.
		   *
		   * The full name is the name of the contact written in the way the contact
		   * prefers. For instance for English names this is usually the given name
		   * followed by the family name, but Chinese names are usually the family
		   * name followed by the given name.
		   * The full name could or could not contain additional names (like a
		   * middle name), prefixes or suffixes.
		   *
		   * The full name must not be ``null``: the empty string represents an unset
		   * full name.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("full-name", "full-name", "full-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		/**
		   * The nickname of the contact.
		   *
		   * The nickname is the name that the contact chose for himself. This is
		   * different from {@link AliasDetails.alias} as aliases can be chosen by
		   * the user and not by the contacts themselves.
		   *
		   * Consequently, setting the nickname only makes sense in the context of an
		   * address book when updating the information a contact has specified about
		   * themselves.
		   *
		   * The nickname must not be ``null``: the empty string represents an unset
		   * nickname.
		   *
		   * @since 0.3.5
		   */
		g_object_interface_install_property (iface, g_param_spec_string ("nickname", "nickname", "nickname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_structured_name = folks_name_details_real_change_structured_name;
		iface->change_structured_name_finish = folks_name_details_real_change_structured_name_finish;
		iface->change_full_name = folks_name_details_real_change_full_name;
		iface->change_full_name_finish = folks_name_details_real_change_full_name_finish;
		iface->change_nickname = folks_name_details_real_change_nickname;
		iface->change_nickname_finish = folks_name_details_real_change_nickname_finish;
	}
}


/**
 * Interface for classes which represent contacts with names, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
GType folks_name_details_get_type (void) {
	static volatile gsize folks_name_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_name_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksNameDetailsIface), (GBaseInitFunc) folks_name_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_name_details_type_id;
		folks_name_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksNameDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_name_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_name_details_type_id__volatile, folks_name_details_type_id);
	}
	return folks_name_details_type_id__volatile;
}



