/* chess-clock.c generated by valac 0.30.0, the Vala compiler
 * generated from chess-clock.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CLOCK_TYPE (clock_type_get_type ())

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

typedef enum  {
	CLOCK_TYPE_SIMPLE,
	CLOCK_TYPE_FISCHER,
	CLOCK_TYPE_BRONSTEIN,
	CLOCK_TYPE_INVALID
} ClockType;

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessClockPrivate {
	gint _white_initial_seconds;
	gint _black_initial_seconds;
	gint _white_seconds_used;
	gint _black_seconds_used;
	ClockType _clock_type;
	gint _white_prev_move_seconds;
	gint _black_prev_move_seconds;
	gint _white_extra_seconds;
	gint _black_extra_seconds;
	Color _active_color;
	gint _extra_seconds;
	GTimer* timer;
	guint tick_timeout_id;
	gboolean is_active;
};


static gpointer chess_clock_parent_class = NULL;

GType clock_type_get_type (void) G_GNUC_CONST;
gchar* clock_type_to_string (ClockType self);
ClockType clock_type_string_to_enum (const gchar* s);
GType chess_clock_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
#define CHESS_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_CLOCK, ChessClockPrivate))
enum  {
	CHESS_CLOCK_DUMMY_PROPERTY,
	CHESS_CLOCK_WHITE_INITIAL_SECONDS,
	CHESS_CLOCK_BLACK_INITIAL_SECONDS,
	CHESS_CLOCK_WHITE_SECONDS_USED,
	CHESS_CLOCK_BLACK_SECONDS_USED,
	CHESS_CLOCK_CLOCK_TYPE,
	CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS,
	CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS,
	CHESS_CLOCK_WHITE_EXTRA_SECONDS,
	CHESS_CLOCK_BLACK_EXTRA_SECONDS,
	CHESS_CLOCK_EXTRA_SECONDS,
	CHESS_CLOCK_ACTIVE_COLOR
};
void chess_clock_update_prev_move_time (ChessClock* self);
Color chess_clock_get_active_color (ChessClock* self);
gint chess_clock_get_black_seconds_used (ChessClock* self);
static void chess_clock_set_black_prev_move_seconds (ChessClock* self, gint value);
gint chess_clock_get_white_seconds_used (ChessClock* self);
static void chess_clock_set_white_prev_move_seconds (ChessClock* self, gint value);
void chess_clock_update_extra_seconds (ChessClock* self);
ClockType chess_clock_get_clock_type (ChessClock* self);
gint chess_clock_get_white_extra_seconds (ChessClock* self);
gint chess_clock_get_extra_seconds (ChessClock* self);
static void chess_clock_set_white_extra_seconds (ChessClock* self, gint value);
gint chess_clock_get_black_extra_seconds (ChessClock* self);
static void chess_clock_set_black_extra_seconds (ChessClock* self, gint value);
gint chess_clock_get_white_prev_move_seconds (ChessClock* self);
gint chess_clock_get_black_prev_move_seconds (ChessClock* self);
ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds);
static void chess_clock_set_white_initial_seconds (ChessClock* self, gint value);
static void chess_clock_set_black_initial_seconds (ChessClock* self, gint value);
void chess_clock_start (ChessClock* self);
static void chess_clock_watch_timer (ChessClock* self);
static gboolean chess_clock_tick_cb (ChessClock* self);
static void chess_clock_set_white_seconds_used (ChessClock* self, gint value);
static void chess_clock_set_black_seconds_used (ChessClock* self, gint value);
gint chess_clock_get_white_initial_seconds (ChessClock* self);
gint chess_clock_get_black_initial_seconds (ChessClock* self);
void chess_clock_stop (ChessClock* self);
static void chess_clock_stop_watching_timer (ChessClock* self);
void chess_clock_pause (ChessClock* self);
void chess_clock_unpause (ChessClock* self);
static gboolean _chess_clock_tick_cb_gsource_func (gpointer self);
void chess_clock_set_clock_type (ChessClock* self, ClockType value);
void chess_clock_set_extra_seconds (ChessClock* self, gint value);
void chess_clock_set_active_color (ChessClock* self, Color value);
static void chess_clock_finalize (GObject* obj);
static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gchar* clock_type_to_string (ClockType self) {
	gchar* result = NULL;
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	switch (self) {
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_SIMPLE:
#line 145 "chess-clock.c"
		{
			gchar* _tmp0_ = NULL;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp0_ = g_strdup ("simple");
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			result = _tmp0_;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			return result;
#line 154 "chess-clock.c"
		}
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_FISCHER:
#line 158 "chess-clock.c"
		{
			gchar* _tmp1_ = NULL;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp1_ = g_strdup ("fischer");
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			result = _tmp1_;
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			return result;
#line 167 "chess-clock.c"
		}
#line 22 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_BRONSTEIN:
#line 171 "chess-clock.c"
		{
			gchar* _tmp2_ = NULL;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp2_ = g_strdup ("bronstein");
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			result = _tmp2_;
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			return result;
#line 180 "chess-clock.c"
		}
		default:
		{
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			g_assert_not_reached ();
#line 186 "chess-clock.c"
		}
	}
}


ClockType clock_type_string_to_enum (const gchar* s) {
	ClockType result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	static GQuark _tmp2_label0 = 0;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	static GQuark _tmp2_label1 = 0;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	static GQuark _tmp2_label2 = 0;
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (s != NULL, 0);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = s;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("simple")))) {
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 215 "chess-clock.c"
			default:
			{
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_SIMPLE;
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				return result;
#line 222 "chess-clock.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("fischer")))) {
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 228 "chess-clock.c"
			default:
			{
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_FISCHER;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				return result;
#line 235 "chess-clock.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("bronstein")))) {
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 241 "chess-clock.c"
			default:
			{
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_BRONSTEIN;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				return result;
#line 248 "chess-clock.c"
			}
		}
	} else {
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		switch (0) {
#line 254 "chess-clock.c"
			default:
			{
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				result = CLOCK_TYPE_INVALID;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				return result;
#line 261 "chess-clock.c"
			}
		}
	}
}


GType clock_type_get_type (void) {
	static volatile gsize clock_type_type_id__volatile = 0;
	if (g_once_init_enter (&clock_type_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCK_TYPE_SIMPLE, "CLOCK_TYPE_SIMPLE", "simple"}, {CLOCK_TYPE_FISCHER, "CLOCK_TYPE_FISCHER", "fischer"}, {CLOCK_TYPE_BRONSTEIN, "CLOCK_TYPE_BRONSTEIN", "bronstein"}, {CLOCK_TYPE_INVALID, "CLOCK_TYPE_INVALID", "invalid"}, {0, NULL, NULL}};
		GType clock_type_type_id;
		clock_type_type_id = g_enum_register_static ("ClockType", values);
		g_once_init_leave (&clock_type_type_id__volatile, clock_type_type_id);
	}
	return clock_type_type_id__volatile;
}


void chess_clock_update_prev_move_time (ChessClock* self) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = chess_clock_get_active_color (self);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == COLOR_WHITE) {
#line 291 "chess-clock.c"
		gint _tmp2_ = 0;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = self->priv->_black_seconds_used;
#line 78 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_prev_move_seconds (self, _tmp2_);
#line 297 "chess-clock.c"
	} else {
		gint _tmp3_ = 0;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = self->priv->_white_seconds_used;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_prev_move_seconds (self, _tmp3_);
#line 304 "chess-clock.c"
	}
}


void chess_clock_update_extra_seconds (ChessClock* self) {
	gint white_move_used = 0;
	gint black_move_used = 0;
	ClockType _tmp0_ = 0;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	white_move_used = 0;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	black_move_used = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_clock_type;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	switch (_tmp0_) {
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_SIMPLE:
#line 325 "chess-clock.c"
		{
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			break;
#line 329 "chess-clock.c"
		}
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_FISCHER:
#line 333 "chess-clock.c"
		{
			Color _tmp1_ = 0;
			Color _tmp2_ = 0;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp1_ = chess_clock_get_active_color (self);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp2_ = _tmp1_;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			if (_tmp2_ == COLOR_WHITE) {
#line 343 "chess-clock.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp3_ = self->priv->_white_extra_seconds;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp4_ = self->priv->_extra_seconds;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_white_extra_seconds (self, _tmp3_ + _tmp4_);
#line 352 "chess-clock.c"
			} else {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp5_ = self->priv->_black_extra_seconds;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp6_ = self->priv->_extra_seconds;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_black_extra_seconds (self, _tmp5_ + _tmp6_);
#line 362 "chess-clock.c"
			}
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			break;
#line 366 "chess-clock.c"
		}
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CLOCK_TYPE_BRONSTEIN:
#line 370 "chess-clock.c"
		{
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			Color _tmp11_ = 0;
			Color _tmp12_ = 0;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp7_ = self->priv->_white_seconds_used;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp8_ = self->priv->_white_prev_move_seconds;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			white_move_used = _tmp7_ - _tmp8_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp9_ = self->priv->_black_seconds_used;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp10_ = self->priv->_black_prev_move_seconds;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			black_move_used = _tmp9_ - _tmp10_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp11_ = chess_clock_get_active_color (self);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			_tmp12_ = _tmp11_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			if (_tmp12_ != COLOR_WHITE) {
#line 396 "chess-clock.c"
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp13_ = self->priv->_white_extra_seconds;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp14_ = self->priv->_extra_seconds;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp15_ = white_move_used;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp16_ = MIN (_tmp14_, _tmp15_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_white_extra_seconds (self, _tmp13_ + _tmp16_);
#line 411 "chess-clock.c"
			} else {
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp17_ = self->priv->_black_extra_seconds;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp18_ = self->priv->_extra_seconds;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp19_ = black_move_used;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				_tmp20_ = MIN (_tmp18_, _tmp19_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
				chess_clock_set_black_extra_seconds (self, _tmp17_ + _tmp20_);
#line 427 "chess-clock.c"
			}
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
			break;
#line 431 "chess-clock.c"
		}
		default:
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 436 "chess-clock.c"
	}
}


ChessClock* chess_clock_construct (GType object_type, gint white_initial_seconds, gint black_initial_seconds) {
	ChessClock * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self = (ChessClock*) g_object_new (object_type, NULL);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = white_initial_seconds;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_set_white_initial_seconds (self, _tmp0_);
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = black_initial_seconds;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_set_black_initial_seconds (self, _tmp1_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return self;
#line 457 "chess-clock.c"
}


ChessClock* chess_clock_new (gint white_initial_seconds, gint black_initial_seconds) {
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return chess_clock_construct (TYPE_CHESS_CLOCK, white_initial_seconds, black_initial_seconds);
#line 464 "chess-clock.c"
}


void chess_clock_start (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->is_active;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp0_) {
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		return;
#line 479 "chess-clock.c"
	}
#line 146 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = TRUE;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == NULL) {
#line 487 "chess-clock.c"
		GTimer* _tmp2_ = NULL;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = g_timer_new ();
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_g_timer_destroy0 (self->priv->timer);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		self->priv->timer = _tmp2_;
#line 495 "chess-clock.c"
	} else {
		GTimer* _tmp3_ = NULL;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = self->priv->timer;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_timer_start (_tmp3_);
#line 502 "chess-clock.c"
	}
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_watch_timer (self);
#line 506 "chess-clock.c"
}


static gboolean chess_clock_tick_cb (ChessClock* self) {
	gboolean result = FALSE;
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = chess_clock_get_active_color (self);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = _tmp0_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == COLOR_WHITE) {
#line 525 "chess-clock.c"
		gint _tmp2_ = 0;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = self->priv->_white_seconds_used;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_seconds_used (self, _tmp2_ + 1);
#line 531 "chess-clock.c"
	} else {
		gint _tmp3_ = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp3_ = self->priv->_black_seconds_used;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_seconds_used (self, _tmp3_ + 1);
#line 538 "chess-clock.c"
	}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_signal_emit_by_name (self, "tick");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp5_ = self->priv->_white_seconds_used;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp6_ = self->priv->_white_initial_seconds;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp5_ >= _tmp6_) {
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp4_ = TRUE;
#line 550 "chess-clock.c"
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp7_ = self->priv->_black_seconds_used;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp8_ = self->priv->_black_initial_seconds;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp4_ = _tmp7_ >= _tmp8_;
#line 560 "chess-clock.c"
	}
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp4_) {
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_stop (self);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_signal_emit_by_name (self, "expired");
#line 568 "chess-clock.c"
	}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = G_SOURCE_CONTINUE;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 574 "chess-clock.c"
}


void chess_clock_stop (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->is_active;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (!_tmp0_) {
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		return;
#line 589 "chess-clock.c"
	}
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_timer_stop (_tmp1_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_stop_watching_timer (self);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = FALSE;
#line 599 "chess-clock.c"
}


void chess_clock_pause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->is_active;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (!_tmp0_) {
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		return;
#line 614 "chess-clock.c"
	}
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_timer_stop (_tmp1_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_stop_watching_timer (self);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = FALSE;
#line 624 "chess-clock.c"
}


void chess_clock_unpause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	GTimer* _tmp3_ = NULL;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = self->priv->timer;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp1_ == NULL) {
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = TRUE;
#line 640 "chess-clock.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp2_ = self->priv->is_active;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		_tmp0_ = _tmp2_;
#line 647 "chess-clock.c"
	}
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp0_) {
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		return;
#line 653 "chess-clock.c"
	}
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp3_ = self->priv->timer;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_timer_continue (_tmp3_);
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_watch_timer (self);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = TRUE;
#line 663 "chess-clock.c"
}


static gboolean _chess_clock_tick_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_tick_cb ((ChessClock*) self);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 672 "chess-clock.c"
}


static void chess_clock_watch_timer (ChessClock* self) {
	guint _tmp0_ = 0U;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _chess_clock_tick_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->tick_timeout_id = _tmp0_;
#line 684 "chess-clock.c"
}


static void chess_clock_stop_watching_timer (ChessClock* self) {
	guint _tmp0_ = 0U;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->tick_timeout_id;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_source_remove (_tmp0_);
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->tick_timeout_id = (guint) 0;
#line 698 "chess-clock.c"
}


gint chess_clock_get_white_initial_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_initial_seconds;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 713 "chess-clock.c"
}


static void chess_clock_set_white_initial_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_initial_seconds = _tmp0_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "white-initial-seconds");
#line 727 "chess-clock.c"
}


gint chess_clock_get_black_initial_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_initial_seconds;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 742 "chess-clock.c"
}


static void chess_clock_set_black_initial_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_initial_seconds = _tmp0_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "black-initial-seconds");
#line 756 "chess-clock.c"
}


gint chess_clock_get_white_seconds_used (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_seconds_used;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 771 "chess-clock.c"
}


static void chess_clock_set_white_seconds_used (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_seconds_used = _tmp0_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "white-seconds-used");
#line 785 "chess-clock.c"
}


gint chess_clock_get_black_seconds_used (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_seconds_used;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 800 "chess-clock.c"
}


static void chess_clock_set_black_seconds_used (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_seconds_used = _tmp0_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "black-seconds-used");
#line 814 "chess-clock.c"
}


ClockType chess_clock_get_clock_type (ChessClock* self) {
	ClockType result;
	ClockType _tmp0_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_clock_type;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 829 "chess-clock.c"
}


void chess_clock_set_clock_type (ChessClock* self, ClockType value) {
	ClockType _tmp0_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_clock_type = _tmp0_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "clock-type");
#line 843 "chess-clock.c"
}


gint chess_clock_get_white_prev_move_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_prev_move_seconds;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 858 "chess-clock.c"
}


static void chess_clock_set_white_prev_move_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_prev_move_seconds = _tmp0_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "white-prev-move-seconds");
#line 872 "chess-clock.c"
}


gint chess_clock_get_black_prev_move_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_prev_move_seconds;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 887 "chess-clock.c"
}


static void chess_clock_set_black_prev_move_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_prev_move_seconds = _tmp0_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "black-prev-move-seconds");
#line 901 "chess-clock.c"
}


gint chess_clock_get_white_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_white_extra_seconds;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 916 "chess-clock.c"
}


static void chess_clock_set_white_extra_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_extra_seconds = _tmp0_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "white-extra-seconds");
#line 930 "chess-clock.c"
}


gint chess_clock_get_black_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_black_extra_seconds;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 945 "chess-clock.c"
}


static void chess_clock_set_black_extra_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_extra_seconds = _tmp0_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "black-extra-seconds");
#line 959 "chess-clock.c"
}


gint chess_clock_get_extra_seconds (ChessClock* self) {
	gint result;
	gint _tmp0_ = 0;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_extra_seconds;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 974 "chess-clock.c"
}


void chess_clock_set_extra_seconds (ChessClock* self, gint value) {
	gint _tmp0_ = 0;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_extra_seconds = _tmp0_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "extra-seconds");
#line 988 "chess-clock.c"
}


Color chess_clock_get_active_color (ChessClock* self) {
	Color result;
	Color _tmp0_ = 0;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = self->priv->_active_color;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	result = _tmp0_;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	return result;
#line 1003 "chess-clock.c"
}


void chess_clock_set_active_color (ChessClock* self, Color value) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
	Color _tmp3_ = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp0_ = value;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp1_ = chess_clock_get_active_color (self);
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	if (_tmp0_ == _tmp2_) {
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		return;
#line 1024 "chess-clock.c"
	}
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_stop (self);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_tmp3_ = value;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_active_color = _tmp3_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_update_extra_seconds (self);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_update_prev_move_time (self);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_start (self);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_notify ((GObject *) self, "active-color");
#line 1040 "chess-clock.c"
}


static void chess_clock_class_init (ChessClockClass * klass) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	chess_clock_parent_class = g_type_class_peek_parent (klass);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_type_class_add_private (klass, sizeof (ChessClockPrivate));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_clock_get_property;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_clock_set_property;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_clock_finalize;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_INITIAL_SECONDS, g_param_spec_int ("white-initial-seconds", "white-initial-seconds", "white-initial-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_INITIAL_SECONDS, g_param_spec_int ("black-initial-seconds", "black-initial-seconds", "black-initial-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_SECONDS_USED, g_param_spec_int ("white-seconds-used", "white-seconds-used", "white-seconds-used", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_SECONDS_USED, g_param_spec_int ("black-seconds-used", "black-seconds-used", "black-seconds-used", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_CLOCK_TYPE, g_param_spec_enum ("clock-type", "clock-type", "clock-type", TYPE_CLOCK_TYPE, CLOCK_TYPE_SIMPLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS, g_param_spec_int ("white-prev-move-seconds", "white-prev-move-seconds", "white-prev-move-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS, g_param_spec_int ("black-prev-move-seconds", "black-prev-move-seconds", "black-prev-move-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_EXTRA_SECONDS, g_param_spec_int ("white-extra-seconds", "white-extra-seconds", "white-extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_EXTRA_SECONDS, g_param_spec_int ("black-extra-seconds", "black-extra-seconds", "black-extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_EXTRA_SECONDS, g_param_spec_int ("extra-seconds", "extra-seconds", "extra-seconds", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_ACTIVE_COLOR, g_param_spec_enum ("active-color", "active-color", "active-color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_signal_new ("tick", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	g_signal_new ("expired", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1081 "chess-clock.c"
}


static void chess_clock_instance_init (ChessClock * self) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv = CHESS_CLOCK_GET_PRIVATE (self);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_seconds_used = 0;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_seconds_used = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_clock_type = CLOCK_TYPE_SIMPLE;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_prev_move_seconds = 0;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_prev_move_seconds = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_white_extra_seconds = 0;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_black_extra_seconds = 0;
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_active_color = COLOR_WHITE;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->_extra_seconds = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->tick_timeout_id = (guint) 0;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self->priv->is_active = FALSE;
#line 1110 "chess-clock.c"
}


static void chess_clock_finalize (GObject* obj) {
	ChessClock * self;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_CLOCK, ChessClock);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	G_OBJECT_CLASS (chess_clock_parent_class)->finalize (obj);
#line 1122 "chess-clock.c"
}


GType chess_clock_get_type (void) {
	static volatile gsize chess_clock_type_id__volatile = 0;
	if (g_once_init_enter (&chess_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessClock), 0, (GInstanceInitFunc) chess_clock_instance_init, NULL };
		GType chess_clock_type_id;
		chess_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessClock", &g_define_type_info, 0);
		g_once_init_leave (&chess_clock_type_id__volatile, chess_clock_type_id);
	}
	return chess_clock_type_id__volatile;
}


static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	switch (property_id) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_initial_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_initial_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_SECONDS_USED:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_seconds_used (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_SECONDS_USED:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_seconds_used (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_CLOCK_TYPE:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_enum (value, chess_clock_get_clock_type (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_prev_move_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_prev_move_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_EXTRA_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_white_extra_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_EXTRA_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_black_extra_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_EXTRA_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_int (value, chess_clock_get_extra_seconds (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_ACTIVE_COLOR:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		g_value_set_enum (value, chess_clock_get_active_color (self));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 1209 "chess-clock.c"
		default:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 1215 "chess-clock.c"
	}
}


static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
	switch (property_id) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_initial_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_initial_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_SECONDS_USED:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_seconds_used (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_SECONDS_USED:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_seconds_used (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_CLOCK_TYPE:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_clock_type (self, g_value_get_enum (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_PREV_MOVE_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_prev_move_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_PREV_MOVE_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_prev_move_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_WHITE_EXTRA_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_white_extra_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_BLACK_EXTRA_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_black_extra_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_EXTRA_SECONDS:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_extra_seconds (self, g_value_get_int (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		case CHESS_CLOCK_ACTIVE_COLOR:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		chess_clock_set_active_color (self, g_value_get_enum (value));
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 1291 "chess-clock.c"
		default:
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-chess/lib/chess-clock.vala"
		break;
#line 1297 "chess-clock.c"
	}
}



