/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.28 from the
 * contents of Core.xs. Do not edit this file, edit Core.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Core.xs"
#define PERL_NO_GET_CONTEXT
#include "module.h"
#include "irssi-version.h"
#include "core.h"

#include "pidwait.h"
#include "session.h"

#define DEFAULT_COMMAND_CATEGORY "Perl scripts' commands"

static void perl_signal_add_hash(int priority, SV *sv)
{
	HV *hv;
        HE *he;
	I32 len;

	if (!is_hvref(sv))
		croak("Usage: Irssi::signal_add(hash)");

        hv = hvref(sv);
	hv_iterinit(hv);
	while ((he = hv_iternext(hv)) != NULL)
                perl_signal_add_full(hv_iterkey(he, &len), HeVAL(he), priority);
}

static void perl_command_bind_add_hash(int priority, SV *sv, char *category)
{
	HV *hv;
        HE *he;
	I32 len;

        hv = hvref(sv);
	hv_iterinit(hv);
	while ((he = hv_iternext(hv)) != NULL)
		perl_command_bind_to(hv_iterkey(he, &len), category, HeVAL(he), priority);
}

static void handle_command_bind(int priority, int items, SV *p0, SV *p1, SV *p2)
{
	char *category;
	int hash;

	hash = items > 0 && is_hvref(p0);
	if (!hash) {
		if (items < 2 || items > 3)
			croak("Usage: Irssi::command_bind(signal, func, category)");
	} else if (items > 2)
		croak("Usage: Irssi::command_bind(signals_hash, category)");

	if (!hash) {
		category = items < 3 ? DEFAULT_COMMAND_CATEGORY :
			SvPV_nolen(p2);
		perl_command_bind_to(SvPV_nolen(p0), category, p1, priority);
	} else {
		category = items < 2 ? DEFAULT_COMMAND_CATEGORY :
			SvPV_nolen(p1);
		perl_command_bind_add_hash(priority, p0, category);
	}
}

static void add_tuple(gpointer key_, gpointer value_, gpointer user_data)
{
	HV *hash = user_data;
	char *key = key_;
	char *value = value_;
	(void) hv_store(hash, key, strlen(key), new_pv(value), 0);
}

static void wrap_signal_emit(void *signal, void **p) {
	signal_emit(signal, 6, p[0], p[1], p[2], p[3], p[4], p[5]);
}

static void wrap_signal_continue(void *dummy, void **p) {
	(void)dummy;
	signal_continue(6, p[0], p[1], p[2], p[3], p[4], p[5]);
}

#line 88 "Core.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 232 "Core.c"

XS_EUPXS(XS_Irssi_signal_emit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_emit)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "signal, ...");
    {
	char *	signal = (char *)SvPV_nolen(ST(0))
;
#line 85 "Core.xs"
	int signal_id;
	SV *args[SIGNAL_MAX_ARGUMENTS];
	int n, used;

	signal_id = signal_get_uniq_id(signal);
	used = items - 1;
	if (used > SIGNAL_MAX_ARGUMENTS) {
		used = SIGNAL_MAX_ARGUMENTS;
	}
	for (n = 0; n < used; ++n) {
		args[n] = ST(n + 1);
	}
	perl_signal_args_to_c(wrap_signal_emit, signal, signal_id, args, used);
#line 257 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_continue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_continue)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 102 "Core.xs"
	SV *args[SIGNAL_MAX_ARGUMENTS];
	int n, used;

	used = items;
	if (used > SIGNAL_MAX_ARGUMENTS) {
		used = SIGNAL_MAX_ARGUMENTS;
	}
	for (n = 0; n < used; ++n) {
		args[n] = ST(n);
	}
	perl_signal_args_to_c(wrap_signal_continue, NULL, signal_get_emitted_id(), args, used);
#line 281 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_add)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 117 "Core.xs"
	if (items != 1 && items != 2)
		croak("Usage: Irssi::signal_add(signal, func)");
	if (items == 2)
		perl_signal_add_full(SvPV_nolen(ST(0)), ST(1),
				     SIGNAL_PRIORITY_DEFAULT);
	else
		perl_signal_add_hash(SIGNAL_PRIORITY_DEFAULT, ST(0));
#line 301 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_add_first); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_add_first)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 128 "Core.xs"
	if (items != 1 && items != 2)
		croak("Usage: Irssi::signal_add_first(signal, func)");
	if (items == 2)
		perl_signal_add_full(SvPV_nolen(ST(0)), ST(1),
				     SIGNAL_PRIORITY_HIGH);
	else
		perl_signal_add_hash(SIGNAL_PRIORITY_HIGH, ST(0));
#line 321 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_add_last); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_add_last)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 139 "Core.xs"
	if (items != 1 && items != 2)
		croak("Usage: Irssi::signal_add_last(signal, func)");
	if (items == 2)
		perl_signal_add_full(SvPV_nolen(ST(0)), ST(1),
				     SIGNAL_PRIORITY_LOW);
	else
		perl_signal_add_hash(SIGNAL_PRIORITY_LOW, ST(0));
#line 341 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_add_priority); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_add_priority)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 150 "Core.xs"
	if (items != 2 && items != 3)
		croak("Usage: Irssi::signal_add_priority(signal, func, priority)");
	if (items == 3)
		perl_signal_add_full(SvPV_nolen(ST(0)), ST(1), SvIV(ST(2)));
	else
		perl_signal_add_hash(SvIV(ST(0)), ST(1));
#line 360 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_register); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_register)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 160 "Core.xs"
	HV *hv;
        HE *he;
	I32 len, pos;
	const char *arr[7];
#line 377 "Core.c"
#line 165 "Core.xs"
	if (items != 1 || !is_hvref(ST(0)))
		croak("Usage: Irssi::signal_register(hash)");

        hv = hvref(ST(0));
	hv_iterinit(hv);
	while ((he = hv_iternext(hv)) != NULL) {
		const char *key = hv_iterkey(he, &len);
		SV *val = HeVAL(he);
		AV *av;

		if (!SvROK(val) || SvTYPE(SvRV(val)) != SVt_PVAV)
			croak("not array reference");

		av = (AV *) SvRV(val);
		len = av_len(av)+1;
		if (len > 6) len = 6;
		for (pos = 0; pos < len; pos++) {
                	SV **val = av_fetch(av, pos, 0);
			arr[pos] = SvPV_nolen(*val);
		}
		arr[pos] = NULL;
		perl_signal_register(key, arr);
	}
#line 402 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_SIGNAL_PRIORITY_LOW); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_SIGNAL_PRIORITY_LOW)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 193 "Core.xs"
	RETVAL = SIGNAL_PRIORITY_LOW;
#line 419 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_SIGNAL_PRIORITY_DEFAULT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_SIGNAL_PRIORITY_DEFAULT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 200 "Core.xs"
	RETVAL = SIGNAL_PRIORITY_DEFAULT;
#line 437 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_SIGNAL_PRIORITY_HIGH); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_SIGNAL_PRIORITY_HIGH)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 207 "Core.xs"
	RETVAL = SIGNAL_PRIORITY_HIGH;
#line 455 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_signal_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_remove)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "signal, func");
    {
	char *	signal = (char *)SvPV_nolen(ST(0))
;
	SV *	func = ST(1)
;
#line 216 "Core.xs"
	perl_signal_remove(signal, func);
#line 475 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_stop); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_stop)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	signal_stop();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_stop_by_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_stop_by_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "signal");
    {
	char *	signal = (char *)SvPV_nolen(ST(0))
;

	signal_stop_by_name(signal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_signal_get_emitted); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_get_emitted)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 228 "Core.xs"
	RETVAL = (char *) signal_get_emitted();
#line 522 "Core.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_signal_get_emitted_id); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_signal_get_emitted_id)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = signal_get_emitted_id();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_timeout_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_timeout_add)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "msecs, func, data");
    {
	int	msecs = (int)SvIV(ST(0))
;
	SV *	func = ST(1)
;
	SV *	data = ST(2)
;
	int	RETVAL;
	dXSTARG;
#line 241 "Core.xs"
	if (msecs < 10) {
		croak("Irssi::timeout() : msecs must be >= 10");
		RETVAL = -1;
	} else {
		RETVAL = perl_timeout_add(msecs, func, data, FALSE);
	}
#line 568 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_timeout_add_once); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_timeout_add_once)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "msecs, func, data");
    {
	int	msecs = (int)SvIV(ST(0))
;
	SV *	func = ST(1)
;
	SV *	data = ST(2)
;
	int	RETVAL;
	dXSTARG;
#line 256 "Core.xs"
	if (msecs < 10) {
		croak("Irssi::timeout_once() : msecs must be >= 10");
		RETVAL = -1;
	} else {
		RETVAL = perl_timeout_add(msecs, func, data, TRUE);
	}
#line 597 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_timeout_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_timeout_remove)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0))
;
#line 269 "Core.xs"
	perl_source_remove(tag);
#line 615 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_INPUT_READ); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_INPUT_READ)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 275 "Core.xs"
	RETVAL = G_INPUT_READ;
#line 632 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_INPUT_WRITE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_INPUT_WRITE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 282 "Core.xs"
	RETVAL = G_INPUT_WRITE;
#line 650 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_input_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_input_add)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "source, condition, func, data");
    {
	int	source = (int)SvIV(ST(0))
;
	int	condition = (int)SvIV(ST(1))
;
	SV *	func = ST(2)
;
	SV *	data = ST(3)
;
	int	RETVAL;
	dXSTARG;
#line 293 "Core.xs"
	RETVAL = perl_input_add(source, condition, func, data, FALSE);
#line 676 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_input_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_input_remove)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "tag");
    {
	int	tag = (int)SvIV(ST(0))
;
#line 301 "Core.xs"
	perl_source_remove(tag);
#line 694 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_MSGLEVEL_CRAP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_CRAP)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 307 "Core.xs"
	RETVAL = MSGLEVEL_CRAP;
#line 711 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_MSGS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_MSGS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 314 "Core.xs"
	RETVAL = MSGLEVEL_MSGS;
#line 729 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_PUBLIC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_PUBLIC)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 321 "Core.xs"
	RETVAL = MSGLEVEL_PUBLIC;
#line 747 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_NOTICES); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_NOTICES)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 328 "Core.xs"
	RETVAL = MSGLEVEL_NOTICES;
#line 765 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_SNOTES); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_SNOTES)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 335 "Core.xs"
	RETVAL = MSGLEVEL_SNOTES;
#line 783 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_CTCPS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_CTCPS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 342 "Core.xs"
	RETVAL = MSGLEVEL_CTCPS;
#line 801 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_ACTIONS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_ACTIONS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 349 "Core.xs"
	RETVAL = MSGLEVEL_ACTIONS;
#line 819 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_JOINS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_JOINS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 356 "Core.xs"
	RETVAL = MSGLEVEL_JOINS;
#line 837 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_PARTS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_PARTS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 363 "Core.xs"
	RETVAL = MSGLEVEL_PARTS;
#line 855 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_QUITS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_QUITS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 370 "Core.xs"
	RETVAL = MSGLEVEL_QUITS;
#line 873 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_KICKS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_KICKS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 377 "Core.xs"
	RETVAL = MSGLEVEL_KICKS;
#line 891 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_MODES); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_MODES)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 384 "Core.xs"
	RETVAL = MSGLEVEL_MODES;
#line 909 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_TOPICS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_TOPICS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 391 "Core.xs"
	RETVAL = MSGLEVEL_TOPICS;
#line 927 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_WALLOPS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_WALLOPS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 398 "Core.xs"
	RETVAL = MSGLEVEL_WALLOPS;
#line 945 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_INVITES); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_INVITES)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 405 "Core.xs"
	RETVAL = MSGLEVEL_INVITES;
#line 963 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_NICKS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_NICKS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 412 "Core.xs"
	RETVAL = MSGLEVEL_NICKS;
#line 981 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_DCC); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_DCC)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 419 "Core.xs"
	RETVAL = MSGLEVEL_DCC;
#line 999 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_DCCMSGS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_DCCMSGS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 426 "Core.xs"
	RETVAL = MSGLEVEL_DCCMSGS;
#line 1017 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_CLIENTNOTICE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_CLIENTNOTICE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 433 "Core.xs"
	RETVAL = MSGLEVEL_CLIENTNOTICE;
#line 1035 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_CLIENTCRAP); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_CLIENTCRAP)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 440 "Core.xs"
	RETVAL = MSGLEVEL_CLIENTCRAP;
#line 1053 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_CLIENTERROR); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_CLIENTERROR)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 447 "Core.xs"
	RETVAL = MSGLEVEL_CLIENTERROR;
#line 1071 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_HILIGHT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_HILIGHT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 454 "Core.xs"
	RETVAL = MSGLEVEL_HILIGHT;
#line 1089 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_ALL); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_ALL)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 461 "Core.xs"
	RETVAL = MSGLEVEL_ALL;
#line 1107 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_NOHILIGHT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_NOHILIGHT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 468 "Core.xs"
	RETVAL = MSGLEVEL_NOHILIGHT;
#line 1125 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_NO_ACT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_NO_ACT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 475 "Core.xs"
	RETVAL = MSGLEVEL_NO_ACT;
#line 1143 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_NEVER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_NEVER)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 482 "Core.xs"
	RETVAL = MSGLEVEL_NEVER;
#line 1161 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_MSGLEVEL_LASTLOG); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_MSGLEVEL_LASTLOG)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 489 "Core.xs"
	RETVAL = MSGLEVEL_LASTLOG;
#line 1179 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_level2bits); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_level2bits)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "str");
    {
	char *	str = (char *)SvPV_nolen(ST(0))
;
	int	RETVAL;
	dXSTARG;
#line 497 "Core.xs"
	RETVAL = level2bits(str, NULL);
#line 1199 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_bits2level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_bits2level)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "bits");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	bits = (int)SvIV(ST(0))
;
#line 505 "Core.xs"
	char *ret;
#line 1219 "Core.c"
#line 507 "Core.xs"
	ret = bits2level(bits);
	XPUSHs(sv_2mortal(new_pv(ret)));
	g_free(ret);
#line 1224 "Core.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Irssi_combine_level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_combine_level)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "level, str");
    {
	int	level = (int)SvIV(ST(0))
;
	char *	str = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = combine_level(level, str);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "cmd");
    {
	char *	cmd = (char *)SvPV_nolen(ST(0))
;
#line 520 "Core.xs"
	perl_command(cmd, NULL, NULL);
#line 1263 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_commands); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_commands)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 525 "Core.xs"
	GSList *tmp;
#line 1280 "Core.c"
#line 527 "Core.xs"
	for (tmp = commands; tmp != NULL; tmp = tmp->next) {
		XPUSHs(sv_2mortal(plain_bless(tmp->data, "Irssi::Command")));
	}
#line 1285 "Core.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Irssi_command_bind_first); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_bind_first)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 534 "Core.xs"
	handle_command_bind(SIGNAL_PRIORITY_HIGH, items, ST(0), ST(1), ST(2));
#line 1300 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_command_bind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_bind)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 539 "Core.xs"
	handle_command_bind(SIGNAL_PRIORITY_DEFAULT, items, ST(0), ST(1), ST(2));
#line 1314 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_command_bind_last); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_bind_last)
{
    dVAR; dXSARGS;
    PERL_UNUSED_VAR(cv); /* -W */
    {
#line 544 "Core.xs"
	handle_command_bind(SIGNAL_PRIORITY_LOW, items, ST(0), ST(1), ST(2));
#line 1328 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_command_runsub); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_runsub)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "cmd, data, server, item");
    {
	char *	cmd = (char *)SvPV_nolen(ST(0))
;
	char *	data = (char *)SvPV_nolen(ST(1))
;
	Irssi__Server	server = irssi_ref_object(ST(2))
;
	Irssi__Windowitem	item = irssi_ref_object(ST(3))
;
#line 553 "Core.xs"
	perl_command_runsub(cmd, data, server, item);
#line 1351 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_command_unbind); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_unbind)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cmd, func");
    {
	char *	cmd = (char *)SvPV_nolen(ST(0))
;
	SV *	func = ST(1)
;
#line 560 "Core.xs"
	perl_command_unbind(cmd, func);
#line 1370 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_command_set_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_set_options)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cmd, options");
    {
	char *	cmd = (char *)SvPV_nolen(ST(0))
;
	char *	options = (char *)SvPV_nolen(ST(1))
;

	command_set_options(cmd, options);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_command_parse_options); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_command_parse_options)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "cmd, data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	cmd = (char *)SvPV_nolen(ST(0))
;
	char *	data = (char *)SvPV_nolen(ST(1))
;
#line 572 "Core.xs"
	HV *hash;
	GHashTable *optlist;
	void *free_arg;
	char *ptr;
#line 1412 "Core.c"
#line 577 "Core.xs"
	if (cmd_get_params(data, &free_arg, 1 | PARAM_FLAG_OPTIONS | PARAM_FLAG_GETREST,
			   cmd, &optlist, &ptr)) {
		hash = newHV();
		g_hash_table_foreach(optlist, add_tuple, hash);
		XPUSHs(sv_2mortal(newRV_noinc((SV*)hash)));
		XPUSHs(sv_2mortal(new_pv(ptr)));
		cmd_params_free(free_arg);
	} else {
		XPUSHs(&PL_sv_undef);
		XPUSHs(&PL_sv_undef);
	}
#line 1425 "Core.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Irssi_pidwait_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_pidwait_add)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pid");
    {
	int	pid = (int)SvIV(ST(0))
;

	pidwait_add(pid);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_pidwait_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_pidwait_remove)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pid");
    {
	int	pid = (int)SvIV(ST(0))
;

	pidwait_remove(pid);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi_parse_special); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_parse_special)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "cmd, data=\"\", flags=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	cmd = (char *)SvPV_nolen(ST(0))
;
	char *	data;
	int	flags;
#line 603 "Core.xs"
	char *ret;
#line 1479 "Core.c"

	if (items < 2)
	    data = "";
	else {
	    data = (char *)SvPV_nolen(ST(1))
;
	}

	if (items < 3)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(2))
;
	}
#line 605 "Core.xs"
	ret = parse_special_string(cmd, NULL, NULL, data, NULL, flags);
	XPUSHs(sv_2mortal(new_pv(ret)));
	g_free_not_null(ret);
#line 1498 "Core.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Irssi_get_irssi_dir); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_get_irssi_dir)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 612 "Core.xs"
	RETVAL = (char *) get_irssi_dir();
#line 1516 "Core.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_get_irssi_config); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_get_irssi_config)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 619 "Core.xs"
	RETVAL = (char *) get_irssi_config();
#line 1534 "Core.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_get_irssi_binary); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_get_irssi_binary)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	char *	RETVAL;
	dXSTARG;
#line 626 "Core.xs"
	RETVAL = irssi_binary;
#line 1552 "Core.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_version)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 633 "Core.xs"
	char version[100];
#line 1568 "Core.c"
	char *	RETVAL;
	dXSTARG;
#line 635 "Core.xs"
	g_snprintf(version, sizeof(version), "%d.%04d",
		   IRSSI_VERSION_DATE, IRSSI_VERSION_TIME);
	RETVAL = version;
#line 1575 "Core.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_get_gui); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_get_gui)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 644 "Core.xs"
	RETVAL = irssi_gui;
#line 1593 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_IRSSI_GUI_NONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_IRSSI_GUI_NONE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 651 "Core.xs"
	RETVAL = IRSSI_GUI_NONE;
#line 1611 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_IRSSI_GUI_TEXT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_IRSSI_GUI_TEXT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 658 "Core.xs"
	RETVAL = IRSSI_GUI_TEXT;
#line 1629 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_IRSSI_GUI_GTK); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_IRSSI_GUI_GTK)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 665 "Core.xs"
	RETVAL = IRSSI_GUI_GTK;
#line 1647 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_IRSSI_GUI_GNOME); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_IRSSI_GUI_GNOME)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 672 "Core.xs"
	RETVAL = IRSSI_GUI_GNOME;
#line 1665 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_IRSSI_GUI_QT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_IRSSI_GUI_QT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 679 "Core.xs"
	RETVAL = IRSSI_GUI_QT;
#line 1683 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi_IRSSI_GUI_KDE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi_IRSSI_GUI_KDE)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 686 "Core.xs"
	RETVAL = IRSSI_GUI_KDE;
#line 1701 "Core.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Irssi__Server_parse_special); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi__Server_parse_special)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "server, cmd, data=\"\", flags=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Irssi__Server	server = irssi_ref_object(ST(0))
;
	char *	cmd = (char *)SvPV_nolen(ST(1))
;
	char *	data;
	int	flags;
#line 701 "Core.xs"
	char *ret;
#line 1725 "Core.c"

	if (items < 3)
	    data = "";
	else {
	    data = (char *)SvPV_nolen(ST(2))
;
	}

	if (items < 4)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(3))
;
	}
#line 703 "Core.xs"
	ret = parse_special_string(cmd, server, NULL, data, NULL, flags);
	XPUSHs(sv_2mortal(new_pv(ret)));
	g_free_not_null(ret);
#line 1744 "Core.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Irssi__Server_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi__Server_command)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "server, cmd");
    {
	Irssi__Server	server = irssi_ref_object(ST(0))
;
	char *	cmd = (char *)SvPV_nolen(ST(1))
;
#line 712 "Core.xs"
	perl_command(cmd, server, NULL);
#line 1764 "Core.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Irssi__Windowitem_parse_special); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi__Windowitem_parse_special)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "item, cmd, data=\"\", flags=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Irssi__Windowitem	item = irssi_ref_object(ST(0))
;
	char *	cmd = (char *)SvPV_nolen(ST(1))
;
	char *	data;
	int	flags;
#line 726 "Core.xs"
	char *ret;
#line 1787 "Core.c"

	if (items < 3)
	    data = "";
	else {
	    data = (char *)SvPV_nolen(ST(2))
;
	}

	if (items < 4)
	    flags = 0;
	else {
	    flags = (int)SvIV(ST(3))
;
	}
#line 728 "Core.xs"
	ret = parse_special_string(cmd, item->server, item, data, NULL, flags);
	XPUSHs(sv_2mortal(new_pv(ret)));
	g_free_not_null(ret);
#line 1806 "Core.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Irssi__Windowitem_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Irssi__Windowitem_command)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "item, cmd");
    {
	Irssi__Windowitem	item = irssi_ref_object(ST(0))
;
	char *	cmd = (char *)SvPV_nolen(ST(1))
;
#line 737 "Core.xs"
	perl_command(cmd, item->server, item);
#line 1826 "Core.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Irssi__Core); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Irssi__Core)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("Irssi::signal_emit", XS_Irssi_signal_emit, file, "$;@");
        (void)newXSproto_portable("Irssi::signal_continue", XS_Irssi_signal_continue, file, ";@");
        (void)newXSproto_portable("Irssi::signal_add", XS_Irssi_signal_add, file, ";@");
        (void)newXSproto_portable("Irssi::signal_add_first", XS_Irssi_signal_add_first, file, ";@");
        (void)newXSproto_portable("Irssi::signal_add_last", XS_Irssi_signal_add_last, file, ";@");
        (void)newXSproto_portable("Irssi::signal_add_priority", XS_Irssi_signal_add_priority, file, ";@");
        (void)newXSproto_portable("Irssi::signal_register", XS_Irssi_signal_register, file, ";@");
        (void)newXSproto_portable("Irssi::SIGNAL_PRIORITY_LOW", XS_Irssi_SIGNAL_PRIORITY_LOW, file, "");
        (void)newXSproto_portable("Irssi::SIGNAL_PRIORITY_DEFAULT", XS_Irssi_SIGNAL_PRIORITY_DEFAULT, file, "");
        (void)newXSproto_portable("Irssi::SIGNAL_PRIORITY_HIGH", XS_Irssi_SIGNAL_PRIORITY_HIGH, file, "");
        (void)newXSproto_portable("Irssi::signal_remove", XS_Irssi_signal_remove, file, "$$");
        (void)newXSproto_portable("Irssi::signal_stop", XS_Irssi_signal_stop, file, "");
        (void)newXSproto_portable("Irssi::signal_stop_by_name", XS_Irssi_signal_stop_by_name, file, "$");
        (void)newXSproto_portable("Irssi::signal_get_emitted", XS_Irssi_signal_get_emitted, file, "");
        (void)newXSproto_portable("Irssi::signal_get_emitted_id", XS_Irssi_signal_get_emitted_id, file, "");
        (void)newXSproto_portable("Irssi::timeout_add", XS_Irssi_timeout_add, file, "$$$");
        (void)newXSproto_portable("Irssi::timeout_add_once", XS_Irssi_timeout_add_once, file, "$$$");
        (void)newXSproto_portable("Irssi::timeout_remove", XS_Irssi_timeout_remove, file, "$");
        (void)newXSproto_portable("Irssi::INPUT_READ", XS_Irssi_INPUT_READ, file, "");
        (void)newXSproto_portable("Irssi::INPUT_WRITE", XS_Irssi_INPUT_WRITE, file, "");
        (void)newXSproto_portable("Irssi::input_add", XS_Irssi_input_add, file, "$$$$");
        (void)newXSproto_portable("Irssi::input_remove", XS_Irssi_input_remove, file, "$");
        (void)newXSproto_portable("Irssi::MSGLEVEL_CRAP", XS_Irssi_MSGLEVEL_CRAP, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_MSGS", XS_Irssi_MSGLEVEL_MSGS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_PUBLIC", XS_Irssi_MSGLEVEL_PUBLIC, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_NOTICES", XS_Irssi_MSGLEVEL_NOTICES, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_SNOTES", XS_Irssi_MSGLEVEL_SNOTES, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_CTCPS", XS_Irssi_MSGLEVEL_CTCPS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_ACTIONS", XS_Irssi_MSGLEVEL_ACTIONS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_JOINS", XS_Irssi_MSGLEVEL_JOINS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_PARTS", XS_Irssi_MSGLEVEL_PARTS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_QUITS", XS_Irssi_MSGLEVEL_QUITS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_KICKS", XS_Irssi_MSGLEVEL_KICKS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_MODES", XS_Irssi_MSGLEVEL_MODES, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_TOPICS", XS_Irssi_MSGLEVEL_TOPICS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_WALLOPS", XS_Irssi_MSGLEVEL_WALLOPS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_INVITES", XS_Irssi_MSGLEVEL_INVITES, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_NICKS", XS_Irssi_MSGLEVEL_NICKS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_DCC", XS_Irssi_MSGLEVEL_DCC, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_DCCMSGS", XS_Irssi_MSGLEVEL_DCCMSGS, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_CLIENTNOTICE", XS_Irssi_MSGLEVEL_CLIENTNOTICE, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_CLIENTCRAP", XS_Irssi_MSGLEVEL_CLIENTCRAP, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_CLIENTERROR", XS_Irssi_MSGLEVEL_CLIENTERROR, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_HILIGHT", XS_Irssi_MSGLEVEL_HILIGHT, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_ALL", XS_Irssi_MSGLEVEL_ALL, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_NOHILIGHT", XS_Irssi_MSGLEVEL_NOHILIGHT, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_NO_ACT", XS_Irssi_MSGLEVEL_NO_ACT, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_NEVER", XS_Irssi_MSGLEVEL_NEVER, file, "");
        (void)newXSproto_portable("Irssi::MSGLEVEL_LASTLOG", XS_Irssi_MSGLEVEL_LASTLOG, file, "");
        (void)newXSproto_portable("Irssi::level2bits", XS_Irssi_level2bits, file, "$");
        (void)newXSproto_portable("Irssi::bits2level", XS_Irssi_bits2level, file, "$");
        (void)newXSproto_portable("Irssi::combine_level", XS_Irssi_combine_level, file, "$$");
        (void)newXSproto_portable("Irssi::command", XS_Irssi_command, file, "$");
        (void)newXSproto_portable("Irssi::commands", XS_Irssi_commands, file, "");
        (void)newXSproto_portable("Irssi::command_bind_first", XS_Irssi_command_bind_first, file, ";@");
        (void)newXSproto_portable("Irssi::command_bind", XS_Irssi_command_bind, file, ";@");
        (void)newXSproto_portable("Irssi::command_bind_last", XS_Irssi_command_bind_last, file, ";@");
        (void)newXSproto_portable("Irssi::command_runsub", XS_Irssi_command_runsub, file, "$$$$");
        (void)newXSproto_portable("Irssi::command_unbind", XS_Irssi_command_unbind, file, "$$");
        (void)newXSproto_portable("Irssi::command_set_options", XS_Irssi_command_set_options, file, "$$");
        (void)newXSproto_portable("Irssi::command_parse_options", XS_Irssi_command_parse_options, file, "$$");
        (void)newXSproto_portable("Irssi::pidwait_add", XS_Irssi_pidwait_add, file, "$");
        (void)newXSproto_portable("Irssi::pidwait_remove", XS_Irssi_pidwait_remove, file, "$");
        (void)newXSproto_portable("Irssi::parse_special", XS_Irssi_parse_special, file, "$;$$");
        (void)newXSproto_portable("Irssi::get_irssi_dir", XS_Irssi_get_irssi_dir, file, "");
        (void)newXSproto_portable("Irssi::get_irssi_config", XS_Irssi_get_irssi_config, file, "");
        (void)newXSproto_portable("Irssi::get_irssi_binary", XS_Irssi_get_irssi_binary, file, "");
        (void)newXSproto_portable("Irssi::version", XS_Irssi_version, file, "");
        (void)newXSproto_portable("Irssi::get_gui", XS_Irssi_get_gui, file, "");
        (void)newXSproto_portable("Irssi::IRSSI_GUI_NONE", XS_Irssi_IRSSI_GUI_NONE, file, "");
        (void)newXSproto_portable("Irssi::IRSSI_GUI_TEXT", XS_Irssi_IRSSI_GUI_TEXT, file, "");
        (void)newXSproto_portable("Irssi::IRSSI_GUI_GTK", XS_Irssi_IRSSI_GUI_GTK, file, "");
        (void)newXSproto_portable("Irssi::IRSSI_GUI_GNOME", XS_Irssi_IRSSI_GUI_GNOME, file, "");
        (void)newXSproto_portable("Irssi::IRSSI_GUI_QT", XS_Irssi_IRSSI_GUI_QT, file, "");
        (void)newXSproto_portable("Irssi::IRSSI_GUI_KDE", XS_Irssi_IRSSI_GUI_KDE, file, "");
        (void)newXSproto_portable("Irssi::Server::parse_special", XS_Irssi__Server_parse_special, file, "$$;$$");
        (void)newXSproto_portable("Irssi::Server::command", XS_Irssi__Server_command, file, "$$");
        (void)newXSproto_portable("Irssi::Windowitem::parse_special", XS_Irssi__Windowitem_parse_special, file, "$$;$$");
        (void)newXSproto_portable("Irssi::Windowitem::command", XS_Irssi__Windowitem_command, file, "$$");
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

