/* $Id: init.c,v 1.10 2005/09/06 15:12:02 cegger Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "xwmh.h"

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32_t *dlret)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);
	ggi_x_priv *xpriv = GGIX_PRIV(vis);

	/* Cannot use WMH on an X window which is in the root window. */
	if (xpriv->parentwin == 
	    RootWindow(xpriv->disp, xpriv->vilist[xpriv->viidx].vi->screen))
	{
		return GGI_ENOFUNC;
	}

	priv->move     = GGIwmh_x_move;
	priv->resize   = GGIwmh_x_resize;
	priv->getpos   = GGIwmh_x_getpos;
	priv->getsize  = GGIwmh_x_getsize;
	priv->settitle = GGIwmh_x_settitle;
	priv->maximize = GGIwmh_x_maximize;
	priv->zorder   = GGIwmh_x_zorder;
	priv->iconify  = GGIwmh_x_iconify;
	priv->moveicon = GGIwmh_x_moveicon;
	priv->seticontitle = GGIwmh_x_seticontitle;
	priv->allowresize  = GGIwmh_x_allowresize;
	
	*dlret = GGI_DL_EXTENSION | GGI_DL_OPDISPLAY;
	return 0;
}

EXPORTFUNC
int WMHdl_X_wmh(int func, void **funcptr);

int WMHdl_X_wmh(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
	case GGIFUNC_close:
		*funcptr = NULL;
		return 0;
	default:
		*funcptr = NULL;
	}

	return GGI_ENOTFOUND;
}

#include <ggi/internal/ggidlinit.h>
