#ifndef CONFIG_H
#define CONFIG_H


// Enums for various options.

typedef enum { MDK_SHIFT = 1, MDK_ALT = 2, MDK_CTRL = 4 } mod_keys;
enum { HOLD_NEVER, HOLD_START, HOLD_ERROR, HOLD_ALWAYS };
enum { CUR_BLOCK, CUR_UNDERSCORE, CUR_LINE };
enum { FS_DEFAULT, FS_PARTIAL, FS_NONE, FS_FULL };
enum { MC_VOID, MC_PASTE, MC_EXTEND, MC_ENTER };
enum { RC_MENU, RC_PASTE, RC_EXTEND, RC_ENTER };
enum { TR_OFF = 0, TR_LOW = 16, TR_MEDIUM = 32, TR_HIGH = 48, TR_GLASS = -1 };


// Colour values.

typedef uint colour;

enum { DEFAULT_COLOUR = UINT_MAX };

static inline colour
make_colour(uchar r, uchar g, uchar b) { return r | g << 8 | b << 16; }

extern bool parse_colour(string, colour *);

static inline uchar red(colour c) { return c; }
static inline uchar green(colour c) { return c >> 8; }
static inline uchar blue(colour c) { return c >> 16; }


// Font properties.

typedef struct {
  string name;
  int size;
  bool isbold;
} font_spec;


// Configuration data.

typedef struct {
  // Looks
  colour fg_colour, bold_colour, bg_colour, cursor_colour;
  colour search_fg_colour, search_bg_colour, search_current_colour;
  char transparency;
  bool opaque_when_focused;
  char cursor_type;
  bool cursor_blinks;
  // Text
  font_spec font;
  char font_smoothing;
  char bold_as_font;    // 0 = false, 1 = true, -1 = undefined
  bool bold_as_colour;
  bool allow_blinking;
  string locale;
  string charset;
  // Keys
  bool backspace_sends_bs;
  bool delete_sends_del;
  bool ctrl_alt_is_altgr;
  bool clip_shortcuts;
  bool window_shortcuts;
  bool switch_shortcuts;
  bool zoom_shortcuts;
  bool zoom_font_with_window;
  bool alt_fn_shortcuts;
  bool ctrl_shift_shortcuts;
  string break_string;
  string pause_string;
  // Mouse
  bool copy_on_select;
  bool copy_as_rtf;
  bool clicks_place_cursor;
  char middle_click_action;
  char right_click_action;
  bool zoom_mouse;
  bool clicks_target_app;
  char click_target_mod;
  bool hide_mouse;
  // Window
  int cols, rows;
  int scrollback_lines;
  char scrollbar;
  char scroll_mod;
  bool pgupdn_scroll;
  string search_bar;
  // Terminal
  string term;
  string answerback;
  bool bell_sound;
  int bell_type;
  int bell_freq;
  int bell_len;
  bool bell_flash;
  bool bell_taskbar;
  string printer;
  bool confirm_exit;
  // Command line
  string class;
  char hold;
  bool exit_write;
  string exit_title;
  string icon;
  string log;
  string title;
  bool utmp;
  char window;
  int x, y;
  bool daemonize;
  // "Hidden"
  string app_id;
  string app_name;
  string app_launch_cmd;
  int col_spacing, row_spacing;
  string word_chars;
  string word_chars_excl;
  colour ime_cursor_colour;
  colour ansi_colours[16];
  // Legacy
  bool use_system_colours;
} config;

extern config cfg, new_cfg;

extern void init_config(void);
extern void load_config(string filename, bool to_save);
extern void set_arg_option(string name, string val);
extern void parse_arg_option(string);
extern void remember_arg(string);
extern void finish_config(void);
extern void copy_config(config *dst, const config *src);

#endif
