.TH AP %manext8% "March 6, 2012" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
ap \- parse addresses 822-style
.SH SYNOPSIS
.HP 5
.na
.B %libdir%/ap
.RB [ \-form
.IR formatfile ]
.RB [ \-format
.IR string ]
.RB [ \-normalize " | " \-nonormalize ]
.RB [ \-width
.IR columns ]
.RB [ \-version ]
.RB [ \-help ] 
.I addrs
\&...
.ad
.SH DESCRIPTION
.B Ap
is a program that parses addresses according to the ARPA
Internet standard.  It also understands many non\-standard formats.
It is useful for seeing how
.B nmh
will interpret an address.
.PP
The
.B ap
program treats each argument as one or more addresses, and
prints those addresses out in the official 822\-format.  Hence, it is
usually best to enclose each argument in quotes for the shell.
.PP
To override the output format used by
.BR ap ,
the
.B \-format
.I string
or
.B \-format
.I file
switches are used.  This permits individual fields of
the address to be extracted with ease.  The string is simply a format
string, and the file is simply a format file.  See
.IR mh\-format (5)
for the details.
.PP
In addition to the standard escapes,
.B ap
also recognizes the following additional escape:
.PP
.RS 5
.nf
.ta \w'Escape  'u +\w'Returns  'u
.I "Escape	Returns	Description"
error	string	A diagnostic if the parse failed
.RE
.fi
.PP
If the
.B \-normalize
switch is given,
.B ap
will try to track down
the official hostname of the address.
.PP
Here is the default format string used by
.BR ap :
.PP
.RS 5
%<{error}%{error}: %{text}%|%(putstr(proper{text}))%>
.RE
.PP
which says that if an error was detected, print the error, a `:', and
the address in error.  Otherwise, output the 822\-proper format of
the address.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^%etcdir%/mts.conf~^nmh mts configuration file
.fi
.SH "PROFILE COMPONENTS"
None
.SH "SEE ALSO"
.IR dp (8)
.PP
.I
Standard for the Format of ARPA Internet Text Messages
(RFC\-822)
.SH DEFAULTS
.nf
.RB ` \-format "' defaults as described above"
.RB ` \-normalize '
.RB ` \-width "' defaults to the width of the terminal"
.fi
.SH CONTEXT
None
.SH BUGS
The argument to the
.B \-format
switch must be interpreted as a single token
by the shell that invokes
.BR ap .
Therefore,
one must usually place the argument to this switch inside quotes.
