.TH MSH %manext1% "January 8, 2012" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
msh \- nmh shell (and BBoard reader)
.SH SYNOPSIS
.HP 5
.na
.B msh
.RB [ \-prompt
.IR string ]
.RB [ \-scan " | " \-noscan ]
.RB [ \-topcur " | " \-notopcur ]
.RI [ file ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B msh
is an interactive program that implements a subset of the normal
.B nmh
commands operating on a single file in
.BR packf 'd format.
That is,
.B msh
is used to read a file that contains a number
of messages, as opposed to the standard
.B nmh
style of reading
a number of files, each file being a separate message in a folder.
.BR msh 's
chief advantage is that the normal
.B nmh
style does not
allow a file to have more than one message in it.  Hence,
.B msh
is
ideal for reading BBoards, as these files are delivered by the
transport system in this format.  In addition,
.B msh
can be used on
other files, such as message archives which have been
.BR pack ed
(see
.IR packf (1)).
Finally,
.B msh
is an excellent
.B nmh
tutor.
As the only commands available to the user are
.B nmh
commands, this
allows
.B nmh
beginners to concentrate on how commands to
.B nmh
are formed and (more or less) what they mean.
.PP
When invoked,
.B msh
reads the named file, and enters a command loop.
The user may type most of the normal
.B nmh
commands.  The syntax and
semantics of these commands typed to
.B msh
are identical to their
.B nmh
counterparts.  In cases where the nature of
.B msh
would be
inconsistent (e.g., specifying a
.I +folder
with some commands),
.B msh
will duly inform the user.  The commands that
.B msh
currently supports
(in some slightly modified or restricted forms) are:
.PP
.RS 5
.nf
ali
burst
comp
dist
folder
forw
inc
mark
mhmail
mhn
msgchk
next
packf
pick
prev
refile
repl
rmm
scan
send
show
sortm
whatnow
whom
.fi
.RE
.PP
In addition,
.B msh
has a
.B help
command which gives a
brief overview.  To terminate
.BR msh ,
type CTRL\-D, or use the
.B quit
command.
.PP
If the file is writable and has been modified, then using
.B quit
will query the user if the file should be updated.
.PP
The
.B \-prompt
.I string
switch sets the prompting string for
.BR msh .
.PP
You may wish to use an alternate
.B nmh
profile for the commands that
.B msh
executes; see
.IR mh-profile (5)
for details about the
.B $MH
environment variable.
.PP
The
.B exit
command is identical to the
.B quit
command in
.BR msh .
.PP
.B msh
supports an output redirection facility.  Commands may be
followed by one of
.PP
.RS 5
.nf
.ta \w'| \fIcommand\fR  'u
^> \fIfile\fR~^write output to \fIfile\fR
^>> \fIfile\fR~^append output to \fIfile\fR
^| \fIcommand\fR~^pipe output to UNIX \fIcommand\fR
.fi
.RE
.PP
If
.I file
starts with a \*(lq\~\*(rq (tilde), then a
.BR csh \-like
expansion
takes place.  Note that
.I command
is interpreted by
.BR sh .
Also note that
.B msh
does NOT support history substitutions, variable
substitutions, or alias substitutions.
.PP
When parsing commands to the left of any redirection symbol,
.B msh
will honor `\\' (back\-slash) as the quote next\-character symbol, and
`\*(lq' (double\-quote) as quote\-word delimiters.  All other input tokens
are separated by whitespace (spaces and tabs).
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^%etcdir%/mts.conf~^nmh mts configuration file
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Msg\-Protect:~^To set mode when creating a new `file'
^fileproc:~^Program to file messages
^showproc:~^Program to show messages
.fi
.SH "SEE ALSO"
.IR packf (1)
.SH DEFAULTS
.nf
.RB ` file "' defaults to \*(lq./msgbox\*(rq"
.RB ` "\-prompt\ (msh)\ "'
.RB ` \-noscan '
.RB ` \-notopcur '
.fi
.SH CONTEXT
None
.SH BUGS
The argument to the
.B \-prompt
switch must be interpreted as a single
token by the shell that invokes
.BR msh .
Therefore, one must usually
place the argument to this switch inside double\-quotes.
.PP
There is a strict limit of messages per file in
.BR packf 'd
format which
.B msh
can handle.  Usually, this limit is 1000 messages.
.PP
Please remember that
.B msh
is not the C\-Shell, and that a lot of
the nice facilities provided by the latter are not present in the former.
.PP
In particular,
.B msh
does not understand back\-quoting, so the only
effective way to use
.B pick
inside
.B msh
is to always use the
.B \-seq
.I select
switch.  Clever users of
.B nmh
will put the line
.P
.RS 5
pick:\0\-seq\0select\0\-list
.RE
.PP
in their
.I \&.mh\(ruprofile
file so that
.B pick
works equally well from both the shell and
.BR msh .
.PP
.B sortm
always uses
.B \-noverbose
and if
.B \-textfield
.I field
is used,
.B \-limit
.IR 0 .
.PP
The
.B msh
program inherits most (if not all) of the bugs from the
.B nmh
commands it implements.
