.TH REFILE %manext1% "January 18, 2001" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
refile \- file message in other folders
.SH SYNOPSIS
.HP 5
.na
.B refile 
.RI [ msgs ]
.RB [ \-draft ]
.RB [ \-link " | " \-nolink ]
.RB [ \-preserve " | " \-nopreserve ]
.RB [ \-unlink " | " \-nounlink ]
.RB [ \-src
.IR +folder ]
.RB [ \-file
.IR file ]
.RB [ \-rmmproc
.IR program ]
.RB [ \-normmproc ]
.I +folder1
\&...
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Refile
moves (see
.IR mv (1))
or links (see
.IR ln (1))
messages
from a source folder into one or more destination folders.
.PP
If you think of a message as a sheet of paper, this operation is not
unlike filing the sheet of paper (or copies) in file cabinet folders.
When a message is filed, it is linked into the destination folder(s)
if possible, and is copied otherwise.  As long as the destination
folders are all on the same file system, multiple filing causes little
storage overhead.  This facility provides a good way to cross\-file or
multiply\-index messages.  For example, if a message is received from
Jones about the ARPA Map Project, the command
.PP
.RS 5
refile\0cur\0+jones\0+Map
.RE
.PP
would allow the message to be found in either of the two folders `jones'
or `Map'.
.PP
You may specify the source folder using
.B \-src
.IR +folder .
If this is
not given, the current folder is used by default.  If no message is
specified, then `cur' is used by default.
.PP
The option
.B \-file
.I file
directs
.B refile
to use the specified file
as the source message to be filed, rather than a message from a folder.
Note that the file should be a validly formatted message, just like
any other
.B nmh
message.  It should
.B NOT
be in mail drop format
(to convert a file in mail drop format to a folder of
.B nmh
messages,
see
.IR inc (1)).
.PP
If a destination folder doesn't exist,
.B refile
will ask if you want
to create it.  A negative response will abort the file operation.  If the
standard input for
.B refile
is
.B not
a tty, then
.B refile
will not ask any questions and will proceed as if the user answered
\*(lqyes\*(rq to all questions.
.PP
The option
.B \-link
preserves the source folder copy of the message (i.e.,
it does a
.IR ln (1)
rather than a
.IR mv (1)),
whereas,
.B \-nolink
(the default) deletes the filed messages from the source folder.
.PP
Normally when a message is refiled, for each destination folder it
is assigned the number which is one above the current highest message
number in that folder.  Use of the
.B \-preserv
switch will override
this message renaming, and try to preserve the number of the message.
If a conflict for a particular folder occurs when using the
.B \-preserve
switch, then
.B refile
will use the next available message number
which is above the message number you wish to preserve.
.PP
If
.B \-link
is not specified (or
.B \-nolink
is specified), the filed
messages will be removed from the source folder.  The default is to
remove these messages by renaming them with a site-dependent prefix
(usually a comma).  Such files will then need to be removed in some
manner after a certain amount of time.  Many sites arrange for
.B cron
to remove these files once a day, so check with your
system administrator.
.PP
Alternately, if you wish for
.B refile
to really remove the files
representing these messages from the source folder, you can use the
.B -unlink
switch (not to be confused with the
.B \-link
switch).  But
messages removed by this method cannot be later recovered.
.PP
If you prefer a more sophisticated method of `removing' the messages
from the source folder, you can define the
.B rmmproc
profile
component.  For example, you can add a profile component such as
.PP
.RS 5
rmmproc:	/home/coleman/bin/rmm_msgs
.RE
.PP
then
.B refile
will instead call the named program or script to
handle the message files.
.PP
The user may specify
.B \-rmmproc
.I program
on the command line to
override this profile specification.  The
.B \-normmproc
option forces
the message files to be deleted by renaming or unlinking them as
described above.
.PP
The
.B \-draft
switch tells
.B refile
to file the <mh\-dir>/draft.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^Folder\-Protect:~^To set mode when creating a new folder
^rmmproc:~^Program to delete the message
.fi
.SH "SEE ALSO"
.IR folder (1),
.IR rmf (1),
.IR rmm (1)
.SH DEFAULTS
.nf
.RB ` "\-src\ +folder" "' defaults to the current folder"
.RB ` msgs "' defaults to cur"
.RB ` \-nolink '
.RB ` \-nounlink '
.RB ` \-nopreserve '
.fi
.SH CONTEXT
If
.B \-src
.I +folder
is given, it will become the current folder.
If neither
.B \-link
nor `all' is specified, the current message in the
source folder will be set to the last message specified; otherwise, the
current message won't be changed.
.PP
If the \*(lqPrevious\-Sequence\*(rq profile entry is set, in addition to defining
the named sequences from the source folder,
.B refile
will also define
those sequences for the destination folders.  See
.B mh\-sequence (5)
for information concerning the previous sequence.
.SH BUGS
Since
.B refile
uses your
.I rmmproc
to delete the message,
the
.I rmmproc
must
.B NOT
call
.B refile
without specifying
.BR \-normmproc ,
or you will create an infinite loop.
