#!/bin/sh
#
# Common routines for the post tests
#

set -e

. "${MH_OBJ_DIR}/test/common.sh"

setup_test

localport=65412
testname="${MH_TEST_DIR}/$$"

#
# Set this for the EHLO command
#

echo "clientname: nosuchhost.example.com" >> ${MHMTSCONF}

#
# One "post" test run.  Ok, yeah, we're using "send", but that's just
# because it's easier.
# $1: output filename for fakesmtp, i.e., the sent message
# $2: expected output
# $3: optional switches for send

test_post ()
{ "${MH_OBJ_DIR}/test/fakesmtp" "$1" $localport &
    pid="$!"

    # The server doesn't always come up fast enough, so sleep and
    # retry a few times if it fails...
    status=1
    for i in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20; do
        if send -draft -server 127.0.0.1 -port $localport $3
        then
            status=0
            break
        fi
        sleep 2
    done
    if [ $status -ne 0 ]; then
      printf '%s: send failed, was fakesmtp given enough time to start?\n' \
             "$0" >&2
      exit 1
    fi

    wait ${pid}

    #
    # It's hard to calculate the exact Date: header post is going to
    # use, so we'll just use sed to remove the actual date so we can easily
    # compare it against our "correct" output.
    #

    sed -e 's/^Date:.*/Date:/' "$1" > "$1".nodate
    rm -f "$1"

    check "$1".nodate "$2"
}
