function resu = df_allmeta(df, dim = [])

  %# function resu = df_allmeta(df, dim = [])
  %# Returns a new dataframe, initalised with the all the
  %# meta-information but with empty data

  %% Copyright (C) 2009-2015 Pascal Dupuis <cdemills@gmail.com>
  %%
  %% This file is part of Octave.
  %%
  %% Octave is free software; you can redistribute it and/or
  %% modify it under the terms of the GNU General Public
  %% License as published by the Free Software Foundation;
  %% either version 2, or (at your option) any later version.
  %%
  %% Octave is distributed in the hope that it will be useful,
  %% but WITHOUT ANY WARRANTY; without even the implied
  %% warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
  %% PURPOSE.  See the GNU General Public License for more
  %% details.
  %%
  %% You should have received a copy of the GNU General Public
  %% License along with Octave; see the file COPYING.  If not,
  %% write to the Free Software Foundation, 51 Franklin Street -
  %% Fifth Floor, Boston, MA 02110-1301, USA.
  
  %#
  %# $Id$
  %#

  resu = dataframe ();

  if (isempty (dim))
    dim = df._cnt(1:2); 
  else
    dim = dim(1:2); %# ignore third dim, if any
  endif

  %# this is unnecessary: if passed a dim, just use it.
  %# resu._cnt(1:2) = min (dim, df._cnt(1:2));
  resu._cnt(1:2) = dim;
  
  if (~isempty (df._name{1}))
    if (df._cnt(1) >= resu._cnt(1))
      resu._name{1} = df._name{1}(1:resu._cnt(1));
      resu._over{1} = df._over{1}(1:resu._cnt(1));
    else
      dummy = floor (resu._cnt(1) / df._cnt(1));
      resu._name{1} = repmat (df._name{1}(1:df._cnt(1)), 1, dummy);
      resu._over{1} = repmat (df._over{1}(1:df._cnt(1)), 1, dummy);
      if (length (resu._name{1}) != dim(1))
        if (~isempty (other))
          if (isa (other, 'dataframe'))
            if (length (other._name{1}) >= dim(1))
              resu._name{1} = other._name{1}(1:resu._cnt(1));
              resu._over{1} = other._over{1}(1:resu._cnt(1));
            end
          end
        end
      end
    end
  end

  if (~isempty (df._name{2}))
    if (df._cnt(2) >= resu._cnt(2))
      resu._name{2} = df._name{2}(1:resu._cnt(2));
      resu._over{2} = df._over{2}(1:resu._cnt(2));
    else
      dummy = floor (resu._cnt(2) / df._cnt(2));
      resu._name{2} = repmat (df._name{2}(1:df._cnt(2)), 1, dummy);
      resu._over{2} = repmat (df._over{2}(1:df._cnt(2)), 1, dummy);
      if (length (resu._name{2}) != dim(2))
        dummy = repmat ('X', resu._cnt(2), 1);
        dummy = cstrcat (dummy, strjust (num2str ((1:resu._cnt(2))(:)), 'left'));
        resu._name{2} = cellstr (dummy);
        resu._over{2} = true (ones (resu._cnt(2), 1));
      end
    end
  end

  if (~isempty (df._ridx))
    if (size (df._ridx, 2) >= resu._cnt(2)),
      resu._ridx = df._ridx(1:resu._cnt(1), :, :);
    else
      resu._ridx = df._ridx(1:resu._cnt(1), 1, :);
    end
  end
  
  %# init it with the right orientation
  resu._data = cell (size (df._data, 1), min (dim(2), size (df._data, 2)));
  resu._rep = cell (size (resu._data));
  
  %# type 'char' must get through
  resu._type = cellstr (repmat ('unknown', resu._cnt(2), 1)).';
  if (df._cnt(2) >= resu._cnt(2))
    for indi = (1:resu._cnt(2))
      switch df._type{indi}
        case 'char'
          resu._type{indi} = 'char';
      end
    end
  else
    for indi = (1:df._cnt(2))
      switch df._type{indi}
        case 'char'
          resu._type = cellstr (repmat ('char', resu._cnt(2), 1)).';
      end 
    end  
  end
    
  resu._src  = df._src;
  resu._cmt  = df._cmt;
  
endfunction
