/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternals.h"

#include "ClientRect.h"
#include "ClientRectList.h"
#include "DOMStringList.h"
#include "DOMWindow.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "InternalSettings.h"
#include "Internals.h"
#include "JSArrayBuffer.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDOMStringList.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSInternalSettings.h"
#include "JSMallocStatistics.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "JSRange.h"
#include "JSWebKitPoint.h"
#include "KURL.h"
#include "MallocStatistics.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"
#include "Range.h"
#include "SerializedScriptValue.h"
#include "WebKitPoint.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/ArrayBuffer.h>
#include <wtf/GetPtr.h>

#if ENABLE(INSPECTOR)
#include "JSDOMWindow.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSInternalsTableValues[] =
{
    { "settings", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsSettings), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalsTable = { 2, 1, JSInternalsTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSInternalsPrototypeTableValues[] =
{
    { "LAYER_TREE_INCLUDES_VISIBLE_RECTS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_VISIBLE_RECTS), (intptr_t)0, NoIntrinsic },
    { "LAYER_TREE_INCLUDES_TILE_CACHES", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_TILE_CACHES), (intptr_t)0, NoIntrinsic },
    { "LAYER_TREE_INCLUDES_REPAINT_RECTS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_REPAINT_RECTS), (intptr_t)0, NoIntrinsic },
    { "address", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAddress), (intptr_t)1, NoIntrinsic },
    { "elementRenderTreeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionElementRenderTreeAsText), (intptr_t)1, NoIntrinsic },
    { "isPreloaded", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsPreloaded), (intptr_t)2, NoIntrinsic },
    { "numberOfScopedHTMLStyleChildren", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfScopedHTMLStyleChildren), (intptr_t)1, NoIntrinsic },
    { "ensureShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEnsureShadowRoot), (intptr_t)1, NoIntrinsic },
    { "shadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowRoot), (intptr_t)1, NoIntrinsic },
    { "youngestShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionYoungestShadowRoot), (intptr_t)1, NoIntrinsic },
    { "oldestShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionOldestShadowRoot), (intptr_t)1, NoIntrinsic },
    { "youngerShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionYoungerShadowRoot), (intptr_t)1, NoIntrinsic },
    { "shadowRootType", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowRootType), (intptr_t)1, NoIntrinsic },
    { "hasShadowInsertionPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasShadowInsertionPoint), (intptr_t)1, NoIntrinsic },
    { "hasContentElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasContentElement), (intptr_t)1, NoIntrinsic },
    { "countElementShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCountElementShadow), (intptr_t)1, NoIntrinsic },
    { "includerFor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIncluderFor), (intptr_t)1, NoIntrinsic },
    { "shadowPseudoId", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowPseudoId), (intptr_t)1, NoIntrinsic },
    { "setShadowPseudoId", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetShadowPseudoId), (intptr_t)2, NoIntrinsic },
    { "createContentElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCreateContentElement), (intptr_t)1, NoIntrinsic },
    { "getElementByIdInShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetElementByIdInShadowRoot), (intptr_t)2, NoIntrinsic },
    { "isValidContentSelect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsValidContentSelect), (intptr_t)1, NoIntrinsic },
    { "treeScopeRootNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTreeScopeRootNode), (intptr_t)1, NoIntrinsic },
    { "parentTreeScope", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionParentTreeScope), (intptr_t)1, NoIntrinsic },
    { "hasSelectorForIdInShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasSelectorForIdInShadow), (intptr_t)2, NoIntrinsic },
    { "hasSelectorForClassInShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasSelectorForClassInShadow), (intptr_t)2, NoIntrinsic },
    { "hasSelectorForAttributeInShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasSelectorForAttributeInShadow), (intptr_t)2, NoIntrinsic },
    { "hasSelectorForPseudoClassInShadow", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasSelectorForPseudoClassInShadow), (intptr_t)2, NoIntrinsic },
    { "nextSiblingByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNextSiblingByWalker), (intptr_t)1, NoIntrinsic },
    { "firstChildByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionFirstChildByWalker), (intptr_t)1, NoIntrinsic },
    { "lastChildByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLastChildByWalker), (intptr_t)1, NoIntrinsic },
    { "nextNodeByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNextNodeByWalker), (intptr_t)1, NoIntrinsic },
    { "previousNodeByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPreviousNodeByWalker), (intptr_t)1, NoIntrinsic },
    { "attached", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAttached), (intptr_t)1, NoIntrinsic },
    { "visiblePlaceholder", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionVisiblePlaceholder), (intptr_t)1, NoIntrinsic },
    { "selectColorInColorChooser", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSelectColorInColorChooser), (intptr_t)2, NoIntrinsic },
    { "formControlStateOfPreviousHistoryItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem), (intptr_t)0, NoIntrinsic },
    { "setFormControlStateOfPreviousHistoryItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem), (intptr_t)1, NoIntrinsic },
    { "setEnableMockPagePopup", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetEnableMockPagePopup), (intptr_t)1, NoIntrinsic },
    { "absoluteCaretBounds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAbsoluteCaretBounds), (intptr_t)1, NoIntrinsic },
    { "boundingBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionBoundingBox), (intptr_t)1, NoIntrinsic },
    { "inspectorHighlightRects", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionInspectorHighlightRects), (intptr_t)1, NoIntrinsic },
    { "setBackgroundBlurOnNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetBackgroundBlurOnNode), (intptr_t)2, NoIntrinsic },
    { "markerCountForNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerCountForNode), (intptr_t)2, NoIntrinsic },
    { "markerRangeForNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerRangeForNode), (intptr_t)3, NoIntrinsic },
    { "markerDescriptionForNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerDescriptionForNode), (intptr_t)3, NoIntrinsic },
    { "addTextMatchMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAddTextMatchMarker), (intptr_t)2, NoIntrinsic },
    { "setScrollViewPosition", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetScrollViewPosition), (intptr_t)3, NoIntrinsic },
    { "setPagination", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPagination), (intptr_t)4, NoIntrinsic },
    { "configurationForViewport", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionConfigurationForViewport), (intptr_t)6, NoIntrinsic },
    { "wasLastChangeUserEdit", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWasLastChangeUserEdit), (intptr_t)1, NoIntrinsic },
    { "suggestedValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSuggestedValue), (intptr_t)1, NoIntrinsic },
    { "setSuggestedValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetSuggestedValue), (intptr_t)2, NoIntrinsic },
    { "setEditingValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetEditingValue), (intptr_t)2, NoIntrinsic },
    { "paintControlTints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPaintControlTints), (intptr_t)1, NoIntrinsic },
    { "scrollElementToRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionScrollElementToRect), (intptr_t)5, NoIntrinsic },
    { "rangeFromLocationAndLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRangeFromLocationAndLength), (intptr_t)3, NoIntrinsic },
    { "locationFromRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLocationFromRange), (intptr_t)2, NoIntrinsic },
    { "lengthFromRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLengthFromRange), (intptr_t)2, NoIntrinsic },
    { "rangeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRangeAsText), (intptr_t)1, NoIntrinsic },
    { "setDelegatesScrolling", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetDelegatesScrolling), (intptr_t)2, NoIntrinsic },
    { "touchPositionAdjustedToBestClickableNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchPositionAdjustedToBestClickableNode), (intptr_t)5, NoIntrinsic },
    { "touchNodeAdjustedToBestClickableNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchNodeAdjustedToBestClickableNode), (intptr_t)5, NoIntrinsic },
    { "touchPositionAdjustedToBestContextMenuNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchPositionAdjustedToBestContextMenuNode), (intptr_t)5, NoIntrinsic },
    { "touchNodeAdjustedToBestContextMenuNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchNodeAdjustedToBestContextMenuNode), (intptr_t)5, NoIntrinsic },
    { "bestZoomableAreaForTouchPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionBestZoomableAreaForTouchPoint), (intptr_t)5, NoIntrinsic },
    { "lastSpellCheckRequestSequence", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLastSpellCheckRequestSequence), (intptr_t)1, NoIntrinsic },
    { "lastSpellCheckProcessedSequence", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence), (intptr_t)1, NoIntrinsic },
    { "userPreferredLanguages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionUserPreferredLanguages), (intptr_t)0, NoIntrinsic },
    { "setUserPreferredLanguages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetUserPreferredLanguages), (intptr_t)1, NoIntrinsic },
    { "wheelEventHandlerCount", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWheelEventHandlerCount), (intptr_t)1, NoIntrinsic },
    { "touchEventHandlerCount", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchEventHandlerCount), (intptr_t)1, NoIntrinsic },
    { "nodesFromRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNodesFromRect), (intptr_t)9, NoIntrinsic },
    { "emitInspectorDidBeginFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEmitInspectorDidBeginFrame), (intptr_t)0, NoIntrinsic },
    { "emitInspectorDidCancelFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEmitInspectorDidCancelFrame), (intptr_t)0, NoIntrinsic },
    { "hasSpellingMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasSpellingMarker), (intptr_t)3, NoIntrinsic },
    { "hasGrammarMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasGrammarMarker), (intptr_t)3, NoIntrinsic },
    { "hasAutocorrectedMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasAutocorrectedMarker), (intptr_t)3, NoIntrinsic },
    { "numberOfScrollableAreas", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfScrollableAreas), (intptr_t)1, NoIntrinsic },
    { "isPageBoxVisible", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsPageBoxVisible), (intptr_t)2, NoIntrinsic },
    { "suspendAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSuspendAnimations), (intptr_t)1, NoIntrinsic },
    { "resumeAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionResumeAnimations), (intptr_t)1, NoIntrinsic },
    { "layerTreeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLayerTreeAsText), (intptr_t)2, NoIntrinsic },
    { "scrollingStateTreeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionScrollingStateTreeAsText), (intptr_t)1, NoIntrinsic },
    { "repaintRectsAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRepaintRectsAsText), (intptr_t)1, NoIntrinsic },
    { "garbageCollectDocumentResources", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGarbageCollectDocumentResources), (intptr_t)1, NoIntrinsic },
    { "allowRoundingHacks", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAllowRoundingHacks), (intptr_t)0, NoIntrinsic },
#if ENABLE(INSPECTOR)
    { "numberOfLiveNodes", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfLiveNodes), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "numberOfLiveDocuments", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfLiveDocuments), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "consoleMessageArgumentCounts", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionConsoleMessageArgumentCounts), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "openDummyInspectorFrontend", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionOpenDummyInspectorFrontend), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "closeDummyInspectorFrontend", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCloseDummyInspectorFrontend), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "setInspectorResourcesDataSizeLimits", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetInspectorResourcesDataSizeLimits), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "setJavaScriptProfilingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetJavaScriptProfilingEnabled), (intptr_t)1, NoIntrinsic },
#endif
    { "counterValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCounterValue), (intptr_t)1, NoIntrinsic },
    { "pageNumber", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPageNumber), (intptr_t)3, NoIntrinsic },
    { "iconURLs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIconURLs), (intptr_t)1, NoIntrinsic },
    { "numberOfPages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfPages), (intptr_t)2, NoIntrinsic },
    { "pageProperty", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPageProperty), (intptr_t)2, NoIntrinsic },
    { "pageSizeAndMarginsInPixels", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels), (intptr_t)7, NoIntrinsic },
    { "setPageScaleFactor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPageScaleFactor), (intptr_t)3, NoIntrinsic },
    { "registerURLSchemeAsBypassingContentSecurityPolicy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy), (intptr_t)1, NoIntrinsic },
    { "removeURLSchemeRegisteredAsBypassingContentSecurityPolicy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy), (intptr_t)1, NoIntrinsic },
    { "mallocStatistics", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMallocStatistics), (intptr_t)0, NoIntrinsic },
    { "getReferencedFilePaths", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetReferencedFilePaths), (intptr_t)0, NoIntrinsic },
    { "startTrackingRepaints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionStartTrackingRepaints), (intptr_t)1, NoIntrinsic },
    { "stopTrackingRepaints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionStopTrackingRepaints), (intptr_t)1, NoIntrinsic },
    { "getCurrentCursorInfo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetCurrentCursorInfo), (intptr_t)1, NoIntrinsic },
    { "deserializeBuffer", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionDeserializeBuffer), (intptr_t)1, NoIntrinsic },
    { "serializeObject", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSerializeObject), (intptr_t)1, NoIntrinsic },
    { "setUsesOverlayScrollbars", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetUsesOverlayScrollbars), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalsPrototypeTable = { 273, 255, JSInternalsPrototypeTableValues, 0 };
const ClassInfo JSInternalsPrototype::s_info = { "InternalsPrototype", &Base::s_info, &JSInternalsPrototypeTable, 0, CREATE_METHOD_TABLE(JSInternalsPrototype) };

JSObject* JSInternalsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInternals>(exec, globalObject);
}

bool JSInternalsPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternalsPrototype* thisObject = jsCast<JSInternalsPrototype*>(cell);
    return getStaticPropertySlot<JSInternalsPrototype, JSObject>(exec, &JSInternalsPrototypeTable, thisObject, propertyName, slot);
}

bool JSInternalsPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternalsPrototype* thisObject = jsCast<JSInternalsPrototype*>(object);
    return getStaticPropertyDescriptor<JSInternalsPrototype, JSObject>(exec, &JSInternalsPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInternals::s_info = { "Internals", &Base::s_info, &JSInternalsTable, 0 , CREATE_METHOD_TABLE(JSInternals) };

JSInternals::JSInternals(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Internals> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSInternals::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSInternals::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInternalsPrototype::create(exec->globalData(), globalObject, JSInternalsPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSInternals::destroy(JSC::JSCell* cell)
{
    JSInternals* thisObject = static_cast<JSInternals*>(cell);
    thisObject->JSInternals::~JSInternals();
}

JSInternals::~JSInternals()
{
    releaseImplIfNotNull();
}

bool JSInternals::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternals* thisObject = jsCast<JSInternals*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSInternals, Base>(exec, &JSInternalsTable, thisObject, propertyName, slot);
}

bool JSInternals::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternals* thisObject = jsCast<JSInternals*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSInternals, Base>(exec, &JSInternalsTable, thisObject, propertyName, descriptor);
}

JSValue jsInternalsSettings(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->settings()));
    return result;
}


EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddress(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->address(node));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementRenderTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->elementRenderTreeAsText(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPreloaded(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& url(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPreloaded(document, url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfScopedHTMLStyleChildren(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* scope(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->numberOfScopedHTMLStyleChildren(scope, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnsureShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->ensureShadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->shadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionYoungestShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->youngestShadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOldestShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->oldestShadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionYoungerShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->youngerShadowRoot(root, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRootType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->shadowRootType(root, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasShadowInsertionPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasShadowInsertionPoint(root, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasContentElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasContentElement(root, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCountElementShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* Root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->countElementShadow(Root, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIncluderFor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->includerFor(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowPseudoId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->shadowPseudoId(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShadowPseudoId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& id(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadowPseudoId(element, id, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateContentElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createContentElement(document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetElementByIdInShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* shadowRoot(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& id(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementByIdInShadowRoot(shadowRoot, id, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsValidContentSelect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* contentElement(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isValidContentSelect(contentElement, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTreeScopeRootNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->treeScopeRootNode(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParentTreeScope(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentTreeScope(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSelectorForIdInShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& id(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasSelectorForIdInShadow(host, id, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSelectorForClassInShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& className(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasSelectorForClassInShadow(host, className, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSelectorForAttributeInShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& attributeName(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasSelectorForAttributeInShadow(host, attributeName, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSelectorForPseudoClassInShadow(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& pseudoClass(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasSelectorForPseudoClassInShadow(host, pseudoClass, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNextSiblingByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextSiblingByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFirstChildByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->firstChildByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastChildByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->lastChildByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNextNodeByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextNodeByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPreviousNodeByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->previousNodeByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAttached(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->attached(node, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionVisiblePlaceholder(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->visiblePlaceholder(element));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectColorInColorChooser(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& colorValue(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->selectColorInColorChooser(element, colorValue);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->formControlStateOfPreviousHistoryItem(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    RefPtr<DOMStringList> values(toDOMStringList(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFormControlStateOfPreviousHistoryItem(values, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEnableMockPagePopup(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEnableMockPagePopup(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAbsoluteCaretBounds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->absoluteCaretBounds(document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBoundingBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->boundingBox(element, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInspectorHighlightRects(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->inspectorHighlightRects(document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetBackgroundBlurOnNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int blurLength(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setBackgroundBlurOnNode(node, blurLength, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerCountForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& markerType(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->markerCountForNode(node, markerType, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerRangeForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& markerType(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->markerRangeForNode(node, markerType, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerDescriptionForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& markerType(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->markerDescriptionForNode(node, markerType, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddTextMatchMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Range* range(toRange(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool isActive(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->addTextMatchMarker(range, isActive);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetScrollViewPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setScrollViewPosition(document, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPagination(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& mode(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int gap(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 3) {
        impl->setPagination(document, mode, gap, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    int pageLength(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPagination(document, mode, gap, pageLength, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionConfigurationForViewport(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 6)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float devicePixelRatio(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int deviceWidth(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int deviceHeight(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int availableWidth(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int availableHeight(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->configurationForViewport(document, devicePixelRatio, deviceWidth, deviceHeight, availableWidth, availableHeight, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWasLastChangeUserEdit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* textField(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->wasLastChangeUserEdit(textField, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuggestedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->suggestedValue(inputElement, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSuggestedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSuggestedValue(inputElement, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEditingValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEditingValue(inputElement, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPaintControlTints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->paintControlTints(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollElementToRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int w(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int h(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scrollElementToRect(element, x, y, w, h, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeFromLocationAndLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* scope(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int rangeLocation(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int rangeLength(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->rangeFromLocationAndLength(scope, rangeLocation, rangeLength, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLocationFromRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* scope(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Range* range(toRange(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->locationFromRange(scope, range, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLengthFromRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* scope(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Range* range(toRange(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->lengthFromRange(scope, range, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Range* range(toRange(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->rangeAsText(range, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetDelegatesScrolling(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDelegatesScrolling(enabled, document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchPositionAdjustedToBestClickableNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchPositionAdjustedToBestClickableNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchNodeAdjustedToBestClickableNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchNodeAdjustedToBestClickableNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchPositionAdjustedToBestContextMenuNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchPositionAdjustedToBestContextMenuNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchNodeAdjustedToBestContextMenuNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchNodeAdjustedToBestContextMenuNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBestZoomableAreaForTouchPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->bestZoomableAreaForTouchPoint(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckRequestSequence(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->lastSpellCheckRequestSequence(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->lastSpellCheckProcessedSequence(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPreferredLanguages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->userPreferredLanguages());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserPreferredLanguages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Vector<String> languages(toNativeArray<String>(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUserPreferredLanguages(languages);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWheelEventHandlerCount(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->wheelEventHandlerCount(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchEventHandlerCount(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->touchEventHandlerCount(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNodesFromRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 9)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned topPadding(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned rightPadding(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned bottomPadding(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned leftPadding(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ignoreClipping(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool allowShadowContent(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nodesFromRect(document, x, y, topPadding, rightPadding, bottomPadding, leftPadding, ignoreClipping, allowShadowContent, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEmitInspectorDidBeginFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->emitInspectorDidBeginFrame();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEmitInspectorDidCancelFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->emitInspectorDidCancelFrame();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSpellingMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int from(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasSpellingMarker(document, from, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasGrammarMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int from(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasGrammarMarker(document, from, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasAutocorrectedMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int from(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasAutocorrectedMarker(document, from, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfScrollableAreas(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->numberOfScrollableAreas(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPageBoxVisible(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int pageNumber(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPageBoxVisible(document, pageNumber, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuspendAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->suspendAnimations(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResumeAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->resumeAnimations(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsStringWithCache(exec, impl->layerTreeAsText(document, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    unsigned short flags(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->layerTreeAsText(document, flags, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollingStateTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->scrollingStateTreeAsText(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRepaintRectsAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->repaintRectsAsText(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGarbageCollectDocumentResources(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->garbageCollectDocumentResources(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAllowRoundingHacks(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->allowRoundingHacks();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveNodes(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->numberOfLiveNodes());
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveDocuments(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->numberOfLiveDocuments());
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionConsoleMessageArgumentCounts(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->consoleMessageArgumentCounts(document));
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOpenDummyInspectorFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openDummyInspectorFrontend(url)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCloseDummyInspectorFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->closeDummyInspectorFrontend();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetInspectorResourcesDataSizeLimits(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int maximumResourcesContentSize(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int maximumSingleResourceContentSize(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setInspectorResourcesDataSizeLimits(maximumResourcesContentSize, maximumSingleResourceContentSize, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetJavaScriptProfilingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool creates(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setJavaScriptProfilingEnabled(creates, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCounterValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->counterValue(element));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageNumber(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(impl->pageNumber(element));
        return JSValue::encode(result);
    }

    float pageWidth(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {

        JSC::JSValue result = jsNumber(impl->pageNumber(element, pageWidth));
        return JSValue::encode(result);
    }

    float pageHeight(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->pageNumber(element, pageWidth, pageHeight));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIconURLs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->iconURLs(document));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfPages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {

        JSC::JSValue result = jsNumber(impl->numberOfPages());
        return JSValue::encode(result);
    }

    double pageWidthInPixels(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(impl->numberOfPages(pageWidthInPixels));
        return JSValue::encode(result);
    }

    double pageHeightInPixels(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->numberOfPages(pageWidthInPixels, pageHeightInPixels));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& propertyName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int pageNumber(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->pageProperty(propertyName, pageNumber, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 7)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int pageIndex(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginTop(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginRight(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginBottom(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginLeft(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->pageSizeAndMarginsInPixels(pageIndex, width, height, marginTop, marginRight, marginBottom, marginLeft, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageScaleFactor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    float scaleFactor(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPageScaleFactor(scaleFactor, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& scheme(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->registerURLSchemeAsBypassingContentSecurityPolicy(scheme);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& scheme(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->removeURLSchemeRegisteredAsBypassingContentSecurityPolicy(scheme);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMallocStatistics(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->mallocStatistics()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetReferencedFilePaths(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->getReferencedFilePaths());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingRepaints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->startTrackingRepaints(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStopTrackingRepaints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->stopTrackingRepaints(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCurrentCursorInfo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->getCurrentCursorInfo(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeserializeBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ArrayBuffer* buffer(toArrayBuffer(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = impl->deserializeBuffer(buffer) ? impl->deserializeBuffer(buffer)->deserialize(exec, castedThis->globalObject(), 0) : jsNull();
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSerializeObject(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    RefPtr<SerializedScriptValue> obj(SerializedScriptValue::create(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined), 0, 0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->serializeObject(obj)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUsesOverlayScrollbars(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool enabled(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUsesOverlayScrollbars(enabled);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsInternalsLAYER_TREE_INCLUDES_VISIBLE_RECTS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsInternalsLAYER_TREE_INCLUDES_TILE_CACHES(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsInternalsLAYER_TREE_INCLUDES_REPAINT_RECTS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

static inline bool isObservable(JSInternals* jsInternals)
{
    if (jsInternals->hasCustomProperties())
        return true;
    return false;
}

bool JSInternalsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSInternals* jsInternals = jsCast<JSInternals*>(handle.get().asCell());
    if (!isObservable(jsInternals))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSInternalsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSInternals* jsInternals = jsCast<JSInternals*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInternals->impl(), jsInternals);
    jsInternals->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Internals* impl)
{
    return wrap<JSInternals>(exec, globalObject, impl);
}

Internals* toInternals(JSC::JSValue value)
{
    return value.inherits(&JSInternals::s_info) ? jsCast<JSInternals*>(asObject(value))->impl() : 0;
}

}
