/*
 * Copyright (c) 2009 Charles S. Wilson
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a 
 * copy of this software and associated documentation files (the "Software"), 
 * to deal in the Software without restriction, including without limitation 
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, 
 * and/or sell copies of the Software, and to permit persons to whom the 
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included 
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS 
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
 * OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef RUN2_CONFDATA_H
#define RUN2_CONFDATA_H

#include <stdio.h>
#include <ustr.h>
#include "cdsl/cdsl_dlist.h"
#include "cdsl/cdsl_map.h"

typedef struct run2_selfoptions {
  cdsl_dlist_t *args;
} run2_selfoptions_t;

typedef struct run2_env_spec {
  Ustr         *set;     /* may be null  */
  cdsl_dlist_t *prepend; /* may be empty */
  cdsl_dlist_t *append;  /* may be empty */
} run2_env_spec_t;

typedef struct run2_env {
  cdsl_map_t    *map; /* map[VAR] = env_spec_t */
} run2_env_t;

typedef struct run2_tgt_spec {
  Ustr         *filename;
  Ustr         *startin;  /* may be null */
  cdsl_dlist_t *args;
} run2_tgt_spec_t;

typedef struct run2_global {
  run2_env_t      *env;
  run2_tgt_spec_t *tgt;   /* may be null */
} run2_global_t;

typedef struct run2_tgtopts {
  run2_env_t      *env;
  run2_tgt_spec_t *tgt;
} run2_tgtopts_t;


typedef struct run2_confdata {
  run2_selfoptions_t *selfopt;
  run2_global_t      *global;
  run2_tgtopts_t     *gdi;
  run2_tgtopts_t     *x11;
} run2_confdata_t;


run2_selfoptions_t * run2_selfoptions_create (void);
void                 run2_selfoptions_delete (run2_selfoptions_t *arg);
void                 run2_selfoptions_print  (FILE * f, int level,
                                              const Ustr *name,
                                              const run2_selfoptions_t *elem);

run2_env_spec_t *    run2_env_spec_create (void);
run2_env_spec_t *    run2_env_spec_copy   (run2_env_spec_t * arg);
void                 run2_env_spec_delete (run2_env_spec_t *arg);
void                 run2_env_spec_print  (FILE * f, int level,
                                           const Ustr *name,
                                           const run2_env_spec_t *elem);

run2_env_t *         run2_env_create (void);
void                 run2_env_delete (run2_env_t *arg);
void                 run2_env_print  (FILE * f, int level, const Ustr *name,
                                      const run2_env_t *elem);

run2_global_t *      run2_global_create (void);
void                 run2_global_delete (run2_global_t *arg);
void                 run2_global_print  (FILE * f, int level, const Ustr *name,
                                         const run2_global_t *elem);

run2_tgt_spec_t *    run2_tgt_spec_create (void);
void                 run2_tgt_spec_delete (run2_tgt_spec_t *arg);
void                 run2_tgt_spec_print  (FILE * f, int level,
                                           const Ustr *name,
                                           const run2_tgt_spec_t *elem);

run2_tgtopts_t *     run2_tgtopts_create (void);
void                 run2_tgtopts_delete (run2_tgtopts_t *arg);
void                 run2_tgtopts_print  (FILE * f, int level, const Ustr *name,
                                          const run2_tgtopts_t *elem);

run2_confdata_t *    run2_confdata_create (void);
void                 run2_confdata_delete (run2_confdata_t *arg);
void                 run2_confdata_print  (FILE * f, int level,
                                           const Ustr *name,
                                           const run2_confdata_t *elem);

int run2_selfoptions_add_arg (run2_selfoptions_t *elem,
                              const Ustr         *entry);

int run2_env_spec_set     (run2_env_spec_t *elem,
                           const Ustr      *set);
int run2_env_spec_prepend (run2_env_spec_t *elem,
                           const Ustr      *prepend);
int run2_env_spec_append  (run2_env_spec_t *elem,
                           const Ustr      *append);

run2_env_spec_t *
run2_env_get_var (run2_env_t *elem,
                  const Ustr *varname);

run2_env_t *
run2_global_get_env (run2_global_t *elem);

run2_tgt_spec_t *
run2_global_get_tgt (run2_global_t *elem);

int run2_tgt_spec_add_arg (run2_tgt_spec_t *elem,
                           const Ustr      *entry);
int run2_tgt_spec_set_filename (run2_tgt_spec_t *elem,
                                const Ustr      *filename);
int run2_tgt_spec_set_startin (run2_tgt_spec_t *elem,
                               const Ustr      *startin);

run2_env_t *
run2_tgtopts_get_env (run2_tgtopts_t *elem);

run2_tgt_spec_t *
run2_tgtopts_get_tgt (run2_tgtopts_t *elem);

run2_selfoptions_t *
run2_confdata_get_selfoptions (run2_confdata_t *elem);

run2_global_t *
run2_confdata_get_global (run2_confdata_t *elem);

run2_tgtopts_t *
run2_confdata_get_gdi (run2_confdata_t *elem);

run2_tgtopts_t *
run2_confdata_get_x11 (run2_confdata_t *elem);

#endif /* RUN2_CONFDATA_H */

