#include <attica_includes.h>

#include <smoke.h>
#include <attica_smoke.h>

namespace __smokeattica {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
};

// These are the xenum functions for manipulating enum pointers

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//1
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
};

static Smoke::Index ambiguousMethodList[] = {
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *attica_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_attica_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    attica_Smoke = new Smoke(
        "attica",
        __smokeattica::classes, 1,
        __smokeattica::methods, 1,
        __smokeattica::methodMaps, 1,
        __smokeattica::methodNames, 0,
        __smokeattica::types, 0,
        __smokeattica::inheritanceList,
        __smokeattica::argumentList,
        __smokeattica::ambiguousMethodList,
        __smokeattica::cast );
    initialized = true;
}

void delete_attica_Smoke() { delete attica_Smoke; }

}
