#include <knewstuff2_includes.h>

#include <smoke.h>
#include <knewstuff2_smoke.h>

namespace __smokeknewstuff2 {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //KAction
      switch(to) {
        case 1: return (void*)(KAction*)xptr;
        default: return xptr;
      }
    case 2:   //KActionCollection
      switch(to) {
        case 2: return (void*)(KActionCollection*)xptr;
        default: return xptr;
      }
    case 3:   //KNS::Author
      switch(to) {
        case 3: return (void*)(KNS::Author*)xptr;
        default: return xptr;
      }
    case 4:   //KNS::Button
      switch(to) {
        case 8: return (void*)(KPushButton*)(KNS::Button*)xptr;
        case 58: return (void*)(QPushButton*)(KNS::Button*)xptr;
        case 9: return (void*)(QAbstractButton*)(KNS::Button*)xptr;
        case 79: return (void*)(QWidget*)(KNS::Button*)xptr;
        case 48: return (void*)(QObject*)(KNS::Button*)xptr;
        case 4: return (void*)(KNS::Button*)xptr;
        default: return xptr;
      }
    case 5:   //KNS::Engine
      switch(to) {
        case 5: return (void*)(KNS::Engine*)xptr;
        default: return xptr;
      }
    case 6:   //KNS::Entry
      switch(to) {
        case 6: return (void*)(KNS::Entry*)xptr;
        default: return xptr;
      }
    case 7:   //KNS::KTranslatable
      switch(to) {
        case 7: return (void*)(KNS::KTranslatable*)xptr;
        default: return xptr;
      }
    case 8:   //KPushButton
      switch(to) {
        case 58: return (void*)(QPushButton*)(KPushButton*)xptr;
        case 9: return (void*)(QAbstractButton*)(KPushButton*)xptr;
        case 79: return (void*)(QWidget*)(KPushButton*)xptr;
        case 48: return (void*)(QObject*)(KPushButton*)xptr;
        case 8: return (void*)(KPushButton*)xptr;
        case 4: return (void*)(KNS::Button*)(KPushButton*)xptr;
        default: return xptr;
      }
    case 9:   //QAbstractButton
      switch(to) {
        case 79: return (void*)(QWidget*)(QAbstractButton*)xptr;
        case 48: return (void*)(QObject*)(QAbstractButton*)xptr;
        case 9: return (void*)(QAbstractButton*)xptr;
        case 4: return (void*)(KNS::Button*)(QAbstractButton*)xptr;
        default: return xptr;
      }
    case 10:   //QActionEvent
      switch(to) {
        case 10: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QBool
      switch(to) {
        case 11: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 12:   //QBrush
      switch(to) {
        case 12: return (void*)(QBrush*)xptr;
        default: return xptr;
      }
    case 13:   //QByteArray
      switch(to) {
        case 13: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 14:   //QChar
      switch(to) {
        case 14: return (void*)(QChar*)xptr;
        default: return xptr;
      }
    case 15:   //QChildEvent
      switch(to) {
        case 15: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 16:   //QCloseEvent
      switch(to) {
        case 16: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 17:   //QColor
      switch(to) {
        case 17: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 18:   //QContextMenuEvent
      switch(to) {
        case 18: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 19:   //QCursor
      switch(to) {
        case 19: return (void*)(QCursor*)xptr;
        default: return xptr;
      }
    case 20:   //QDataStream
      switch(to) {
        case 20: return (void*)(QDataStream*)xptr;
        default: return xptr;
      }
    case 21:   //QDate
      switch(to) {
        case 21: return (void*)(QDate*)xptr;
        default: return xptr;
      }
    case 22:   //QDateTime
      switch(to) {
        case 22: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 23:   //QDrag
      switch(to) {
        case 23: return (void*)(QDrag*)xptr;
        default: return xptr;
      }
    case 24:   //QDragEnterEvent
      switch(to) {
        case 24: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 25:   //QDragLeaveEvent
      switch(to) {
        case 25: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 26:   //QDragMoveEvent
      switch(to) {
        case 26: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 27:   //QDropEvent
      switch(to) {
        case 27: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 28:   //QEvent
      switch(to) {
        case 28: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 29:   //QFocusEvent
      switch(to) {
        case 29: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 30:   //QFont
      switch(to) {
        case 30: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 32:   //QHashDummyValue
      switch(to) {
        case 32: return (void*)(QHashDummyValue*)xptr;
        default: return xptr;
      }
    case 33:   //QHideEvent
      switch(to) {
        case 33: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 34:   //QIcon
      switch(to) {
        case 34: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 35:   //QImage
      switch(to) {
        case 35: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 36:   //QIncompatibleFlag
      switch(to) {
        case 36: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 37:   //QInputMethodEvent
      switch(to) {
        case 37: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 38:   //QKeyEvent
      switch(to) {
        case 38: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 39:   //QKeySequence
      switch(to) {
        case 39: return (void*)(QKeySequence*)xptr;
        default: return xptr;
      }
    case 40:   //QLatin1String
      switch(to) {
        case 40: return (void*)(QLatin1String*)xptr;
        default: return xptr;
      }
    case 41:   //QLine
      switch(to) {
        case 41: return (void*)(QLine*)xptr;
        default: return xptr;
      }
    case 42:   //QLineF
      switch(to) {
        case 42: return (void*)(QLineF*)xptr;
        default: return xptr;
      }
    case 43:   //QMargins
      switch(to) {
        case 43: return (void*)(QMargins*)xptr;
        default: return xptr;
      }
    case 44:   //QMatrix
      switch(to) {
        case 44: return (void*)(QMatrix*)xptr;
        default: return xptr;
      }
    case 45:   //QMetaObject
      switch(to) {
        case 45: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 46:   //QMouseEvent
      switch(to) {
        case 46: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 47:   //QMoveEvent
      switch(to) {
        case 47: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 48:   //QObject
      switch(to) {
        case 48: return (void*)(QObject*)xptr;
        case 4: return (void*)(KNS::Button*)(QObject*)xptr;
        default: return xptr;
      }
    case 49:   //QPaintEngine
      switch(to) {
        case 49: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 50:   //QPaintEvent
      switch(to) {
        case 50: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 51:   //QPainterPath
      switch(to) {
        case 51: return (void*)(QPainterPath*)xptr;
        default: return xptr;
      }
    case 52:   //QPalette
      switch(to) {
        case 52: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 53:   //QPixmap
      switch(to) {
        case 53: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 54:   //QPoint
      switch(to) {
        case 54: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 55:   //QPointF
      switch(to) {
        case 55: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 56:   //QPolygon
      switch(to) {
        case 56: return (void*)(QPolygon*)xptr;
        default: return xptr;
      }
    case 57:   //QPolygonF
      switch(to) {
        case 57: return (void*)(QPolygonF*)xptr;
        default: return xptr;
      }
    case 58:   //QPushButton
      switch(to) {
        case 9: return (void*)(QAbstractButton*)(QPushButton*)xptr;
        case 79: return (void*)(QWidget*)(QPushButton*)xptr;
        case 48: return (void*)(QObject*)(QPushButton*)xptr;
        case 58: return (void*)(QPushButton*)xptr;
        case 4: return (void*)(KNS::Button*)(QPushButton*)xptr;
        default: return xptr;
      }
    case 59:   //QRect
      switch(to) {
        case 59: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 60:   //QRectF
      switch(to) {
        case 60: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 61:   //QRegExp
      switch(to) {
        case 61: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 62:   //QRegion
      switch(to) {
        case 62: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 63:   //QResizeEvent
      switch(to) {
        case 63: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 64:   //QShowEvent
      switch(to) {
        case 64: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 65:   //QSize
      switch(to) {
        case 65: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 66:   //QSizeF
      switch(to) {
        case 66: return (void*)(QSizeF*)xptr;
        default: return xptr;
      }
    case 67:   //QSizePolicy
      switch(to) {
        case 67: return (void*)(QSizePolicy*)xptr;
        default: return xptr;
      }
    case 68:   //QString::Null
      switch(to) {
        case 68: return (void*)(QString::Null*)xptr;
        default: return xptr;
      }
    case 69:   //QStringRef
      switch(to) {
        case 69: return (void*)(QStringRef*)xptr;
        default: return xptr;
      }
    case 70:   //QStyle
      switch(to) {
        case 70: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 71:   //QTabletEvent
      switch(to) {
        case 71: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 72:   //QTime
      switch(to) {
        case 72: return (void*)(QTime*)xptr;
        default: return xptr;
      }
    case 73:   //QTimerEvent
      switch(to) {
        case 73: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 74:   //QTransform
      switch(to) {
        case 74: return (void*)(QTransform*)xptr;
        default: return xptr;
      }
    case 75:   //QUrl
      switch(to) {
        case 75: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 76:   //QVariant
      switch(to) {
        case 76: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 77:   //QVariantComparisonHelper
      switch(to) {
        case 77: return (void*)(QVariantComparisonHelper*)xptr;
        default: return xptr;
      }
    case 78:   //QWheelEvent
      switch(to) {
        case 78: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 79:   //QWidget
      switch(to) {
        case 48: return (void*)(QObject*)(QWidget*)xptr;
        case 79: return (void*)(QWidget*)xptr;
        case 4: return (void*)(KNS::Button*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    8, 0,	// 1: KPushButton
};

// These are the xenum functions for manipulating enum pointers
void xenum_KNS__Entry(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_KNS__Author(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS__Button(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS__Engine(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS__Entry(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS__KTranslatable(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "KAction", true, 0, 0, 0, 0, 0 },	//1
    { "KActionCollection", true, 0, 0, 0, 0, 0 },	//2
    { "KNS::Author", false, 0, xcall_KNS__Author, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KNS::Author) },	//3
    { "KNS::Button", false, 1, xcall_KNS__Button, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KNS::Button) },	//4
    { "KNS::Engine", false, 0, xcall_KNS__Engine, 0, Smoke::cf_constructor, sizeof(KNS::Engine) },	//5
    { "KNS::Entry", false, 0, xcall_KNS__Entry, xenum_KNS__Entry, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KNS::Entry) },	//6
    { "KNS::KTranslatable", false, 0, xcall_KNS__KTranslatable, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KNS::KTranslatable) },	//7
    { "KPushButton", true, 0, 0, 0, 0, 0 },	//8
    { "QAbstractButton", true, 0, 0, 0, 0, 0 },	//9
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QBool", true, 0, 0, 0, 0, 0 },	//11
    { "QBrush", true, 0, 0, 0, 0, 0 },	//12
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//13
    { "QChar", true, 0, 0, 0, 0, 0 },	//14
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//15
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//16
    { "QColor", true, 0, 0, 0, 0, 0 },	//17
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//18
    { "QCursor", true, 0, 0, 0, 0, 0 },	//19
    { "QDataStream", true, 0, 0, 0, 0, 0 },	//20
    { "QDate", true, 0, 0, 0, 0, 0 },	//21
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//22
    { "QDrag", true, 0, 0, 0, 0, 0 },	//23
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//24
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//25
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//26
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//27
    { "QEvent", true, 0, 0, 0, 0, 0 },	//28
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//29
    { "QFont", true, 0, 0, 0, 0, 0 },	//30
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//31
    { "QHashDummyValue", true, 0, 0, 0, 0, 0 },	//32
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//33
    { "QIcon", true, 0, 0, 0, 0, 0 },	//34
    { "QImage", true, 0, 0, 0, 0, 0 },	//35
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//36
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//37
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//38
    { "QKeySequence", true, 0, 0, 0, 0, 0 },	//39
    { "QLatin1String", true, 0, 0, 0, 0, 0 },	//40
    { "QLine", true, 0, 0, 0, 0, 0 },	//41
    { "QLineF", true, 0, 0, 0, 0, 0 },	//42
    { "QMargins", true, 0, 0, 0, 0, 0 },	//43
    { "QMatrix", true, 0, 0, 0, 0, 0 },	//44
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//45
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//46
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//47
    { "QObject", true, 0, 0, 0, 0, 0 },	//48
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//49
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//50
    { "QPainterPath", true, 0, 0, 0, 0, 0 },	//51
    { "QPalette", true, 0, 0, 0, 0, 0 },	//52
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//53
    { "QPoint", true, 0, 0, 0, 0, 0 },	//54
    { "QPointF", true, 0, 0, 0, 0, 0 },	//55
    { "QPolygon", true, 0, 0, 0, 0, 0 },	//56
    { "QPolygonF", true, 0, 0, 0, 0, 0 },	//57
    { "QPushButton", true, 0, 0, 0, 0, 0 },	//58
    { "QRect", true, 0, 0, 0, 0, 0 },	//59
    { "QRectF", true, 0, 0, 0, 0, 0 },	//60
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//61
    { "QRegion", true, 0, 0, 0, 0, 0 },	//62
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//63
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//64
    { "QSize", true, 0, 0, 0, 0, 0 },	//65
    { "QSizeF", true, 0, 0, 0, 0, 0 },	//66
    { "QSizePolicy", true, 0, 0, 0, 0, 0 },	//67
    { "QString::Null", true, 0, 0, 0, 0, 0 },	//68
    { "QStringRef", true, 0, 0, 0, 0, 0 },	//69
    { "QStyle", true, 0, 0, 0, 0, 0 },	//70
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//71
    { "QTime", true, 0, 0, 0, 0, 0 },	//72
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//73
    { "QTransform", true, 0, 0, 0, 0, 0 },	//74
    { "QUrl", true, 0, 0, 0, 0, 0 },	//75
    { "QVariant", true, 0, 0, 0, 0, 0 },	//76
    { "QVariantComparisonHelper", true, 0, 0, 0, 0, 0 },	//77
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//78
    { "QWidget", true, 0, 0, 0, 0, 0 },	//79
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "KAction*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "KActionCollection*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "KGlobal::CopyCatalogs", 0, Smoke::t_enum|Smoke::tf_stack },	//3
    { "KIconLoader::Group", 0, Smoke::t_enum|Smoke::tf_stack },	//4
    { "KIconLoader::Group&", 0, Smoke::t_enum|Smoke::tf_ref },	//5
    { "KNS::Author", 3, Smoke::t_class|Smoke::tf_stack },	//6
    { "KNS::Author&", 3, Smoke::t_class|Smoke::tf_ref },	//7
    { "KNS::Author*", 3, Smoke::t_class|Smoke::tf_ptr },	//8
    { "KNS::Button*", 4, Smoke::t_class|Smoke::tf_ptr },	//9
    { "KNS::Engine*", 5, Smoke::t_class|Smoke::tf_ptr },	//10
    { "KNS::Entry&", 6, Smoke::t_class|Smoke::tf_ref },	//11
    { "KNS::Entry*", 6, Smoke::t_class|Smoke::tf_ptr },	//12
    { "KNS::Entry::Source", 6, Smoke::t_enum|Smoke::tf_stack },	//13
    { "KNS::Entry::Status", 6, Smoke::t_enum|Smoke::tf_stack },	//14
    { "KNS::KTranslatable", 7, Smoke::t_class|Smoke::tf_stack },	//15
    { "KNS::KTranslatable&", 7, Smoke::t_class|Smoke::tf_ref },	//16
    { "KNS::KTranslatable*", 7, Smoke::t_class|Smoke::tf_ptr },	//17
    { "KStandardGuiItem::BidiMode", 0, Smoke::t_enum|Smoke::tf_stack },	//18
    { "KStandardGuiItem::StandardItem", 0, Smoke::t_enum|Smoke::tf_stack },	//19
    { "KUrl::CleanPathOption", 0, Smoke::t_enum|Smoke::tf_stack },	//20
    { "KUrl::DirectoryOption", 0, Smoke::t_enum|Smoke::tf_stack },	//21
    { "KUrl::EncodedPathAndQueryOption", 0, Smoke::t_enum|Smoke::tf_stack },	//22
    { "KUrl::EqualsOption", 0, Smoke::t_enum|Smoke::tf_stack },	//23
    { "KUrl::QueryItemsOption", 0, Smoke::t_enum|Smoke::tf_stack },	//24
    { "QActionEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QBool", 11, Smoke::t_class|Smoke::tf_stack },	//26
    { "QBrush&", 12, Smoke::t_class|Smoke::tf_ref },	//27
    { "QByteArray&", 13, Smoke::t_class|Smoke::tf_ref },	//28
    { "QChar", 14, Smoke::t_class|Smoke::tf_stack },	//29
    { "QChar&", 14, Smoke::t_class|Smoke::tf_ref },	//30
    { "QChildEvent*", 15, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QCloseEvent*", 16, Smoke::t_class|Smoke::tf_ptr },	//32
    { "QColor&", 17, Smoke::t_class|Smoke::tf_ref },	//33
    { "QContextMenuEvent*", 18, Smoke::t_class|Smoke::tf_ptr },	//34
    { "QCursor&", 19, Smoke::t_class|Smoke::tf_ref },	//35
    { "QDataStream&", 20, Smoke::t_class|Smoke::tf_ref },	//36
    { "QDate", 21, Smoke::t_class|Smoke::tf_stack },	//37
    { "QDate&", 21, Smoke::t_class|Smoke::tf_ref },	//38
    { "QDateTime&", 22, Smoke::t_class|Smoke::tf_ref },	//39
    { "QDrag*", 23, Smoke::t_class|Smoke::tf_ptr },	//40
    { "QDragEnterEvent*", 24, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QDragLeaveEvent*", 25, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QDragMoveEvent*", 26, Smoke::t_class|Smoke::tf_ptr },	//43
    { "QDropEvent*", 27, Smoke::t_class|Smoke::tf_ptr },	//44
    { "QEvent*", 28, Smoke::t_class|Smoke::tf_ptr },	//45
    { "QFlags<KUrl::CleanPathOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//46
    { "QFlags<KUrl::DirectoryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//47
    { "QFlags<KUrl::EncodedPathAndQueryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//48
    { "QFlags<KUrl::EqualsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//49
    { "QFlags<KUrl::QueryItemsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//50
    { "QFlags<QIODevice::OpenModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//51
    { "QFlags<QSizePolicy::ControlType>", 0, Smoke::t_uint|Smoke::tf_stack },	//52
    { "QFlags<QString::SectionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//53
    { "QFlags<QUrl::FormattingOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//54
    { "QFlags<QWidget::RenderFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//55
    { "QFlags<Qt::AlignmentFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//56
    { "QFlags<Qt::DockWidgetArea>", 0, Smoke::t_uint|Smoke::tf_stack },	//57
    { "QFlags<Qt::DropAction>", 0, Smoke::t_uint|Smoke::tf_stack },	//58
    { "QFlags<Qt::GestureFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//59
    { "QFlags<Qt::ImageConversionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//60
    { "QFlags<Qt::InputMethodHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//61
    { "QFlags<Qt::ItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//62
    { "QFlags<Qt::KeyboardModifier>", 0, Smoke::t_uint|Smoke::tf_stack },	//63
    { "QFlags<Qt::MatchFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//64
    { "QFlags<Qt::MouseButton>", 0, Smoke::t_uint|Smoke::tf_stack },	//65
    { "QFlags<Qt::Orientation>", 0, Smoke::t_uint|Smoke::tf_stack },	//66
    { "QFlags<Qt::TextInteractionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//67
    { "QFlags<Qt::ToolBarArea>", 0, Smoke::t_uint|Smoke::tf_stack },	//68
    { "QFlags<Qt::TouchPointState>", 0, Smoke::t_uint|Smoke::tf_stack },	//69
    { "QFlags<Qt::WindowState>", 0, Smoke::t_uint|Smoke::tf_stack },	//70
    { "QFlags<Qt::WindowType>", 0, Smoke::t_uint|Smoke::tf_stack },	//71
    { "QFocusEvent*", 29, Smoke::t_class|Smoke::tf_ptr },	//72
    { "QFont&", 30, Smoke::t_class|Smoke::tf_ref },	//73
    { "QHideEvent*", 33, Smoke::t_class|Smoke::tf_ptr },	//74
    { "QIODevice::OpenModeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "QIcon&", 34, Smoke::t_class|Smoke::tf_ref },	//76
    { "QImage&", 35, Smoke::t_class|Smoke::tf_ref },	//77
    { "QIncompatibleFlag", 36, Smoke::t_class|Smoke::tf_stack },	//78
    { "QInputMethodEvent*", 37, Smoke::t_class|Smoke::tf_ptr },	//79
    { "QKeyEvent*", 38, Smoke::t_class|Smoke::tf_ptr },	//80
    { "QKeySequence&", 39, Smoke::t_class|Smoke::tf_ref },	//81
    { "QLine", 41, Smoke::t_class|Smoke::tf_stack },	//82
    { "QLine&", 41, Smoke::t_class|Smoke::tf_ref },	//83
    { "QLineF", 42, Smoke::t_class|Smoke::tf_stack },	//84
    { "QLineF&", 42, Smoke::t_class|Smoke::tf_ref },	//85
    { "QList<KNS::Entry*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//86
    { "QMap<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//87
    { "QMatrix&", 44, Smoke::t_class|Smoke::tf_ref },	//88
    { "QMetaObject::Call", 45, Smoke::t_enum|Smoke::tf_stack },	//89
    { "QMouseEvent*", 46, Smoke::t_class|Smoke::tf_ptr },	//90
    { "QMoveEvent*", 47, Smoke::t_class|Smoke::tf_ptr },	//91
    { "QObject*", 48, Smoke::t_class|Smoke::tf_ptr },	//92
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "QPaintEngine*", 49, Smoke::t_class|Smoke::tf_ptr },	//94
    { "QPaintEvent*", 50, Smoke::t_class|Smoke::tf_ptr },	//95
    { "QPainterPath", 51, Smoke::t_class|Smoke::tf_stack },	//96
    { "QPainterPath&", 51, Smoke::t_class|Smoke::tf_ref },	//97
    { "QPalette&", 52, Smoke::t_class|Smoke::tf_ref },	//98
    { "QPixmap&", 53, Smoke::t_class|Smoke::tf_ref },	//99
    { "QPoint", 54, Smoke::t_class|Smoke::tf_stack },	//100
    { "QPoint&", 54, Smoke::t_class|Smoke::tf_ref },	//101
    { "QPointF", 55, Smoke::t_class|Smoke::tf_stack },	//102
    { "QPointF&", 55, Smoke::t_class|Smoke::tf_ref },	//103
    { "QPolygon", 56, Smoke::t_class|Smoke::tf_stack },	//104
    { "QPolygon&", 56, Smoke::t_class|Smoke::tf_ref },	//105
    { "QPolygonF", 57, Smoke::t_class|Smoke::tf_stack },	//106
    { "QPolygonF&", 57, Smoke::t_class|Smoke::tf_ref },	//107
    { "QRect&", 59, Smoke::t_class|Smoke::tf_ref },	//108
    { "QRectF&", 60, Smoke::t_class|Smoke::tf_ref },	//109
    { "QRegExp&", 61, Smoke::t_class|Smoke::tf_ref },	//110
    { "QRegion", 62, Smoke::t_class|Smoke::tf_stack },	//111
    { "QRegion&", 62, Smoke::t_class|Smoke::tf_ref },	//112
    { "QResizeEvent*", 63, Smoke::t_class|Smoke::tf_ptr },	//113
    { "QShowEvent*", 64, Smoke::t_class|Smoke::tf_ptr },	//114
    { "QSize", 65, Smoke::t_class|Smoke::tf_stack },	//115
    { "QSize&", 65, Smoke::t_class|Smoke::tf_ref },	//116
    { "QSizeF&", 66, Smoke::t_class|Smoke::tf_ref },	//117
    { "QSizePolicy&", 67, Smoke::t_class|Smoke::tf_ref },	//118
    { "QSizePolicy::ControlType", 67, Smoke::t_enum|Smoke::tf_stack },	//119
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//120
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//121
    { "QString::Null", 68, Smoke::t_class|Smoke::tf_stack },	//122
    { "QString::SectionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//124
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//125
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//126
    { "QStyle&", 70, Smoke::t_class|Smoke::tf_ref },	//127
    { "QTabletEvent*", 71, Smoke::t_class|Smoke::tf_ptr },	//128
    { "QTime&", 72, Smoke::t_class|Smoke::tf_ref },	//129
    { "QTimerEvent*", 73, Smoke::t_class|Smoke::tf_ptr },	//130
    { "QTransform", 74, Smoke::t_class|Smoke::tf_stack },	//131
    { "QTransform&", 74, Smoke::t_class|Smoke::tf_ref },	//132
    { "QUrl&", 75, Smoke::t_class|Smoke::tf_ref },	//133
    { "QUrl::FormattingOption", 75, Smoke::t_enum|Smoke::tf_stack },	//134
    { "QVariant", 76, Smoke::t_class|Smoke::tf_stack },	//135
    { "QVariant&", 76, Smoke::t_class|Smoke::tf_ref },	//136
    { "QVariant::Type&", 76, Smoke::t_enum|Smoke::tf_ref },	//137
    { "QWheelEvent*", 78, Smoke::t_class|Smoke::tf_ptr },	//138
    { "QWidget*", 79, Smoke::t_class|Smoke::tf_ptr },	//139
    { "QWidget::RenderFlag", 79, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//159
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//162
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//164
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//166
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//167
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//168
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//169
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//170
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//175
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//213
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//214
    { "char", 0, Smoke::t_char|Smoke::tf_stack },	//215
    { "const KNS::Author&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//216
    { "const KNS::Entry&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//217
    { "const KNS::KTranslatable&", 7, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//218
    { "const QBrush&", 12, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//219
    { "const QByteArray", 13, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//220
    { "const QByteArray&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//221
    { "const QChar&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//222
    { "const QColor&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//223
    { "const QCursor&", 19, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//224
    { "const QDate&", 21, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//225
    { "const QDateTime&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//226
    { "const QFont&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//227
    { "const QHashDummyValue&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//228
    { "const QIcon&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//229
    { "const QImage&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//230
    { "const QKeySequence&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//231
    { "const QLatin1String&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//232
    { "const QLine&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//233
    { "const QLineF&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//234
    { "const QMargins&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//235
    { "const QMatrix&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//236
    { "const QMetaObject&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//237
    { "const QMetaObject*", 45, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//238
    { "const QObject*", 48, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//239
    { "const QPainterPath&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//240
    { "const QPalette&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//241
    { "const QPixmap&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//242
    { "const QPoint", 54, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//243
    { "const QPoint&", 54, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//244
    { "const QPointF", 55, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//245
    { "const QPointF&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//246
    { "const QPolygon&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//247
    { "const QPolygonF&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//248
    { "const QRect&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//249
    { "const QRectF&", 60, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//250
    { "const QRegExp&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//251
    { "const QRegion&", 62, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//252
    { "const QSize", 65, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//253
    { "const QSize&", 65, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//254
    { "const QSizeF", 66, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//255
    { "const QSizeF&", 66, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//256
    { "const QSizePolicy&", 67, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//257
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//258
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//259
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//260
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//261
    { "const QStringRef&", 69, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//262
    { "const QTime&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//263
    { "const QTransform&", 74, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//264
    { "const QUrl&", 75, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//265
    { "const QVariant&", 76, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//266
    { "const QVariant::Type", 76, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//267
    { "const QVariantComparisonHelper&", 77, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//268
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//269
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//270
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//271
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//272
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//273
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//274
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//275
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//276
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    216, 0,	//1  const KNS::Author&
    259, 0,	//3  const QString&
    269, 0,	//5  const char*
    269, 269, 0,	//7  const char*, const char*
    269, 269, 273, 0,	//10  const char*, const char*, int
    89, 273, 275, 0,	//14  QMetaObject::Call, int, void**
    259, 259, 259, 139, 0,	//18  const QString&, const QString&, const QString&, QWidget*
    139, 0,	//23  QWidget*
    92, 269, 0,	//25  QObject*, const char*
    217, 0,	//28  const KNS::Entry&
    218, 0,	//30  const KNS::KTranslatable&
    273, 0,	//32  int
    225, 0,	//34  const QDate&
    260, 0,	//36  const QStringList&
    14, 0,	//38  KNS::Entry::Status
    13, 0,	//40  KNS::Entry::Source
    259, 259, 0,	//42  const QString&, const QString&
    90, 0,	//45  QMouseEvent*
    95, 0,	//47  QPaintEvent*
    244, 0,	//49  const QPoint&
    80, 0,	//51  QKeyEvent*
    45, 0,	//53  QEvent*
    130, 0,	//55  QTimerEvent*
    161, 273, 0,	//57  Qt::DockWidgetArea, int
    244, 271, 0,	//60  const QPoint&, double
    271, 246, 0,	//63  double, const QPointF&
    185, 65, 0,	//66  Qt::MouseButton, QFlags<Qt::MouseButton>
    235, 235, 0,	//69  const QMargins&, const QMargins&
    271, 256, 0,	//72  double, const QSizeF&
    36, 77, 0,	//75  QDataStream&, QImage&
    36, 257, 0,	//78  QDataStream&, const QSizePolicy&
    174, 273, 0,	//81  Qt::InputMethodHint, int
    249, 249, 0,	//84  const QRect&, const QRect&
    254, 254, 0,	//87  const QSize&, const QSize&
    36, 264, 0,	//90  QDataStream&, const QTransform&
    246, 236, 0,	//93  const QPointF&, const QMatrix&
    233, 264, 0,	//96  const QLine&, const QTransform&
    211, 70, 0,	//99  Qt::WindowState, QFlags<Qt::WindowState>
    256, 271, 0,	//102  const QSizeF&, double
    36, 233, 0,	//105  QDataStream&, const QLine&
    269, 232, 0,	//108  const char*, const QLatin1String&
    256, 256, 0,	//111  const QSizeF&, const QSizeF&
    221, 221, 0,	//114  const QByteArray&, const QByteArray&
    232, 262, 0,	//117  const QLatin1String&, const QStringRef&
    185, 185, 0,	//120  Qt::MouseButton, Qt::MouseButton
    20, 46, 0,	//123  KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>
    20, 20, 0,	//126  KUrl::CleanPathOption, KUrl::CleanPathOption
    266, 268, 0,	//129  const QVariant&, const QVariantComparisonHelper&
    26, 26, 0,	//132  QBool, QBool
    141, 56, 0,	//135  Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>
    122, 122, 0,	//138  QString::Null, QString::Null
    36, 250, 0,	//141  QDataStream&, const QRectF&
    29, 259, 0,	//144  QChar, const QString&
    75, 51, 0,	//147  QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>
    36, 241, 0,	//150  QDataStream&, const QPalette&
    5, 0,	//153  KIconLoader::Group&
    36, 221, 0,	//155  QDataStream&, const QByteArray&
    248, 264, 0,	//158  const QPolygonF&, const QTransform&
    202, 202, 0,	//161  Qt::ToolBarArea, Qt::ToolBarArea
    24, 273, 0,	//164  KUrl::QueryItemsOption, int
    140, 273, 0,	//167  QWidget::RenderFlag, int
    163, 273, 0,	//170  Qt::DropAction, int
    36, 260, 0,	//173  QDataStream&, const QStringList&
    22, 22, 0,	//176  KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption
    141, 141, 0,	//179  Qt::AlignmentFlag, Qt::AlignmentFlag
    36, 33, 0,	//182  QDataStream&, QColor&
    36, 251, 0,	//185  QDataStream&, const QRegExp&
    134, 273, 0,	//188  QUrl::FormattingOption, int
    221, 269, 0,	//191  const QByteArray&, const char*
    21, 21, 0,	//194  KUrl::DirectoryOption, KUrl::DirectoryOption
    161, 57, 0,	//197  Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>
    233, 236, 0,	//200  const QLine&, const QMatrix&
    21, 47, 0,	//203  KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>
    234, 236, 0,	//206  const QLineF&, const QMatrix&
    187, 187, 0,	//209  Qt::Orientation, Qt::Orientation
    240, 236, 0,	//212  const QPainterPath&, const QMatrix&
    202, 273, 0,	//215  Qt::ToolBarArea, int
    36, 103, 0,	//218  QDataStream&, QPointF&
    36, 231, 0,	//221  QDataStream&, const QKeySequence&
    183, 273, 0,	//224  Qt::MatchFlag, int
    259, 269, 0,	//227  const QString&, const char*
    36, 224, 0,	//230  QDataStream&, const QCursor&
    168, 168, 0,	//233  Qt::GestureFlag, Qt::GestureFlag
    36, 38, 0,	//236  QDataStream&, QDate&
    75, 75, 0,	//239  QIODevice::OpenModeFlag, QIODevice::OpenModeFlag
    215, 221, 0,	//242  char, const QByteArray&
    269, 259, 0,	//245  const char*, const QString&
    269, 221, 0,	//248  const char*, const QByteArray&
    36, 28, 0,	//251  QDataStream&, QByteArray&
    36, 136, 0,	//254  QDataStream&, QVariant&
    36, 110, 0,	//257  QDataStream&, QRegExp&
    246, 246, 0,	//260  const QPointF&, const QPointF&
    264, 271, 0,	//263  const QTransform&, double
    262, 262, 0,	//266  const QStringRef&, const QStringRef&
    29, 29, 0,	//269  QChar, QChar
    240, 264, 0,	//272  const QPainterPath&, const QTransform&
    36, 219, 0,	//275  QDataStream&, const QBrush&
    36, 112, 0,	//278  QDataStream&, QRegion&
    246, 271, 0,	//281  const QPointF&, double
    22, 273, 0,	//284  KUrl::EncodedPathAndQueryOption, int
    36, 225, 0,	//287  QDataStream&, const QDate&
    183, 64, 0,	//290  Qt::MatchFlag, QFlags<Qt::MatchFlag>
    168, 273, 0,	//293  Qt::GestureFlag, int
    119, 119, 0,	//296  QSizePolicy::ControlType, QSizePolicy::ControlType
    36, 35, 0,	//299  QDataStream&, QCursor&
    180, 63, 0,	//302  Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>
    183, 183, 0,	//305  Qt::MatchFlag, Qt::MatchFlag
    36, 132, 0,	//308  QDataStream&, QTransform&
    247, 236, 0,	//311  const QPolygon&, const QMatrix&
    259, 122, 0,	//314  const QString&, QString::Null
    36, 117, 0,	//317  QDataStream&, QSizeF&
    246, 0,	//320  const QPointF&
    177, 177, 0,	//322  Qt::ItemFlag, Qt::ItemFlag
    36, 242, 0,	//325  QDataStream&, const QPixmap&
    221, 259, 0,	//328  const QByteArray&, const QString&
    212, 71, 0,	//331  Qt::WindowType, QFlags<Qt::WindowType>
    246, 264, 0,	//334  const QPointF&, const QTransform&
    177, 62, 0,	//337  Qt::ItemFlag, QFlags<Qt::ItemFlag>
    205, 69, 0,	//340  Qt::TouchPointState, QFlags<Qt::TouchPointState>
    259, 215, 0,	//343  const QString&, char
    36, 265, 0,	//346  QDataStream&, const QUrl&
    119, 52, 0,	//349  QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>
    36, 266, 0,	//352  QDataStream&, const QVariant&
    36, 83, 0,	//355  QDataStream&, QLine&
    180, 180, 0,	//358  Qt::KeyboardModifier, Qt::KeyboardModifier
    141, 273, 0,	//361  Qt::AlignmentFlag, int
    244, 236, 0,	//364  const QPoint&, const QMatrix&
    180, 273, 0,	//367  Qt::KeyboardModifier, int
    177, 273, 0,	//370  Qt::ItemFlag, int
    172, 60, 0,	//373  Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>
    244, 244, 0,	//376  const QPoint&, const QPoint&
    123, 273, 0,	//379  QString::SectionFlag, int
    212, 273, 0,	//382  Qt::WindowType, int
    140, 140, 0,	//385  QWidget::RenderFlag, QWidget::RenderFlag
    262, 259, 0,	//388  const QStringRef&, const QString&
    232, 232, 0,	//391  const QLatin1String&, const QLatin1String&
    228, 228, 0,	//394  const QHashDummyValue&, const QHashDummyValue&
    23, 23, 0,	//397  KUrl::EqualsOption, KUrl::EqualsOption
    134, 134, 0,	//400  QUrl::FormattingOption, QUrl::FormattingOption
    36, 76, 0,	//403  QDataStream&, QIcon&
    36, 247, 0,	//406  QDataStream&, const QPolygon&
    205, 273, 0,	//409  Qt::TouchPointState, int
    140, 55, 0,	//412  QWidget::RenderFlag, QFlags<QWidget::RenderFlag>
    262, 269, 0,	//415  const QStringRef&, const char*
    20, 273, 0,	//418  KUrl::CleanPathOption, int
    24, 24, 0,	//421  KUrl::QueryItemsOption, KUrl::QueryItemsOption
    36, 234, 0,	//424  QDataStream&, const QLineF&
    36, 27, 0,	//427  QDataStream&, QBrush&
    36, 246, 0,	//430  QDataStream&, const QPointF&
    244, 272, 0,	//433  const QPoint&, float
    259, 262, 0,	//436  const QString&, const QStringRef&
    23, 273, 0,	//439  KUrl::EqualsOption, int
    119, 273, 0,	//442  QSizePolicy::ControlType, int
    36, 118, 0,	//445  QDataStream&, QSizePolicy&
    269, 262, 0,	//448  const char*, const QStringRef&
    36, 88, 0,	//451  QDataStream&, QMatrix&
    185, 273, 0,	//454  Qt::MouseButton, int
    36, 116, 0,	//457  QDataStream&, QSize&
    174, 174, 0,	//460  Qt::InputMethodHint, Qt::InputMethodHint
    36, 137, 0,	//463  QDataStream&, QVariant::Type&
    199, 67, 0,	//466  Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>
    234, 264, 0,	//469  const QLineF&, const QTransform&
    262, 232, 0,	//472  const QStringRef&, const QLatin1String&
    36, 248, 0,	//475  QDataStream&, const QPolygonF&
    36, 256, 0,	//478  QDataStream&, const QSizeF&
    202, 68, 0,	//481  Qt::ToolBarArea, QFlags<Qt::ToolBarArea>
    36, 227, 0,	//484  QDataStream&, const QFont&
    23, 49, 0,	//487  KUrl::EqualsOption, QFlags<KUrl::EqualsOption>
    36, 236, 0,	//490  QDataStream&, const QMatrix&
    215, 259, 0,	//493  char, const QString&
    211, 211, 0,	//496  Qt::WindowState, Qt::WindowState
    134, 54, 0,	//499  QUrl::FormattingOption, QFlags<QUrl::FormattingOption>
    36, 107, 0,	//502  QDataStream&, QPolygonF&
    36, 98, 0,	//505  QDataStream&, QPalette&
    36, 240, 0,	//508  QDataStream&, const QPainterPath&
    250, 250, 0,	//511  const QRectF&, const QRectF&
    271, 254, 0,	//514  double, const QSize&
    271, 244, 0,	//517  double, const QPoint&
    36, 244, 0,	//520  QDataStream&, const QPoint&
    36, 230, 0,	//523  QDataStream&, const QImage&
    221, 215, 0,	//526  const QByteArray&, char
    36, 73, 0,	//529  QDataStream&, QFont&
    123, 53, 0,	//532  QString::SectionFlag, QFlags<QString::SectionFlag>
    36, 254, 0,	//535  QDataStream&, const QSize&
    36, 109, 0,	//538  QDataStream&, QRectF&
    36, 222, 0,	//541  QDataStream&, const QChar&
    214, 26, 0,	//544  bool, QBool
    24, 50, 0,	//547  KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>
    247, 264, 0,	//550  const QPolygon&, const QTransform&
    26, 214, 0,	//553  QBool, bool
    211, 273, 0,	//556  Qt::WindowState, int
    36, 125, 0,	//559  QDataStream&, QStringList&
    36, 249, 0,	//562  QDataStream&, const QRect&
    21, 273, 0,	//565  KUrl::DirectoryOption, int
    36, 252, 0,	//568  QDataStream&, const QRegion&
    161, 161, 0,	//571  Qt::DockWidgetArea, Qt::DockWidgetArea
    36, 223, 0,	//574  QDataStream&, const QColor&
    212, 212, 0,	//577  Qt::WindowType, Qt::WindowType
    254, 271, 0,	//580  const QSize&, double
    122, 259, 0,	//583  QString::Null, const QString&
    174, 61, 0,	//586  Qt::InputMethodHint, QFlags<Qt::InputMethodHint>
    36, 101, 0,	//589  QDataStream&, QPoint&
    36, 39, 0,	//592  QDataStream&, QDateTime&
    36, 263, 0,	//595  QDataStream&, const QTime&
    36, 81, 0,	//598  QDataStream&, QKeySequence&
    252, 264, 0,	//601  const QRegion&, const QTransform&
    123, 123, 0,	//604  QString::SectionFlag, QString::SectionFlag
    75, 273, 0,	//607  QIODevice::OpenModeFlag, int
    273, 244, 0,	//610  int, const QPoint&
    168, 59, 0,	//613  Qt::GestureFlag, QFlags<Qt::GestureFlag>
    248, 236, 0,	//616  const QPolygonF&, const QMatrix&
    36, 105, 0,	//619  QDataStream&, QPolygon&
    22, 48, 0,	//622  KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>
    36, 121, 0,	//625  QDataStream&, QString&
    36, 259, 0,	//628  QDataStream&, const QString&
    36, 30, 0,	//631  QDataStream&, QChar&
    199, 199, 0,	//634  Qt::TextInteractionFlag, Qt::TextInteractionFlag
    36, 99, 0,	//637  QDataStream&, QPixmap&
    259, 221, 0,	//640  const QString&, const QByteArray&
    36, 108, 0,	//643  QDataStream&, QRect&
    172, 273, 0,	//646  Qt::ImageConversionFlag, int
    36, 229, 0,	//649  QDataStream&, const QIcon&
    36, 267, 0,	//652  QDataStream&, const QVariant::Type
    36, 85, 0,	//655  QDataStream&, QLineF&
    36, 97, 0,	//658  QDataStream&, QPainterPath&
    205, 205, 0,	//661  Qt::TouchPointState, Qt::TouchPointState
    199, 273, 0,	//664  Qt::TextInteractionFlag, int
    244, 264, 0,	//667  const QPoint&, const QTransform&
    36, 226, 0,	//670  QDataStream&, const QDateTime&
    36, 129, 0,	//673  QDataStream&, QTime&
    244, 273, 0,	//676  const QPoint&, int
    172, 172, 0,	//679  Qt::ImageConversionFlag, Qt::ImageConversionFlag
    163, 58, 0,	//682  Qt::DropAction, QFlags<Qt::DropAction>
    163, 163, 0,	//685  Qt::DropAction, Qt::DropAction
    187, 273, 0,	//688  Qt::Orientation, int
    252, 236, 0,	//691  const QRegion&, const QMatrix&
    272, 244, 0,	//694  float, const QPoint&
    36, 133, 0,	//697  QDataStream&, QUrl&
    259, 29, 0,	//700  const QString&, QChar
    187, 66, 0,	//703  Qt::Orientation, QFlags<Qt::Orientation>
    5, 273, 0,	//706  KIconLoader::Group&, int
    92, 45, 0,	//709  QObject*, QEvent*
    31, 0,	//712  QChildEvent*
    72, 0,	//714  QFocusEvent*
    214, 0,	//716  bool
    138, 0,	//718  QWheelEvent*
    91, 0,	//720  QMoveEvent*
    113, 0,	//722  QResizeEvent*
    32, 0,	//724  QCloseEvent*
    34, 0,	//726  QContextMenuEvent*
    128, 0,	//728  QTabletEvent*
    25, 0,	//730  QActionEvent*
    41, 0,	//732  QDragEnterEvent*
    43, 0,	//734  QDragMoveEvent*
    42, 0,	//736  QDragLeaveEvent*
    44, 0,	//738  QDropEvent*
    114, 0,	//740  QShowEvent*
    74, 0,	//742  QHideEvent*
    213, 0,	//744  _XEvent*
    93, 0,	//746  QPaintDevice::PaintDeviceMetric
    79, 0,	//748  QInputMethodEvent*
    175, 0,	//750  Qt::InputMethodQuery
    127, 0,	//752  QStyle&
    241, 0,	//754  const QPalette&
    227, 0,	//756  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "Author",	//1
    "Author#",	//2
    "Button",	//3
    "Button#",	//4
    "Button$$$#",	//5
    "Cache",	//6
    "Deleted",	//7
    "Downloadable",	//8
    "DrawChildren",	//9
    "DrawWindowBackground",	//10
    "Engine",	//11
    "Engine#",	//12
    "Entry",	//13
    "Entry#",	//14
    "IgnoreMask",	//15
    "Installed",	//16
    "Invalid",	//17
    "KTranslatable",	//18
    "KTranslatable#",	//19
    "KTranslatable$",	//20
    "Online",	//21
    "Registry",	//22
    "Updateable",	//23
    "aboutToShowDialog",	//24
    "actionEvent",	//25
    "addString",	//26
    "addString$$",	//27
    "author",	//28
    "category",	//29
    "changeEvent",	//30
    "checkStateSet",	//31
    "checksum",	//32
    "childEvent",	//33
    "closeEvent",	//34
    "connectNotify",	//35
    "contextMenuEvent",	//36
    "customEvent",	//37
    "devType",	//38
    "dialogFinished",	//39
    "disconnectNotify",	//40
    "download",	//41
    "downloadDialog",	//42
    "downloadDialog#$",	//43
    "downloadDialogModal",	//44
    "downloadDialogModal#",	//45
    "downloads",	//46
    "dragEnterEvent",	//47
    "dragLeaveEvent",	//48
    "dragMoveEvent",	//49
    "dragObject",	//50
    "dropEvent",	//51
    "email",	//52
    "enabledChange",	//53
    "enterEvent",	//54
    "event",	//55
    "eventFilter",	//56
    "focusInEvent",	//57
    "focusNextPrevChild",	//58
    "focusOutEvent",	//59
    "fontChange",	//60
    "heightForWidth",	//61
    "hideEvent",	//62
    "hitButton",	//63
    "homepage",	//64
    "idNumber",	//65
    "init",	//66
    "init$",	//67
    "inputMethodEvent",	//68
    "inputMethodQuery",	//69
    "installedFiles",	//70
    "isEmpty",	//71
    "isTranslated",	//72
    "jabber",	//73
    "keyPressEvent",	//74
    "keyReleaseEvent",	//75
    "language",	//76
    "languageChange",	//77
    "languages",	//78
    "leaveEvent",	//79
    "license",	//80
    "metaObject",	//81
    "metric",	//82
    "minimumSizeHint",	//83
    "mouseDoubleClickEvent",	//84
    "mouseMoveEvent",	//85
    "mousePressEvent",	//86
    "mouseReleaseEvent",	//87
    "moveEvent",	//88
    "name",	//89
    "nextCheckState",	//90
    "operator!=",	//91
    "operator!=##",	//92
    "operator!=#$",	//93
    "operator!=$#",	//94
    "operator!=$$",	//95
    "operator*",	//96
    "operator*##",	//97
    "operator*#$",	//98
    "operator*$#",	//99
    "operator+",	//100
    "operator+##",	//101
    "operator+#$",	//102
    "operator+$#",	//103
    "operator+$$",	//104
    "operator++",	//105
    "operator++$",	//106
    "operator++$$",	//107
    "operator-",	//108
    "operator-#",	//109
    "operator-##",	//110
    "operator-#$",	//111
    "operator/",	//112
    "operator/#$",	//113
    "operator<",	//114
    "operator<##",	//115
    "operator<#$",	//116
    "operator<$#",	//117
    "operator<$$",	//118
    "operator<<",	//119
    "operator<<##",	//120
    "operator<<#$",	//121
    "operator<<#?",	//122
    "operator<=",	//123
    "operator<=##",	//124
    "operator<=#$",	//125
    "operator<=$#",	//126
    "operator<=$$",	//127
    "operator=",	//128
    "operator=#",	//129
    "operator==",	//130
    "operator==##",	//131
    "operator==#$",	//132
    "operator==$#",	//133
    "operator==$$",	//134
    "operator>",	//135
    "operator>##",	//136
    "operator>#$",	//137
    "operator>$#",	//138
    "operator>$$",	//139
    "operator>=",	//140
    "operator>=##",	//141
    "operator>=#$",	//142
    "operator>=$#",	//143
    "operator>=$$",	//144
    "operator>>",	//145
    "operator>>##",	//146
    "operator>>#$",	//147
    "operator>>#?",	//148
    "operator|",	//149
    "operator|$$",	//150
    "paintEngine",	//151
    "paintEvent",	//152
    "paletteChange",	//153
    "payload",	//154
    "preview",	//155
    "qt_metacall",	//156
    "qt_metacall$$?",	//157
    "qt_metacast",	//158
    "qt_metacast$",	//159
    "rating",	//160
    "release",	//161
    "releaseDate",	//162
    "representation",	//163
    "resizeEvent",	//164
    "setAuthor",	//165
    "setAuthor#",	//166
    "setButtonText",	//167
    "setButtonText$",	//168
    "setCategory",	//169
    "setCategory$",	//170
    "setChecksum",	//171
    "setChecksum$",	//172
    "setDownloads",	//173
    "setDownloads$",	//174
    "setEmail",	//175
    "setEmail$",	//176
    "setHomepage",	//177
    "setHomepage$",	//178
    "setIdNumber",	//179
    "setIdNumber$",	//180
    "setInstalledFiles",	//181
    "setInstalledFiles?",	//182
    "setJabber",	//183
    "setJabber$",	//184
    "setLicense",	//185
    "setLicense$",	//186
    "setName",	//187
    "setName#",	//188
    "setName$",	//189
    "setPayload",	//190
    "setPayload#",	//191
    "setPreview",	//192
    "setPreview#",	//193
    "setProviderList",	//194
    "setProviderList$",	//195
    "setRating",	//196
    "setRating$",	//197
    "setRelease",	//198
    "setRelease$",	//199
    "setReleaseDate",	//200
    "setReleaseDate#",	//201
    "setResourceType",	//202
    "setResourceType$",	//203
    "setSignature",	//204
    "setSignature$",	//205
    "setSource",	//206
    "setSource$",	//207
    "setStatus",	//208
    "setStatus$",	//209
    "setSummary",	//210
    "setSummary#",	//211
    "setUnInstalledFiles",	//212
    "setUnInstalledFiles?",	//213
    "setVersion",	//214
    "setVersion$",	//215
    "setVisible",	//216
    "showDialog",	//217
    "showEvent",	//218
    "signature",	//219
    "sizeHint",	//220
    "source",	//221
    "startDrag",	//222
    "staticMetaObject",	//223
    "status",	//224
    "stringmap",	//225
    "strings",	//226
    "styleChange",	//227
    "summary",	//228
    "tabletEvent",	//229
    "timerEvent",	//230
    "tr",	//231
    "tr$",	//232
    "tr$$",	//233
    "tr$$$",	//234
    "trUtf8",	//235
    "trUtf8$",	//236
    "trUtf8$$",	//237
    "trUtf8$$$",	//238
    "translated",	//239
    "translated$",	//240
    "uninstalledFiles",	//241
    "upload",	//242
    "upload$",	//243
    "uploadDialog",	//244
    "uploadDialog$",	//245
    "uploadDialogModal",	//246
    "uploadDialogModal$",	//247
    "version",	//248
    "wheelEvent",	//249
    "windowActivationChange",	//250
    "x11Event",	//251
    "~Author",	//252
    "~Button",	//253
    "~Engine",	//254
    "~Entry",	//255
    "~KTranslatable",	//256
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {3, 1, 0, 0, Smoke::mf_ctor, 8, 1},	//1 KNS::Author::Author()
    {3, 1, 1, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 8, 2},	//2 KNS::Author::Author(const KNS::Author&)
    {3, 128, 1, 1, 0, 7, 3},	//3 KNS::Author::operator=(const KNS::Author&)
    {3, 187, 3, 1, 0, 0, 4},	//4 KNS::Author::setName(const QString&)
    {3, 89, 0, 0, Smoke::mf_const, 120, 5},	//5 KNS::Author::name() const
    {3, 175, 3, 1, 0, 0, 6},	//6 KNS::Author::setEmail(const QString&)
    {3, 52, 0, 0, Smoke::mf_const, 120, 7},	//7 KNS::Author::email() const
    {3, 183, 3, 1, 0, 0, 8},	//8 KNS::Author::setJabber(const QString&)
    {3, 73, 0, 0, Smoke::mf_const, 120, 9},	//9 KNS::Author::jabber() const
    {3, 177, 3, 1, 0, 0, 10},	//10 KNS::Author::setHomepage(const QString&)
    {3, 64, 0, 0, Smoke::mf_const, 120, 11},	//11 KNS::Author::homepage() const
    {3, 252, 0, 0, Smoke::mf_dtor, 0, 12 },	//12 KNS::Author::~Author()
    {4, 81, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 238, 1},	//13 KNS::Button::metaObject() const
    {4, 158, 5, 1, Smoke::mf_virtual, 274, 2},	//14 KNS::Button::qt_metacast(const char*)
    {4, 231, 7, 2, Smoke::mf_static, 120, 3},	//15 KNS::Button::tr(const char*, const char*)
    {4, 235, 7, 2, Smoke::mf_static, 120, 4},	//16 KNS::Button::trUtf8(const char*, const char*)
    {4, 231, 10, 3, Smoke::mf_static, 120, 5},	//17 KNS::Button::tr(const char*, const char*, int)
    {4, 235, 10, 3, Smoke::mf_static, 120, 6},	//18 KNS::Button::trUtf8(const char*, const char*, int)
    {4, 156, 14, 3, Smoke::mf_virtual, 273, 7},	//19 KNS::Button::qt_metacall(QMetaObject::Call, int, void**)
    {4, 3, 18, 4, Smoke::mf_ctor, 9, 8},	//20 KNS::Button::Button(const QString&, const QString&, const QString&, QWidget*)
    {4, 3, 23, 1, Smoke::mf_ctor, 9, 9},	//21 KNS::Button::Button(QWidget*)
    {4, 194, 3, 1, 0, 0, 10},	//22 KNS::Button::setProviderList(const QString&)
    {4, 202, 3, 1, 0, 0, 11},	//23 KNS::Button::setResourceType(const QString&)
    {4, 167, 3, 1, 0, 0, 12},	//24 KNS::Button::setButtonText(const QString&)
    {4, 24, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//25 KNS::Button::aboutToShowDialog()
    {4, 39, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//26 KNS::Button::dialogFinished()
    {4, 217, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 15},	//27 KNS::Button::showDialog()
    {4, 231, 5, 1, Smoke::mf_static, 120, 16},	//28 KNS::Button::tr(const char*)
    {4, 235, 5, 1, Smoke::mf_static, 120, 17},	//29 KNS::Button::trUtf8(const char*)
    {4, 223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 237, 18},	//30 KNS::Button::staticMetaObject() const
    {4, 253, 0, 0, Smoke::mf_dtor, 0, 19 },	//31 KNS::Button::~Button()
    {5, 11, 23, 1, Smoke::mf_ctor, 10, 1},	//32 KNS::Engine::Engine(QWidget*)
    {5, 44, 23, 1, 0, 86, 2},	//33 KNS::Engine::downloadDialogModal(QWidget*)
    {5, 41, 0, 0, Smoke::mf_static, 86, 3},	//34 KNS::Engine::download()
    {5, 246, 3, 1, 0, 12, 4},	//35 KNS::Engine::uploadDialogModal(const QString&)
    {5, 242, 3, 1, Smoke::mf_static, 12, 5},	//36 KNS::Engine::upload(const QString&)
    {5, 42, 0, 0, 0, 0, 6},	//37 KNS::Engine::downloadDialog()
    {5, 42, 25, 2, 0, 0, 7},	//38 KNS::Engine::downloadDialog(QObject*, const char*)
    {5, 244, 3, 1, 0, 0, 8},	//39 KNS::Engine::uploadDialog(const QString&)
    {5, 66, 3, 1, 0, 214, 9},	//40 KNS::Engine::init(const QString&)
    {5, 11, 0, 0, Smoke::mf_ctor, 10, 10},	//41 KNS::Engine::Engine()
    {5, 44, 0, 0, 0, 86, 11},	//42 KNS::Engine::downloadDialogModal()
    {5, 254, 0, 0, Smoke::mf_dtor, 0, 12 },	//43 KNS::Engine::~Engine()
    {6, 13, 0, 0, Smoke::mf_ctor, 12, 1},	//44 KNS::Entry::Entry()
    {6, 13, 28, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 12, 2},	//45 KNS::Entry::Entry(const KNS::Entry&)
    {6, 128, 28, 1, 0, 11, 3},	//46 KNS::Entry::operator=(const KNS::Entry&)
    {6, 187, 30, 1, 0, 0, 4},	//47 KNS::Entry::setName(const KNS::KTranslatable&)
    {6, 89, 0, 0, Smoke::mf_const, 15, 5},	//48 KNS::Entry::name() const
    {6, 169, 3, 1, 0, 0, 6},	//49 KNS::Entry::setCategory(const QString&)
    {6, 29, 0, 0, Smoke::mf_const, 120, 7},	//50 KNS::Entry::category() const
    {6, 165, 1, 1, 0, 0, 8},	//51 KNS::Entry::setAuthor(const KNS::Author&)
    {6, 28, 0, 0, Smoke::mf_const, 6, 9},	//52 KNS::Entry::author() const
    {6, 185, 3, 1, 0, 0, 10},	//53 KNS::Entry::setLicense(const QString&)
    {6, 80, 0, 0, Smoke::mf_const, 120, 11},	//54 KNS::Entry::license() const
    {6, 210, 30, 1, 0, 0, 12},	//55 KNS::Entry::setSummary(const KNS::KTranslatable&)
    {6, 228, 0, 0, Smoke::mf_const, 15, 13},	//56 KNS::Entry::summary() const
    {6, 214, 3, 1, 0, 0, 14},	//57 KNS::Entry::setVersion(const QString&)
    {6, 248, 0, 0, Smoke::mf_const, 120, 15},	//58 KNS::Entry::version() const
    {6, 198, 32, 1, 0, 0, 16},	//59 KNS::Entry::setRelease(int)
    {6, 161, 0, 0, Smoke::mf_const, 273, 17},	//60 KNS::Entry::release() const
    {6, 200, 34, 1, 0, 0, 18},	//61 KNS::Entry::setReleaseDate(const QDate&)
    {6, 162, 0, 0, Smoke::mf_const, 37, 19},	//62 KNS::Entry::releaseDate() const
    {6, 190, 30, 1, 0, 0, 20},	//63 KNS::Entry::setPayload(const KNS::KTranslatable&)
    {6, 154, 0, 0, Smoke::mf_const, 15, 21},	//64 KNS::Entry::payload() const
    {6, 192, 30, 1, 0, 0, 22},	//65 KNS::Entry::setPreview(const KNS::KTranslatable&)
    {6, 155, 0, 0, Smoke::mf_const, 15, 23},	//66 KNS::Entry::preview() const
    {6, 181, 36, 1, 0, 0, 24},	//67 KNS::Entry::setInstalledFiles(const QStringList&)
    {6, 212, 36, 1, 0, 0, 25},	//68 KNS::Entry::setUnInstalledFiles(const QStringList&)
    {6, 70, 0, 0, Smoke::mf_const, 124, 26},	//69 KNS::Entry::installedFiles() const
    {6, 241, 0, 0, Smoke::mf_const, 124, 27},	//70 KNS::Entry::uninstalledFiles() const
    {6, 196, 32, 1, 0, 0, 28},	//71 KNS::Entry::setRating(int)
    {6, 160, 0, 0, Smoke::mf_const, 273, 29},	//72 KNS::Entry::rating() const
    {6, 173, 32, 1, 0, 0, 30},	//73 KNS::Entry::setDownloads(int)
    {6, 46, 0, 0, Smoke::mf_const, 273, 31},	//74 KNS::Entry::downloads() const
    {6, 171, 3, 1, 0, 0, 32},	//75 KNS::Entry::setChecksum(const QString&)
    {6, 204, 3, 1, 0, 0, 33},	//76 KNS::Entry::setSignature(const QString&)
    {6, 32, 0, 0, Smoke::mf_const, 120, 34},	//77 KNS::Entry::checksum() const
    {6, 219, 0, 0, Smoke::mf_const, 120, 35},	//78 KNS::Entry::signature() const
    {6, 208, 38, 1, 0, 0, 36},	//79 KNS::Entry::setStatus(KNS::Entry::Status)
    {6, 224, 0, 0, 0, 14, 37},	//80 KNS::Entry::status()
    {6, 206, 40, 1, 0, 0, 38},	//81 KNS::Entry::setSource(KNS::Entry::Source)
    {6, 221, 0, 0, 0, 13, 39},	//82 KNS::Entry::source()
    {6, 179, 32, 1, 0, 0, 40},	//83 KNS::Entry::setIdNumber(int)
    {6, 65, 0, 0, Smoke::mf_const, 273, 41},	//84 KNS::Entry::idNumber() const
    {6, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 42},	//85 KNS::Entry::Invalid (enum)
    {6, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 43},	//86 KNS::Entry::Downloadable (enum)
    {6, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 44},	//87 KNS::Entry::Installed (enum)
    {6, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 45},	//88 KNS::Entry::Updateable (enum)
    {6, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 46},	//89 KNS::Entry::Deleted (enum)
    {6, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 47},	//90 KNS::Entry::Cache (enum)
    {6, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 48},	//91 KNS::Entry::Online (enum)
    {6, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 49},	//92 KNS::Entry::Registry (enum)
    {6, 255, 0, 0, Smoke::mf_dtor, 0, 50 },	//93 KNS::Entry::~Entry()
    {7, 18, 0, 0, Smoke::mf_ctor, 17, 1},	//94 KNS::KTranslatable::KTranslatable()
    {7, 18, 3, 1, Smoke::mf_ctor, 17, 2},	//95 KNS::KTranslatable::KTranslatable(const QString&)
    {7, 128, 30, 1, 0, 16, 3},	//96 KNS::KTranslatable::operator=(const KNS::KTranslatable&)
    {7, 18, 30, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 17, 4},	//97 KNS::KTranslatable::KTranslatable(const KNS::KTranslatable&)
    {7, 26, 42, 2, 0, 0, 5},	//98 KNS::KTranslatable::addString(const QString&, const QString&)
    {7, 163, 0, 0, Smoke::mf_const, 120, 6},	//99 KNS::KTranslatable::representation() const
    {7, 239, 3, 1, Smoke::mf_const, 120, 7},	//100 KNS::KTranslatable::translated(const QString&) const
    {7, 226, 0, 0, Smoke::mf_const, 124, 8},	//101 KNS::KTranslatable::strings() const
    {7, 78, 0, 0, Smoke::mf_const, 124, 9},	//102 KNS::KTranslatable::languages() const
    {7, 76, 0, 0, Smoke::mf_const, 120, 10},	//103 KNS::KTranslatable::language() const
    {7, 225, 0, 0, Smoke::mf_const, 87, 11},	//104 KNS::KTranslatable::stringmap() const
    {7, 72, 0, 0, Smoke::mf_const, 214, 12},	//105 KNS::KTranslatable::isTranslated() const
    {7, 71, 0, 0, Smoke::mf_const, 214, 13},	//106 KNS::KTranslatable::isEmpty() const
    {7, 256, 0, 0, Smoke::mf_dtor, 0, 14 },	//107 KNS::KTranslatable::~KTranslatable()
    {8, 220, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 115, 0},	//108 KPushButton::sizeHint() const
    {8, 50, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 40, 0},	//109 KPushButton::dragObject()
    {8, 86, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//110 KPushButton::mousePressEvent(QMouseEvent*)
    {8, 85, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//111 KPushButton::mouseMoveEvent(QMouseEvent*)
    {8, 152, 47, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//112 KPushButton::paintEvent(QPaintEvent*)
    {8, 222, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//113 KPushButton::startDrag()
    {9, 63, 49, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//114 QAbstractButton::hitButton(const QPoint&) const
    {9, 31, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//115 QAbstractButton::checkStateSet()
    {9, 90, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//116 QAbstractButton::nextCheckState()
    {9, 75, 51, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//117 QAbstractButton::keyReleaseEvent(QKeyEvent*)
    {9, 87, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//118 QAbstractButton::mouseReleaseEvent(QMouseEvent*)
    {9, 30, 53, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//119 QAbstractButton::changeEvent(QEvent*)
    {9, 230, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//120 QAbstractButton::timerEvent(QTimerEvent*)
    {31, 149, 57, 2, Smoke::mf_static, 78, 1},	//121 QGlobalSpace::operator|(Qt::DockWidgetArea, int)
    {31, 96, 60, 2, Smoke::mf_static, 243, 2},	//122 QGlobalSpace::operator*(const QPoint&, double)
    {31, 96, 63, 2, Smoke::mf_static, 245, 3},	//123 QGlobalSpace::operator*(double, const QPointF&)
    {31, 149, 66, 2, Smoke::mf_static, 65, 4},	//124 QGlobalSpace::operator|(Qt::MouseButton, QFlags<Qt::MouseButton>)
    {31, 91, 69, 2, Smoke::mf_static, 214, 5},	//125 QGlobalSpace::operator!=(const QMargins&, const QMargins&)
    {31, 96, 72, 2, Smoke::mf_static, 255, 6},	//126 QGlobalSpace::operator*(double, const QSizeF&)
    {31, 145, 75, 2, Smoke::mf_static, 36, 7},	//127 QGlobalSpace::operator>>(QDataStream&, QImage&)
    {31, 119, 78, 2, Smoke::mf_static, 36, 8},	//128 QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    {31, 149, 81, 2, Smoke::mf_static, 78, 9},	//129 QGlobalSpace::operator|(Qt::InputMethodHint, int)
    {31, 91, 84, 2, Smoke::mf_static, 214, 10},	//130 QGlobalSpace::operator!=(const QRect&, const QRect&)
    {31, 100, 87, 2, Smoke::mf_static, 253, 11},	//131 QGlobalSpace::operator+(const QSize&, const QSize&)
    {31, 119, 90, 2, Smoke::mf_static, 36, 12},	//132 QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    {31, 96, 93, 2, Smoke::mf_static, 102, 13},	//133 QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    {31, 96, 96, 2, Smoke::mf_static, 82, 14},	//134 QGlobalSpace::operator*(const QLine&, const QTransform&)
    {31, 130, 69, 2, Smoke::mf_static, 214, 15},	//135 QGlobalSpace::operator==(const QMargins&, const QMargins&)
    {31, 149, 99, 2, Smoke::mf_static, 70, 16},	//136 QGlobalSpace::operator|(Qt::WindowState, QFlags<Qt::WindowState>)
    {31, 96, 102, 2, Smoke::mf_static, 255, 17},	//137 QGlobalSpace::operator*(const QSizeF&, double)
    {31, 119, 105, 2, Smoke::mf_static, 36, 18},	//138 QGlobalSpace::operator<<(QDataStream&, const QLine&)
    {31, 135, 108, 2, Smoke::mf_static, 214, 19},	//139 QGlobalSpace::operator>(const char*, const QLatin1String&)
    {31, 108, 111, 2, Smoke::mf_static, 255, 20},	//140 QGlobalSpace::operator-(const QSizeF&, const QSizeF&)
    {31, 140, 114, 2, Smoke::mf_static, 214, 21},	//141 QGlobalSpace::operator>=(const QByteArray&, const QByteArray&)
    {31, 130, 117, 2, Smoke::mf_static, 214, 22},	//142 QGlobalSpace::operator==(const QLatin1String&, const QStringRef&)
    {31, 149, 120, 2, Smoke::mf_static, 65, 23},	//143 QGlobalSpace::operator|(Qt::MouseButton, Qt::MouseButton)
    {31, 149, 123, 2, Smoke::mf_static, 46, 24},	//144 QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    {31, 149, 126, 2, Smoke::mf_static, 46, 25},	//145 QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    {31, 91, 129, 2, Smoke::mf_static, 214, 26},	//146 QGlobalSpace::operator!=(const QVariant&, const QVariantComparisonHelper&)
    {31, 130, 132, 2, Smoke::mf_static, 214, 27},	//147 QGlobalSpace::operator==(QBool, QBool)
    {31, 149, 135, 2, Smoke::mf_static, 56, 28},	//148 QGlobalSpace::operator|(Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>)
    {31, 130, 138, 2, Smoke::mf_static, 214, 29},	//149 QGlobalSpace::operator==(QString::Null, QString::Null)
    {31, 119, 141, 2, Smoke::mf_static, 36, 30},	//150 QGlobalSpace::operator<<(QDataStream&, const QRectF&)
    {31, 100, 144, 2, Smoke::mf_static, 258, 31},	//151 QGlobalSpace::operator+(QChar, const QString&)
    {31, 149, 147, 2, Smoke::mf_static, 51, 32},	//152 QGlobalSpace::operator|(QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>)
    {31, 119, 150, 2, Smoke::mf_static, 36, 33},	//153 QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    {31, 105, 153, 1, Smoke::mf_static, 5, 34},	//154 QGlobalSpace::operator++(KIconLoader::Group&)
    {31, 119, 155, 2, Smoke::mf_static, 36, 35},	//155 QGlobalSpace::operator<<(QDataStream&, const QByteArray&)
    {31, 96, 158, 2, Smoke::mf_static, 106, 36},	//156 QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    {31, 149, 161, 2, Smoke::mf_static, 68, 37},	//157 QGlobalSpace::operator|(Qt::ToolBarArea, Qt::ToolBarArea)
    {31, 149, 164, 2, Smoke::mf_static, 78, 38},	//158 QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    {31, 100, 111, 2, Smoke::mf_static, 255, 39},	//159 QGlobalSpace::operator+(const QSizeF&, const QSizeF&)
    {31, 149, 167, 2, Smoke::mf_static, 78, 40},	//160 QGlobalSpace::operator|(QWidget::RenderFlag, int)
    {31, 149, 170, 2, Smoke::mf_static, 78, 41},	//161 QGlobalSpace::operator|(Qt::DropAction, int)
    {31, 119, 173, 2, Smoke::mf_static, 36, 42},	//162 QGlobalSpace::operator<<(QDataStream&, const QStringList&)
    {31, 149, 176, 2, Smoke::mf_static, 48, 43},	//163 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    {31, 149, 179, 2, Smoke::mf_static, 56, 44},	//164 QGlobalSpace::operator|(Qt::AlignmentFlag, Qt::AlignmentFlag)
    {31, 145, 182, 2, Smoke::mf_static, 36, 45},	//165 QGlobalSpace::operator>>(QDataStream&, QColor&)
    {31, 119, 185, 2, Smoke::mf_static, 36, 46},	//166 QGlobalSpace::operator<<(QDataStream&, const QRegExp&)
    {31, 149, 188, 2, Smoke::mf_static, 78, 47},	//167 QGlobalSpace::operator|(QUrl::FormattingOption, int)
    {31, 114, 191, 2, Smoke::mf_static, 214, 48},	//168 QGlobalSpace::operator<(const QByteArray&, const char*)
    {31, 149, 194, 2, Smoke::mf_static, 47, 49},	//169 QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    {31, 149, 197, 2, Smoke::mf_static, 57, 50},	//170 QGlobalSpace::operator|(Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>)
    {31, 96, 200, 2, Smoke::mf_static, 82, 51},	//171 QGlobalSpace::operator*(const QLine&, const QMatrix&)
    {31, 149, 203, 2, Smoke::mf_static, 47, 52},	//172 QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    {31, 96, 206, 2, Smoke::mf_static, 84, 53},	//173 QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    {31, 149, 209, 2, Smoke::mf_static, 66, 54},	//174 QGlobalSpace::operator|(Qt::Orientation, Qt::Orientation)
    {31, 96, 212, 2, Smoke::mf_static, 96, 55},	//175 QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    {31, 149, 215, 2, Smoke::mf_static, 78, 56},	//176 QGlobalSpace::operator|(Qt::ToolBarArea, int)
    {31, 145, 218, 2, Smoke::mf_static, 36, 57},	//177 QGlobalSpace::operator>>(QDataStream&, QPointF&)
    {31, 119, 221, 2, Smoke::mf_static, 36, 58},	//178 QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    {31, 149, 224, 2, Smoke::mf_static, 78, 59},	//179 QGlobalSpace::operator|(Qt::MatchFlag, int)
    {31, 100, 227, 2, Smoke::mf_static, 258, 60},	//180 QGlobalSpace::operator+(const QString&, const char*)
    {31, 119, 230, 2, Smoke::mf_static, 36, 61},	//181 QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    {31, 149, 233, 2, Smoke::mf_static, 59, 62},	//182 QGlobalSpace::operator|(Qt::GestureFlag, Qt::GestureFlag)
    {31, 145, 236, 2, Smoke::mf_static, 36, 63},	//183 QGlobalSpace::operator>>(QDataStream&, QDate&)
    {31, 149, 239, 2, Smoke::mf_static, 51, 64},	//184 QGlobalSpace::operator|(QIODevice::OpenModeFlag, QIODevice::OpenModeFlag)
    {31, 100, 242, 2, Smoke::mf_static, 220, 65},	//185 QGlobalSpace::operator+(char, const QByteArray&)
    {31, 112, 60, 2, Smoke::mf_static, 243, 66},	//186 QGlobalSpace::operator/(const QPoint&, double)
    {31, 100, 245, 2, Smoke::mf_static, 258, 67},	//187 QGlobalSpace::operator+(const char*, const QString&)
    {31, 130, 248, 2, Smoke::mf_static, 214, 68},	//188 QGlobalSpace::operator==(const char*, const QByteArray&)
    {31, 145, 251, 2, Smoke::mf_static, 36, 69},	//189 QGlobalSpace::operator>>(QDataStream&, QByteArray&)
    {31, 145, 254, 2, Smoke::mf_static, 36, 70},	//190 QGlobalSpace::operator>>(QDataStream&, QVariant&)
    {31, 145, 257, 2, Smoke::mf_static, 36, 71},	//191 QGlobalSpace::operator>>(QDataStream&, QRegExp&)
    {31, 130, 260, 2, Smoke::mf_static, 214, 72},	//192 QGlobalSpace::operator==(const QPointF&, const QPointF&)
    {31, 112, 263, 2, Smoke::mf_static, 131, 73},	//193 QGlobalSpace::operator/(const QTransform&, double)
    {31, 123, 245, 2, Smoke::mf_static, 214, 74},	//194 QGlobalSpace::operator<=(const char*, const QString&)
    {31, 91, 266, 2, Smoke::mf_static, 214, 75},	//195 QGlobalSpace::operator!=(const QStringRef&, const QStringRef&)
    {31, 114, 269, 2, Smoke::mf_static, 214, 76},	//196 QGlobalSpace::operator<(QChar, QChar)
    {31, 96, 272, 2, Smoke::mf_static, 96, 77},	//197 QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    {31, 119, 275, 2, Smoke::mf_static, 36, 78},	//198 QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    {31, 140, 108, 2, Smoke::mf_static, 214, 79},	//199 QGlobalSpace::operator>=(const char*, const QLatin1String&)
    {31, 145, 278, 2, Smoke::mf_static, 36, 80},	//200 QGlobalSpace::operator>>(QDataStream&, QRegion&)
    {31, 96, 281, 2, Smoke::mf_static, 245, 81},	//201 QGlobalSpace::operator*(const QPointF&, double)
    {31, 149, 284, 2, Smoke::mf_static, 78, 82},	//202 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    {31, 130, 87, 2, Smoke::mf_static, 214, 83},	//203 QGlobalSpace::operator==(const QSize&, const QSize&)
    {31, 119, 287, 2, Smoke::mf_static, 36, 84},	//204 QGlobalSpace::operator<<(QDataStream&, const QDate&)
    {31, 130, 108, 2, Smoke::mf_static, 214, 85},	//205 QGlobalSpace::operator==(const char*, const QLatin1String&)
    {31, 149, 290, 2, Smoke::mf_static, 64, 86},	//206 QGlobalSpace::operator|(Qt::MatchFlag, QFlags<Qt::MatchFlag>)
    {31, 149, 293, 2, Smoke::mf_static, 78, 87},	//207 QGlobalSpace::operator|(Qt::GestureFlag, int)
    {31, 91, 114, 2, Smoke::mf_static, 214, 88},	//208 QGlobalSpace::operator!=(const QByteArray&, const QByteArray&)
    {31, 149, 296, 2, Smoke::mf_static, 52, 89},	//209 QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    {31, 145, 299, 2, Smoke::mf_static, 36, 90},	//210 QGlobalSpace::operator>>(QDataStream&, QCursor&)
    {31, 149, 302, 2, Smoke::mf_static, 63, 91},	//211 QGlobalSpace::operator|(Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>)
    {31, 112, 102, 2, Smoke::mf_static, 255, 92},	//212 QGlobalSpace::operator/(const QSizeF&, double)
    {31, 149, 305, 2, Smoke::mf_static, 64, 93},	//213 QGlobalSpace::operator|(Qt::MatchFlag, Qt::MatchFlag)
    {31, 145, 308, 2, Smoke::mf_static, 36, 94},	//214 QGlobalSpace::operator>>(QDataStream&, QTransform&)
    {31, 96, 311, 2, Smoke::mf_static, 104, 95},	//215 QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    {31, 135, 269, 2, Smoke::mf_static, 214, 96},	//216 QGlobalSpace::operator>(QChar, QChar)
    {31, 140, 248, 2, Smoke::mf_static, 214, 97},	//217 QGlobalSpace::operator>=(const char*, const QByteArray&)
    {31, 130, 314, 2, Smoke::mf_static, 214, 98},	//218 QGlobalSpace::operator==(const QString&, QString::Null)
    {31, 114, 114, 2, Smoke::mf_static, 214, 99},	//219 QGlobalSpace::operator<(const QByteArray&, const QByteArray&)
    {31, 145, 317, 2, Smoke::mf_static, 36, 100},	//220 QGlobalSpace::operator>>(QDataStream&, QSizeF&)
    {31, 108, 320, 1, Smoke::mf_static, 245, 101},	//221 QGlobalSpace::operator-(const QPointF&)
    {31, 149, 322, 2, Smoke::mf_static, 62, 102},	//222 QGlobalSpace::operator|(Qt::ItemFlag, Qt::ItemFlag)
    {31, 119, 325, 2, Smoke::mf_static, 36, 103},	//223 QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    {31, 100, 328, 2, Smoke::mf_static, 258, 104},	//224 QGlobalSpace::operator+(const QByteArray&, const QString&)
    {31, 149, 331, 2, Smoke::mf_static, 71, 105},	//225 QGlobalSpace::operator|(Qt::WindowType, QFlags<Qt::WindowType>)
    {31, 96, 334, 2, Smoke::mf_static, 102, 106},	//226 QGlobalSpace::operator*(const QPointF&, const QTransform&)
    {31, 149, 337, 2, Smoke::mf_static, 62, 107},	//227 QGlobalSpace::operator|(Qt::ItemFlag, QFlags<Qt::ItemFlag>)
    {31, 149, 340, 2, Smoke::mf_static, 69, 108},	//228 QGlobalSpace::operator|(Qt::TouchPointState, QFlags<Qt::TouchPointState>)
    {31, 100, 343, 2, Smoke::mf_static, 258, 109},	//229 QGlobalSpace::operator+(const QString&, char)
    {31, 140, 266, 2, Smoke::mf_static, 214, 110},	//230 QGlobalSpace::operator>=(const QStringRef&, const QStringRef&)
    {31, 130, 129, 2, Smoke::mf_static, 214, 111},	//231 QGlobalSpace::operator==(const QVariant&, const QVariantComparisonHelper&)
    {31, 119, 346, 2, Smoke::mf_static, 36, 112},	//232 QGlobalSpace::operator<<(QDataStream&, const QUrl&)
    {31, 149, 349, 2, Smoke::mf_static, 52, 113},	//233 QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    {31, 119, 352, 2, Smoke::mf_static, 36, 114},	//234 QGlobalSpace::operator<<(QDataStream&, const QVariant&)
    {31, 145, 355, 2, Smoke::mf_static, 36, 115},	//235 QGlobalSpace::operator>>(QDataStream&, QLine&)
    {31, 149, 358, 2, Smoke::mf_static, 63, 116},	//236 QGlobalSpace::operator|(Qt::KeyboardModifier, Qt::KeyboardModifier)
    {31, 114, 248, 2, Smoke::mf_static, 214, 117},	//237 QGlobalSpace::operator<(const char*, const QByteArray&)
    {31, 149, 361, 2, Smoke::mf_static, 78, 118},	//238 QGlobalSpace::operator|(Qt::AlignmentFlag, int)
    {31, 96, 364, 2, Smoke::mf_static, 100, 119},	//239 QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    {31, 149, 367, 2, Smoke::mf_static, 78, 120},	//240 QGlobalSpace::operator|(Qt::KeyboardModifier, int)
    {31, 149, 370, 2, Smoke::mf_static, 78, 121},	//241 QGlobalSpace::operator|(Qt::ItemFlag, int)
    {31, 91, 87, 2, Smoke::mf_static, 214, 122},	//242 QGlobalSpace::operator!=(const QSize&, const QSize&)
    {31, 149, 373, 2, Smoke::mf_static, 60, 123},	//243 QGlobalSpace::operator|(Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>)
    {31, 123, 191, 2, Smoke::mf_static, 214, 124},	//244 QGlobalSpace::operator<=(const QByteArray&, const char*)
    {31, 91, 376, 2, Smoke::mf_static, 214, 125},	//245 QGlobalSpace::operator!=(const QPoint&, const QPoint&)
    {31, 149, 379, 2, Smoke::mf_static, 78, 126},	//246 QGlobalSpace::operator|(QString::SectionFlag, int)
    {31, 149, 382, 2, Smoke::mf_static, 78, 127},	//247 QGlobalSpace::operator|(Qt::WindowType, int)
    {31, 149, 385, 2, Smoke::mf_static, 55, 128},	//248 QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    {31, 130, 388, 2, Smoke::mf_static, 214, 129},	//249 QGlobalSpace::operator==(const QStringRef&, const QString&)
    {31, 140, 391, 2, Smoke::mf_static, 214, 130},	//250 QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    {31, 130, 394, 2, Smoke::mf_static, 214, 131},	//251 QGlobalSpace::operator==(const QHashDummyValue&, const QHashDummyValue&)
    {31, 149, 397, 2, Smoke::mf_static, 49, 132},	//252 QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    {31, 149, 400, 2, Smoke::mf_static, 54, 133},	//253 QGlobalSpace::operator|(QUrl::FormattingOption, QUrl::FormattingOption)
    {31, 145, 403, 2, Smoke::mf_static, 36, 134},	//254 QGlobalSpace::operator>>(QDataStream&, QIcon&)
    {31, 119, 406, 2, Smoke::mf_static, 36, 135},	//255 QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    {31, 96, 263, 2, Smoke::mf_static, 131, 136},	//256 QGlobalSpace::operator*(const QTransform&, double)
    {31, 149, 409, 2, Smoke::mf_static, 78, 137},	//257 QGlobalSpace::operator|(Qt::TouchPointState, int)
    {31, 149, 412, 2, Smoke::mf_static, 55, 138},	//258 QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    {31, 114, 266, 2, Smoke::mf_static, 214, 139},	//259 QGlobalSpace::operator<(const QStringRef&, const QStringRef&)
    {31, 91, 415, 2, Smoke::mf_static, 214, 140},	//260 QGlobalSpace::operator!=(const QStringRef&, const char*)
    {31, 91, 248, 2, Smoke::mf_static, 214, 141},	//261 QGlobalSpace::operator!=(const char*, const QByteArray&)
    {31, 135, 266, 2, Smoke::mf_static, 214, 142},	//262 QGlobalSpace::operator>(const QStringRef&, const QStringRef&)
    {31, 149, 418, 2, Smoke::mf_static, 78, 143},	//263 QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    {31, 149, 421, 2, Smoke::mf_static, 50, 144},	//264 QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    {31, 119, 424, 2, Smoke::mf_static, 36, 145},	//265 QGlobalSpace::operator<<(QDataStream&, const QLineF&)
    {31, 145, 427, 2, Smoke::mf_static, 36, 146},	//266 QGlobalSpace::operator>>(QDataStream&, QBrush&)
    {31, 119, 430, 2, Smoke::mf_static, 36, 147},	//267 QGlobalSpace::operator<<(QDataStream&, const QPointF&)
    {31, 96, 433, 2, Smoke::mf_static, 243, 148},	//268 QGlobalSpace::operator*(const QPoint&, float)
    {31, 100, 42, 2, Smoke::mf_static, 258, 149},	//269 QGlobalSpace::operator+(const QString&, const QString&)
    {31, 114, 245, 2, Smoke::mf_static, 214, 150},	//270 QGlobalSpace::operator<(const char*, const QString&)
    {31, 91, 245, 2, Smoke::mf_static, 214, 151},	//271 QGlobalSpace::operator!=(const char*, const QString&)
    {31, 91, 191, 2, Smoke::mf_static, 214, 152},	//272 QGlobalSpace::operator!=(const QByteArray&, const char*)
    {31, 91, 436, 2, Smoke::mf_static, 214, 153},	//273 QGlobalSpace::operator!=(const QString&, const QStringRef&)
    {31, 149, 439, 2, Smoke::mf_static, 78, 154},	//274 QGlobalSpace::operator|(KUrl::EqualsOption, int)
    {31, 149, 442, 2, Smoke::mf_static, 78, 155},	//275 QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    {31, 145, 445, 2, Smoke::mf_static, 36, 156},	//276 QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    {31, 135, 114, 2, Smoke::mf_static, 214, 157},	//277 QGlobalSpace::operator>(const QByteArray&, const QByteArray&)
    {31, 123, 108, 2, Smoke::mf_static, 214, 158},	//278 QGlobalSpace::operator<=(const char*, const QLatin1String&)
    {31, 130, 376, 2, Smoke::mf_static, 214, 159},	//279 QGlobalSpace::operator==(const QPoint&, const QPoint&)
    {31, 130, 448, 2, Smoke::mf_static, 214, 160},	//280 QGlobalSpace::operator==(const char*, const QStringRef&)
    {31, 100, 248, 2, Smoke::mf_static, 220, 161},	//281 QGlobalSpace::operator+(const char*, const QByteArray&)
    {31, 145, 451, 2, Smoke::mf_static, 36, 162},	//282 QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    {31, 149, 454, 2, Smoke::mf_static, 78, 163},	//283 QGlobalSpace::operator|(Qt::MouseButton, int)
    {31, 123, 266, 2, Smoke::mf_static, 214, 164},	//284 QGlobalSpace::operator<=(const QStringRef&, const QStringRef&)
    {31, 145, 457, 2, Smoke::mf_static, 36, 165},	//285 QGlobalSpace::operator>>(QDataStream&, QSize&)
    {31, 149, 460, 2, Smoke::mf_static, 61, 166},	//286 QGlobalSpace::operator|(Qt::InputMethodHint, Qt::InputMethodHint)
    {31, 145, 463, 2, Smoke::mf_static, 36, 167},	//287 QGlobalSpace::operator>>(QDataStream&, QVariant::Type&)
    {31, 130, 269, 2, Smoke::mf_static, 214, 168},	//288 QGlobalSpace::operator==(QChar, QChar)
    {31, 149, 466, 2, Smoke::mf_static, 67, 169},	//289 QGlobalSpace::operator|(Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>)
    {31, 91, 388, 2, Smoke::mf_static, 214, 170},	//290 QGlobalSpace::operator!=(const QStringRef&, const QString&)
    {31, 96, 469, 2, Smoke::mf_static, 84, 171},	//291 QGlobalSpace::operator*(const QLineF&, const QTransform&)
    {31, 91, 472, 2, Smoke::mf_static, 214, 172},	//292 QGlobalSpace::operator!=(const QStringRef&, const QLatin1String&)
    {31, 119, 475, 2, Smoke::mf_static, 36, 173},	//293 QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    {31, 119, 478, 2, Smoke::mf_static, 36, 174},	//294 QGlobalSpace::operator<<(QDataStream&, const QSizeF&)
    {31, 149, 481, 2, Smoke::mf_static, 68, 175},	//295 QGlobalSpace::operator|(Qt::ToolBarArea, QFlags<Qt::ToolBarArea>)
    {31, 119, 484, 2, Smoke::mf_static, 36, 176},	//296 QGlobalSpace::operator<<(QDataStream&, const QFont&)
    {31, 149, 487, 2, Smoke::mf_static, 49, 177},	//297 QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    {31, 119, 490, 2, Smoke::mf_static, 36, 178},	//298 QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    {31, 100, 493, 2, Smoke::mf_static, 258, 179},	//299 QGlobalSpace::operator+(char, const QString&)
    {31, 91, 117, 2, Smoke::mf_static, 214, 180},	//300 QGlobalSpace::operator!=(const QLatin1String&, const QStringRef&)
    {31, 91, 269, 2, Smoke::mf_static, 214, 181},	//301 QGlobalSpace::operator!=(QChar, QChar)
    {31, 130, 391, 2, Smoke::mf_static, 214, 182},	//302 QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    {31, 149, 496, 2, Smoke::mf_static, 70, 183},	//303 QGlobalSpace::operator|(Qt::WindowState, Qt::WindowState)
    {31, 149, 499, 2, Smoke::mf_static, 54, 184},	//304 QGlobalSpace::operator|(QUrl::FormattingOption, QFlags<QUrl::FormattingOption>)
    {31, 130, 111, 2, Smoke::mf_static, 214, 185},	//305 QGlobalSpace::operator==(const QSizeF&, const QSizeF&)
    {31, 145, 502, 2, Smoke::mf_static, 36, 186},	//306 QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    {31, 145, 505, 2, Smoke::mf_static, 36, 187},	//307 QGlobalSpace::operator>>(QDataStream&, QPalette&)
    {31, 119, 508, 2, Smoke::mf_static, 36, 188},	//308 QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    {31, 130, 266, 2, Smoke::mf_static, 214, 189},	//309 QGlobalSpace::operator==(const QStringRef&, const QStringRef&)
    {31, 91, 511, 2, Smoke::mf_static, 214, 190},	//310 QGlobalSpace::operator!=(const QRectF&, const QRectF&)
    {31, 96, 514, 2, Smoke::mf_static, 253, 191},	//311 QGlobalSpace::operator*(double, const QSize&)
    {31, 140, 191, 2, Smoke::mf_static, 214, 192},	//312 QGlobalSpace::operator>=(const QByteArray&, const char*)
    {31, 96, 517, 2, Smoke::mf_static, 243, 193},	//313 QGlobalSpace::operator*(double, const QPoint&)
    {31, 119, 520, 2, Smoke::mf_static, 36, 194},	//314 QGlobalSpace::operator<<(QDataStream&, const QPoint&)
    {31, 119, 523, 2, Smoke::mf_static, 36, 195},	//315 QGlobalSpace::operator<<(QDataStream&, const QImage&)
    {31, 100, 526, 2, Smoke::mf_static, 220, 196},	//316 QGlobalSpace::operator+(const QByteArray&, char)
    {31, 112, 281, 2, Smoke::mf_static, 245, 197},	//317 QGlobalSpace::operator/(const QPointF&, double)
    {31, 140, 269, 2, Smoke::mf_static, 214, 198},	//318 QGlobalSpace::operator>=(QChar, QChar)
    {31, 123, 114, 2, Smoke::mf_static, 214, 199},	//319 QGlobalSpace::operator<=(const QByteArray&, const QByteArray&)
    {31, 145, 529, 2, Smoke::mf_static, 36, 200},	//320 QGlobalSpace::operator>>(QDataStream&, QFont&)
    {31, 123, 391, 2, Smoke::mf_static, 214, 201},	//321 QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    {31, 149, 532, 2, Smoke::mf_static, 53, 202},	//322 QGlobalSpace::operator|(QString::SectionFlag, QFlags<QString::SectionFlag>)
    {31, 119, 535, 2, Smoke::mf_static, 36, 203},	//323 QGlobalSpace::operator<<(QDataStream&, const QSize&)
    {31, 135, 248, 2, Smoke::mf_static, 214, 204},	//324 QGlobalSpace::operator>(const char*, const QByteArray&)
    {31, 145, 538, 2, Smoke::mf_static, 36, 205},	//325 QGlobalSpace::operator>>(QDataStream&, QRectF&)
    {31, 119, 541, 2, Smoke::mf_static, 36, 206},	//326 QGlobalSpace::operator<<(QDataStream&, const QChar&)
    {31, 130, 511, 2, Smoke::mf_static, 214, 207},	//327 QGlobalSpace::operator==(const QRectF&, const QRectF&)
    {31, 91, 544, 2, Smoke::mf_static, 214, 208},	//328 QGlobalSpace::operator!=(bool, QBool)
    {31, 149, 547, 2, Smoke::mf_static, 50, 209},	//329 QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    {31, 96, 550, 2, Smoke::mf_static, 104, 210},	//330 QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    {31, 91, 553, 2, Smoke::mf_static, 214, 211},	//331 QGlobalSpace::operator!=(QBool, bool)
    {31, 149, 556, 2, Smoke::mf_static, 78, 212},	//332 QGlobalSpace::operator|(Qt::WindowState, int)
    {31, 108, 376, 2, Smoke::mf_static, 243, 213},	//333 QGlobalSpace::operator-(const QPoint&, const QPoint&)
    {31, 145, 559, 2, Smoke::mf_static, 36, 214},	//334 QGlobalSpace::operator>>(QDataStream&, QStringList&)
    {31, 100, 191, 2, Smoke::mf_static, 220, 215},	//335 QGlobalSpace::operator+(const QByteArray&, const char*)
    {31, 119, 562, 2, Smoke::mf_static, 36, 216},	//336 QGlobalSpace::operator<<(QDataStream&, const QRect&)
    {31, 91, 111, 2, Smoke::mf_static, 214, 217},	//337 QGlobalSpace::operator!=(const QSizeF&, const QSizeF&)
    {31, 123, 248, 2, Smoke::mf_static, 214, 218},	//338 QGlobalSpace::operator<=(const char*, const QByteArray&)
    {31, 149, 565, 2, Smoke::mf_static, 78, 219},	//339 QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    {31, 119, 568, 2, Smoke::mf_static, 36, 220},	//340 QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    {31, 149, 571, 2, Smoke::mf_static, 57, 221},	//341 QGlobalSpace::operator|(Qt::DockWidgetArea, Qt::DockWidgetArea)
    {31, 130, 436, 2, Smoke::mf_static, 214, 222},	//342 QGlobalSpace::operator==(const QString&, const QStringRef&)
    {31, 91, 391, 2, Smoke::mf_static, 214, 223},	//343 QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    {31, 119, 574, 2, Smoke::mf_static, 36, 224},	//344 QGlobalSpace::operator<<(QDataStream&, const QColor&)
    {31, 149, 577, 2, Smoke::mf_static, 71, 225},	//345 QGlobalSpace::operator|(Qt::WindowType, Qt::WindowType)
    {31, 96, 580, 2, Smoke::mf_static, 253, 226},	//346 QGlobalSpace::operator*(const QSize&, double)
    {31, 130, 583, 2, Smoke::mf_static, 214, 227},	//347 QGlobalSpace::operator==(QString::Null, const QString&)
    {31, 149, 586, 2, Smoke::mf_static, 61, 228},	//348 QGlobalSpace::operator|(Qt::InputMethodHint, QFlags<Qt::InputMethodHint>)
    {31, 145, 589, 2, Smoke::mf_static, 36, 229},	//349 QGlobalSpace::operator>>(QDataStream&, QPoint&)
    {31, 130, 191, 2, Smoke::mf_static, 214, 230},	//350 QGlobalSpace::operator==(const QByteArray&, const char*)
    {31, 145, 592, 2, Smoke::mf_static, 36, 231},	//351 QGlobalSpace::operator>>(QDataStream&, QDateTime&)
    {31, 135, 245, 2, Smoke::mf_static, 214, 232},	//352 QGlobalSpace::operator>(const char*, const QString&)
    {31, 119, 595, 2, Smoke::mf_static, 36, 233},	//353 QGlobalSpace::operator<<(QDataStream&, const QTime&)
    {31, 145, 598, 2, Smoke::mf_static, 36, 234},	//354 QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    {31, 135, 191, 2, Smoke::mf_static, 214, 235},	//355 QGlobalSpace::operator>(const QByteArray&, const char*)
    {31, 114, 108, 2, Smoke::mf_static, 214, 236},	//356 QGlobalSpace::operator<(const char*, const QLatin1String&)
    {31, 100, 376, 2, Smoke::mf_static, 243, 237},	//357 QGlobalSpace::operator+(const QPoint&, const QPoint&)
    {31, 123, 269, 2, Smoke::mf_static, 214, 238},	//358 QGlobalSpace::operator<=(QChar, QChar)
    {31, 96, 601, 2, Smoke::mf_static, 111, 239},	//359 QGlobalSpace::operator*(const QRegion&, const QTransform&)
    {31, 91, 583, 2, Smoke::mf_static, 214, 240},	//360 QGlobalSpace::operator!=(QString::Null, const QString&)
    {31, 135, 391, 2, Smoke::mf_static, 214, 241},	//361 QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    {31, 149, 604, 2, Smoke::mf_static, 53, 242},	//362 QGlobalSpace::operator|(QString::SectionFlag, QString::SectionFlag)
    {31, 91, 314, 2, Smoke::mf_static, 214, 243},	//363 QGlobalSpace::operator!=(const QString&, QString::Null)
    {31, 149, 607, 2, Smoke::mf_static, 78, 244},	//364 QGlobalSpace::operator|(QIODevice::OpenModeFlag, int)
    {31, 96, 610, 2, Smoke::mf_static, 243, 245},	//365 QGlobalSpace::operator*(int, const QPoint&)
    {31, 149, 613, 2, Smoke::mf_static, 59, 246},	//366 QGlobalSpace::operator|(Qt::GestureFlag, QFlags<Qt::GestureFlag>)
    {31, 96, 616, 2, Smoke::mf_static, 106, 247},	//367 QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    {31, 108, 49, 1, Smoke::mf_static, 243, 248},	//368 QGlobalSpace::operator-(const QPoint&)
    {31, 145, 619, 2, Smoke::mf_static, 36, 249},	//369 QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    {31, 149, 622, 2, Smoke::mf_static, 48, 250},	//370 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    {31, 145, 625, 2, Smoke::mf_static, 36, 251},	//371 QGlobalSpace::operator>>(QDataStream&, QString&)
    {31, 130, 114, 2, Smoke::mf_static, 214, 252},	//372 QGlobalSpace::operator==(const QByteArray&, const QByteArray&)
    {31, 119, 628, 2, Smoke::mf_static, 36, 253},	//373 QGlobalSpace::operator<<(QDataStream&, const QString&)
    {31, 108, 260, 2, Smoke::mf_static, 245, 254},	//374 QGlobalSpace::operator-(const QPointF&, const QPointF&)
    {31, 114, 391, 2, Smoke::mf_static, 214, 255},	//375 QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    {31, 145, 631, 2, Smoke::mf_static, 36, 256},	//376 QGlobalSpace::operator>>(QDataStream&, QChar&)
    {31, 100, 263, 2, Smoke::mf_static, 131, 257},	//377 QGlobalSpace::operator+(const QTransform&, double)
    {31, 149, 634, 2, Smoke::mf_static, 67, 258},	//378 QGlobalSpace::operator|(Qt::TextInteractionFlag, Qt::TextInteractionFlag)
    {31, 130, 415, 2, Smoke::mf_static, 214, 259},	//379 QGlobalSpace::operator==(const QStringRef&, const char*)
    {31, 91, 448, 2, Smoke::mf_static, 214, 260},	//380 QGlobalSpace::operator!=(const char*, const QStringRef&)
    {31, 145, 637, 2, Smoke::mf_static, 36, 261},	//381 QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    {31, 100, 114, 2, Smoke::mf_static, 220, 262},	//382 QGlobalSpace::operator+(const QByteArray&, const QByteArray&)
    {31, 100, 640, 2, Smoke::mf_static, 258, 263},	//383 QGlobalSpace::operator+(const QString&, const QByteArray&)
    {31, 145, 643, 2, Smoke::mf_static, 36, 264},	//384 QGlobalSpace::operator>>(QDataStream&, QRect&)
    {31, 149, 646, 2, Smoke::mf_static, 78, 265},	//385 QGlobalSpace::operator|(Qt::ImageConversionFlag, int)
    {31, 130, 245, 2, Smoke::mf_static, 214, 266},	//386 QGlobalSpace::operator==(const char*, const QString&)
    {31, 119, 649, 2, Smoke::mf_static, 36, 267},	//387 QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    {31, 119, 652, 2, Smoke::mf_static, 36, 268},	//388 QGlobalSpace::operator<<(QDataStream&, const QVariant::Type)
    {31, 112, 580, 2, Smoke::mf_static, 253, 269},	//389 QGlobalSpace::operator/(const QSize&, double)
    {31, 145, 655, 2, Smoke::mf_static, 36, 270},	//390 QGlobalSpace::operator>>(QDataStream&, QLineF&)
    {31, 145, 658, 2, Smoke::mf_static, 36, 271},	//391 QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    {31, 130, 544, 2, Smoke::mf_static, 214, 272},	//392 QGlobalSpace::operator==(bool, QBool)
    {31, 149, 661, 2, Smoke::mf_static, 69, 273},	//393 QGlobalSpace::operator|(Qt::TouchPointState, Qt::TouchPointState)
    {31, 149, 664, 2, Smoke::mf_static, 78, 274},	//394 QGlobalSpace::operator|(Qt::TextInteractionFlag, int)
    {31, 96, 667, 2, Smoke::mf_static, 100, 275},	//395 QGlobalSpace::operator*(const QPoint&, const QTransform&)
    {31, 140, 245, 2, Smoke::mf_static, 214, 276},	//396 QGlobalSpace::operator>=(const char*, const QString&)
    {31, 119, 670, 2, Smoke::mf_static, 36, 277},	//397 QGlobalSpace::operator<<(QDataStream&, const QDateTime&)
    {31, 145, 673, 2, Smoke::mf_static, 36, 278},	//398 QGlobalSpace::operator>>(QDataStream&, QTime&)
    {31, 91, 260, 2, Smoke::mf_static, 214, 279},	//399 QGlobalSpace::operator!=(const QPointF&, const QPointF&)
    {31, 96, 676, 2, Smoke::mf_static, 243, 280},	//400 QGlobalSpace::operator*(const QPoint&, int)
    {31, 149, 679, 2, Smoke::mf_static, 60, 281},	//401 QGlobalSpace::operator|(Qt::ImageConversionFlag, Qt::ImageConversionFlag)
    {31, 108, 87, 2, Smoke::mf_static, 253, 282},	//402 QGlobalSpace::operator-(const QSize&, const QSize&)
    {31, 149, 682, 2, Smoke::mf_static, 58, 283},	//403 QGlobalSpace::operator|(Qt::DropAction, QFlags<Qt::DropAction>)
    {31, 149, 685, 2, Smoke::mf_static, 58, 284},	//404 QGlobalSpace::operator|(Qt::DropAction, Qt::DropAction)
    {31, 149, 688, 2, Smoke::mf_static, 78, 285},	//405 QGlobalSpace::operator|(Qt::Orientation, int)
    {31, 91, 108, 2, Smoke::mf_static, 214, 286},	//406 QGlobalSpace::operator!=(const char*, const QLatin1String&)
    {31, 100, 260, 2, Smoke::mf_static, 245, 287},	//407 QGlobalSpace::operator+(const QPointF&, const QPointF&)
    {31, 96, 691, 2, Smoke::mf_static, 111, 288},	//408 QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    {31, 130, 553, 2, Smoke::mf_static, 214, 289},	//409 QGlobalSpace::operator==(QBool, bool)
    {31, 130, 84, 2, Smoke::mf_static, 214, 290},	//410 QGlobalSpace::operator==(const QRect&, const QRect&)
    {31, 96, 694, 2, Smoke::mf_static, 243, 291},	//411 QGlobalSpace::operator*(float, const QPoint&)
    {31, 145, 697, 2, Smoke::mf_static, 36, 292},	//412 QGlobalSpace::operator>>(QDataStream&, QUrl&)
    {31, 100, 700, 2, Smoke::mf_static, 258, 293},	//413 QGlobalSpace::operator+(const QString&, QChar)
    {31, 91, 138, 2, Smoke::mf_static, 214, 294},	//414 QGlobalSpace::operator!=(QString::Null, QString::Null)
    {31, 149, 703, 2, Smoke::mf_static, 66, 295},	//415 QGlobalSpace::operator|(Qt::Orientation, QFlags<Qt::Orientation>)
    {31, 91, 132, 2, Smoke::mf_static, 214, 296},	//416 QGlobalSpace::operator!=(QBool, QBool)
    {31, 130, 472, 2, Smoke::mf_static, 214, 297},	//417 QGlobalSpace::operator==(const QStringRef&, const QLatin1String&)
    {31, 108, 263, 2, Smoke::mf_static, 131, 298},	//418 QGlobalSpace::operator-(const QTransform&, double)
    {31, 105, 706, 2, Smoke::mf_static, 4, 299},	//419 QGlobalSpace::operator++(KIconLoader::Group&, int)
    {48, 56, 709, 2, Smoke::mf_virtual, 214, 0},	//420 QObject::eventFilter(QObject*, QEvent*)
    {48, 33, 712, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//421 QObject::childEvent(QChildEvent*)
    {48, 37, 53, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//422 QObject::customEvent(QEvent*)
    {48, 35, 5, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//423 QObject::connectNotify(const char*)
    {48, 40, 5, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//424 QObject::disconnectNotify(const char*)
    {58, 83, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 115, 0},	//425 QPushButton::minimumSizeHint() const
    {58, 55, 53, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//426 QPushButton::event(QEvent*)
    {58, 74, 51, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//427 QPushButton::keyPressEvent(QKeyEvent*)
    {58, 57, 714, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//428 QPushButton::focusInEvent(QFocusEvent*)
    {58, 59, 714, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//429 QPushButton::focusOutEvent(QFocusEvent*)
    {79, 38, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 273, 0},	//430 QWidget::devType() const
    {79, 216, 716, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//431 QWidget::setVisible(bool)
    {79, 61, 32, 1, Smoke::mf_const|Smoke::mf_virtual, 273, 0},	//432 QWidget::heightForWidth(int) const
    {79, 151, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 94, 0},	//433 QWidget::paintEngine() const
    {79, 84, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//434 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {79, 249, 718, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//435 QWidget::wheelEvent(QWheelEvent*)
    {79, 54, 53, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//436 QWidget::enterEvent(QEvent*)
    {79, 79, 53, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//437 QWidget::leaveEvent(QEvent*)
    {79, 88, 720, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//438 QWidget::moveEvent(QMoveEvent*)
    {79, 164, 722, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//439 QWidget::resizeEvent(QResizeEvent*)
    {79, 34, 724, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//440 QWidget::closeEvent(QCloseEvent*)
    {79, 36, 726, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//441 QWidget::contextMenuEvent(QContextMenuEvent*)
    {79, 229, 728, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//442 QWidget::tabletEvent(QTabletEvent*)
    {79, 25, 730, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//443 QWidget::actionEvent(QActionEvent*)
    {79, 47, 732, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//444 QWidget::dragEnterEvent(QDragEnterEvent*)
    {79, 49, 734, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//445 QWidget::dragMoveEvent(QDragMoveEvent*)
    {79, 48, 736, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//446 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {79, 51, 738, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//447 QWidget::dropEvent(QDropEvent*)
    {79, 218, 740, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//448 QWidget::showEvent(QShowEvent*)
    {79, 62, 742, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//449 QWidget::hideEvent(QHideEvent*)
    {79, 251, 744, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//450 QWidget::x11Event(_XEvent*)
    {79, 82, 746, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 273, 0},	//451 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {79, 68, 748, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//452 QWidget::inputMethodEvent(QInputMethodEvent*)
    {79, 69, 750, 1, Smoke::mf_const|Smoke::mf_virtual, 135, 0},	//453 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {79, 58, 716, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//454 QWidget::focusNextPrevChild(bool)
    {79, 227, 752, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//455 QWidget::styleChange(QStyle&)
    {79, 53, 716, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//456 QWidget::enabledChange(bool)
    {79, 153, 754, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//457 QWidget::paletteChange(const QPalette&)
    {79, 60, 756, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//458 QWidget::fontChange(const QFont&)
    {79, 250, 716, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//459 QWidget::windowActivationChange(bool)
    {79, 77, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//460 QWidget::languageChange()
    {79, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 32},	//461 QWidget::DrawWindowBackground (enum)
    {79, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 33},	//462 QWidget::DrawChildren (enum)
    {79, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 34},	//463 QWidget::IgnoreMask (enum)
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    125,  // QGlobalSpace::operator!=(const QMargins&, const QMargins&)
    130,  // QGlobalSpace::operator!=(const QRect&, const QRect&)
    146,  // QGlobalSpace::operator!=(const QVariant&, const QVariantComparisonHelper&)
    195,  // QGlobalSpace::operator!=(const QStringRef&, const QStringRef&)
    208,  // QGlobalSpace::operator!=(const QByteArray&, const QByteArray&)
    242,  // QGlobalSpace::operator!=(const QSize&, const QSize&)
    245,  // QGlobalSpace::operator!=(const QPoint&, const QPoint&)
    292,  // QGlobalSpace::operator!=(const QStringRef&, const QLatin1String&)
    300,  // QGlobalSpace::operator!=(const QLatin1String&, const QStringRef&)
    301,  // QGlobalSpace::operator!=(QChar, QChar)
    310,  // QGlobalSpace::operator!=(const QRectF&, const QRectF&)
    337,  // QGlobalSpace::operator!=(const QSizeF&, const QSizeF&)
    343,  // QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    399,  // QGlobalSpace::operator!=(const QPointF&, const QPointF&)
    414,  // QGlobalSpace::operator!=(QString::Null, QString::Null)
    416,  // QGlobalSpace::operator!=(QBool, QBool)
    0,
    260,  // QGlobalSpace::operator!=(const QStringRef&, const char*)
    272,  // QGlobalSpace::operator!=(const QByteArray&, const char*)
    290,  // QGlobalSpace::operator!=(const QStringRef&, const QString&)
    331,  // QGlobalSpace::operator!=(QBool, bool)
    360,  // QGlobalSpace::operator!=(QString::Null, const QString&)
    0,
    261,  // QGlobalSpace::operator!=(const char*, const QByteArray&)
    273,  // QGlobalSpace::operator!=(const QString&, const QStringRef&)
    328,  // QGlobalSpace::operator!=(bool, QBool)
    363,  // QGlobalSpace::operator!=(const QString&, QString::Null)
    380,  // QGlobalSpace::operator!=(const char*, const QStringRef&)
    406,  // QGlobalSpace::operator!=(const char*, const QLatin1String&)
    0,
    133,  // QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    134,  // QGlobalSpace::operator*(const QLine&, const QTransform&)
    156,  // QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    171,  // QGlobalSpace::operator*(const QLine&, const QMatrix&)
    173,  // QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    175,  // QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    197,  // QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    215,  // QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    226,  // QGlobalSpace::operator*(const QPointF&, const QTransform&)
    239,  // QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    291,  // QGlobalSpace::operator*(const QLineF&, const QTransform&)
    330,  // QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    359,  // QGlobalSpace::operator*(const QRegion&, const QTransform&)
    367,  // QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    395,  // QGlobalSpace::operator*(const QPoint&, const QTransform&)
    408,  // QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    0,
    122,  // QGlobalSpace::operator*(const QPoint&, double)
    137,  // QGlobalSpace::operator*(const QSizeF&, double)
    201,  // QGlobalSpace::operator*(const QPointF&, double)
    256,  // QGlobalSpace::operator*(const QTransform&, double)
    268,  // QGlobalSpace::operator*(const QPoint&, float)
    346,  // QGlobalSpace::operator*(const QSize&, double)
    400,  // QGlobalSpace::operator*(const QPoint&, int)
    0,
    123,  // QGlobalSpace::operator*(double, const QPointF&)
    126,  // QGlobalSpace::operator*(double, const QSizeF&)
    311,  // QGlobalSpace::operator*(double, const QSize&)
    313,  // QGlobalSpace::operator*(double, const QPoint&)
    365,  // QGlobalSpace::operator*(int, const QPoint&)
    411,  // QGlobalSpace::operator*(float, const QPoint&)
    0,
    131,  // QGlobalSpace::operator+(const QSize&, const QSize&)
    159,  // QGlobalSpace::operator+(const QSizeF&, const QSizeF&)
    357,  // QGlobalSpace::operator+(const QPoint&, const QPoint&)
    382,  // QGlobalSpace::operator+(const QByteArray&, const QByteArray&)
    407,  // QGlobalSpace::operator+(const QPointF&, const QPointF&)
    0,
    151,  // QGlobalSpace::operator+(QChar, const QString&)
    224,  // QGlobalSpace::operator+(const QByteArray&, const QString&)
    316,  // QGlobalSpace::operator+(const QByteArray&, char)
    335,  // QGlobalSpace::operator+(const QByteArray&, const char*)
    377,  // QGlobalSpace::operator+(const QTransform&, double)
    0,
    185,  // QGlobalSpace::operator+(char, const QByteArray&)
    281,  // QGlobalSpace::operator+(const char*, const QByteArray&)
    383,  // QGlobalSpace::operator+(const QString&, const QByteArray&)
    413,  // QGlobalSpace::operator+(const QString&, QChar)
    0,
    180,  // QGlobalSpace::operator+(const QString&, const char*)
    187,  // QGlobalSpace::operator+(const char*, const QString&)
    229,  // QGlobalSpace::operator+(const QString&, char)
    269,  // QGlobalSpace::operator+(const QString&, const QString&)
    299,  // QGlobalSpace::operator+(char, const QString&)
    0,
    221,  // QGlobalSpace::operator-(const QPointF&)
    368,  // QGlobalSpace::operator-(const QPoint&)
    0,
    140,  // QGlobalSpace::operator-(const QSizeF&, const QSizeF&)
    333,  // QGlobalSpace::operator-(const QPoint&, const QPoint&)
    374,  // QGlobalSpace::operator-(const QPointF&, const QPointF&)
    402,  // QGlobalSpace::operator-(const QSize&, const QSize&)
    0,
    186,  // QGlobalSpace::operator/(const QPoint&, double)
    193,  // QGlobalSpace::operator/(const QTransform&, double)
    212,  // QGlobalSpace::operator/(const QSizeF&, double)
    317,  // QGlobalSpace::operator/(const QPointF&, double)
    389,  // QGlobalSpace::operator/(const QSize&, double)
    0,
    196,  // QGlobalSpace::operator<(QChar, QChar)
    219,  // QGlobalSpace::operator<(const QByteArray&, const QByteArray&)
    259,  // QGlobalSpace::operator<(const QStringRef&, const QStringRef&)
    375,  // QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    0,
    237,  // QGlobalSpace::operator<(const char*, const QByteArray&)
    356,  // QGlobalSpace::operator<(const char*, const QLatin1String&)
    0,
    128,  // QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    132,  // QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    138,  // QGlobalSpace::operator<<(QDataStream&, const QLine&)
    150,  // QGlobalSpace::operator<<(QDataStream&, const QRectF&)
    153,  // QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    155,  // QGlobalSpace::operator<<(QDataStream&, const QByteArray&)
    166,  // QGlobalSpace::operator<<(QDataStream&, const QRegExp&)
    178,  // QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    181,  // QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    198,  // QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    204,  // QGlobalSpace::operator<<(QDataStream&, const QDate&)
    223,  // QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    232,  // QGlobalSpace::operator<<(QDataStream&, const QUrl&)
    234,  // QGlobalSpace::operator<<(QDataStream&, const QVariant&)
    255,  // QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    265,  // QGlobalSpace::operator<<(QDataStream&, const QLineF&)
    267,  // QGlobalSpace::operator<<(QDataStream&, const QPointF&)
    293,  // QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    294,  // QGlobalSpace::operator<<(QDataStream&, const QSizeF&)
    296,  // QGlobalSpace::operator<<(QDataStream&, const QFont&)
    298,  // QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    308,  // QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    314,  // QGlobalSpace::operator<<(QDataStream&, const QPoint&)
    315,  // QGlobalSpace::operator<<(QDataStream&, const QImage&)
    323,  // QGlobalSpace::operator<<(QDataStream&, const QSize&)
    326,  // QGlobalSpace::operator<<(QDataStream&, const QChar&)
    336,  // QGlobalSpace::operator<<(QDataStream&, const QRect&)
    340,  // QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    344,  // QGlobalSpace::operator<<(QDataStream&, const QColor&)
    353,  // QGlobalSpace::operator<<(QDataStream&, const QTime&)
    387,  // QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    397,  // QGlobalSpace::operator<<(QDataStream&, const QDateTime&)
    0,
    373,  // QGlobalSpace::operator<<(QDataStream&, const QString&)
    388,  // QGlobalSpace::operator<<(QDataStream&, const QVariant::Type)
    0,
    284,  // QGlobalSpace::operator<=(const QStringRef&, const QStringRef&)
    319,  // QGlobalSpace::operator<=(const QByteArray&, const QByteArray&)
    321,  // QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    358,  // QGlobalSpace::operator<=(QChar, QChar)
    0,
    278,  // QGlobalSpace::operator<=(const char*, const QLatin1String&)
    338,  // QGlobalSpace::operator<=(const char*, const QByteArray&)
    0,
    135,  // QGlobalSpace::operator==(const QMargins&, const QMargins&)
    142,  // QGlobalSpace::operator==(const QLatin1String&, const QStringRef&)
    147,  // QGlobalSpace::operator==(QBool, QBool)
    149,  // QGlobalSpace::operator==(QString::Null, QString::Null)
    192,  // QGlobalSpace::operator==(const QPointF&, const QPointF&)
    203,  // QGlobalSpace::operator==(const QSize&, const QSize&)
    231,  // QGlobalSpace::operator==(const QVariant&, const QVariantComparisonHelper&)
    251,  // QGlobalSpace::operator==(const QHashDummyValue&, const QHashDummyValue&)
    279,  // QGlobalSpace::operator==(const QPoint&, const QPoint&)
    288,  // QGlobalSpace::operator==(QChar, QChar)
    302,  // QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    305,  // QGlobalSpace::operator==(const QSizeF&, const QSizeF&)
    309,  // QGlobalSpace::operator==(const QStringRef&, const QStringRef&)
    327,  // QGlobalSpace::operator==(const QRectF&, const QRectF&)
    372,  // QGlobalSpace::operator==(const QByteArray&, const QByteArray&)
    410,  // QGlobalSpace::operator==(const QRect&, const QRect&)
    417,  // QGlobalSpace::operator==(const QStringRef&, const QLatin1String&)
    0,
    249,  // QGlobalSpace::operator==(const QStringRef&, const QString&)
    347,  // QGlobalSpace::operator==(QString::Null, const QString&)
    350,  // QGlobalSpace::operator==(const QByteArray&, const char*)
    379,  // QGlobalSpace::operator==(const QStringRef&, const char*)
    409,  // QGlobalSpace::operator==(QBool, bool)
    0,
    188,  // QGlobalSpace::operator==(const char*, const QByteArray&)
    205,  // QGlobalSpace::operator==(const char*, const QLatin1String&)
    218,  // QGlobalSpace::operator==(const QString&, QString::Null)
    280,  // QGlobalSpace::operator==(const char*, const QStringRef&)
    342,  // QGlobalSpace::operator==(const QString&, const QStringRef&)
    392,  // QGlobalSpace::operator==(bool, QBool)
    0,
    216,  // QGlobalSpace::operator>(QChar, QChar)
    262,  // QGlobalSpace::operator>(const QStringRef&, const QStringRef&)
    277,  // QGlobalSpace::operator>(const QByteArray&, const QByteArray&)
    361,  // QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    0,
    139,  // QGlobalSpace::operator>(const char*, const QLatin1String&)
    324,  // QGlobalSpace::operator>(const char*, const QByteArray&)
    0,
    141,  // QGlobalSpace::operator>=(const QByteArray&, const QByteArray&)
    230,  // QGlobalSpace::operator>=(const QStringRef&, const QStringRef&)
    250,  // QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    318,  // QGlobalSpace::operator>=(QChar, QChar)
    0,
    199,  // QGlobalSpace::operator>=(const char*, const QLatin1String&)
    217,  // QGlobalSpace::operator>=(const char*, const QByteArray&)
    0,
    127,  // QGlobalSpace::operator>>(QDataStream&, QImage&)
    165,  // QGlobalSpace::operator>>(QDataStream&, QColor&)
    177,  // QGlobalSpace::operator>>(QDataStream&, QPointF&)
    183,  // QGlobalSpace::operator>>(QDataStream&, QDate&)
    189,  // QGlobalSpace::operator>>(QDataStream&, QByteArray&)
    190,  // QGlobalSpace::operator>>(QDataStream&, QVariant&)
    191,  // QGlobalSpace::operator>>(QDataStream&, QRegExp&)
    200,  // QGlobalSpace::operator>>(QDataStream&, QRegion&)
    210,  // QGlobalSpace::operator>>(QDataStream&, QCursor&)
    214,  // QGlobalSpace::operator>>(QDataStream&, QTransform&)
    220,  // QGlobalSpace::operator>>(QDataStream&, QSizeF&)
    235,  // QGlobalSpace::operator>>(QDataStream&, QLine&)
    254,  // QGlobalSpace::operator>>(QDataStream&, QIcon&)
    266,  // QGlobalSpace::operator>>(QDataStream&, QBrush&)
    276,  // QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    282,  // QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    285,  // QGlobalSpace::operator>>(QDataStream&, QSize&)
    306,  // QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    307,  // QGlobalSpace::operator>>(QDataStream&, QPalette&)
    320,  // QGlobalSpace::operator>>(QDataStream&, QFont&)
    325,  // QGlobalSpace::operator>>(QDataStream&, QRectF&)
    349,  // QGlobalSpace::operator>>(QDataStream&, QPoint&)
    351,  // QGlobalSpace::operator>>(QDataStream&, QDateTime&)
    354,  // QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    369,  // QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    376,  // QGlobalSpace::operator>>(QDataStream&, QChar&)
    381,  // QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    384,  // QGlobalSpace::operator>>(QDataStream&, QRect&)
    390,  // QGlobalSpace::operator>>(QDataStream&, QLineF&)
    391,  // QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    398,  // QGlobalSpace::operator>>(QDataStream&, QTime&)
    412,  // QGlobalSpace::operator>>(QDataStream&, QUrl&)
    0,
    287,  // QGlobalSpace::operator>>(QDataStream&, QVariant::Type&)
    371,  // QGlobalSpace::operator>>(QDataStream&, QString&)
    0,
    121,  // QGlobalSpace::operator|(Qt::DockWidgetArea, int)
    124,  // QGlobalSpace::operator|(Qt::MouseButton, QFlags<Qt::MouseButton>)
    129,  // QGlobalSpace::operator|(Qt::InputMethodHint, int)
    136,  // QGlobalSpace::operator|(Qt::WindowState, QFlags<Qt::WindowState>)
    143,  // QGlobalSpace::operator|(Qt::MouseButton, Qt::MouseButton)
    144,  // QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    145,  // QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    148,  // QGlobalSpace::operator|(Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>)
    152,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>)
    157,  // QGlobalSpace::operator|(Qt::ToolBarArea, Qt::ToolBarArea)
    158,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    160,  // QGlobalSpace::operator|(QWidget::RenderFlag, int)
    161,  // QGlobalSpace::operator|(Qt::DropAction, int)
    163,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    164,  // QGlobalSpace::operator|(Qt::AlignmentFlag, Qt::AlignmentFlag)
    167,  // QGlobalSpace::operator|(QUrl::FormattingOption, int)
    169,  // QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    170,  // QGlobalSpace::operator|(Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>)
    172,  // QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    174,  // QGlobalSpace::operator|(Qt::Orientation, Qt::Orientation)
    176,  // QGlobalSpace::operator|(Qt::ToolBarArea, int)
    179,  // QGlobalSpace::operator|(Qt::MatchFlag, int)
    182,  // QGlobalSpace::operator|(Qt::GestureFlag, Qt::GestureFlag)
    184,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, QIODevice::OpenModeFlag)
    202,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    206,  // QGlobalSpace::operator|(Qt::MatchFlag, QFlags<Qt::MatchFlag>)
    207,  // QGlobalSpace::operator|(Qt::GestureFlag, int)
    209,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    211,  // QGlobalSpace::operator|(Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>)
    213,  // QGlobalSpace::operator|(Qt::MatchFlag, Qt::MatchFlag)
    222,  // QGlobalSpace::operator|(Qt::ItemFlag, Qt::ItemFlag)
    225,  // QGlobalSpace::operator|(Qt::WindowType, QFlags<Qt::WindowType>)
    227,  // QGlobalSpace::operator|(Qt::ItemFlag, QFlags<Qt::ItemFlag>)
    228,  // QGlobalSpace::operator|(Qt::TouchPointState, QFlags<Qt::TouchPointState>)
    233,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    236,  // QGlobalSpace::operator|(Qt::KeyboardModifier, Qt::KeyboardModifier)
    238,  // QGlobalSpace::operator|(Qt::AlignmentFlag, int)
    240,  // QGlobalSpace::operator|(Qt::KeyboardModifier, int)
    241,  // QGlobalSpace::operator|(Qt::ItemFlag, int)
    243,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>)
    246,  // QGlobalSpace::operator|(QString::SectionFlag, int)
    247,  // QGlobalSpace::operator|(Qt::WindowType, int)
    248,  // QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    252,  // QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    253,  // QGlobalSpace::operator|(QUrl::FormattingOption, QUrl::FormattingOption)
    257,  // QGlobalSpace::operator|(Qt::TouchPointState, int)
    258,  // QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    263,  // QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    264,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    274,  // QGlobalSpace::operator|(KUrl::EqualsOption, int)
    275,  // QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    283,  // QGlobalSpace::operator|(Qt::MouseButton, int)
    286,  // QGlobalSpace::operator|(Qt::InputMethodHint, Qt::InputMethodHint)
    289,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>)
    295,  // QGlobalSpace::operator|(Qt::ToolBarArea, QFlags<Qt::ToolBarArea>)
    297,  // QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    303,  // QGlobalSpace::operator|(Qt::WindowState, Qt::WindowState)
    304,  // QGlobalSpace::operator|(QUrl::FormattingOption, QFlags<QUrl::FormattingOption>)
    322,  // QGlobalSpace::operator|(QString::SectionFlag, QFlags<QString::SectionFlag>)
    329,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    332,  // QGlobalSpace::operator|(Qt::WindowState, int)
    339,  // QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    341,  // QGlobalSpace::operator|(Qt::DockWidgetArea, Qt::DockWidgetArea)
    345,  // QGlobalSpace::operator|(Qt::WindowType, Qt::WindowType)
    348,  // QGlobalSpace::operator|(Qt::InputMethodHint, QFlags<Qt::InputMethodHint>)
    362,  // QGlobalSpace::operator|(QString::SectionFlag, QString::SectionFlag)
    364,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, int)
    366,  // QGlobalSpace::operator|(Qt::GestureFlag, QFlags<Qt::GestureFlag>)
    370,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    378,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, Qt::TextInteractionFlag)
    385,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, int)
    393,  // QGlobalSpace::operator|(Qt::TouchPointState, Qt::TouchPointState)
    394,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, int)
    401,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, Qt::ImageConversionFlag)
    403,  // QGlobalSpace::operator|(Qt::DropAction, QFlags<Qt::DropAction>)
    404,  // QGlobalSpace::operator|(Qt::DropAction, Qt::DropAction)
    405,  // QGlobalSpace::operator|(Qt::Orientation, int)
    415,  // QGlobalSpace::operator|(Qt::Orientation, QFlags<Qt::Orientation>)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {3, 1, 1},	// KNS::Author::Author
    {3, 2, 2},	// KNS::Author::Author#
    {3, 52, 7},	// KNS::Author::email
    {3, 64, 11},	// KNS::Author::homepage
    {3, 73, 9},	// KNS::Author::jabber
    {3, 89, 5},	// KNS::Author::name
    {3, 129, 3},	// KNS::Author::operator=#
    {3, 176, 6},	// KNS::Author::setEmail$
    {3, 178, 10},	// KNS::Author::setHomepage$
    {3, 184, 8},	// KNS::Author::setJabber$
    {3, 189, 4},	// KNS::Author::setName$
    {3, 252, 12},	// KNS::Author::~Author
    {4, 4, 21},	// KNS::Button::Button#
    {4, 5, 20},	// KNS::Button::Button$$$#
    {4, 24, 25},	// KNS::Button::aboutToShowDialog
    {4, 39, 26},	// KNS::Button::dialogFinished
    {4, 81, 13},	// KNS::Button::metaObject
    {4, 157, 19},	// KNS::Button::qt_metacall$$?
    {4, 159, 14},	// KNS::Button::qt_metacast$
    {4, 168, 24},	// KNS::Button::setButtonText$
    {4, 195, 22},	// KNS::Button::setProviderList$
    {4, 203, 23},	// KNS::Button::setResourceType$
    {4, 217, 27},	// KNS::Button::showDialog
    {4, 223, 30},	// KNS::Button::staticMetaObject
    {4, 232, 28},	// KNS::Button::tr$
    {4, 233, 15},	// KNS::Button::tr$$
    {4, 234, 17},	// KNS::Button::tr$$$
    {4, 236, 29},	// KNS::Button::trUtf8$
    {4, 237, 16},	// KNS::Button::trUtf8$$
    {4, 238, 18},	// KNS::Button::trUtf8$$$
    {4, 253, 31},	// KNS::Button::~Button
    {5, 11, 41},	// KNS::Engine::Engine
    {5, 12, 32},	// KNS::Engine::Engine#
    {5, 41, 34},	// KNS::Engine::download
    {5, 42, 37},	// KNS::Engine::downloadDialog
    {5, 43, 38},	// KNS::Engine::downloadDialog#$
    {5, 44, 42},	// KNS::Engine::downloadDialogModal
    {5, 45, 33},	// KNS::Engine::downloadDialogModal#
    {5, 67, 40},	// KNS::Engine::init$
    {5, 243, 36},	// KNS::Engine::upload$
    {5, 245, 39},	// KNS::Engine::uploadDialog$
    {5, 247, 35},	// KNS::Engine::uploadDialogModal$
    {5, 254, 43},	// KNS::Engine::~Engine
    {6, 6, 90},	// KNS::Entry::Cache
    {6, 7, 89},	// KNS::Entry::Deleted
    {6, 8, 86},	// KNS::Entry::Downloadable
    {6, 13, 44},	// KNS::Entry::Entry
    {6, 14, 45},	// KNS::Entry::Entry#
    {6, 16, 87},	// KNS::Entry::Installed
    {6, 17, 85},	// KNS::Entry::Invalid
    {6, 21, 91},	// KNS::Entry::Online
    {6, 22, 92},	// KNS::Entry::Registry
    {6, 23, 88},	// KNS::Entry::Updateable
    {6, 28, 52},	// KNS::Entry::author
    {6, 29, 50},	// KNS::Entry::category
    {6, 32, 77},	// KNS::Entry::checksum
    {6, 46, 74},	// KNS::Entry::downloads
    {6, 65, 84},	// KNS::Entry::idNumber
    {6, 70, 69},	// KNS::Entry::installedFiles
    {6, 80, 54},	// KNS::Entry::license
    {6, 89, 48},	// KNS::Entry::name
    {6, 129, 46},	// KNS::Entry::operator=#
    {6, 154, 64},	// KNS::Entry::payload
    {6, 155, 66},	// KNS::Entry::preview
    {6, 160, 72},	// KNS::Entry::rating
    {6, 161, 60},	// KNS::Entry::release
    {6, 162, 62},	// KNS::Entry::releaseDate
    {6, 166, 51},	// KNS::Entry::setAuthor#
    {6, 170, 49},	// KNS::Entry::setCategory$
    {6, 172, 75},	// KNS::Entry::setChecksum$
    {6, 174, 73},	// KNS::Entry::setDownloads$
    {6, 180, 83},	// KNS::Entry::setIdNumber$
    {6, 182, 67},	// KNS::Entry::setInstalledFiles?
    {6, 186, 53},	// KNS::Entry::setLicense$
    {6, 188, 47},	// KNS::Entry::setName#
    {6, 191, 63},	// KNS::Entry::setPayload#
    {6, 193, 65},	// KNS::Entry::setPreview#
    {6, 197, 71},	// KNS::Entry::setRating$
    {6, 199, 59},	// KNS::Entry::setRelease$
    {6, 201, 61},	// KNS::Entry::setReleaseDate#
    {6, 205, 76},	// KNS::Entry::setSignature$
    {6, 207, 81},	// KNS::Entry::setSource$
    {6, 209, 79},	// KNS::Entry::setStatus$
    {6, 211, 55},	// KNS::Entry::setSummary#
    {6, 213, 68},	// KNS::Entry::setUnInstalledFiles?
    {6, 215, 57},	// KNS::Entry::setVersion$
    {6, 219, 78},	// KNS::Entry::signature
    {6, 221, 82},	// KNS::Entry::source
    {6, 224, 80},	// KNS::Entry::status
    {6, 228, 56},	// KNS::Entry::summary
    {6, 241, 70},	// KNS::Entry::uninstalledFiles
    {6, 248, 58},	// KNS::Entry::version
    {6, 255, 93},	// KNS::Entry::~Entry
    {7, 18, 94},	// KNS::KTranslatable::KTranslatable
    {7, 19, 97},	// KNS::KTranslatable::KTranslatable#
    {7, 20, 95},	// KNS::KTranslatable::KTranslatable$
    {7, 27, 98},	// KNS::KTranslatable::addString$$
    {7, 71, 106},	// KNS::KTranslatable::isEmpty
    {7, 72, 105},	// KNS::KTranslatable::isTranslated
    {7, 76, 103},	// KNS::KTranslatable::language
    {7, 78, 102},	// KNS::KTranslatable::languages
    {7, 129, 96},	// KNS::KTranslatable::operator=#
    {7, 163, 99},	// KNS::KTranslatable::representation
    {7, 225, 104},	// KNS::KTranslatable::stringmap
    {7, 226, 101},	// KNS::KTranslatable::strings
    {7, 240, 100},	// KNS::KTranslatable::translated$
    {7, 256, 107},	// KNS::KTranslatable::~KTranslatable
    {31, 92, -1},	// QGlobalSpace::operator!=##
    {31, 93, -18},	// QGlobalSpace::operator!=#$
    {31, 94, -24},	// QGlobalSpace::operator!=$#
    {31, 95, 271},	// QGlobalSpace::operator!=$$
    {31, 97, -31},	// QGlobalSpace::operator*##
    {31, 98, -48},	// QGlobalSpace::operator*#$
    {31, 99, -56},	// QGlobalSpace::operator*$#
    {31, 101, -63},	// QGlobalSpace::operator+##
    {31, 102, -69},	// QGlobalSpace::operator+#$
    {31, 103, -75},	// QGlobalSpace::operator+$#
    {31, 104, -80},	// QGlobalSpace::operator+$$
    {31, 106, 154},	// QGlobalSpace::operator++$
    {31, 107, 419},	// QGlobalSpace::operator++$$
    {31, 109, -86},	// QGlobalSpace::operator-#
    {31, 110, -89},	// QGlobalSpace::operator-##
    {31, 111, 418},	// QGlobalSpace::operator-#$
    {31, 113, -94},	// QGlobalSpace::operator/#$
    {31, 115, -100},	// QGlobalSpace::operator<##
    {31, 116, 168},	// QGlobalSpace::operator<#$
    {31, 117, -105},	// QGlobalSpace::operator<$#
    {31, 118, 270},	// QGlobalSpace::operator<$$
    {31, 120, -108},	// QGlobalSpace::operator<<##
    {31, 121, -141},	// QGlobalSpace::operator<<#$
    {31, 122, 162},	// QGlobalSpace::operator<<#?
    {31, 124, -144},	// QGlobalSpace::operator<=##
    {31, 125, 244},	// QGlobalSpace::operator<=#$
    {31, 126, -149},	// QGlobalSpace::operator<=$#
    {31, 127, 194},	// QGlobalSpace::operator<=$$
    {31, 131, -152},	// QGlobalSpace::operator==##
    {31, 132, -170},	// QGlobalSpace::operator==#$
    {31, 133, -176},	// QGlobalSpace::operator==$#
    {31, 134, 386},	// QGlobalSpace::operator==$$
    {31, 136, -183},	// QGlobalSpace::operator>##
    {31, 137, 355},	// QGlobalSpace::operator>#$
    {31, 138, -188},	// QGlobalSpace::operator>$#
    {31, 139, 352},	// QGlobalSpace::operator>$$
    {31, 141, -191},	// QGlobalSpace::operator>=##
    {31, 142, 312},	// QGlobalSpace::operator>=#$
    {31, 143, -196},	// QGlobalSpace::operator>=$#
    {31, 144, 396},	// QGlobalSpace::operator>=$$
    {31, 146, -199},	// QGlobalSpace::operator>>##
    {31, 147, -232},	// QGlobalSpace::operator>>#$
    {31, 148, 334},	// QGlobalSpace::operator>>#?
    {31, 150, -235},	// QGlobalSpace::operator|$$
};

}

extern "C" {

SMOKE_IMPORT void init_kdeui_Smoke();

static bool initialized = false;
Smoke *knewstuff2_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_knewstuff2_Smoke() {
    init_kdeui_Smoke();
    if (initialized) return;
    knewstuff2_Smoke = new Smoke(
        "knewstuff2",
        __smokeknewstuff2::classes, 79,
        __smokeknewstuff2::methods, 464,
        __smokeknewstuff2::methodMaps, 152,
        __smokeknewstuff2::methodNames, 256,
        __smokeknewstuff2::types, 276,
        __smokeknewstuff2::inheritanceList,
        __smokeknewstuff2::argumentList,
        __smokeknewstuff2::ambiguousMethodList,
        __smokeknewstuff2::cast );
    initialized = true;
}

void delete_knewstuff2_Smoke() { delete knewstuff2_Smoke; }

}
