#include <ktexteditor_includes.h>

#include <smoke.h>
#include <ktexteditor_smoke.h>

namespace __smokektexteditor {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //KAboutData
      switch(to) {
        case 1: return (void*)(KAboutData*)xptr;
        default: return xptr;
      }
    case 2:   //KAction
      switch(to) {
        case 2: return (void*)(KAction*)xptr;
        default: return xptr;
      }
    case 3:   //KActionCollection
      switch(to) {
        case 3: return (void*)(KActionCollection*)xptr;
        default: return xptr;
      }
    case 4:   //KCompletion
      switch(to) {
        case 4: return (void*)(KCompletion*)xptr;
        default: return xptr;
      }
    case 5:   //KComponentData
      switch(to) {
        case 5: return (void*)(KComponentData*)xptr;
        default: return xptr;
      }
    case 6:   //KConfig
      switch(to) {
        case 6: return (void*)(KConfig*)xptr;
        default: return xptr;
      }
    case 7:   //KConfigGroup
      switch(to) {
        case 7: return (void*)(KConfigGroup*)xptr;
        default: return xptr;
      }
    case 8:   //KIcon
      switch(to) {
        case 8: return (void*)(KIcon*)xptr;
        default: return xptr;
      }
    case 9:   //KParts::Factory
      switch(to) {
        case 18: return (void*)(KPluginFactory*)(KParts::Factory*)xptr;
        case 99: return (void*)(QObject*)(KParts::Factory*)xptr;
        case 9: return (void*)(KParts::Factory*)xptr;
        case 41: return (void*)(KTextEditor::Factory*)(KParts::Factory*)xptr;
        default: return xptr;
      }
    case 10:   //KParts::GUIActivateEvent
      switch(to) {
        case 10: return (void*)(KParts::GUIActivateEvent*)xptr;
        default: return xptr;
      }
    case 11:   //KParts::Part
      switch(to) {
        case 99: return (void*)(QObject*)(KParts::Part*)xptr;
        case 13: return (void*)(KParts::PartBase*)(KParts::Part*)xptr;
        case 68: return (void*)(KXMLGUIClient*)(KParts::Part*)xptr;
        case 11: return (void*)(KParts::Part*)xptr;
        case 38: return (void*)(KTextEditor::Document*)(KParts::Part*)xptr;
        default: return xptr;
      }
    case 12:   //KParts::PartActivateEvent
      switch(to) {
        case 12: return (void*)(KParts::PartActivateEvent*)xptr;
        default: return xptr;
      }
    case 13:   //KParts::PartBase
      switch(to) {
        case 68: return (void*)(KXMLGUIClient*)(KParts::PartBase*)xptr;
        case 13: return (void*)(KParts::PartBase*)xptr;
        case 38: return (void*)(KTextEditor::Document*)(KParts::PartBase*)xptr;
        default: return xptr;
      }
    case 14:   //KParts::PartManager
      switch(to) {
        case 14: return (void*)(KParts::PartManager*)xptr;
        default: return xptr;
      }
    case 15:   //KParts::PartSelectEvent
      switch(to) {
        case 15: return (void*)(KParts::PartSelectEvent*)xptr;
        default: return xptr;
      }
    case 16:   //KParts::ReadOnlyPart
      switch(to) {
        case 11: return (void*)(KParts::Part*)(KParts::ReadOnlyPart*)xptr;
        case 99: return (void*)(QObject*)(KParts::ReadOnlyPart*)xptr;
        case 13: return (void*)(KParts::PartBase*)(KParts::ReadOnlyPart*)xptr;
        case 68: return (void*)(KXMLGUIClient*)(KParts::ReadOnlyPart*)xptr;
        case 16: return (void*)(KParts::ReadOnlyPart*)xptr;
        case 38: return (void*)(KTextEditor::Document*)(KParts::ReadOnlyPart*)xptr;
        default: return xptr;
      }
    case 17:   //KParts::ReadWritePart
      switch(to) {
        case 16: return (void*)(KParts::ReadOnlyPart*)(KParts::ReadWritePart*)xptr;
        case 11: return (void*)(KParts::Part*)(KParts::ReadWritePart*)xptr;
        case 99: return (void*)(QObject*)(KParts::ReadWritePart*)xptr;
        case 13: return (void*)(KParts::PartBase*)(KParts::ReadWritePart*)xptr;
        case 68: return (void*)(KXMLGUIClient*)(KParts::ReadWritePart*)xptr;
        case 17: return (void*)(KParts::ReadWritePart*)xptr;
        case 38: return (void*)(KTextEditor::Document*)(KParts::ReadWritePart*)xptr;
        default: return xptr;
      }
    case 18:   //KPluginFactory
      switch(to) {
        case 99: return (void*)(QObject*)(KPluginFactory*)xptr;
        case 18: return (void*)(KPluginFactory*)xptr;
        case 41: return (void*)(KTextEditor::Factory*)(KPluginFactory*)xptr;
        default: return xptr;
      }
    case 19:   //KService
      switch(to) {
        case 107: return (void*)(QSharedData*)(KService*)xptr;
        case 19: return (void*)(KService*)xptr;
        default: return xptr;
      }
    case 21:   //KTextEditor::AnnotationInterface
      switch(to) {
        case 21: return (void*)(KTextEditor::AnnotationInterface*)xptr;
        case 23: return (void*)(KTextEditor::AnnotationViewInterface*)(KTextEditor::AnnotationInterface*)xptr;
        default: return xptr;
      }
    case 22:   //KTextEditor::AnnotationModel
      switch(to) {
        case 99: return (void*)(QObject*)(KTextEditor::AnnotationModel*)xptr;
        case 22: return (void*)(KTextEditor::AnnotationModel*)xptr;
        default: return xptr;
      }
    case 23:   //KTextEditor::AnnotationViewInterface
      switch(to) {
        case 21: return (void*)(KTextEditor::AnnotationInterface*)(KTextEditor::AnnotationViewInterface*)xptr;
        case 23: return (void*)(KTextEditor::AnnotationViewInterface*)xptr;
        default: return xptr;
      }
    case 24:   //KTextEditor::Attribute
      switch(to) {
        case 112: return (void*)(QTextCharFormat*)(KTextEditor::Attribute*)xptr;
        case 107: return (void*)(QSharedData*)(KTextEditor::Attribute*)xptr;
        case 24: return (void*)(KTextEditor::Attribute*)xptr;
        default: return xptr;
      }
    case 25:   //KTextEditor::CodeCompletionInterface
      switch(to) {
        case 25: return (void*)(KTextEditor::CodeCompletionInterface*)xptr;
        default: return xptr;
      }
    case 26:   //KTextEditor::CodeCompletionModel
      switch(to) {
        case 69: return (void*)(QAbstractItemModel*)(KTextEditor::CodeCompletionModel*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::CodeCompletionModel*)xptr;
        case 26: return (void*)(KTextEditor::CodeCompletionModel*)xptr;
        case 27: return (void*)(KTextEditor::CodeCompletionModel2*)(KTextEditor::CodeCompletionModel*)xptr;
        default: return xptr;
      }
    case 27:   //KTextEditor::CodeCompletionModel2
      switch(to) {
        case 26: return (void*)(KTextEditor::CodeCompletionModel*)(KTextEditor::CodeCompletionModel2*)xptr;
        case 69: return (void*)(QAbstractItemModel*)(KTextEditor::CodeCompletionModel2*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::CodeCompletionModel2*)xptr;
        case 27: return (void*)(KTextEditor::CodeCompletionModel2*)xptr;
        default: return xptr;
      }
    case 28:   //KTextEditor::CodeCompletionModelControllerInterface
      switch(to) {
        case 28: return (void*)(KTextEditor::CodeCompletionModelControllerInterface*)xptr;
        case 29: return (void*)(KTextEditor::CodeCompletionModelControllerInterface2*)(KTextEditor::CodeCompletionModelControllerInterface*)xptr;
        default: return xptr;
      }
    case 29:   //KTextEditor::CodeCompletionModelControllerInterface2
      switch(to) {
        case 28: return (void*)(KTextEditor::CodeCompletionModelControllerInterface*)(KTextEditor::CodeCompletionModelControllerInterface2*)xptr;
        case 29: return (void*)(KTextEditor::CodeCompletionModelControllerInterface2*)xptr;
        default: return xptr;
      }
    case 30:   //KTextEditor::Command
      switch(to) {
        case 30: return (void*)(KTextEditor::Command*)xptr;
        default: return xptr;
      }
    case 31:   //KTextEditor::CommandExtension
      switch(to) {
        case 31: return (void*)(KTextEditor::CommandExtension*)xptr;
        default: return xptr;
      }
    case 32:   //KTextEditor::CommandInterface
      switch(to) {
        case 32: return (void*)(KTextEditor::CommandInterface*)xptr;
        default: return xptr;
      }
    case 33:   //KTextEditor::ConfigInterface
      switch(to) {
        case 33: return (void*)(KTextEditor::ConfigInterface*)xptr;
        default: return xptr;
      }
    case 34:   //KTextEditor::ConfigPage
      switch(to) {
        case 116: return (void*)(QWidget*)(KTextEditor::ConfigPage*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::ConfigPage*)xptr;
        case 34: return (void*)(KTextEditor::ConfigPage*)xptr;
        default: return xptr;
      }
    case 35:   //KTextEditor::ContainerInterface
      switch(to) {
        case 35: return (void*)(KTextEditor::ContainerInterface*)xptr;
        default: return xptr;
      }
    case 36:   //KTextEditor::CoordinatesToCursorInterface
      switch(to) {
        case 36: return (void*)(KTextEditor::CoordinatesToCursorInterface*)xptr;
        default: return xptr;
      }
    case 37:   //KTextEditor::Cursor
      switch(to) {
        case 37: return (void*)(KTextEditor::Cursor*)xptr;
        case 55: return (void*)(KTextEditor::SmartCursor*)(KTextEditor::Cursor*)xptr;
        default: return xptr;
      }
    case 38:   //KTextEditor::Document
      switch(to) {
        case 17: return (void*)(KParts::ReadWritePart*)(KTextEditor::Document*)xptr;
        case 16: return (void*)(KParts::ReadOnlyPart*)(KTextEditor::Document*)xptr;
        case 11: return (void*)(KParts::Part*)(KTextEditor::Document*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::Document*)xptr;
        case 13: return (void*)(KParts::PartBase*)(KTextEditor::Document*)xptr;
        case 68: return (void*)(KXMLGUIClient*)(KTextEditor::Document*)xptr;
        case 38: return (void*)(KTextEditor::Document*)xptr;
        default: return xptr;
      }
    case 39:   //KTextEditor::Editor
      switch(to) {
        case 99: return (void*)(QObject*)(KTextEditor::Editor*)xptr;
        case 39: return (void*)(KTextEditor::Editor*)xptr;
        default: return xptr;
      }
    case 40:   //KTextEditor::EditorChooser
      switch(to) {
        case 116: return (void*)(QWidget*)(KTextEditor::EditorChooser*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::EditorChooser*)xptr;
        case 40: return (void*)(KTextEditor::EditorChooser*)xptr;
        default: return xptr;
      }
    case 41:   //KTextEditor::Factory
      switch(to) {
        case 9: return (void*)(KParts::Factory*)(KTextEditor::Factory*)xptr;
        case 18: return (void*)(KPluginFactory*)(KTextEditor::Factory*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::Factory*)xptr;
        case 41: return (void*)(KTextEditor::Factory*)xptr;
        default: return xptr;
      }
    case 42:   //KTextEditor::HighlightInterface
      switch(to) {
        case 42: return (void*)(KTextEditor::HighlightInterface*)xptr;
        default: return xptr;
      }
    case 43:   //KTextEditor::HighlightInterface::AttributeBlock
      switch(to) {
        case 43: return (void*)(KTextEditor::HighlightInterface::AttributeBlock*)xptr;
        default: return xptr;
      }
    case 44:   //KTextEditor::LoadSaveFilterCheckPlugin
      switch(to) {
        case 99: return (void*)(QObject*)(KTextEditor::LoadSaveFilterCheckPlugin*)xptr;
        case 44: return (void*)(KTextEditor::LoadSaveFilterCheckPlugin*)xptr;
        default: return xptr;
      }
    case 45:   //KTextEditor::Mark
      switch(to) {
        case 45: return (void*)(KTextEditor::Mark*)xptr;
        default: return xptr;
      }
    case 46:   //KTextEditor::MarkInterface
      switch(to) {
        case 46: return (void*)(KTextEditor::MarkInterface*)xptr;
        default: return xptr;
      }
    case 47:   //KTextEditor::MdiContainer
      switch(to) {
        case 47: return (void*)(KTextEditor::MdiContainer*)xptr;
        default: return xptr;
      }
    case 48:   //KTextEditor::ModificationInterface
      switch(to) {
        case 48: return (void*)(KTextEditor::ModificationInterface*)xptr;
        default: return xptr;
      }
    case 49:   //KTextEditor::ParameterizedSessionConfigInterface
      switch(to) {
        case 49: return (void*)(KTextEditor::ParameterizedSessionConfigInterface*)xptr;
        default: return xptr;
      }
    case 50:   //KTextEditor::Plugin
      switch(to) {
        case 99: return (void*)(QObject*)(KTextEditor::Plugin*)xptr;
        case 50: return (void*)(KTextEditor::Plugin*)xptr;
        default: return xptr;
      }
    case 51:   //KTextEditor::Range
      switch(to) {
        case 51: return (void*)(KTextEditor::Range*)xptr;
        case 59: return (void*)(KTextEditor::SmartRange*)(KTextEditor::Range*)xptr;
        default: return xptr;
      }
    case 52:   //KTextEditor::RangeCommand
      switch(to) {
        case 52: return (void*)(KTextEditor::RangeCommand*)xptr;
        default: return xptr;
      }
    case 53:   //KTextEditor::SearchInterface
      switch(to) {
        case 53: return (void*)(KTextEditor::SearchInterface*)xptr;
        default: return xptr;
      }
    case 54:   //KTextEditor::SessionConfigInterface
      switch(to) {
        case 54: return (void*)(KTextEditor::SessionConfigInterface*)xptr;
        default: return xptr;
      }
    case 55:   //KTextEditor::SmartCursor
      switch(to) {
        case 37: return (void*)(KTextEditor::Cursor*)(KTextEditor::SmartCursor*)xptr;
        case 55: return (void*)(KTextEditor::SmartCursor*)xptr;
        default: return xptr;
      }
    case 56:   //KTextEditor::SmartCursorNotifier
      switch(to) {
        case 99: return (void*)(QObject*)(KTextEditor::SmartCursorNotifier*)xptr;
        case 56: return (void*)(KTextEditor::SmartCursorNotifier*)xptr;
        default: return xptr;
      }
    case 57:   //KTextEditor::SmartCursorWatcher
      switch(to) {
        case 57: return (void*)(KTextEditor::SmartCursorWatcher*)xptr;
        default: return xptr;
      }
    case 58:   //KTextEditor::SmartInterface
      switch(to) {
        case 58: return (void*)(KTextEditor::SmartInterface*)xptr;
        default: return xptr;
      }
    case 59:   //KTextEditor::SmartRange
      switch(to) {
        case 51: return (void*)(KTextEditor::Range*)(KTextEditor::SmartRange*)xptr;
        case 59: return (void*)(KTextEditor::SmartRange*)xptr;
        default: return xptr;
      }
    case 60:   //KTextEditor::SmartRangeNotifier
      switch(to) {
        case 99: return (void*)(QObject*)(KTextEditor::SmartRangeNotifier*)xptr;
        case 60: return (void*)(KTextEditor::SmartRangeNotifier*)xptr;
        default: return xptr;
      }
    case 61:   //KTextEditor::SmartRangeWatcher
      switch(to) {
        case 61: return (void*)(KTextEditor::SmartRangeWatcher*)xptr;
        default: return xptr;
      }
    case 62:   //KTextEditor::TemplateInterface
      switch(to) {
        case 62: return (void*)(KTextEditor::TemplateInterface*)xptr;
        default: return xptr;
      }
    case 63:   //KTextEditor::TextHintInterface
      switch(to) {
        case 63: return (void*)(KTextEditor::TextHintInterface*)xptr;
        default: return xptr;
      }
    case 64:   //KTextEditor::VariableInterface
      switch(to) {
        case 64: return (void*)(KTextEditor::VariableInterface*)xptr;
        default: return xptr;
      }
    case 65:   //KTextEditor::View
      switch(to) {
        case 116: return (void*)(QWidget*)(KTextEditor::View*)xptr;
        case 99: return (void*)(QObject*)(KTextEditor::View*)xptr;
        case 68: return (void*)(KXMLGUIClient*)(KTextEditor::View*)xptr;
        case 65: return (void*)(KTextEditor::View*)xptr;
        default: return xptr;
      }
    case 66:   //KTextEditor::ViewBarContainer
      switch(to) {
        case 66: return (void*)(KTextEditor::ViewBarContainer*)xptr;
        default: return xptr;
      }
    case 67:   //KUrl
      switch(to) {
        case 67: return (void*)(KUrl*)xptr;
        default: return xptr;
      }
    case 68:   //KXMLGUIClient
      switch(to) {
        case 68: return (void*)(KXMLGUIClient*)xptr;
        case 38: return (void*)dynamic_cast<KTextEditor::Document*>((KXMLGUIClient*)xptr);
        case 65: return (void*)(KTextEditor::View*)(KXMLGUIClient*)xptr;
        default: return xptr;
      }
    case 69:   //QAbstractItemModel
      switch(to) {
        case 99: return (void*)(QObject*)(QAbstractItemModel*)xptr;
        case 69: return (void*)(QAbstractItemModel*)xptr;
        case 27: return (void*)(KTextEditor::CodeCompletionModel2*)(QAbstractItemModel*)xptr;
        case 26: return (void*)(KTextEditor::CodeCompletionModel*)(QAbstractItemModel*)xptr;
        default: return xptr;
      }
    case 70:   //QAction
      switch(to) {
        case 70: return (void*)(QAction*)xptr;
        default: return xptr;
      }
    case 71:   //QActionEvent
      switch(to) {
        case 71: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 72:   //QBool
      switch(to) {
        case 72: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 73:   //QBrush
      switch(to) {
        case 73: return (void*)(QBrush*)xptr;
        default: return xptr;
      }
    case 74:   //QChar
      switch(to) {
        case 74: return (void*)(QChar*)xptr;
        default: return xptr;
      }
    case 75:   //QChildEvent
      switch(to) {
        case 84: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 75: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 76:   //QCloseEvent
      switch(to) {
        case 76: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 77:   //QContextMenuEvent
      switch(to) {
        case 77: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 78:   //QDomDocument
      switch(to) {
        case 78: return (void*)(QDomDocument*)xptr;
        default: return xptr;
      }
    case 79:   //QDomElement
      switch(to) {
        case 79: return (void*)(QDomElement*)xptr;
        default: return xptr;
      }
    case 80:   //QDragEnterEvent
      switch(to) {
        case 80: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 81:   //QDragLeaveEvent
      switch(to) {
        case 81: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 82:   //QDragMoveEvent
      switch(to) {
        case 82: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 83:   //QDropEvent
      switch(to) {
        case 83: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 84:   //QEvent
      switch(to) {
        case 84: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 85:   //QFocusEvent
      switch(to) {
        case 85: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 86:   //QFont
      switch(to) {
        case 86: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 88:   //QHideEvent
      switch(to) {
        case 88: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 89:   //QIncompatibleFlag
      switch(to) {
        case 89: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 90:   //QInputMethodEvent
      switch(to) {
        case 90: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 91:   //QKeyEvent
      switch(to) {
        case 91: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 92:   //QMenu
      switch(to) {
        case 92: return (void*)(QMenu*)xptr;
        default: return xptr;
      }
    case 93:   //QMetaObject
      switch(to) {
        case 93: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 94:   //QMimeData
      switch(to) {
        case 94: return (void*)(QMimeData*)xptr;
        default: return xptr;
      }
    case 95:   //QModelIndex
      switch(to) {
        case 95: return (void*)(QModelIndex*)xptr;
        default: return xptr;
      }
    case 96:   //QMouseEvent
      switch(to) {
        case 96: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 97:   //QMoveEvent
      switch(to) {
        case 97: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 98:   //QMutex
      switch(to) {
        case 98: return (void*)(QMutex*)xptr;
        default: return xptr;
      }
    case 99:   //QObject
      switch(to) {
        case 99: return (void*)(QObject*)xptr;
        case 22: return (void*)(KTextEditor::AnnotationModel*)(QObject*)xptr;
        case 44: return (void*)(KTextEditor::LoadSaveFilterCheckPlugin*)(QObject*)xptr;
        case 41: return (void*)(KTextEditor::Factory*)(QObject*)xptr;
        case 50: return (void*)(KTextEditor::Plugin*)(QObject*)xptr;
        case 39: return (void*)(KTextEditor::Editor*)(QObject*)xptr;
        case 56: return (void*)(KTextEditor::SmartCursorNotifier*)(QObject*)xptr;
        case 27: return (void*)(KTextEditor::CodeCompletionModel2*)(QObject*)xptr;
        case 38: return (void*)(KTextEditor::Document*)(QObject*)xptr;
        case 26: return (void*)(KTextEditor::CodeCompletionModel*)(QObject*)xptr;
        case 40: return (void*)(KTextEditor::EditorChooser*)(QObject*)xptr;
        case 65: return (void*)(KTextEditor::View*)(QObject*)xptr;
        case 34: return (void*)(KTextEditor::ConfigPage*)(QObject*)xptr;
        case 60: return (void*)(KTextEditor::SmartRangeNotifier*)(QObject*)xptr;
        default: return xptr;
      }
    case 100:   //QPaintEngine
      switch(to) {
        case 100: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 101:   //QPaintEvent
      switch(to) {
        case 101: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 102:   //QPalette
      switch(to) {
        case 102: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 103:   //QPixmap
      switch(to) {
        case 103: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 104:   //QPoint
      switch(to) {
        case 104: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 105:   //QRegExp
      switch(to) {
        case 105: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 106:   //QResizeEvent
      switch(to) {
        case 106: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 107:   //QSharedData
      switch(to) {
        case 107: return (void*)(QSharedData*)xptr;
        case 24: return (void*)(KTextEditor::Attribute*)(QSharedData*)xptr;
        default: return xptr;
      }
    case 108:   //QShowEvent
      switch(to) {
        case 108: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 109:   //QSize
      switch(to) {
        case 109: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 110:   //QStyle
      switch(to) {
        case 110: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 111:   //QTabletEvent
      switch(to) {
        case 111: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 112:   //QTextCharFormat
      switch(to) {
        case 112: return (void*)(QTextCharFormat*)xptr;
        case 24: return (void*)(KTextEditor::Attribute*)(QTextCharFormat*)xptr;
        default: return xptr;
      }
    case 113:   //QTimerEvent
      switch(to) {
        case 84: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 113: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 114:   //QVariant
      switch(to) {
        case 114: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 115:   //QWheelEvent
      switch(to) {
        case 115: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 116:   //QWidget
      switch(to) {
        case 99: return (void*)(QObject*)(QWidget*)xptr;
        case 116: return (void*)(QWidget*)xptr;
        case 40: return (void*)(KTextEditor::EditorChooser*)(QWidget*)xptr;
        case 65: return (void*)(KTextEditor::View*)(QWidget*)xptr;
        case 34: return (void*)(KTextEditor::ConfigPage*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    99, 0,	// 1: QObject
    21, 0,	// 3: KTextEditor::AnnotationInterface
    112, 107, 0,	// 5: QTextCharFormat, QSharedData
    69, 0,	// 8: QAbstractItemModel
    26, 0,	// 10: KTextEditor::CodeCompletionModel
    28, 0,	// 12: KTextEditor::CodeCompletionModelControllerInterface
    116, 0,	// 14: QWidget
    17, 0,	// 16: KParts::ReadWritePart
    9, 0,	// 18: KParts::Factory
    37, 0,	// 20: KTextEditor::Cursor
    51, 0,	// 22: KTextEditor::Range
    116, 68, 0,	// 24: QWidget, KXMLGUIClient
};

// These are the xenum functions for manipulating enum pointers
void xenum_KTextEditor__MarkInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGlobalSpace(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__CodeCompletionModel(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__ModificationInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__SmartCursor(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__HighlightInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__Attribute(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__ViewBarContainer(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__SmartRange(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__View(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__ParameterizedSessionConfigInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KTextEditor__CodeCompletionModelControllerInterface2(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_KTextEditor(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__AnnotationInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__AnnotationModel(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__AnnotationViewInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Attribute(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CodeCompletionInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CodeCompletionModel(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CodeCompletionModel2(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CodeCompletionModelControllerInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CodeCompletionModelControllerInterface2(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Command(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CommandExtension(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CommandInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__ConfigInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__ConfigPage(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__ContainerInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__CoordinatesToCursorInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Cursor(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Document(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Editor(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__EditorChooser(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Factory(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__HighlightInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__HighlightInterface__AttributeBlock(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__LoadSaveFilterCheckPlugin(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Mark(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__MarkInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__MdiContainer(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__ModificationInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__ParameterizedSessionConfigInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Plugin(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__Range(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__RangeCommand(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SearchInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SessionConfigInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartCursor(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartCursorNotifier(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartCursorWatcher(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartRange(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartRangeNotifier(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__SmartRangeWatcher(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__TemplateInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__TextHintInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__VariableInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__View(Smoke::Index, void*, Smoke::Stack);
void xcall_KTextEditor__ViewBarContainer(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "KAboutData", true, 0, 0, 0, 0, 0 },	//1
    { "KAction", true, 0, 0, 0, 0, 0 },	//2
    { "KActionCollection", true, 0, 0, 0, 0, 0 },	//3
    { "KCompletion", true, 0, 0, 0, 0, 0 },	//4
    { "KComponentData", true, 0, 0, 0, 0, 0 },	//5
    { "KConfig", true, 0, 0, 0, 0, 0 },	//6
    { "KConfigGroup", true, 0, 0, 0, 0, 0 },	//7
    { "KIcon", true, 0, 0, 0, 0, 0 },	//8
    { "KParts::Factory", true, 0, 0, 0, 0, 0 },	//9
    { "KParts::GUIActivateEvent", true, 0, 0, 0, 0, 0 },	//10
    { "KParts::Part", true, 0, 0, 0, 0, 0 },	//11
    { "KParts::PartActivateEvent", true, 0, 0, 0, 0, 0 },	//12
    { "KParts::PartBase", true, 0, 0, 0, 0, 0 },	//13
    { "KParts::PartManager", true, 0, 0, 0, 0, 0 },	//14
    { "KParts::PartSelectEvent", true, 0, 0, 0, 0, 0 },	//15
    { "KParts::ReadOnlyPart", true, 0, 0, 0, 0, 0 },	//16
    { "KParts::ReadWritePart", true, 0, 0, 0, 0, 0 },	//17
    { "KPluginFactory", true, 0, 0, 0, 0, 0 },	//18
    { "KService", true, 0, 0, 0, 0, 0 },	//19
    { "KTextEditor", false, 0, xcall_KTextEditor, 0, Smoke::cf_namespace, 0 },	//20
    { "KTextEditor::AnnotationInterface", false, 0, xcall_KTextEditor__AnnotationInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::AnnotationInterface) },	//21
    { "KTextEditor::AnnotationModel", false, 1, xcall_KTextEditor__AnnotationModel, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::AnnotationModel) },	//22
    { "KTextEditor::AnnotationViewInterface", false, 3, xcall_KTextEditor__AnnotationViewInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::AnnotationViewInterface) },	//23
    { "KTextEditor::Attribute", false, 5, xcall_KTextEditor__Attribute, xenum_KTextEditor__Attribute, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::Attribute) },	//24
    { "KTextEditor::CodeCompletionInterface", false, 0, xcall_KTextEditor__CodeCompletionInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::CodeCompletionInterface) },	//25
    { "KTextEditor::CodeCompletionModel", false, 8, xcall_KTextEditor__CodeCompletionModel, xenum_KTextEditor__CodeCompletionModel, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::CodeCompletionModel) },	//26
    { "KTextEditor::CodeCompletionModel2", false, 10, xcall_KTextEditor__CodeCompletionModel2, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::CodeCompletionModel2) },	//27
    { "KTextEditor::CodeCompletionModelControllerInterface", false, 0, xcall_KTextEditor__CodeCompletionModelControllerInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::CodeCompletionModelControllerInterface) },	//28
    { "KTextEditor::CodeCompletionModelControllerInterface2", false, 12, xcall_KTextEditor__CodeCompletionModelControllerInterface2, xenum_KTextEditor__CodeCompletionModelControllerInterface2, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::CodeCompletionModelControllerInterface2) },	//29
    { "KTextEditor::Command", false, 0, xcall_KTextEditor__Command, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::Command) },	//30
    { "KTextEditor::CommandExtension", false, 0, xcall_KTextEditor__CommandExtension, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::CommandExtension) },	//31
    { "KTextEditor::CommandInterface", false, 0, xcall_KTextEditor__CommandInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::CommandInterface) },	//32
    { "KTextEditor::ConfigInterface", false, 0, xcall_KTextEditor__ConfigInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::ConfigInterface) },	//33
    { "KTextEditor::ConfigPage", false, 14, xcall_KTextEditor__ConfigPage, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::ConfigPage) },	//34
    { "KTextEditor::ContainerInterface", false, 0, xcall_KTextEditor__ContainerInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::ContainerInterface) },	//35
    { "KTextEditor::CoordinatesToCursorInterface", false, 0, xcall_KTextEditor__CoordinatesToCursorInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::CoordinatesToCursorInterface) },	//36
    { "KTextEditor::Cursor", false, 0, xcall_KTextEditor__Cursor, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::Cursor) },	//37
    { "KTextEditor::Document", false, 16, xcall_KTextEditor__Document, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::Document) },	//38
    { "KTextEditor::Editor", false, 1, xcall_KTextEditor__Editor, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::Editor) },	//39
    { "KTextEditor::EditorChooser", false, 14, xcall_KTextEditor__EditorChooser, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::EditorChooser) },	//40
    { "KTextEditor::Factory", false, 18, xcall_KTextEditor__Factory, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::Factory) },	//41
    { "KTextEditor::HighlightInterface", false, 0, xcall_KTextEditor__HighlightInterface, xenum_KTextEditor__HighlightInterface, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::HighlightInterface) },	//42
    { "KTextEditor::HighlightInterface::AttributeBlock", false, 0, xcall_KTextEditor__HighlightInterface__AttributeBlock, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KTextEditor::HighlightInterface::AttributeBlock) },	//43
    { "KTextEditor::LoadSaveFilterCheckPlugin", false, 1, xcall_KTextEditor__LoadSaveFilterCheckPlugin, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::LoadSaveFilterCheckPlugin) },	//44
    { "KTextEditor::Mark", false, 0, xcall_KTextEditor__Mark, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KTextEditor::Mark) },	//45
    { "KTextEditor::MarkInterface", false, 0, xcall_KTextEditor__MarkInterface, xenum_KTextEditor__MarkInterface, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::MarkInterface) },	//46
    { "KTextEditor::MdiContainer", false, 0, xcall_KTextEditor__MdiContainer, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::MdiContainer) },	//47
    { "KTextEditor::ModificationInterface", false, 0, xcall_KTextEditor__ModificationInterface, xenum_KTextEditor__ModificationInterface, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::ModificationInterface) },	//48
    { "KTextEditor::ParameterizedSessionConfigInterface", false, 0, xcall_KTextEditor__ParameterizedSessionConfigInterface, xenum_KTextEditor__ParameterizedSessionConfigInterface, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::ParameterizedSessionConfigInterface) },	//49
    { "KTextEditor::Plugin", false, 1, xcall_KTextEditor__Plugin, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::Plugin) },	//50
    { "KTextEditor::Range", false, 0, xcall_KTextEditor__Range, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::Range) },	//51
    { "KTextEditor::RangeCommand", false, 0, xcall_KTextEditor__RangeCommand, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::RangeCommand) },	//52
    { "KTextEditor::SearchInterface", false, 0, xcall_KTextEditor__SearchInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::SearchInterface) },	//53
    { "KTextEditor::SessionConfigInterface", false, 0, xcall_KTextEditor__SessionConfigInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::SessionConfigInterface) },	//54
    { "KTextEditor::SmartCursor", false, 20, xcall_KTextEditor__SmartCursor, xenum_KTextEditor__SmartCursor, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::SmartCursor) },	//55
    { "KTextEditor::SmartCursorNotifier", false, 1, xcall_KTextEditor__SmartCursorNotifier, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::SmartCursorNotifier) },	//56
    { "KTextEditor::SmartCursorWatcher", false, 0, xcall_KTextEditor__SmartCursorWatcher, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::SmartCursorWatcher) },	//57
    { "KTextEditor::SmartInterface", false, 0, xcall_KTextEditor__SmartInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::SmartInterface) },	//58
    { "KTextEditor::SmartRange", false, 22, xcall_KTextEditor__SmartRange, xenum_KTextEditor__SmartRange, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::SmartRange) },	//59
    { "KTextEditor::SmartRangeNotifier", false, 1, xcall_KTextEditor__SmartRangeNotifier, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::SmartRangeNotifier) },	//60
    { "KTextEditor::SmartRangeWatcher", false, 0, xcall_KTextEditor__SmartRangeWatcher, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::SmartRangeWatcher) },	//61
    { "KTextEditor::TemplateInterface", false, 0, xcall_KTextEditor__TemplateInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::TemplateInterface) },	//62
    { "KTextEditor::TextHintInterface", false, 0, xcall_KTextEditor__TextHintInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::TextHintInterface) },	//63
    { "KTextEditor::VariableInterface", false, 0, xcall_KTextEditor__VariableInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::VariableInterface) },	//64
    { "KTextEditor::View", false, 24, xcall_KTextEditor__View, xenum_KTextEditor__View, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTextEditor::View) },	//65
    { "KTextEditor::ViewBarContainer", false, 0, xcall_KTextEditor__ViewBarContainer, xenum_KTextEditor__ViewBarContainer, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTextEditor::ViewBarContainer) },	//66
    { "KUrl", true, 0, 0, 0, 0, 0 },	//67
    { "KXMLGUIClient", true, 0, 0, 0, 0, 0 },	//68
    { "QAbstractItemModel", true, 0, 0, 0, 0, 0 },	//69
    { "QAction", true, 0, 0, 0, 0, 0 },	//70
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//71
    { "QBool", true, 0, 0, 0, 0, 0 },	//72
    { "QBrush", true, 0, 0, 0, 0, 0 },	//73
    { "QChar", true, 0, 0, 0, 0, 0 },	//74
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//75
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//76
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//77
    { "QDomDocument", true, 0, 0, 0, 0, 0 },	//78
    { "QDomElement", true, 0, 0, 0, 0, 0 },	//79
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//80
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//81
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//82
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//83
    { "QEvent", true, 0, 0, 0, 0, 0 },	//84
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//85
    { "QFont", true, 0, 0, 0, 0, 0 },	//86
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, xenum_QGlobalSpace, Smoke::cf_namespace, 0 },	//87
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//88
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//89
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//90
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//91
    { "QMenu", true, 0, 0, 0, 0, 0 },	//92
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//93
    { "QMimeData", true, 0, 0, 0, 0, 0 },	//94
    { "QModelIndex", true, 0, 0, 0, 0, 0 },	//95
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//96
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//97
    { "QMutex", true, 0, 0, 0, 0, 0 },	//98
    { "QObject", true, 0, 0, 0, 0, 0 },	//99
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//100
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//101
    { "QPalette", true, 0, 0, 0, 0, 0 },	//102
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//103
    { "QPoint", true, 0, 0, 0, 0, 0 },	//104
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//105
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//106
    { "QSharedData", true, 0, 0, 0, 0, 0 },	//107
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//108
    { "QSize", true, 0, 0, 0, 0, 0 },	//109
    { "QStyle", true, 0, 0, 0, 0, 0 },	//110
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//111
    { "QTextCharFormat", true, 0, 0, 0, 0, 0 },	//112
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//113
    { "QVariant", true, 0, 0, 0, 0, 0 },	//114
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//115
    { "QWidget", true, 0, 0, 0, 0, 0 },	//116
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "KAction*", 2, Smoke::t_class|Smoke::tf_ptr },	//1
    { "KActionCollection*", 3, Smoke::t_class|Smoke::tf_ptr },	//2
    { "KCompletion*", 4, Smoke::t_class|Smoke::tf_ptr },	//3
    { "KComponentData", 5, Smoke::t_class|Smoke::tf_stack },	//4
    { "KConfig*", 6, Smoke::t_class|Smoke::tf_ptr },	//5
    { "KConfigGroup&", 7, Smoke::t_class|Smoke::tf_ref },	//6
    { "KGlobal::CopyCatalogs", 0, Smoke::t_enum|Smoke::tf_stack },	//7
    { "KIcon", 8, Smoke::t_class|Smoke::tf_stack },	//8
    { "KParts::GUIActivateEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//9
    { "KParts::Part*", 11, Smoke::t_class|Smoke::tf_ptr },	//10
    { "KParts::PartActivateEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//11
    { "KParts::PartManager*", 14, Smoke::t_class|Smoke::tf_ptr },	//12
    { "KParts::PartSelectEvent*", 15, Smoke::t_class|Smoke::tf_ptr },	//13
    { "KService", 19, Smoke::t_class|Smoke::tf_stack },	//14
    { "KSharedPtr<KService>", 0, Smoke::t_voidp|Smoke::tf_stack },	//15
    { "KSharedPtr<KTextEditor::Attribute>", 0, Smoke::t_voidp|Smoke::tf_stack },	//16
    { "KSharedPtr<KTextEditor::Attribute>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//17
    { "KSycocaFactoryId", 87, Smoke::t_enum|Smoke::tf_stack },	//18
    { "KSycocaType", 87, Smoke::t_enum|Smoke::tf_stack },	//19
    { "KTextEditor::AnnotationInterface*", 21, Smoke::t_class|Smoke::tf_ptr },	//20
    { "KTextEditor::AnnotationModel*", 22, Smoke::t_class|Smoke::tf_ptr },	//21
    { "KTextEditor::AnnotationViewInterface*", 23, Smoke::t_class|Smoke::tf_ptr },	//22
    { "KTextEditor::Attribute", 24, Smoke::t_class|Smoke::tf_stack },	//23
    { "KTextEditor::Attribute&", 24, Smoke::t_class|Smoke::tf_ref },	//24
    { "KTextEditor::Attribute*", 24, Smoke::t_class|Smoke::tf_ptr },	//25
    { "KTextEditor::Attribute::ActivationType", 24, Smoke::t_enum|Smoke::tf_stack },	//26
    { "KTextEditor::Attribute::CustomProperties", 24, Smoke::t_enum|Smoke::tf_stack },	//27
    { "KTextEditor::Attribute::Effect", 24, Smoke::t_enum|Smoke::tf_stack },	//28
    { "KTextEditor::Attribute::Effects::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//29
    { "KTextEditor::Attribute::Ptr", 0, Smoke::t_voidp|Smoke::tf_stack },	//30
    { "KTextEditor::CodeCompletionInterface*", 25, Smoke::t_class|Smoke::tf_ptr },	//31
    { "KTextEditor::CodeCompletionModel*", 26, Smoke::t_class|Smoke::tf_ptr },	//32
    { "KTextEditor::CodeCompletionModel2*", 27, Smoke::t_class|Smoke::tf_ptr },	//33
    { "KTextEditor::CodeCompletionModel::Columns", 26, Smoke::t_enum|Smoke::tf_stack },	//34
    { "KTextEditor::CodeCompletionModel::CompletionProperties::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//35
    { "KTextEditor::CodeCompletionModel::CompletionProperty", 26, Smoke::t_enum|Smoke::tf_stack },	//36
    { "KTextEditor::CodeCompletionModel::ExtraItemDataRoles", 26, Smoke::t_enum|Smoke::tf_stack },	//37
    { "KTextEditor::CodeCompletionModel::HighlightMethod", 26, Smoke::t_enum|Smoke::tf_stack },	//38
    { "KTextEditor::CodeCompletionModel::HighlightMethods::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//39
    { "KTextEditor::CodeCompletionModel::InvocationType", 26, Smoke::t_enum|Smoke::tf_stack },	//40
    { "KTextEditor::CodeCompletionModelControllerInterface*", 28, Smoke::t_class|Smoke::tf_ptr },	//41
    { "KTextEditor::CodeCompletionModelControllerInterface2*", 29, Smoke::t_class|Smoke::tf_ptr },	//42
    { "KTextEditor::CodeCompletionModelControllerInterface2::MatchReaction", 29, Smoke::t_enum|Smoke::tf_stack },	//43
    { "KTextEditor::Command*", 30, Smoke::t_class|Smoke::tf_ptr },	//44
    { "KTextEditor::CommandExtension*", 31, Smoke::t_class|Smoke::tf_ptr },	//45
    { "KTextEditor::CommandInterface*", 32, Smoke::t_class|Smoke::tf_ptr },	//46
    { "KTextEditor::ConfigInterface*", 33, Smoke::t_class|Smoke::tf_ptr },	//47
    { "KTextEditor::ConfigPage*", 34, Smoke::t_class|Smoke::tf_ptr },	//48
    { "KTextEditor::ContainerInterface*", 35, Smoke::t_class|Smoke::tf_ptr },	//49
    { "KTextEditor::CoordinatesToCursorInterface*", 36, Smoke::t_class|Smoke::tf_ptr },	//50
    { "KTextEditor::Cursor", 37, Smoke::t_class|Smoke::tf_stack },	//51
    { "KTextEditor::Cursor&", 37, Smoke::t_class|Smoke::tf_ref },	//52
    { "KTextEditor::Cursor*", 37, Smoke::t_class|Smoke::tf_ptr },	//53
    { "KTextEditor::Document*", 38, Smoke::t_class|Smoke::tf_ptr },	//54
    { "KTextEditor::Editor*", 39, Smoke::t_class|Smoke::tf_ptr },	//55
    { "KTextEditor::EditorChooser*", 40, Smoke::t_class|Smoke::tf_ptr },	//56
    { "KTextEditor::Factory*", 41, Smoke::t_class|Smoke::tf_ptr },	//57
    { "KTextEditor::HighlightInterface*", 42, Smoke::t_class|Smoke::tf_ptr },	//58
    { "KTextEditor::HighlightInterface::AttributeBlock", 43, Smoke::t_class|Smoke::tf_stack },	//59
    { "KTextEditor::HighlightInterface::AttributeBlock*", 43, Smoke::t_class|Smoke::tf_ptr },	//60
    { "KTextEditor::HighlightInterface::DefaultStyle", 42, Smoke::t_enum|Smoke::tf_stack },	//61
    { "KTextEditor::LoadSaveFilterCheckPlugin*", 44, Smoke::t_class|Smoke::tf_ptr },	//62
    { "KTextEditor::Mark", 45, Smoke::t_class|Smoke::tf_stack },	//63
    { "KTextEditor::Mark*", 45, Smoke::t_class|Smoke::tf_ptr },	//64
    { "KTextEditor::MarkInterface*", 46, Smoke::t_class|Smoke::tf_ptr },	//65
    { "KTextEditor::MarkInterface::MarkChangeAction", 46, Smoke::t_enum|Smoke::tf_stack },	//66
    { "KTextEditor::MarkInterface::MarkTypes", 46, Smoke::t_enum|Smoke::tf_stack },	//67
    { "KTextEditor::MdiContainer*", 47, Smoke::t_class|Smoke::tf_ptr },	//68
    { "KTextEditor::ModificationInterface*", 48, Smoke::t_class|Smoke::tf_ptr },	//69
    { "KTextEditor::ModificationInterface::ModifiedOnDiskReason", 48, Smoke::t_enum|Smoke::tf_stack },	//70
    { "KTextEditor::ParameterizedSessionConfigInterface*", 49, Smoke::t_class|Smoke::tf_ptr },	//71
    { "KTextEditor::ParameterizedSessionConfigInterface::SessionConfigParameter", 49, Smoke::t_enum|Smoke::tf_stack },	//72
    { "KTextEditor::Plugin*", 50, Smoke::t_class|Smoke::tf_ptr },	//73
    { "KTextEditor::Range", 51, Smoke::t_class|Smoke::tf_stack },	//74
    { "KTextEditor::Range&", 51, Smoke::t_class|Smoke::tf_ref },	//75
    { "KTextEditor::Range*", 51, Smoke::t_class|Smoke::tf_ptr },	//76
    { "KTextEditor::RangeCommand*", 52, Smoke::t_class|Smoke::tf_ptr },	//77
    { "KTextEditor::Search::SearchOptions::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//78
    { "KTextEditor::Search::SearchOptionsEnum", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "KTextEditor::SearchInterface*", 53, Smoke::t_class|Smoke::tf_ptr },	//80
    { "KTextEditor::SessionConfigInterface*", 54, Smoke::t_class|Smoke::tf_ptr },	//81
    { "KTextEditor::SmartCursor&", 55, Smoke::t_class|Smoke::tf_ref },	//82
    { "KTextEditor::SmartCursor*", 55, Smoke::t_class|Smoke::tf_ptr },	//83
    { "KTextEditor::SmartCursor::AdvanceMode", 55, Smoke::t_enum|Smoke::tf_stack },	//84
    { "KTextEditor::SmartCursor::InsertBehavior", 55, Smoke::t_enum|Smoke::tf_stack },	//85
    { "KTextEditor::SmartCursorNotifier*", 56, Smoke::t_class|Smoke::tf_ptr },	//86
    { "KTextEditor::SmartCursorWatcher*", 57, Smoke::t_class|Smoke::tf_ptr },	//87
    { "KTextEditor::SmartInterface*", 58, Smoke::t_class|Smoke::tf_ptr },	//88
    { "KTextEditor::SmartRange&", 59, Smoke::t_class|Smoke::tf_ref },	//89
    { "KTextEditor::SmartRange*", 59, Smoke::t_class|Smoke::tf_ptr },	//90
    { "KTextEditor::SmartRange::InsertBehavior", 59, Smoke::t_enum|Smoke::tf_stack },	//91
    { "KTextEditor::SmartRange::InsertBehaviors::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//92
    { "KTextEditor::SmartRangeNotifier*", 60, Smoke::t_class|Smoke::tf_ptr },	//93
    { "KTextEditor::SmartRangeWatcher*", 61, Smoke::t_class|Smoke::tf_ptr },	//94
    { "KTextEditor::TemplateInterface*", 62, Smoke::t_class|Smoke::tf_ptr },	//95
    { "KTextEditor::TextHintInterface*", 63, Smoke::t_class|Smoke::tf_ptr },	//96
    { "KTextEditor::VariableInterface*", 64, Smoke::t_class|Smoke::tf_ptr },	//97
    { "KTextEditor::View*", 65, Smoke::t_class|Smoke::tf_ptr },	//98
    { "KTextEditor::View::EditMode", 65, Smoke::t_enum|Smoke::tf_stack },	//99
    { "KTextEditor::ViewBarContainer*", 66, Smoke::t_class|Smoke::tf_ptr },	//100
    { "KTextEditor::ViewBarContainer::Position", 66, Smoke::t_enum|Smoke::tf_stack },	//101
    { "KUrl", 67, Smoke::t_class|Smoke::tf_stack },	//102
    { "KXMLGUIClient::ReverseStateChange", 68, Smoke::t_enum|Smoke::tf_stack },	//103
    { "QAction*", 70, Smoke::t_class|Smoke::tf_ptr },	//104
    { "QActionEvent*", 71, Smoke::t_class|Smoke::tf_ptr },	//105
    { "QBool", 72, Smoke::t_class|Smoke::tf_stack },	//106
    { "QBrush", 73, Smoke::t_class|Smoke::tf_stack },	//107
    { "QChar", 74, Smoke::t_class|Smoke::tf_stack },	//108
    { "QChildEvent*", 75, Smoke::t_class|Smoke::tf_ptr },	//109
    { "QCloseEvent*", 76, Smoke::t_class|Smoke::tf_ptr },	//110
    { "QContextMenuEvent*", 77, Smoke::t_class|Smoke::tf_ptr },	//111
    { "QDomDocument", 78, Smoke::t_class|Smoke::tf_stack },	//112
    { "QDragEnterEvent*", 80, Smoke::t_class|Smoke::tf_ptr },	//113
    { "QDragLeaveEvent*", 81, Smoke::t_class|Smoke::tf_ptr },	//114
    { "QDragMoveEvent*", 82, Smoke::t_class|Smoke::tf_ptr },	//115
    { "QDropEvent*", 83, Smoke::t_class|Smoke::tf_ptr },	//116
    { "QEvent*", 84, Smoke::t_class|Smoke::tf_ptr },	//117
    { "QFlags<KTextEditor::Attribute::Effect>", 0, Smoke::t_uint|Smoke::tf_stack },	//118
    { "QFlags<KTextEditor::Attribute::Effects::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//119
    { "QFlags<KTextEditor::CodeCompletionModel::CompletionProperties::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//120
    { "QFlags<KTextEditor::CodeCompletionModel::HighlightMethods::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//121
    { "QFlags<KTextEditor::Search::SearchOptions::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//122
    { "QFlags<KTextEditor::Search::SearchOptionsEnum>", 0, Smoke::t_uint|Smoke::tf_stack },	//123
    { "QFlags<KTextEditor::SmartRange::InsertBehavior>", 0, Smoke::t_uint|Smoke::tf_stack },	//124
    { "QFlags<KTextEditor::SmartRange::InsertBehaviors::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//125
    { "QFlags<Qt::DropAction>", 0, Smoke::t_uint|Smoke::tf_stack },	//126
    { "QFlags<Qt::ItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//127
    { "QFlags<Qt::MatchFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//128
    { "QFocusEvent*", 85, Smoke::t_class|Smoke::tf_ptr },	//129
    { "QHideEvent*", 88, Smoke::t_class|Smoke::tf_ptr },	//130
    { "QIncompatibleFlag", 89, Smoke::t_class|Smoke::tf_stack },	//131
    { "QInputMethodEvent*", 90, Smoke::t_class|Smoke::tf_ptr },	//132
    { "QKeyEvent*", 91, Smoke::t_class|Smoke::tf_ptr },	//133
    { "QList<KTextEditor::Command*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//134
    { "QList<KTextEditor::HighlightInterface::AttributeBlock>", 0, Smoke::t_voidp|Smoke::tf_stack },	//135
    { "QList<KTextEditor::SmartRange*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//136
    { "QList<QModelIndex>", 0, Smoke::t_voidp|Smoke::tf_stack },	//137
    { "QMap<QString,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//138
    { "QMap<QString,QString>*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//139
    { "QMap<int,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//140
    { "QMenu*", 92, Smoke::t_class|Smoke::tf_ptr },	//141
    { "QMetaObject::Call", 93, Smoke::t_enum|Smoke::tf_stack },	//142
    { "QMimeData*", 94, Smoke::t_class|Smoke::tf_ptr },	//143
    { "QModelIndex", 95, Smoke::t_class|Smoke::tf_stack },	//144
    { "QMouseEvent*", 96, Smoke::t_class|Smoke::tf_ptr },	//145
    { "QMoveEvent*", 97, Smoke::t_class|Smoke::tf_ptr },	//146
    { "QMutex*", 98, Smoke::t_class|Smoke::tf_ptr },	//147
    { "QObject*", 99, Smoke::t_class|Smoke::tf_ptr },	//148
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "QPaintEngine*", 100, Smoke::t_class|Smoke::tf_ptr },	//150
    { "QPaintEvent*", 101, Smoke::t_class|Smoke::tf_ptr },	//151
    { "QPixmap", 103, Smoke::t_class|Smoke::tf_stack },	//152
    { "QPoint", 104, Smoke::t_class|Smoke::tf_stack },	//153
    { "QRegExp&", 105, Smoke::t_class|Smoke::tf_ref },	//154
    { "QResizeEvent*", 106, Smoke::t_class|Smoke::tf_ptr },	//155
    { "QShowEvent*", 108, Smoke::t_class|Smoke::tf_ptr },	//156
    { "QSize", 109, Smoke::t_class|Smoke::tf_stack },	//157
    { "QStack<KTextEditor::SmartRange*>*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//158
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//159
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//160
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//161
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//162
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//163
    { "QStyle&", 110, Smoke::t_class|Smoke::tf_ref },	//164
    { "QTabletEvent*", 111, Smoke::t_class|Smoke::tf_ptr },	//165
    { "QTimerEvent*", 113, Smoke::t_class|Smoke::tf_ptr },	//166
    { "QVariant", 114, Smoke::t_class|Smoke::tf_stack },	//167
    { "QVector<KTextEditor::Range>", 0, Smoke::t_voidp|Smoke::tf_stack },	//168
    { "QWheelEvent*", 115, Smoke::t_class|Smoke::tf_ptr },	//169
    { "QWidget*", 116, Smoke::t_class|Smoke::tf_ptr },	//170
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//175
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//214
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//215
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//216
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//217
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//218
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//219
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//220
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//221
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//222
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//223
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//224
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//225
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//226
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//227
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//228
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//229
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//230
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//231
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//232
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//233
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//234
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//235
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//236
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//237
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//238
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//239
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//240
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//241
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//242
    { "QtMsgType", 87, Smoke::t_enum|Smoke::tf_stack },	//243
    { "QtValidLicenseForActiveQtModule", 87, Smoke::t_enum|Smoke::tf_stack },	//244
    { "QtValidLicenseForCoreModule", 87, Smoke::t_enum|Smoke::tf_stack },	//245
    { "QtValidLicenseForDBusModule", 87, Smoke::t_enum|Smoke::tf_stack },	//246
    { "QtValidLicenseForDeclarativeModule", 87, Smoke::t_enum|Smoke::tf_stack },	//247
    { "QtValidLicenseForGuiModule", 87, Smoke::t_enum|Smoke::tf_stack },	//248
    { "QtValidLicenseForHelpModule", 87, Smoke::t_enum|Smoke::tf_stack },	//249
    { "QtValidLicenseForMultimediaModule", 87, Smoke::t_enum|Smoke::tf_stack },	//250
    { "QtValidLicenseForNetworkModule", 87, Smoke::t_enum|Smoke::tf_stack },	//251
    { "QtValidLicenseForOpenGLModule", 87, Smoke::t_enum|Smoke::tf_stack },	//252
    { "QtValidLicenseForOpenVGModule", 87, Smoke::t_enum|Smoke::tf_stack },	//253
    { "QtValidLicenseForQt3SupportLightModule", 87, Smoke::t_enum|Smoke::tf_stack },	//254
    { "QtValidLicenseForQt3SupportModule", 87, Smoke::t_enum|Smoke::tf_stack },	//255
    { "QtValidLicenseForScriptModule", 87, Smoke::t_enum|Smoke::tf_stack },	//256
    { "QtValidLicenseForScriptToolsModule", 87, Smoke::t_enum|Smoke::tf_stack },	//257
    { "QtValidLicenseForSqlModule", 87, Smoke::t_enum|Smoke::tf_stack },	//258
    { "QtValidLicenseForSvgModule", 87, Smoke::t_enum|Smoke::tf_stack },	//259
    { "QtValidLicenseForTestModule", 87, Smoke::t_enum|Smoke::tf_stack },	//260
    { "QtValidLicenseForXmlModule", 87, Smoke::t_enum|Smoke::tf_stack },	//261
    { "QtValidLicenseForXmlPatternsModule", 87, Smoke::t_enum|Smoke::tf_stack },	//262
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//263
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//264
    { "const KAboutData*", 1, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//265
    { "const KComponentData&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//266
    { "const KConfigGroup&", 7, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//267
    { "const KSharedPtr<KTextEditor::Attribute>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//268
    { "const KTextEditor::AnnotationInterface&", 21, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//269
    { "const KTextEditor::AnnotationViewInterface&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//270
    { "const KTextEditor::Attribute&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//271
    { "const KTextEditor::CodeCompletionInterface&", 25, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//272
    { "const KTextEditor::CodeCompletionModelControllerInterface&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//273
    { "const KTextEditor::CodeCompletionModelControllerInterface2&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//274
    { "const KTextEditor::Command&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//275
    { "const KTextEditor::CommandExtension&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//276
    { "const KTextEditor::CommandInterface&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//277
    { "const KTextEditor::ConfigInterface&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//278
    { "const KTextEditor::ContainerInterface&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//279
    { "const KTextEditor::CoordinatesToCursorInterface&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//280
    { "const KTextEditor::Cursor&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//281
    { "const KTextEditor::HighlightInterface&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//282
    { "const KTextEditor::HighlightInterface::AttributeBlock&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//283
    { "const KTextEditor::HighlightInterface::DefaultStyle", 42, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//284
    { "const KTextEditor::Mark&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//285
    { "const KTextEditor::MarkInterface&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//286
    { "const KTextEditor::MdiContainer&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//287
    { "const KTextEditor::ModificationInterface&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//288
    { "const KTextEditor::ParameterizedSessionConfigInterface&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//289
    { "const KTextEditor::Range&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//290
    { "const KTextEditor::RangeCommand&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//291
    { "const KTextEditor::SearchInterface&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//292
    { "const KTextEditor::SessionConfigInterface&", 54, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//293
    { "const KTextEditor::SmartCursor&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//294
    { "const KTextEditor::SmartCursorWatcher&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//295
    { "const KTextEditor::SmartInterface&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//296
    { "const KTextEditor::SmartRange&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//297
    { "const KTextEditor::SmartRange*", 59, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//298
    { "const KTextEditor::SmartRangeWatcher&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//299
    { "const KTextEditor::TemplateInterface&", 62, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//300
    { "const KTextEditor::TextHintInterface&", 63, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//301
    { "const KTextEditor::VariableInterface&", 64, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//302
    { "const KTextEditor::ViewBarContainer&", 66, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//303
    { "const KUrl&", 67, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//304
    { "const QBrush&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//305
    { "const QDomDocument&", 78, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//306
    { "const QDomElement&", 79, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//307
    { "const QFlags<KTextEditor::Search::SearchOptionsEnum>", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//308
    { "const QFont&", 86, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//309
    { "const QHash<int,KTextEditor::Mark*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//310
    { "const QList<KAction*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//311
    { "const QList<KTextEditor::Document*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//312
    { "const QList<KTextEditor::SmartRange*>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//313
    { "const QList<KTextEditor::SmartRange*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//314
    { "const QList<KTextEditor::SmartRangeNotifier*>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//315
    { "const QList<KTextEditor::SmartRangeWatcher*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//316
    { "const QList<KTextEditor::View*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//317
    { "const QList<QModelIndex>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//318
    { "const QList<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//319
    { "const QMap<QString,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//320
    { "const QMap<int,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//321
    { "const QMetaObject&", 93, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//322
    { "const QMetaObject*", 93, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//323
    { "const QMimeData*", 94, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//324
    { "const QModelIndex&", 95, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//325
    { "const QPalette&", 102, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//326
    { "const QPixmap&", 103, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//327
    { "const QPoint&", 104, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//328
    { "const QRegExp&", 105, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//329
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//330
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//331
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//332
    { "const QVariant&", 114, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//333
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//334
    { "const int", 0, Smoke::t_int|Smoke::tf_stack|Smoke::tf_const },	//335
    { "const unsigned int", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//336
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//337
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//338
    { "int&", 0, Smoke::t_voidp|Smoke::tf_ref },	//339
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//340
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//341
    { "unsigned long", 0, Smoke::t_ulong|Smoke::tf_stack },	//342
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//343
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//344
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//345
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    170, 148, 334, 331, 0,	//1  QWidget*, QObject*, const char*, const QStringList&
    148, 334, 331, 0,	//6  QObject*, const char*, const QStringList&
    170, 0,	//10  QWidget*
    12, 0,	//12  KParts::PartManager*
    170, 328, 0,	//14  QWidget*, const QPoint&
    264, 0,	//17  bool
    117, 0,	//19  QEvent*
    11, 0,	//21  KParts::PartActivateEvent*
    13, 0,	//23  KParts::PartSelectEvent*
    266, 0,	//25  const KComponentData&
    266, 264, 0,	//27  const KComponentData&, bool
    304, 0,	//30  const KUrl&
    9, 0,	//32  KParts::GUIActivateEvent*
    334, 170, 148, 319, 330, 0,	//34  const char*, QWidget*, QObject*, const QList<QVariant>&, const QString&
    39, 121, 0,	//40  KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, QFlags<KTextEditor::CodeCompletionModel::HighlightMethods::enum_type>
    92, 92, 0,	//43  KTextEditor::SmartRange::InsertBehaviors::enum_type, KTextEditor::SmartRange::InsertBehaviors::enum_type
    39, 338, 0,	//46  KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, int
    29, 29, 0,	//49  KTextEditor::Attribute::Effects::enum_type, KTextEditor::Attribute::Effects::enum_type
    35, 120, 0,	//52  KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, QFlags<KTextEditor::CodeCompletionModel::CompletionProperties::enum_type>
    92, 338, 0,	//55  KTextEditor::SmartRange::InsertBehaviors::enum_type, int
    92, 125, 0,	//58  KTextEditor::SmartRange::InsertBehaviors::enum_type, QFlags<KTextEditor::SmartRange::InsertBehaviors::enum_type>
    29, 119, 0,	//61  KTextEditor::Attribute::Effects::enum_type, QFlags<KTextEditor::Attribute::Effects::enum_type>
    35, 35, 0,	//64  KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, KTextEditor::CodeCompletionModel::CompletionProperties::enum_type
    29, 338, 0,	//67  KTextEditor::Attribute::Effects::enum_type, int
    334, 0,	//70  const char*
    15, 148, 0,	//72  KSharedPtr<KService>, QObject*
    35, 338, 0,	//75  KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, int
    39, 39, 0,	//78  KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, KTextEditor::CodeCompletionModel::HighlightMethods::enum_type
    21, 0,	//81  KTextEditor::AnnotationModel*
    269, 0,	//83  const KTextEditor::AnnotationInterface&
    334, 334, 0,	//85  const char*, const char*
    334, 334, 338, 0,	//88  const char*, const char*, int
    142, 338, 344, 0,	//92  QMetaObject::Call, int, void**
    338, 206, 0,	//96  int, Qt::ItemDataRole
    338, 0,	//99  int
    98, 141, 338, 0,	//101  KTextEditor::View*, QMenu*, int
    98, 338, 0,	//105  KTextEditor::View*, int
    98, 264, 0,	//108  KTextEditor::View*, bool
    270, 0,	//111  const KTextEditor::AnnotationViewInterface&
    271, 0,	//113  const KTextEditor::Attribute&
    305, 0,	//115  const QBrush&
    26, 0,	//117  KTextEditor::Attribute::ActivationType
    26, 16, 0,	//119  KTextEditor::Attribute::ActivationType, KSharedPtr<KTextEditor::Attribute>
    118, 0,	//122  QFlags<KTextEditor::Attribute::Effect>
    290, 32, 0,	//124  const KTextEditor::Range&, KTextEditor::CodeCompletionModel*
    32, 0,	//127  KTextEditor::CodeCompletionModel*
    272, 0,	//129  const KTextEditor::CodeCompletionInterface&
    148, 0,	//131  QObject*
    98, 290, 40, 0,	//133  KTextEditor::View*, const KTextEditor::Range&, KTextEditor::CodeCompletionModel::InvocationType
    54, 290, 338, 0,	//137  KTextEditor::Document*, const KTextEditor::Range&, int
    325, 0,	//141  const QModelIndex&
    338, 338, 325, 0,	//143  int, int, const QModelIndex&
    32, 264, 0,	//147  KTextEditor::CodeCompletionModel*, bool
    338, 338, 0,	//150  int, int
    54, 290, 325, 0,	//153  KTextEditor::Document*, const KTextEditor::Range&, const QModelIndex&
    98, 330, 264, 281, 0,	//157  KTextEditor::View*, const QString&, bool, const KTextEditor::Cursor&
    98, 281, 0,	//162  KTextEditor::View*, const KTextEditor::Cursor&
    98, 89, 0,	//165  KTextEditor::View*, KTextEditor::SmartRange&
    98, 297, 281, 0,	//168  KTextEditor::View*, const KTextEditor::SmartRange&, const KTextEditor::Cursor&
    98, 297, 330, 0,	//172  KTextEditor::View*, const KTextEditor::SmartRange&, const QString&
    325, 108, 0,	//176  const QModelIndex&, QChar
    98, 0,	//179  KTextEditor::View*
    273, 0,	//181  const KTextEditor::CodeCompletionModelControllerInterface&
    274, 0,	//183  const KTextEditor::CodeCompletionModelControllerInterface2&
    98, 330, 160, 0,	//185  KTextEditor::View*, const QString&, QString&
    275, 0,	//189  const KTextEditor::Command&
    162, 0,	//191  QStringList&
    98, 330, 0,	//193  KTextEditor::View*, const QString&
    330, 0,	//196  const QString&
    276, 0,	//198  const KTextEditor::CommandExtension&
    44, 0,	//200  KTextEditor::Command*
    277, 0,	//202  const KTextEditor::CommandInterface&
    330, 333, 0,	//204  const QString&, const QVariant&
    278, 0,	//207  const KTextEditor::ConfigInterface&
    279, 0,	//209  const KTextEditor::ContainerInterface&
    328, 0,	//211  const QPoint&
    280, 0,	//213  const KTextEditor::CoordinatesToCursorInterface&
    281, 0,	//215  const KTextEditor::Cursor&
    339, 339, 0,	//217  int&, int&
    76, 0,	//220  KTextEditor::Range*
    54, 98, 0,	//222  KTextEditor::Document*, KTextEditor::View*
    54, 0,	//225  KTextEditor::Document*
    54, 264, 0,	//227  KTextEditor::Document*, bool
    290, 264, 0,	//230  const KTextEditor::Range&, bool
    331, 0,	//233  const QStringList&
    281, 330, 264, 0,	//235  const KTextEditor::Cursor&, const QString&, bool
    281, 331, 264, 0,	//239  const KTextEditor::Cursor&, const QStringList&, bool
    290, 330, 264, 0,	//243  const KTextEditor::Range&, const QString&, bool
    290, 331, 264, 0,	//247  const KTextEditor::Range&, const QStringList&, bool
    338, 330, 0,	//251  int, const QString&
    338, 331, 0,	//254  int, const QStringList&
    54, 290, 0,	//257  KTextEditor::Document*, const KTextEditor::Range&
    54, 290, 330, 0,	//260  KTextEditor::Document*, const KTextEditor::Range&, const QString&
    54, 290, 290, 0,	//264  KTextEditor::Document*, const KTextEditor::Range&, const KTextEditor::Range&
    54, 290, 330, 290, 0,	//268  KTextEditor::Document*, const KTextEditor::Range&, const QString&, const KTextEditor::Range&
    290, 0,	//273  const KTextEditor::Range&
    281, 330, 0,	//275  const KTextEditor::Cursor&, const QString&
    281, 331, 0,	//278  const KTextEditor::Cursor&, const QStringList&
    290, 330, 0,	//281  const KTextEditor::Range&, const QString&
    290, 331, 0,	//284  const KTextEditor::Range&, const QStringList&
    5, 0,	//287  KConfig*
    338, 170, 0,	//289  int, QWidget*
    55, 54, 0,	//292  KTextEditor::Editor*, KTextEditor::Document*
    330, 264, 0,	//295  const QString&, bool
    284, 0,	//298  const KTextEditor::HighlightInterface::DefaultStyle
    336, 0,	//300  const unsigned int
    282, 0,	//302  const KTextEditor::HighlightInterface&
    335, 335, 268, 0,	//304  const int, const int, const KSharedPtr<KTextEditor::Attribute>&
    283, 0,	//308  const KTextEditor::HighlightInterface::AttributeBlock&
    268, 0,	//310  const KSharedPtr<KTextEditor::Attribute>&
    285, 0,	//312  const KTextEditor::Mark&
    341, 0,	//314  unsigned int
    338, 341, 0,	//316  int, unsigned int
    67, 327, 0,	//319  KTextEditor::MarkInterface::MarkTypes, const QPixmap&
    67, 0,	//322  KTextEditor::MarkInterface::MarkTypes
    67, 330, 0,	//324  KTextEditor::MarkInterface::MarkTypes, const QString&
    54, 63, 66, 0,	//327  KTextEditor::Document*, KTextEditor::Mark, KTextEditor::MarkInterface::MarkChangeAction
    286, 0,	//331  const KTextEditor::MarkInterface&
    287, 0,	//333  const KTextEditor::MdiContainer&
    70, 0,	//335  KTextEditor::ModificationInterface::ModifiedOnDiskReason
    54, 264, 70, 0,	//337  KTextEditor::Document*, bool, KTextEditor::ModificationInterface::ModifiedOnDiskReason
    288, 0,	//341  const KTextEditor::ModificationInterface&
    267, 342, 0,	//343  const KConfigGroup&, unsigned long
    6, 342, 0,	//346  KConfigGroup&, unsigned long
    289, 0,	//349  const KTextEditor::ParameterizedSessionConfigInterface&
    281, 281, 0,	//351  const KTextEditor::Cursor&, const KTextEditor::Cursor&
    281, 338, 0,	//354  const KTextEditor::Cursor&, int
    281, 338, 338, 0,	//357  const KTextEditor::Cursor&, int, int
    338, 338, 338, 338, 0,	//361  int, int, int, int
    53, 53, 0,	//366  KTextEditor::Cursor*, KTextEditor::Cursor*
    53, 290, 0,	//369  KTextEditor::Cursor*, const KTextEditor::Range&
    53, 0,	//372  KTextEditor::Cursor*
    98, 330, 160, 290, 0,	//374  KTextEditor::View*, const QString&, QString&, const KTextEditor::Range&
    291, 0,	//379  const KTextEditor::RangeCommand&
    290, 330, 308, 0,	//381  const KTextEditor::Range&, const QString&, const QFlags<KTextEditor::Search::SearchOptionsEnum>
    292, 0,	//385  const KTextEditor::SearchInterface&
    267, 0,	//387  const KConfigGroup&
    6, 0,	//389  KConfigGroup&
    293, 0,	//391  const KTextEditor::SessionConfigInterface&
    331, 264, 0,	//393  const QStringList&, bool
    338, 84, 0,	//396  int, KTextEditor::SmartCursor::AdvanceMode
    85, 0,	//399  KTextEditor::SmartCursor::InsertBehavior
    87, 0,	//401  KTextEditor::SmartCursorWatcher*
    294, 0,	//403  const KTextEditor::SmartCursor&
    281, 54, 85, 0,	//405  const KTextEditor::Cursor&, KTextEditor::Document*, KTextEditor::SmartCursor::InsertBehavior
    83, 0,	//409  KTextEditor::SmartCursor*
    83, 264, 0,	//411  KTextEditor::SmartCursor*, bool
    295, 0,	//414  const KTextEditor::SmartCursorWatcher&
    281, 85, 0,	//416  const KTextEditor::Cursor&, KTextEditor::SmartCursor::InsertBehavior
    290, 124, 0,	//419  const KTextEditor::Range&, QFlags<KTextEditor::SmartRange::InsertBehavior>
    338, 338, 85, 0,	//422  int, int, KTextEditor::SmartCursor::InsertBehavior
    290, 90, 124, 0,	//426  const KTextEditor::Range&, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>
    281, 281, 90, 124, 0,	//430  const KTextEditor::Cursor&, const KTextEditor::Cursor&, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>
    338, 338, 338, 338, 90, 124, 0,	//435  int, int, int, int, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>
    83, 83, 90, 124, 0,	//442  KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>
    90, 0,	//447  KTextEditor::SmartRange*
    90, 264, 0,	//449  KTextEditor::SmartRange*, bool
    98, 90, 264, 0,	//452  KTextEditor::View*, KTextEditor::SmartRange*, bool
    98, 90, 0,	//456  KTextEditor::View*, KTextEditor::SmartRange*
    16, 0,	//459  KSharedPtr<KTextEditor::Attribute>
    296, 0,	//461  const KTextEditor::SmartInterface&
    290, 90, 0,	//463  const KTextEditor::Range&, KTextEditor::SmartRange*
    281, 281, 90, 0,	//466  const KTextEditor::Cursor&, const KTextEditor::Cursor&, KTextEditor::SmartRange*
    338, 338, 338, 338, 90, 0,	//470  int, int, int, int, KTextEditor::SmartRange*
    83, 83, 0,	//476  KTextEditor::SmartCursor*, KTextEditor::SmartCursor*
    83, 83, 90, 0,	//479  KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*
    124, 0,	//483  QFlags<KTextEditor::SmartRange::InsertBehavior>
    298, 0,	//485  const KTextEditor::SmartRange*
    281, 158, 158, 0,	//487  const KTextEditor::Cursor&, QStack<KTextEditor::SmartRange*>*, QStack<KTextEditor::SmartRange*>*
    1, 0,	//491  KAction*
    93, 0,	//493  KTextEditor::SmartRangeNotifier*
    94, 0,	//495  KTextEditor::SmartRangeWatcher*
    297, 0,	//497  const KTextEditor::SmartRange&
    281, 158, 0,	//499  const KTextEditor::Cursor&, QStack<KTextEditor::SmartRange*>*
    90, 90, 0,	//502  KTextEditor::SmartRange*, KTextEditor::SmartRange*
    90, 98, 0,	//505  KTextEditor::SmartRange*, KTextEditor::View*
    90, 90, 90, 0,	//508  KTextEditor::SmartRange*, KTextEditor::SmartRange*, KTextEditor::SmartRange*
    90, 30, 30, 0,	//512  KTextEditor::SmartRange*, KTextEditor::Attribute::Ptr, KTextEditor::Attribute::Ptr
    90, 16, 16, 0,	//516  KTextEditor::SmartRange*, KSharedPtr<KTextEditor::Attribute>, KSharedPtr<KTextEditor::Attribute>
    299, 0,	//520  const KTextEditor::SmartRangeWatcher&
    138, 170, 0,	//522  QMap<QString,QString>&, QWidget*
    281, 330, 320, 0,	//525  const KTextEditor::Cursor&, const QString&, const QMap<QString,QString>&
    330, 139, 0,	//529  const QString&, QMap<QString,QString>*
    300, 0,	//532  const KTextEditor::TemplateInterface&
    281, 160, 0,	//534  const KTextEditor::Cursor&, QString&
    301, 0,	//537  const KTextEditor::TextHintInterface&
    54, 330, 330, 0,	//539  KTextEditor::Document*, const QString&, const QString&
    302, 0,	//543  const KTextEditor::VariableInterface&
    98, 99, 0,	//545  KTextEditor::View*, KTextEditor::View::EditMode
    98, 281, 330, 0,	//548  KTextEditor::View*, const KTextEditor::Cursor&, const QString&
    141, 0,	//552  QMenu*
    98, 141, 0,	//554  KTextEditor::View*, QMenu*
    51, 0,	//557  KTextEditor::Cursor
    281, 338, 264, 0,	//559  const KTextEditor::Cursor&, int, bool
    98, 101, 0,	//563  KTextEditor::View*, KTextEditor::ViewBarContainer::Position
    98, 170, 101, 0,	//566  KTextEditor::View*, QWidget*, KTextEditor::ViewBarContainer::Position
    303, 0,	//570  const KTextEditor::ViewBarContainer&
    307, 0,	//572  const QDomElement&
    330, 264, 264, 0,	//574  const QString&, bool, bool
    306, 264, 0,	//578  const QDomDocument&, bool
    330, 103, 0,	//581  const QString&, KXMLGUIClient::ReverseStateChange
    338, 343, 0,	//584  int, void*
    325, 338, 0,	//587  const QModelIndex&, int
    325, 333, 338, 0,	//590  const QModelIndex&, const QVariant&, int
    338, 217, 338, 0,	//594  int, Qt::Orientation, int
    338, 217, 333, 338, 0,	//598  int, Qt::Orientation, const QVariant&, int
    325, 321, 0,	//603  const QModelIndex&, const QMap<int,QVariant>&
    318, 0,	//606  const QList<QModelIndex>&
    324, 193, 338, 338, 325, 0,	//608  const QMimeData*, Qt::DropAction, int, int, const QModelIndex&
    338, 225, 0,	//614  int, Qt::SortOrder
    325, 338, 333, 338, 128, 0,	//617  const QModelIndex&, int, const QVariant&, int, QFlags<Qt::MatchFlag>
    148, 117, 0,	//623  QObject*, QEvent*
    166, 0,	//626  QTimerEvent*
    109, 0,	//628  QChildEvent*
    145, 0,	//630  QMouseEvent*
    169, 0,	//632  QWheelEvent*
    133, 0,	//634  QKeyEvent*
    129, 0,	//636  QFocusEvent*
    151, 0,	//638  QPaintEvent*
    146, 0,	//640  QMoveEvent*
    155, 0,	//642  QResizeEvent*
    110, 0,	//644  QCloseEvent*
    111, 0,	//646  QContextMenuEvent*
    165, 0,	//648  QTabletEvent*
    105, 0,	//650  QActionEvent*
    113, 0,	//652  QDragEnterEvent*
    115, 0,	//654  QDragMoveEvent*
    114, 0,	//656  QDragLeaveEvent*
    116, 0,	//658  QDropEvent*
    156, 0,	//660  QShowEvent*
    130, 0,	//662  QHideEvent*
    263, 0,	//664  _XEvent*
    149, 0,	//666  QPaintDevice::PaintDeviceMetric
    132, 0,	//668  QInputMethodEvent*
    205, 0,	//670  Qt::InputMethodQuery
    164, 0,	//672  QStyle&
    326, 0,	//674  const QPalette&
    309, 0,	//676  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AccessibilityAccept",	//1
    "AccessibilityNext",	//2
    "AccessibilityPrevious",	//3
    "ActivateCaretIn",	//4
    "ActivateMouseIn",	//5
    "AnnotationInterface",	//6
    "AnnotationInterface#",	//7
    "AnnotationModel",	//8
    "AnnotationViewInterface",	//9
    "AnnotationViewInterface#",	//10
    "ArgumentHintDepth",	//11
    "Arguments",	//12
    "Attribute",	//13
    "Attribute#",	//14
    "AttributeBlock",	//15
    "AttributeBlock#",	//16
    "AttributeBlock$$?",	//17
    "AttributeDynamicEffect",	//18
    "AttributeInternalProperty",	//19
    "AttributeUserProperty",	//20
    "AutomaticInvocation",	//21
    "BackgroundFillWhitespace",	//22
    "BestMatchesCount",	//23
    "Bookmark",	//24
    "BottomBar",	//25
    "BreakpointActive",	//26
    "BreakpointDisabled",	//27
    "BreakpointReached",	//28
    "ByCharacter",	//29
    "ByCursorPosition",	//30
    "Class",	//31
    "CodeCompletionInterface",	//32
    "CodeCompletionInterface#",	//33
    "CodeCompletionModel",	//34
    "CodeCompletionModel#",	//35
    "CodeCompletionModel2",	//36
    "CodeCompletionModel2#",	//37
    "CodeCompletionModelControllerInterface",	//38
    "CodeCompletionModelControllerInterface#",	//39
    "CodeCompletionModelControllerInterface2",	//40
    "CodeCompletionModelControllerInterface2#",	//41
    "ColumnCount",	//42
    "Command",	//43
    "Command#",	//44
    "CommandExtension",	//45
    "CommandExtension#",	//46
    "CommandInterface",	//47
    "CommandInterface#",	//48
    "CompletionRole",	//49
    "ConfigInterface",	//50
    "ConfigInterface#",	//51
    "ConfigPage",	//52
    "ConfigPage#",	//53
    "Const",	//54
    "ContainerInterface",	//55
    "ContainerInterface#",	//56
    "CoordinatesToCursorInterface",	//57
    "CoordinatesToCursorInterface#",	//58
    "Cursor",	//59
    "Cursor#",	//60
    "Cursor$$",	//61
    "CustomHighlight",	//62
    "CustomHighlighting",	//63
    "DoNotExpand",	//64
    "DoNotLoadPlugins",	//65
    "Document",	//66
    "Document#",	//67
    "DrawChildren",	//68
    "DrawWindowBackground",	//69
    "EditInsert",	//70
    "EditOverwrite",	//71
    "EditViMode",	//72
    "Editor",	//73
    "Editor#",	//74
    "EditorChooser",	//75
    "EditorChooser#",	//76
    "EffectCycleGradient",	//77
    "EffectFadeIn",	//78
    "EffectFadeOut",	//79
    "EffectNone",	//80
    "EffectPulse",	//81
    "Enum",	//82
    "Error",	//83
    "Execution",	//84
    "ExpandLeft",	//85
    "ExpandRight",	//86
    "ExpandingWidget",	//87
    "Factory",	//88
    "Factory#",	//89
    "FirstProperty",	//90
    "Friend",	//91
    "Function",	//92
    "GlobalScope",	//93
    "GroupIdentifierRole",	//94
    "GroupRole",	//95
    "HideListIfAutomaticInvocation",	//96
    "HighlightInterface",	//97
    "HighlightInterface#",	//98
    "HighlightingMethod",	//99
    "Icon",	//100
    "IgnoreMask",	//101
    "InheritanceDepth",	//102
    "Inline",	//103
    "InternalHighlighting",	//104
    "IsExpandable",	//105
    "ItemSelected",	//106
    "KST_CTimeInfo",	//107
    "KST_KCustom",	//108
    "KST_KDEDesktopMimeType",	//109
    "KST_KFolderMimeType",	//110
    "KST_KImageIO",	//111
    "KST_KImageIOFormat",	//112
    "KST_KMimeType",	//113
    "KST_KMimeTypeEntry",	//114
    "KST_KMimeTypeFactory",	//115
    "KST_KProtocolInfo",	//116
    "KST_KProtocolInfoFactory",	//117
    "KST_KService",	//118
    "KST_KServiceFactory",	//119
    "KST_KServiceGroup",	//120
    "KST_KServiceGroupFactory",	//121
    "KST_KServiceSeparator",	//122
    "KST_KServiceType",	//123
    "KST_KServiceTypeFactory",	//124
    "KST_KSycocaEntry",	//125
    "KTE_INTERNAL_setupIntialValues",	//126
    "KTE_INTERNAL_setupIntialValues$?",	//127
    "LastExtraItemDataRole",	//128
    "LastItemDataRole",	//129
    "LastProperty",	//130
    "LeftBar",	//131
    "LicensedActiveQt",	//132
    "LicensedCore",	//133
    "LicensedDBus",	//134
    "LicensedDeclarative",	//135
    "LicensedGui",	//136
    "LicensedHelp",	//137
    "LicensedMultimedia",	//138
    "LicensedNetwork",	//139
    "LicensedOpenGL",	//140
    "LicensedOpenVG",	//141
    "LicensedQt3Support",	//142
    "LicensedQt3SupportLight",	//143
    "LicensedScript",	//144
    "LicensedScriptTools",	//145
    "LicensedSql",	//146
    "LicensedSvg",	//147
    "LicensedTest",	//148
    "LicensedXml",	//149
    "LicensedXmlPatterns",	//150
    "LoadPlugins",	//151
    "LoadPluginsIfEnabled",	//152
    "LoadSaveFilterCheckPlugin",	//153
    "LoadSaveFilterCheckPlugin#",	//154
    "LocalScope",	//155
    "ManualInvocation",	//156
    "Mark",	//157
    "Mark#",	//158
    "MarkAdded",	//159
    "MarkInterface",	//160
    "MarkInterface#",	//161
    "MarkRemoved",	//162
    "MatchQuality",	//163
    "MdiContainer",	//164
    "MdiContainer#",	//165
    "ModificationInterface",	//166
    "ModificationInterface#",	//167
    "MoveOnInsert",	//168
    "Name",	//169
    "Namespace",	//170
    "NamespaceScope",	//171
    "NoHighlighting",	//172
    "NoProperty",	//173
    "None",	//174
    "OnDiskCreated",	//175
    "OnDiskDeleted",	//176
    "OnDiskModified",	//177
    "OnDiskUnmodified",	//178
    "Outline",	//179
    "Override",	//180
    "ParameterizedSessionConfigInterface",	//181
    "ParameterizedSessionConfigInterface#",	//182
    "Plugin",	//183
    "Plugin#",	//184
    "Postfix",	//185
    "Prefix",	//186
    "Private",	//187
    "Protected",	//188
    "Public",	//189
    "Q_COMPLEX_TYPE",	//190
    "Q_DUMMY_TYPE",	//191
    "Q_MOVABLE_TYPE",	//192
    "Q_PRIMITIVE_TYPE",	//193
    "Q_STATIC_TYPE",	//194
    "QtCriticalMsg",	//195
    "QtDebugMsg",	//196
    "QtFatalMsg",	//197
    "QtSystemMsg",	//198
    "QtWarningMsg",	//199
    "Range",	//200
    "Range#",	//201
    "Range##",	//202
    "Range#$",	//203
    "Range#$$",	//204
    "Range$$$$",	//205
    "RangeCommand",	//206
    "RangeCommand#",	//207
    "RightBar",	//208
    "Scope",	//209
    "ScopeIndex",	//210
    "SearchInterface",	//211
    "SearchInterface#",	//212
    "SelectedBackground",	//213
    "SelectedForeground",	//214
    "SessionConfigInterface",	//215
    "SessionConfigInterface#",	//216
    "SetMatchContext",	//217
    "Signal",	//218
    "SkipEncoding",	//219
    "SkipFolding",	//220
    "SkipHighlighting",	//221
    "SkipMode",	//222
    "SkipNone",	//223
    "SkipUrl",	//224
    "Slot",	//225
    "SmartCursor",	//226
    "SmartCursor##$",	//227
    "SmartCursorNotifier",	//228
    "SmartCursorWatcher",	//229
    "SmartCursorWatcher#",	//230
    "SmartInterface",	//231
    "SmartInterface#",	//232
    "SmartRange",	//233
    "SmartRange##",	//234
    "SmartRange###",	//235
    "SmartRange###$",	//236
    "SmartRangeNotifier",	//237
    "SmartRangeWatcher",	//238
    "SmartRangeWatcher#",	//239
    "StateNoReverse",	//240
    "StateReverse",	//241
    "Static",	//242
    "StayOnInsert",	//243
    "Struct",	//244
    "Template",	//245
    "TemplateInterface",	//246
    "TemplateInterface#",	//247
    "TextHintInterface",	//248
    "TextHintInterface#",	//249
    "TopBar",	//250
    "TypeAlias",	//251
    "UnimportantItemRole",	//252
    "Union",	//253
    "UserInvocation",	//254
    "Variable",	//255
    "VariableInterface",	//256
    "VariableInterface#",	//257
    "View",	//258
    "View#",	//259
    "ViewBarContainer",	//260
    "ViewBarContainer#",	//261
    "Virtual",	//262
    "Warning",	//263
    "abortCompletion",	//264
    "aborted",	//265
    "aborted#",	//266
    "aboutData",	//267
    "aboutToClose",	//268
    "aboutToClose#",	//269
    "aboutToReload",	//270
    "aboutToReload#",	//271
    "action",	//272
    "actionCollection",	//273
    "actionEvent",	//274
    "activeView",	//275
    "addActionsToDocument",	//276
    "addActionsToDocument#",	//277
    "addActionsToView",	//278
    "addActionsToView##",	//279
    "addDocument",	//280
    "addDocument#",	//281
    "addHighlightToDocument",	//282
    "addHighlightToDocument#",	//283
    "addHighlightToDocument#$",	//284
    "addHighlightToView",	//285
    "addHighlightToView##",	//286
    "addHighlightToView##$",	//287
    "addMark",	//288
    "addMark$$",	//289
    "addNotifier",	//290
    "addNotifier#",	//291
    "addView",	//292
    "addView#",	//293
    "addViewBarToLayout",	//294
    "addViewBarToLayout##$",	//295
    "addWatcher",	//296
    "addWatcher#",	//297
    "advance",	//298
    "advance$",	//299
    "advance$$",	//300
    "annotationActivated",	//301
    "annotationActivated#$",	//302
    "annotationBorderVisibilityChanged",	//303
    "annotationBorderVisibilityChanged#$",	//304
    "annotationContextMenuAboutToShow",	//305
    "annotationContextMenuAboutToShow##$",	//306
    "annotationModel",	//307
    "apply",	//308
    "associateAction",	//309
    "associateAction#",	//310
    "associatedActions",	//311
    "atEndOfDocument",	//312
    "atEndOfLine",	//313
    "atStartOfDocument",	//314
    "atStartOfLine",	//315
    "attribute",	//316
    "attributeDynamic",	//317
    "attributeDynamic?",	//318
    "attributeNotDynamic",	//319
    "attributeNotDynamic?",	//320
    "backgroundFillWhitespace",	//321
    "blockSelection",	//322
    "boundaryAtCursor",	//323
    "boundaryAtCursor#",	//324
    "boundaryOnLine",	//325
    "boundaryOnLine$",	//326
    "buddy",	//327
    "canFetchMore",	//328
    "caretEnteredRange",	//329
    "caretEnteredRange##",	//330
    "caretExitedRange",	//331
    "caretExitedRange##",	//332
    "changeEvent",	//333
    "changed",	//334
    "character",	//335
    "character#",	//336
    "characterDeleted",	//337
    "characterDeleted#$",	//338
    "characterInserted",	//339
    "characterInserted#$",	//340
    "checkFeedback",	//341
    "childAfter",	//342
    "childAfter#",	//343
    "childBefore",	//344
    "childBefore#",	//345
    "childEvent",	//346
    "childRangeInserted",	//347
    "childRangeInserted##",	//348
    "childRangeRemoved",	//349
    "childRangeRemoved##",	//350
    "childRanges",	//351
    "clear",	//352
    "clearAndDeleteChildRanges",	//353
    "clearAssociatedActions",	//354
    "clearChildRanges",	//355
    "clearDocumentActions",	//356
    "clearDocumentHighlights",	//357
    "clearMark",	//358
    "clearMark$",	//359
    "clearMarks",	//360
    "clearOnDocumentReload",	//361
    "clearRevision",	//362
    "clearSmartInterface",	//363
    "clearViewActions",	//364
    "clearViewActions#",	//365
    "clearViewHighlights",	//366
    "clearViewHighlights#",	//367
    "closeDocument",	//368
    "closeDocument#",	//369
    "closeEvent",	//370
    "closeUrl",	//371
    "closeView",	//372
    "closeView#",	//373
    "cmds",	//374
    "column",	//375
    "columnCount",	//376
    "columnCount#",	//377
    "columnWidth",	//378
    "commandList",	//379
    "commands",	//380
    "completionInvoked",	//381
    "completionInvoked##$",	//382
    "completionObject",	//383
    "completionObject#$",	//384
    "completionRange",	//385
    "completionRange##",	//386
    "componentData",	//387
    "configDialog",	//388
    "configDialog#",	//389
    "configDialogSupported",	//390
    "configKeys",	//391
    "configPage",	//392
    "configPage$#",	//393
    "configPageFullName",	//394
    "configPageFullName$",	//395
    "configPageIcon",	//396
    "configPageIcon$",	//397
    "configPageName",	//398
    "configPageName$",	//399
    "configPages",	//400
    "configValue",	//401
    "configValue$",	//402
    "confineToRange",	//403
    "confineToRange#",	//404
    "connectNotify",	//405
    "container",	//406
    "contains",	//407
    "contains#",	//408
    "containsColumn",	//409
    "containsColumn$",	//410
    "containsLine",	//411
    "containsLine$",	//412
    "contextMenu",	//413
    "contextMenuAboutToShow",	//414
    "contextMenuAboutToShow##",	//415
    "contextMenuEvent",	//416
    "coordinatesToCursor",	//417
    "coordinatesToCursor#",	//418
    "create",	//419
    "createDocument",	//420
    "createDocument#",	//421
    "createNotifier",	//422
    "createObject",	//423
    "createPartObject",	//424
    "createPlugin",	//425
    "createPlugin?#",	//426
    "createView",	//427
    "createView#",	//428
    "currentRevision",	//429
    "cursorChangedDirectly",	//430
    "cursorChangedDirectly#",	//431
    "cursorInText",	//432
    "cursorInText#",	//433
    "cursorPosition",	//434
    "cursorPositionChanged",	//435
    "cursorPositionChanged##",	//436
    "cursorPositionCoordinates",	//437
    "cursorPositionVirtual",	//438
    "cursorToCoordinate",	//439
    "cursorToCoordinate#",	//440
    "customEvent",	//441
    "data",	//442
    "data$$",	//443
    "deepestRangeContaining",	//444
    "deepestRangeContaining#",	//445
    "deepestRangeContaining#?",	//446
    "deepestRangeContaining#??",	//447
    "deepestRangesContaining",	//448
    "deepestRangesContaining#",	//449
    "defaultContextMenu",	//450
    "defaultContextMenu#",	//451
    "defaultEncoding",	//452
    "defaultStyle",	//453
    "defaultStyle$",	//454
    "defaults",	//455
    "deleteChildRanges",	//456
    "deleteCursors",	//457
    "deleteNotifier",	//458
    "deletePrimaryNotifier",	//459
    "deleteRanges",	//460
    "deleteViewBarForView",	//461
    "deleteViewBarForView#$",	//462
    "deleted",	//463
    "deleted#",	//464
    "depth",	//465
    "devType",	//466
    "disableTextHints",	//467
    "disconnectNotify",	//468
    "dissociateAction",	//469
    "dissociateAction#",	//470
    "document",	//471
    "documentActions",	//472
    "documentCreated",	//473
    "documentCreated##",	//474
    "documentEnd",	//475
    "documentHighlights",	//476
    "documentName",	//477
    "documentNameChanged",	//478
    "documentNameChanged#",	//479
    "documentRange",	//480
    "documentReload",	//481
    "documentSave",	//482
    "documentSaveAs",	//483
    "documentSavedOrUploaded",	//484
    "documentSavedOrUploaded#$",	//485
    "documentUrlChanged",	//486
    "documentUrlChanged#",	//487
    "documents",	//488
    "domDocument",	//489
    "dragEnterEvent",	//490
    "dragLeaveEvent",	//491
    "dragMoveEvent",	//492
    "dropEvent",	//493
    "dropMimeData",	//494
    "dsAlert",	//495
    "dsBaseN",	//496
    "dsChar",	//497
    "dsComment",	//498
    "dsDataType",	//499
    "dsDecVal",	//500
    "dsError",	//501
    "dsFloat",	//502
    "dsFunction",	//503
    "dsKeyword",	//504
    "dsNormal",	//505
    "dsOthers",	//506
    "dsRegionMarker",	//507
    "dsString",	//508
    "dynamicAttribute",	//509
    "dynamicAttribute$",	//510
    "editableMarks",	//511
    "editor",	//512
    "editor$",	//513
    "editor$$",	//514
    "effects",	//515
    "embed",	//516
    "embeddedHighlightingModes",	//517
    "enableTextHints",	//518
    "enableTextHints$",	//519
    "enabledChange",	//520
    "encoding",	//521
    "encompass",	//522
    "encompass#",	//523
    "end",	//524
    "endEditing",	//525
    "endOfLine",	//526
    "endOfLine$",	//527
    "enterEvent",	//528
    "event",	//529
    "eventFilter",	//530
    "exclusiveEditEnd",	//531
    "exclusiveEditEnd#",	//532
    "exclusiveEditStart",	//533
    "exclusiveEditStart#",	//534
    "exec",	//535
    "exec#$$",	//536
    "exec#$$#",	//537
    "executeCompletionItem",	//538
    "executeCompletionItem##$",	//539
    "executeCompletionItem2",	//540
    "executeCompletionItem2###",	//541
    "expandMacros",	//542
    "expandMacros?#",	//543
    "expandToRange",	//544
    "expandToRange#",	//545
    "fetchMore",	//546
    "filterString",	//547
    "filterString###",	//548
    "firstRangeContaining",	//549
    "firstRangeContaining#",	//550
    "flagCompletions",	//551
    "flagCompletions?",	//552
    "flags",	//553
    "focusIn",	//554
    "focusIn#",	//555
    "focusInEvent",	//556
    "focusNextPrevChild",	//557
    "focusOut",	//558
    "focusOut#",	//559
    "focusOutEvent",	//560
    "fontBold",	//561
    "fontChange",	//562
    "forceCompletion",	//563
    "getViewBarParent",	//564
    "getViewBarParent#$",	//565
    "guiActivateEvent",	//566
    "hasAnyProperty",	//567
    "hasChildren",	//568
    "hasGroups",	//569
    "hasGroupsChanged",	//570
    "hasGroupsChanged#$",	//571
    "hasNotifier",	//572
    "hasParent",	//573
    "hasParent#",	//574
    "headerData",	//575
    "heightForWidth",	//576
    "help",	//577
    "help#$$",	//578
    "hideEvent",	//579
    "hideViewBarForView",	//580
    "hideViewBarForView#$",	//581
    "highlightingMode",	//582
    "highlightingModeAt",	//583
    "highlightingModeAt#",	//584
    "highlightingModeChanged",	//585
    "highlightingModeChanged#",	//586
    "highlightingModeSection",	//587
    "highlightingModeSection$",	//588
    "highlightingModes",	//589
    "hitTest",	//590
    "horizontalScrollPositionChanged",	//591
    "horizontalScrollPositionChanged#",	//592
    "index",	//593
    "index$$",	//594
    "index$$#",	//595
    "informationMessage",	//596
    "informationMessage#$",	//597
    "inputMethodEvent",	//598
    "inputMethodQuery",	//599
    "insertBehavior",	//600
    "insertColumns",	//601
    "insertLine",	//602
    "insertLine$$",	//603
    "insertLines",	//604
    "insertLines$?",	//605
    "insertRows",	//606
    "insertTemplateText",	//607
    "insertTemplateText#$?",	//608
    "insertTemplateTextImplementation",	//609
    "insertTemplateTextImplementation#$?",	//610
    "insertText",	//611
    "insertText#$",	//612
    "insertText#$$",	//613
    "insertText#?",	//614
    "insertText#?$",	//615
    "insertText$",	//616
    "insertText?",	//617
    "insertText?$",	//618
    "intersect",	//619
    "intersect#",	//620
    "invalid",	//621
    "isActiveView",	//622
    "isAnnotationBorderVisible",	//623
    "isAutomaticInvocationEnabled",	//624
    "isCompletionActive",	//625
    "isEmpty",	//626
    "isOrphaned",	//627
    "isSmartCursor",	//628
    "isSmartRange",	//629
    "isValid",	//630
    "itemData",	//631
    "itemData#",	//632
    "keyPressEvent",	//633
    "keyReleaseEvent",	//634
    "languageChange",	//635
    "leaveEvent",	//636
    "length",	//637
    "line",	//638
    "line$",	//639
    "lineAttributes",	//640
    "lineAttributes$",	//641
    "lineChanged",	//642
    "lineChanged$",	//643
    "lineLength",	//644
    "lineLength$",	//645
    "lines",	//646
    "localXMLFile",	//647
    "m_column",	//648
    "m_end",	//649
    "m_line",	//650
    "m_range",	//651
    "m_start",	//652
    "mark",	//653
    "mark$",	//654
    "markChanged",	//655
    "markChanged##$",	//656
    "markDescription",	//657
    "markDescription$",	//658
    "markPixmap",	//659
    "markPixmap$",	//660
    "markType01",	//661
    "markType02",	//662
    "markType03",	//663
    "markType04",	//664
    "markType05",	//665
    "markType06",	//666
    "markType07",	//667
    "markType08",	//668
    "markType09",	//669
    "markType10",	//670
    "markType11",	//671
    "markType12",	//672
    "markType13",	//673
    "markType14",	//674
    "markType15",	//675
    "markType16",	//676
    "markType17",	//677
    "markType18",	//678
    "markType19",	//679
    "markType20",	//680
    "markType21",	//681
    "markType22",	//682
    "markType23",	//683
    "markType24",	//684
    "markType25",	//685
    "markType26",	//686
    "markType27",	//687
    "markType28",	//688
    "markType29",	//689
    "markType30",	//690
    "markType31",	//691
    "markType32",	//692
    "marks",	//693
    "marksChanged",	//694
    "marksChanged#",	//695
    "match",	//696
    "matchingItem",	//697
    "matchingItem#",	//698
    "metaObject",	//699
    "metric",	//700
    "mimeData",	//701
    "mimeType",	//702
    "mimeTypes",	//703
    "minimumSizeHint",	//704
    "mode",	//705
    "modeChanged",	//706
    "modeChanged#",	//707
    "modeSection",	//708
    "modeSection$",	//709
    "modes",	//710
    "modifiedChanged",	//711
    "modifiedChanged#",	//712
    "modifiedOnDisk",	//713
    "modifiedOnDisk#$$",	//714
    "mostSpecificRange",	//715
    "mostSpecificRange#",	//716
    "mouseDoubleClickEvent",	//717
    "mouseEnteredRange",	//718
    "mouseEnteredRange##",	//719
    "mouseExitedRange",	//720
    "mouseExitedRange##",	//721
    "mouseMoveEvent",	//722
    "mousePositionChanged",	//723
    "mousePositionChanged##",	//724
    "mousePressEvent",	//725
    "mouseReleaseEvent",	//726
    "mouseTrackingEnabled",	//727
    "moveEvent",	//728
    "needTextHint",	//729
    "needTextHint#$",	//730
    "newSmartCursor",	//731
    "newSmartCursor#",	//732
    "newSmartCursor#$",	//733
    "newSmartCursor$$",	//734
    "newSmartCursor$$$",	//735
    "newSmartRange",	//736
    "newSmartRange#",	//737
    "newSmartRange##",	//738
    "newSmartRange###",	//739
    "newSmartRange###$",	//740
    "newSmartRange##$",	//741
    "newSmartRange$$$$",	//742
    "newSmartRange$$$$#",	//743
    "newSmartRange$$$$#$",	//744
    "notifier",	//745
    "notifiers",	//746
    "numberOfLines",	//747
    "onSingleLine",	//748
    "openFile",	//749
    "openUrl",	//750
    "openingError",	//751
    "openingErrorMessage",	//752
    "operator+=",	//753
    "operator+=#",	//754
    "operator=",	//755
    "operator=#",	//756
    "operator|",	//757
    "operator|?$",	//758
    "operator|??",	//759
    "outline",	//760
    "overlapCount",	//761
    "overlaps",	//762
    "overlaps#",	//763
    "overlapsColumn",	//764
    "overlapsColumn$",	//765
    "overlapsLine",	//766
    "overlapsLine$",	//767
    "paintEngine",	//768
    "paintEvent",	//769
    "paletteChange",	//770
    "parent",	//771
    "parent#",	//772
    "parentRange",	//773
    "parentRangeChanged",	//774
    "parentRangeChanged###",	//775
    "partActivateEvent",	//776
    "partComponentData",	//777
    "partSelectEvent",	//778
    "position",	//779
    "position$$",	//780
    "positionChanged",	//781
    "positionChanged#",	//782
    "positionDeleted",	//783
    "positionDeleted#",	//784
    "positionRelativeToCursor",	//785
    "positionRelativeToCursor#",	//786
    "positionRelativeToLine",	//787
    "positionRelativeToLine$",	//788
    "postLoadFilter",	//789
    "postLoadFilter#",	//790
    "postSaveFilterCheck",	//791
    "postSaveFilterCheck#$",	//792
    "preSavePostDialogFilterCheck",	//793
    "preSavePostDialogFilterCheck#",	//794
    "primaryNotifier",	//795
    "processText",	//796
    "processText#$",	//797
    "qt_metacall",	//798
    "qt_metacall$$?",	//799
    "qt_metacast",	//800
    "qt_metacast$",	//801
    "queryClose",	//802
    "queryCommand",	//803
    "queryCommand$",	//804
    "range",	//805
    "rangeAttributeChanged",	//806
    "rangeAttributeChanged#??",	//807
    "rangeChanged",	//808
    "rangeChanged##",	//809
    "rangeContentsChanged",	//810
    "rangeContentsChanged#",	//811
    "rangeContentsChanged##",	//812
    "rangeDeleted",	//813
    "rangeDeleted#",	//814
    "rangeEliminated",	//815
    "rangeEliminated#",	//816
    "rangePositionChanged",	//817
    "rangePositionChanged#",	//818
    "readAppSetting",	//819
    "readAppSetting$",	//820
    "readConfig",	//821
    "readConfig#",	//822
    "readParameterizedSessionConfig",	//823
    "readParameterizedSessionConfig#$",	//824
    "readSessionConfig",	//825
    "readSessionConfig#",	//826
    "rebuildChildStructure",	//827
    "registerCommand",	//828
    "registerCommand#",	//829
    "registerCompletionModel",	//830
    "registerCompletionModel#",	//831
    "releaseRevision",	//832
    "releaseRevision$",	//833
    "reloaded",	//834
    "reloaded#",	//835
    "removeActionsFromDocument",	//836
    "removeActionsFromDocument#",	//837
    "removeActionsFromView",	//838
    "removeActionsFromView##",	//839
    "removeColumns",	//840
    "removeDocument",	//841
    "removeDocument#",	//842
    "removeHighlightFromDocument",	//843
    "removeHighlightFromDocument#",	//844
    "removeHighlightFromView",	//845
    "removeHighlightFromView##",	//846
    "removeLine",	//847
    "removeLine$",	//848
    "removeMark",	//849
    "removeMark$$",	//850
    "removeNotifier",	//851
    "removeNotifier#",	//852
    "removeRows",	//853
    "removeSelection",	//854
    "removeSelectionText",	//855
    "removeText",	//856
    "removeText#",	//857
    "removeText#$",	//858
    "removeText$",	//859
    "removeView",	//860
    "removeView#",	//861
    "removeWatcher",	//862
    "removeWatcher#",	//863
    "replaceText",	//864
    "replaceText#$",	//865
    "replaceText#$$",	//866
    "replaceText#?",	//867
    "replaceText#?$",	//868
    "replaceText?",	//869
    "replaceText?$",	//870
    "reservedMarkersCount",	//871
    "reset",	//872
    "resizeEvent",	//873
    "revert",	//874
    "rowCount",	//875
    "rowCount#",	//876
    "save",	//877
    "saveAs",	//878
    "saveFile",	//879
    "saveToUrl",	//880
    "searchText",	//881
    "searchText#$",	//882
    "searchText#$$",	//883
    "selectedBackground",	//884
    "selectedForeground",	//885
    "selection",	//886
    "selectionChanged",	//887
    "selectionChanged#",	//888
    "selectionRange",	//889
    "selectionText",	//890
    "setActiveView",	//891
    "setActiveView#",	//892
    "setAnnotationBorderVisible",	//893
    "setAnnotationBorderVisible$",	//894
    "setAnnotationModel",	//895
    "setAnnotationModel#",	//896
    "setAttribute",	//897
    "setAttribute?",	//898
    "setAutomaticInvocationEnabled",	//899
    "setAutomaticInvocationEnabled$",	//900
    "setBackgroundFillWhitespace",	//901
    "setBackgroundFillWhitespace$",	//902
    "setBlockSelection",	//903
    "setBlockSelection$",	//904
    "setBothColumns",	//905
    "setBothColumns$",	//906
    "setBothLines",	//907
    "setBothLines$",	//908
    "setClearOnDocumentReload",	//909
    "setClearOnDocumentReload$",	//910
    "setColumn",	//911
    "setColumn$",	//912
    "setComponentData",	//913
    "setConfigValue",	//914
    "setConfigValue$#",	//915
    "setContainer",	//916
    "setContainer#",	//917
    "setContextMenu",	//918
    "setContextMenu#",	//919
    "setCursorPosition",	//920
    "setCursorPosition#",	//921
    "setDOMDocument",	//922
    "setData",	//923
    "setDefaultEncoding",	//924
    "setDefaultEncoding$",	//925
    "setDynamicAttribute",	//926
    "setDynamicAttribute$?",	//927
    "setEditableMarks",	//928
    "setEditableMarks$",	//929
    "setEffects",	//930
    "setEffects$",	//931
    "setEncoding",	//932
    "setEncoding$",	//933
    "setFontBold",	//934
    "setFontBold$",	//935
    "setHasGroups",	//936
    "setHasGroups$",	//937
    "setHeaderData",	//938
    "setHighlightingMode",	//939
    "setHighlightingMode$",	//940
    "setInsertBehavior",	//941
    "setInsertBehavior$",	//942
    "setItemData",	//943
    "setLength",	//944
    "setLength$",	//945
    "setLine",	//946
    "setLine$",	//947
    "setLocalXMLFile",	//948
    "setM_column",	//949
    "setM_column$",	//950
    "setM_end",	//951
    "setM_end#",	//952
    "setM_line",	//953
    "setM_line$",	//954
    "setM_range",	//955
    "setM_range#",	//956
    "setM_start",	//957
    "setM_start#",	//958
    "setManager",	//959
    "setMark",	//960
    "setMark$$",	//961
    "setMarkDescription",	//962
    "setMarkDescription$$",	//963
    "setMarkPixmap",	//964
    "setMarkPixmap$#",	//965
    "setMode",	//966
    "setMode$",	//967
    "setModified",	//968
    "setModifiedOnDisk",	//969
    "setModifiedOnDisk$",	//970
    "setModifiedOnDiskWarning",	//971
    "setModifiedOnDiskWarning$",	//972
    "setMouseTrackingEnabled",	//973
    "setMouseTrackingEnabled$",	//974
    "setOpeningError",	//975
    "setOpeningError$",	//976
    "setOpeningErrorMessage",	//977
    "setOpeningErrorMessage$",	//978
    "setOrphaned",	//979
    "setOrphaned$",	//980
    "setOutline",	//981
    "setOutline#",	//982
    "setParentRange",	//983
    "setParentRange#",	//984
    "setPosition",	//985
    "setPosition#",	//986
    "setPosition$$",	//987
    "setRange",	//988
    "setRange#",	//989
    "setRange##",	//990
    "setReadWrite",	//991
    "setRowCount",	//992
    "setRowCount$",	//993
    "setSelectable",	//994
    "setSelectedBackground",	//995
    "setSelectedBackground#",	//996
    "setSelectedForeground",	//997
    "setSelectedForeground#",	//998
    "setSelection",	//999
    "setSelection#",	//1000
    "setSelection#$",	//1001
    "setSelection#$$",	//1002
    "setSimpleMode",	//1003
    "setSimpleMode$",	//1004
    "setStart",	//1005
    "setStart$",	//1006
    "setSuppressOpeningErrorDialogs",	//1007
    "setSuppressOpeningErrorDialogs$",	//1008
    "setText",	//1009
    "setText$",	//1010
    "setText?",	//1011
    "setType",	//1012
    "setType$",	//1013
    "setVisible",	//1014
    "setWantsDirectChanges",	//1015
    "setWantsDirectChanges$",	//1016
    "setWatcher",	//1017
    "setWatcher#",	//1018
    "setWidget",	//1019
    "setXML",	//1020
    "setXMLFile",	//1021
    "setupTranslations",	//1022
    "shouldAbortCompletion",	//1023
    "shouldAbortCompletion##$",	//1024
    "shouldExecute",	//1025
    "shouldExecute##",	//1026
    "shouldStartCompletion",	//1027
    "shouldStartCompletion#$$#",	//1028
    "showEvent",	//1029
    "showViewBarForView",	//1030
    "showViewBarForView#$",	//1031
    "simpleMode",	//1032
    "sizeHint",	//1033
    "slotModifiedOnDisk",	//1034
    "slotModifiedOnDisk#",	//1035
    "smartEnd",	//1036
    "smartMutex",	//1037
    "smartRange",	//1038
    "smartStart",	//1039
    "sort",	//1040
    "span",	//1041
    "start",	//1042
    "startCompletion",	//1043
    "startCompletion##",	//1044
    "startEditing",	//1045
    "stateChanged",	//1046
    "staticMetaObject",	//1047
    "styleChange",	//1048
    "submit",	//1049
    "supportedDropActions",	//1050
    "supportedSearchOptions",	//1051
    "supportsRange",	//1052
    "supportsRange$",	//1053
    "suppressOpeningErrorDialogs",	//1054
    "tabletEvent",	//1055
    "text",	//1056
    "text#",	//1057
    "text#$",	//1058
    "text$",	//1059
    "textChanged",	//1060
    "textChanged#",	//1061
    "textChanged###",	//1062
    "textChanged##$#",	//1063
    "textInserted",	//1064
    "textInserted##",	//1065
    "textInserted##$",	//1066
    "textLines",	//1067
    "textLines#",	//1068
    "textLines#$",	//1069
    "textRemoved",	//1070
    "textRemoved##",	//1071
    "textRemoved##$",	//1072
    "timerEvent",	//1073
    "toSmartCursor",	//1074
    "toSmartRange",	//1075
    "topParentRange",	//1076
    "totalCharacters",	//1077
    "tr",	//1078
    "tr$",	//1079
    "tr$$",	//1080
    "tr$$$",	//1081
    "trUtf8",	//1082
    "trUtf8$",	//1083
    "trUtf8$$",	//1084
    "trUtf8$$$",	//1085
    "translateFromRevision",	//1086
    "translateFromRevision#",	//1087
    "translateFromRevision#$",	//1088
    "type",	//1089
    "unbindSmartRange",	//1090
    "unbindSmartRange#",	//1091
    "unregisterCommand",	//1092
    "unregisterCommand#",	//1093
    "unregisterCompletionModel",	//1094
    "unregisterCompletionModel#",	//1095
    "updateCompletionRange",	//1096
    "updateCompletionRange##",	//1097
    "useRevision",	//1098
    "useRevision$",	//1099
    "variable",	//1100
    "variable$",	//1101
    "variableChanged",	//1102
    "variableChanged#$$",	//1103
    "verticalScrollPositionChanged",	//1104
    "verticalScrollPositionChanged##",	//1105
    "viewActions",	//1106
    "viewActions#",	//1107
    "viewCreated",	//1108
    "viewCreated##",	//1109
    "viewEditMode",	//1110
    "viewEditModeChanged",	//1111
    "viewEditModeChanged#$",	//1112
    "viewHighlights",	//1113
    "viewHighlights#",	//1114
    "viewMode",	//1115
    "viewModeChanged",	//1116
    "viewModeChanged#",	//1117
    "views",	//1118
    "virtual_hook",	//1119
    "waitForReset",	//1120
    "wantsDirectChanges",	//1121
    "wantsToProcessText",	//1122
    "wantsToProcessText$",	//1123
    "watcher",	//1124
    "watchers",	//1125
    "wheelEvent",	//1126
    "widget",	//1127
    "windowActivationChange",	//1128
    "writeAppSetting",	//1129
    "writeAppSetting$",	//1130
    "writeConfig",	//1131
    "writeConfig#",	//1132
    "writeParameterizedSessionConfig",	//1133
    "writeParameterizedSessionConfig#$",	//1134
    "writeSessionConfig",	//1135
    "writeSessionConfig#",	//1136
    "x11Event",	//1137
    "xmlFile",	//1138
    "~AnnotationInterface",	//1139
    "~AnnotationModel",	//1140
    "~AnnotationViewInterface",	//1141
    "~Attribute",	//1142
    "~AttributeBlock",	//1143
    "~CodeCompletionInterface",	//1144
    "~CodeCompletionModel",	//1145
    "~CodeCompletionModel2",	//1146
    "~CodeCompletionModelControllerInterface",	//1147
    "~CodeCompletionModelControllerInterface2",	//1148
    "~Command",	//1149
    "~CommandExtension",	//1150
    "~CommandInterface",	//1151
    "~ConfigInterface",	//1152
    "~ConfigPage",	//1153
    "~ContainerInterface",	//1154
    "~CoordinatesToCursorInterface",	//1155
    "~Cursor",	//1156
    "~Document",	//1157
    "~Editor",	//1158
    "~EditorChooser",	//1159
    "~Factory",	//1160
    "~HighlightInterface",	//1161
    "~LoadSaveFilterCheckPlugin",	//1162
    "~Mark",	//1163
    "~MarkInterface",	//1164
    "~MdiContainer",	//1165
    "~ModificationInterface",	//1166
    "~ParameterizedSessionConfigInterface",	//1167
    "~Plugin",	//1168
    "~Range",	//1169
    "~RangeCommand",	//1170
    "~SearchInterface",	//1171
    "~SessionConfigInterface",	//1172
    "~SmartCursor",	//1173
    "~SmartCursorNotifier",	//1174
    "~SmartCursorWatcher",	//1175
    "~SmartInterface",	//1176
    "~SmartRange",	//1177
    "~SmartRangeNotifier",	//1178
    "~SmartRangeWatcher",	//1179
    "~TemplateInterface",	//1180
    "~TextHintInterface",	//1181
    "~VariableInterface",	//1182
    "~View",	//1183
    "~ViewBarContainer",	//1184
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {9, 777, 0, 0, Smoke::mf_virtual, 4, 0},	//1 KParts::Factory::partComponentData()
    {9, 424, 1, 4, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 10, 0},	//2 KParts::Factory::createPartObject(QWidget*, QObject*, const char*, const QStringList&) [pure virtual]
    {9, 423, 6, 3, Smoke::mf_protected|Smoke::mf_virtual, 148, 0},	//3 KParts::Factory::createObject(QObject*, const char*, const QStringList&)
    {11, 516, 10, 1, Smoke::mf_virtual, 0, 0},	//4 KParts::Part::embed(QWidget*)
    {11, 1127, 0, 0, Smoke::mf_virtual, 170, 0},	//5 KParts::Part::widget()
    {11, 959, 12, 1, Smoke::mf_virtual, 0, 0},	//6 KParts::Part::setManager(KParts::PartManager*)
    {11, 590, 14, 2, Smoke::mf_virtual, 10, 0},	//7 KParts::Part::hitTest(QWidget*, const QPoint&)
    {11, 994, 17, 1, Smoke::mf_virtual, 0, 0},	//8 KParts::Part::setSelectable(bool)
    {11, 1019, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//9 KParts::Part::setWidget(QWidget*)
    {11, 441, 19, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//10 KParts::Part::customEvent(QEvent*)
    {11, 776, 21, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//11 KParts::Part::partActivateEvent(KParts::PartActivateEvent*)
    {11, 778, 23, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//12 KParts::Part::partSelectEvent(KParts::PartSelectEvent*)
    {13, 913, 25, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//13 KParts::PartBase::setComponentData(const KComponentData&)
    {13, 913, 27, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//14 KParts::PartBase::setComponentData(const KComponentData&, bool)
    {16, 750, 30, 1, Smoke::mf_virtual|Smoke::mf_slot, 264, 0},	//15 KParts::ReadOnlyPart::openUrl(const KUrl&)
    {16, 749, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 264, 0},	//16 KParts::ReadOnlyPart::openFile()
    {16, 566, 32, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//17 KParts::ReadOnlyPart::guiActivateEvent(KParts::GUIActivateEvent*)
    {17, 991, 17, 1, Smoke::mf_virtual, 0, 0},	//18 KParts::ReadWritePart::setReadWrite(bool)
    {17, 802, 0, 0, Smoke::mf_virtual, 264, 0},	//19 KParts::ReadWritePart::queryClose()
    {17, 371, 0, 0, Smoke::mf_virtual, 264, 0},	//20 KParts::ReadWritePart::closeUrl()
    {17, 371, 17, 1, Smoke::mf_virtual, 264, 0},	//21 KParts::ReadWritePart::closeUrl(bool)
    {17, 878, 30, 1, Smoke::mf_virtual, 264, 0},	//22 KParts::ReadWritePart::saveAs(const KUrl&)
    {17, 968, 17, 1, Smoke::mf_virtual, 0, 0},	//23 KParts::ReadWritePart::setModified(bool)
    {17, 877, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 264, 0},	//24 KParts::ReadWritePart::save()
    {17, 879, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 0},	//25 KParts::ReadWritePart::saveFile() [pure virtual]
    {17, 880, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 264, 0},	//26 KParts::ReadWritePart::saveToUrl()
    {18, 1022, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//27 KPluginFactory::setupTranslations()
    {18, 419, 34, 5, Smoke::mf_protected|Smoke::mf_virtual, 148, 0},	//28 KPluginFactory::create(const char*, QWidget*, QObject*, const QList<QVariant>&, const QString&)
    {20, 757, 40, 2, Smoke::mf_static, 121, 1},	//29 KTextEditor::operator|(KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, QFlags<KTextEditor::CodeCompletionModel::HighlightMethods::enum_type>)
    {20, 757, 43, 2, Smoke::mf_static, 125, 2},	//30 KTextEditor::operator|(KTextEditor::SmartRange::InsertBehaviors::enum_type, KTextEditor::SmartRange::InsertBehaviors::enum_type)
    {20, 757, 46, 2, Smoke::mf_static, 131, 3},	//31 KTextEditor::operator|(KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, int)
    {20, 757, 49, 2, Smoke::mf_static, 119, 4},	//32 KTextEditor::operator|(KTextEditor::Attribute::Effects::enum_type, KTextEditor::Attribute::Effects::enum_type)
    {20, 757, 52, 2, Smoke::mf_static, 120, 5},	//33 KTextEditor::operator|(KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, QFlags<KTextEditor::CodeCompletionModel::CompletionProperties::enum_type>)
    {20, 757, 55, 2, Smoke::mf_static, 131, 6},	//34 KTextEditor::operator|(KTextEditor::SmartRange::InsertBehaviors::enum_type, int)
    {20, 757, 58, 2, Smoke::mf_static, 125, 7},	//35 KTextEditor::operator|(KTextEditor::SmartRange::InsertBehaviors::enum_type, QFlags<KTextEditor::SmartRange::InsertBehaviors::enum_type>)
    {20, 757, 61, 2, Smoke::mf_static, 119, 8},	//36 KTextEditor::operator|(KTextEditor::Attribute::Effects::enum_type, QFlags<KTextEditor::Attribute::Effects::enum_type>)
    {20, 757, 64, 2, Smoke::mf_static, 120, 9},	//37 KTextEditor::operator|(KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, KTextEditor::CodeCompletionModel::CompletionProperties::enum_type)
    {20, 757, 67, 2, Smoke::mf_static, 131, 10},	//38 KTextEditor::operator|(KTextEditor::Attribute::Effects::enum_type, int)
    {20, 512, 70, 1, Smoke::mf_static, 55, 11},	//39 KTextEditor::editor(const char*)
    {20, 425, 72, 2, Smoke::mf_static, 73, 12},	//40 KTextEditor::createPlugin(KSharedPtr<KService>, QObject*)
    {20, 757, 75, 2, Smoke::mf_static, 131, 13},	//41 KTextEditor::operator|(KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, int)
    {20, 757, 78, 2, Smoke::mf_static, 121, 14},	//42 KTextEditor::operator|(KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, KTextEditor::CodeCompletionModel::HighlightMethods::enum_type)
    {21, 895, 81, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//43 KTextEditor::AnnotationInterface::setAnnotationModel(KTextEditor::AnnotationModel*) [pure virtual]
    {21, 307, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 21, 2},	//44 KTextEditor::AnnotationInterface::annotationModel() const [pure virtual]
    {21, 6, 0, 0, Smoke::mf_ctor, 20, 3},	//45 KTextEditor::AnnotationInterface::AnnotationInterface()
    {21, 6, 83, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 20, 4},	//46 KTextEditor::AnnotationInterface::AnnotationInterface(const KTextEditor::AnnotationInterface&)
    {21, 1139, 0, 0, Smoke::mf_dtor, 0, 5 },	//47 KTextEditor::AnnotationInterface::~AnnotationInterface()
    {22, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//48 KTextEditor::AnnotationModel::metaObject() const
    {22, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//49 KTextEditor::AnnotationModel::qt_metacast(const char*)
    {22, 1078, 85, 2, Smoke::mf_static, 159, 3},	//50 KTextEditor::AnnotationModel::tr(const char*, const char*)
    {22, 1082, 85, 2, Smoke::mf_static, 159, 4},	//51 KTextEditor::AnnotationModel::trUtf8(const char*, const char*)
    {22, 1078, 88, 3, Smoke::mf_static, 159, 5},	//52 KTextEditor::AnnotationModel::tr(const char*, const char*, int)
    {22, 1082, 88, 3, Smoke::mf_static, 159, 6},	//53 KTextEditor::AnnotationModel::trUtf8(const char*, const char*, int)
    {22, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//54 KTextEditor::AnnotationModel::qt_metacall(QMetaObject::Call, int, void**)
    {22, 442, 96, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 167, 8},	//55 KTextEditor::AnnotationModel::data(int, Qt::ItemDataRole) const [pure virtual]
    {22, 872, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//56 KTextEditor::AnnotationModel::reset()
    {22, 642, 99, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 10},	//57 KTextEditor::AnnotationModel::lineChanged(int)
    {22, 8, 0, 0, Smoke::mf_ctor, 21, 11},	//58 KTextEditor::AnnotationModel::AnnotationModel()
    {22, 1078, 70, 1, Smoke::mf_static, 159, 12},	//59 KTextEditor::AnnotationModel::tr(const char*)
    {22, 1082, 70, 1, Smoke::mf_static, 159, 13},	//60 KTextEditor::AnnotationModel::trUtf8(const char*)
    {22, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 14},	//61 KTextEditor::AnnotationModel::staticMetaObject() const
    {22, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 340, 15},	//62 KTextEditor::AnnotationModel::GroupIdentifierRole (enum)
    {22, 1140, 0, 0, Smoke::mf_dtor, 0, 16 },	//63 KTextEditor::AnnotationModel::~AnnotationModel()
    {23, 893, 17, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//64 KTextEditor::AnnotationViewInterface::setAnnotationBorderVisible(bool) [pure virtual]
    {23, 623, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 2},	//65 KTextEditor::AnnotationViewInterface::isAnnotationBorderVisible() const [pure virtual]
    {23, 305, 101, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//66 KTextEditor::AnnotationViewInterface::annotationContextMenuAboutToShow(KTextEditor::View*, QMenu*, int) [pure virtual]
    {23, 301, 105, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//67 KTextEditor::AnnotationViewInterface::annotationActivated(KTextEditor::View*, int) [pure virtual]
    {23, 303, 108, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//68 KTextEditor::AnnotationViewInterface::annotationBorderVisibilityChanged(KTextEditor::View*, bool) [pure virtual]
    {23, 9, 0, 0, Smoke::mf_ctor, 22, 6},	//69 KTextEditor::AnnotationViewInterface::AnnotationViewInterface()
    {23, 9, 111, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 22, 7},	//70 KTextEditor::AnnotationViewInterface::AnnotationViewInterface(const KTextEditor::AnnotationViewInterface&)
    {23, 1141, 0, 0, Smoke::mf_dtor, 0, 8 },	//71 KTextEditor::AnnotationViewInterface::~AnnotationViewInterface()
    {24, 13, 0, 0, Smoke::mf_ctor, 25, 1},	//72 KTextEditor::Attribute::Attribute()
    {24, 13, 113, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 25, 2},	//73 KTextEditor::Attribute::Attribute(const KTextEditor::Attribute&)
    {24, 561, 0, 0, Smoke::mf_const, 264, 3},	//74 KTextEditor::Attribute::fontBold() const
    {24, 934, 17, 1, 0, 0, 4},	//75 KTextEditor::Attribute::setFontBold(bool)
    {24, 760, 0, 0, Smoke::mf_const, 107, 5},	//76 KTextEditor::Attribute::outline() const
    {24, 981, 115, 1, 0, 0, 6},	//77 KTextEditor::Attribute::setOutline(const QBrush&)
    {24, 885, 0, 0, Smoke::mf_const, 107, 7},	//78 KTextEditor::Attribute::selectedForeground() const
    {24, 997, 115, 1, 0, 0, 8},	//79 KTextEditor::Attribute::setSelectedForeground(const QBrush&)
    {24, 884, 0, 0, Smoke::mf_const, 107, 9},	//80 KTextEditor::Attribute::selectedBackground() const
    {24, 995, 115, 1, 0, 0, 10},	//81 KTextEditor::Attribute::setSelectedBackground(const QBrush&)
    {24, 321, 0, 0, Smoke::mf_const, 264, 11},	//82 KTextEditor::Attribute::backgroundFillWhitespace() const
    {24, 901, 17, 1, 0, 0, 12},	//83 KTextEditor::Attribute::setBackgroundFillWhitespace(bool)
    {24, 352, 0, 0, 0, 0, 13},	//84 KTextEditor::Attribute::clear()
    {24, 567, 0, 0, Smoke::mf_const, 264, 14},	//85 KTextEditor::Attribute::hasAnyProperty() const
    {24, 311, 0, 0, Smoke::mf_const, 311, 15},	//86 KTextEditor::Attribute::associatedActions() const
    {24, 354, 0, 0, 0, 0, 16},	//87 KTextEditor::Attribute::clearAssociatedActions()
    {24, 509, 117, 1, Smoke::mf_const, 16, 17},	//88 KTextEditor::Attribute::dynamicAttribute(KTextEditor::Attribute::ActivationType) const
    {24, 926, 119, 2, 0, 0, 18},	//89 KTextEditor::Attribute::setDynamicAttribute(KTextEditor::Attribute::ActivationType, KSharedPtr<KTextEditor::Attribute>)
    {24, 515, 0, 0, Smoke::mf_const, 118, 19},	//90 KTextEditor::Attribute::effects() const
    {24, 930, 122, 1, 0, 0, 20},	//91 KTextEditor::Attribute::setEffects(QFlags<KTextEditor::Attribute::Effect>)
    {24, 753, 113, 1, 0, 24, 21},	//92 KTextEditor::Attribute::operator+=(const KTextEditor::Attribute&)
    {24, 755, 113, 1, 0, 24, 22},	//93 KTextEditor::Attribute::operator=(const KTextEditor::Attribute&)
    {24, 934, 0, 0, 0, 0, 23},	//94 KTextEditor::Attribute::setFontBold()
    {24, 179, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 24},	//95 KTextEditor::Attribute::Outline (enum)
    {24, 214, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 25},	//96 KTextEditor::Attribute::SelectedForeground (enum)
    {24, 213, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 26},	//97 KTextEditor::Attribute::SelectedBackground (enum)
    {24, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 27},	//98 KTextEditor::Attribute::BackgroundFillWhitespace (enum)
    {24, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 28},	//99 KTextEditor::Attribute::AttributeDynamicEffect (enum)
    {24, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 29},	//100 KTextEditor::Attribute::AttributeInternalProperty (enum)
    {24, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 30},	//101 KTextEditor::Attribute::AttributeUserProperty (enum)
    {24, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 31},	//102 KTextEditor::Attribute::ActivateMouseIn (enum)
    {24, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 32},	//103 KTextEditor::Attribute::ActivateCaretIn (enum)
    {24, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 33},	//104 KTextEditor::Attribute::EffectNone (enum)
    {24, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 34},	//105 KTextEditor::Attribute::EffectFadeIn (enum)
    {24, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 35},	//106 KTextEditor::Attribute::EffectFadeOut (enum)
    {24, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 36},	//107 KTextEditor::Attribute::EffectPulse (enum)
    {24, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 37},	//108 KTextEditor::Attribute::EffectCycleGradient (enum)
    {24, 1142, 0, 0, Smoke::mf_dtor, 0, 38 },	//109 KTextEditor::Attribute::~Attribute()
    {25, 625, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 1},	//110 KTextEditor::CodeCompletionInterface::isCompletionActive() const [pure virtual]
    {25, 1043, 124, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//111 KTextEditor::CodeCompletionInterface::startCompletion(const KTextEditor::Range&, KTextEditor::CodeCompletionModel*) [pure virtual]
    {25, 264, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//112 KTextEditor::CodeCompletionInterface::abortCompletion() [pure virtual]
    {25, 563, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//113 KTextEditor::CodeCompletionInterface::forceCompletion() [pure virtual]
    {25, 830, 127, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//114 KTextEditor::CodeCompletionInterface::registerCompletionModel(KTextEditor::CodeCompletionModel*) [pure virtual]
    {25, 1094, 127, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 6},	//115 KTextEditor::CodeCompletionInterface::unregisterCompletionModel(KTextEditor::CodeCompletionModel*) [pure virtual]
    {25, 624, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 7},	//116 KTextEditor::CodeCompletionInterface::isAutomaticInvocationEnabled() const [pure virtual]
    {25, 899, 17, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 8},	//117 KTextEditor::CodeCompletionInterface::setAutomaticInvocationEnabled(bool) [pure virtual]
    {25, 32, 0, 0, Smoke::mf_ctor, 31, 9},	//118 KTextEditor::CodeCompletionInterface::CodeCompletionInterface()
    {25, 32, 129, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 31, 10},	//119 KTextEditor::CodeCompletionInterface::CodeCompletionInterface(const KTextEditor::CodeCompletionInterface&)
    {25, 899, 0, 0, 0, 0, 11},	//120 KTextEditor::CodeCompletionInterface::setAutomaticInvocationEnabled()
    {25, 1144, 0, 0, Smoke::mf_dtor, 0, 12 },	//121 KTextEditor::CodeCompletionInterface::~CodeCompletionInterface()
    {26, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//122 KTextEditor::CodeCompletionModel::metaObject() const
    {26, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//123 KTextEditor::CodeCompletionModel::qt_metacast(const char*)
    {26, 1078, 85, 2, Smoke::mf_static, 159, 3},	//124 KTextEditor::CodeCompletionModel::tr(const char*, const char*)
    {26, 1082, 85, 2, Smoke::mf_static, 159, 4},	//125 KTextEditor::CodeCompletionModel::trUtf8(const char*, const char*)
    {26, 1078, 88, 3, Smoke::mf_static, 159, 5},	//126 KTextEditor::CodeCompletionModel::tr(const char*, const char*, int)
    {26, 1082, 88, 3, Smoke::mf_static, 159, 6},	//127 KTextEditor::CodeCompletionModel::trUtf8(const char*, const char*, int)
    {26, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//128 KTextEditor::CodeCompletionModel::qt_metacall(QMetaObject::Call, int, void**)
    {26, 34, 131, 1, Smoke::mf_ctor, 32, 8},	//129 KTextEditor::CodeCompletionModel::CodeCompletionModel(QObject*)
    {26, 992, 99, 1, 0, 0, 9},	//130 KTextEditor::CodeCompletionModel::setRowCount(int)
    {26, 381, 133, 3, Smoke::mf_virtual, 0, 10},	//131 KTextEditor::CodeCompletionModel::completionInvoked(KTextEditor::View*, const KTextEditor::Range&, KTextEditor::CodeCompletionModel::InvocationType)
    {26, 538, 137, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 11},	//132 KTextEditor::CodeCompletionModel::executeCompletionItem(KTextEditor::Document*, const KTextEditor::Range&, int) const
    {26, 376, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 338, 12},	//133 KTextEditor::CodeCompletionModel::columnCount(const QModelIndex&) const
    {26, 593, 143, 3, Smoke::mf_const|Smoke::mf_virtual, 144, 13},	//134 KTextEditor::CodeCompletionModel::index(int, int, const QModelIndex&) const
    {26, 631, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 140, 14},	//135 KTextEditor::CodeCompletionModel::itemData(const QModelIndex&) const
    {26, 771, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 144, 15},	//136 KTextEditor::CodeCompletionModel::parent(const QModelIndex&) const
    {26, 875, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 338, 16},	//137 KTextEditor::CodeCompletionModel::rowCount(const QModelIndex&) const
    {26, 569, 0, 0, Smoke::mf_const, 264, 17},	//138 KTextEditor::CodeCompletionModel::hasGroups() const
    {26, 1120, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//139 KTextEditor::CodeCompletionModel::waitForReset()
    {26, 570, 147, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//140 KTextEditor::CodeCompletionModel::hasGroupsChanged(KTextEditor::CodeCompletionModel*, bool)
    {26, 936, 17, 1, Smoke::mf_protected, 0, 20},	//141 KTextEditor::CodeCompletionModel::setHasGroups(bool)
    {26, 1078, 70, 1, Smoke::mf_static, 159, 21},	//142 KTextEditor::CodeCompletionModel::tr(const char*)
    {26, 1082, 70, 1, Smoke::mf_static, 159, 22},	//143 KTextEditor::CodeCompletionModel::trUtf8(const char*)
    {26, 376, 0, 0, Smoke::mf_const, 338, 23},	//144 KTextEditor::CodeCompletionModel::columnCount() const
    {26, 593, 150, 2, Smoke::mf_const, 144, 24},	//145 KTextEditor::CodeCompletionModel::index(int, int) const
    {26, 875, 0, 0, Smoke::mf_const, 338, 25},	//146 KTextEditor::CodeCompletionModel::rowCount() const
    {26, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 26},	//147 KTextEditor::CodeCompletionModel::staticMetaObject() const
    {26, 42, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 335, 27},	//148 KTextEditor::CodeCompletionModel::ColumnCount() const
    {26, 129, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 335, 28},	//149 KTextEditor::CodeCompletionModel::LastItemDataRole() const
    {26, 186, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 29},	//150 KTextEditor::CodeCompletionModel::Prefix (enum)
    {26, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 30},	//151 KTextEditor::CodeCompletionModel::Icon (enum)
    {26, 209, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 31},	//152 KTextEditor::CodeCompletionModel::Scope (enum)
    {26, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 32},	//153 KTextEditor::CodeCompletionModel::Name (enum)
    {26, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 33},	//154 KTextEditor::CodeCompletionModel::Arguments (enum)
    {26, 185, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 34},	//155 KTextEditor::CodeCompletionModel::Postfix (enum)
    {26, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 35},	//156 KTextEditor::CodeCompletionModel::NoProperty (enum)
    {26, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 36},	//157 KTextEditor::CodeCompletionModel::FirstProperty (enum)
    {26, 189, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 37},	//158 KTextEditor::CodeCompletionModel::Public (enum)
    {26, 188, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 38},	//159 KTextEditor::CodeCompletionModel::Protected (enum)
    {26, 187, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 39},	//160 KTextEditor::CodeCompletionModel::Private (enum)
    {26, 242, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 40},	//161 KTextEditor::CodeCompletionModel::Static (enum)
    {26, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 41},	//162 KTextEditor::CodeCompletionModel::Const (enum)
    {26, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 42},	//163 KTextEditor::CodeCompletionModel::Namespace (enum)
    {26, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 43},	//164 KTextEditor::CodeCompletionModel::Class (enum)
    {26, 244, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 44},	//165 KTextEditor::CodeCompletionModel::Struct (enum)
    {26, 253, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 45},	//166 KTextEditor::CodeCompletionModel::Union (enum)
    {26, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 46},	//167 KTextEditor::CodeCompletionModel::Function (enum)
    {26, 255, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 47},	//168 KTextEditor::CodeCompletionModel::Variable (enum)
    {26, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 48},	//169 KTextEditor::CodeCompletionModel::Enum (enum)
    {26, 245, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 49},	//170 KTextEditor::CodeCompletionModel::Template (enum)
    {26, 251, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 50},	//171 KTextEditor::CodeCompletionModel::TypeAlias (enum)
    {26, 262, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 51},	//172 KTextEditor::CodeCompletionModel::Virtual (enum)
    {26, 180, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 52},	//173 KTextEditor::CodeCompletionModel::Override (enum)
    {26, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 53},	//174 KTextEditor::CodeCompletionModel::Inline (enum)
    {26, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 54},	//175 KTextEditor::CodeCompletionModel::Friend (enum)
    {26, 218, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 55},	//176 KTextEditor::CodeCompletionModel::Signal (enum)
    {26, 225, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 56},	//177 KTextEditor::CodeCompletionModel::Slot (enum)
    {26, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 57},	//178 KTextEditor::CodeCompletionModel::LocalScope (enum)
    {26, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 58},	//179 KTextEditor::CodeCompletionModel::NamespaceScope (enum)
    {26, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 59},	//180 KTextEditor::CodeCompletionModel::GlobalScope (enum)
    {26, 130, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 60},	//181 KTextEditor::CodeCompletionModel::LastProperty (enum)
    {26, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 61},	//182 KTextEditor::CodeCompletionModel::NoHighlighting (enum)
    {26, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 62},	//183 KTextEditor::CodeCompletionModel::InternalHighlighting (enum)
    {26, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 38, 63},	//184 KTextEditor::CodeCompletionModel::CustomHighlighting (enum)
    {26, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 64},	//185 KTextEditor::CodeCompletionModel::CompletionRole (enum)
    {26, 210, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 65},	//186 KTextEditor::CodeCompletionModel::ScopeIndex (enum)
    {26, 163, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 66},	//187 KTextEditor::CodeCompletionModel::MatchQuality (enum)
    {26, 217, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 67},	//188 KTextEditor::CodeCompletionModel::SetMatchContext (enum)
    {26, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 68},	//189 KTextEditor::CodeCompletionModel::HighlightingMethod (enum)
    {26, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 69},	//190 KTextEditor::CodeCompletionModel::CustomHighlight (enum)
    {26, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 70},	//191 KTextEditor::CodeCompletionModel::InheritanceDepth (enum)
    {26, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 71},	//192 KTextEditor::CodeCompletionModel::IsExpandable (enum)
    {26, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 72},	//193 KTextEditor::CodeCompletionModel::ExpandingWidget (enum)
    {26, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 73},	//194 KTextEditor::CodeCompletionModel::ItemSelected (enum)
    {26, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 74},	//195 KTextEditor::CodeCompletionModel::ArgumentHintDepth (enum)
    {26, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 75},	//196 KTextEditor::CodeCompletionModel::BestMatchesCount (enum)
    {26, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 76},	//197 KTextEditor::CodeCompletionModel::AccessibilityNext (enum)
    {26, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 77},	//198 KTextEditor::CodeCompletionModel::AccessibilityPrevious (enum)
    {26, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 78},	//199 KTextEditor::CodeCompletionModel::AccessibilityAccept (enum)
    {26, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 79},	//200 KTextEditor::CodeCompletionModel::GroupRole (enum)
    {26, 252, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 80},	//201 KTextEditor::CodeCompletionModel::UnimportantItemRole (enum)
    {26, 128, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 81},	//202 KTextEditor::CodeCompletionModel::LastExtraItemDataRole (enum)
    {26, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 82},	//203 KTextEditor::CodeCompletionModel::AutomaticInvocation (enum)
    {26, 254, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 83},	//204 KTextEditor::CodeCompletionModel::UserInvocation (enum)
    {26, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 84},	//205 KTextEditor::CodeCompletionModel::ManualInvocation (enum)
    {26, 1145, 0, 0, Smoke::mf_dtor, 0, 85 },	//206 KTextEditor::CodeCompletionModel::~CodeCompletionModel()
    {27, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//207 KTextEditor::CodeCompletionModel2::metaObject() const
    {27, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//208 KTextEditor::CodeCompletionModel2::qt_metacast(const char*)
    {27, 1078, 85, 2, Smoke::mf_static, 159, 3},	//209 KTextEditor::CodeCompletionModel2::tr(const char*, const char*)
    {27, 1082, 85, 2, Smoke::mf_static, 159, 4},	//210 KTextEditor::CodeCompletionModel2::trUtf8(const char*, const char*)
    {27, 1078, 88, 3, Smoke::mf_static, 159, 5},	//211 KTextEditor::CodeCompletionModel2::tr(const char*, const char*, int)
    {27, 1082, 88, 3, Smoke::mf_static, 159, 6},	//212 KTextEditor::CodeCompletionModel2::trUtf8(const char*, const char*, int)
    {27, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//213 KTextEditor::CodeCompletionModel2::qt_metacall(QMetaObject::Call, int, void**)
    {27, 36, 131, 1, Smoke::mf_ctor, 33, 8},	//214 KTextEditor::CodeCompletionModel2::CodeCompletionModel2(QObject*)
    {27, 540, 153, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 9},	//215 KTextEditor::CodeCompletionModel2::executeCompletionItem2(KTextEditor::Document*, const KTextEditor::Range&, const QModelIndex&) const
    {27, 1078, 70, 1, Smoke::mf_static, 159, 10},	//216 KTextEditor::CodeCompletionModel2::tr(const char*)
    {27, 1082, 70, 1, Smoke::mf_static, 159, 11},	//217 KTextEditor::CodeCompletionModel2::trUtf8(const char*)
    {27, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 12},	//218 KTextEditor::CodeCompletionModel2::staticMetaObject() const
    {27, 1146, 0, 0, Smoke::mf_dtor, 0, 13 },	//219 KTextEditor::CodeCompletionModel2::~CodeCompletionModel2()
    {28, 38, 0, 0, Smoke::mf_ctor, 41, 1},	//220 KTextEditor::CodeCompletionModelControllerInterface::CodeCompletionModelControllerInterface()
    {28, 1027, 157, 4, Smoke::mf_virtual, 264, 2},	//221 KTextEditor::CodeCompletionModelControllerInterface::shouldStartCompletion(KTextEditor::View*, const QString&, bool, const KTextEditor::Cursor&)
    {28, 385, 162, 2, Smoke::mf_virtual, 74, 3},	//222 KTextEditor::CodeCompletionModelControllerInterface::completionRange(KTextEditor::View*, const KTextEditor::Cursor&)
    {28, 1096, 165, 2, Smoke::mf_virtual, 0, 4},	//223 KTextEditor::CodeCompletionModelControllerInterface::updateCompletionRange(KTextEditor::View*, KTextEditor::SmartRange&)
    {28, 547, 168, 3, Smoke::mf_virtual, 159, 5},	//224 KTextEditor::CodeCompletionModelControllerInterface::filterString(KTextEditor::View*, const KTextEditor::SmartRange&, const KTextEditor::Cursor&)
    {28, 1023, 172, 3, Smoke::mf_virtual, 264, 6},	//225 KTextEditor::CodeCompletionModelControllerInterface::shouldAbortCompletion(KTextEditor::View*, const KTextEditor::SmartRange&, const QString&)
    {28, 1025, 176, 2, Smoke::mf_virtual, 264, 7},	//226 KTextEditor::CodeCompletionModelControllerInterface::shouldExecute(const QModelIndex&, QChar)
    {28, 265, 179, 1, Smoke::mf_virtual, 0, 8},	//227 KTextEditor::CodeCompletionModelControllerInterface::aborted(KTextEditor::View*)
    {28, 38, 181, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 41, 9},	//228 KTextEditor::CodeCompletionModelControllerInterface::CodeCompletionModelControllerInterface(const KTextEditor::CodeCompletionModelControllerInterface&)
    {28, 1147, 0, 0, Smoke::mf_dtor, 0, 10 },	//229 KTextEditor::CodeCompletionModelControllerInterface::~CodeCompletionModelControllerInterface()
    {29, 697, 141, 1, Smoke::mf_virtual, 43, 1},	//230 KTextEditor::CodeCompletionModelControllerInterface2::matchingItem(const QModelIndex&)
    {29, 40, 0, 0, Smoke::mf_ctor, 42, 2},	//231 KTextEditor::CodeCompletionModelControllerInterface2::CodeCompletionModelControllerInterface2()
    {29, 40, 183, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 42, 3},	//232 KTextEditor::CodeCompletionModelControllerInterface2::CodeCompletionModelControllerInterface2(const KTextEditor::CodeCompletionModelControllerInterface2&)
    {29, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 4},	//233 KTextEditor::CodeCompletionModelControllerInterface2::None (enum)
    {29, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 5},	//234 KTextEditor::CodeCompletionModelControllerInterface2::HideListIfAutomaticInvocation (enum)
    {29, 1148, 0, 0, Smoke::mf_dtor, 0, 6 },	//235 KTextEditor::CodeCompletionModelControllerInterface2::~CodeCompletionModelControllerInterface2()
    {30, 374, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 331, 1},	//236 KTextEditor::Command::cmds() [pure virtual]
    {30, 535, 185, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 2},	//237 KTextEditor::Command::exec(KTextEditor::View*, const QString&, QString&) [pure virtual]
    {30, 577, 185, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 3},	//238 KTextEditor::Command::help(KTextEditor::View*, const QString&, QString&) [pure virtual]
    {30, 43, 0, 0, Smoke::mf_ctor, 44, 4},	//239 KTextEditor::Command::Command()
    {30, 43, 189, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 44, 5},	//240 KTextEditor::Command::Command(const KTextEditor::Command&)
    {30, 1149, 0, 0, Smoke::mf_dtor, 0, 6 },	//241 KTextEditor::Command::~Command()
    {31, 551, 191, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//242 KTextEditor::CommandExtension::flagCompletions(QStringList&) [pure virtual]
    {31, 383, 193, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 3, 2},	//243 KTextEditor::CommandExtension::completionObject(KTextEditor::View*, const QString&) [pure virtual]
    {31, 1122, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 3},	//244 KTextEditor::CommandExtension::wantsToProcessText(const QString&) [pure virtual]
    {31, 796, 193, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//245 KTextEditor::CommandExtension::processText(KTextEditor::View*, const QString&) [pure virtual]
    {31, 45, 0, 0, Smoke::mf_ctor, 45, 5},	//246 KTextEditor::CommandExtension::CommandExtension()
    {31, 45, 198, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 45, 6},	//247 KTextEditor::CommandExtension::CommandExtension(const KTextEditor::CommandExtension&)
    {31, 1150, 0, 0, Smoke::mf_dtor, 0, 7 },	//248 KTextEditor::CommandExtension::~CommandExtension()
    {32, 828, 200, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 1},	//249 KTextEditor::CommandInterface::registerCommand(KTextEditor::Command*) [pure virtual]
    {32, 1092, 200, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 2},	//250 KTextEditor::CommandInterface::unregisterCommand(KTextEditor::Command*) [pure virtual]
    {32, 803, 196, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 44, 3},	//251 KTextEditor::CommandInterface::queryCommand(const QString&) const [pure virtual]
    {32, 380, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 134, 4},	//252 KTextEditor::CommandInterface::commands() const [pure virtual]
    {32, 379, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 161, 5},	//253 KTextEditor::CommandInterface::commandList() const [pure virtual]
    {32, 47, 0, 0, Smoke::mf_ctor, 46, 6},	//254 KTextEditor::CommandInterface::CommandInterface()
    {32, 47, 202, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 46, 7},	//255 KTextEditor::CommandInterface::CommandInterface(const KTextEditor::CommandInterface&)
    {32, 1151, 0, 0, Smoke::mf_dtor, 0, 8 },	//256 KTextEditor::CommandInterface::~CommandInterface()
    {33, 50, 0, 0, Smoke::mf_ctor, 47, 1},	//257 KTextEditor::ConfigInterface::ConfigInterface()
    {33, 391, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 161, 2},	//258 KTextEditor::ConfigInterface::configKeys() const [pure virtual]
    {33, 401, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 167, 3},	//259 KTextEditor::ConfigInterface::configValue(const QString&) [pure virtual]
    {33, 914, 204, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//260 KTextEditor::ConfigInterface::setConfigValue(const QString&, const QVariant&) [pure virtual]
    {33, 50, 207, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 47, 5},	//261 KTextEditor::ConfigInterface::ConfigInterface(const KTextEditor::ConfigInterface&)
    {33, 1152, 0, 0, Smoke::mf_dtor, 0, 6 },	//262 KTextEditor::ConfigInterface::~ConfigInterface()
    {34, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//263 KTextEditor::ConfigPage::metaObject() const
    {34, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//264 KTextEditor::ConfigPage::qt_metacast(const char*)
    {34, 1078, 85, 2, Smoke::mf_static, 159, 3},	//265 KTextEditor::ConfigPage::tr(const char*, const char*)
    {34, 1082, 85, 2, Smoke::mf_static, 159, 4},	//266 KTextEditor::ConfigPage::trUtf8(const char*, const char*)
    {34, 1078, 88, 3, Smoke::mf_static, 159, 5},	//267 KTextEditor::ConfigPage::tr(const char*, const char*, int)
    {34, 1082, 88, 3, Smoke::mf_static, 159, 6},	//268 KTextEditor::ConfigPage::trUtf8(const char*, const char*, int)
    {34, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//269 KTextEditor::ConfigPage::qt_metacall(QMetaObject::Call, int, void**)
    {34, 52, 10, 1, Smoke::mf_ctor, 48, 8},	//270 KTextEditor::ConfigPage::ConfigPage(QWidget*)
    {34, 308, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual|Smoke::mf_slot, 0, 9},	//271 KTextEditor::ConfigPage::apply() [pure virtual]
    {34, 872, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual|Smoke::mf_slot, 0, 10},	//272 KTextEditor::ConfigPage::reset() [pure virtual]
    {34, 455, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual|Smoke::mf_slot, 0, 11},	//273 KTextEditor::ConfigPage::defaults() [pure virtual]
    {34, 334, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//274 KTextEditor::ConfigPage::changed()
    {34, 1078, 70, 1, Smoke::mf_static, 159, 13},	//275 KTextEditor::ConfigPage::tr(const char*)
    {34, 1082, 70, 1, Smoke::mf_static, 159, 14},	//276 KTextEditor::ConfigPage::trUtf8(const char*)
    {34, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 15},	//277 KTextEditor::ConfigPage::staticMetaObject() const
    {34, 1153, 0, 0, Smoke::mf_dtor, 0, 16 },	//278 KTextEditor::ConfigPage::~ConfigPage()
    {35, 55, 0, 0, Smoke::mf_ctor, 49, 1},	//279 KTextEditor::ContainerInterface::ContainerInterface()
    {35, 916, 131, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//280 KTextEditor::ContainerInterface::setContainer(QObject*) [pure virtual]
    {35, 406, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 148, 3},	//281 KTextEditor::ContainerInterface::container() [pure virtual]
    {35, 55, 209, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 49, 4},	//282 KTextEditor::ContainerInterface::ContainerInterface(const KTextEditor::ContainerInterface&)
    {35, 1154, 0, 0, Smoke::mf_dtor, 0, 5 },	//283 KTextEditor::ContainerInterface::~ContainerInterface()
    {36, 417, 211, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 51, 1},	//284 KTextEditor::CoordinatesToCursorInterface::coordinatesToCursor(const QPoint&) const [pure virtual]
    {36, 57, 0, 0, Smoke::mf_ctor, 50, 2},	//285 KTextEditor::CoordinatesToCursorInterface::CoordinatesToCursorInterface()
    {36, 57, 213, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 50, 3},	//286 KTextEditor::CoordinatesToCursorInterface::CoordinatesToCursorInterface(const KTextEditor::CoordinatesToCursorInterface&)
    {36, 1155, 0, 0, Smoke::mf_dtor, 0, 4 },	//287 KTextEditor::CoordinatesToCursorInterface::~CoordinatesToCursorInterface()
    {37, 59, 0, 0, Smoke::mf_ctor, 53, 1},	//288 KTextEditor::Cursor::Cursor()
    {37, 59, 150, 2, Smoke::mf_ctor, 53, 2},	//289 KTextEditor::Cursor::Cursor(int, int)
    {37, 59, 215, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 3},	//290 KTextEditor::Cursor::Cursor(const KTextEditor::Cursor&)
    {37, 630, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 4},	//291 KTextEditor::Cursor::isValid() const
    {37, 628, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 5},	//292 KTextEditor::Cursor::isSmartCursor() const
    {37, 1074, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 83, 6},	//293 KTextEditor::Cursor::toSmartCursor() const
    {37, 621, 0, 0, Smoke::mf_static, 51, 7},	//294 KTextEditor::Cursor::invalid()
    {37, 1042, 0, 0, Smoke::mf_static, 51, 8},	//295 KTextEditor::Cursor::start()
    {37, 985, 215, 1, Smoke::mf_virtual, 0, 9},	//296 KTextEditor::Cursor::setPosition(const KTextEditor::Cursor&)
    {37, 985, 150, 2, 0, 0, 10},	//297 KTextEditor::Cursor::setPosition(int, int)
    {37, 638, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 338, 11},	//298 KTextEditor::Cursor::line() const
    {37, 946, 99, 1, Smoke::mf_virtual, 0, 12},	//299 KTextEditor::Cursor::setLine(int)
    {37, 375, 0, 0, Smoke::mf_const, 338, 13},	//300 KTextEditor::Cursor::column() const
    {37, 911, 99, 1, Smoke::mf_virtual, 0, 14},	//301 KTextEditor::Cursor::setColumn(int)
    {37, 315, 0, 0, Smoke::mf_const, 264, 15},	//302 KTextEditor::Cursor::atStartOfLine() const
    {37, 314, 0, 0, Smoke::mf_const, 264, 16},	//303 KTextEditor::Cursor::atStartOfDocument() const
    {37, 779, 217, 2, Smoke::mf_const, 0, 17},	//304 KTextEditor::Cursor::position(int&, int&) const
    {37, 805, 0, 0, Smoke::mf_const, 76, 18},	//305 KTextEditor::Cursor::range() const
    {37, 755, 215, 1, 0, 52, 19},	//306 KTextEditor::Cursor::operator=(const KTextEditor::Cursor&)
    {37, 988, 220, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//307 KTextEditor::Cursor::setRange(KTextEditor::Range*)
    {37, 430, 215, 1, Smoke::mf_protected, 0, 21},	//308 KTextEditor::Cursor::cursorChangedDirectly(const KTextEditor::Cursor&)
    {37, 650, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 338, 22},	//309 KTextEditor::Cursor::m_line() const
    {37, 953, 99, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 23},	//310 KTextEditor::Cursor::setM_line(int)
    {37, 648, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 338, 24},	//311 KTextEditor::Cursor::m_column() const
    {37, 949, 99, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 25},	//312 KTextEditor::Cursor::setM_column(int)
    {37, 651, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 76, 26},	//313 KTextEditor::Cursor::m_range() const
    {37, 955, 220, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 27},	//314 KTextEditor::Cursor::setM_range(KTextEditor::Range*)
    {37, 1156, 0, 0, Smoke::mf_dtor, 0, 28 },	//315 KTextEditor::Cursor::~Cursor()
    {38, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//316 KTextEditor::Document::metaObject() const
    {38, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//317 KTextEditor::Document::qt_metacast(const char*)
    {38, 1078, 85, 2, Smoke::mf_static, 159, 3},	//318 KTextEditor::Document::tr(const char*, const char*)
    {38, 1082, 85, 2, Smoke::mf_static, 159, 4},	//319 KTextEditor::Document::trUtf8(const char*, const char*)
    {38, 1078, 88, 3, Smoke::mf_static, 159, 5},	//320 KTextEditor::Document::tr(const char*, const char*, int)
    {38, 1082, 88, 3, Smoke::mf_static, 159, 6},	//321 KTextEditor::Document::trUtf8(const char*, const char*, int)
    {38, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//322 KTextEditor::Document::qt_metacall(QMetaObject::Call, int, void**)
    {38, 66, 131, 1, Smoke::mf_ctor, 54, 8},	//323 KTextEditor::Document::Document(QObject*)
    {38, 512, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 55, 9},	//324 KTextEditor::Document::editor() [pure virtual]
    {38, 427, 10, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 98, 10},	//325 KTextEditor::Document::createView(QWidget*) [pure virtual]
    {38, 275, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 98, 11},	//326 KTextEditor::Document::activeView() const [pure virtual]
    {38, 1118, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 317, 12},	//327 KTextEditor::Document::views() const [pure virtual]
    {38, 1108, 222, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//328 KTextEditor::Document::viewCreated(KTextEditor::Document*, KTextEditor::View*)
    {38, 477, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 330, 14},	//329 KTextEditor::Document::documentName() const [pure virtual]
    {38, 702, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 15},	//330 KTextEditor::Document::mimeType() [pure virtual]
    {38, 478, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//331 KTextEditor::Document::documentNameChanged(KTextEditor::Document*)
    {38, 486, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//332 KTextEditor::Document::documentUrlChanged(KTextEditor::Document*)
    {38, 711, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//333 KTextEditor::Document::modifiedChanged(KTextEditor::Document*)
    {38, 932, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 19},	//334 KTextEditor::Document::setEncoding(const QString&) [pure virtual]
    {38, 521, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 330, 20},	//335 KTextEditor::Document::encoding() const [pure virtual]
    {38, 481, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 21},	//336 KTextEditor::Document::documentReload() [pure virtual]
    {38, 482, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 22},	//337 KTextEditor::Document::documentSave() [pure virtual]
    {38, 483, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 23},	//338 KTextEditor::Document::documentSaveAs() [pure virtual]
    {38, 484, 227, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//339 KTextEditor::Document::documentSavedOrUploaded(KTextEditor::Document*, bool)
    {38, 1045, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 25},	//340 KTextEditor::Document::startEditing() [pure virtual]
    {38, 525, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 26},	//341 KTextEditor::Document::endEditing() [pure virtual]
    {38, 1056, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 27},	//342 KTextEditor::Document::text() const [pure virtual]
    {38, 1056, 230, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 28},	//343 KTextEditor::Document::text(const KTextEditor::Range&, bool) const [pure virtual]
    {38, 335, 215, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 108, 29},	//344 KTextEditor::Document::character(const KTextEditor::Cursor&) const [pure virtual]
    {38, 1067, 230, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 161, 30},	//345 KTextEditor::Document::textLines(const KTextEditor::Range&, bool) const [pure virtual]
    {38, 638, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 31},	//346 KTextEditor::Document::line(int) const [pure virtual]
    {38, 646, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 338, 32},	//347 KTextEditor::Document::lines() const [pure virtual]
    {38, 475, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 51, 33},	//348 KTextEditor::Document::documentEnd() const [pure virtual]
    {38, 480, 0, 0, Smoke::mf_const, 74, 34},	//349 KTextEditor::Document::documentRange() const
    {38, 1077, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 338, 35},	//350 KTextEditor::Document::totalCharacters() const [pure virtual]
    {38, 626, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 36},	//351 KTextEditor::Document::isEmpty() const
    {38, 644, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 338, 37},	//352 KTextEditor::Document::lineLength(int) const [pure virtual]
    {38, 526, 99, 1, Smoke::mf_const, 51, 38},	//353 KTextEditor::Document::endOfLine(int) const
    {38, 1009, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 39},	//354 KTextEditor::Document::setText(const QString&) [pure virtual]
    {38, 1009, 233, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 40},	//355 KTextEditor::Document::setText(const QStringList&) [pure virtual]
    {38, 352, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 41},	//356 KTextEditor::Document::clear() [pure virtual]
    {38, 611, 235, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 42},	//357 KTextEditor::Document::insertText(const KTextEditor::Cursor&, const QString&, bool) [pure virtual]
    {38, 611, 239, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 43},	//358 KTextEditor::Document::insertText(const KTextEditor::Cursor&, const QStringList&, bool) [pure virtual]
    {38, 864, 243, 3, Smoke::mf_virtual, 264, 44},	//359 KTextEditor::Document::replaceText(const KTextEditor::Range&, const QString&, bool)
    {38, 864, 247, 3, Smoke::mf_virtual, 264, 45},	//360 KTextEditor::Document::replaceText(const KTextEditor::Range&, const QStringList&, bool)
    {38, 856, 230, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 46},	//361 KTextEditor::Document::removeText(const KTextEditor::Range&, bool) [pure virtual]
    {38, 432, 215, 1, Smoke::mf_virtual, 264, 47},	//362 KTextEditor::Document::cursorInText(const KTextEditor::Cursor&)
    {38, 602, 251, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 48},	//363 KTextEditor::Document::insertLine(int, const QString&) [pure virtual]
    {38, 604, 254, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 49},	//364 KTextEditor::Document::insertLines(int, const QStringList&) [pure virtual]
    {38, 847, 99, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 50},	//365 KTextEditor::Document::removeLine(int) [pure virtual]
    {38, 1060, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//366 KTextEditor::Document::textChanged(KTextEditor::Document*)
    {38, 1064, 257, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 52},	//367 KTextEditor::Document::textInserted(KTextEditor::Document*, const KTextEditor::Range&)
    {38, 1070, 257, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 53},	//368 KTextEditor::Document::textRemoved(KTextEditor::Document*, const KTextEditor::Range&)
    {38, 1070, 260, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 54},	//369 KTextEditor::Document::textRemoved(KTextEditor::Document*, const KTextEditor::Range&, const QString&)
    {38, 1060, 264, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 55},	//370 KTextEditor::Document::textChanged(KTextEditor::Document*, const KTextEditor::Range&, const KTextEditor::Range&)
    {38, 1060, 268, 4, Smoke::mf_protected|Smoke::mf_signal, 0, 56},	//371 KTextEditor::Document::textChanged(KTextEditor::Document*, const KTextEditor::Range&, const QString&, const KTextEditor::Range&)
    {38, 268, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 57},	//372 KTextEditor::Document::aboutToClose(KTextEditor::Document*)
    {38, 270, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 58},	//373 KTextEditor::Document::aboutToReload(KTextEditor::Document*)
    {38, 834, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 59},	//374 KTextEditor::Document::reloaded(KTextEditor::Document*)
    {38, 533, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 60},	//375 KTextEditor::Document::exclusiveEditStart(KTextEditor::Document*)
    {38, 531, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 61},	//376 KTextEditor::Document::exclusiveEditEnd(KTextEditor::Document*)
    {38, 705, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 62},	//377 KTextEditor::Document::mode() const [pure virtual]
    {38, 582, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 63},	//378 KTextEditor::Document::highlightingMode() const [pure virtual]
    {38, 710, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 161, 64},	//379 KTextEditor::Document::modes() const [pure virtual]
    {38, 589, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 161, 65},	//380 KTextEditor::Document::highlightingModes() const [pure virtual]
    {38, 966, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 66},	//381 KTextEditor::Document::setMode(const QString&) [pure virtual]
    {38, 939, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 67},	//382 KTextEditor::Document::setHighlightingMode(const QString&) [pure virtual]
    {38, 587, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 68},	//383 KTextEditor::Document::highlightingModeSection(int) const [pure virtual]
    {38, 708, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 69},	//384 KTextEditor::Document::modeSection(int) const [pure virtual]
    {38, 706, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 70},	//385 KTextEditor::Document::modeChanged(KTextEditor::Document*)
    {38, 585, 225, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 71},	//386 KTextEditor::Document::highlightingModeChanged(KTextEditor::Document*)
    {38, 1007, 17, 1, 0, 0, 72},	//387 KTextEditor::Document::setSuppressOpeningErrorDialogs(bool)
    {38, 1054, 0, 0, Smoke::mf_const, 264, 73},	//388 KTextEditor::Document::suppressOpeningErrorDialogs() const
    {38, 751, 0, 0, Smoke::mf_const, 264, 74},	//389 KTextEditor::Document::openingError() const
    {38, 752, 0, 0, Smoke::mf_const, 159, 75},	//390 KTextEditor::Document::openingErrorMessage() const
    {38, 627, 0, 0, Smoke::mf_const, 264, 76},	//391 KTextEditor::Document::isOrphaned() const
    {38, 979, 17, 1, 0, 0, 77},	//392 KTextEditor::Document::setOrphaned(bool)
    {38, 975, 17, 1, Smoke::mf_protected, 0, 78},	//393 KTextEditor::Document::setOpeningError(bool)
    {38, 977, 196, 1, Smoke::mf_protected, 0, 79},	//394 KTextEditor::Document::setOpeningErrorMessage(const QString&)
    {38, 1078, 70, 1, Smoke::mf_static, 159, 80},	//395 KTextEditor::Document::tr(const char*)
    {38, 1082, 70, 1, Smoke::mf_static, 159, 81},	//396 KTextEditor::Document::trUtf8(const char*)
    {38, 66, 0, 0, Smoke::mf_ctor, 54, 82},	//397 KTextEditor::Document::Document()
    {38, 1056, 273, 1, Smoke::mf_const, 159, 83},	//398 KTextEditor::Document::text(const KTextEditor::Range&) const
    {38, 1067, 273, 1, Smoke::mf_const, 161, 84},	//399 KTextEditor::Document::textLines(const KTextEditor::Range&) const
    {38, 611, 275, 2, 0, 264, 85},	//400 KTextEditor::Document::insertText(const KTextEditor::Cursor&, const QString&)
    {38, 611, 278, 2, 0, 264, 86},	//401 KTextEditor::Document::insertText(const KTextEditor::Cursor&, const QStringList&)
    {38, 864, 281, 2, 0, 264, 87},	//402 KTextEditor::Document::replaceText(const KTextEditor::Range&, const QString&)
    {38, 864, 284, 2, 0, 264, 88},	//403 KTextEditor::Document::replaceText(const KTextEditor::Range&, const QStringList&)
    {38, 856, 273, 1, 0, 264, 89},	//404 KTextEditor::Document::removeText(const KTextEditor::Range&)
    {38, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 90},	//405 KTextEditor::Document::staticMetaObject() const
    {38, 1157, 0, 0, Smoke::mf_dtor, 0, 91 },	//406 KTextEditor::Document::~Document()
    {39, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//407 KTextEditor::Editor::metaObject() const
    {39, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//408 KTextEditor::Editor::qt_metacast(const char*)
    {39, 1078, 85, 2, Smoke::mf_static, 159, 3},	//409 KTextEditor::Editor::tr(const char*, const char*)
    {39, 1082, 85, 2, Smoke::mf_static, 159, 4},	//410 KTextEditor::Editor::trUtf8(const char*, const char*)
    {39, 1078, 88, 3, Smoke::mf_static, 159, 5},	//411 KTextEditor::Editor::tr(const char*, const char*, int)
    {39, 1082, 88, 3, Smoke::mf_static, 159, 6},	//412 KTextEditor::Editor::trUtf8(const char*, const char*, int)
    {39, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//413 KTextEditor::Editor::qt_metacall(QMetaObject::Call, int, void**)
    {39, 73, 131, 1, Smoke::mf_ctor, 55, 8},	//414 KTextEditor::Editor::Editor(QObject*)
    {39, 1003, 17, 1, 0, 0, 9},	//415 KTextEditor::Editor::setSimpleMode(bool)
    {39, 1032, 0, 0, Smoke::mf_const, 264, 10},	//416 KTextEditor::Editor::simpleMode() const
    {39, 420, 131, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 54, 11},	//417 KTextEditor::Editor::createDocument(QObject*) [pure virtual]
    {39, 488, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 312, 12},	//418 KTextEditor::Editor::documents() [pure virtual]
    {39, 267, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 265, 13},	//419 KTextEditor::Editor::aboutData() const [pure virtual]
    {39, 452, 0, 0, Smoke::mf_const, 330, 14},	//420 KTextEditor::Editor::defaultEncoding() const
    {39, 924, 196, 1, Smoke::mf_protected, 0, 15},	//421 KTextEditor::Editor::setDefaultEncoding(const QString&)
    {39, 821, 287, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 16},	//422 KTextEditor::Editor::readConfig(KConfig*) [pure virtual]
    {39, 1131, 287, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 17},	//423 KTextEditor::Editor::writeConfig(KConfig*) [pure virtual]
    {39, 390, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 18},	//424 KTextEditor::Editor::configDialogSupported() const [pure virtual]
    {39, 388, 10, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 19},	//425 KTextEditor::Editor::configDialog(QWidget*) [pure virtual]
    {39, 400, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 338, 20},	//426 KTextEditor::Editor::configPages() const [pure virtual]
    {39, 392, 289, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 48, 21},	//427 KTextEditor::Editor::configPage(int, QWidget*) [pure virtual]
    {39, 398, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 22},	//428 KTextEditor::Editor::configPageName(int) const [pure virtual]
    {39, 394, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 23},	//429 KTextEditor::Editor::configPageFullName(int) const [pure virtual]
    {39, 396, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 8, 24},	//430 KTextEditor::Editor::configPageIcon(int) const [pure virtual]
    {39, 473, 292, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//431 KTextEditor::Editor::documentCreated(KTextEditor::Editor*, KTextEditor::Document*)
    {39, 1078, 70, 1, Smoke::mf_static, 159, 26},	//432 KTextEditor::Editor::tr(const char*)
    {39, 1082, 70, 1, Smoke::mf_static, 159, 27},	//433 KTextEditor::Editor::trUtf8(const char*)
    {39, 821, 0, 0, 0, 0, 28},	//434 KTextEditor::Editor::readConfig()
    {39, 1131, 0, 0, 0, 0, 29},	//435 KTextEditor::Editor::writeConfig()
    {39, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 30},	//436 KTextEditor::Editor::staticMetaObject() const
    {39, 1158, 0, 0, Smoke::mf_dtor, 0, 31 },	//437 KTextEditor::Editor::~Editor()
    {40, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//438 KTextEditor::EditorChooser::metaObject() const
    {40, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//439 KTextEditor::EditorChooser::qt_metacast(const char*)
    {40, 1078, 85, 2, Smoke::mf_static, 159, 3},	//440 KTextEditor::EditorChooser::tr(const char*, const char*)
    {40, 1082, 85, 2, Smoke::mf_static, 159, 4},	//441 KTextEditor::EditorChooser::trUtf8(const char*, const char*)
    {40, 1078, 88, 3, Smoke::mf_static, 159, 5},	//442 KTextEditor::EditorChooser::tr(const char*, const char*, int)
    {40, 1082, 88, 3, Smoke::mf_static, 159, 6},	//443 KTextEditor::EditorChooser::trUtf8(const char*, const char*, int)
    {40, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//444 KTextEditor::EditorChooser::qt_metacall(QMetaObject::Call, int, void**)
    {40, 75, 10, 1, Smoke::mf_ctor, 56, 8},	//445 KTextEditor::EditorChooser::EditorChooser(QWidget*)
    {40, 819, 196, 1, 0, 0, 9},	//446 KTextEditor::EditorChooser::readAppSetting(const QString&)
    {40, 1129, 196, 1, 0, 0, 10},	//447 KTextEditor::EditorChooser::writeAppSetting(const QString&)
    {40, 512, 295, 2, Smoke::mf_static, 55, 11},	//448 KTextEditor::EditorChooser::editor(const QString&, bool)
    {40, 334, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//449 KTextEditor::EditorChooser::changed()
    {40, 1078, 70, 1, Smoke::mf_static, 159, 13},	//450 KTextEditor::EditorChooser::tr(const char*)
    {40, 1082, 70, 1, Smoke::mf_static, 159, 14},	//451 KTextEditor::EditorChooser::trUtf8(const char*)
    {40, 75, 0, 0, Smoke::mf_ctor, 56, 15},	//452 KTextEditor::EditorChooser::EditorChooser()
    {40, 819, 0, 0, 0, 0, 16},	//453 KTextEditor::EditorChooser::readAppSetting()
    {40, 1129, 0, 0, 0, 0, 17},	//454 KTextEditor::EditorChooser::writeAppSetting()
    {40, 512, 0, 0, Smoke::mf_static, 55, 18},	//455 KTextEditor::EditorChooser::editor()
    {40, 512, 196, 1, Smoke::mf_static, 55, 19},	//456 KTextEditor::EditorChooser::editor(const QString&)
    {40, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 20},	//457 KTextEditor::EditorChooser::staticMetaObject() const
    {40, 1159, 0, 0, Smoke::mf_dtor, 0, 21 },	//458 KTextEditor::EditorChooser::~EditorChooser()
    {41, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//459 KTextEditor::Factory::metaObject() const
    {41, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//460 KTextEditor::Factory::qt_metacast(const char*)
    {41, 1078, 85, 2, Smoke::mf_static, 159, 3},	//461 KTextEditor::Factory::tr(const char*, const char*)
    {41, 1082, 85, 2, Smoke::mf_static, 159, 4},	//462 KTextEditor::Factory::trUtf8(const char*, const char*)
    {41, 1078, 88, 3, Smoke::mf_static, 159, 5},	//463 KTextEditor::Factory::tr(const char*, const char*, int)
    {41, 1082, 88, 3, Smoke::mf_static, 159, 6},	//464 KTextEditor::Factory::trUtf8(const char*, const char*, int)
    {41, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//465 KTextEditor::Factory::qt_metacall(QMetaObject::Call, int, void**)
    {41, 88, 131, 1, Smoke::mf_ctor, 57, 8},	//466 KTextEditor::Factory::Factory(QObject*)
    {41, 512, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 55, 9},	//467 KTextEditor::Factory::editor() [pure virtual]
    {41, 1078, 70, 1, Smoke::mf_static, 159, 10},	//468 KTextEditor::Factory::tr(const char*)
    {41, 1082, 70, 1, Smoke::mf_static, 159, 11},	//469 KTextEditor::Factory::trUtf8(const char*)
    {41, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 12},	//470 KTextEditor::Factory::staticMetaObject() const
    {41, 1160, 0, 0, Smoke::mf_dtor, 0, 13 },	//471 KTextEditor::Factory::~Factory()
    {42, 97, 0, 0, Smoke::mf_ctor, 58, 1},	//472 KTextEditor::HighlightInterface::HighlightInterface()
    {42, 453, 298, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 16, 2},	//473 KTextEditor::HighlightInterface::defaultStyle(const KTextEditor::HighlightInterface::DefaultStyle) const [pure virtual]
    {42, 640, 300, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 135, 3},	//474 KTextEditor::HighlightInterface::lineAttributes(const unsigned int) [pure virtual]
    {42, 517, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 161, 4},	//475 KTextEditor::HighlightInterface::embeddedHighlightingModes() const [pure virtual]
    {42, 583, 215, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 5},	//476 KTextEditor::HighlightInterface::highlightingModeAt(const KTextEditor::Cursor&) [pure virtual]
    {42, 97, 302, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 58, 6},	//477 KTextEditor::HighlightInterface::HighlightInterface(const KTextEditor::HighlightInterface&)
    {42, 505, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 7},	//478 KTextEditor::HighlightInterface::dsNormal (enum)
    {42, 504, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 8},	//479 KTextEditor::HighlightInterface::dsKeyword (enum)
    {42, 499, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 9},	//480 KTextEditor::HighlightInterface::dsDataType (enum)
    {42, 500, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 10},	//481 KTextEditor::HighlightInterface::dsDecVal (enum)
    {42, 496, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 11},	//482 KTextEditor::HighlightInterface::dsBaseN (enum)
    {42, 502, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 12},	//483 KTextEditor::HighlightInterface::dsFloat (enum)
    {42, 497, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 13},	//484 KTextEditor::HighlightInterface::dsChar (enum)
    {42, 508, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 14},	//485 KTextEditor::HighlightInterface::dsString (enum)
    {42, 498, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 15},	//486 KTextEditor::HighlightInterface::dsComment (enum)
    {42, 506, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 16},	//487 KTextEditor::HighlightInterface::dsOthers (enum)
    {42, 495, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 17},	//488 KTextEditor::HighlightInterface::dsAlert (enum)
    {42, 503, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 18},	//489 KTextEditor::HighlightInterface::dsFunction (enum)
    {42, 507, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 19},	//490 KTextEditor::HighlightInterface::dsRegionMarker (enum)
    {42, 501, 0, 0, Smoke::mf_static|Smoke::mf_enum, 61, 20},	//491 KTextEditor::HighlightInterface::dsError (enum)
    {42, 1161, 0, 0, Smoke::mf_dtor, 0, 21 },	//492 KTextEditor::HighlightInterface::~HighlightInterface()
    {43, 15, 304, 3, Smoke::mf_ctor, 60, 1},	//493 KTextEditor::HighlightInterface::AttributeBlock::AttributeBlock(const int, const int, const KSharedPtr<KTextEditor::Attribute>&)
    {43, 15, 308, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 60, 2},	//494 KTextEditor::HighlightInterface::AttributeBlock::AttributeBlock(const KTextEditor::HighlightInterface::AttributeBlock&)
    {43, 1042, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 338, 3},	//495 KTextEditor::HighlightInterface::AttributeBlock::start() const
    {43, 1005, 99, 1, Smoke::mf_attribute, 0, 4},	//496 KTextEditor::HighlightInterface::AttributeBlock::setStart(int)
    {43, 637, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 338, 5},	//497 KTextEditor::HighlightInterface::AttributeBlock::length() const
    {43, 944, 99, 1, Smoke::mf_attribute, 0, 6},	//498 KTextEditor::HighlightInterface::AttributeBlock::setLength(int)
    {43, 316, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 17, 7},	//499 KTextEditor::HighlightInterface::AttributeBlock::attribute() const
    {43, 897, 310, 1, Smoke::mf_attribute, 0, 8},	//500 KTextEditor::HighlightInterface::AttributeBlock::setAttribute(const KSharedPtr<KTextEditor::Attribute>&)
    {43, 1143, 0, 0, Smoke::mf_dtor, 0, 9 },	//501 KTextEditor::HighlightInterface::AttributeBlock::~AttributeBlock()
    {44, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//502 KTextEditor::LoadSaveFilterCheckPlugin::metaObject() const
    {44, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//503 KTextEditor::LoadSaveFilterCheckPlugin::qt_metacast(const char*)
    {44, 1078, 85, 2, Smoke::mf_static, 159, 3},	//504 KTextEditor::LoadSaveFilterCheckPlugin::tr(const char*, const char*)
    {44, 1082, 85, 2, Smoke::mf_static, 159, 4},	//505 KTextEditor::LoadSaveFilterCheckPlugin::trUtf8(const char*, const char*)
    {44, 1078, 88, 3, Smoke::mf_static, 159, 5},	//506 KTextEditor::LoadSaveFilterCheckPlugin::tr(const char*, const char*, int)
    {44, 1082, 88, 3, Smoke::mf_static, 159, 6},	//507 KTextEditor::LoadSaveFilterCheckPlugin::trUtf8(const char*, const char*, int)
    {44, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//508 KTextEditor::LoadSaveFilterCheckPlugin::qt_metacall(QMetaObject::Call, int, void**)
    {44, 153, 131, 1, Smoke::mf_ctor, 62, 8},	//509 KTextEditor::LoadSaveFilterCheckPlugin::LoadSaveFilterCheckPlugin(QObject*)
    {44, 793, 225, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 9},	//510 KTextEditor::LoadSaveFilterCheckPlugin::preSavePostDialogFilterCheck(KTextEditor::Document*) [pure virtual]
    {44, 791, 227, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 10},	//511 KTextEditor::LoadSaveFilterCheckPlugin::postSaveFilterCheck(KTextEditor::Document*, bool) [pure virtual]
    {44, 789, 225, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 11},	//512 KTextEditor::LoadSaveFilterCheckPlugin::postLoadFilter(KTextEditor::Document*) [pure virtual]
    {44, 1078, 70, 1, Smoke::mf_static, 159, 12},	//513 KTextEditor::LoadSaveFilterCheckPlugin::tr(const char*)
    {44, 1082, 70, 1, Smoke::mf_static, 159, 13},	//514 KTextEditor::LoadSaveFilterCheckPlugin::trUtf8(const char*)
    {44, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 14},	//515 KTextEditor::LoadSaveFilterCheckPlugin::staticMetaObject() const
    {44, 1162, 0, 0, Smoke::mf_dtor, 0, 15 },	//516 KTextEditor::LoadSaveFilterCheckPlugin::~LoadSaveFilterCheckPlugin()
    {45, 157, 0, 0, Smoke::mf_ctor, 64, 1},	//517 KTextEditor::Mark::Mark()
    {45, 157, 312, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 64, 2},	//518 KTextEditor::Mark::Mark(const KTextEditor::Mark&)
    {45, 638, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 338, 3},	//519 KTextEditor::Mark::line() const
    {45, 946, 99, 1, Smoke::mf_attribute, 0, 4},	//520 KTextEditor::Mark::setLine(int)
    {45, 1089, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 341, 5},	//521 KTextEditor::Mark::type() const
    {45, 1012, 314, 1, Smoke::mf_attribute, 0, 6},	//522 KTextEditor::Mark::setType(unsigned int)
    {45, 1163, 0, 0, Smoke::mf_dtor, 0, 7 },	//523 KTextEditor::Mark::~Mark()
    {46, 160, 0, 0, Smoke::mf_ctor, 65, 1},	//524 KTextEditor::MarkInterface::MarkInterface()
    {46, 653, 99, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 341, 2},	//525 KTextEditor::MarkInterface::mark(int) [pure virtual]
    {46, 960, 316, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//526 KTextEditor::MarkInterface::setMark(int, unsigned int) [pure virtual]
    {46, 358, 99, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//527 KTextEditor::MarkInterface::clearMark(int) [pure virtual]
    {46, 288, 316, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//528 KTextEditor::MarkInterface::addMark(int, unsigned int) [pure virtual]
    {46, 849, 316, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 6},	//529 KTextEditor::MarkInterface::removeMark(int, unsigned int) [pure virtual]
    {46, 693, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 310, 7},	//530 KTextEditor::MarkInterface::marks() [pure virtual]
    {46, 360, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 8},	//531 KTextEditor::MarkInterface::clearMarks() [pure virtual]
    {46, 871, 0, 0, Smoke::mf_static, 338, 9},	//532 KTextEditor::MarkInterface::reservedMarkersCount()
    {46, 694, 225, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 10},	//533 KTextEditor::MarkInterface::marksChanged(KTextEditor::Document*) [pure virtual]
    {46, 964, 319, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 11},	//534 KTextEditor::MarkInterface::setMarkPixmap(KTextEditor::MarkInterface::MarkTypes, const QPixmap&) [pure virtual]
    {46, 659, 322, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 152, 12},	//535 KTextEditor::MarkInterface::markPixmap(KTextEditor::MarkInterface::MarkTypes) const [pure virtual]
    {46, 962, 324, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 13},	//536 KTextEditor::MarkInterface::setMarkDescription(KTextEditor::MarkInterface::MarkTypes, const QString&) [pure virtual]
    {46, 657, 322, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 14},	//537 KTextEditor::MarkInterface::markDescription(KTextEditor::MarkInterface::MarkTypes) const [pure virtual]
    {46, 928, 314, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 15},	//538 KTextEditor::MarkInterface::setEditableMarks(unsigned int) [pure virtual]
    {46, 511, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 341, 16},	//539 KTextEditor::MarkInterface::editableMarks() const [pure virtual]
    {46, 655, 327, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 17},	//540 KTextEditor::MarkInterface::markChanged(KTextEditor::Document*, KTextEditor::Mark, KTextEditor::MarkInterface::MarkChangeAction) [pure virtual]
    {46, 160, 331, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 65, 18},	//541 KTextEditor::MarkInterface::MarkInterface(const KTextEditor::MarkInterface&)
    {46, 661, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 19},	//542 KTextEditor::MarkInterface::markType01 (enum)
    {46, 662, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 20},	//543 KTextEditor::MarkInterface::markType02 (enum)
    {46, 663, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 21},	//544 KTextEditor::MarkInterface::markType03 (enum)
    {46, 664, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 22},	//545 KTextEditor::MarkInterface::markType04 (enum)
    {46, 665, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 23},	//546 KTextEditor::MarkInterface::markType05 (enum)
    {46, 666, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 24},	//547 KTextEditor::MarkInterface::markType06 (enum)
    {46, 667, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 25},	//548 KTextEditor::MarkInterface::markType07 (enum)
    {46, 668, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 26},	//549 KTextEditor::MarkInterface::markType08 (enum)
    {46, 669, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 27},	//550 KTextEditor::MarkInterface::markType09 (enum)
    {46, 670, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 28},	//551 KTextEditor::MarkInterface::markType10 (enum)
    {46, 671, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 29},	//552 KTextEditor::MarkInterface::markType11 (enum)
    {46, 672, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 30},	//553 KTextEditor::MarkInterface::markType12 (enum)
    {46, 673, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 31},	//554 KTextEditor::MarkInterface::markType13 (enum)
    {46, 674, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 32},	//555 KTextEditor::MarkInterface::markType14 (enum)
    {46, 675, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 33},	//556 KTextEditor::MarkInterface::markType15 (enum)
    {46, 676, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 34},	//557 KTextEditor::MarkInterface::markType16 (enum)
    {46, 677, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 35},	//558 KTextEditor::MarkInterface::markType17 (enum)
    {46, 678, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 36},	//559 KTextEditor::MarkInterface::markType18 (enum)
    {46, 679, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 37},	//560 KTextEditor::MarkInterface::markType19 (enum)
    {46, 680, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 38},	//561 KTextEditor::MarkInterface::markType20 (enum)
    {46, 681, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 39},	//562 KTextEditor::MarkInterface::markType21 (enum)
    {46, 682, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 40},	//563 KTextEditor::MarkInterface::markType22 (enum)
    {46, 683, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 41},	//564 KTextEditor::MarkInterface::markType23 (enum)
    {46, 684, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 42},	//565 KTextEditor::MarkInterface::markType24 (enum)
    {46, 685, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 43},	//566 KTextEditor::MarkInterface::markType25 (enum)
    {46, 686, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 44},	//567 KTextEditor::MarkInterface::markType26 (enum)
    {46, 687, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 45},	//568 KTextEditor::MarkInterface::markType27 (enum)
    {46, 688, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 46},	//569 KTextEditor::MarkInterface::markType28 (enum)
    {46, 689, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 47},	//570 KTextEditor::MarkInterface::markType29 (enum)
    {46, 690, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 48},	//571 KTextEditor::MarkInterface::markType30 (enum)
    {46, 691, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 49},	//572 KTextEditor::MarkInterface::markType31 (enum)
    {46, 692, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 50},	//573 KTextEditor::MarkInterface::markType32 (enum)
    {46, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 51},	//574 KTextEditor::MarkInterface::Bookmark (enum)
    {46, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 52},	//575 KTextEditor::MarkInterface::BreakpointActive (enum)
    {46, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 53},	//576 KTextEditor::MarkInterface::BreakpointReached (enum)
    {46, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 54},	//577 KTextEditor::MarkInterface::BreakpointDisabled (enum)
    {46, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 55},	//578 KTextEditor::MarkInterface::Execution (enum)
    {46, 263, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 56},	//579 KTextEditor::MarkInterface::Warning (enum)
    {46, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 67, 57},	//580 KTextEditor::MarkInterface::Error (enum)
    {46, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 58},	//581 KTextEditor::MarkInterface::MarkAdded (enum)
    {46, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 59},	//582 KTextEditor::MarkInterface::MarkRemoved (enum)
    {46, 1164, 0, 0, Smoke::mf_dtor, 0, 60 },	//583 KTextEditor::MarkInterface::~MarkInterface()
    {47, 164, 0, 0, Smoke::mf_ctor, 68, 1},	//584 KTextEditor::MdiContainer::MdiContainer()
    {47, 891, 179, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//585 KTextEditor::MdiContainer::setActiveView(KTextEditor::View*) [pure virtual]
    {47, 275, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 98, 3},	//586 KTextEditor::MdiContainer::activeView() [pure virtual]
    {47, 420, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 54, 4},	//587 KTextEditor::MdiContainer::createDocument() [pure virtual]
    {47, 368, 225, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 5},	//588 KTextEditor::MdiContainer::closeDocument(KTextEditor::Document*) [pure virtual]
    {47, 427, 225, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 98, 6},	//589 KTextEditor::MdiContainer::createView(KTextEditor::Document*) [pure virtual]
    {47, 372, 179, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 7},	//590 KTextEditor::MdiContainer::closeView(KTextEditor::View*) [pure virtual]
    {47, 164, 333, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 68, 8},	//591 KTextEditor::MdiContainer::MdiContainer(const KTextEditor::MdiContainer&)
    {47, 1165, 0, 0, Smoke::mf_dtor, 0, 9 },	//592 KTextEditor::MdiContainer::~MdiContainer()
    {48, 166, 0, 0, Smoke::mf_ctor, 69, 1},	//593 KTextEditor::ModificationInterface::ModificationInterface()
    {48, 969, 335, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//594 KTextEditor::ModificationInterface::setModifiedOnDisk(KTextEditor::ModificationInterface::ModifiedOnDiskReason) [pure virtual]
    {48, 971, 17, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//595 KTextEditor::ModificationInterface::setModifiedOnDiskWarning(bool) [pure virtual]
    {48, 1034, 179, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//596 KTextEditor::ModificationInterface::slotModifiedOnDisk(KTextEditor::View*) [pure virtual]
    {48, 713, 337, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//597 KTextEditor::ModificationInterface::modifiedOnDisk(KTextEditor::Document*, bool, KTextEditor::ModificationInterface::ModifiedOnDiskReason) [pure virtual]
    {48, 166, 341, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 69, 6},	//598 KTextEditor::ModificationInterface::ModificationInterface(const KTextEditor::ModificationInterface&)
    {48, 1034, 0, 0, 0, 0, 7},	//599 KTextEditor::ModificationInterface::slotModifiedOnDisk()
    {48, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 70, 8},	//600 KTextEditor::ModificationInterface::OnDiskUnmodified (enum)
    {48, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 70, 9},	//601 KTextEditor::ModificationInterface::OnDiskModified (enum)
    {48, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 70, 10},	//602 KTextEditor::ModificationInterface::OnDiskCreated (enum)
    {48, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 70, 11},	//603 KTextEditor::ModificationInterface::OnDiskDeleted (enum)
    {48, 1166, 0, 0, Smoke::mf_dtor, 0, 12 },	//604 KTextEditor::ModificationInterface::~ModificationInterface()
    {49, 181, 0, 0, Smoke::mf_ctor, 71, 1},	//605 KTextEditor::ParameterizedSessionConfigInterface::ParameterizedSessionConfigInterface()
    {49, 823, 343, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//606 KTextEditor::ParameterizedSessionConfigInterface::readParameterizedSessionConfig(const KConfigGroup&, unsigned long) [pure virtual]
    {49, 1133, 346, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//607 KTextEditor::ParameterizedSessionConfigInterface::writeParameterizedSessionConfig(KConfigGroup&, unsigned long) [pure virtual]
    {49, 181, 349, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 71, 4},	//608 KTextEditor::ParameterizedSessionConfigInterface::ParameterizedSessionConfigInterface(const KTextEditor::ParameterizedSessionConfigInterface&)
    {49, 223, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 5},	//609 KTextEditor::ParameterizedSessionConfigInterface::SkipNone (enum)
    {49, 224, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 6},	//610 KTextEditor::ParameterizedSessionConfigInterface::SkipUrl (enum)
    {49, 222, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 7},	//611 KTextEditor::ParameterizedSessionConfigInterface::SkipMode (enum)
    {49, 221, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 8},	//612 KTextEditor::ParameterizedSessionConfigInterface::SkipHighlighting (enum)
    {49, 219, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 9},	//613 KTextEditor::ParameterizedSessionConfigInterface::SkipEncoding (enum)
    {49, 220, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 10},	//614 KTextEditor::ParameterizedSessionConfigInterface::SkipFolding (enum)
    {49, 1167, 0, 0, Smoke::mf_dtor, 0, 11 },	//615 KTextEditor::ParameterizedSessionConfigInterface::~ParameterizedSessionConfigInterface()
    {50, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//616 KTextEditor::Plugin::metaObject() const
    {50, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//617 KTextEditor::Plugin::qt_metacast(const char*)
    {50, 1078, 85, 2, Smoke::mf_static, 159, 3},	//618 KTextEditor::Plugin::tr(const char*, const char*)
    {50, 1082, 85, 2, Smoke::mf_static, 159, 4},	//619 KTextEditor::Plugin::trUtf8(const char*, const char*)
    {50, 1078, 88, 3, Smoke::mf_static, 159, 5},	//620 KTextEditor::Plugin::tr(const char*, const char*, int)
    {50, 1082, 88, 3, Smoke::mf_static, 159, 6},	//621 KTextEditor::Plugin::trUtf8(const char*, const char*, int)
    {50, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//622 KTextEditor::Plugin::qt_metacall(QMetaObject::Call, int, void**)
    {50, 183, 131, 1, Smoke::mf_ctor, 73, 8},	//623 KTextEditor::Plugin::Plugin(QObject*)
    {50, 280, 225, 1, Smoke::mf_virtual, 0, 9},	//624 KTextEditor::Plugin::addDocument(KTextEditor::Document*)
    {50, 841, 225, 1, Smoke::mf_virtual, 0, 10},	//625 KTextEditor::Plugin::removeDocument(KTextEditor::Document*)
    {50, 292, 179, 1, Smoke::mf_virtual, 0, 11},	//626 KTextEditor::Plugin::addView(KTextEditor::View*)
    {50, 860, 179, 1, Smoke::mf_virtual, 0, 12},	//627 KTextEditor::Plugin::removeView(KTextEditor::View*)
    {50, 1078, 70, 1, Smoke::mf_static, 159, 13},	//628 KTextEditor::Plugin::tr(const char*)
    {50, 1082, 70, 1, Smoke::mf_static, 159, 14},	//629 KTextEditor::Plugin::trUtf8(const char*)
    {50, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 15},	//630 KTextEditor::Plugin::staticMetaObject() const
    {50, 1168, 0, 0, Smoke::mf_dtor, 0, 16 },	//631 KTextEditor::Plugin::~Plugin()
    {51, 200, 0, 0, Smoke::mf_ctor, 76, 1},	//632 KTextEditor::Range::Range()
    {51, 200, 351, 2, Smoke::mf_ctor, 76, 2},	//633 KTextEditor::Range::Range(const KTextEditor::Cursor&, const KTextEditor::Cursor&)
    {51, 200, 354, 2, Smoke::mf_ctor, 76, 3},	//634 KTextEditor::Range::Range(const KTextEditor::Cursor&, int)
    {51, 200, 357, 3, Smoke::mf_ctor, 76, 4},	//635 KTextEditor::Range::Range(const KTextEditor::Cursor&, int, int)
    {51, 200, 361, 4, Smoke::mf_ctor, 76, 5},	//636 KTextEditor::Range::Range(int, int, int, int)
    {51, 200, 273, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 76, 6},	//637 KTextEditor::Range::Range(const KTextEditor::Range&)
    {51, 630, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 7},	//638 KTextEditor::Range::isValid() const
    {51, 621, 0, 0, Smoke::mf_static, 74, 8},	//639 KTextEditor::Range::invalid()
    {51, 629, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 9},	//640 KTextEditor::Range::isSmartRange() const
    {51, 1075, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 90, 10},	//641 KTextEditor::Range::toSmartRange() const
    {51, 1042, 0, 0, 0, 52, 11},	//642 KTextEditor::Range::start()
    {51, 1042, 0, 0, Smoke::mf_const, 281, 12},	//643 KTextEditor::Range::start() const
    {51, 524, 0, 0, 0, 52, 13},	//644 KTextEditor::Range::end()
    {51, 524, 0, 0, Smoke::mf_const, 281, 14},	//645 KTextEditor::Range::end() const
    {51, 907, 99, 1, 0, 0, 15},	//646 KTextEditor::Range::setBothLines(int)
    {51, 905, 99, 1, 0, 0, 16},	//647 KTextEditor::Range::setBothColumns(int)
    {51, 988, 273, 1, Smoke::mf_virtual, 0, 17},	//648 KTextEditor::Range::setRange(const KTextEditor::Range&)
    {51, 988, 351, 2, 0, 0, 18},	//649 KTextEditor::Range::setRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&)
    {51, 544, 273, 1, Smoke::mf_virtual, 264, 19},	//650 KTextEditor::Range::expandToRange(const KTextEditor::Range&)
    {51, 403, 273, 1, Smoke::mf_virtual, 264, 20},	//651 KTextEditor::Range::confineToRange(const KTextEditor::Range&)
    {51, 748, 0, 0, Smoke::mf_const, 264, 21},	//652 KTextEditor::Range::onSingleLine() const
    {51, 747, 0, 0, Smoke::mf_const, 338, 22},	//653 KTextEditor::Range::numberOfLines() const
    {51, 378, 0, 0, Smoke::mf_const, 338, 23},	//654 KTextEditor::Range::columnWidth() const
    {51, 626, 0, 0, Smoke::mf_const, 264, 24},	//655 KTextEditor::Range::isEmpty() const
    {51, 407, 273, 1, Smoke::mf_const, 264, 25},	//656 KTextEditor::Range::contains(const KTextEditor::Range&) const
    {51, 407, 215, 1, Smoke::mf_const, 264, 26},	//657 KTextEditor::Range::contains(const KTextEditor::Cursor&) const
    {51, 411, 99, 1, Smoke::mf_const, 264, 27},	//658 KTextEditor::Range::containsLine(int) const
    {51, 409, 99, 1, Smoke::mf_const, 264, 28},	//659 KTextEditor::Range::containsColumn(int) const
    {51, 762, 273, 1, Smoke::mf_const, 264, 29},	//660 KTextEditor::Range::overlaps(const KTextEditor::Range&) const
    {51, 766, 99, 1, Smoke::mf_const, 264, 30},	//661 KTextEditor::Range::overlapsLine(int) const
    {51, 764, 99, 1, Smoke::mf_const, 264, 31},	//662 KTextEditor::Range::overlapsColumn(int) const
    {51, 785, 215, 1, Smoke::mf_const, 338, 32},	//663 KTextEditor::Range::positionRelativeToCursor(const KTextEditor::Cursor&) const
    {51, 787, 99, 1, Smoke::mf_const, 338, 33},	//664 KTextEditor::Range::positionRelativeToLine(int) const
    {51, 323, 215, 1, Smoke::mf_const, 264, 34},	//665 KTextEditor::Range::boundaryAtCursor(const KTextEditor::Cursor&) const
    {51, 325, 99, 1, Smoke::mf_const, 264, 35},	//666 KTextEditor::Range::boundaryOnLine(int) const
    {51, 619, 273, 1, Smoke::mf_const, 74, 36},	//667 KTextEditor::Range::intersect(const KTextEditor::Range&) const
    {51, 522, 273, 1, Smoke::mf_const, 74, 37},	//668 KTextEditor::Range::encompass(const KTextEditor::Range&) const
    {51, 755, 273, 1, 0, 75, 38},	//669 KTextEditor::Range::operator=(const KTextEditor::Range&)
    {51, 200, 366, 2, Smoke::mf_ctor|Smoke::mf_protected, 76, 39},	//670 KTextEditor::Range::Range(KTextEditor::Cursor*, KTextEditor::Cursor*)
    {51, 808, 369, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 40},	//671 KTextEditor::Range::rangeChanged(KTextEditor::Cursor*, const KTextEditor::Range&)
    {51, 652, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 53, 41},	//672 KTextEditor::Range::m_start() const
    {51, 957, 372, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 42},	//673 KTextEditor::Range::setM_start(KTextEditor::Cursor*)
    {51, 649, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 53, 43},	//674 KTextEditor::Range::m_end() const
    {51, 951, 372, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 44},	//675 KTextEditor::Range::setM_end(KTextEditor::Cursor*)
    {51, 1169, 0, 0, Smoke::mf_dtor, 0, 45 },	//676 KTextEditor::Range::~Range()
    {52, 535, 374, 4, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 1},	//677 KTextEditor::RangeCommand::exec(KTextEditor::View*, const QString&, QString&, const KTextEditor::Range&) [pure virtual]
    {52, 1052, 196, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 2},	//678 KTextEditor::RangeCommand::supportsRange(const QString&) [pure virtual]
    {52, 206, 0, 0, Smoke::mf_ctor, 77, 3},	//679 KTextEditor::RangeCommand::RangeCommand()
    {52, 206, 379, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 77, 4},	//680 KTextEditor::RangeCommand::RangeCommand(const KTextEditor::RangeCommand&)
    {52, 1170, 0, 0, Smoke::mf_dtor, 0, 5 },	//681 KTextEditor::RangeCommand::~RangeCommand()
    {53, 211, 0, 0, Smoke::mf_ctor, 80, 1},	//682 KTextEditor::SearchInterface::SearchInterface()
    {53, 881, 381, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 168, 2},	//683 KTextEditor::SearchInterface::searchText(const KTextEditor::Range&, const QString&, const QFlags<KTextEditor::Search::SearchOptionsEnum>) [pure virtual]
    {53, 1051, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 123, 3},	//684 KTextEditor::SearchInterface::supportedSearchOptions() const [pure virtual]
    {53, 211, 385, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 80, 4},	//685 KTextEditor::SearchInterface::SearchInterface(const KTextEditor::SearchInterface&)
    {53, 881, 281, 2, 0, 168, 5},	//686 KTextEditor::SearchInterface::searchText(const KTextEditor::Range&, const QString&)
    {53, 1171, 0, 0, Smoke::mf_dtor, 0, 6 },	//687 KTextEditor::SearchInterface::~SearchInterface()
    {54, 215, 0, 0, Smoke::mf_ctor, 81, 1},	//688 KTextEditor::SessionConfigInterface::SessionConfigInterface()
    {54, 825, 387, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//689 KTextEditor::SessionConfigInterface::readSessionConfig(const KConfigGroup&) [pure virtual]
    {54, 1135, 389, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//690 KTextEditor::SessionConfigInterface::writeSessionConfig(KConfigGroup&) [pure virtual]
    {54, 215, 391, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 81, 4},	//691 KTextEditor::SessionConfigInterface::SessionConfigInterface(const KTextEditor::SessionConfigInterface&)
    {54, 1172, 0, 0, Smoke::mf_dtor, 0, 5 },	//692 KTextEditor::SessionConfigInterface::~SessionConfigInterface()
    {55, 628, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 1},	//693 KTextEditor::SmartCursor::isSmartCursor() const
    {55, 1074, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 83, 2},	//694 KTextEditor::SmartCursor::toSmartCursor() const
    {55, 1038, 0, 0, Smoke::mf_const, 90, 3},	//695 KTextEditor::SmartCursor::smartRange() const
    {55, 471, 0, 0, Smoke::mf_const, 54, 4},	//696 KTextEditor::SmartCursor::document() const
    {55, 313, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 5},	//697 KTextEditor::SmartCursor::atEndOfLine() const
    {55, 312, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 6},	//698 KTextEditor::SmartCursor::atEndOfDocument() const
    {55, 630, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 7},	//699 KTextEditor::SmartCursor::isValid() const
    {55, 335, 0, 0, Smoke::mf_const, 108, 8},	//700 KTextEditor::SmartCursor::character() const
    {55, 611, 393, 2, Smoke::mf_virtual, 264, 9},	//701 KTextEditor::SmartCursor::insertText(const QStringList&, bool)
    {55, 298, 396, 2, Smoke::mf_virtual, 264, 10},	//702 KTextEditor::SmartCursor::advance(int, KTextEditor::SmartCursor::AdvanceMode)
    {55, 600, 0, 0, Smoke::mf_const, 85, 11},	//703 KTextEditor::SmartCursor::insertBehavior() const
    {55, 941, 399, 1, 0, 0, 12},	//704 KTextEditor::SmartCursor::setInsertBehavior(KTextEditor::SmartCursor::InsertBehavior)
    {55, 572, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 13},	//705 KTextEditor::SmartCursor::hasNotifier() const [pure virtual]
    {55, 745, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 86, 14},	//706 KTextEditor::SmartCursor::notifier() [pure virtual]
    {55, 458, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 15},	//707 KTextEditor::SmartCursor::deleteNotifier() [pure virtual]
    {55, 1124, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 87, 16},	//708 KTextEditor::SmartCursor::watcher() const [pure virtual]
    {55, 1017, 401, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 17},	//709 KTextEditor::SmartCursor::setWatcher(KTextEditor::SmartCursorWatcher*) [pure virtual]
    {55, 755, 403, 1, 0, 82, 18},	//710 KTextEditor::SmartCursor::operator=(const KTextEditor::SmartCursor&)
    {55, 226, 405, 3, Smoke::mf_ctor|Smoke::mf_protected, 83, 19},	//711 KTextEditor::SmartCursor::SmartCursor(const KTextEditor::Cursor&, KTextEditor::Document*, KTextEditor::SmartCursor::InsertBehavior)
    {55, 611, 233, 1, 0, 264, 20},	//712 KTextEditor::SmartCursor::insertText(const QStringList&)
    {55, 298, 99, 1, 0, 264, 21},	//713 KTextEditor::SmartCursor::advance(int)
    {55, 1017, 0, 0, 0, 0, 22},	//714 KTextEditor::SmartCursor::setWatcher()
    {55, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 23},	//715 KTextEditor::SmartCursor::ByCharacter (enum)
    {55, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 24},	//716 KTextEditor::SmartCursor::ByCursorPosition (enum)
    {55, 243, 0, 0, Smoke::mf_static|Smoke::mf_enum, 85, 25},	//717 KTextEditor::SmartCursor::StayOnInsert (enum)
    {55, 168, 0, 0, Smoke::mf_static|Smoke::mf_enum, 85, 26},	//718 KTextEditor::SmartCursor::MoveOnInsert (enum)
    {55, 1173, 0, 0, Smoke::mf_dtor, 0, 27 },	//719 KTextEditor::SmartCursor::~SmartCursor()
    {56, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//720 KTextEditor::SmartCursorNotifier::metaObject() const
    {56, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//721 KTextEditor::SmartCursorNotifier::qt_metacast(const char*)
    {56, 1078, 85, 2, Smoke::mf_static, 159, 3},	//722 KTextEditor::SmartCursorNotifier::tr(const char*, const char*)
    {56, 1082, 85, 2, Smoke::mf_static, 159, 4},	//723 KTextEditor::SmartCursorNotifier::trUtf8(const char*, const char*)
    {56, 1078, 88, 3, Smoke::mf_static, 159, 5},	//724 KTextEditor::SmartCursorNotifier::tr(const char*, const char*, int)
    {56, 1082, 88, 3, Smoke::mf_static, 159, 6},	//725 KTextEditor::SmartCursorNotifier::trUtf8(const char*, const char*, int)
    {56, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//726 KTextEditor::SmartCursorNotifier::qt_metacall(QMetaObject::Call, int, void**)
    {56, 228, 0, 0, Smoke::mf_ctor, 86, 8},	//727 KTextEditor::SmartCursorNotifier::SmartCursorNotifier()
    {56, 1121, 0, 0, Smoke::mf_const, 264, 9},	//728 KTextEditor::SmartCursorNotifier::wantsDirectChanges() const
    {56, 1015, 17, 1, 0, 0, 10},	//729 KTextEditor::SmartCursorNotifier::setWantsDirectChanges(bool)
    {56, 781, 409, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 11},	//730 KTextEditor::SmartCursorNotifier::positionChanged(KTextEditor::SmartCursor*)
    {56, 783, 409, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//731 KTextEditor::SmartCursorNotifier::positionDeleted(KTextEditor::SmartCursor*)
    {56, 337, 411, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//732 KTextEditor::SmartCursorNotifier::characterDeleted(KTextEditor::SmartCursor*, bool)
    {56, 339, 411, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//733 KTextEditor::SmartCursorNotifier::characterInserted(KTextEditor::SmartCursor*, bool)
    {56, 463, 409, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//734 KTextEditor::SmartCursorNotifier::deleted(KTextEditor::SmartCursor*)
    {56, 1078, 70, 1, Smoke::mf_static, 159, 16},	//735 KTextEditor::SmartCursorNotifier::tr(const char*)
    {56, 1082, 70, 1, Smoke::mf_static, 159, 17},	//736 KTextEditor::SmartCursorNotifier::trUtf8(const char*)
    {56, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 18},	//737 KTextEditor::SmartCursorNotifier::staticMetaObject() const
    {56, 1174, 0, 0, Smoke::mf_dtor, 0, 19 },	//738 KTextEditor::SmartCursorNotifier::~SmartCursorNotifier()
    {57, 229, 0, 0, Smoke::mf_ctor, 87, 1},	//739 KTextEditor::SmartCursorWatcher::SmartCursorWatcher()
    {57, 1121, 0, 0, Smoke::mf_const, 264, 2},	//740 KTextEditor::SmartCursorWatcher::wantsDirectChanges() const
    {57, 1015, 17, 1, 0, 0, 3},	//741 KTextEditor::SmartCursorWatcher::setWantsDirectChanges(bool)
    {57, 781, 409, 1, Smoke::mf_virtual, 0, 4},	//742 KTextEditor::SmartCursorWatcher::positionChanged(KTextEditor::SmartCursor*)
    {57, 783, 409, 1, Smoke::mf_virtual, 0, 5},	//743 KTextEditor::SmartCursorWatcher::positionDeleted(KTextEditor::SmartCursor*)
    {57, 337, 411, 2, Smoke::mf_virtual, 0, 6},	//744 KTextEditor::SmartCursorWatcher::characterDeleted(KTextEditor::SmartCursor*, bool)
    {57, 339, 411, 2, Smoke::mf_virtual, 0, 7},	//745 KTextEditor::SmartCursorWatcher::characterInserted(KTextEditor::SmartCursor*, bool)
    {57, 463, 409, 1, Smoke::mf_virtual, 0, 8},	//746 KTextEditor::SmartCursorWatcher::deleted(KTextEditor::SmartCursor*)
    {57, 229, 414, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 87, 9},	//747 KTextEditor::SmartCursorWatcher::SmartCursorWatcher(const KTextEditor::SmartCursorWatcher&)
    {57, 1175, 0, 0, Smoke::mf_dtor, 0, 10 },	//748 KTextEditor::SmartCursorWatcher::~SmartCursorWatcher()
    {58, 231, 0, 0, Smoke::mf_ctor, 88, 1},	//749 KTextEditor::SmartInterface::SmartInterface()
    {58, 1037, 0, 0, Smoke::mf_const, 147, 2},	//750 KTextEditor::SmartInterface::smartMutex() const
    {58, 363, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//751 KTextEditor::SmartInterface::clearSmartInterface() [pure virtual]
    {58, 361, 0, 0, Smoke::mf_const, 264, 4},	//752 KTextEditor::SmartInterface::clearOnDocumentReload() const
    {58, 909, 17, 1, 0, 0, 5},	//753 KTextEditor::SmartInterface::setClearOnDocumentReload(bool)
    {58, 429, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 338, 6},	//754 KTextEditor::SmartInterface::currentRevision() const [pure virtual]
    {58, 832, 99, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 7},	//755 KTextEditor::SmartInterface::releaseRevision(int) const [pure virtual]
    {58, 1098, 99, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 8},	//756 KTextEditor::SmartInterface::useRevision(int) [pure virtual]
    {58, 362, 0, 0, 0, 0, 9},	//757 KTextEditor::SmartInterface::clearRevision()
    {58, 1086, 416, 2, Smoke::mf_const|Smoke::mf_virtual, 51, 10},	//758 KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Cursor&, KTextEditor::SmartCursor::InsertBehavior) const
    {58, 1086, 419, 2, Smoke::mf_const|Smoke::mf_virtual, 74, 11},	//759 KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Range&, QFlags<KTextEditor::SmartRange::InsertBehavior>) const
    {58, 731, 416, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 83, 12},	//760 KTextEditor::SmartInterface::newSmartCursor(const KTextEditor::Cursor&, KTextEditor::SmartCursor::InsertBehavior) [pure virtual]
    {58, 731, 422, 3, 0, 83, 13},	//761 KTextEditor::SmartInterface::newSmartCursor(int, int, KTextEditor::SmartCursor::InsertBehavior)
    {58, 457, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 14},	//762 KTextEditor::SmartInterface::deleteCursors() [pure virtual]
    {58, 736, 426, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 90, 15},	//763 KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Range&, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>) [pure virtual]
    {58, 736, 430, 4, 0, 90, 16},	//764 KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>)
    {58, 736, 435, 6, 0, 90, 17},	//765 KTextEditor::SmartInterface::newSmartRange(int, int, int, int, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>)
    {58, 736, 442, 4, Smoke::mf_virtual|Smoke::mf_purevirtual, 90, 18},	//766 KTextEditor::SmartInterface::newSmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>) [pure virtual]
    {58, 1090, 447, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 19},	//767 KTextEditor::SmartInterface::unbindSmartRange(KTextEditor::SmartRange*) [pure virtual]
    {58, 460, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 20},	//768 KTextEditor::SmartInterface::deleteRanges() [pure virtual]
    {58, 282, 449, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 21},	//769 KTextEditor::SmartInterface::addHighlightToDocument(KTextEditor::SmartRange*, bool) [pure virtual]
    {58, 843, 447, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 22},	//770 KTextEditor::SmartInterface::removeHighlightFromDocument(KTextEditor::SmartRange*) [pure virtual]
    {58, 476, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 313, 23},	//771 KTextEditor::SmartInterface::documentHighlights() const [pure virtual]
    {58, 357, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 24},	//772 KTextEditor::SmartInterface::clearDocumentHighlights() [pure virtual]
    {58, 285, 452, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 25},	//773 KTextEditor::SmartInterface::addHighlightToView(KTextEditor::View*, KTextEditor::SmartRange*, bool) [pure virtual]
    {58, 845, 456, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 26},	//774 KTextEditor::SmartInterface::removeHighlightFromView(KTextEditor::View*, KTextEditor::SmartRange*) [pure virtual]
    {58, 1113, 179, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 313, 27},	//775 KTextEditor::SmartInterface::viewHighlights(KTextEditor::View*) const [pure virtual]
    {58, 366, 179, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 28},	//776 KTextEditor::SmartInterface::clearViewHighlights(KTextEditor::View*) [pure virtual]
    {58, 276, 447, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 29},	//777 KTextEditor::SmartInterface::addActionsToDocument(KTextEditor::SmartRange*) [pure virtual]
    {58, 836, 447, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 30},	//778 KTextEditor::SmartInterface::removeActionsFromDocument(KTextEditor::SmartRange*) [pure virtual]
    {58, 472, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 313, 31},	//779 KTextEditor::SmartInterface::documentActions() const [pure virtual]
    {58, 356, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 32},	//780 KTextEditor::SmartInterface::clearDocumentActions() [pure virtual]
    {58, 278, 456, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 33},	//781 KTextEditor::SmartInterface::addActionsToView(KTextEditor::View*, KTextEditor::SmartRange*) [pure virtual]
    {58, 838, 456, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 34},	//782 KTextEditor::SmartInterface::removeActionsFromView(KTextEditor::View*, KTextEditor::SmartRange*) [pure virtual]
    {58, 1106, 179, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 313, 35},	//783 KTextEditor::SmartInterface::viewActions(KTextEditor::View*) const [pure virtual]
    {58, 364, 179, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 36},	//784 KTextEditor::SmartInterface::clearViewActions(KTextEditor::View*) [pure virtual]
    {58, 317, 459, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 37},	//785 KTextEditor::SmartInterface::attributeDynamic(KSharedPtr<KTextEditor::Attribute>) [pure virtual]
    {58, 319, 459, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 38},	//786 KTextEditor::SmartInterface::attributeNotDynamic(KSharedPtr<KTextEditor::Attribute>) [pure virtual]
    {58, 231, 461, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 88, 39},	//787 KTextEditor::SmartInterface::SmartInterface(const KTextEditor::SmartInterface&)
    {58, 1086, 215, 1, Smoke::mf_const, 51, 40},	//788 KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Cursor&) const
    {58, 1086, 273, 1, Smoke::mf_const, 74, 41},	//789 KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Range&) const
    {58, 731, 0, 0, 0, 83, 42},	//790 KTextEditor::SmartInterface::newSmartCursor()
    {58, 731, 215, 1, 0, 83, 43},	//791 KTextEditor::SmartInterface::newSmartCursor(const KTextEditor::Cursor&)
    {58, 731, 150, 2, 0, 83, 44},	//792 KTextEditor::SmartInterface::newSmartCursor(int, int)
    {58, 736, 0, 0, 0, 90, 45},	//793 KTextEditor::SmartInterface::newSmartRange()
    {58, 736, 273, 1, 0, 90, 46},	//794 KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Range&)
    {58, 736, 463, 2, 0, 90, 47},	//795 KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Range&, KTextEditor::SmartRange*)
    {58, 736, 351, 2, 0, 90, 48},	//796 KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&)
    {58, 736, 466, 3, 0, 90, 49},	//797 KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&, KTextEditor::SmartRange*)
    {58, 736, 361, 4, 0, 90, 50},	//798 KTextEditor::SmartInterface::newSmartRange(int, int, int, int)
    {58, 736, 470, 5, 0, 90, 51},	//799 KTextEditor::SmartInterface::newSmartRange(int, int, int, int, KTextEditor::SmartRange*)
    {58, 736, 476, 2, 0, 90, 52},	//800 KTextEditor::SmartInterface::newSmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*)
    {58, 736, 479, 3, 0, 90, 53},	//801 KTextEditor::SmartInterface::newSmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*)
    {58, 282, 447, 1, 0, 0, 54},	//802 KTextEditor::SmartInterface::addHighlightToDocument(KTextEditor::SmartRange*)
    {58, 285, 456, 2, 0, 0, 55},	//803 KTextEditor::SmartInterface::addHighlightToView(KTextEditor::View*, KTextEditor::SmartRange*)
    {58, 1176, 0, 0, Smoke::mf_dtor, 0, 56 },	//804 KTextEditor::SmartInterface::~SmartInterface()
    {59, 629, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 1},	//805 KTextEditor::SmartRange::isSmartRange() const
    {59, 1075, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 90, 2},	//806 KTextEditor::SmartRange::toSmartRange() const
    {59, 988, 273, 1, Smoke::mf_virtual, 0, 3},	//807 KTextEditor::SmartRange::setRange(const KTextEditor::Range&)
    {59, 1039, 0, 0, 0, 82, 4},	//808 KTextEditor::SmartRange::smartStart()
    {59, 1039, 0, 0, Smoke::mf_const, 294, 5},	//809 KTextEditor::SmartRange::smartStart() const
    {59, 1036, 0, 0, 0, 82, 6},	//810 KTextEditor::SmartRange::smartEnd()
    {59, 1036, 0, 0, Smoke::mf_const, 294, 7},	//811 KTextEditor::SmartRange::smartEnd() const
    {59, 403, 273, 1, Smoke::mf_virtual, 264, 8},	//812 KTextEditor::SmartRange::confineToRange(const KTextEditor::Range&)
    {59, 544, 273, 1, Smoke::mf_virtual, 264, 9},	//813 KTextEditor::SmartRange::expandToRange(const KTextEditor::Range&)
    {59, 471, 0, 0, Smoke::mf_const, 54, 10},	//814 KTextEditor::SmartRange::document() const
    {59, 1056, 17, 1, Smoke::mf_const|Smoke::mf_virtual, 161, 11},	//815 KTextEditor::SmartRange::text(bool) const
    {59, 864, 393, 2, Smoke::mf_virtual, 264, 12},	//816 KTextEditor::SmartRange::replaceText(const QStringList&, bool)
    {59, 856, 17, 1, Smoke::mf_virtual, 264, 13},	//817 KTextEditor::SmartRange::removeText(bool)
    {59, 600, 0, 0, Smoke::mf_const, 124, 14},	//818 KTextEditor::SmartRange::insertBehavior() const
    {59, 941, 483, 1, 0, 0, 15},	//819 KTextEditor::SmartRange::setInsertBehavior(QFlags<KTextEditor::SmartRange::InsertBehavior>)
    {59, 773, 0, 0, Smoke::mf_const, 90, 16},	//820 KTextEditor::SmartRange::parentRange() const
    {59, 983, 447, 1, Smoke::mf_virtual, 0, 17},	//821 KTextEditor::SmartRange::setParentRange(KTextEditor::SmartRange*)
    {59, 573, 447, 1, Smoke::mf_const, 264, 18},	//822 KTextEditor::SmartRange::hasParent(KTextEditor::SmartRange*) const
    {59, 465, 0, 0, Smoke::mf_const, 338, 19},	//823 KTextEditor::SmartRange::depth() const
    {59, 1076, 0, 0, Smoke::mf_const, 90, 20},	//824 KTextEditor::SmartRange::topParentRange() const
    {59, 351, 0, 0, Smoke::mf_const, 314, 21},	//825 KTextEditor::SmartRange::childRanges() const
    {59, 355, 0, 0, 0, 0, 22},	//826 KTextEditor::SmartRange::clearChildRanges()
    {59, 456, 0, 0, 0, 0, 23},	//827 KTextEditor::SmartRange::deleteChildRanges()
    {59, 353, 0, 0, 0, 0, 24},	//828 KTextEditor::SmartRange::clearAndDeleteChildRanges()
    {59, 344, 485, 1, Smoke::mf_const, 90, 25},	//829 KTextEditor::SmartRange::childBefore(const KTextEditor::SmartRange*) const
    {59, 342, 485, 1, Smoke::mf_const, 90, 26},	//830 KTextEditor::SmartRange::childAfter(const KTextEditor::SmartRange*) const
    {59, 715, 273, 1, Smoke::mf_const, 90, 27},	//831 KTextEditor::SmartRange::mostSpecificRange(const KTextEditor::Range&) const
    {59, 549, 215, 1, Smoke::mf_const, 90, 28},	//832 KTextEditor::SmartRange::firstRangeContaining(const KTextEditor::Cursor&) const
    {59, 444, 487, 3, Smoke::mf_const, 90, 29},	//833 KTextEditor::SmartRange::deepestRangeContaining(const KTextEditor::Cursor&, QStack<KTextEditor::SmartRange*>*, QStack<KTextEditor::SmartRange*>*) const
    {59, 448, 215, 1, Smoke::mf_const, 136, 30},	//834 KTextEditor::SmartRange::deepestRangesContaining(const KTextEditor::Cursor&) const
    {59, 761, 0, 0, Smoke::mf_const, 338, 31},	//835 KTextEditor::SmartRange::overlapCount() const
    {59, 316, 0, 0, Smoke::mf_const, 16, 32},	//836 KTextEditor::SmartRange::attribute() const
    {59, 897, 459, 1, 0, 0, 33},	//837 KTextEditor::SmartRange::setAttribute(KSharedPtr<KTextEditor::Attribute>)
    {59, 309, 491, 1, 0, 0, 34},	//838 KTextEditor::SmartRange::associateAction(KAction*)
    {59, 469, 491, 1, 0, 0, 35},	//839 KTextEditor::SmartRange::dissociateAction(KAction*)
    {59, 311, 0, 0, Smoke::mf_const, 311, 36},	//840 KTextEditor::SmartRange::associatedActions() const
    {59, 354, 0, 0, 0, 0, 37},	//841 KTextEditor::SmartRange::clearAssociatedActions()
    {59, 795, 0, 0, 0, 93, 38},	//842 KTextEditor::SmartRange::primaryNotifier()
    {59, 746, 0, 0, Smoke::mf_const, 315, 39},	//843 KTextEditor::SmartRange::notifiers() const
    {59, 290, 493, 1, 0, 0, 40},	//844 KTextEditor::SmartRange::addNotifier(KTextEditor::SmartRangeNotifier*)
    {59, 851, 493, 1, 0, 0, 41},	//845 KTextEditor::SmartRange::removeNotifier(KTextEditor::SmartRangeNotifier*)
    {59, 459, 0, 0, 0, 0, 42},	//846 KTextEditor::SmartRange::deletePrimaryNotifier()
    {59, 1125, 0, 0, Smoke::mf_const, 316, 43},	//847 KTextEditor::SmartRange::watchers() const
    {59, 296, 495, 1, 0, 0, 44},	//848 KTextEditor::SmartRange::addWatcher(KTextEditor::SmartRangeWatcher*)
    {59, 862, 495, 1, 0, 0, 45},	//849 KTextEditor::SmartRange::removeWatcher(KTextEditor::SmartRangeWatcher*)
    {59, 755, 497, 1, 0, 89, 46},	//850 KTextEditor::SmartRange::operator=(const KTextEditor::SmartRange&)
    {59, 755, 273, 1, 0, 89, 47},	//851 KTextEditor::SmartRange::operator=(const KTextEditor::Range&)
    {59, 233, 442, 4, Smoke::mf_ctor|Smoke::mf_protected, 90, 48},	//852 KTextEditor::SmartRange::SmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>)
    {59, 808, 369, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 49},	//853 KTextEditor::SmartRange::rangeChanged(KTextEditor::Cursor*, const KTextEditor::Range&)
    {59, 341, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 50},	//854 KTextEditor::SmartRange::checkFeedback()
    {59, 422, 0, 0, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 93, 51},	//855 KTextEditor::SmartRange::createNotifier() [pure virtual]
    {59, 827, 0, 0, Smoke::mf_protected, 0, 52},	//856 KTextEditor::SmartRange::rebuildChildStructure()
    {59, 1056, 0, 0, Smoke::mf_const, 161, 53},	//857 KTextEditor::SmartRange::text() const
    {59, 864, 233, 1, 0, 264, 54},	//858 KTextEditor::SmartRange::replaceText(const QStringList&)
    {59, 856, 0, 0, 0, 264, 55},	//859 KTextEditor::SmartRange::removeText()
    {59, 444, 215, 1, Smoke::mf_const, 90, 56},	//860 KTextEditor::SmartRange::deepestRangeContaining(const KTextEditor::Cursor&) const
    {59, 444, 499, 2, Smoke::mf_const, 90, 57},	//861 KTextEditor::SmartRange::deepestRangeContaining(const KTextEditor::Cursor&, QStack<KTextEditor::SmartRange*>*) const
    {59, 233, 476, 2, Smoke::mf_ctor|Smoke::mf_protected, 90, 58},	//862 KTextEditor::SmartRange::SmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*)
    {59, 233, 479, 3, Smoke::mf_ctor|Smoke::mf_protected, 90, 59},	//863 KTextEditor::SmartRange::SmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*)
    {59, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 91, 60},	//864 KTextEditor::SmartRange::DoNotExpand (enum)
    {59, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 91, 61},	//865 KTextEditor::SmartRange::ExpandLeft (enum)
    {59, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 91, 62},	//866 KTextEditor::SmartRange::ExpandRight (enum)
    {59, 1177, 0, 0, Smoke::mf_dtor, 0, 63 },	//867 KTextEditor::SmartRange::~SmartRange()
    {60, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//868 KTextEditor::SmartRangeNotifier::metaObject() const
    {60, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//869 KTextEditor::SmartRangeNotifier::qt_metacast(const char*)
    {60, 1078, 85, 2, Smoke::mf_static, 159, 3},	//870 KTextEditor::SmartRangeNotifier::tr(const char*, const char*)
    {60, 1082, 85, 2, Smoke::mf_static, 159, 4},	//871 KTextEditor::SmartRangeNotifier::trUtf8(const char*, const char*)
    {60, 1078, 88, 3, Smoke::mf_static, 159, 5},	//872 KTextEditor::SmartRangeNotifier::tr(const char*, const char*, int)
    {60, 1082, 88, 3, Smoke::mf_static, 159, 6},	//873 KTextEditor::SmartRangeNotifier::trUtf8(const char*, const char*, int)
    {60, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//874 KTextEditor::SmartRangeNotifier::qt_metacall(QMetaObject::Call, int, void**)
    {60, 237, 0, 0, Smoke::mf_ctor, 93, 8},	//875 KTextEditor::SmartRangeNotifier::SmartRangeNotifier()
    {60, 1121, 0, 0, Smoke::mf_const, 264, 9},	//876 KTextEditor::SmartRangeNotifier::wantsDirectChanges() const
    {60, 1015, 17, 1, 0, 0, 10},	//877 KTextEditor::SmartRangeNotifier::setWantsDirectChanges(bool)
    {60, 817, 447, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 11},	//878 KTextEditor::SmartRangeNotifier::rangePositionChanged(KTextEditor::SmartRange*)
    {60, 810, 447, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//879 KTextEditor::SmartRangeNotifier::rangeContentsChanged(KTextEditor::SmartRange*)
    {60, 810, 502, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//880 KTextEditor::SmartRangeNotifier::rangeContentsChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {60, 718, 505, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//881 KTextEditor::SmartRangeNotifier::mouseEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {60, 720, 505, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//882 KTextEditor::SmartRangeNotifier::mouseExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {60, 329, 505, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//883 KTextEditor::SmartRangeNotifier::caretEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {60, 331, 505, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//884 KTextEditor::SmartRangeNotifier::caretExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {60, 815, 447, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//885 KTextEditor::SmartRangeNotifier::rangeEliminated(KTextEditor::SmartRange*)
    {60, 813, 447, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//886 KTextEditor::SmartRangeNotifier::rangeDeleted(KTextEditor::SmartRange*)
    {60, 774, 508, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//887 KTextEditor::SmartRangeNotifier::parentRangeChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {60, 347, 502, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//888 KTextEditor::SmartRangeNotifier::childRangeInserted(KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {60, 349, 502, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//889 KTextEditor::SmartRangeNotifier::childRangeRemoved(KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {60, 806, 512, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 23},	//890 KTextEditor::SmartRangeNotifier::rangeAttributeChanged(KTextEditor::SmartRange*, KTextEditor::Attribute::Ptr, KTextEditor::Attribute::Ptr)
    {60, 1078, 70, 1, Smoke::mf_static, 159, 24},	//891 KTextEditor::SmartRangeNotifier::tr(const char*)
    {60, 1082, 70, 1, Smoke::mf_static, 159, 25},	//892 KTextEditor::SmartRangeNotifier::trUtf8(const char*)
    {60, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 26},	//893 KTextEditor::SmartRangeNotifier::staticMetaObject() const
    {60, 1178, 0, 0, Smoke::mf_dtor, 0, 27 },	//894 KTextEditor::SmartRangeNotifier::~SmartRangeNotifier()
    {61, 238, 0, 0, Smoke::mf_ctor, 94, 1},	//895 KTextEditor::SmartRangeWatcher::SmartRangeWatcher()
    {61, 1121, 0, 0, Smoke::mf_const, 264, 2},	//896 KTextEditor::SmartRangeWatcher::wantsDirectChanges() const
    {61, 1015, 17, 1, 0, 0, 3},	//897 KTextEditor::SmartRangeWatcher::setWantsDirectChanges(bool)
    {61, 817, 447, 1, Smoke::mf_virtual, 0, 4},	//898 KTextEditor::SmartRangeWatcher::rangePositionChanged(KTextEditor::SmartRange*)
    {61, 810, 447, 1, Smoke::mf_virtual, 0, 5},	//899 KTextEditor::SmartRangeWatcher::rangeContentsChanged(KTextEditor::SmartRange*)
    {61, 810, 502, 2, Smoke::mf_virtual, 0, 6},	//900 KTextEditor::SmartRangeWatcher::rangeContentsChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {61, 718, 505, 2, Smoke::mf_virtual, 0, 7},	//901 KTextEditor::SmartRangeWatcher::mouseEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {61, 720, 505, 2, Smoke::mf_virtual, 0, 8},	//902 KTextEditor::SmartRangeWatcher::mouseExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {61, 329, 505, 2, Smoke::mf_virtual, 0, 9},	//903 KTextEditor::SmartRangeWatcher::caretEnteredRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {61, 331, 505, 2, Smoke::mf_virtual, 0, 10},	//904 KTextEditor::SmartRangeWatcher::caretExitedRange(KTextEditor::SmartRange*, KTextEditor::View*)
    {61, 815, 447, 1, Smoke::mf_virtual, 0, 11},	//905 KTextEditor::SmartRangeWatcher::rangeEliminated(KTextEditor::SmartRange*)
    {61, 813, 447, 1, Smoke::mf_virtual, 0, 12},	//906 KTextEditor::SmartRangeWatcher::rangeDeleted(KTextEditor::SmartRange*)
    {61, 774, 508, 3, Smoke::mf_virtual, 0, 13},	//907 KTextEditor::SmartRangeWatcher::parentRangeChanged(KTextEditor::SmartRange*, KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {61, 347, 502, 2, Smoke::mf_virtual, 0, 14},	//908 KTextEditor::SmartRangeWatcher::childRangeInserted(KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {61, 349, 502, 2, Smoke::mf_virtual, 0, 15},	//909 KTextEditor::SmartRangeWatcher::childRangeRemoved(KTextEditor::SmartRange*, KTextEditor::SmartRange*)
    {61, 806, 516, 3, Smoke::mf_virtual, 0, 16},	//910 KTextEditor::SmartRangeWatcher::rangeAttributeChanged(KTextEditor::SmartRange*, KSharedPtr<KTextEditor::Attribute>, KSharedPtr<KTextEditor::Attribute>)
    {61, 238, 520, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 94, 17},	//911 KTextEditor::SmartRangeWatcher::SmartRangeWatcher(const KTextEditor::SmartRangeWatcher&)
    {61, 1179, 0, 0, Smoke::mf_dtor, 0, 18 },	//912 KTextEditor::SmartRangeWatcher::~SmartRangeWatcher()
    {62, 246, 0, 0, Smoke::mf_ctor, 95, 1},	//913 KTextEditor::TemplateInterface::TemplateInterface()
    {62, 542, 522, 2, Smoke::mf_static, 264, 2},	//914 KTextEditor::TemplateInterface::expandMacros(QMap<QString,QString>&, QWidget*)
    {62, 607, 525, 3, 0, 264, 3},	//915 KTextEditor::TemplateInterface::insertTemplateText(const KTextEditor::Cursor&, const QString&, const QMap<QString,QString>&)
    {62, 609, 525, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 4},	//916 KTextEditor::TemplateInterface::insertTemplateTextImplementation(const KTextEditor::Cursor&, const QString&, const QMap<QString,QString>&) [pure virtual]
    {62, 126, 529, 2, Smoke::mf_protected, 264, 5},	//917 KTextEditor::TemplateInterface::KTE_INTERNAL_setupIntialValues(const QString&, QMap<QString,QString>*)
    {62, 246, 532, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 95, 6},	//918 KTextEditor::TemplateInterface::TemplateInterface(const KTextEditor::TemplateInterface&)
    {62, 1180, 0, 0, Smoke::mf_dtor, 0, 7 },	//919 KTextEditor::TemplateInterface::~TemplateInterface()
    {63, 248, 0, 0, Smoke::mf_ctor, 96, 1},	//920 KTextEditor::TextHintInterface::TextHintInterface()
    {63, 518, 99, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//921 KTextEditor::TextHintInterface::enableTextHints(int) [pure virtual]
    {63, 467, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//922 KTextEditor::TextHintInterface::disableTextHints() [pure virtual]
    {63, 729, 534, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//923 KTextEditor::TextHintInterface::needTextHint(const KTextEditor::Cursor&, QString&) [pure virtual]
    {63, 248, 537, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 96, 5},	//924 KTextEditor::TextHintInterface::TextHintInterface(const KTextEditor::TextHintInterface&)
    {63, 1181, 0, 0, Smoke::mf_dtor, 0, 6 },	//925 KTextEditor::TextHintInterface::~TextHintInterface()
    {64, 256, 0, 0, Smoke::mf_ctor, 97, 1},	//926 KTextEditor::VariableInterface::VariableInterface()
    {64, 1100, 196, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 2},	//927 KTextEditor::VariableInterface::variable(const QString&) const [pure virtual]
    {64, 1102, 539, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//928 KTextEditor::VariableInterface::variableChanged(KTextEditor::Document*, const QString&, const QString&) [pure virtual]
    {64, 256, 543, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 97, 4},	//929 KTextEditor::VariableInterface::VariableInterface(const KTextEditor::VariableInterface&)
    {64, 1182, 0, 0, Smoke::mf_dtor, 0, 5 },	//930 KTextEditor::VariableInterface::~VariableInterface()
    {65, 699, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 323, 1},	//931 KTextEditor::View::metaObject() const
    {65, 800, 70, 1, Smoke::mf_virtual, 343, 2},	//932 KTextEditor::View::qt_metacast(const char*)
    {65, 1078, 85, 2, Smoke::mf_static, 159, 3},	//933 KTextEditor::View::tr(const char*, const char*)
    {65, 1082, 85, 2, Smoke::mf_static, 159, 4},	//934 KTextEditor::View::trUtf8(const char*, const char*)
    {65, 1078, 88, 3, Smoke::mf_static, 159, 5},	//935 KTextEditor::View::tr(const char*, const char*, int)
    {65, 1082, 88, 3, Smoke::mf_static, 159, 6},	//936 KTextEditor::View::trUtf8(const char*, const char*, int)
    {65, 798, 92, 3, Smoke::mf_virtual, 338, 7},	//937 KTextEditor::View::qt_metacall(QMetaObject::Call, int, void**)
    {65, 258, 10, 1, Smoke::mf_ctor, 98, 8},	//938 KTextEditor::View::View(QWidget*)
    {65, 471, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 54, 9},	//939 KTextEditor::View::document() const [pure virtual]
    {65, 622, 0, 0, Smoke::mf_const, 264, 10},	//940 KTextEditor::View::isActiveView() const
    {65, 1115, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 11},	//941 KTextEditor::View::viewMode() const [pure virtual]
    {65, 1110, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 99, 12},	//942 KTextEditor::View::viewEditMode() const [pure virtual]
    {65, 554, 179, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//943 KTextEditor::View::focusIn(KTextEditor::View*)
    {65, 558, 179, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//944 KTextEditor::View::focusOut(KTextEditor::View*)
    {65, 1116, 179, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//945 KTextEditor::View::viewModeChanged(KTextEditor::View*)
    {65, 1111, 545, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//946 KTextEditor::View::viewEditModeChanged(KTextEditor::View*, KTextEditor::View::EditMode)
    {65, 596, 193, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//947 KTextEditor::View::informationMessage(KTextEditor::View*, const QString&)
    {65, 1064, 548, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//948 KTextEditor::View::textInserted(KTextEditor::View*, const KTextEditor::Cursor&, const QString&)
    {65, 918, 552, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 19},	//949 KTextEditor::View::setContextMenu(QMenu*) [pure virtual]
    {65, 413, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 141, 20},	//950 KTextEditor::View::contextMenu() const [pure virtual]
    {65, 450, 552, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 141, 21},	//951 KTextEditor::View::defaultContextMenu(QMenu*) const [pure virtual]
    {65, 414, 554, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//952 KTextEditor::View::contextMenuAboutToShow(KTextEditor::View*, QMenu*)
    {65, 920, 557, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 23},	//953 KTextEditor::View::setCursorPosition(KTextEditor::Cursor) [pure virtual]
    {65, 434, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 51, 24},	//954 KTextEditor::View::cursorPosition() const [pure virtual]
    {65, 438, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 51, 25},	//955 KTextEditor::View::cursorPositionVirtual() const [pure virtual]
    {65, 439, 215, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 153, 26},	//956 KTextEditor::View::cursorToCoordinate(const KTextEditor::Cursor&) const [pure virtual]
    {65, 437, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 153, 27},	//957 KTextEditor::View::cursorPositionCoordinates() const [pure virtual]
    {65, 435, 162, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//958 KTextEditor::View::cursorPositionChanged(KTextEditor::View*, const KTextEditor::Cursor&)
    {65, 1104, 162, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//959 KTextEditor::View::verticalScrollPositionChanged(KTextEditor::View*, const KTextEditor::Cursor&)
    {65, 591, 179, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//960 KTextEditor::View::horizontalScrollPositionChanged(KTextEditor::View*)
    {65, 727, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 31},	//961 KTextEditor::View::mouseTrackingEnabled() const [pure virtual]
    {65, 973, 17, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 32},	//962 KTextEditor::View::setMouseTrackingEnabled(bool) [pure virtual]
    {65, 723, 162, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//963 KTextEditor::View::mousePositionChanged(KTextEditor::View*, const KTextEditor::Cursor&)
    {65, 999, 273, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 34},	//964 KTextEditor::View::setSelection(const KTextEditor::Range&) [pure virtual]
    {65, 999, 559, 3, Smoke::mf_virtual, 264, 35},	//965 KTextEditor::View::setSelection(const KTextEditor::Cursor&, int, bool)
    {65, 886, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 36},	//966 KTextEditor::View::selection() const [pure virtual]
    {65, 889, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 290, 37},	//967 KTextEditor::View::selectionRange() const [pure virtual]
    {65, 890, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 159, 38},	//968 KTextEditor::View::selectionText() const [pure virtual]
    {65, 854, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 39},	//969 KTextEditor::View::removeSelection() [pure virtual]
    {65, 855, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 40},	//970 KTextEditor::View::removeSelectionText() [pure virtual]
    {65, 903, 17, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 41},	//971 KTextEditor::View::setBlockSelection(bool) [pure virtual]
    {65, 322, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 264, 42},	//972 KTextEditor::View::blockSelection() const [pure virtual]
    {65, 887, 179, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//973 KTextEditor::View::selectionChanged(KTextEditor::View*)
    {65, 611, 196, 1, Smoke::mf_virtual, 264, 44},	//974 KTextEditor::View::insertText(const QString&)
    {65, 1078, 70, 1, Smoke::mf_static, 159, 45},	//975 KTextEditor::View::tr(const char*)
    {65, 1082, 70, 1, Smoke::mf_static, 159, 46},	//976 KTextEditor::View::trUtf8(const char*)
    {65, 450, 0, 0, Smoke::mf_const, 141, 47},	//977 KTextEditor::View::defaultContextMenu() const
    {65, 999, 354, 2, 0, 264, 48},	//978 KTextEditor::View::setSelection(const KTextEditor::Cursor&, int)
    {65, 1047, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 322, 49},	//979 KTextEditor::View::staticMetaObject() const
    {65, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 50},	//980 KTextEditor::View::EditInsert (enum)
    {65, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 51},	//981 KTextEditor::View::EditOverwrite (enum)
    {65, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 52},	//982 KTextEditor::View::EditViMode (enum)
    {65, 1183, 0, 0, Smoke::mf_dtor, 0, 53 },	//983 KTextEditor::View::~View()
    {66, 260, 0, 0, Smoke::mf_ctor, 100, 1},	//984 KTextEditor::ViewBarContainer::ViewBarContainer()
    {66, 564, 563, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 170, 2},	//985 KTextEditor::ViewBarContainer::getViewBarParent(KTextEditor::View*, KTextEditor::ViewBarContainer::Position) [pure virtual]
    {66, 294, 566, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 3},	//986 KTextEditor::ViewBarContainer::addViewBarToLayout(KTextEditor::View*, QWidget*, KTextEditor::ViewBarContainer::Position) [pure virtual]
    {66, 1030, 563, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//987 KTextEditor::ViewBarContainer::showViewBarForView(KTextEditor::View*, KTextEditor::ViewBarContainer::Position) [pure virtual]
    {66, 580, 563, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 5},	//988 KTextEditor::ViewBarContainer::hideViewBarForView(KTextEditor::View*, KTextEditor::ViewBarContainer::Position) [pure virtual]
    {66, 461, 563, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 6},	//989 KTextEditor::ViewBarContainer::deleteViewBarForView(KTextEditor::View*, KTextEditor::ViewBarContainer::Position) [pure virtual]
    {66, 260, 570, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 100, 7},	//990 KTextEditor::ViewBarContainer::ViewBarContainer(const KTextEditor::ViewBarContainer&)
    {66, 131, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 8},	//991 KTextEditor::ViewBarContainer::LeftBar (enum)
    {66, 250, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 9},	//992 KTextEditor::ViewBarContainer::TopBar (enum)
    {66, 208, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 10},	//993 KTextEditor::ViewBarContainer::RightBar (enum)
    {66, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 11},	//994 KTextEditor::ViewBarContainer::BottomBar (enum)
    {66, 1184, 0, 0, Smoke::mf_dtor, 0, 12 },	//995 KTextEditor::ViewBarContainer::~ViewBarContainer()
    {68, 272, 572, 1, Smoke::mf_const|Smoke::mf_virtual, 104, 0},	//996 KXMLGUIClient::action(const QDomElement&) const
    {68, 273, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 2, 0},	//997 KXMLGUIClient::actionCollection() const
    {68, 387, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 4, 0},	//998 KXMLGUIClient::componentData() const
    {68, 489, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 112, 0},	//999 KXMLGUIClient::domDocument() const
    {68, 1138, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 0},	//1000 KXMLGUIClient::xmlFile() const
    {68, 647, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 159, 0},	//1001 KXMLGUIClient::localXMLFile() const
    {68, 913, 25, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1002 KXMLGUIClient::setComponentData(const KComponentData&)
    {68, 1021, 574, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1003 KXMLGUIClient::setXMLFile(const QString&, bool, bool)
    {68, 948, 196, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1004 KXMLGUIClient::setLocalXMLFile(const QString&)
    {68, 1020, 295, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1005 KXMLGUIClient::setXML(const QString&, bool)
    {68, 922, 578, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1006 KXMLGUIClient::setDOMDocument(const QDomDocument&, bool)
    {68, 1046, 581, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1007 KXMLGUIClient::stateChanged(const QString&, KXMLGUIClient::ReverseStateChange)
    {68, 1119, 584, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1008 KXMLGUIClient::virtual_hook(int, void*)
    {68, 240, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 14},	//1009 KXMLGUIClient::StateNoReverse (enum)
    {68, 241, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 15},	//1010 KXMLGUIClient::StateReverse (enum)
    {69, 568, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 264, 0},	//1011 QAbstractItemModel::hasChildren(const QModelIndex&) const
    {69, 442, 587, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 167, 0},	//1012 QAbstractItemModel::data(const QModelIndex&, int) const [pure virtual]
    {69, 923, 590, 3, Smoke::mf_virtual, 264, 0},	//1013 QAbstractItemModel::setData(const QModelIndex&, const QVariant&, int)
    {69, 575, 594, 3, Smoke::mf_const|Smoke::mf_virtual, 167, 0},	//1014 QAbstractItemModel::headerData(int, Qt::Orientation, int) const
    {69, 938, 598, 4, Smoke::mf_virtual, 264, 0},	//1015 QAbstractItemModel::setHeaderData(int, Qt::Orientation, const QVariant&, int)
    {69, 943, 603, 2, Smoke::mf_virtual, 264, 0},	//1016 QAbstractItemModel::setItemData(const QModelIndex&, const QMap<int,QVariant>&)
    {69, 703, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 161, 0},	//1017 QAbstractItemModel::mimeTypes() const
    {69, 701, 606, 1, Smoke::mf_const|Smoke::mf_virtual, 143, 0},	//1018 QAbstractItemModel::mimeData(const QList<QModelIndex>&) const
    {69, 494, 608, 5, Smoke::mf_virtual, 264, 0},	//1019 QAbstractItemModel::dropMimeData(const QMimeData*, Qt::DropAction, int, int, const QModelIndex&)
    {69, 1050, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 126, 0},	//1020 QAbstractItemModel::supportedDropActions() const
    {69, 606, 143, 3, Smoke::mf_virtual, 264, 0},	//1021 QAbstractItemModel::insertRows(int, int, const QModelIndex&)
    {69, 601, 143, 3, Smoke::mf_virtual, 264, 0},	//1022 QAbstractItemModel::insertColumns(int, int, const QModelIndex&)
    {69, 853, 143, 3, Smoke::mf_virtual, 264, 0},	//1023 QAbstractItemModel::removeRows(int, int, const QModelIndex&)
    {69, 840, 143, 3, Smoke::mf_virtual, 264, 0},	//1024 QAbstractItemModel::removeColumns(int, int, const QModelIndex&)
    {69, 546, 141, 1, Smoke::mf_virtual, 0, 0},	//1025 QAbstractItemModel::fetchMore(const QModelIndex&)
    {69, 328, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 264, 0},	//1026 QAbstractItemModel::canFetchMore(const QModelIndex&) const
    {69, 553, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 127, 0},	//1027 QAbstractItemModel::flags(const QModelIndex&) const
    {69, 1040, 614, 2, Smoke::mf_virtual, 0, 0},	//1028 QAbstractItemModel::sort(int, Qt::SortOrder)
    {69, 327, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 144, 0},	//1029 QAbstractItemModel::buddy(const QModelIndex&) const
    {69, 696, 617, 5, Smoke::mf_const|Smoke::mf_virtual, 137, 0},	//1030 QAbstractItemModel::match(const QModelIndex&, int, const QVariant&, int, QFlags<Qt::MatchFlag>) const
    {69, 1041, 141, 1, Smoke::mf_const|Smoke::mf_virtual, 157, 0},	//1031 QAbstractItemModel::span(const QModelIndex&) const
    {69, 1049, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 264, 0},	//1032 QAbstractItemModel::submit()
    {69, 874, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//1033 QAbstractItemModel::revert()
    {87, 190, 0, 0, Smoke::mf_static|Smoke::mf_enum, 340, 1},	//1034 QGlobalSpace::Q_COMPLEX_TYPE (enum)
    {87, 193, 0, 0, Smoke::mf_static|Smoke::mf_enum, 340, 2},	//1035 QGlobalSpace::Q_PRIMITIVE_TYPE (enum)
    {87, 194, 0, 0, Smoke::mf_static|Smoke::mf_enum, 340, 3},	//1036 QGlobalSpace::Q_STATIC_TYPE (enum)
    {87, 192, 0, 0, Smoke::mf_static|Smoke::mf_enum, 340, 4},	//1037 QGlobalSpace::Q_MOVABLE_TYPE (enum)
    {87, 191, 0, 0, Smoke::mf_static|Smoke::mf_enum, 340, 5},	//1038 QGlobalSpace::Q_DUMMY_TYPE (enum)
    {87, 136, 0, 0, Smoke::mf_static|Smoke::mf_enum, 248, 6},	//1039 QGlobalSpace::LicensedGui (enum)
    {87, 149, 0, 0, Smoke::mf_static|Smoke::mf_enum, 261, 7},	//1040 QGlobalSpace::LicensedXml (enum)
    {87, 143, 0, 0, Smoke::mf_static|Smoke::mf_enum, 254, 8},	//1041 QGlobalSpace::LicensedQt3SupportLight (enum)
    {87, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 9},	//1042 QGlobalSpace::KST_KSycocaEntry (enum)
    {87, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 10},	//1043 QGlobalSpace::KST_KService (enum)
    {87, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 11},	//1044 QGlobalSpace::KST_KServiceType (enum)
    {87, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 12},	//1045 QGlobalSpace::KST_KMimeType (enum)
    {87, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 13},	//1046 QGlobalSpace::KST_KFolderMimeType (enum)
    {87, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 14},	//1047 QGlobalSpace::KST_KDEDesktopMimeType (enum)
    {87, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 15},	//1048 QGlobalSpace::KST_KMimeTypeEntry (enum)
    {87, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 16},	//1049 QGlobalSpace::KST_KServiceGroup (enum)
    {87, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 17},	//1050 QGlobalSpace::KST_KImageIOFormat (enum)
    {87, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 18},	//1051 QGlobalSpace::KST_KProtocolInfo (enum)
    {87, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 19},	//1052 QGlobalSpace::KST_KServiceSeparator (enum)
    {87, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 20},	//1053 QGlobalSpace::KST_KCustom (enum)
    {87, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 256, 21},	//1054 QGlobalSpace::LicensedScript (enum)
    {87, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 253, 22},	//1055 QGlobalSpace::LicensedOpenVG (enum)
    {87, 134, 0, 0, Smoke::mf_static|Smoke::mf_enum, 246, 23},	//1056 QGlobalSpace::LicensedDBus (enum)
    {87, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 260, 24},	//1057 QGlobalSpace::LicensedTest (enum)
    {87, 132, 0, 0, Smoke::mf_static|Smoke::mf_enum, 244, 25},	//1058 QGlobalSpace::LicensedActiveQt (enum)
    {87, 145, 0, 0, Smoke::mf_static|Smoke::mf_enum, 257, 26},	//1059 QGlobalSpace::LicensedScriptTools (enum)
    {87, 147, 0, 0, Smoke::mf_static|Smoke::mf_enum, 259, 27},	//1060 QGlobalSpace::LicensedSvg (enum)
    {87, 135, 0, 0, Smoke::mf_static|Smoke::mf_enum, 247, 28},	//1061 QGlobalSpace::LicensedDeclarative (enum)
    {87, 146, 0, 0, Smoke::mf_static|Smoke::mf_enum, 258, 29},	//1062 QGlobalSpace::LicensedSql (enum)
    {87, 140, 0, 0, Smoke::mf_static|Smoke::mf_enum, 252, 30},	//1063 QGlobalSpace::LicensedOpenGL (enum)
    {87, 133, 0, 0, Smoke::mf_static|Smoke::mf_enum, 245, 31},	//1064 QGlobalSpace::LicensedCore (enum)
    {87, 196, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 32},	//1065 QGlobalSpace::QtDebugMsg (enum)
    {87, 199, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 33},	//1066 QGlobalSpace::QtWarningMsg (enum)
    {87, 195, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 34},	//1067 QGlobalSpace::QtCriticalMsg (enum)
    {87, 197, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 35},	//1068 QGlobalSpace::QtFatalMsg (enum)
    {87, 198, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 36},	//1069 QGlobalSpace::QtSystemMsg (enum)
    {87, 137, 0, 0, Smoke::mf_static|Smoke::mf_enum, 249, 37},	//1070 QGlobalSpace::LicensedHelp (enum)
    {87, 138, 0, 0, Smoke::mf_static|Smoke::mf_enum, 250, 38},	//1071 QGlobalSpace::LicensedMultimedia (enum)
    {87, 142, 0, 0, Smoke::mf_static|Smoke::mf_enum, 255, 39},	//1072 QGlobalSpace::LicensedQt3Support (enum)
    {87, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 40},	//1073 QGlobalSpace::KST_KServiceFactory (enum)
    {87, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 41},	//1074 QGlobalSpace::KST_KServiceTypeFactory (enum)
    {87, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 42},	//1075 QGlobalSpace::KST_KServiceGroupFactory (enum)
    {87, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 43},	//1076 QGlobalSpace::KST_KImageIO (enum)
    {87, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 44},	//1077 QGlobalSpace::KST_KProtocolInfoFactory (enum)
    {87, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 45},	//1078 QGlobalSpace::KST_KMimeTypeFactory (enum)
    {87, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 46},	//1079 QGlobalSpace::KST_CTimeInfo (enum)
    {87, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 47},	//1080 QGlobalSpace::LicensedXmlPatterns (enum)
    {87, 139, 0, 0, Smoke::mf_static|Smoke::mf_enum, 251, 48},	//1081 QGlobalSpace::LicensedNetwork (enum)
    {99, 529, 19, 1, Smoke::mf_virtual, 264, 0},	//1082 QObject::event(QEvent*)
    {99, 530, 623, 2, Smoke::mf_virtual, 264, 0},	//1083 QObject::eventFilter(QObject*, QEvent*)
    {99, 1073, 626, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1084 QObject::timerEvent(QTimerEvent*)
    {99, 346, 628, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1085 QObject::childEvent(QChildEvent*)
    {99, 441, 19, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1086 QObject::customEvent(QEvent*)
    {99, 405, 70, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1087 QObject::connectNotify(const char*)
    {99, 468, 70, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1088 QObject::disconnectNotify(const char*)
    {116, 466, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 338, 0},	//1089 QWidget::devType() const
    {116, 1014, 17, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//1090 QWidget::setVisible(bool)
    {116, 1033, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 157, 0},	//1091 QWidget::sizeHint() const
    {116, 704, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 157, 0},	//1092 QWidget::minimumSizeHint() const
    {116, 576, 99, 1, Smoke::mf_const|Smoke::mf_virtual, 338, 0},	//1093 QWidget::heightForWidth(int) const
    {116, 768, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 150, 0},	//1094 QWidget::paintEngine() const
    {116, 529, 19, 1, Smoke::mf_protected|Smoke::mf_virtual, 264, 0},	//1095 QWidget::event(QEvent*)
    {116, 725, 630, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1096 QWidget::mousePressEvent(QMouseEvent*)
    {116, 726, 630, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1097 QWidget::mouseReleaseEvent(QMouseEvent*)
    {116, 717, 630, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1098 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {116, 722, 630, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1099 QWidget::mouseMoveEvent(QMouseEvent*)
    {116, 1126, 632, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1100 QWidget::wheelEvent(QWheelEvent*)
    {116, 633, 634, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1101 QWidget::keyPressEvent(QKeyEvent*)
    {116, 634, 634, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1102 QWidget::keyReleaseEvent(QKeyEvent*)
    {116, 556, 636, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1103 QWidget::focusInEvent(QFocusEvent*)
    {116, 560, 636, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1104 QWidget::focusOutEvent(QFocusEvent*)
    {116, 528, 19, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1105 QWidget::enterEvent(QEvent*)
    {116, 636, 19, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1106 QWidget::leaveEvent(QEvent*)
    {116, 769, 638, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1107 QWidget::paintEvent(QPaintEvent*)
    {116, 728, 640, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1108 QWidget::moveEvent(QMoveEvent*)
    {116, 873, 642, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1109 QWidget::resizeEvent(QResizeEvent*)
    {116, 370, 644, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1110 QWidget::closeEvent(QCloseEvent*)
    {116, 416, 646, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1111 QWidget::contextMenuEvent(QContextMenuEvent*)
    {116, 1055, 648, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1112 QWidget::tabletEvent(QTabletEvent*)
    {116, 274, 650, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1113 QWidget::actionEvent(QActionEvent*)
    {116, 490, 652, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1114 QWidget::dragEnterEvent(QDragEnterEvent*)
    {116, 492, 654, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1115 QWidget::dragMoveEvent(QDragMoveEvent*)
    {116, 491, 656, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1116 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {116, 493, 658, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1117 QWidget::dropEvent(QDropEvent*)
    {116, 1029, 660, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1118 QWidget::showEvent(QShowEvent*)
    {116, 579, 662, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1119 QWidget::hideEvent(QHideEvent*)
    {116, 1137, 664, 1, Smoke::mf_protected|Smoke::mf_virtual, 264, 0},	//1120 QWidget::x11Event(_XEvent*)
    {116, 333, 19, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1121 QWidget::changeEvent(QEvent*)
    {116, 700, 666, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 338, 0},	//1122 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {116, 598, 668, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1123 QWidget::inputMethodEvent(QInputMethodEvent*)
    {116, 599, 670, 1, Smoke::mf_const|Smoke::mf_virtual, 167, 0},	//1124 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {116, 557, 17, 1, Smoke::mf_protected|Smoke::mf_virtual, 264, 0},	//1125 QWidget::focusNextPrevChild(bool)
    {116, 1048, 672, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1126 QWidget::styleChange(QStyle&)
    {116, 520, 17, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1127 QWidget::enabledChange(bool)
    {116, 770, 674, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1128 QWidget::paletteChange(const QPalette&)
    {116, 562, 676, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1129 QWidget::fontChange(const QFont&)
    {116, 1128, 17, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1130 QWidget::windowActivationChange(bool)
    {116, 635, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//1131 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    29,  // KTextEditor::operator|(KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, QFlags<KTextEditor::CodeCompletionModel::HighlightMethods::enum_type>)
    31,  // KTextEditor::operator|(KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, int)
    33,  // KTextEditor::operator|(KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, QFlags<KTextEditor::CodeCompletionModel::CompletionProperties::enum_type>)
    34,  // KTextEditor::operator|(KTextEditor::SmartRange::InsertBehaviors::enum_type, int)
    35,  // KTextEditor::operator|(KTextEditor::SmartRange::InsertBehaviors::enum_type, QFlags<KTextEditor::SmartRange::InsertBehaviors::enum_type>)
    36,  // KTextEditor::operator|(KTextEditor::Attribute::Effects::enum_type, QFlags<KTextEditor::Attribute::Effects::enum_type>)
    38,  // KTextEditor::operator|(KTextEditor::Attribute::Effects::enum_type, int)
    41,  // KTextEditor::operator|(KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, int)
    0,
    30,  // KTextEditor::operator|(KTextEditor::SmartRange::InsertBehaviors::enum_type, KTextEditor::SmartRange::InsertBehaviors::enum_type)
    32,  // KTextEditor::operator|(KTextEditor::Attribute::Effects::enum_type, KTextEditor::Attribute::Effects::enum_type)
    37,  // KTextEditor::operator|(KTextEditor::CodeCompletionModel::CompletionProperties::enum_type, KTextEditor::CodeCompletionModel::CompletionProperties::enum_type)
    42,  // KTextEditor::operator|(KTextEditor::CodeCompletionModel::HighlightMethods::enum_type, KTextEditor::CodeCompletionModel::HighlightMethods::enum_type)
    0,
    633,  // KTextEditor::Range::Range(const KTextEditor::Cursor&, const KTextEditor::Cursor&)
    670,  // KTextEditor::Range::Range(KTextEditor::Cursor*, KTextEditor::Cursor*)
    0,
    656,  // KTextEditor::Range::contains(const KTextEditor::Range&) const
    657,  // KTextEditor::Range::contains(const KTextEditor::Cursor&) const
    0,
    644,  // KTextEditor::Range::end()
    645,  // KTextEditor::Range::end() const
    0,
    642,  // KTextEditor::Range::start()
    643,  // KTextEditor::Range::start() const
    0,
    850,  // KTextEditor::SmartRange::operator=(const KTextEditor::SmartRange&)
    851,  // KTextEditor::SmartRange::operator=(const KTextEditor::Range&)
    0,
    810,  // KTextEditor::SmartRange::smartEnd()
    811,  // KTextEditor::SmartRange::smartEnd() const
    0,
    808,  // KTextEditor::SmartRange::smartStart()
    809,  // KTextEditor::SmartRange::smartStart() const
    0,
    795,  // KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Range&, KTextEditor::SmartRange*)
    796,  // KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&)
    800,  // KTextEditor::SmartInterface::newSmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*)
    0,
    797,  // KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&, KTextEditor::SmartRange*)
    801,  // KTextEditor::SmartInterface::newSmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*)
    0,
    764,  // KTextEditor::SmartInterface::newSmartRange(const KTextEditor::Cursor&, const KTextEditor::Cursor&, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>)
    766,  // KTextEditor::SmartInterface::newSmartRange(KTextEditor::SmartCursor*, KTextEditor::SmartCursor*, KTextEditor::SmartRange*, QFlags<KTextEditor::SmartRange::InsertBehavior>)
    0,
    788,  // KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Cursor&) const
    789,  // KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Range&) const
    0,
    758,  // KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Cursor&, KTextEditor::SmartCursor::InsertBehavior) const
    759,  // KTextEditor::SmartInterface::translateFromRevision(const KTextEditor::Range&, QFlags<KTextEditor::SmartRange::InsertBehavior>) const
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {20, 426, 40},	// KTextEditor::createPlugin?#
    {20, 513, 39},	// KTextEditor::editor$
    {20, 758, -1},	// KTextEditor::operator|?$
    {20, 759, -10},	// KTextEditor::operator|??
    {21, 6, 45},	// KTextEditor::AnnotationInterface::AnnotationInterface
    {21, 7, 46},	// KTextEditor::AnnotationInterface::AnnotationInterface#
    {21, 307, 44},	// KTextEditor::AnnotationInterface::annotationModel
    {21, 896, 43},	// KTextEditor::AnnotationInterface::setAnnotationModel#
    {21, 1139, 47},	// KTextEditor::AnnotationInterface::~AnnotationInterface
    {22, 8, 58},	// KTextEditor::AnnotationModel::AnnotationModel
    {22, 94, 62},	// KTextEditor::AnnotationModel::GroupIdentifierRole
    {22, 443, 55},	// KTextEditor::AnnotationModel::data$$
    {22, 643, 57},	// KTextEditor::AnnotationModel::lineChanged$
    {22, 699, 48},	// KTextEditor::AnnotationModel::metaObject
    {22, 799, 54},	// KTextEditor::AnnotationModel::qt_metacall$$?
    {22, 801, 49},	// KTextEditor::AnnotationModel::qt_metacast$
    {22, 872, 56},	// KTextEditor::AnnotationModel::reset
    {22, 1047, 61},	// KTextEditor::AnnotationModel::staticMetaObject
    {22, 1079, 59},	// KTextEditor::AnnotationModel::tr$
    {22, 1080, 50},	// KTextEditor::AnnotationModel::tr$$
    {22, 1081, 52},	// KTextEditor::AnnotationModel::tr$$$
    {22, 1083, 60},	// KTextEditor::AnnotationModel::trUtf8$
    {22, 1084, 51},	// KTextEditor::AnnotationModel::trUtf8$$
    {22, 1085, 53},	// KTextEditor::AnnotationModel::trUtf8$$$
    {22, 1140, 63},	// KTextEditor::AnnotationModel::~AnnotationModel
    {23, 9, 69},	// KTextEditor::AnnotationViewInterface::AnnotationViewInterface
    {23, 10, 70},	// KTextEditor::AnnotationViewInterface::AnnotationViewInterface#
    {23, 302, 67},	// KTextEditor::AnnotationViewInterface::annotationActivated#$
    {23, 304, 68},	// KTextEditor::AnnotationViewInterface::annotationBorderVisibilityChanged#$
    {23, 306, 66},	// KTextEditor::AnnotationViewInterface::annotationContextMenuAboutToShow##$
    {23, 623, 65},	// KTextEditor::AnnotationViewInterface::isAnnotationBorderVisible
    {23, 894, 64},	// KTextEditor::AnnotationViewInterface::setAnnotationBorderVisible$
    {23, 1141, 71},	// KTextEditor::AnnotationViewInterface::~AnnotationViewInterface
    {24, 4, 103},	// KTextEditor::Attribute::ActivateCaretIn
    {24, 5, 102},	// KTextEditor::Attribute::ActivateMouseIn
    {24, 13, 72},	// KTextEditor::Attribute::Attribute
    {24, 14, 73},	// KTextEditor::Attribute::Attribute#
    {24, 18, 99},	// KTextEditor::Attribute::AttributeDynamicEffect
    {24, 19, 100},	// KTextEditor::Attribute::AttributeInternalProperty
    {24, 20, 101},	// KTextEditor::Attribute::AttributeUserProperty
    {24, 22, 98},	// KTextEditor::Attribute::BackgroundFillWhitespace
    {24, 77, 108},	// KTextEditor::Attribute::EffectCycleGradient
    {24, 78, 105},	// KTextEditor::Attribute::EffectFadeIn
    {24, 79, 106},	// KTextEditor::Attribute::EffectFadeOut
    {24, 80, 104},	// KTextEditor::Attribute::EffectNone
    {24, 81, 107},	// KTextEditor::Attribute::EffectPulse
    {24, 179, 95},	// KTextEditor::Attribute::Outline
    {24, 213, 97},	// KTextEditor::Attribute::SelectedBackground
    {24, 214, 96},	// KTextEditor::Attribute::SelectedForeground
    {24, 311, 86},	// KTextEditor::Attribute::associatedActions
    {24, 321, 82},	// KTextEditor::Attribute::backgroundFillWhitespace
    {24, 352, 84},	// KTextEditor::Attribute::clear
    {24, 354, 87},	// KTextEditor::Attribute::clearAssociatedActions
    {24, 510, 88},	// KTextEditor::Attribute::dynamicAttribute$
    {24, 515, 90},	// KTextEditor::Attribute::effects
    {24, 561, 74},	// KTextEditor::Attribute::fontBold
    {24, 567, 85},	// KTextEditor::Attribute::hasAnyProperty
    {24, 754, 92},	// KTextEditor::Attribute::operator+=#
    {24, 756, 93},	// KTextEditor::Attribute::operator=#
    {24, 760, 76},	// KTextEditor::Attribute::outline
    {24, 884, 80},	// KTextEditor::Attribute::selectedBackground
    {24, 885, 78},	// KTextEditor::Attribute::selectedForeground
    {24, 902, 83},	// KTextEditor::Attribute::setBackgroundFillWhitespace$
    {24, 927, 89},	// KTextEditor::Attribute::setDynamicAttribute$?
    {24, 931, 91},	// KTextEditor::Attribute::setEffects$
    {24, 934, 94},	// KTextEditor::Attribute::setFontBold
    {24, 935, 75},	// KTextEditor::Attribute::setFontBold$
    {24, 982, 77},	// KTextEditor::Attribute::setOutline#
    {24, 996, 81},	// KTextEditor::Attribute::setSelectedBackground#
    {24, 998, 79},	// KTextEditor::Attribute::setSelectedForeground#
    {24, 1142, 109},	// KTextEditor::Attribute::~Attribute
    {25, 32, 118},	// KTextEditor::CodeCompletionInterface::CodeCompletionInterface
    {25, 33, 119},	// KTextEditor::CodeCompletionInterface::CodeCompletionInterface#
    {25, 264, 112},	// KTextEditor::CodeCompletionInterface::abortCompletion
    {25, 563, 113},	// KTextEditor::CodeCompletionInterface::forceCompletion
    {25, 624, 116},	// KTextEditor::CodeCompletionInterface::isAutomaticInvocationEnabled
    {25, 625, 110},	// KTextEditor::CodeCompletionInterface::isCompletionActive
    {25, 831, 114},	// KTextEditor::CodeCompletionInterface::registerCompletionModel#
    {25, 899, 120},	// KTextEditor::CodeCompletionInterface::setAutomaticInvocationEnabled
    {25, 900, 117},	// KTextEditor::CodeCompletionInterface::setAutomaticInvocationEnabled$
    {25, 1044, 111},	// KTextEditor::CodeCompletionInterface::startCompletion##
    {25, 1095, 115},	// KTextEditor::CodeCompletionInterface::unregisterCompletionModel#
    {25, 1144, 121},	// KTextEditor::CodeCompletionInterface::~CodeCompletionInterface
    {26, 1, 199},	// KTextEditor::CodeCompletionModel::AccessibilityAccept
    {26, 2, 197},	// KTextEditor::CodeCompletionModel::AccessibilityNext
    {26, 3, 198},	// KTextEditor::CodeCompletionModel::AccessibilityPrevious
    {26, 11, 195},	// KTextEditor::CodeCompletionModel::ArgumentHintDepth
    {26, 12, 154},	// KTextEditor::CodeCompletionModel::Arguments
    {26, 21, 203},	// KTextEditor::CodeCompletionModel::AutomaticInvocation
    {26, 23, 196},	// KTextEditor::CodeCompletionModel::BestMatchesCount
    {26, 31, 164},	// KTextEditor::CodeCompletionModel::Class
    {26, 35, 129},	// KTextEditor::CodeCompletionModel::CodeCompletionModel#
    {26, 42, 148},	// KTextEditor::CodeCompletionModel::ColumnCount
    {26, 49, 185},	// KTextEditor::CodeCompletionModel::CompletionRole
    {26, 54, 162},	// KTextEditor::CodeCompletionModel::Const
    {26, 62, 190},	// KTextEditor::CodeCompletionModel::CustomHighlight
    {26, 63, 184},	// KTextEditor::CodeCompletionModel::CustomHighlighting
    {26, 82, 169},	// KTextEditor::CodeCompletionModel::Enum
    {26, 87, 193},	// KTextEditor::CodeCompletionModel::ExpandingWidget
    {26, 90, 157},	// KTextEditor::CodeCompletionModel::FirstProperty
    {26, 91, 175},	// KTextEditor::CodeCompletionModel::Friend
    {26, 92, 167},	// KTextEditor::CodeCompletionModel::Function
    {26, 93, 180},	// KTextEditor::CodeCompletionModel::GlobalScope
    {26, 95, 200},	// KTextEditor::CodeCompletionModel::GroupRole
    {26, 99, 189},	// KTextEditor::CodeCompletionModel::HighlightingMethod
    {26, 100, 151},	// KTextEditor::CodeCompletionModel::Icon
    {26, 102, 191},	// KTextEditor::CodeCompletionModel::InheritanceDepth
    {26, 103, 174},	// KTextEditor::CodeCompletionModel::Inline
    {26, 104, 183},	// KTextEditor::CodeCompletionModel::InternalHighlighting
    {26, 105, 192},	// KTextEditor::CodeCompletionModel::IsExpandable
    {26, 106, 194},	// KTextEditor::CodeCompletionModel::ItemSelected
    {26, 128, 202},	// KTextEditor::CodeCompletionModel::LastExtraItemDataRole
    {26, 129, 149},	// KTextEditor::CodeCompletionModel::LastItemDataRole
    {26, 130, 181},	// KTextEditor::CodeCompletionModel::LastProperty
    {26, 155, 178},	// KTextEditor::CodeCompletionModel::LocalScope
    {26, 156, 205},	// KTextEditor::CodeCompletionModel::ManualInvocation
    {26, 163, 187},	// KTextEditor::CodeCompletionModel::MatchQuality
    {26, 169, 153},	// KTextEditor::CodeCompletionModel::Name
    {26, 170, 163},	// KTextEditor::CodeCompletionModel::Namespace
    {26, 171, 179},	// KTextEditor::CodeCompletionModel::NamespaceScope
    {26, 172, 182},	// KTextEditor::CodeCompletionModel::NoHighlighting
    {26, 173, 156},	// KTextEditor::CodeCompletionModel::NoProperty
    {26, 180, 173},	// KTextEditor::CodeCompletionModel::Override
    {26, 185, 155},	// KTextEditor::CodeCompletionModel::Postfix
    {26, 186, 150},	// KTextEditor::CodeCompletionModel::Prefix
    {26, 187, 160},	// KTextEditor::CodeCompletionModel::Private
    {26, 188, 159},	// KTextEditor::CodeCompletionModel::Protected
    {26, 189, 158},	// KTextEditor::CodeCompletionModel::Public
    {26, 209, 152},	// KTextEditor::CodeCompletionModel::Scope
    {26, 210, 186},	// KTextEditor::CodeCompletionModel::ScopeIndex
    {26, 217, 188},	// KTextEditor::CodeCompletionModel::SetMatchContext
    {26, 218, 176},	// KTextEditor::CodeCompletionModel::Signal
    {26, 225, 177},	// KTextEditor::CodeCompletionModel::Slot
    {26, 242, 161},	// KTextEditor::CodeCompletionModel::Static
    {26, 244, 165},	// KTextEditor::CodeCompletionModel::Struct
    {26, 245, 170},	// KTextEditor::CodeCompletionModel::Template
    {26, 251, 171},	// KTextEditor::CodeCompletionModel::TypeAlias
    {26, 252, 201},	// KTextEditor::CodeCompletionModel::UnimportantItemRole
    {26, 253, 166},	// KTextEditor::CodeCompletionModel::Union
    {26, 254, 204},	// KTextEditor::CodeCompletionModel::UserInvocation
    {26, 255, 168},	// KTextEditor::CodeCompletionModel::Variable
    {26, 262, 172},	// KTextEditor::CodeCompletionModel::Virtual
    {26, 376, 144},	// KTextEditor::CodeCompletionModel::columnCount
    {26, 377, 133},	// KTextEditor::CodeCompletionModel::columnCount#
    {26, 382, 131},	// KTextEditor::CodeCompletionModel::completionInvoked##$
    {26, 539, 132},	// KTextEditor::CodeCompletionModel::executeCompletionItem##$
    {26, 569, 138},	// KTextEditor::CodeCompletionModel::hasGroups
    {26, 571, 140},	// KTextEditor::CodeCompletionModel::hasGroupsChanged#$
    {26, 594, 145},	// KTextEditor::CodeCompletionModel::index$$
    {26, 595, 134},	// KTextEditor::CodeCompletionModel::index$$#
    {26, 632, 135},	// KTextEditor::CodeCompletionModel::itemData#
    {26, 699, 122},	// KTextEditor::CodeCompletionModel::metaObject
    {26, 772, 136},	// KTextEditor::CodeCompletionModel::parent#
    {26, 799, 128},	// KTextEditor::CodeCompletionModel::qt_metacall$$?
    {26, 801, 123},	// KTextEditor::CodeCompletionModel::qt_metacast$
    {26, 875, 146},	// KTextEditor::CodeCompletionModel::rowCount
    {26, 876, 137},	// KTextEditor::CodeCompletionModel::rowCount#
    {26, 937, 141},	// KTextEditor::CodeCompletionModel::setHasGroups$
    {26, 993, 130},	// KTextEditor::CodeCompletionModel::setRowCount$
    {26, 1047, 147},	// KTextEditor::CodeCompletionModel::staticMetaObject
    {26, 1079, 142},	// KTextEditor::CodeCompletionModel::tr$
    {26, 1080, 124},	// KTextEditor::CodeCompletionModel::tr$$
    {26, 1081, 126},	// KTextEditor::CodeCompletionModel::tr$$$
    {26, 1083, 143},	// KTextEditor::CodeCompletionModel::trUtf8$
    {26, 1084, 125},	// KTextEditor::CodeCompletionModel::trUtf8$$
    {26, 1085, 127},	// KTextEditor::CodeCompletionModel::trUtf8$$$
    {26, 1120, 139},	// KTextEditor::CodeCompletionModel::waitForReset
    {26, 1145, 206},	// KTextEditor::CodeCompletionModel::~CodeCompletionModel
    {27, 37, 214},	// KTextEditor::CodeCompletionModel2::CodeCompletionModel2#
    {27, 541, 215},	// KTextEditor::CodeCompletionModel2::executeCompletionItem2###
    {27, 699, 207},	// KTextEditor::CodeCompletionModel2::metaObject
    {27, 799, 213},	// KTextEditor::CodeCompletionModel2::qt_metacall$$?
    {27, 801, 208},	// KTextEditor::CodeCompletionModel2::qt_metacast$
    {27, 1047, 218},	// KTextEditor::CodeCompletionModel2::staticMetaObject
    {27, 1079, 216},	// KTextEditor::CodeCompletionModel2::tr$
    {27, 1080, 209},	// KTextEditor::CodeCompletionModel2::tr$$
    {27, 1081, 211},	// KTextEditor::CodeCompletionModel2::tr$$$
    {27, 1083, 217},	// KTextEditor::CodeCompletionModel2::trUtf8$
    {27, 1084, 210},	// KTextEditor::CodeCompletionModel2::trUtf8$$
    {27, 1085, 212},	// KTextEditor::CodeCompletionModel2::trUtf8$$$
    {27, 1146, 219},	// KTextEditor::CodeCompletionModel2::~CodeCompletionModel2
    {28, 38, 220},	// KTextEditor::CodeCompletionModelControllerInterface::CodeCompletionModelControllerInterface
    {28, 39, 228},	// KTextEditor::CodeCompletionModelControllerInterface::CodeCompletionModelControllerInterface#
    {28, 266, 227},	// KTextEditor::CodeCompletionModelControllerInterface::aborted#
    {28, 386, 222},	// KTextEditor::CodeCompletionModelControllerInterface::completionRange##
    {28, 548, 224},	// KTextEditor::CodeCompletionModelControllerInterface::filterString###
    {28, 1024, 225},	// KTextEditor::CodeCompletionModelControllerInterface::shouldAbortCompletion##$
    {28, 1026, 226},	// KTextEditor::CodeCompletionModelControllerInterface::shouldExecute##
    {28, 1028, 221},	// KTextEditor::CodeCompletionModelControllerInterface::shouldStartCompletion#$$#
    {28, 1097, 223},	// KTextEditor::CodeCompletionModelControllerInterface::updateCompletionRange##
    {28, 1147, 229},	// KTextEditor::CodeCompletionModelControllerInterface::~CodeCompletionModelControllerInterface
    {29, 40, 231},	// KTextEditor::CodeCompletionModelControllerInterface2::CodeCompletionModelControllerInterface2
    {29, 41, 232},	// KTextEditor::CodeCompletionModelControllerInterface2::CodeCompletionModelControllerInterface2#
    {29, 96, 234},	// KTextEditor::CodeCompletionModelControllerInterface2::HideListIfAutomaticInvocation
    {29, 174, 233},	// KTextEditor::CodeCompletionModelControllerInterface2::None
    {29, 698, 230},	// KTextEditor::CodeCompletionModelControllerInterface2::matchingItem#
    {29, 1148, 235},	// KTextEditor::CodeCompletionModelControllerInterface2::~CodeCompletionModelControllerInterface2
    {30, 43, 239},	// KTextEditor::Command::Command
    {30, 44, 240},	// KTextEditor::Command::Command#
    {30, 374, 236},	// KTextEditor::Command::cmds
    {30, 536, 237},	// KTextEditor::Command::exec#$$
    {30, 578, 238},	// KTextEditor::Command::help#$$
    {30, 1149, 241},	// KTextEditor::Command::~Command
    {31, 45, 246},	// KTextEditor::CommandExtension::CommandExtension
    {31, 46, 247},	// KTextEditor::CommandExtension::CommandExtension#
    {31, 384, 243},	// KTextEditor::CommandExtension::completionObject#$
    {31, 552, 242},	// KTextEditor::CommandExtension::flagCompletions?
    {31, 797, 245},	// KTextEditor::CommandExtension::processText#$
    {31, 1123, 244},	// KTextEditor::CommandExtension::wantsToProcessText$
    {31, 1150, 248},	// KTextEditor::CommandExtension::~CommandExtension
    {32, 47, 254},	// KTextEditor::CommandInterface::CommandInterface
    {32, 48, 255},	// KTextEditor::CommandInterface::CommandInterface#
    {32, 379, 253},	// KTextEditor::CommandInterface::commandList
    {32, 380, 252},	// KTextEditor::CommandInterface::commands
    {32, 804, 251},	// KTextEditor::CommandInterface::queryCommand$
    {32, 829, 249},	// KTextEditor::CommandInterface::registerCommand#
    {32, 1093, 250},	// KTextEditor::CommandInterface::unregisterCommand#
    {32, 1151, 256},	// KTextEditor::CommandInterface::~CommandInterface
    {33, 50, 257},	// KTextEditor::ConfigInterface::ConfigInterface
    {33, 51, 261},	// KTextEditor::ConfigInterface::ConfigInterface#
    {33, 391, 258},	// KTextEditor::ConfigInterface::configKeys
    {33, 402, 259},	// KTextEditor::ConfigInterface::configValue$
    {33, 915, 260},	// KTextEditor::ConfigInterface::setConfigValue$#
    {33, 1152, 262},	// KTextEditor::ConfigInterface::~ConfigInterface
    {34, 53, 270},	// KTextEditor::ConfigPage::ConfigPage#
    {34, 308, 271},	// KTextEditor::ConfigPage::apply
    {34, 334, 274},	// KTextEditor::ConfigPage::changed
    {34, 455, 273},	// KTextEditor::ConfigPage::defaults
    {34, 699, 263},	// KTextEditor::ConfigPage::metaObject
    {34, 799, 269},	// KTextEditor::ConfigPage::qt_metacall$$?
    {34, 801, 264},	// KTextEditor::ConfigPage::qt_metacast$
    {34, 872, 272},	// KTextEditor::ConfigPage::reset
    {34, 1047, 277},	// KTextEditor::ConfigPage::staticMetaObject
    {34, 1079, 275},	// KTextEditor::ConfigPage::tr$
    {34, 1080, 265},	// KTextEditor::ConfigPage::tr$$
    {34, 1081, 267},	// KTextEditor::ConfigPage::tr$$$
    {34, 1083, 276},	// KTextEditor::ConfigPage::trUtf8$
    {34, 1084, 266},	// KTextEditor::ConfigPage::trUtf8$$
    {34, 1085, 268},	// KTextEditor::ConfigPage::trUtf8$$$
    {34, 1153, 278},	// KTextEditor::ConfigPage::~ConfigPage
    {35, 55, 279},	// KTextEditor::ContainerInterface::ContainerInterface
    {35, 56, 282},	// KTextEditor::ContainerInterface::ContainerInterface#
    {35, 406, 281},	// KTextEditor::ContainerInterface::container
    {35, 917, 280},	// KTextEditor::ContainerInterface::setContainer#
    {35, 1154, 283},	// KTextEditor::ContainerInterface::~ContainerInterface
    {36, 57, 285},	// KTextEditor::CoordinatesToCursorInterface::CoordinatesToCursorInterface
    {36, 58, 286},	// KTextEditor::CoordinatesToCursorInterface::CoordinatesToCursorInterface#
    {36, 418, 284},	// KTextEditor::CoordinatesToCursorInterface::coordinatesToCursor#
    {36, 1155, 287},	// KTextEditor::CoordinatesToCursorInterface::~CoordinatesToCursorInterface
    {37, 59, 288},	// KTextEditor::Cursor::Cursor
    {37, 60, 290},	// KTextEditor::Cursor::Cursor#
    {37, 61, 289},	// KTextEditor::Cursor::Cursor$$
    {37, 314, 303},	// KTextEditor::Cursor::atStartOfDocument
    {37, 315, 302},	// KTextEditor::Cursor::atStartOfLine
    {37, 375, 300},	// KTextEditor::Cursor::column
    {37, 431, 308},	// KTextEditor::Cursor::cursorChangedDirectly#
    {37, 621, 294},	// KTextEditor::Cursor::invalid
    {37, 628, 292},	// KTextEditor::Cursor::isSmartCursor
    {37, 630, 291},	// KTextEditor::Cursor::isValid
    {37, 638, 298},	// KTextEditor::Cursor::line
    {37, 648, 311},	// KTextEditor::Cursor::m_column
    {37, 650, 309},	// KTextEditor::Cursor::m_line
    {37, 651, 313},	// KTextEditor::Cursor::m_range
    {37, 756, 306},	// KTextEditor::Cursor::operator=#
    {37, 780, 304},	// KTextEditor::Cursor::position$$
    {37, 805, 305},	// KTextEditor::Cursor::range
    {37, 912, 301},	// KTextEditor::Cursor::setColumn$
    {37, 947, 299},	// KTextEditor::Cursor::setLine$
    {37, 950, 312},	// KTextEditor::Cursor::setM_column$
    {37, 954, 310},	// KTextEditor::Cursor::setM_line$
    {37, 956, 314},	// KTextEditor::Cursor::setM_range#
    {37, 986, 296},	// KTextEditor::Cursor::setPosition#
    {37, 987, 297},	// KTextEditor::Cursor::setPosition$$
    {37, 989, 307},	// KTextEditor::Cursor::setRange#
    {37, 1042, 295},	// KTextEditor::Cursor::start
    {37, 1074, 293},	// KTextEditor::Cursor::toSmartCursor
    {37, 1156, 315},	// KTextEditor::Cursor::~Cursor
    {38, 66, 397},	// KTextEditor::Document::Document
    {38, 67, 323},	// KTextEditor::Document::Document#
    {38, 269, 372},	// KTextEditor::Document::aboutToClose#
    {38, 271, 373},	// KTextEditor::Document::aboutToReload#
    {38, 275, 326},	// KTextEditor::Document::activeView
    {38, 336, 344},	// KTextEditor::Document::character#
    {38, 352, 356},	// KTextEditor::Document::clear
    {38, 428, 325},	// KTextEditor::Document::createView#
    {38, 433, 362},	// KTextEditor::Document::cursorInText#
    {38, 475, 348},	// KTextEditor::Document::documentEnd
    {38, 477, 329},	// KTextEditor::Document::documentName
    {38, 479, 331},	// KTextEditor::Document::documentNameChanged#
    {38, 480, 349},	// KTextEditor::Document::documentRange
    {38, 481, 336},	// KTextEditor::Document::documentReload
    {38, 482, 337},	// KTextEditor::Document::documentSave
    {38, 483, 338},	// KTextEditor::Document::documentSaveAs
    {38, 485, 339},	// KTextEditor::Document::documentSavedOrUploaded#$
    {38, 487, 332},	// KTextEditor::Document::documentUrlChanged#
    {38, 512, 324},	// KTextEditor::Document::editor
    {38, 521, 335},	// KTextEditor::Document::encoding
    {38, 525, 341},	// KTextEditor::Document::endEditing
    {38, 527, 353},	// KTextEditor::Document::endOfLine$
    {38, 532, 376},	// KTextEditor::Document::exclusiveEditEnd#
    {38, 534, 375},	// KTextEditor::Document::exclusiveEditStart#
    {38, 582, 378},	// KTextEditor::Document::highlightingMode
    {38, 586, 386},	// KTextEditor::Document::highlightingModeChanged#
    {38, 588, 383},	// KTextEditor::Document::highlightingModeSection$
    {38, 589, 380},	// KTextEditor::Document::highlightingModes
    {38, 603, 363},	// KTextEditor::Document::insertLine$$
    {38, 605, 364},	// KTextEditor::Document::insertLines$?
    {38, 612, 400},	// KTextEditor::Document::insertText#$
    {38, 613, 357},	// KTextEditor::Document::insertText#$$
    {38, 614, 401},	// KTextEditor::Document::insertText#?
    {38, 615, 358},	// KTextEditor::Document::insertText#?$
    {38, 626, 351},	// KTextEditor::Document::isEmpty
    {38, 627, 391},	// KTextEditor::Document::isOrphaned
    {38, 639, 346},	// KTextEditor::Document::line$
    {38, 645, 352},	// KTextEditor::Document::lineLength$
    {38, 646, 347},	// KTextEditor::Document::lines
    {38, 699, 316},	// KTextEditor::Document::metaObject
    {38, 702, 330},	// KTextEditor::Document::mimeType
    {38, 705, 377},	// KTextEditor::Document::mode
    {38, 707, 385},	// KTextEditor::Document::modeChanged#
    {38, 709, 384},	// KTextEditor::Document::modeSection$
    {38, 710, 379},	// KTextEditor::Document::modes
    {38, 712, 333},	// KTextEditor::Document::modifiedChanged#
    {38, 751, 389},	// KTextEditor::Document::openingError
    {38, 752, 390},	// KTextEditor::Document::openingErrorMessage
    {38, 799, 322},	// KTextEditor::Document::qt_metacall$$?
    {38, 801, 317},	// KTextEditor::Document::qt_metacast$
    {38, 835, 374},	// KTextEditor::Document::reloaded#
    {38, 848, 365},	// KTextEditor::Document::removeLine$
    {38, 857, 404},	// KTextEditor::Document::removeText#
    {38, 858, 361},	// KTextEditor::Document::removeText#$
    {38, 865, 402},	// KTextEditor::Document::replaceText#$
    {38, 866, 359},	// KTextEditor::Document::replaceText#$$
    {38, 867, 403},	// KTextEditor::Document::replaceText#?
    {38, 868, 360},	// KTextEditor::Document::replaceText#?$
    {38, 933, 334},	// KTextEditor::Document::setEncoding$
    {38, 940, 382},	// KTextEditor::Document::setHighlightingMode$
    {38, 967, 381},	// KTextEditor::Document::setMode$
    {38, 976, 393},	// KTextEditor::Document::setOpeningError$
    {38, 978, 394},	// KTextEditor::Document::setOpeningErrorMessage$
    {38, 980, 392},	// KTextEditor::Document::setOrphaned$
    {38, 1008, 387},	// KTextEditor::Document::setSuppressOpeningErrorDialogs$
    {38, 1010, 354},	// KTextEditor::Document::setText$
    {38, 1011, 355},	// KTextEditor::Document::setText?
    {38, 1045, 340},	// KTextEditor::Document::startEditing
    {38, 1047, 405},	// KTextEditor::Document::staticMetaObject
    {38, 1054, 388},	// KTextEditor::Document::suppressOpeningErrorDialogs
    {38, 1056, 342},	// KTextEditor::Document::text
    {38, 1057, 398},	// KTextEditor::Document::text#
    {38, 1058, 343},	// KTextEditor::Document::text#$
    {38, 1061, 366},	// KTextEditor::Document::textChanged#
    {38, 1062, 370},	// KTextEditor::Document::textChanged###
    {38, 1063, 371},	// KTextEditor::Document::textChanged##$#
    {38, 1065, 367},	// KTextEditor::Document::textInserted##
    {38, 1068, 399},	// KTextEditor::Document::textLines#
    {38, 1069, 345},	// KTextEditor::Document::textLines#$
    {38, 1071, 368},	// KTextEditor::Document::textRemoved##
    {38, 1072, 369},	// KTextEditor::Document::textRemoved##$
    {38, 1077, 350},	// KTextEditor::Document::totalCharacters
    {38, 1079, 395},	// KTextEditor::Document::tr$
    {38, 1080, 318},	// KTextEditor::Document::tr$$
    {38, 1081, 320},	// KTextEditor::Document::tr$$$
    {38, 1083, 396},	// KTextEditor::Document::trUtf8$
    {38, 1084, 319},	// KTextEditor::Document::trUtf8$$
    {38, 1085, 321},	// KTextEditor::Document::trUtf8$$$
    {38, 1109, 328},	// KTextEditor::Document::viewCreated##
    {38, 1118, 327},	// KTextEditor::Document::views
    {38, 1157, 406},	// KTextEditor::Document::~Document
    {39, 74, 414},	// KTextEditor::Editor::Editor#
    {39, 267, 419},	// KTextEditor::Editor::aboutData
    {39, 389, 425},	// KTextEditor::Editor::configDialog#
    {39, 390, 424},	// KTextEditor::Editor::configDialogSupported
    {39, 393, 427},	// KTextEditor::Editor::configPage$#
    {39, 395, 429},	// KTextEditor::Editor::configPageFullName$
    {39, 397, 430},	// KTextEditor::Editor::configPageIcon$
    {39, 399, 428},	// KTextEditor::Editor::configPageName$
    {39, 400, 426},	// KTextEditor::Editor::configPages
    {39, 421, 417},	// KTextEditor::Editor::createDocument#
    {39, 452, 420},	// KTextEditor::Editor::defaultEncoding
    {39, 474, 431},	// KTextEditor::Editor::documentCreated##
    {39, 488, 418},	// KTextEditor::Editor::documents
    {39, 699, 407},	// KTextEditor::Editor::metaObject
    {39, 799, 413},	// KTextEditor::Editor::qt_metacall$$?
    {39, 801, 408},	// KTextEditor::Editor::qt_metacast$
    {39, 821, 434},	// KTextEditor::Editor::readConfig
    {39, 822, 422},	// KTextEditor::Editor::readConfig#
    {39, 925, 421},	// KTextEditor::Editor::setDefaultEncoding$
    {39, 1004, 415},	// KTextEditor::Editor::setSimpleMode$
    {39, 1032, 416},	// KTextEditor::Editor::simpleMode
    {39, 1047, 436},	// KTextEditor::Editor::staticMetaObject
    {39, 1079, 432},	// KTextEditor::Editor::tr$
    {39, 1080, 409},	// KTextEditor::Editor::tr$$
    {39, 1081, 411},	// KTextEditor::Editor::tr$$$
    {39, 1083, 433},	// KTextEditor::Editor::trUtf8$
    {39, 1084, 410},	// KTextEditor::Editor::trUtf8$$
    {39, 1085, 412},	// KTextEditor::Editor::trUtf8$$$
    {39, 1131, 435},	// KTextEditor::Editor::writeConfig
    {39, 1132, 423},	// KTextEditor::Editor::writeConfig#
    {39, 1158, 437},	// KTextEditor::Editor::~Editor
    {40, 75, 452},	// KTextEditor::EditorChooser::EditorChooser
    {40, 76, 445},	// KTextEditor::EditorChooser::EditorChooser#
    {40, 334, 449},	// KTextEditor::EditorChooser::changed
    {40, 512, 455},	// KTextEditor::EditorChooser::editor
    {40, 513, 456},	// KTextEditor::EditorChooser::editor$
    {40, 514, 448},	// KTextEditor::EditorChooser::editor$$
    {40, 699, 438},	// KTextEditor::EditorChooser::metaObject
    {40, 799, 444},	// KTextEditor::EditorChooser::qt_metacall$$?
    {40, 801, 439},	// KTextEditor::EditorChooser::qt_metacast$
    {40, 819, 453},	// KTextEditor::EditorChooser::readAppSetting
    {40, 820, 446},	// KTextEditor::EditorChooser::readAppSetting$
    {40, 1047, 457},	// KTextEditor::EditorChooser::staticMetaObject
    {40, 1079, 450},	// KTextEditor::EditorChooser::tr$
    {40, 1080, 440},	// KTextEditor::EditorChooser::tr$$
    {40, 1081, 442},	// KTextEditor::EditorChooser::tr$$$
    {40, 1083, 451},	// KTextEditor::EditorChooser::trUtf8$
    {40, 1084, 441},	// KTextEditor::EditorChooser::trUtf8$$
    {40, 1085, 443},	// KTextEditor::EditorChooser::trUtf8$$$
    {40, 1129, 454},	// KTextEditor::EditorChooser::writeAppSetting
    {40, 1130, 447},	// KTextEditor::EditorChooser::writeAppSetting$
    {40, 1159, 458},	// KTextEditor::EditorChooser::~EditorChooser
    {41, 89, 466},	// KTextEditor::Factory::Factory#
    {41, 512, 467},	// KTextEditor::Factory::editor
    {41, 699, 459},	// KTextEditor::Factory::metaObject
    {41, 799, 465},	// KTextEditor::Factory::qt_metacall$$?
    {41, 801, 460},	// KTextEditor::Factory::qt_metacast$
    {41, 1047, 470},	// KTextEditor::Factory::staticMetaObject
    {41, 1079, 468},	// KTextEditor::Factory::tr$
    {41, 1080, 461},	// KTextEditor::Factory::tr$$
    {41, 1081, 463},	// KTextEditor::Factory::tr$$$
    {41, 1083, 469},	// KTextEditor::Factory::trUtf8$
    {41, 1084, 462},	// KTextEditor::Factory::trUtf8$$
    {41, 1085, 464},	// KTextEditor::Factory::trUtf8$$$
    {41, 1160, 471},	// KTextEditor::Factory::~Factory
    {42, 97, 472},	// KTextEditor::HighlightInterface::HighlightInterface
    {42, 98, 477},	// KTextEditor::HighlightInterface::HighlightInterface#
    {42, 454, 473},	// KTextEditor::HighlightInterface::defaultStyle$
    {42, 495, 488},	// KTextEditor::HighlightInterface::dsAlert
    {42, 496, 482},	// KTextEditor::HighlightInterface::dsBaseN
    {42, 497, 484},	// KTextEditor::HighlightInterface::dsChar
    {42, 498, 486},	// KTextEditor::HighlightInterface::dsComment
    {42, 499, 480},	// KTextEditor::HighlightInterface::dsDataType
    {42, 500, 481},	// KTextEditor::HighlightInterface::dsDecVal
    {42, 501, 491},	// KTextEditor::HighlightInterface::dsError
    {42, 502, 483},	// KTextEditor::HighlightInterface::dsFloat
    {42, 503, 489},	// KTextEditor::HighlightInterface::dsFunction
    {42, 504, 479},	// KTextEditor::HighlightInterface::dsKeyword
    {42, 505, 478},	// KTextEditor::HighlightInterface::dsNormal
    {42, 506, 487},	// KTextEditor::HighlightInterface::dsOthers
    {42, 507, 490},	// KTextEditor::HighlightInterface::dsRegionMarker
    {42, 508, 485},	// KTextEditor::HighlightInterface::dsString
    {42, 517, 475},	// KTextEditor::HighlightInterface::embeddedHighlightingModes
    {42, 584, 476},	// KTextEditor::HighlightInterface::highlightingModeAt#
    {42, 641, 474},	// KTextEditor::HighlightInterface::lineAttributes$
    {42, 1161, 492},	// KTextEditor::HighlightInterface::~HighlightInterface
    {43, 16, 494},	// KTextEditor::HighlightInterface::AttributeBlock::AttributeBlock#
    {43, 17, 493},	// KTextEditor::HighlightInterface::AttributeBlock::AttributeBlock$$?
    {43, 316, 499},	// KTextEditor::HighlightInterface::AttributeBlock::attribute
    {43, 637, 497},	// KTextEditor::HighlightInterface::AttributeBlock::length
    {43, 898, 500},	// KTextEditor::HighlightInterface::AttributeBlock::setAttribute?
    {43, 945, 498},	// KTextEditor::HighlightInterface::AttributeBlock::setLength$
    {43, 1006, 496},	// KTextEditor::HighlightInterface::AttributeBlock::setStart$
    {43, 1042, 495},	// KTextEditor::HighlightInterface::AttributeBlock::start
    {43, 1143, 501},	// KTextEditor::HighlightInterface::AttributeBlock::~AttributeBlock
    {44, 154, 509},	// KTextEditor::LoadSaveFilterCheckPlugin::LoadSaveFilterCheckPlugin#
    {44, 699, 502},	// KTextEditor::LoadSaveFilterCheckPlugin::metaObject
    {44, 790, 512},	// KTextEditor::LoadSaveFilterCheckPlugin::postLoadFilter#
    {44, 792, 511},	// KTextEditor::LoadSaveFilterCheckPlugin::postSaveFilterCheck#$
    {44, 794, 510},	// KTextEditor::LoadSaveFilterCheckPlugin::preSavePostDialogFilterCheck#
    {44, 799, 508},	// KTextEditor::LoadSaveFilterCheckPlugin::qt_metacall$$?
    {44, 801, 503},	// KTextEditor::LoadSaveFilterCheckPlugin::qt_metacast$
    {44, 1047, 515},	// KTextEditor::LoadSaveFilterCheckPlugin::staticMetaObject
    {44, 1079, 513},	// KTextEditor::LoadSaveFilterCheckPlugin::tr$
    {44, 1080, 504},	// KTextEditor::LoadSaveFilterCheckPlugin::tr$$
    {44, 1081, 506},	// KTextEditor::LoadSaveFilterCheckPlugin::tr$$$
    {44, 1083, 514},	// KTextEditor::LoadSaveFilterCheckPlugin::trUtf8$
    {44, 1084, 505},	// KTextEditor::LoadSaveFilterCheckPlugin::trUtf8$$
    {44, 1085, 507},	// KTextEditor::LoadSaveFilterCheckPlugin::trUtf8$$$
    {44, 1162, 516},	// KTextEditor::LoadSaveFilterCheckPlugin::~LoadSaveFilterCheckPlugin
    {45, 157, 517},	// KTextEditor::Mark::Mark
    {45, 158, 518},	// KTextEditor::Mark::Mark#
    {45, 638, 519},	// KTextEditor::Mark::line
    {45, 947, 520},	// KTextEditor::Mark::setLine$
    {45, 1013, 522},	// KTextEditor::Mark::setType$
    {45, 1089, 521},	// KTextEditor::Mark::type
    {45, 1163, 523},	// KTextEditor::Mark::~Mark
    {46, 24, 574},	// KTextEditor::MarkInterface::Bookmark
    {46, 26, 575},	// KTextEditor::MarkInterface::BreakpointActive
    {46, 27, 577},	// KTextEditor::MarkInterface::BreakpointDisabled
    {46, 28, 576},	// KTextEditor::MarkInterface::BreakpointReached
    {46, 83, 580},	// KTextEditor::MarkInterface::Error
    {46, 84, 578},	// KTextEditor::MarkInterface::Execution
    {46, 159, 581},	// KTextEditor::MarkInterface::MarkAdded
    {46, 160, 524},	// KTextEditor::MarkInterface::MarkInterface
    {46, 161, 541},	// KTextEditor::MarkInterface::MarkInterface#
    {46, 162, 582},	// KTextEditor::MarkInterface::MarkRemoved
    {46, 263, 579},	// KTextEditor::MarkInterface::Warning
    {46, 289, 528},	// KTextEditor::MarkInterface::addMark$$
    {46, 359, 527},	// KTextEditor::MarkInterface::clearMark$
    {46, 360, 531},	// KTextEditor::MarkInterface::clearMarks
    {46, 511, 539},	// KTextEditor::MarkInterface::editableMarks
    {46, 654, 525},	// KTextEditor::MarkInterface::mark$
    {46, 656, 540},	// KTextEditor::MarkInterface::markChanged##$
    {46, 658, 537},	// KTextEditor::MarkInterface::markDescription$
    {46, 660, 535},	// KTextEditor::MarkInterface::markPixmap$
    {46, 661, 542},	// KTextEditor::MarkInterface::markType01
    {46, 662, 543},	// KTextEditor::MarkInterface::markType02
    {46, 663, 544},	// KTextEditor::MarkInterface::markType03
    {46, 664, 545},	// KTextEditor::MarkInterface::markType04
    {46, 665, 546},	// KTextEditor::MarkInterface::markType05
    {46, 666, 547},	// KTextEditor::MarkInterface::markType06
    {46, 667, 548},	// KTextEditor::MarkInterface::markType07
    {46, 668, 549},	// KTextEditor::MarkInterface::markType08
    {46, 669, 550},	// KTextEditor::MarkInterface::markType09
    {46, 670, 551},	// KTextEditor::MarkInterface::markType10
    {46, 671, 552},	// KTextEditor::MarkInterface::markType11
    {46, 672, 553},	// KTextEditor::MarkInterface::markType12
    {46, 673, 554},	// KTextEditor::MarkInterface::markType13
    {46, 674, 555},	// KTextEditor::MarkInterface::markType14
    {46, 675, 556},	// KTextEditor::MarkInterface::markType15
    {46, 676, 557},	// KTextEditor::MarkInterface::markType16
    {46, 677, 558},	// KTextEditor::MarkInterface::markType17
    {46, 678, 559},	// KTextEditor::MarkInterface::markType18
    {46, 679, 560},	// KTextEditor::MarkInterface::markType19
    {46, 680, 561},	// KTextEditor::MarkInterface::markType20
    {46, 681, 562},	// KTextEditor::MarkInterface::markType21
    {46, 682, 563},	// KTextEditor::MarkInterface::markType22
    {46, 683, 564},	// KTextEditor::MarkInterface::markType23
    {46, 684, 565},	// KTextEditor::MarkInterface::markType24
    {46, 685, 566},	// KTextEditor::MarkInterface::markType25
    {46, 686, 567},	// KTextEditor::MarkInterface::markType26
    {46, 687, 568},	// KTextEditor::MarkInterface::markType27
    {46, 688, 569},	// KTextEditor::MarkInterface::markType28
    {46, 689, 570},	// KTextEditor::MarkInterface::markType29
    {46, 690, 571},	// KTextEditor::MarkInterface::markType30
    {46, 691, 572},	// KTextEditor::MarkInterface::markType31
    {46, 692, 573},	// KTextEditor::MarkInterface::markType32
    {46, 693, 530},	// KTextEditor::MarkInterface::marks
    {46, 695, 533},	// KTextEditor::MarkInterface::marksChanged#
    {46, 850, 529},	// KTextEditor::MarkInterface::removeMark$$
    {46, 871, 532},	// KTextEditor::MarkInterface::reservedMarkersCount
    {46, 929, 538},	// KTextEditor::MarkInterface::setEditableMarks$
    {46, 961, 526},	// KTextEditor::MarkInterface::setMark$$
    {46, 963, 536},	// KTextEditor::MarkInterface::setMarkDescription$$
    {46, 965, 534},	// KTextEditor::MarkInterface::setMarkPixmap$#
    {46, 1164, 583},	// KTextEditor::MarkInterface::~MarkInterface
    {47, 164, 584},	// KTextEditor::MdiContainer::MdiContainer
    {47, 165, 591},	// KTextEditor::MdiContainer::MdiContainer#
    {47, 275, 586},	// KTextEditor::MdiContainer::activeView
    {47, 369, 588},	// KTextEditor::MdiContainer::closeDocument#
    {47, 373, 590},	// KTextEditor::MdiContainer::closeView#
    {47, 420, 587},	// KTextEditor::MdiContainer::createDocument
    {47, 428, 589},	// KTextEditor::MdiContainer::createView#
    {47, 892, 585},	// KTextEditor::MdiContainer::setActiveView#
    {47, 1165, 592},	// KTextEditor::MdiContainer::~MdiContainer
    {48, 166, 593},	// KTextEditor::ModificationInterface::ModificationInterface
    {48, 167, 598},	// KTextEditor::ModificationInterface::ModificationInterface#
    {48, 175, 602},	// KTextEditor::ModificationInterface::OnDiskCreated
    {48, 176, 603},	// KTextEditor::ModificationInterface::OnDiskDeleted
    {48, 177, 601},	// KTextEditor::ModificationInterface::OnDiskModified
    {48, 178, 600},	// KTextEditor::ModificationInterface::OnDiskUnmodified
    {48, 714, 597},	// KTextEditor::ModificationInterface::modifiedOnDisk#$$
    {48, 970, 594},	// KTextEditor::ModificationInterface::setModifiedOnDisk$
    {48, 972, 595},	// KTextEditor::ModificationInterface::setModifiedOnDiskWarning$
    {48, 1034, 599},	// KTextEditor::ModificationInterface::slotModifiedOnDisk
    {48, 1035, 596},	// KTextEditor::ModificationInterface::slotModifiedOnDisk#
    {48, 1166, 604},	// KTextEditor::ModificationInterface::~ModificationInterface
    {49, 181, 605},	// KTextEditor::ParameterizedSessionConfigInterface::ParameterizedSessionConfigInterface
    {49, 182, 608},	// KTextEditor::ParameterizedSessionConfigInterface::ParameterizedSessionConfigInterface#
    {49, 219, 613},	// KTextEditor::ParameterizedSessionConfigInterface::SkipEncoding
    {49, 220, 614},	// KTextEditor::ParameterizedSessionConfigInterface::SkipFolding
    {49, 221, 612},	// KTextEditor::ParameterizedSessionConfigInterface::SkipHighlighting
    {49, 222, 611},	// KTextEditor::ParameterizedSessionConfigInterface::SkipMode
    {49, 223, 609},	// KTextEditor::ParameterizedSessionConfigInterface::SkipNone
    {49, 224, 610},	// KTextEditor::ParameterizedSessionConfigInterface::SkipUrl
    {49, 824, 606},	// KTextEditor::ParameterizedSessionConfigInterface::readParameterizedSessionConfig#$
    {49, 1134, 607},	// KTextEditor::ParameterizedSessionConfigInterface::writeParameterizedSessionConfig#$
    {49, 1167, 615},	// KTextEditor::ParameterizedSessionConfigInterface::~ParameterizedSessionConfigInterface
    {50, 184, 623},	// KTextEditor::Plugin::Plugin#
    {50, 281, 624},	// KTextEditor::Plugin::addDocument#
    {50, 293, 626},	// KTextEditor::Plugin::addView#
    {50, 699, 616},	// KTextEditor::Plugin::metaObject
    {50, 799, 622},	// KTextEditor::Plugin::qt_metacall$$?
    {50, 801, 617},	// KTextEditor::Plugin::qt_metacast$
    {50, 842, 625},	// KTextEditor::Plugin::removeDocument#
    {50, 861, 627},	// KTextEditor::Plugin::removeView#
    {50, 1047, 630},	// KTextEditor::Plugin::staticMetaObject
    {50, 1079, 628},	// KTextEditor::Plugin::tr$
    {50, 1080, 618},	// KTextEditor::Plugin::tr$$
    {50, 1081, 620},	// KTextEditor::Plugin::tr$$$
    {50, 1083, 629},	// KTextEditor::Plugin::trUtf8$
    {50, 1084, 619},	// KTextEditor::Plugin::trUtf8$$
    {50, 1085, 621},	// KTextEditor::Plugin::trUtf8$$$
    {50, 1168, 631},	// KTextEditor::Plugin::~Plugin
    {51, 200, 632},	// KTextEditor::Range::Range
    {51, 201, 637},	// KTextEditor::Range::Range#
    {51, 202, -15},	// KTextEditor::Range::Range##
    {51, 203, 634},	// KTextEditor::Range::Range#$
    {51, 204, 635},	// KTextEditor::Range::Range#$$
    {51, 205, 636},	// KTextEditor::Range::Range$$$$
    {51, 324, 665},	// KTextEditor::Range::boundaryAtCursor#
    {51, 326, 666},	// KTextEditor::Range::boundaryOnLine$
    {51, 378, 654},	// KTextEditor::Range::columnWidth
    {51, 404, 651},	// KTextEditor::Range::confineToRange#
    {51, 408, -18},	// KTextEditor::Range::contains#
    {51, 410, 659},	// KTextEditor::Range::containsColumn$
    {51, 412, 658},	// KTextEditor::Range::containsLine$
    {51, 523, 668},	// KTextEditor::Range::encompass#
    {51, 524, -21},	// KTextEditor::Range::end
    {51, 545, 650},	// KTextEditor::Range::expandToRange#
    {51, 620, 667},	// KTextEditor::Range::intersect#
    {51, 621, 639},	// KTextEditor::Range::invalid
    {51, 626, 655},	// KTextEditor::Range::isEmpty
    {51, 629, 640},	// KTextEditor::Range::isSmartRange
    {51, 630, 638},	// KTextEditor::Range::isValid
    {51, 649, 674},	// KTextEditor::Range::m_end
    {51, 652, 672},	// KTextEditor::Range::m_start
    {51, 747, 653},	// KTextEditor::Range::numberOfLines
    {51, 748, 652},	// KTextEditor::Range::onSingleLine
    {51, 756, 669},	// KTextEditor::Range::operator=#
    {51, 763, 660},	// KTextEditor::Range::overlaps#
    {51, 765, 662},	// KTextEditor::Range::overlapsColumn$
    {51, 767, 661},	// KTextEditor::Range::overlapsLine$
    {51, 786, 663},	// KTextEditor::Range::positionRelativeToCursor#
    {51, 788, 664},	// KTextEditor::Range::positionRelativeToLine$
    {51, 809, 671},	// KTextEditor::Range::rangeChanged##
    {51, 906, 647},	// KTextEditor::Range::setBothColumns$
    {51, 908, 646},	// KTextEditor::Range::setBothLines$
    {51, 952, 675},	// KTextEditor::Range::setM_end#
    {51, 958, 673},	// KTextEditor::Range::setM_start#
    {51, 989, 648},	// KTextEditor::Range::setRange#
    {51, 990, 649},	// KTextEditor::Range::setRange##
    {51, 1042, -24},	// KTextEditor::Range::start
    {51, 1075, 641},	// KTextEditor::Range::toSmartRange
    {51, 1169, 676},	// KTextEditor::Range::~Range
    {52, 206, 679},	// KTextEditor::RangeCommand::RangeCommand
    {52, 207, 680},	// KTextEditor::RangeCommand::RangeCommand#
    {52, 537, 677},	// KTextEditor::RangeCommand::exec#$$#
    {52, 1053, 678},	// KTextEditor::RangeCommand::supportsRange$
    {52, 1170, 681},	// KTextEditor::RangeCommand::~RangeCommand
    {53, 211, 682},	// KTextEditor::SearchInterface::SearchInterface
    {53, 212, 685},	// KTextEditor::SearchInterface::SearchInterface#
    {53, 882, 686},	// KTextEditor::SearchInterface::searchText#$
    {53, 883, 683},	// KTextEditor::SearchInterface::searchText#$$
    {53, 1051, 684},	// KTextEditor::SearchInterface::supportedSearchOptions
    {53, 1171, 687},	// KTextEditor::SearchInterface::~SearchInterface
    {54, 215, 688},	// KTextEditor::SessionConfigInterface::SessionConfigInterface
    {54, 216, 691},	// KTextEditor::SessionConfigInterface::SessionConfigInterface#
    {54, 826, 689},	// KTextEditor::SessionConfigInterface::readSessionConfig#
    {54, 1136, 690},	// KTextEditor::SessionConfigInterface::writeSessionConfig#
    {54, 1172, 692},	// KTextEditor::SessionConfigInterface::~SessionConfigInterface
    {55, 29, 715},	// KTextEditor::SmartCursor::ByCharacter
    {55, 30, 716},	// KTextEditor::SmartCursor::ByCursorPosition
    {55, 168, 718},	// KTextEditor::SmartCursor::MoveOnInsert
    {55, 227, 711},	// KTextEditor::SmartCursor::SmartCursor##$
    {55, 243, 717},	// KTextEditor::SmartCursor::StayOnInsert
    {55, 299, 713},	// KTextEditor::SmartCursor::advance$
    {55, 300, 702},	// KTextEditor::SmartCursor::advance$$
    {55, 312, 698},	// KTextEditor::SmartCursor::atEndOfDocument
    {55, 313, 697},	// KTextEditor::SmartCursor::atEndOfLine
    {55, 335, 700},	// KTextEditor::SmartCursor::character
    {55, 458, 707},	// KTextEditor::SmartCursor::deleteNotifier
    {55, 471, 696},	// KTextEditor::SmartCursor::document
    {55, 572, 705},	// KTextEditor::SmartCursor::hasNotifier
    {55, 600, 703},	// KTextEditor::SmartCursor::insertBehavior
    {55, 617, 712},	// KTextEditor::SmartCursor::insertText?
    {55, 618, 701},	// KTextEditor::SmartCursor::insertText?$
    {55, 628, 693},	// KTextEditor::SmartCursor::isSmartCursor
    {55, 630, 699},	// KTextEditor::SmartCursor::isValid
    {55, 745, 706},	// KTextEditor::SmartCursor::notifier
    {55, 756, 710},	// KTextEditor::SmartCursor::operator=#
    {55, 942, 704},	// KTextEditor::SmartCursor::setInsertBehavior$
    {55, 1017, 714},	// KTextEditor::SmartCursor::setWatcher
    {55, 1018, 709},	// KTextEditor::SmartCursor::setWatcher#
    {55, 1038, 695},	// KTextEditor::SmartCursor::smartRange
    {55, 1074, 694},	// KTextEditor::SmartCursor::toSmartCursor
    {55, 1124, 708},	// KTextEditor::SmartCursor::watcher
    {55, 1173, 719},	// KTextEditor::SmartCursor::~SmartCursor
    {56, 228, 727},	// KTextEditor::SmartCursorNotifier::SmartCursorNotifier
    {56, 338, 732},	// KTextEditor::SmartCursorNotifier::characterDeleted#$
    {56, 340, 733},	// KTextEditor::SmartCursorNotifier::characterInserted#$
    {56, 464, 734},	// KTextEditor::SmartCursorNotifier::deleted#
    {56, 699, 720},	// KTextEditor::SmartCursorNotifier::metaObject
    {56, 782, 730},	// KTextEditor::SmartCursorNotifier::positionChanged#
    {56, 784, 731},	// KTextEditor::SmartCursorNotifier::positionDeleted#
    {56, 799, 726},	// KTextEditor::SmartCursorNotifier::qt_metacall$$?
    {56, 801, 721},	// KTextEditor::SmartCursorNotifier::qt_metacast$
    {56, 1016, 729},	// KTextEditor::SmartCursorNotifier::setWantsDirectChanges$
    {56, 1047, 737},	// KTextEditor::SmartCursorNotifier::staticMetaObject
    {56, 1079, 735},	// KTextEditor::SmartCursorNotifier::tr$
    {56, 1080, 722},	// KTextEditor::SmartCursorNotifier::tr$$
    {56, 1081, 724},	// KTextEditor::SmartCursorNotifier::tr$$$
    {56, 1083, 736},	// KTextEditor::SmartCursorNotifier::trUtf8$
    {56, 1084, 723},	// KTextEditor::SmartCursorNotifier::trUtf8$$
    {56, 1085, 725},	// KTextEditor::SmartCursorNotifier::trUtf8$$$
    {56, 1121, 728},	// KTextEditor::SmartCursorNotifier::wantsDirectChanges
    {56, 1174, 738},	// KTextEditor::SmartCursorNotifier::~SmartCursorNotifier
    {57, 229, 739},	// KTextEditor::SmartCursorWatcher::SmartCursorWatcher
    {57, 230, 747},	// KTextEditor::SmartCursorWatcher::SmartCursorWatcher#
    {57, 338, 744},	// KTextEditor::SmartCursorWatcher::characterDeleted#$
    {57, 340, 745},	// KTextEditor::SmartCursorWatcher::characterInserted#$
    {57, 464, 746},	// KTextEditor::SmartCursorWatcher::deleted#
    {57, 782, 742},	// KTextEditor::SmartCursorWatcher::positionChanged#
    {57, 784, 743},	// KTextEditor::SmartCursorWatcher::positionDeleted#
    {57, 1016, 741},	// KTextEditor::SmartCursorWatcher::setWantsDirectChanges$
    {57, 1121, 740},	// KTextEditor::SmartCursorWatcher::wantsDirectChanges
    {57, 1175, 748},	// KTextEditor::SmartCursorWatcher::~SmartCursorWatcher
    {58, 231, 749},	// KTextEditor::SmartInterface::SmartInterface
    {58, 232, 787},	// KTextEditor::SmartInterface::SmartInterface#
    {58, 277, 777},	// KTextEditor::SmartInterface::addActionsToDocument#
    {58, 279, 781},	// KTextEditor::SmartInterface::addActionsToView##
    {58, 283, 802},	// KTextEditor::SmartInterface::addHighlightToDocument#
    {58, 284, 769},	// KTextEditor::SmartInterface::addHighlightToDocument#$
    {58, 286, 803},	// KTextEditor::SmartInterface::addHighlightToView##
    {58, 287, 773},	// KTextEditor::SmartInterface::addHighlightToView##$
    {58, 318, 785},	// KTextEditor::SmartInterface::attributeDynamic?
    {58, 320, 786},	// KTextEditor::SmartInterface::attributeNotDynamic?
    {58, 356, 780},	// KTextEditor::SmartInterface::clearDocumentActions
    {58, 357, 772},	// KTextEditor::SmartInterface::clearDocumentHighlights
    {58, 361, 752},	// KTextEditor::SmartInterface::clearOnDocumentReload
    {58, 362, 757},	// KTextEditor::SmartInterface::clearRevision
    {58, 363, 751},	// KTextEditor::SmartInterface::clearSmartInterface
    {58, 365, 784},	// KTextEditor::SmartInterface::clearViewActions#
    {58, 367, 776},	// KTextEditor::SmartInterface::clearViewHighlights#
    {58, 429, 754},	// KTextEditor::SmartInterface::currentRevision
    {58, 457, 762},	// KTextEditor::SmartInterface::deleteCursors
    {58, 460, 768},	// KTextEditor::SmartInterface::deleteRanges
    {58, 472, 779},	// KTextEditor::SmartInterface::documentActions
    {58, 476, 771},	// KTextEditor::SmartInterface::documentHighlights
    {58, 731, 790},	// KTextEditor::SmartInterface::newSmartCursor
    {58, 732, 791},	// KTextEditor::SmartInterface::newSmartCursor#
    {58, 733, 760},	// KTextEditor::SmartInterface::newSmartCursor#$
    {58, 734, 792},	// KTextEditor::SmartInterface::newSmartCursor$$
    {58, 735, 761},	// KTextEditor::SmartInterface::newSmartCursor$$$
    {58, 736, 793},	// KTextEditor::SmartInterface::newSmartRange
    {58, 737, 794},	// KTextEditor::SmartInterface::newSmartRange#
    {58, 738, -36},	// KTextEditor::SmartInterface::newSmartRange##
    {58, 739, -40},	// KTextEditor::SmartInterface::newSmartRange###
    {58, 740, -43},	// KTextEditor::SmartInterface::newSmartRange###$
    {58, 741, 763},	// KTextEditor::SmartInterface::newSmartRange##$
    {58, 742, 798},	// KTextEditor::SmartInterface::newSmartRange$$$$
    {58, 743, 799},	// KTextEditor::SmartInterface::newSmartRange$$$$#
    {58, 744, 765},	// KTextEditor::SmartInterface::newSmartRange$$$$#$
    {58, 833, 755},	// KTextEditor::SmartInterface::releaseRevision$
    {58, 837, 778},	// KTextEditor::SmartInterface::removeActionsFromDocument#
    {58, 839, 782},	// KTextEditor::SmartInterface::removeActionsFromView##
    {58, 844, 770},	// KTextEditor::SmartInterface::removeHighlightFromDocument#
    {58, 846, 774},	// KTextEditor::SmartInterface::removeHighlightFromView##
    {58, 910, 753},	// KTextEditor::SmartInterface::setClearOnDocumentReload$
    {58, 1037, 750},	// KTextEditor::SmartInterface::smartMutex
    {58, 1087, -46},	// KTextEditor::SmartInterface::translateFromRevision#
    {58, 1088, -49},	// KTextEditor::SmartInterface::translateFromRevision#$
    {58, 1091, 767},	// KTextEditor::SmartInterface::unbindSmartRange#
    {58, 1099, 756},	// KTextEditor::SmartInterface::useRevision$
    {58, 1107, 783},	// KTextEditor::SmartInterface::viewActions#
    {58, 1114, 775},	// KTextEditor::SmartInterface::viewHighlights#
    {58, 1176, 804},	// KTextEditor::SmartInterface::~SmartInterface
    {59, 64, 864},	// KTextEditor::SmartRange::DoNotExpand
    {59, 85, 865},	// KTextEditor::SmartRange::ExpandLeft
    {59, 86, 866},	// KTextEditor::SmartRange::ExpandRight
    {59, 234, 862},	// KTextEditor::SmartRange::SmartRange##
    {59, 235, 863},	// KTextEditor::SmartRange::SmartRange###
    {59, 236, 852},	// KTextEditor::SmartRange::SmartRange###$
    {59, 291, 844},	// KTextEditor::SmartRange::addNotifier#
    {59, 297, 848},	// KTextEditor::SmartRange::addWatcher#
    {59, 310, 838},	// KTextEditor::SmartRange::associateAction#
    {59, 311, 840},	// KTextEditor::SmartRange::associatedActions
    {59, 316, 836},	// KTextEditor::SmartRange::attribute
    {59, 341, 854},	// KTextEditor::SmartRange::checkFeedback
    {59, 343, 830},	// KTextEditor::SmartRange::childAfter#
    {59, 345, 829},	// KTextEditor::SmartRange::childBefore#
    {59, 351, 825},	// KTextEditor::SmartRange::childRanges
    {59, 353, 828},	// KTextEditor::SmartRange::clearAndDeleteChildRanges
    {59, 354, 841},	// KTextEditor::SmartRange::clearAssociatedActions
    {59, 355, 826},	// KTextEditor::SmartRange::clearChildRanges
    {59, 404, 812},	// KTextEditor::SmartRange::confineToRange#
    {59, 422, 855},	// KTextEditor::SmartRange::createNotifier
    {59, 445, 860},	// KTextEditor::SmartRange::deepestRangeContaining#
    {59, 446, 861},	// KTextEditor::SmartRange::deepestRangeContaining#?
    {59, 447, 833},	// KTextEditor::SmartRange::deepestRangeContaining#??
    {59, 449, 834},	// KTextEditor::SmartRange::deepestRangesContaining#
    {59, 456, 827},	// KTextEditor::SmartRange::deleteChildRanges
    {59, 459, 846},	// KTextEditor::SmartRange::deletePrimaryNotifier
    {59, 465, 823},	// KTextEditor::SmartRange::depth
    {59, 470, 839},	// KTextEditor::SmartRange::dissociateAction#
    {59, 471, 814},	// KTextEditor::SmartRange::document
    {59, 545, 813},	// KTextEditor::SmartRange::expandToRange#
    {59, 550, 832},	// KTextEditor::SmartRange::firstRangeContaining#
    {59, 574, 822},	// KTextEditor::SmartRange::hasParent#
    {59, 600, 818},	// KTextEditor::SmartRange::insertBehavior
    {59, 629, 805},	// KTextEditor::SmartRange::isSmartRange
    {59, 716, 831},	// KTextEditor::SmartRange::mostSpecificRange#
    {59, 746, 843},	// KTextEditor::SmartRange::notifiers
    {59, 756, -27},	// KTextEditor::SmartRange::operator=#
    {59, 761, 835},	// KTextEditor::SmartRange::overlapCount
    {59, 773, 820},	// KTextEditor::SmartRange::parentRange
    {59, 795, 842},	// KTextEditor::SmartRange::primaryNotifier
    {59, 809, 853},	// KTextEditor::SmartRange::rangeChanged##
    {59, 827, 856},	// KTextEditor::SmartRange::rebuildChildStructure
    {59, 852, 845},	// KTextEditor::SmartRange::removeNotifier#
    {59, 856, 859},	// KTextEditor::SmartRange::removeText
    {59, 859, 817},	// KTextEditor::SmartRange::removeText$
    {59, 863, 849},	// KTextEditor::SmartRange::removeWatcher#
    {59, 869, 858},	// KTextEditor::SmartRange::replaceText?
    {59, 870, 816},	// KTextEditor::SmartRange::replaceText?$
    {59, 898, 837},	// KTextEditor::SmartRange::setAttribute?
    {59, 942, 819},	// KTextEditor::SmartRange::setInsertBehavior$
    {59, 984, 821},	// KTextEditor::SmartRange::setParentRange#
    {59, 989, 807},	// KTextEditor::SmartRange::setRange#
    {59, 1036, -30},	// KTextEditor::SmartRange::smartEnd
    {59, 1039, -33},	// KTextEditor::SmartRange::smartStart
    {59, 1056, 857},	// KTextEditor::SmartRange::text
    {59, 1059, 815},	// KTextEditor::SmartRange::text$
    {59, 1075, 806},	// KTextEditor::SmartRange::toSmartRange
    {59, 1076, 824},	// KTextEditor::SmartRange::topParentRange
    {59, 1125, 847},	// KTextEditor::SmartRange::watchers
    {59, 1177, 867},	// KTextEditor::SmartRange::~SmartRange
    {60, 237, 875},	// KTextEditor::SmartRangeNotifier::SmartRangeNotifier
    {60, 330, 883},	// KTextEditor::SmartRangeNotifier::caretEnteredRange##
    {60, 332, 884},	// KTextEditor::SmartRangeNotifier::caretExitedRange##
    {60, 348, 888},	// KTextEditor::SmartRangeNotifier::childRangeInserted##
    {60, 350, 889},	// KTextEditor::SmartRangeNotifier::childRangeRemoved##
    {60, 699, 868},	// KTextEditor::SmartRangeNotifier::metaObject
    {60, 719, 881},	// KTextEditor::SmartRangeNotifier::mouseEnteredRange##
    {60, 721, 882},	// KTextEditor::SmartRangeNotifier::mouseExitedRange##
    {60, 775, 887},	// KTextEditor::SmartRangeNotifier::parentRangeChanged###
    {60, 799, 874},	// KTextEditor::SmartRangeNotifier::qt_metacall$$?
    {60, 801, 869},	// KTextEditor::SmartRangeNotifier::qt_metacast$
    {60, 807, 890},	// KTextEditor::SmartRangeNotifier::rangeAttributeChanged#??
    {60, 811, 879},	// KTextEditor::SmartRangeNotifier::rangeContentsChanged#
    {60, 812, 880},	// KTextEditor::SmartRangeNotifier::rangeContentsChanged##
    {60, 814, 886},	// KTextEditor::SmartRangeNotifier::rangeDeleted#
    {60, 816, 885},	// KTextEditor::SmartRangeNotifier::rangeEliminated#
    {60, 818, 878},	// KTextEditor::SmartRangeNotifier::rangePositionChanged#
    {60, 1016, 877},	// KTextEditor::SmartRangeNotifier::setWantsDirectChanges$
    {60, 1047, 893},	// KTextEditor::SmartRangeNotifier::staticMetaObject
    {60, 1079, 891},	// KTextEditor::SmartRangeNotifier::tr$
    {60, 1080, 870},	// KTextEditor::SmartRangeNotifier::tr$$
    {60, 1081, 872},	// KTextEditor::SmartRangeNotifier::tr$$$
    {60, 1083, 892},	// KTextEditor::SmartRangeNotifier::trUtf8$
    {60, 1084, 871},	// KTextEditor::SmartRangeNotifier::trUtf8$$
    {60, 1085, 873},	// KTextEditor::SmartRangeNotifier::trUtf8$$$
    {60, 1121, 876},	// KTextEditor::SmartRangeNotifier::wantsDirectChanges
    {60, 1178, 894},	// KTextEditor::SmartRangeNotifier::~SmartRangeNotifier
    {61, 238, 895},	// KTextEditor::SmartRangeWatcher::SmartRangeWatcher
    {61, 239, 911},	// KTextEditor::SmartRangeWatcher::SmartRangeWatcher#
    {61, 330, 903},	// KTextEditor::SmartRangeWatcher::caretEnteredRange##
    {61, 332, 904},	// KTextEditor::SmartRangeWatcher::caretExitedRange##
    {61, 348, 908},	// KTextEditor::SmartRangeWatcher::childRangeInserted##
    {61, 350, 909},	// KTextEditor::SmartRangeWatcher::childRangeRemoved##
    {61, 719, 901},	// KTextEditor::SmartRangeWatcher::mouseEnteredRange##
    {61, 721, 902},	// KTextEditor::SmartRangeWatcher::mouseExitedRange##
    {61, 775, 907},	// KTextEditor::SmartRangeWatcher::parentRangeChanged###
    {61, 807, 910},	// KTextEditor::SmartRangeWatcher::rangeAttributeChanged#??
    {61, 811, 899},	// KTextEditor::SmartRangeWatcher::rangeContentsChanged#
    {61, 812, 900},	// KTextEditor::SmartRangeWatcher::rangeContentsChanged##
    {61, 814, 906},	// KTextEditor::SmartRangeWatcher::rangeDeleted#
    {61, 816, 905},	// KTextEditor::SmartRangeWatcher::rangeEliminated#
    {61, 818, 898},	// KTextEditor::SmartRangeWatcher::rangePositionChanged#
    {61, 1016, 897},	// KTextEditor::SmartRangeWatcher::setWantsDirectChanges$
    {61, 1121, 896},	// KTextEditor::SmartRangeWatcher::wantsDirectChanges
    {61, 1179, 912},	// KTextEditor::SmartRangeWatcher::~SmartRangeWatcher
    {62, 127, 917},	// KTextEditor::TemplateInterface::KTE_INTERNAL_setupIntialValues$?
    {62, 246, 913},	// KTextEditor::TemplateInterface::TemplateInterface
    {62, 247, 918},	// KTextEditor::TemplateInterface::TemplateInterface#
    {62, 543, 914},	// KTextEditor::TemplateInterface::expandMacros?#
    {62, 608, 915},	// KTextEditor::TemplateInterface::insertTemplateText#$?
    {62, 610, 916},	// KTextEditor::TemplateInterface::insertTemplateTextImplementation#$?
    {62, 1180, 919},	// KTextEditor::TemplateInterface::~TemplateInterface
    {63, 248, 920},	// KTextEditor::TextHintInterface::TextHintInterface
    {63, 249, 924},	// KTextEditor::TextHintInterface::TextHintInterface#
    {63, 467, 922},	// KTextEditor::TextHintInterface::disableTextHints
    {63, 519, 921},	// KTextEditor::TextHintInterface::enableTextHints$
    {63, 730, 923},	// KTextEditor::TextHintInterface::needTextHint#$
    {63, 1181, 925},	// KTextEditor::TextHintInterface::~TextHintInterface
    {64, 256, 926},	// KTextEditor::VariableInterface::VariableInterface
    {64, 257, 929},	// KTextEditor::VariableInterface::VariableInterface#
    {64, 1101, 927},	// KTextEditor::VariableInterface::variable$
    {64, 1103, 928},	// KTextEditor::VariableInterface::variableChanged#$$
    {64, 1182, 930},	// KTextEditor::VariableInterface::~VariableInterface
    {65, 70, 980},	// KTextEditor::View::EditInsert
    {65, 71, 981},	// KTextEditor::View::EditOverwrite
    {65, 72, 982},	// KTextEditor::View::EditViMode
    {65, 259, 938},	// KTextEditor::View::View#
    {65, 322, 972},	// KTextEditor::View::blockSelection
    {65, 413, 950},	// KTextEditor::View::contextMenu
    {65, 415, 952},	// KTextEditor::View::contextMenuAboutToShow##
    {65, 434, 954},	// KTextEditor::View::cursorPosition
    {65, 436, 958},	// KTextEditor::View::cursorPositionChanged##
    {65, 437, 957},	// KTextEditor::View::cursorPositionCoordinates
    {65, 438, 955},	// KTextEditor::View::cursorPositionVirtual
    {65, 440, 956},	// KTextEditor::View::cursorToCoordinate#
    {65, 450, 977},	// KTextEditor::View::defaultContextMenu
    {65, 451, 951},	// KTextEditor::View::defaultContextMenu#
    {65, 471, 939},	// KTextEditor::View::document
    {65, 555, 943},	// KTextEditor::View::focusIn#
    {65, 559, 944},	// KTextEditor::View::focusOut#
    {65, 592, 960},	// KTextEditor::View::horizontalScrollPositionChanged#
    {65, 597, 947},	// KTextEditor::View::informationMessage#$
    {65, 616, 974},	// KTextEditor::View::insertText$
    {65, 622, 940},	// KTextEditor::View::isActiveView
    {65, 699, 931},	// KTextEditor::View::metaObject
    {65, 724, 963},	// KTextEditor::View::mousePositionChanged##
    {65, 727, 961},	// KTextEditor::View::mouseTrackingEnabled
    {65, 799, 937},	// KTextEditor::View::qt_metacall$$?
    {65, 801, 932},	// KTextEditor::View::qt_metacast$
    {65, 854, 969},	// KTextEditor::View::removeSelection
    {65, 855, 970},	// KTextEditor::View::removeSelectionText
    {65, 886, 966},	// KTextEditor::View::selection
    {65, 888, 973},	// KTextEditor::View::selectionChanged#
    {65, 889, 967},	// KTextEditor::View::selectionRange
    {65, 890, 968},	// KTextEditor::View::selectionText
    {65, 904, 971},	// KTextEditor::View::setBlockSelection$
    {65, 919, 949},	// KTextEditor::View::setContextMenu#
    {65, 921, 953},	// KTextEditor::View::setCursorPosition#
    {65, 974, 962},	// KTextEditor::View::setMouseTrackingEnabled$
    {65, 1000, 964},	// KTextEditor::View::setSelection#
    {65, 1001, 978},	// KTextEditor::View::setSelection#$
    {65, 1002, 965},	// KTextEditor::View::setSelection#$$
    {65, 1047, 979},	// KTextEditor::View::staticMetaObject
    {65, 1066, 948},	// KTextEditor::View::textInserted##$
    {65, 1079, 975},	// KTextEditor::View::tr$
    {65, 1080, 933},	// KTextEditor::View::tr$$
    {65, 1081, 935},	// KTextEditor::View::tr$$$
    {65, 1083, 976},	// KTextEditor::View::trUtf8$
    {65, 1084, 934},	// KTextEditor::View::trUtf8$$
    {65, 1085, 936},	// KTextEditor::View::trUtf8$$$
    {65, 1105, 959},	// KTextEditor::View::verticalScrollPositionChanged##
    {65, 1110, 942},	// KTextEditor::View::viewEditMode
    {65, 1112, 946},	// KTextEditor::View::viewEditModeChanged#$
    {65, 1115, 941},	// KTextEditor::View::viewMode
    {65, 1117, 945},	// KTextEditor::View::viewModeChanged#
    {65, 1183, 983},	// KTextEditor::View::~View
    {66, 25, 994},	// KTextEditor::ViewBarContainer::BottomBar
    {66, 131, 991},	// KTextEditor::ViewBarContainer::LeftBar
    {66, 208, 993},	// KTextEditor::ViewBarContainer::RightBar
    {66, 250, 992},	// KTextEditor::ViewBarContainer::TopBar
    {66, 260, 984},	// KTextEditor::ViewBarContainer::ViewBarContainer
    {66, 261, 990},	// KTextEditor::ViewBarContainer::ViewBarContainer#
    {66, 295, 986},	// KTextEditor::ViewBarContainer::addViewBarToLayout##$
    {66, 462, 989},	// KTextEditor::ViewBarContainer::deleteViewBarForView#$
    {66, 565, 985},	// KTextEditor::ViewBarContainer::getViewBarParent#$
    {66, 581, 988},	// KTextEditor::ViewBarContainer::hideViewBarForView#$
    {66, 1031, 987},	// KTextEditor::ViewBarContainer::showViewBarForView#$
    {66, 1184, 995},	// KTextEditor::ViewBarContainer::~ViewBarContainer
    {87, 107, 1079},	// QGlobalSpace::KST_CTimeInfo
    {87, 108, 1053},	// QGlobalSpace::KST_KCustom
    {87, 109, 1047},	// QGlobalSpace::KST_KDEDesktopMimeType
    {87, 110, 1046},	// QGlobalSpace::KST_KFolderMimeType
    {87, 111, 1076},	// QGlobalSpace::KST_KImageIO
    {87, 112, 1050},	// QGlobalSpace::KST_KImageIOFormat
    {87, 113, 1045},	// QGlobalSpace::KST_KMimeType
    {87, 114, 1048},	// QGlobalSpace::KST_KMimeTypeEntry
    {87, 115, 1078},	// QGlobalSpace::KST_KMimeTypeFactory
    {87, 116, 1051},	// QGlobalSpace::KST_KProtocolInfo
    {87, 117, 1077},	// QGlobalSpace::KST_KProtocolInfoFactory
    {87, 118, 1043},	// QGlobalSpace::KST_KService
    {87, 119, 1073},	// QGlobalSpace::KST_KServiceFactory
    {87, 120, 1049},	// QGlobalSpace::KST_KServiceGroup
    {87, 121, 1075},	// QGlobalSpace::KST_KServiceGroupFactory
    {87, 122, 1052},	// QGlobalSpace::KST_KServiceSeparator
    {87, 123, 1044},	// QGlobalSpace::KST_KServiceType
    {87, 124, 1074},	// QGlobalSpace::KST_KServiceTypeFactory
    {87, 125, 1042},	// QGlobalSpace::KST_KSycocaEntry
    {87, 132, 1058},	// QGlobalSpace::LicensedActiveQt
    {87, 133, 1064},	// QGlobalSpace::LicensedCore
    {87, 134, 1056},	// QGlobalSpace::LicensedDBus
    {87, 135, 1061},	// QGlobalSpace::LicensedDeclarative
    {87, 136, 1039},	// QGlobalSpace::LicensedGui
    {87, 137, 1070},	// QGlobalSpace::LicensedHelp
    {87, 138, 1071},	// QGlobalSpace::LicensedMultimedia
    {87, 139, 1081},	// QGlobalSpace::LicensedNetwork
    {87, 140, 1063},	// QGlobalSpace::LicensedOpenGL
    {87, 141, 1055},	// QGlobalSpace::LicensedOpenVG
    {87, 142, 1072},	// QGlobalSpace::LicensedQt3Support
    {87, 143, 1041},	// QGlobalSpace::LicensedQt3SupportLight
    {87, 144, 1054},	// QGlobalSpace::LicensedScript
    {87, 145, 1059},	// QGlobalSpace::LicensedScriptTools
    {87, 146, 1062},	// QGlobalSpace::LicensedSql
    {87, 147, 1060},	// QGlobalSpace::LicensedSvg
    {87, 148, 1057},	// QGlobalSpace::LicensedTest
    {87, 149, 1040},	// QGlobalSpace::LicensedXml
    {87, 150, 1080},	// QGlobalSpace::LicensedXmlPatterns
    {87, 190, 1034},	// QGlobalSpace::Q_COMPLEX_TYPE
    {87, 191, 1038},	// QGlobalSpace::Q_DUMMY_TYPE
    {87, 192, 1037},	// QGlobalSpace::Q_MOVABLE_TYPE
    {87, 193, 1035},	// QGlobalSpace::Q_PRIMITIVE_TYPE
    {87, 194, 1036},	// QGlobalSpace::Q_STATIC_TYPE
    {87, 195, 1067},	// QGlobalSpace::QtCriticalMsg
    {87, 196, 1065},	// QGlobalSpace::QtDebugMsg
    {87, 197, 1068},	// QGlobalSpace::QtFatalMsg
    {87, 198, 1069},	// QGlobalSpace::QtSystemMsg
    {87, 199, 1066},	// QGlobalSpace::QtWarningMsg
};

}

extern "C" {

SMOKE_IMPORT void init_kparts_Smoke();

static bool initialized = false;
Smoke *ktexteditor_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_ktexteditor_Smoke() {
    init_kparts_Smoke();
    if (initialized) return;
    ktexteditor_Smoke = new Smoke(
        "ktexteditor",
        __smokektexteditor::classes, 116,
        __smokektexteditor::methods, 1132,
        __smokektexteditor::methodMaps, 993,
        __smokektexteditor::methodNames, 1184,
        __smokektexteditor::types, 345,
        __smokektexteditor::inheritanceList,
        __smokektexteditor::argumentList,
        __smokektexteditor::ambiguousMethodList,
        __smokektexteditor::cast );
    initialized = true;
}

void delete_ktexteditor_Smoke() { delete ktexteditor_Smoke; }

}
