#include <qthelp_includes.h>

#include <smoke.h>
#include <qthelp_smoke.h>

namespace __smokeqthelp {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAbstractItemModel
      switch(to) {
        case 35: return (void*)(QObject*)(QAbstractItemModel*)xptr;
        case 1: return (void*)(QAbstractItemModel*)xptr;
        case 21: return (void*)(QHelpIndexModel*)(QAbstractItemModel*)xptr;
        case 17: return (void*)(QHelpContentModel*)(QAbstractItemModel*)xptr;
        default: return xptr;
      }
    case 2:   //QActionEvent
      switch(to) {
        case 2: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 3:   //QBool
      switch(to) {
        case 3: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 4:   //QByteArray
      switch(to) {
        case 4: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 5:   //QChildEvent
      switch(to) {
        case 12: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 5: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QCloseEvent
      switch(to) {
        case 6: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 7:   //QContextMenuEvent
      switch(to) {
        case 7: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QDragEnterEvent
      switch(to) {
        case 8: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 9:   //QDragLeaveEvent
      switch(to) {
        case 9: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 10:   //QDragMoveEvent
      switch(to) {
        case 10: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QDropEvent
      switch(to) {
        case 11: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 12:   //QEvent
      switch(to) {
        case 12: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 13:   //QFocusEvent
      switch(to) {
        case 13: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 14:   //QFont
      switch(to) {
        case 14: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 16:   //QHelpContentItem
      switch(to) {
        case 16: return (void*)(QHelpContentItem*)xptr;
        default: return xptr;
      }
    case 17:   //QHelpContentModel
      switch(to) {
        case 1: return (void*)(QAbstractItemModel*)(QHelpContentModel*)xptr;
        case 35: return (void*)(QObject*)(QHelpContentModel*)xptr;
        case 17: return (void*)(QHelpContentModel*)xptr;
        default: return xptr;
      }
    case 18:   //QHelpContentWidget
      switch(to) {
        case 48: return (void*)(QTreeView*)(QHelpContentWidget*)xptr;
        case 52: return (void*)(QWidget*)(QHelpContentWidget*)xptr;
        case 35: return (void*)(QObject*)(QHelpContentWidget*)xptr;
        case 18: return (void*)(QHelpContentWidget*)xptr;
        default: return xptr;
      }
    case 19:   //QHelpEngine
      switch(to) {
        case 20: return (void*)(QHelpEngineCore*)(QHelpEngine*)xptr;
        case 35: return (void*)(QObject*)(QHelpEngine*)xptr;
        case 19: return (void*)(QHelpEngine*)xptr;
        default: return xptr;
      }
    case 20:   //QHelpEngineCore
      switch(to) {
        case 35: return (void*)(QObject*)(QHelpEngineCore*)xptr;
        case 20: return (void*)(QHelpEngineCore*)xptr;
        case 19: return (void*)(QHelpEngine*)(QHelpEngineCore*)xptr;
        default: return xptr;
      }
    case 21:   //QHelpIndexModel
      switch(to) {
        case 44: return (void*)(QStringListModel*)(QHelpIndexModel*)xptr;
        case 1: return (void*)(QAbstractItemModel*)(QHelpIndexModel*)xptr;
        case 35: return (void*)(QObject*)(QHelpIndexModel*)xptr;
        case 21: return (void*)(QHelpIndexModel*)xptr;
        default: return xptr;
      }
    case 22:   //QHelpIndexWidget
      switch(to) {
        case 30: return (void*)(QListView*)(QHelpIndexWidget*)xptr;
        case 52: return (void*)(QWidget*)(QHelpIndexWidget*)xptr;
        case 35: return (void*)(QObject*)(QHelpIndexWidget*)xptr;
        case 22: return (void*)(QHelpIndexWidget*)xptr;
        default: return xptr;
      }
    case 23:   //QHelpSearchEngine
      switch(to) {
        case 35: return (void*)(QObject*)(QHelpSearchEngine*)xptr;
        case 23: return (void*)(QHelpSearchEngine*)xptr;
        default: return xptr;
      }
    case 24:   //QHelpSearchQuery
      switch(to) {
        case 24: return (void*)(QHelpSearchQuery*)xptr;
        default: return xptr;
      }
    case 25:   //QHelpSearchQueryWidget
      switch(to) {
        case 52: return (void*)(QWidget*)(QHelpSearchQueryWidget*)xptr;
        case 35: return (void*)(QObject*)(QHelpSearchQueryWidget*)xptr;
        case 25: return (void*)(QHelpSearchQueryWidget*)xptr;
        default: return xptr;
      }
    case 26:   //QHelpSearchResultWidget
      switch(to) {
        case 52: return (void*)(QWidget*)(QHelpSearchResultWidget*)xptr;
        case 35: return (void*)(QObject*)(QHelpSearchResultWidget*)xptr;
        case 26: return (void*)(QHelpSearchResultWidget*)xptr;
        default: return xptr;
      }
    case 27:   //QHideEvent
      switch(to) {
        case 27: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 28:   //QInputMethodEvent
      switch(to) {
        case 28: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 29:   //QKeyEvent
      switch(to) {
        case 29: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 30:   //QListView
      switch(to) {
        case 52: return (void*)(QWidget*)(QListView*)xptr;
        case 35: return (void*)(QObject*)(QListView*)xptr;
        case 30: return (void*)(QListView*)xptr;
        case 22: return (void*)(QHelpIndexWidget*)(QListView*)xptr;
        default: return xptr;
      }
    case 31:   //QMetaObject
      switch(to) {
        case 31: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 32:   //QModelIndex
      switch(to) {
        case 32: return (void*)(QModelIndex*)xptr;
        default: return xptr;
      }
    case 33:   //QMouseEvent
      switch(to) {
        case 33: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 34:   //QMoveEvent
      switch(to) {
        case 34: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 35:   //QObject
      switch(to) {
        case 35: return (void*)(QObject*)xptr;
        case 25: return (void*)(QHelpSearchQueryWidget*)(QObject*)xptr;
        case 18: return (void*)(QHelpContentWidget*)(QObject*)xptr;
        case 21: return (void*)(QHelpIndexModel*)(QObject*)xptr;
        case 17: return (void*)(QHelpContentModel*)(QObject*)xptr;
        case 22: return (void*)(QHelpIndexWidget*)(QObject*)xptr;
        case 20: return (void*)(QHelpEngineCore*)(QObject*)xptr;
        case 19: return (void*)(QHelpEngine*)(QObject*)xptr;
        case 23: return (void*)(QHelpSearchEngine*)(QObject*)xptr;
        case 26: return (void*)(QHelpSearchResultWidget*)(QObject*)xptr;
        default: return xptr;
      }
    case 36:   //QPaintEngine
      switch(to) {
        case 36: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 37:   //QPaintEvent
      switch(to) {
        case 37: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 38:   //QPalette
      switch(to) {
        case 38: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 39:   //QPoint
      switch(to) {
        case 39: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 40:   //QRegExp
      switch(to) {
        case 40: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 41:   //QResizeEvent
      switch(to) {
        case 41: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 42:   //QShowEvent
      switch(to) {
        case 42: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 43:   //QSize
      switch(to) {
        case 43: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 44:   //QStringListModel
      switch(to) {
        case 1: return (void*)(QAbstractItemModel*)(QStringListModel*)xptr;
        case 35: return (void*)(QObject*)(QStringListModel*)xptr;
        case 44: return (void*)(QStringListModel*)xptr;
        case 21: return (void*)(QHelpIndexModel*)(QStringListModel*)xptr;
        default: return xptr;
      }
    case 45:   //QStyle
      switch(to) {
        case 35: return (void*)(QObject*)(QStyle*)xptr;
        case 45: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 46:   //QTabletEvent
      switch(to) {
        case 46: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 47:   //QTimerEvent
      switch(to) {
        case 12: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 47: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 48:   //QTreeView
      switch(to) {
        case 52: return (void*)(QWidget*)(QTreeView*)xptr;
        case 35: return (void*)(QObject*)(QTreeView*)xptr;
        case 48: return (void*)(QTreeView*)xptr;
        case 18: return (void*)(QHelpContentWidget*)(QTreeView*)xptr;
        default: return xptr;
      }
    case 49:   //QUrl
      switch(to) {
        case 49: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 50:   //QVariant
      switch(to) {
        case 50: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 51:   //QWheelEvent
      switch(to) {
        case 51: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 52:   //QWidget
      switch(to) {
        case 35: return (void*)(QObject*)(QWidget*)xptr;
        case 52: return (void*)(QWidget*)xptr;
        case 25: return (void*)(QHelpSearchQueryWidget*)(QWidget*)xptr;
        case 18: return (void*)(QHelpContentWidget*)(QWidget*)xptr;
        case 22: return (void*)(QHelpIndexWidget*)(QWidget*)xptr;
        case 26: return (void*)(QHelpSearchResultWidget*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    1, 0,	// 1: QAbstractItemModel
    48, 0,	// 3: QTreeView
    20, 0,	// 5: QHelpEngineCore
    35, 0,	// 7: QObject
    44, 0,	// 9: QStringListModel
    30, 0,	// 11: QListView
    52, 0,	// 13: QWidget
};

// These are the xenum functions for manipulating enum pointers
void xenum_QHelpSearchQuery(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpContentItem(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpContentModel(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpContentWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpEngine(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpEngineCore(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpIndexModel(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpIndexWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpSearchEngine(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpSearchQuery(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpSearchQueryWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_QHelpSearchResultWidget(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAbstractItemModel", true, 0, 0, 0, 0, 0 },	//1
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//2
    { "QBool", true, 0, 0, 0, 0, 0 },	//3
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//4
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//5
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//6
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//7
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//8
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//9
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//11
    { "QEvent", true, 0, 0, 0, 0, 0 },	//12
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//13
    { "QFont", true, 0, 0, 0, 0, 0 },	//14
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//15
    { "QHelpContentItem", false, 0, xcall_QHelpContentItem, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QHelpContentItem) },	//16
    { "QHelpContentModel", false, 1, xcall_QHelpContentModel, 0, Smoke::cf_virtual, sizeof(QHelpContentModel) },	//17
    { "QHelpContentWidget", false, 3, xcall_QHelpContentWidget, 0, Smoke::cf_virtual, sizeof(QHelpContentWidget) },	//18
    { "QHelpEngine", false, 5, xcall_QHelpEngine, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QHelpEngine) },	//19
    { "QHelpEngineCore", false, 7, xcall_QHelpEngineCore, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QHelpEngineCore) },	//20
    { "QHelpIndexModel", false, 9, xcall_QHelpIndexModel, 0, Smoke::cf_virtual, sizeof(QHelpIndexModel) },	//21
    { "QHelpIndexWidget", false, 11, xcall_QHelpIndexWidget, 0, Smoke::cf_virtual, sizeof(QHelpIndexWidget) },	//22
    { "QHelpSearchEngine", false, 7, xcall_QHelpSearchEngine, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QHelpSearchEngine) },	//23
    { "QHelpSearchQuery", false, 0, xcall_QHelpSearchQuery, xenum_QHelpSearchQuery, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QHelpSearchQuery) },	//24
    { "QHelpSearchQueryWidget", false, 13, xcall_QHelpSearchQueryWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QHelpSearchQueryWidget) },	//25
    { "QHelpSearchResultWidget", false, 13, xcall_QHelpSearchResultWidget, 0, Smoke::cf_virtual, sizeof(QHelpSearchResultWidget) },	//26
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//27
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//28
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//29
    { "QListView", true, 0, 0, 0, 0, 0 },	//30
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//31
    { "QModelIndex", true, 0, 0, 0, 0, 0 },	//32
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//33
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//34
    { "QObject", true, 0, 0, 0, 0, 0 },	//35
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//36
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//37
    { "QPalette", true, 0, 0, 0, 0, 0 },	//38
    { "QPoint", true, 0, 0, 0, 0, 0 },	//39
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//40
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//41
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//42
    { "QSize", true, 0, 0, 0, 0, 0 },	//43
    { "QStringListModel", true, 0, 0, 0, 0, 0 },	//44
    { "QStyle", true, 0, 0, 0, 0, 0 },	//45
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//46
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//47
    { "QTreeView", true, 0, 0, 0, 0, 0 },	//48
    { "QUrl", true, 0, 0, 0, 0, 0 },	//49
    { "QVariant", true, 0, 0, 0, 0, 0 },	//50
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//51
    { "QWidget", true, 0, 0, 0, 0, 0 },	//52
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QActionEvent*", 2, Smoke::t_class|Smoke::tf_ptr },	//1
    { "QBool", 3, Smoke::t_class|Smoke::tf_stack },	//2
    { "QByteArray", 4, Smoke::t_class|Smoke::tf_stack },	//3
    { "QChildEvent*", 5, Smoke::t_class|Smoke::tf_ptr },	//4
    { "QCloseEvent*", 6, Smoke::t_class|Smoke::tf_ptr },	//5
    { "QContextMenuEvent*", 7, Smoke::t_class|Smoke::tf_ptr },	//6
    { "QDragEnterEvent*", 8, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QDragLeaveEvent*", 9, Smoke::t_class|Smoke::tf_ptr },	//8
    { "QDragMoveEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QDropEvent*", 11, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//11
    { "QFocusEvent*", 13, Smoke::t_class|Smoke::tf_ptr },	//12
    { "QHelpContentItem*", 16, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QHelpContentModel*", 17, Smoke::t_class|Smoke::tf_ptr },	//14
    { "QHelpContentWidget*", 18, Smoke::t_class|Smoke::tf_ptr },	//15
    { "QHelpEngine*", 19, Smoke::t_class|Smoke::tf_ptr },	//16
    { "QHelpEngineCore*", 20, Smoke::t_class|Smoke::tf_ptr },	//17
    { "QHelpIndexModel*", 21, Smoke::t_class|Smoke::tf_ptr },	//18
    { "QHelpIndexWidget*", 22, Smoke::t_class|Smoke::tf_ptr },	//19
    { "QHelpSearchEngine*", 23, Smoke::t_class|Smoke::tf_ptr },	//20
    { "QHelpSearchQuery", 24, Smoke::t_class|Smoke::tf_stack },	//21
    { "QHelpSearchQuery*", 24, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QHelpSearchQuery::FieldName", 24, Smoke::t_enum|Smoke::tf_stack },	//23
    { "QHelpSearchQueryWidget*", 25, Smoke::t_class|Smoke::tf_ptr },	//24
    { "QHelpSearchResultWidget*", 26, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QHideEvent*", 27, Smoke::t_class|Smoke::tf_ptr },	//26
    { "QInputMethodEvent*", 28, Smoke::t_class|Smoke::tf_ptr },	//27
    { "QKeyEvent*", 29, Smoke::t_class|Smoke::tf_ptr },	//28
    { "QList<QHelpSearchQuery>", 0, Smoke::t_voidp|Smoke::tf_stack },	//29
    { "QList<QPair<QString,QString> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//30
    { "QList<QStringList>", 0, Smoke::t_voidp|Smoke::tf_stack },	//31
    { "QList<QUrl>", 0, Smoke::t_voidp|Smoke::tf_stack },	//32
    { "QMap<QString,QUrl>", 0, Smoke::t_voidp|Smoke::tf_stack },	//33
    { "QMetaObject::Call", 31, Smoke::t_enum|Smoke::tf_stack },	//34
    { "QModelIndex", 32, Smoke::t_class|Smoke::tf_stack },	//35
    { "QMouseEvent*", 33, Smoke::t_class|Smoke::tf_ptr },	//36
    { "QMoveEvent*", 34, Smoke::t_class|Smoke::tf_ptr },	//37
    { "QObject*", 35, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "QPaintEngine*", 36, Smoke::t_class|Smoke::tf_ptr },	//40
    { "QPaintEvent*", 37, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QPair<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//42
    { "QRegExp&", 40, Smoke::t_class|Smoke::tf_ref },	//43
    { "QResizeEvent*", 41, Smoke::t_class|Smoke::tf_ptr },	//44
    { "QShowEvent*", 42, Smoke::t_class|Smoke::tf_ptr },	//45
    { "QSize", 43, Smoke::t_class|Smoke::tf_stack },	//46
    { "QSql::Location", 0, Smoke::t_enum|Smoke::tf_stack },	//47
    { "QSql::NumericalPrecisionPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//48
    { "QSql::ParamTypeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//49
    { "QSql::TableType", 0, Smoke::t_enum|Smoke::tf_stack },	//50
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//51
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//52
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//53
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//54
    { "QStyle&", 45, Smoke::t_class|Smoke::tf_ref },	//55
    { "QTabletEvent*", 46, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QTimerEvent*", 47, Smoke::t_class|Smoke::tf_ptr },	//57
    { "QUrl", 49, Smoke::t_class|Smoke::tf_stack },	//58
    { "QVariant", 50, Smoke::t_class|Smoke::tf_stack },	//59
    { "QWheelEvent*", 51, Smoke::t_class|Smoke::tf_ptr },	//60
    { "QWidget*", 52, Smoke::t_class|Smoke::tf_ptr },	//61
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//130
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//133
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//134
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//135
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//136
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//137
    { "const QFont&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//138
    { "const QHelpContentItem&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//139
    { "const QHelpSearchQuery&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//140
    { "const QList<QHelpSearchQuery>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//141
    { "const QMap<QString,QUrl>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//142
    { "const QMetaObject&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//143
    { "const QMetaObject*", 31, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//144
    { "const QModelIndex&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//145
    { "const QPalette&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//146
    { "const QPoint&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//147
    { "const QRegExp&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//148
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//149
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//150
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//151
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//152
    { "const QUrl&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//153
    { "const QVariant&", 50, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//154
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//155
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//156
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//157
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//158
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//159
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//160
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//161
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    157, 0,	//1  int
    13, 0,	//3  QHelpContentItem*
    139, 0,	//5  const QHelpContentItem&
    155, 0,	//7  const char*
    155, 155, 0,	//9  const char*, const char*
    155, 155, 157, 0,	//12  const char*, const char*, int
    34, 157, 160, 0,	//16  QMetaObject::Call, int, void**
    150, 0,	//20  const QString&
    145, 0,	//22  const QModelIndex&
    145, 157, 0,	//24  const QModelIndex&, int
    157, 157, 145, 0,	//27  int, int, const QModelIndex&
    157, 157, 0,	//31  int, int
    153, 0,	//34  const QUrl&
    150, 38, 0,	//36  const QString&, QObject*
    150, 151, 0,	//39  const QString&, const QStringList&
    149, 151, 150, 0,	//42  const QString, const QStringList&, const QString&
    150, 154, 0,	//46  const QString&, const QVariant&
    150, 150, 0,	//49  const QString&, const QString&
    137, 0,	//52  bool
    149, 151, 0,	//54  const QString, const QStringList&
    153, 150, 0,	//57  const QUrl&, const QString&
    142, 150, 0,	//60  const QMap<QString,QUrl>&, const QString&
    17, 38, 0,	//63  QHelpEngineCore*, QObject*
    141, 0,	//66  const QList<QHelpSearchQuery>&
    17, 0,	//68  QHelpEngineCore*
    23, 151, 0,	//70  QHelpSearchQuery::FieldName, const QStringList&
    140, 0,	//73  const QHelpSearchQuery&
    23, 0,	//75  QHelpSearchQuery::FieldName
    151, 0,	//77  const QStringList&
    61, 0,	//79  QWidget*
    147, 0,	//81  const QPoint&
    11, 0,	//83  QEvent*
    38, 11, 0,	//85  QObject*, QEvent*
    57, 0,	//88  QTimerEvent*
    4, 0,	//90  QChildEvent*
    36, 0,	//92  QMouseEvent*
    60, 0,	//94  QWheelEvent*
    28, 0,	//96  QKeyEvent*
    12, 0,	//98  QFocusEvent*
    41, 0,	//100  QPaintEvent*
    37, 0,	//102  QMoveEvent*
    44, 0,	//104  QResizeEvent*
    5, 0,	//106  QCloseEvent*
    6, 0,	//108  QContextMenuEvent*
    56, 0,	//110  QTabletEvent*
    1, 0,	//112  QActionEvent*
    7, 0,	//114  QDragEnterEvent*
    9, 0,	//116  QDragMoveEvent*
    8, 0,	//118  QDragLeaveEvent*
    10, 0,	//120  QDropEvent*
    45, 0,	//122  QShowEvent*
    26, 0,	//124  QHideEvent*
    136, 0,	//126  _XEvent*
    39, 0,	//128  QPaintDevice::PaintDeviceMetric
    27, 0,	//130  QInputMethodEvent*
    96, 0,	//132  Qt::InputMethodQuery
    55, 0,	//134  QStyle&
    146, 0,	//136  const QPalette&
    138, 0,	//138  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "ALL",	//1
    "ATLEAST",	//2
    "DEFAULT",	//3
    "DrawChildren",	//4
    "DrawWindowBackground",	//5
    "FUZZY",	//6
    "IgnoreMask",	//7
    "PHRASE",	//8
    "QHelpContentItem",	//9
    "QHelpContentItem#",	//10
    "QHelpEngine",	//11
    "QHelpEngine$",	//12
    "QHelpEngine$#",	//13
    "QHelpEngineCore",	//14
    "QHelpEngineCore$",	//15
    "QHelpEngineCore$#",	//16
    "QHelpSearchEngine",	//17
    "QHelpSearchEngine#",	//18
    "QHelpSearchEngine##",	//19
    "QHelpSearchQuery",	//20
    "QHelpSearchQuery#",	//21
    "QHelpSearchQuery$?",	//22
    "QHelpSearchQueryWidget",	//23
    "QHelpSearchQueryWidget#",	//24
    "WITHOUT",	//25
    "actionEvent",	//26
    "activateCurrentItem",	//27
    "addCustomFilter",	//28
    "addCustomFilter$?",	//29
    "autoSaveFilter",	//30
    "cancelIndexing",	//31
    "cancelSearching",	//32
    "child",	//33
    "child$",	//34
    "childCount",	//35
    "childEvent",	//36
    "childPosition",	//37
    "childPosition#",	//38
    "closeEvent",	//39
    "collapseExtendedSearch",	//40
    "collectionFile",	//41
    "columnCount",	//42
    "columnCount#",	//43
    "connectNotify",	//44
    "contentItemAt",	//45
    "contentItemAt#",	//46
    "contentModel",	//47
    "contentWidget",	//48
    "contentsCreated",	//49
    "contentsCreationStarted",	//50
    "contextMenuEvent",	//51
    "copyCollectionFile",	//52
    "copyCollectionFile$",	//53
    "createContents",	//54
    "createContents$",	//55
    "createIndex",	//56
    "createIndex$",	//57
    "currentFilter",	//58
    "currentFilterChanged",	//59
    "currentFilterChanged$",	//60
    "customEvent",	//61
    "customFilters",	//62
    "customValue",	//63
    "customValue$",	//64
    "customValue$#",	//65
    "data",	//66
    "data#$",	//67
    "devType",	//68
    "disconnectNotify",	//69
    "documentationFileName",	//70
    "documentationFileName$",	//71
    "dragEnterEvent",	//72
    "dragLeaveEvent",	//73
    "dragMoveEvent",	//74
    "dropEvent",	//75
    "enabledChange",	//76
    "enterEvent",	//77
    "error",	//78
    "event",	//79
    "eventFilter",	//80
    "expandExtendedSearch",	//81
    "fieldName",	//82
    "fileData",	//83
    "fileData#",	//84
    "files",	//85
    "files$?",	//86
    "files$?$",	//87
    "filter",	//88
    "filter$",	//89
    "filter$$",	//90
    "filterAttributeSets",	//91
    "filterAttributeSets$",	//92
    "filterAttributes",	//93
    "filterAttributes$",	//94
    "filterIndices",	//95
    "filterIndices$",	//96
    "filterIndices$$",	//97
    "findFile",	//98
    "findFile#",	//99
    "focusNextPrevChild",	//100
    "focusOutEvent",	//101
    "fontChange",	//102
    "heightForWidth",	//103
    "hideEvent",	//104
    "hitCount",	//105
    "hits",	//106
    "hits$$",	//107
    "hitsCount",	//108
    "index",	//109
    "index$$",	//110
    "index$$#",	//111
    "indexCreated",	//112
    "indexCreationStarted",	//113
    "indexModel",	//114
    "indexOf",	//115
    "indexOf#",	//116
    "indexWidget",	//117
    "indexingFinished",	//118
    "indexingStarted",	//119
    "inputMethodEvent",	//120
    "inputMethodQuery",	//121
    "isCreatingContents",	//122
    "isCreatingIndex",	//123
    "keyPressEvent",	//124
    "keyReleaseEvent",	//125
    "languageChange",	//126
    "leaveEvent",	//127
    "linkActivated",	//128
    "linkActivated#",	//129
    "linkActivated#$",	//130
    "linkAt",	//131
    "linkAt#",	//132
    "linksActivated",	//133
    "linksActivated?$",	//134
    "linksForIdentifier",	//135
    "linksForIdentifier$",	//136
    "linksForKeyword",	//137
    "linksForKeyword$",	//138
    "metaData",	//139
    "metaData$$",	//140
    "metaObject",	//141
    "metric",	//142
    "minimumSizeHint",	//143
    "mouseDoubleClickEvent",	//144
    "mouseMoveEvent",	//145
    "mousePressEvent",	//146
    "mouseReleaseEvent",	//147
    "moveEvent",	//148
    "namespaceName",	//149
    "namespaceName$",	//150
    "paintEngine",	//151
    "paintEvent",	//152
    "paletteChange",	//153
    "parent",	//154
    "parent#",	//155
    "qt_metacall",	//156
    "qt_metacall$$?",	//157
    "qt_metacast",	//158
    "qt_metacast$",	//159
    "query",	//160
    "queryWidget",	//161
    "registerDocumentation",	//162
    "registerDocumentation$",	//163
    "registeredDocumentations",	//164
    "reindexDocumentation",	//165
    "removeCustomFilter",	//166
    "removeCustomFilter$",	//167
    "removeCustomValue",	//168
    "removeCustomValue$",	//169
    "requestShowLink",	//170
    "requestShowLink#",	//171
    "resizeEvent",	//172
    "resultWidget",	//173
    "row",	//174
    "rowCount",	//175
    "rowCount#",	//176
    "search",	//177
    "search?",	//178
    "searchEngine",	//179
    "searchingFinished",	//180
    "searchingFinished$",	//181
    "searchingStarted",	//182
    "setAutoSaveFilter",	//183
    "setAutoSaveFilter$",	//184
    "setCollectionFile",	//185
    "setCollectionFile$",	//186
    "setCurrentFilter",	//187
    "setCurrentFilter$",	//188
    "setCustomValue",	//189
    "setCustomValue$#",	//190
    "setFieldName",	//191
    "setFieldName$",	//192
    "setQuery",	//193
    "setQuery?",	//194
    "setVisible",	//195
    "setWordList",	//196
    "setWordList?",	//197
    "setupData",	//198
    "setupFinished",	//199
    "setupStarted",	//200
    "showEvent",	//201
    "sizeHint",	//202
    "staticMetaObject",	//203
    "styleChange",	//204
    "tabletEvent",	//205
    "timerEvent",	//206
    "title",	//207
    "tr",	//208
    "tr$",	//209
    "tr$$",	//210
    "tr$$$",	//211
    "trUtf8",	//212
    "trUtf8$",	//213
    "trUtf8$$",	//214
    "trUtf8$$$",	//215
    "unregisterDocumentation",	//216
    "unregisterDocumentation$",	//217
    "url",	//218
    "warning",	//219
    "warning$",	//220
    "wheelEvent",	//221
    "windowActivationChange",	//222
    "wordList",	//223
    "x11Event",	//224
    "~QHelpContentItem",	//225
    "~QHelpContentModel",	//226
    "~QHelpContentWidget",	//227
    "~QHelpEngine",	//228
    "~QHelpEngineCore",	//229
    "~QHelpIndexWidget",	//230
    "~QHelpSearchEngine",	//231
    "~QHelpSearchQuery",	//232
    "~QHelpSearchQueryWidget",	//233
    "~QHelpSearchResultWidget",	//234
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {16, 33, 1, 1, Smoke::mf_const, 13, 1},	//1 QHelpContentItem::child(int) const
    {16, 35, 0, 0, Smoke::mf_const, 157, 2},	//2 QHelpContentItem::childCount() const
    {16, 207, 0, 0, Smoke::mf_const, 51, 3},	//3 QHelpContentItem::title() const
    {16, 218, 0, 0, Smoke::mf_const, 58, 4},	//4 QHelpContentItem::url() const
    {16, 174, 0, 0, Smoke::mf_const, 157, 5},	//5 QHelpContentItem::row() const
    {16, 154, 0, 0, Smoke::mf_const, 13, 6},	//6 QHelpContentItem::parent() const
    {16, 37, 3, 1, Smoke::mf_const, 157, 7},	//7 QHelpContentItem::childPosition(QHelpContentItem*) const
    {16, 9, 5, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 13, 8},	//8 QHelpContentItem::QHelpContentItem(const QHelpContentItem&)
    {16, 225, 0, 0, Smoke::mf_dtor, 0, 9 },	//9 QHelpContentItem::~QHelpContentItem()
    {17, 141, 0, 0, Smoke::mf_const, 144, 1},	//10 QHelpContentModel::metaObject() const
    {17, 158, 7, 1, 0, 159, 2},	//11 QHelpContentModel::qt_metacast(const char*)
    {17, 208, 9, 2, Smoke::mf_static, 51, 3},	//12 QHelpContentModel::tr(const char*, const char*)
    {17, 212, 9, 2, Smoke::mf_static, 51, 4},	//13 QHelpContentModel::trUtf8(const char*, const char*)
    {17, 208, 12, 3, Smoke::mf_static, 51, 5},	//14 QHelpContentModel::tr(const char*, const char*, int)
    {17, 212, 12, 3, Smoke::mf_static, 51, 6},	//15 QHelpContentModel::trUtf8(const char*, const char*, int)
    {17, 156, 16, 3, 0, 157, 7},	//16 QHelpContentModel::qt_metacall(QMetaObject::Call, int, void**)
    {17, 54, 20, 1, 0, 0, 8},	//17 QHelpContentModel::createContents(const QString&)
    {17, 45, 22, 1, Smoke::mf_const, 13, 9},	//18 QHelpContentModel::contentItemAt(const QModelIndex&) const
    {17, 66, 24, 2, Smoke::mf_const, 59, 10},	//19 QHelpContentModel::data(const QModelIndex&, int) const
    {17, 109, 27, 3, Smoke::mf_const, 35, 11},	//20 QHelpContentModel::index(int, int, const QModelIndex&) const
    {17, 154, 22, 1, Smoke::mf_const, 35, 12},	//21 QHelpContentModel::parent(const QModelIndex&) const
    {17, 175, 22, 1, Smoke::mf_const, 157, 13},	//22 QHelpContentModel::rowCount(const QModelIndex&) const
    {17, 42, 22, 1, Smoke::mf_const, 157, 14},	//23 QHelpContentModel::columnCount(const QModelIndex&) const
    {17, 122, 0, 0, Smoke::mf_const, 137, 15},	//24 QHelpContentModel::isCreatingContents() const
    {17, 50, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//25 QHelpContentModel::contentsCreationStarted()
    {17, 49, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//26 QHelpContentModel::contentsCreated()
    {17, 208, 7, 1, Smoke::mf_static, 51, 18},	//27 QHelpContentModel::tr(const char*)
    {17, 212, 7, 1, Smoke::mf_static, 51, 19},	//28 QHelpContentModel::trUtf8(const char*)
    {17, 109, 31, 2, Smoke::mf_const, 35, 20},	//29 QHelpContentModel::index(int, int) const
    {17, 175, 0, 0, Smoke::mf_const, 157, 21},	//30 QHelpContentModel::rowCount() const
    {17, 42, 0, 0, Smoke::mf_const, 157, 22},	//31 QHelpContentModel::columnCount() const
    {17, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 23},	//32 QHelpContentModel::staticMetaObject() const
    {17, 226, 0, 0, Smoke::mf_dtor, 0, 24 },	//33 QHelpContentModel::~QHelpContentModel()
    {18, 141, 0, 0, Smoke::mf_const, 144, 1},	//34 QHelpContentWidget::metaObject() const
    {18, 158, 7, 1, 0, 159, 2},	//35 QHelpContentWidget::qt_metacast(const char*)
    {18, 208, 9, 2, Smoke::mf_static, 51, 3},	//36 QHelpContentWidget::tr(const char*, const char*)
    {18, 212, 9, 2, Smoke::mf_static, 51, 4},	//37 QHelpContentWidget::trUtf8(const char*, const char*)
    {18, 208, 12, 3, Smoke::mf_static, 51, 5},	//38 QHelpContentWidget::tr(const char*, const char*, int)
    {18, 212, 12, 3, Smoke::mf_static, 51, 6},	//39 QHelpContentWidget::trUtf8(const char*, const char*, int)
    {18, 156, 16, 3, 0, 157, 7},	//40 QHelpContentWidget::qt_metacall(QMetaObject::Call, int, void**)
    {18, 115, 34, 1, 0, 35, 8},	//41 QHelpContentWidget::indexOf(const QUrl&)
    {18, 128, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//42 QHelpContentWidget::linkActivated(const QUrl&)
    {18, 208, 7, 1, Smoke::mf_static, 51, 10},	//43 QHelpContentWidget::tr(const char*)
    {18, 212, 7, 1, Smoke::mf_static, 51, 11},	//44 QHelpContentWidget::trUtf8(const char*)
    {18, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 12},	//45 QHelpContentWidget::staticMetaObject() const
    {18, 227, 0, 0, Smoke::mf_dtor, 0, 13 },	//46 QHelpContentWidget::~QHelpContentWidget()
    {19, 141, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 144, 1},	//47 QHelpEngine::metaObject() const
    {19, 158, 7, 1, Smoke::mf_virtual, 159, 2},	//48 QHelpEngine::qt_metacast(const char*)
    {19, 208, 9, 2, Smoke::mf_static, 51, 3},	//49 QHelpEngine::tr(const char*, const char*)
    {19, 212, 9, 2, Smoke::mf_static, 51, 4},	//50 QHelpEngine::trUtf8(const char*, const char*)
    {19, 208, 12, 3, Smoke::mf_static, 51, 5},	//51 QHelpEngine::tr(const char*, const char*, int)
    {19, 212, 12, 3, Smoke::mf_static, 51, 6},	//52 QHelpEngine::trUtf8(const char*, const char*, int)
    {19, 156, 16, 3, Smoke::mf_virtual, 157, 7},	//53 QHelpEngine::qt_metacall(QMetaObject::Call, int, void**)
    {19, 11, 36, 2, Smoke::mf_ctor, 16, 8},	//54 QHelpEngine::QHelpEngine(const QString&, QObject*)
    {19, 47, 0, 0, Smoke::mf_const, 14, 9},	//55 QHelpEngine::contentModel() const
    {19, 114, 0, 0, Smoke::mf_const, 18, 10},	//56 QHelpEngine::indexModel() const
    {19, 48, 0, 0, 0, 15, 11},	//57 QHelpEngine::contentWidget()
    {19, 117, 0, 0, 0, 19, 12},	//58 QHelpEngine::indexWidget()
    {19, 179, 0, 0, 0, 20, 13},	//59 QHelpEngine::searchEngine()
    {19, 208, 7, 1, Smoke::mf_static, 51, 14},	//60 QHelpEngine::tr(const char*)
    {19, 212, 7, 1, Smoke::mf_static, 51, 15},	//61 QHelpEngine::trUtf8(const char*)
    {19, 11, 20, 1, Smoke::mf_ctor, 16, 16},	//62 QHelpEngine::QHelpEngine(const QString&)
    {19, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 17},	//63 QHelpEngine::staticMetaObject() const
    {19, 228, 0, 0, Smoke::mf_dtor, 0, 18 },	//64 QHelpEngine::~QHelpEngine()
    {20, 141, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 144, 1},	//65 QHelpEngineCore::metaObject() const
    {20, 158, 7, 1, Smoke::mf_virtual, 159, 2},	//66 QHelpEngineCore::qt_metacast(const char*)
    {20, 208, 9, 2, Smoke::mf_static, 51, 3},	//67 QHelpEngineCore::tr(const char*, const char*)
    {20, 212, 9, 2, Smoke::mf_static, 51, 4},	//68 QHelpEngineCore::trUtf8(const char*, const char*)
    {20, 208, 12, 3, Smoke::mf_static, 51, 5},	//69 QHelpEngineCore::tr(const char*, const char*, int)
    {20, 212, 12, 3, Smoke::mf_static, 51, 6},	//70 QHelpEngineCore::trUtf8(const char*, const char*, int)
    {20, 156, 16, 3, Smoke::mf_virtual, 157, 7},	//71 QHelpEngineCore::qt_metacall(QMetaObject::Call, int, void**)
    {20, 14, 36, 2, Smoke::mf_ctor, 17, 8},	//72 QHelpEngineCore::QHelpEngineCore(const QString&, QObject*)
    {20, 198, 0, 0, 0, 137, 9},	//73 QHelpEngineCore::setupData()
    {20, 41, 0, 0, Smoke::mf_const|Smoke::mf_property, 51, 10},	//74 QHelpEngineCore::collectionFile() const
    {20, 185, 20, 1, Smoke::mf_property, 0, 11},	//75 QHelpEngineCore::setCollectionFile(const QString&)
    {20, 52, 20, 1, 0, 137, 12},	//76 QHelpEngineCore::copyCollectionFile(const QString&)
    {20, 149, 20, 1, Smoke::mf_static, 51, 13},	//77 QHelpEngineCore::namespaceName(const QString&)
    {20, 162, 20, 1, 0, 137, 14},	//78 QHelpEngineCore::registerDocumentation(const QString&)
    {20, 216, 20, 1, 0, 137, 15},	//79 QHelpEngineCore::unregisterDocumentation(const QString&)
    {20, 70, 20, 1, 0, 51, 16},	//80 QHelpEngineCore::documentationFileName(const QString&)
    {20, 62, 0, 0, Smoke::mf_const, 52, 17},	//81 QHelpEngineCore::customFilters() const
    {20, 166, 20, 1, 0, 137, 18},	//82 QHelpEngineCore::removeCustomFilter(const QString&)
    {20, 28, 39, 2, 0, 137, 19},	//83 QHelpEngineCore::addCustomFilter(const QString&, const QStringList&)
    {20, 93, 0, 0, Smoke::mf_const, 52, 20},	//84 QHelpEngineCore::filterAttributes() const
    {20, 93, 20, 1, Smoke::mf_const, 52, 21},	//85 QHelpEngineCore::filterAttributes(const QString&) const
    {20, 58, 0, 0, Smoke::mf_const|Smoke::mf_property, 51, 22},	//86 QHelpEngineCore::currentFilter() const
    {20, 187, 20, 1, Smoke::mf_property, 0, 23},	//87 QHelpEngineCore::setCurrentFilter(const QString&)
    {20, 164, 0, 0, Smoke::mf_const, 52, 24},	//88 QHelpEngineCore::registeredDocumentations() const
    {20, 91, 20, 1, Smoke::mf_const, 31, 25},	//89 QHelpEngineCore::filterAttributeSets(const QString&) const
    {20, 85, 42, 3, 0, 32, 26},	//90 QHelpEngineCore::files(const QString, const QStringList&, const QString&)
    {20, 98, 34, 1, Smoke::mf_const, 58, 27},	//91 QHelpEngineCore::findFile(const QUrl&) const
    {20, 83, 34, 1, Smoke::mf_const, 3, 28},	//92 QHelpEngineCore::fileData(const QUrl&) const
    {20, 135, 20, 1, Smoke::mf_const, 33, 29},	//93 QHelpEngineCore::linksForIdentifier(const QString&) const
    {20, 168, 20, 1, 0, 137, 30},	//94 QHelpEngineCore::removeCustomValue(const QString&)
    {20, 63, 46, 2, Smoke::mf_const, 59, 31},	//95 QHelpEngineCore::customValue(const QString&, const QVariant&) const
    {20, 189, 46, 2, 0, 137, 32},	//96 QHelpEngineCore::setCustomValue(const QString&, const QVariant&)
    {20, 139, 49, 2, Smoke::mf_static, 59, 33},	//97 QHelpEngineCore::metaData(const QString&, const QString&)
    {20, 78, 0, 0, Smoke::mf_const, 51, 34},	//98 QHelpEngineCore::error() const
    {20, 183, 52, 1, Smoke::mf_property, 0, 35},	//99 QHelpEngineCore::setAutoSaveFilter(bool)
    {20, 30, 0, 0, Smoke::mf_const|Smoke::mf_property, 137, 36},	//100 QHelpEngineCore::autoSaveFilter() const
    {20, 200, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 37},	//101 QHelpEngineCore::setupStarted()
    {20, 199, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 38},	//102 QHelpEngineCore::setupFinished()
    {20, 59, 20, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 39},	//103 QHelpEngineCore::currentFilterChanged(const QString&)
    {20, 219, 20, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//104 QHelpEngineCore::warning(const QString&)
    {20, 208, 7, 1, Smoke::mf_static, 51, 41},	//105 QHelpEngineCore::tr(const char*)
    {20, 212, 7, 1, Smoke::mf_static, 51, 42},	//106 QHelpEngineCore::trUtf8(const char*)
    {20, 14, 20, 1, Smoke::mf_ctor, 17, 43},	//107 QHelpEngineCore::QHelpEngineCore(const QString&)
    {20, 85, 54, 2, 0, 32, 44},	//108 QHelpEngineCore::files(const QString, const QStringList&)
    {20, 63, 20, 1, Smoke::mf_const, 59, 45},	//109 QHelpEngineCore::customValue(const QString&) const
    {20, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 46},	//110 QHelpEngineCore::staticMetaObject() const
    {20, 229, 0, 0, Smoke::mf_dtor, 0, 47 },	//111 QHelpEngineCore::~QHelpEngineCore()
    {21, 141, 0, 0, Smoke::mf_const, 144, 1},	//112 QHelpIndexModel::metaObject() const
    {21, 158, 7, 1, 0, 159, 2},	//113 QHelpIndexModel::qt_metacast(const char*)
    {21, 208, 9, 2, Smoke::mf_static, 51, 3},	//114 QHelpIndexModel::tr(const char*, const char*)
    {21, 212, 9, 2, Smoke::mf_static, 51, 4},	//115 QHelpIndexModel::trUtf8(const char*, const char*)
    {21, 208, 12, 3, Smoke::mf_static, 51, 5},	//116 QHelpIndexModel::tr(const char*, const char*, int)
    {21, 212, 12, 3, Smoke::mf_static, 51, 6},	//117 QHelpIndexModel::trUtf8(const char*, const char*, int)
    {21, 156, 16, 3, 0, 157, 7},	//118 QHelpIndexModel::qt_metacall(QMetaObject::Call, int, void**)
    {21, 56, 20, 1, 0, 0, 8},	//119 QHelpIndexModel::createIndex(const QString&)
    {21, 88, 49, 2, 0, 35, 9},	//120 QHelpIndexModel::filter(const QString&, const QString&)
    {21, 137, 20, 1, Smoke::mf_const, 33, 10},	//121 QHelpIndexModel::linksForKeyword(const QString&) const
    {21, 123, 0, 0, Smoke::mf_const, 137, 11},	//122 QHelpIndexModel::isCreatingIndex() const
    {21, 113, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//123 QHelpIndexModel::indexCreationStarted()
    {21, 112, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//124 QHelpIndexModel::indexCreated()
    {21, 208, 7, 1, Smoke::mf_static, 51, 14},	//125 QHelpIndexModel::tr(const char*)
    {21, 212, 7, 1, Smoke::mf_static, 51, 15},	//126 QHelpIndexModel::trUtf8(const char*)
    {21, 88, 20, 1, 0, 35, 16},	//127 QHelpIndexModel::filter(const QString&)
    {21, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 17},	//128 QHelpIndexModel::staticMetaObject() const
    {22, 141, 0, 0, Smoke::mf_const, 144, 1},	//129 QHelpIndexWidget::metaObject() const
    {22, 158, 7, 1, 0, 159, 2},	//130 QHelpIndexWidget::qt_metacast(const char*)
    {22, 208, 9, 2, Smoke::mf_static, 51, 3},	//131 QHelpIndexWidget::tr(const char*, const char*)
    {22, 212, 9, 2, Smoke::mf_static, 51, 4},	//132 QHelpIndexWidget::trUtf8(const char*, const char*)
    {22, 208, 12, 3, Smoke::mf_static, 51, 5},	//133 QHelpIndexWidget::tr(const char*, const char*, int)
    {22, 212, 12, 3, Smoke::mf_static, 51, 6},	//134 QHelpIndexWidget::trUtf8(const char*, const char*, int)
    {22, 156, 16, 3, 0, 157, 7},	//135 QHelpIndexWidget::qt_metacall(QMetaObject::Call, int, void**)
    {22, 128, 57, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 8},	//136 QHelpIndexWidget::linkActivated(const QUrl&, const QString&)
    {22, 133, 60, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//137 QHelpIndexWidget::linksActivated(const QMap<QString,QUrl>&, const QString&)
    {22, 95, 49, 2, Smoke::mf_slot, 0, 10},	//138 QHelpIndexWidget::filterIndices(const QString&, const QString&)
    {22, 27, 0, 0, Smoke::mf_slot, 0, 11},	//139 QHelpIndexWidget::activateCurrentItem()
    {22, 208, 7, 1, Smoke::mf_static, 51, 12},	//140 QHelpIndexWidget::tr(const char*)
    {22, 212, 7, 1, Smoke::mf_static, 51, 13},	//141 QHelpIndexWidget::trUtf8(const char*)
    {22, 95, 20, 1, Smoke::mf_slot, 0, 14},	//142 QHelpIndexWidget::filterIndices(const QString&)
    {22, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 15},	//143 QHelpIndexWidget::staticMetaObject() const
    {22, 230, 0, 0, Smoke::mf_dtor, 0, 16 },	//144 QHelpIndexWidget::~QHelpIndexWidget()
    {23, 141, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 144, 1},	//145 QHelpSearchEngine::metaObject() const
    {23, 158, 7, 1, Smoke::mf_virtual, 159, 2},	//146 QHelpSearchEngine::qt_metacast(const char*)
    {23, 208, 9, 2, Smoke::mf_static, 51, 3},	//147 QHelpSearchEngine::tr(const char*, const char*)
    {23, 212, 9, 2, Smoke::mf_static, 51, 4},	//148 QHelpSearchEngine::trUtf8(const char*, const char*)
    {23, 208, 12, 3, Smoke::mf_static, 51, 5},	//149 QHelpSearchEngine::tr(const char*, const char*, int)
    {23, 212, 12, 3, Smoke::mf_static, 51, 6},	//150 QHelpSearchEngine::trUtf8(const char*, const char*, int)
    {23, 156, 16, 3, Smoke::mf_virtual, 157, 7},	//151 QHelpSearchEngine::qt_metacall(QMetaObject::Call, int, void**)
    {23, 17, 63, 2, Smoke::mf_ctor, 20, 8},	//152 QHelpSearchEngine::QHelpSearchEngine(QHelpEngineCore*, QObject*)
    {23, 161, 0, 0, 0, 24, 9},	//153 QHelpSearchEngine::queryWidget()
    {23, 173, 0, 0, 0, 25, 10},	//154 QHelpSearchEngine::resultWidget()
    {23, 108, 0, 0, Smoke::mf_const, 157, 11},	//155 QHelpSearchEngine::hitsCount() const
    {23, 105, 0, 0, Smoke::mf_const, 157, 12},	//156 QHelpSearchEngine::hitCount() const
    {23, 106, 31, 2, Smoke::mf_const, 30, 13},	//157 QHelpSearchEngine::hits(int, int) const
    {23, 160, 0, 0, Smoke::mf_const, 29, 14},	//158 QHelpSearchEngine::query() const
    {23, 165, 0, 0, Smoke::mf_slot, 0, 15},	//159 QHelpSearchEngine::reindexDocumentation()
    {23, 31, 0, 0, Smoke::mf_slot, 0, 16},	//160 QHelpSearchEngine::cancelIndexing()
    {23, 177, 66, 1, Smoke::mf_slot, 0, 17},	//161 QHelpSearchEngine::search(const QList<QHelpSearchQuery>&)
    {23, 32, 0, 0, Smoke::mf_slot, 0, 18},	//162 QHelpSearchEngine::cancelSearching()
    {23, 119, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//163 QHelpSearchEngine::indexingStarted()
    {23, 118, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//164 QHelpSearchEngine::indexingFinished()
    {23, 182, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//165 QHelpSearchEngine::searchingStarted()
    {23, 180, 1, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//166 QHelpSearchEngine::searchingFinished(int)
    {23, 208, 7, 1, Smoke::mf_static, 51, 23},	//167 QHelpSearchEngine::tr(const char*)
    {23, 212, 7, 1, Smoke::mf_static, 51, 24},	//168 QHelpSearchEngine::trUtf8(const char*)
    {23, 17, 68, 1, Smoke::mf_ctor, 20, 25},	//169 QHelpSearchEngine::QHelpSearchEngine(QHelpEngineCore*)
    {23, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 26},	//170 QHelpSearchEngine::staticMetaObject() const
    {23, 231, 0, 0, Smoke::mf_dtor, 0, 27 },	//171 QHelpSearchEngine::~QHelpSearchEngine()
    {24, 20, 0, 0, Smoke::mf_ctor, 22, 1},	//172 QHelpSearchQuery::QHelpSearchQuery()
    {24, 20, 70, 2, Smoke::mf_ctor, 22, 2},	//173 QHelpSearchQuery::QHelpSearchQuery(QHelpSearchQuery::FieldName, const QStringList&)
    {24, 20, 73, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 22, 3},	//174 QHelpSearchQuery::QHelpSearchQuery(const QHelpSearchQuery&)
    {24, 82, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 23, 4},	//175 QHelpSearchQuery::fieldName() const
    {24, 191, 75, 1, Smoke::mf_attribute, 0, 5},	//176 QHelpSearchQuery::setFieldName(QHelpSearchQuery::FieldName)
    {24, 223, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 53, 6},	//177 QHelpSearchQuery::wordList() const
    {24, 196, 77, 1, Smoke::mf_attribute, 0, 7},	//178 QHelpSearchQuery::setWordList(const QStringList&)
    {24, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 8},	//179 QHelpSearchQuery::DEFAULT (enum)
    {24, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 9},	//180 QHelpSearchQuery::FUZZY (enum)
    {24, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 10},	//181 QHelpSearchQuery::WITHOUT (enum)
    {24, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 11},	//182 QHelpSearchQuery::PHRASE (enum)
    {24, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 12},	//183 QHelpSearchQuery::ALL (enum)
    {24, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 13},	//184 QHelpSearchQuery::ATLEAST (enum)
    {24, 232, 0, 0, Smoke::mf_dtor, 0, 14 },	//185 QHelpSearchQuery::~QHelpSearchQuery()
    {25, 141, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 144, 1},	//186 QHelpSearchQueryWidget::metaObject() const
    {25, 158, 7, 1, Smoke::mf_virtual, 159, 2},	//187 QHelpSearchQueryWidget::qt_metacast(const char*)
    {25, 208, 9, 2, Smoke::mf_static, 51, 3},	//188 QHelpSearchQueryWidget::tr(const char*, const char*)
    {25, 212, 9, 2, Smoke::mf_static, 51, 4},	//189 QHelpSearchQueryWidget::trUtf8(const char*, const char*)
    {25, 208, 12, 3, Smoke::mf_static, 51, 5},	//190 QHelpSearchQueryWidget::tr(const char*, const char*, int)
    {25, 212, 12, 3, Smoke::mf_static, 51, 6},	//191 QHelpSearchQueryWidget::trUtf8(const char*, const char*, int)
    {25, 156, 16, 3, Smoke::mf_virtual, 157, 7},	//192 QHelpSearchQueryWidget::qt_metacall(QMetaObject::Call, int, void**)
    {25, 23, 79, 1, Smoke::mf_ctor, 24, 8},	//193 QHelpSearchQueryWidget::QHelpSearchQueryWidget(QWidget*)
    {25, 81, 0, 0, 0, 0, 9},	//194 QHelpSearchQueryWidget::expandExtendedSearch()
    {25, 40, 0, 0, 0, 0, 10},	//195 QHelpSearchQueryWidget::collapseExtendedSearch()
    {25, 160, 0, 0, Smoke::mf_const, 29, 11},	//196 QHelpSearchQueryWidget::query() const
    {25, 193, 66, 1, 0, 0, 12},	//197 QHelpSearchQueryWidget::setQuery(const QList<QHelpSearchQuery>&)
    {25, 177, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//198 QHelpSearchQueryWidget::search()
    {25, 208, 7, 1, Smoke::mf_static, 51, 14},	//199 QHelpSearchQueryWidget::tr(const char*)
    {25, 212, 7, 1, Smoke::mf_static, 51, 15},	//200 QHelpSearchQueryWidget::trUtf8(const char*)
    {25, 23, 0, 0, Smoke::mf_ctor, 24, 16},	//201 QHelpSearchQueryWidget::QHelpSearchQueryWidget()
    {25, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 17},	//202 QHelpSearchQueryWidget::staticMetaObject() const
    {25, 233, 0, 0, Smoke::mf_dtor, 0, 18 },	//203 QHelpSearchQueryWidget::~QHelpSearchQueryWidget()
    {26, 141, 0, 0, Smoke::mf_const, 144, 1},	//204 QHelpSearchResultWidget::metaObject() const
    {26, 158, 7, 1, 0, 159, 2},	//205 QHelpSearchResultWidget::qt_metacast(const char*)
    {26, 208, 9, 2, Smoke::mf_static, 51, 3},	//206 QHelpSearchResultWidget::tr(const char*, const char*)
    {26, 212, 9, 2, Smoke::mf_static, 51, 4},	//207 QHelpSearchResultWidget::trUtf8(const char*, const char*)
    {26, 208, 12, 3, Smoke::mf_static, 51, 5},	//208 QHelpSearchResultWidget::tr(const char*, const char*, int)
    {26, 212, 12, 3, Smoke::mf_static, 51, 6},	//209 QHelpSearchResultWidget::trUtf8(const char*, const char*, int)
    {26, 156, 16, 3, 0, 157, 7},	//210 QHelpSearchResultWidget::qt_metacall(QMetaObject::Call, int, void**)
    {26, 131, 81, 1, 0, 58, 8},	//211 QHelpSearchResultWidget::linkAt(const QPoint&)
    {26, 170, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//212 QHelpSearchResultWidget::requestShowLink(const QUrl&)
    {26, 208, 7, 1, Smoke::mf_static, 51, 10},	//213 QHelpSearchResultWidget::tr(const char*)
    {26, 212, 7, 1, Smoke::mf_static, 51, 11},	//214 QHelpSearchResultWidget::trUtf8(const char*)
    {26, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 143, 12},	//215 QHelpSearchResultWidget::staticMetaObject() const
    {26, 234, 0, 0, Smoke::mf_dtor, 0, 13 },	//216 QHelpSearchResultWidget::~QHelpSearchResultWidget()
    {35, 79, 83, 1, Smoke::mf_virtual, 137, 0},	//217 QObject::event(QEvent*)
    {35, 80, 85, 2, Smoke::mf_virtual, 137, 0},	//218 QObject::eventFilter(QObject*, QEvent*)
    {35, 206, 88, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//219 QObject::timerEvent(QTimerEvent*)
    {35, 36, 90, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//220 QObject::childEvent(QChildEvent*)
    {35, 61, 83, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//221 QObject::customEvent(QEvent*)
    {35, 44, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//222 QObject::connectNotify(const char*)
    {35, 69, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//223 QObject::disconnectNotify(const char*)
    {52, 68, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 157, 0},	//224 QWidget::devType() const
    {52, 195, 52, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//225 QWidget::setVisible(bool)
    {52, 202, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 46, 0},	//226 QWidget::sizeHint() const
    {52, 143, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 46, 0},	//227 QWidget::minimumSizeHint() const
    {52, 103, 1, 1, Smoke::mf_const|Smoke::mf_virtual, 157, 0},	//228 QWidget::heightForWidth(int) const
    {52, 151, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 40, 0},	//229 QWidget::paintEngine() const
    {52, 79, 83, 1, Smoke::mf_protected|Smoke::mf_virtual, 137, 0},	//230 QWidget::event(QEvent*)
    {52, 146, 92, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//231 QWidget::mousePressEvent(QMouseEvent*)
    {52, 147, 92, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//232 QWidget::mouseReleaseEvent(QMouseEvent*)
    {52, 144, 92, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//233 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {52, 145, 92, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//234 QWidget::mouseMoveEvent(QMouseEvent*)
    {52, 221, 94, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//235 QWidget::wheelEvent(QWheelEvent*)
    {52, 124, 96, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//236 QWidget::keyPressEvent(QKeyEvent*)
    {52, 125, 96, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//237 QWidget::keyReleaseEvent(QKeyEvent*)
    {52, 101, 98, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//238 QWidget::focusOutEvent(QFocusEvent*)
    {52, 77, 83, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//239 QWidget::enterEvent(QEvent*)
    {52, 127, 83, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//240 QWidget::leaveEvent(QEvent*)
    {52, 152, 100, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//241 QWidget::paintEvent(QPaintEvent*)
    {52, 148, 102, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//242 QWidget::moveEvent(QMoveEvent*)
    {52, 172, 104, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//243 QWidget::resizeEvent(QResizeEvent*)
    {52, 39, 106, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//244 QWidget::closeEvent(QCloseEvent*)
    {52, 51, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//245 QWidget::contextMenuEvent(QContextMenuEvent*)
    {52, 205, 110, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//246 QWidget::tabletEvent(QTabletEvent*)
    {52, 26, 112, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//247 QWidget::actionEvent(QActionEvent*)
    {52, 72, 114, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//248 QWidget::dragEnterEvent(QDragEnterEvent*)
    {52, 74, 116, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//249 QWidget::dragMoveEvent(QDragMoveEvent*)
    {52, 73, 118, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//250 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {52, 75, 120, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//251 QWidget::dropEvent(QDropEvent*)
    {52, 201, 122, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//252 QWidget::showEvent(QShowEvent*)
    {52, 104, 124, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//253 QWidget::hideEvent(QHideEvent*)
    {52, 224, 126, 1, Smoke::mf_protected|Smoke::mf_virtual, 137, 0},	//254 QWidget::x11Event(_XEvent*)
    {52, 142, 128, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 157, 0},	//255 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {52, 120, 130, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//256 QWidget::inputMethodEvent(QInputMethodEvent*)
    {52, 121, 132, 1, Smoke::mf_const|Smoke::mf_virtual, 59, 0},	//257 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {52, 100, 52, 1, Smoke::mf_protected|Smoke::mf_virtual, 137, 0},	//258 QWidget::focusNextPrevChild(bool)
    {52, 204, 134, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//259 QWidget::styleChange(QStyle&)
    {52, 76, 52, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//260 QWidget::enabledChange(bool)
    {52, 153, 136, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//261 QWidget::paletteChange(const QPalette&)
    {52, 102, 138, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//262 QWidget::fontChange(const QFont&)
    {52, 222, 52, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//263 QWidget::windowActivationChange(bool)
    {52, 126, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//264 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {16, 10, 8},	// QHelpContentItem::QHelpContentItem#
    {16, 34, 1},	// QHelpContentItem::child$
    {16, 35, 2},	// QHelpContentItem::childCount
    {16, 38, 7},	// QHelpContentItem::childPosition#
    {16, 154, 6},	// QHelpContentItem::parent
    {16, 174, 5},	// QHelpContentItem::row
    {16, 207, 3},	// QHelpContentItem::title
    {16, 218, 4},	// QHelpContentItem::url
    {16, 225, 9},	// QHelpContentItem::~QHelpContentItem
    {17, 42, 31},	// QHelpContentModel::columnCount
    {17, 43, 23},	// QHelpContentModel::columnCount#
    {17, 46, 18},	// QHelpContentModel::contentItemAt#
    {17, 49, 26},	// QHelpContentModel::contentsCreated
    {17, 50, 25},	// QHelpContentModel::contentsCreationStarted
    {17, 55, 17},	// QHelpContentModel::createContents$
    {17, 67, 19},	// QHelpContentModel::data#$
    {17, 110, 29},	// QHelpContentModel::index$$
    {17, 111, 20},	// QHelpContentModel::index$$#
    {17, 122, 24},	// QHelpContentModel::isCreatingContents
    {17, 141, 10},	// QHelpContentModel::metaObject
    {17, 155, 21},	// QHelpContentModel::parent#
    {17, 157, 16},	// QHelpContentModel::qt_metacall$$?
    {17, 159, 11},	// QHelpContentModel::qt_metacast$
    {17, 175, 30},	// QHelpContentModel::rowCount
    {17, 176, 22},	// QHelpContentModel::rowCount#
    {17, 203, 32},	// QHelpContentModel::staticMetaObject
    {17, 209, 27},	// QHelpContentModel::tr$
    {17, 210, 12},	// QHelpContentModel::tr$$
    {17, 211, 14},	// QHelpContentModel::tr$$$
    {17, 213, 28},	// QHelpContentModel::trUtf8$
    {17, 214, 13},	// QHelpContentModel::trUtf8$$
    {17, 215, 15},	// QHelpContentModel::trUtf8$$$
    {17, 226, 33},	// QHelpContentModel::~QHelpContentModel
    {18, 116, 41},	// QHelpContentWidget::indexOf#
    {18, 129, 42},	// QHelpContentWidget::linkActivated#
    {18, 141, 34},	// QHelpContentWidget::metaObject
    {18, 157, 40},	// QHelpContentWidget::qt_metacall$$?
    {18, 159, 35},	// QHelpContentWidget::qt_metacast$
    {18, 203, 45},	// QHelpContentWidget::staticMetaObject
    {18, 209, 43},	// QHelpContentWidget::tr$
    {18, 210, 36},	// QHelpContentWidget::tr$$
    {18, 211, 38},	// QHelpContentWidget::tr$$$
    {18, 213, 44},	// QHelpContentWidget::trUtf8$
    {18, 214, 37},	// QHelpContentWidget::trUtf8$$
    {18, 215, 39},	// QHelpContentWidget::trUtf8$$$
    {18, 227, 46},	// QHelpContentWidget::~QHelpContentWidget
    {19, 12, 62},	// QHelpEngine::QHelpEngine$
    {19, 13, 54},	// QHelpEngine::QHelpEngine$#
    {19, 47, 55},	// QHelpEngine::contentModel
    {19, 48, 57},	// QHelpEngine::contentWidget
    {19, 114, 56},	// QHelpEngine::indexModel
    {19, 117, 58},	// QHelpEngine::indexWidget
    {19, 141, 47},	// QHelpEngine::metaObject
    {19, 157, 53},	// QHelpEngine::qt_metacall$$?
    {19, 159, 48},	// QHelpEngine::qt_metacast$
    {19, 179, 59},	// QHelpEngine::searchEngine
    {19, 203, 63},	// QHelpEngine::staticMetaObject
    {19, 209, 60},	// QHelpEngine::tr$
    {19, 210, 49},	// QHelpEngine::tr$$
    {19, 211, 51},	// QHelpEngine::tr$$$
    {19, 213, 61},	// QHelpEngine::trUtf8$
    {19, 214, 50},	// QHelpEngine::trUtf8$$
    {19, 215, 52},	// QHelpEngine::trUtf8$$$
    {19, 228, 64},	// QHelpEngine::~QHelpEngine
    {20, 15, 107},	// QHelpEngineCore::QHelpEngineCore$
    {20, 16, 72},	// QHelpEngineCore::QHelpEngineCore$#
    {20, 29, 83},	// QHelpEngineCore::addCustomFilter$?
    {20, 30, 100},	// QHelpEngineCore::autoSaveFilter
    {20, 41, 74},	// QHelpEngineCore::collectionFile
    {20, 53, 76},	// QHelpEngineCore::copyCollectionFile$
    {20, 58, 86},	// QHelpEngineCore::currentFilter
    {20, 60, 103},	// QHelpEngineCore::currentFilterChanged$
    {20, 62, 81},	// QHelpEngineCore::customFilters
    {20, 64, 109},	// QHelpEngineCore::customValue$
    {20, 65, 95},	// QHelpEngineCore::customValue$#
    {20, 71, 80},	// QHelpEngineCore::documentationFileName$
    {20, 78, 98},	// QHelpEngineCore::error
    {20, 84, 92},	// QHelpEngineCore::fileData#
    {20, 86, 108},	// QHelpEngineCore::files$?
    {20, 87, 90},	// QHelpEngineCore::files$?$
    {20, 92, 89},	// QHelpEngineCore::filterAttributeSets$
    {20, 93, 84},	// QHelpEngineCore::filterAttributes
    {20, 94, 85},	// QHelpEngineCore::filterAttributes$
    {20, 99, 91},	// QHelpEngineCore::findFile#
    {20, 136, 93},	// QHelpEngineCore::linksForIdentifier$
    {20, 140, 97},	// QHelpEngineCore::metaData$$
    {20, 141, 65},	// QHelpEngineCore::metaObject
    {20, 150, 77},	// QHelpEngineCore::namespaceName$
    {20, 157, 71},	// QHelpEngineCore::qt_metacall$$?
    {20, 159, 66},	// QHelpEngineCore::qt_metacast$
    {20, 163, 78},	// QHelpEngineCore::registerDocumentation$
    {20, 164, 88},	// QHelpEngineCore::registeredDocumentations
    {20, 167, 82},	// QHelpEngineCore::removeCustomFilter$
    {20, 169, 94},	// QHelpEngineCore::removeCustomValue$
    {20, 184, 99},	// QHelpEngineCore::setAutoSaveFilter$
    {20, 186, 75},	// QHelpEngineCore::setCollectionFile$
    {20, 188, 87},	// QHelpEngineCore::setCurrentFilter$
    {20, 190, 96},	// QHelpEngineCore::setCustomValue$#
    {20, 198, 73},	// QHelpEngineCore::setupData
    {20, 199, 102},	// QHelpEngineCore::setupFinished
    {20, 200, 101},	// QHelpEngineCore::setupStarted
    {20, 203, 110},	// QHelpEngineCore::staticMetaObject
    {20, 209, 105},	// QHelpEngineCore::tr$
    {20, 210, 67},	// QHelpEngineCore::tr$$
    {20, 211, 69},	// QHelpEngineCore::tr$$$
    {20, 213, 106},	// QHelpEngineCore::trUtf8$
    {20, 214, 68},	// QHelpEngineCore::trUtf8$$
    {20, 215, 70},	// QHelpEngineCore::trUtf8$$$
    {20, 217, 79},	// QHelpEngineCore::unregisterDocumentation$
    {20, 220, 104},	// QHelpEngineCore::warning$
    {20, 229, 111},	// QHelpEngineCore::~QHelpEngineCore
    {21, 57, 119},	// QHelpIndexModel::createIndex$
    {21, 89, 127},	// QHelpIndexModel::filter$
    {21, 90, 120},	// QHelpIndexModel::filter$$
    {21, 112, 124},	// QHelpIndexModel::indexCreated
    {21, 113, 123},	// QHelpIndexModel::indexCreationStarted
    {21, 123, 122},	// QHelpIndexModel::isCreatingIndex
    {21, 138, 121},	// QHelpIndexModel::linksForKeyword$
    {21, 141, 112},	// QHelpIndexModel::metaObject
    {21, 157, 118},	// QHelpIndexModel::qt_metacall$$?
    {21, 159, 113},	// QHelpIndexModel::qt_metacast$
    {21, 203, 128},	// QHelpIndexModel::staticMetaObject
    {21, 209, 125},	// QHelpIndexModel::tr$
    {21, 210, 114},	// QHelpIndexModel::tr$$
    {21, 211, 116},	// QHelpIndexModel::tr$$$
    {21, 213, 126},	// QHelpIndexModel::trUtf8$
    {21, 214, 115},	// QHelpIndexModel::trUtf8$$
    {21, 215, 117},	// QHelpIndexModel::trUtf8$$$
    {22, 27, 139},	// QHelpIndexWidget::activateCurrentItem
    {22, 96, 142},	// QHelpIndexWidget::filterIndices$
    {22, 97, 138},	// QHelpIndexWidget::filterIndices$$
    {22, 130, 136},	// QHelpIndexWidget::linkActivated#$
    {22, 134, 137},	// QHelpIndexWidget::linksActivated?$
    {22, 141, 129},	// QHelpIndexWidget::metaObject
    {22, 157, 135},	// QHelpIndexWidget::qt_metacall$$?
    {22, 159, 130},	// QHelpIndexWidget::qt_metacast$
    {22, 203, 143},	// QHelpIndexWidget::staticMetaObject
    {22, 209, 140},	// QHelpIndexWidget::tr$
    {22, 210, 131},	// QHelpIndexWidget::tr$$
    {22, 211, 133},	// QHelpIndexWidget::tr$$$
    {22, 213, 141},	// QHelpIndexWidget::trUtf8$
    {22, 214, 132},	// QHelpIndexWidget::trUtf8$$
    {22, 215, 134},	// QHelpIndexWidget::trUtf8$$$
    {22, 230, 144},	// QHelpIndexWidget::~QHelpIndexWidget
    {23, 18, 169},	// QHelpSearchEngine::QHelpSearchEngine#
    {23, 19, 152},	// QHelpSearchEngine::QHelpSearchEngine##
    {23, 31, 160},	// QHelpSearchEngine::cancelIndexing
    {23, 32, 162},	// QHelpSearchEngine::cancelSearching
    {23, 105, 156},	// QHelpSearchEngine::hitCount
    {23, 107, 157},	// QHelpSearchEngine::hits$$
    {23, 108, 155},	// QHelpSearchEngine::hitsCount
    {23, 118, 164},	// QHelpSearchEngine::indexingFinished
    {23, 119, 163},	// QHelpSearchEngine::indexingStarted
    {23, 141, 145},	// QHelpSearchEngine::metaObject
    {23, 157, 151},	// QHelpSearchEngine::qt_metacall$$?
    {23, 159, 146},	// QHelpSearchEngine::qt_metacast$
    {23, 160, 158},	// QHelpSearchEngine::query
    {23, 161, 153},	// QHelpSearchEngine::queryWidget
    {23, 165, 159},	// QHelpSearchEngine::reindexDocumentation
    {23, 173, 154},	// QHelpSearchEngine::resultWidget
    {23, 178, 161},	// QHelpSearchEngine::search?
    {23, 181, 166},	// QHelpSearchEngine::searchingFinished$
    {23, 182, 165},	// QHelpSearchEngine::searchingStarted
    {23, 203, 170},	// QHelpSearchEngine::staticMetaObject
    {23, 209, 167},	// QHelpSearchEngine::tr$
    {23, 210, 147},	// QHelpSearchEngine::tr$$
    {23, 211, 149},	// QHelpSearchEngine::tr$$$
    {23, 213, 168},	// QHelpSearchEngine::trUtf8$
    {23, 214, 148},	// QHelpSearchEngine::trUtf8$$
    {23, 215, 150},	// QHelpSearchEngine::trUtf8$$$
    {23, 231, 171},	// QHelpSearchEngine::~QHelpSearchEngine
    {24, 1, 183},	// QHelpSearchQuery::ALL
    {24, 2, 184},	// QHelpSearchQuery::ATLEAST
    {24, 3, 179},	// QHelpSearchQuery::DEFAULT
    {24, 6, 180},	// QHelpSearchQuery::FUZZY
    {24, 8, 182},	// QHelpSearchQuery::PHRASE
    {24, 20, 172},	// QHelpSearchQuery::QHelpSearchQuery
    {24, 21, 174},	// QHelpSearchQuery::QHelpSearchQuery#
    {24, 22, 173},	// QHelpSearchQuery::QHelpSearchQuery$?
    {24, 25, 181},	// QHelpSearchQuery::WITHOUT
    {24, 82, 175},	// QHelpSearchQuery::fieldName
    {24, 192, 176},	// QHelpSearchQuery::setFieldName$
    {24, 197, 178},	// QHelpSearchQuery::setWordList?
    {24, 223, 177},	// QHelpSearchQuery::wordList
    {24, 232, 185},	// QHelpSearchQuery::~QHelpSearchQuery
    {25, 23, 201},	// QHelpSearchQueryWidget::QHelpSearchQueryWidget
    {25, 24, 193},	// QHelpSearchQueryWidget::QHelpSearchQueryWidget#
    {25, 40, 195},	// QHelpSearchQueryWidget::collapseExtendedSearch
    {25, 81, 194},	// QHelpSearchQueryWidget::expandExtendedSearch
    {25, 141, 186},	// QHelpSearchQueryWidget::metaObject
    {25, 157, 192},	// QHelpSearchQueryWidget::qt_metacall$$?
    {25, 159, 187},	// QHelpSearchQueryWidget::qt_metacast$
    {25, 160, 196},	// QHelpSearchQueryWidget::query
    {25, 177, 198},	// QHelpSearchQueryWidget::search
    {25, 194, 197},	// QHelpSearchQueryWidget::setQuery?
    {25, 203, 202},	// QHelpSearchQueryWidget::staticMetaObject
    {25, 209, 199},	// QHelpSearchQueryWidget::tr$
    {25, 210, 188},	// QHelpSearchQueryWidget::tr$$
    {25, 211, 190},	// QHelpSearchQueryWidget::tr$$$
    {25, 213, 200},	// QHelpSearchQueryWidget::trUtf8$
    {25, 214, 189},	// QHelpSearchQueryWidget::trUtf8$$
    {25, 215, 191},	// QHelpSearchQueryWidget::trUtf8$$$
    {25, 233, 203},	// QHelpSearchQueryWidget::~QHelpSearchQueryWidget
    {26, 132, 211},	// QHelpSearchResultWidget::linkAt#
    {26, 141, 204},	// QHelpSearchResultWidget::metaObject
    {26, 157, 210},	// QHelpSearchResultWidget::qt_metacall$$?
    {26, 159, 205},	// QHelpSearchResultWidget::qt_metacast$
    {26, 171, 212},	// QHelpSearchResultWidget::requestShowLink#
    {26, 203, 215},	// QHelpSearchResultWidget::staticMetaObject
    {26, 209, 213},	// QHelpSearchResultWidget::tr$
    {26, 210, 206},	// QHelpSearchResultWidget::tr$$
    {26, 211, 208},	// QHelpSearchResultWidget::tr$$$
    {26, 213, 214},	// QHelpSearchResultWidget::trUtf8$
    {26, 214, 207},	// QHelpSearchResultWidget::trUtf8$$
    {26, 215, 209},	// QHelpSearchResultWidget::trUtf8$$$
    {26, 234, 216},	// QHelpSearchResultWidget::~QHelpSearchResultWidget
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();
SMOKE_IMPORT void init_qtsql_Smoke();

static bool initialized = false;
Smoke *qthelp_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qthelp_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    init_qtsql_Smoke();
    if (initialized) return;
    qthelp_Smoke = new Smoke(
        "qthelp",
        __smokeqthelp::classes, 52,
        __smokeqthelp::methods, 265,
        __smokeqthelp::methodMaps, 217,
        __smokeqthelp::methodNames, 234,
        __smokeqthelp::types, 161,
        __smokeqthelp::inheritanceList,
        __smokeqthelp::argumentList,
        __smokeqthelp::ambiguousMethodList,
        __smokeqthelp::cast );
    initialized = true;
}

void delete_qthelp_Smoke() { delete qthelp_Smoke; }

}
