#include <qtscript_includes.h>

#include <smoke.h>
#include <qtscript_smoke.h>

namespace __smokeqtscript {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QBool
      switch(to) {
        case 1: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 2:   //QChildEvent
      switch(to) {
        case 2: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 3:   //QDateTime
      switch(to) {
        case 3: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 4:   //QEvent
      switch(to) {
        case 4: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 5:   //QFactoryInterface
      switch(to) {
        case 5: return (void*)(QFactoryInterface*)xptr;
        case 22: return (void*)(QScriptExtensionPlugin*)(QFactoryInterface*)xptr;
        case 21: return (void*)(QScriptExtensionInterface*)(QFactoryInterface*)xptr;
        default: return xptr;
      }
    case 7:   //QLatin1String
      switch(to) {
        case 7: return (void*)(QLatin1String*)xptr;
        default: return xptr;
      }
    case 8:   //QMetaObject
      switch(to) {
        case 8: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 9:   //QObject
      switch(to) {
        case 9: return (void*)(QObject*)xptr;
        case 22: return (void*)(QScriptExtensionPlugin*)(QObject*)xptr;
        case 17: return (void*)(QScriptEngine*)(QObject*)xptr;
        default: return xptr;
      }
    case 10:   //QRegExp
      switch(to) {
        case 10: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 11:   //QScriptClass
      switch(to) {
        case 11: return (void*)(QScriptClass*)xptr;
        default: return xptr;
      }
    case 12:   //QScriptClassPrivate
      switch(to) {
        case 12: return (void*)(QScriptClassPrivate*)xptr;
        default: return xptr;
      }
    case 13:   //QScriptClassPropertyIterator
      switch(to) {
        case 13: return (void*)(QScriptClassPropertyIterator*)xptr;
        default: return xptr;
      }
    case 14:   //QScriptClassPropertyIteratorPrivate
      switch(to) {
        case 14: return (void*)(QScriptClassPropertyIteratorPrivate*)xptr;
        default: return xptr;
      }
    case 15:   //QScriptContext
      switch(to) {
        case 15: return (void*)(QScriptContext*)xptr;
        default: return xptr;
      }
    case 16:   //QScriptContextInfo
      switch(to) {
        case 16: return (void*)(QScriptContextInfo*)xptr;
        default: return xptr;
      }
    case 17:   //QScriptEngine
      switch(to) {
        case 9: return (void*)(QObject*)(QScriptEngine*)xptr;
        case 17: return (void*)(QScriptEngine*)xptr;
        default: return xptr;
      }
    case 18:   //QScriptEngineAgent
      switch(to) {
        case 18: return (void*)(QScriptEngineAgent*)xptr;
        default: return xptr;
      }
    case 19:   //QScriptEngineAgentPrivate
      switch(to) {
        case 19: return (void*)(QScriptEngineAgentPrivate*)xptr;
        default: return xptr;
      }
    case 20:   //QScriptEnginePrivate
      switch(to) {
        case 20: return (void*)(QScriptEnginePrivate*)xptr;
        default: return xptr;
      }
    case 21:   //QScriptExtensionInterface
      switch(to) {
        case 5: return (void*)(QFactoryInterface*)(QScriptExtensionInterface*)xptr;
        case 21: return (void*)(QScriptExtensionInterface*)xptr;
        case 22: return (void*)(QScriptExtensionPlugin*)(QScriptExtensionInterface*)xptr;
        default: return xptr;
      }
    case 22:   //QScriptExtensionPlugin
      switch(to) {
        case 9: return (void*)(QObject*)(QScriptExtensionPlugin*)xptr;
        case 21: return (void*)(QScriptExtensionInterface*)(QScriptExtensionPlugin*)xptr;
        case 5: return (void*)(QFactoryInterface*)(QScriptExtensionPlugin*)xptr;
        case 22: return (void*)(QScriptExtensionPlugin*)xptr;
        default: return xptr;
      }
    case 23:   //QScriptProgram
      switch(to) {
        case 23: return (void*)(QScriptProgram*)xptr;
        default: return xptr;
      }
    case 24:   //QScriptString
      switch(to) {
        case 24: return (void*)(QScriptString*)xptr;
        default: return xptr;
      }
    case 25:   //QScriptSyntaxCheckResult
      switch(to) {
        case 25: return (void*)(QScriptSyntaxCheckResult*)xptr;
        default: return xptr;
      }
    case 26:   //QScriptValue
      switch(to) {
        case 26: return (void*)(QScriptValue*)xptr;
        default: return xptr;
      }
    case 27:   //QScriptValueIterator
      switch(to) {
        case 27: return (void*)(QScriptValueIterator*)xptr;
        default: return xptr;
      }
    case 28:   //QScriptable
      switch(to) {
        case 28: return (void*)(QScriptable*)xptr;
        default: return xptr;
      }
    case 29:   //QTimerEvent
      switch(to) {
        case 29: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 30:   //QVariant
      switch(to) {
        case 30: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    9, 0,	// 1: QObject
    5, 0,	// 3: QFactoryInterface
    9, 21, 0,	// 5: QObject, QScriptExtensionInterface
};

// These are the xenum functions for manipulating enum pointers
void xenum_QScriptEngine(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QScriptClass(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QScriptSyntaxCheckResult(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QScriptValue(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QScriptContext(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QScriptEngineAgent(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QScriptContextInfo(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptClass(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptClassPropertyIterator(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptContext(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptContextInfo(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptEngine(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptEngineAgent(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptExtensionInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptExtensionPlugin(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptString(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptSyntaxCheckResult(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptValue(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptValueIterator(Smoke::Index, void*, Smoke::Stack);
void xcall_QScriptable(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QBool", true, 0, 0, 0, 0, 0 },	//1
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//2
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//3
    { "QEvent", true, 0, 0, 0, 0, 0 },	//4
    { "QFactoryInterface", true, 0, 0, 0, 0, 0 },	//5
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//6
    { "QLatin1String", true, 0, 0, 0, 0, 0 },	//7
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//8
    { "QObject", true, 0, 0, 0, 0, 0 },	//9
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//10
    { "QScriptClass", false, 0, xcall_QScriptClass, xenum_QScriptClass, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QScriptClass) },	//11
    { "QScriptClassPrivate", true, 0, 0, 0, 0, 0 },	//12
    { "QScriptClassPropertyIterator", false, 0, xcall_QScriptClassPropertyIterator, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QScriptClassPropertyIterator) },	//13
    { "QScriptClassPropertyIteratorPrivate", true, 0, 0, 0, 0, 0 },	//14
    { "QScriptContext", false, 0, xcall_QScriptContext, xenum_QScriptContext, 0, sizeof(QScriptContext) },	//15
    { "QScriptContextInfo", false, 0, xcall_QScriptContextInfo, xenum_QScriptContextInfo, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QScriptContextInfo) },	//16
    { "QScriptEngine", false, 1, xcall_QScriptEngine, xenum_QScriptEngine, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QScriptEngine) },	//17
    { "QScriptEngineAgent", false, 0, xcall_QScriptEngineAgent, xenum_QScriptEngineAgent, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QScriptEngineAgent) },	//18
    { "QScriptEngineAgentPrivate", true, 0, 0, 0, 0, 0 },	//19
    { "QScriptEnginePrivate", true, 0, 0, 0, 0, 0 },	//20
    { "QScriptExtensionInterface", false, 3, xcall_QScriptExtensionInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QScriptExtensionInterface) },	//21
    { "QScriptExtensionPlugin", false, 5, xcall_QScriptExtensionPlugin, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QScriptExtensionPlugin) },	//22
    { "QScriptProgram", true, 0, 0, 0, 0, 0 },	//23
    { "QScriptString", false, 0, xcall_QScriptString, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QScriptString) },	//24
    { "QScriptSyntaxCheckResult", false, 0, xcall_QScriptSyntaxCheckResult, xenum_QScriptSyntaxCheckResult, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QScriptSyntaxCheckResult) },	//25
    { "QScriptValue", false, 0, xcall_QScriptValue, xenum_QScriptValue, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QScriptValue) },	//26
    { "QScriptValueIterator", false, 0, xcall_QScriptValueIterator, 0, Smoke::cf_constructor, sizeof(QScriptValueIterator) },	//27
    { "QScriptable", false, 0, xcall_QScriptable, 0, Smoke::cf_constructor, sizeof(QScriptable) },	//28
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//29
    { "QVariant", true, 0, 0, 0, 0, 0 },	//30
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QBool", 1, Smoke::t_class|Smoke::tf_stack },	//1
    { "QChildEvent*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "QDateTime", 3, Smoke::t_class|Smoke::tf_stack },	//3
    { "QEvent*", 4, Smoke::t_class|Smoke::tf_ptr },	//4
    { "QFlags<QScriptClass::QueryFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//5
    { "QFlags<QScriptValue::PropertyFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//6
    { "QList<QScriptValue>", 0, Smoke::t_voidp|Smoke::tf_stack },	//7
    { "QMetaObject::Call", 8, Smoke::t_enum|Smoke::tf_stack },	//8
    { "QObject*", 9, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QRegExp", 10, Smoke::t_class|Smoke::tf_stack },	//10
    { "QRegExp&", 10, Smoke::t_class|Smoke::tf_ref },	//11
    { "QScriptClass*", 11, Smoke::t_class|Smoke::tf_ptr },	//12
    { "QScriptClass::Extension", 11, Smoke::t_enum|Smoke::tf_stack },	//13
    { "QScriptClass::QueryFlag", 11, Smoke::t_enum|Smoke::tf_stack },	//14
    { "QScriptClassPrivate&", 12, Smoke::t_class|Smoke::tf_ref },	//15
    { "QScriptClassPropertyIterator*", 13, Smoke::t_class|Smoke::tf_ptr },	//16
    { "QScriptClassPropertyIteratorPrivate&", 14, Smoke::t_class|Smoke::tf_ref },	//17
    { "QScriptContext*", 15, Smoke::t_class|Smoke::tf_ptr },	//18
    { "QScriptContext::Error", 15, Smoke::t_enum|Smoke::tf_stack },	//19
    { "QScriptContext::ExecutionState", 15, Smoke::t_enum|Smoke::tf_stack },	//20
    { "QScriptContextInfo&", 16, Smoke::t_class|Smoke::tf_ref },	//21
    { "QScriptContextInfo*", 16, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QScriptContextInfo::FunctionType", 16, Smoke::t_enum|Smoke::tf_stack },	//23
    { "QScriptEngine*", 17, Smoke::t_class|Smoke::tf_ptr },	//24
    { "QScriptEngine::QObjectWrapOption", 17, Smoke::t_enum|Smoke::tf_stack },	//25
    { "QScriptEngine::ValueOwnership", 17, Smoke::t_enum|Smoke::tf_stack },	//26
    { "QScriptEngineAgent*", 18, Smoke::t_class|Smoke::tf_ptr },	//27
    { "QScriptEngineAgent::Extension", 18, Smoke::t_enum|Smoke::tf_stack },	//28
    { "QScriptEngineAgentPrivate&", 19, Smoke::t_class|Smoke::tf_ref },	//29
    { "QScriptEnginePrivate&", 20, Smoke::t_class|Smoke::tf_ref },	//30
    { "QScriptExtensionInterface*", 21, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QScriptExtensionPlugin*", 22, Smoke::t_class|Smoke::tf_ptr },	//32
    { "QScriptString", 24, Smoke::t_class|Smoke::tf_stack },	//33
    { "QScriptString&", 24, Smoke::t_class|Smoke::tf_ref },	//34
    { "QScriptString*", 24, Smoke::t_class|Smoke::tf_ptr },	//35
    { "QScriptSyntaxCheckResult", 25, Smoke::t_class|Smoke::tf_stack },	//36
    { "QScriptSyntaxCheckResult&", 25, Smoke::t_class|Smoke::tf_ref },	//37
    { "QScriptSyntaxCheckResult*", 25, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QScriptSyntaxCheckResult::State", 25, Smoke::t_enum|Smoke::tf_stack },	//39
    { "QScriptValue", 26, Smoke::t_class|Smoke::tf_stack },	//40
    { "QScriptValue&", 26, Smoke::t_class|Smoke::tf_ref },	//41
    { "QScriptValue(*)(QScriptContext*,QScriptEngine*)", 26, Smoke::t_class|Smoke::tf_stack },	//42
    { "QScriptValue(*)(QScriptContext*,QScriptEngine*,void*)", 26, Smoke::t_class|Smoke::tf_stack },	//43
    { "QScriptValue*", 26, Smoke::t_class|Smoke::tf_ptr },	//44
    { "QScriptValue::PropertyFlag", 26, Smoke::t_enum|Smoke::tf_stack },	//45
    { "QScriptValue::ResolveFlag", 26, Smoke::t_enum|Smoke::tf_stack },	//46
    { "QScriptValue::SpecialValue", 26, Smoke::t_enum|Smoke::tf_stack },	//47
    { "QScriptValueIterator&", 27, Smoke::t_class|Smoke::tf_ref },	//48
    { "QScriptValueIterator*", 27, Smoke::t_class|Smoke::tf_ptr },	//49
    { "QScriptable*", 28, Smoke::t_class|Smoke::tf_ptr },	//50
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//51
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//52
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//53
    { "QTimerEvent*", 29, Smoke::t_class|Smoke::tf_ptr },	//54
    { "QVariant", 30, Smoke::t_class|Smoke::tf_stack },	//55
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//56
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//57
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//58
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//59
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//119
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//120
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//124
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//125
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//126
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//127
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//128
    { "bool*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//129
    { "const QDateTime&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//130
    { "const QFlags<QScriptEngine::QObjectWrapOption>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//131
    { "const QFlags<QScriptValue::PropertyFlag>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//132
    { "const QFlags<QScriptValue::ResolveFlag>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//133
    { "const QLatin1String&", 7, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//134
    { "const QList<QScriptValue>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//135
    { "const QMetaObject&", 8, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//136
    { "const QMetaObject*", 8, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//137
    { "const QRegExp&", 10, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//138
    { "const QScriptContext*", 15, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//139
    { "const QScriptContextInfo&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//140
    { "const QScriptExtensionInterface&", 21, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//141
    { "const QScriptProgram&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//142
    { "const QScriptString&", 24, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//143
    { "const QScriptSyntaxCheckResult&", 25, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//144
    { "const QScriptValue&", 26, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//145
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//146
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//147
    { "const QVariant&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//148
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//149
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//150
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//151
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//152
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//153
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//154
    { "unsigned int*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//155
    { "unsigned short", 0, Smoke::t_ushort|Smoke::tf_stack },	//156
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//157
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//158
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//159
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    9, 149, 145, 145, 0,	//1  QObject*, const char*, const QScriptValue&, const QScriptValue&
    4, 0,	//6  QEvent*
    9, 4, 0,	//8  QObject*, QEvent*
    54, 0,	//11  QTimerEvent*
    2, 0,	//13  QChildEvent*
    149, 0,	//15  const char*
    24, 0,	//17  QScriptEngine*
    145, 143, 5, 155, 0,	//19  const QScriptValue&, const QScriptString&, QFlags<QScriptClass::QueryFlag>, unsigned int*
    145, 143, 154, 0,	//24  const QScriptValue&, const QScriptString&, unsigned int
    41, 143, 154, 145, 0,	//28  QScriptValue&, const QScriptString&, unsigned int, const QScriptValue&
    145, 0,	//33  const QScriptValue&
    13, 0,	//35  QScriptClass::Extension
    13, 148, 0,	//37  QScriptClass::Extension, const QVariant&
    24, 15, 0,	//40  QScriptEngine*, QScriptClassPrivate&
    145, 17, 0,	//43  const QScriptValue&, QScriptClassPropertyIteratorPrivate&
    152, 0,	//46  int
    19, 146, 0,	//48  QScriptContext::Error, const QString&
    146, 0,	//51  const QString&
    139, 0,	//53  const QScriptContext*
    140, 0,	//55  const QScriptContextInfo&
    149, 149, 0,	//57  const char*, const char*
    149, 149, 152, 0,	//60  const char*, const char*, int
    8, 152, 158, 0,	//64  QMetaObject::Call, int, void**
    9, 0,	//68  QObject*
    146, 146, 152, 0,	//70  const QString&, const QString&, int
    142, 0,	//74  const QScriptProgram&
    42, 152, 0,	//76  QScriptValue(*)(QScriptContext*,QScriptEngine*), int
    42, 145, 152, 0,	//79  QScriptValue(*)(QScriptContext*,QScriptEngine*), const QScriptValue&, int
    43, 157, 0,	//83  QScriptValue(*)(QScriptContext*,QScriptEngine*,void*), void*
    148, 0,	//86  const QVariant&
    145, 148, 0,	//88  const QScriptValue&, const QVariant&
    138, 0,	//91  const QRegExp&
    12, 145, 0,	//93  QScriptClass*, const QScriptValue&
    154, 0,	//96  unsigned int
    146, 146, 0,	//98  const QString&, const QString&
    151, 0,	//101  double
    130, 0,	//103  const QDateTime&
    9, 26, 131, 0,	//105  QObject*, QScriptEngine::ValueOwnership, const QFlags<QScriptEngine::QObjectWrapOption>&
    145, 9, 26, 131, 0,	//109  const QScriptValue&, QObject*, QScriptEngine::ValueOwnership, const QFlags<QScriptEngine::QObjectWrapOption>&
    137, 145, 0,	//114  const QMetaObject*, const QScriptValue&
    152, 145, 0,	//117  int, const QScriptValue&
    27, 0,	//120  QScriptEngineAgent*
    153, 0,	//122  long long
    30, 9, 0,	//124  QScriptEnginePrivate&, QObject*
    42, 0,	//127  QScriptValue(*)(QScriptContext*,QScriptEngine*)
    42, 145, 0,	//129  QScriptValue(*)(QScriptContext*,QScriptEngine*), const QScriptValue&
    12, 0,	//132  QScriptClass*
    9, 26, 0,	//134  QObject*, QScriptEngine::ValueOwnership
    145, 9, 0,	//137  const QScriptValue&, QObject*
    145, 9, 26, 0,	//140  const QScriptValue&, QObject*, QScriptEngine::ValueOwnership
    137, 0,	//144  const QMetaObject*
    30, 0,	//146  QScriptEnginePrivate&
    153, 146, 146, 152, 0,	//148  long long, const QString&, const QString&, int
    153, 145, 0,	//153  long long, const QScriptValue&
    153, 152, 152, 0,	//156  long long, int, int
    153, 145, 128, 0,	//160  long long, const QScriptValue&, bool
    28, 0,	//164  QScriptEngineAgent::Extension
    28, 148, 0,	//166  QScriptEngineAgent::Extension, const QVariant&
    29, 24, 0,	//169  QScriptEngineAgentPrivate&, QScriptEngine*
    146, 24, 0,	//172  const QString&, QScriptEngine*
    141, 0,	//175  const QScriptExtensionInterface&
    143, 0,	//177  const QScriptString&
    129, 0,	//179  bool*
    144, 0,	//181  const QScriptSyntaxCheckResult&
    24, 47, 0,	//183  QScriptEngine*, QScriptValue::SpecialValue
    24, 128, 0,	//186  QScriptEngine*, bool
    24, 152, 0,	//189  QScriptEngine*, int
    24, 154, 0,	//192  QScriptEngine*, unsigned int
    24, 151, 0,	//195  QScriptEngine*, double
    24, 146, 0,	//198  QScriptEngine*, const QString&
    47, 0,	//201  QScriptValue::SpecialValue
    128, 0,	//203  bool
    134, 0,	//205  const QLatin1String&
    146, 133, 0,	//207  const QString&, const QFlags<QScriptValue::ResolveFlag>&
    146, 145, 132, 0,	//210  const QString&, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&
    154, 133, 0,	//214  unsigned int, const QFlags<QScriptValue::ResolveFlag>&
    154, 145, 132, 0,	//217  unsigned int, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&
    143, 133, 0,	//221  const QScriptString&, const QFlags<QScriptValue::ResolveFlag>&
    143, 145, 132, 0,	//224  const QScriptString&, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&
    145, 135, 0,	//228  const QScriptValue&, const QList<QScriptValue>&
    145, 145, 0,	//231  const QScriptValue&, const QScriptValue&
    135, 0,	//234  const QList<QScriptValue>&
    146, 145, 0,	//236  const QString&, const QScriptValue&
    154, 145, 0,	//239  unsigned int, const QScriptValue&
    143, 145, 0,	//242  const QScriptString&, const QScriptValue&
    41, 0,	//245  QScriptValue&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AutoCreateDynamicProperties",	//1
    "AutoOwnership",	//2
    "Callable",	//3
    "DebuggerInvocationRequest",	//4
    "Error",	//5
    "ExceptionState",	//6
    "ExcludeChildObjects",	//7
    "ExcludeDeleteLater",	//8
    "ExcludeSlots",	//9
    "ExcludeSuperClassContents",	//10
    "ExcludeSuperClassMethods",	//11
    "ExcludeSuperClassProperties",	//12
    "HandlesReadAccess",	//13
    "HandlesWriteAccess",	//14
    "HasInstance",	//15
    "Intermediate",	//16
    "KeepExistingFlags",	//17
    "NativeFunction",	//18
    "NormalState",	//19
    "NullValue",	//20
    "PreferExistingWrapperObject",	//21
    "PropertyGetter",	//22
    "PropertySetter",	//23
    "QObjectMember",	//24
    "QScriptClass",	//25
    "QScriptClass#",	//26
    "QScriptClass##",	//27
    "QScriptClassPropertyIterator",	//28
    "QScriptClassPropertyIterator#",	//29
    "QScriptClassPropertyIterator##",	//30
    "QScriptContextInfo",	//31
    "QScriptContextInfo#",	//32
    "QScriptEngine",	//33
    "QScriptEngine#",	//34
    "QScriptEngine##",	//35
    "QScriptEngineAgent",	//36
    "QScriptEngineAgent#",	//37
    "QScriptEngineAgent##",	//38
    "QScriptExtensionInterface",	//39
    "QScriptExtensionInterface#",	//40
    "QScriptExtensionPlugin",	//41
    "QScriptExtensionPlugin#",	//42
    "QScriptString",	//43
    "QScriptString#",	//44
    "QScriptSyntaxCheckResult",	//45
    "QScriptSyntaxCheckResult#",	//46
    "QScriptValue",	//47
    "QScriptValue#",	//48
    "QScriptValue#$",	//49
    "QScriptValue$",	//50
    "QScriptValueIterator",	//51
    "QScriptValueIterator#",	//52
    "QScriptable",	//53
    "QtFunction",	//54
    "QtOwnership",	//55
    "QtPropertyFunction",	//56
    "RangeError",	//57
    "ReadOnly",	//58
    "ReferenceError",	//59
    "ResolveFull",	//60
    "ResolveLocal",	//61
    "ResolvePrototype",	//62
    "ResolveScope",	//63
    "ScriptFunction",	//64
    "ScriptOwnership",	//65
    "SkipInEnumeration",	//66
    "SkipMethodsInEnumeration",	//67
    "SyntaxError",	//68
    "TypeError",	//69
    "URIError",	//70
    "UndefinedValue",	//71
    "Undeletable",	//72
    "UnknownError",	//73
    "UserRange",	//74
    "Valid",	//75
    "abortEvaluation",	//76
    "abortEvaluation#",	//77
    "activationObject",	//78
    "agent",	//79
    "argument",	//80
    "argument$",	//81
    "argumentCount",	//82
    "argumentsObject",	//83
    "availableExtensions",	//84
    "backtrace",	//85
    "call",	//86
    "call#",	//87
    "call##",	//88
    "call#?",	//89
    "callee",	//90
    "canEvaluate",	//91
    "canEvaluate$",	//92
    "checkSyntax",	//93
    "checkSyntax$",	//94
    "childEvent",	//95
    "clearExceptions",	//96
    "collectGarbage",	//97
    "columnNumber",	//98
    "connectNotify",	//99
    "construct",	//100
    "construct#",	//101
    "construct?",	//102
    "context",	//103
    "contextPop",	//104
    "contextPush",	//105
    "currentContext",	//106
    "customEvent",	//107
    "data",	//108
    "defaultPrototype",	//109
    "defaultPrototype$",	//110
    "disconnectNotify",	//111
    "engine",	//112
    "equals",	//113
    "equals#",	//114
    "errorColumnNumber",	//115
    "errorLineNumber",	//116
    "errorMessage",	//117
    "evaluate",	//118
    "evaluate#",	//119
    "evaluate$",	//120
    "evaluate$$",	//121
    "evaluate$$$",	//122
    "event",	//123
    "eventFilter",	//124
    "exceptionCatch",	//125
    "exceptionCatch$#",	//126
    "exceptionThrow",	//127
    "exceptionThrow$#$",	//128
    "extension",	//129
    "extension$",	//130
    "extension$#",	//131
    "fileName",	//132
    "flags",	//133
    "functionEndLineNumber",	//134
    "functionEntry",	//135
    "functionEntry$",	//136
    "functionExit",	//137
    "functionExit$#",	//138
    "functionMetaIndex",	//139
    "functionName",	//140
    "functionParameterNames",	//141
    "functionStartLineNumber",	//142
    "functionType",	//143
    "globalObject",	//144
    "hasNext",	//145
    "hasPrevious",	//146
    "hasUncaughtException",	//147
    "id",	//148
    "importExtension",	//149
    "importExtension$",	//150
    "importedExtensions",	//151
    "initialize",	//152
    "initialize$#",	//153
    "installTranslatorFunctions",	//154
    "installTranslatorFunctions#",	//155
    "instanceOf",	//156
    "instanceOf#",	//157
    "isArray",	//158
    "isBool",	//159
    "isBoolean",	//160
    "isCalledAsConstructor",	//161
    "isDate",	//162
    "isError",	//163
    "isEvaluating",	//164
    "isFunction",	//165
    "isNull",	//166
    "isNumber",	//167
    "isObject",	//168
    "isQMetaObject",	//169
    "isQObject",	//170
    "isRegExp",	//171
    "isString",	//172
    "isUndefined",	//173
    "isValid",	//174
    "isVariant",	//175
    "keys",	//176
    "lessThan",	//177
    "lessThan#",	//178
    "lineNumber",	//179
    "metaObject",	//180
    "name",	//181
    "newActivationObject",	//182
    "newArray",	//183
    "newArray$",	//184
    "newDate",	//185
    "newDate#",	//186
    "newDate$",	//187
    "newFunction",	//188
    "newFunction#",	//189
    "newFunction##",	//190
    "newFunction##$",	//191
    "newFunction#$",	//192
    "newIterator",	//193
    "newIterator#",	//194
    "newObject",	//195
    "newObject#",	//196
    "newObject##",	//197
    "newQMetaObject",	//198
    "newQMetaObject#",	//199
    "newQMetaObject##",	//200
    "newQObject",	//201
    "newQObject#",	//202
    "newQObject##",	//203
    "newQObject##$",	//204
    "newQObject##$#",	//205
    "newQObject#$",	//206
    "newQObject#$#",	//207
    "newRegExp",	//208
    "newRegExp#",	//209
    "newRegExp$$",	//210
    "newVariant",	//211
    "newVariant#",	//212
    "newVariant##",	//213
    "next",	//214
    "nullValue",	//215
    "object",	//216
    "objectById",	//217
    "objectById$",	//218
    "objectId",	//219
    "operator QString",	//220
    "operator!=",	//221
    "operator!=#",	//222
    "operator=",	//223
    "operator=#",	//224
    "operator==",	//225
    "operator==#",	//226
    "parentContext",	//227
    "popContext",	//228
    "popScope",	//229
    "positionChange",	//230
    "positionChange$$$",	//231
    "previous",	//232
    "processEventsInterval",	//233
    "property",	//234
    "property#",	//235
    "property##",	//236
    "property##$",	//237
    "property$",	//238
    "property$#",	//239
    "propertyFlags",	//240
    "propertyFlags#",	//241
    "propertyFlags##",	//242
    "propertyFlags##$",	//243
    "propertyFlags$",	//244
    "propertyFlags$#",	//245
    "prototype",	//246
    "pushContext",	//247
    "pushScope",	//248
    "pushScope#",	//249
    "qScriptConnect",	//250
    "qScriptConnect#$##",	//251
    "qt_metacall",	//252
    "qt_metacall$$?",	//253
    "qt_metacast",	//254
    "qt_metacast$",	//255
    "queryProperty",	//256
    "queryProperty##$$",	//257
    "remove",	//258
    "reportAdditionalMemoryCost",	//259
    "reportAdditionalMemoryCost$",	//260
    "returnValue",	//261
    "scope",	//262
    "scopeChain",	//263
    "scriptClass",	//264
    "scriptId",	//265
    "scriptLoad",	//266
    "scriptLoad$$$$",	//267
    "scriptName",	//268
    "scriptUnload",	//269
    "scriptUnload$",	//270
    "setActivationObject",	//271
    "setActivationObject#",	//272
    "setAgent",	//273
    "setAgent#",	//274
    "setData",	//275
    "setData#",	//276
    "setDefaultPrototype",	//277
    "setDefaultPrototype$#",	//278
    "setGlobalObject",	//279
    "setGlobalObject#",	//280
    "setProcessEventsInterval",	//281
    "setProcessEventsInterval$",	//282
    "setProperty",	//283
    "setProperty##",	//284
    "setProperty###",	//285
    "setProperty##$#",	//286
    "setProperty$#",	//287
    "setProperty$##",	//288
    "setPrototype",	//289
    "setPrototype#",	//290
    "setReturnValue",	//291
    "setReturnValue#",	//292
    "setScope",	//293
    "setScope#",	//294
    "setScriptClass",	//295
    "setScriptClass#",	//296
    "setThisObject",	//297
    "setThisObject#",	//298
    "setValue",	//299
    "setValue#",	//300
    "setupPackage",	//301
    "setupPackage$#",	//302
    "signalHandlerException",	//303
    "signalHandlerException#",	//304
    "state",	//305
    "staticMetaObject",	//306
    "strictlyEquals",	//307
    "strictlyEquals#",	//308
    "supportsExtension",	//309
    "supportsExtension$",	//310
    "thisObject",	//311
    "throwError",	//312
    "throwError$",	//313
    "throwError$$",	//314
    "throwValue",	//315
    "throwValue#",	//316
    "timerEvent",	//317
    "toArrayIndex",	//318
    "toArrayIndex$",	//319
    "toBack",	//320
    "toBool",	//321
    "toBoolean",	//322
    "toDateTime",	//323
    "toFront",	//324
    "toInt32",	//325
    "toInteger",	//326
    "toNumber",	//327
    "toObject",	//328
    "toObject#",	//329
    "toQMetaObject",	//330
    "toQObject",	//331
    "toRegExp",	//332
    "toString",	//333
    "toStringHandle",	//334
    "toStringHandle$",	//335
    "toUInt16",	//336
    "toUInt32",	//337
    "toVariant",	//338
    "tr",	//339
    "tr$",	//340
    "tr$$",	//341
    "tr$$$",	//342
    "trUtf8",	//343
    "trUtf8$",	//344
    "trUtf8$$",	//345
    "trUtf8$$$",	//346
    "uncaughtException",	//347
    "uncaughtExceptionBacktrace",	//348
    "uncaughtExceptionLineNumber",	//349
    "undefinedValue",	//350
    "value",	//351
    "~QScriptClass",	//352
    "~QScriptClassPropertyIterator",	//353
    "~QScriptContext",	//354
    "~QScriptContextInfo",	//355
    "~QScriptEngine",	//356
    "~QScriptEngineAgent",	//357
    "~QScriptExtensionInterface",	//358
    "~QScriptExtensionPlugin",	//359
    "~QScriptString",	//360
    "~QScriptSyntaxCheckResult",	//361
    "~QScriptValue",	//362
    "~QScriptValueIterator",	//363
    "~QScriptable",	//364
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {5, 176, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 52, 0},	//1 QFactoryInterface::keys() const [pure virtual]
    {6, 250, 1, 4, Smoke::mf_static, 128, 1},	//2 QGlobalSpace::qScriptConnect(QObject*, const char*, const QScriptValue&, const QScriptValue&)
    {9, 123, 6, 1, Smoke::mf_virtual, 128, 0},	//3 QObject::event(QEvent*)
    {9, 124, 8, 2, Smoke::mf_virtual, 128, 0},	//4 QObject::eventFilter(QObject*, QEvent*)
    {9, 317, 11, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//5 QObject::timerEvent(QTimerEvent*)
    {9, 95, 13, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 QObject::childEvent(QChildEvent*)
    {9, 107, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 QObject::customEvent(QEvent*)
    {9, 99, 15, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//8 QObject::connectNotify(const char*)
    {9, 111, 15, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//9 QObject::disconnectNotify(const char*)
    {11, 25, 17, 1, Smoke::mf_ctor, 12, 1},	//10 QScriptClass::QScriptClass(QScriptEngine*)
    {11, 112, 0, 0, Smoke::mf_const, 24, 2},	//11 QScriptClass::engine() const
    {11, 256, 19, 4, Smoke::mf_virtual, 5, 3},	//12 QScriptClass::queryProperty(const QScriptValue&, const QScriptString&, QFlags<QScriptClass::QueryFlag>, unsigned int*)
    {11, 234, 24, 3, Smoke::mf_virtual, 40, 4},	//13 QScriptClass::property(const QScriptValue&, const QScriptString&, unsigned int)
    {11, 283, 28, 4, Smoke::mf_virtual, 0, 5},	//14 QScriptClass::setProperty(QScriptValue&, const QScriptString&, unsigned int, const QScriptValue&)
    {11, 240, 24, 3, Smoke::mf_virtual, 6, 6},	//15 QScriptClass::propertyFlags(const QScriptValue&, const QScriptString&, unsigned int)
    {11, 193, 33, 1, Smoke::mf_virtual, 16, 7},	//16 QScriptClass::newIterator(const QScriptValue&)
    {11, 246, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 40, 8},	//17 QScriptClass::prototype() const
    {11, 181, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 51, 9},	//18 QScriptClass::name() const
    {11, 309, 35, 1, Smoke::mf_const|Smoke::mf_virtual, 128, 10},	//19 QScriptClass::supportsExtension(QScriptClass::Extension) const
    {11, 129, 37, 2, Smoke::mf_virtual, 55, 11},	//20 QScriptClass::extension(QScriptClass::Extension, const QVariant&)
    {11, 25, 40, 2, Smoke::mf_ctor|Smoke::mf_protected, 12, 12},	//21 QScriptClass::QScriptClass(QScriptEngine*, QScriptClassPrivate&)
    {11, 129, 35, 1, 0, 55, 13},	//22 QScriptClass::extension(QScriptClass::Extension)
    {11, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 14},	//23 QScriptClass::HandlesReadAccess (enum)
    {11, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 15},	//24 QScriptClass::HandlesWriteAccess (enum)
    {11, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 16},	//25 QScriptClass::Callable (enum)
    {11, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 17},	//26 QScriptClass::HasInstance (enum)
    {11, 352, 0, 0, Smoke::mf_dtor, 0, 18 },	//27 QScriptClass::~QScriptClass()
    {13, 28, 33, 1, Smoke::mf_ctor|Smoke::mf_protected, 16, 1},	//28 QScriptClassPropertyIterator::QScriptClassPropertyIterator(const QScriptValue&)
    {13, 216, 0, 0, Smoke::mf_const, 40, 2},	//29 QScriptClassPropertyIterator::object() const
    {13, 145, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 128, 3},	//30 QScriptClassPropertyIterator::hasNext() const [pure virtual]
    {13, 214, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//31 QScriptClassPropertyIterator::next() [pure virtual]
    {13, 146, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 128, 5},	//32 QScriptClassPropertyIterator::hasPrevious() const [pure virtual]
    {13, 232, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 6},	//33 QScriptClassPropertyIterator::previous() [pure virtual]
    {13, 324, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 7},	//34 QScriptClassPropertyIterator::toFront() [pure virtual]
    {13, 320, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 8},	//35 QScriptClassPropertyIterator::toBack() [pure virtual]
    {13, 181, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 33, 9},	//36 QScriptClassPropertyIterator::name() const [pure virtual]
    {13, 148, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 154, 10},	//37 QScriptClassPropertyIterator::id() const
    {13, 133, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 6, 11},	//38 QScriptClassPropertyIterator::flags() const
    {13, 28, 43, 2, Smoke::mf_ctor|Smoke::mf_protected, 16, 12},	//39 QScriptClassPropertyIterator::QScriptClassPropertyIterator(const QScriptValue&, QScriptClassPropertyIteratorPrivate&)
    {13, 353, 0, 0, Smoke::mf_dtor, 0, 13 },	//40 QScriptClassPropertyIterator::~QScriptClassPropertyIterator()
    {15, 227, 0, 0, Smoke::mf_const, 18, 1},	//41 QScriptContext::parentContext() const
    {15, 112, 0, 0, Smoke::mf_const, 24, 2},	//42 QScriptContext::engine() const
    {15, 305, 0, 0, Smoke::mf_const, 20, 3},	//43 QScriptContext::state() const
    {15, 90, 0, 0, Smoke::mf_const, 40, 4},	//44 QScriptContext::callee() const
    {15, 82, 0, 0, Smoke::mf_const, 152, 5},	//45 QScriptContext::argumentCount() const
    {15, 80, 46, 1, Smoke::mf_const, 40, 6},	//46 QScriptContext::argument(int) const
    {15, 83, 0, 0, Smoke::mf_const, 40, 7},	//47 QScriptContext::argumentsObject() const
    {15, 263, 0, 0, Smoke::mf_const, 7, 8},	//48 QScriptContext::scopeChain() const
    {15, 248, 33, 1, 0, 0, 9},	//49 QScriptContext::pushScope(const QScriptValue&)
    {15, 229, 0, 0, 0, 40, 10},	//50 QScriptContext::popScope()
    {15, 261, 0, 0, Smoke::mf_const, 40, 11},	//51 QScriptContext::returnValue() const
    {15, 291, 33, 1, 0, 0, 12},	//52 QScriptContext::setReturnValue(const QScriptValue&)
    {15, 78, 0, 0, Smoke::mf_const, 40, 13},	//53 QScriptContext::activationObject() const
    {15, 271, 33, 1, 0, 0, 14},	//54 QScriptContext::setActivationObject(const QScriptValue&)
    {15, 311, 0, 0, Smoke::mf_const, 40, 15},	//55 QScriptContext::thisObject() const
    {15, 297, 33, 1, 0, 0, 16},	//56 QScriptContext::setThisObject(const QScriptValue&)
    {15, 161, 0, 0, Smoke::mf_const, 128, 17},	//57 QScriptContext::isCalledAsConstructor() const
    {15, 315, 33, 1, 0, 40, 18},	//58 QScriptContext::throwValue(const QScriptValue&)
    {15, 312, 48, 2, 0, 40, 19},	//59 QScriptContext::throwError(QScriptContext::Error, const QString&)
    {15, 312, 51, 1, 0, 40, 20},	//60 QScriptContext::throwError(const QString&)
    {15, 85, 0, 0, Smoke::mf_const, 52, 21},	//61 QScriptContext::backtrace() const
    {15, 333, 0, 0, Smoke::mf_const, 51, 22},	//62 QScriptContext::toString() const
    {15, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 23},	//63 QScriptContext::NormalState (enum)
    {15, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 24},	//64 QScriptContext::ExceptionState (enum)
    {15, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 25},	//65 QScriptContext::UnknownError (enum)
    {15, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 26},	//66 QScriptContext::ReferenceError (enum)
    {15, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 27},	//67 QScriptContext::SyntaxError (enum)
    {15, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 28},	//68 QScriptContext::TypeError (enum)
    {15, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 29},	//69 QScriptContext::RangeError (enum)
    {15, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 30},	//70 QScriptContext::URIError (enum)
    {15, 354, 0, 0, Smoke::mf_dtor, 0, 31 },	//71 QScriptContext::~QScriptContext()
    {16, 31, 53, 1, Smoke::mf_ctor, 22, 1},	//72 QScriptContextInfo::QScriptContextInfo(const QScriptContext*)
    {16, 31, 55, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 22, 2},	//73 QScriptContextInfo::QScriptContextInfo(const QScriptContextInfo&)
    {16, 31, 0, 0, Smoke::mf_ctor, 22, 3},	//74 QScriptContextInfo::QScriptContextInfo()
    {16, 223, 55, 1, 0, 21, 4},	//75 QScriptContextInfo::operator=(const QScriptContextInfo&)
    {16, 166, 0, 0, Smoke::mf_const, 128, 5},	//76 QScriptContextInfo::isNull() const
    {16, 265, 0, 0, Smoke::mf_const, 153, 6},	//77 QScriptContextInfo::scriptId() const
    {16, 132, 0, 0, Smoke::mf_const, 51, 7},	//78 QScriptContextInfo::fileName() const
    {16, 179, 0, 0, Smoke::mf_const, 152, 8},	//79 QScriptContextInfo::lineNumber() const
    {16, 98, 0, 0, Smoke::mf_const, 152, 9},	//80 QScriptContextInfo::columnNumber() const
    {16, 140, 0, 0, Smoke::mf_const, 51, 10},	//81 QScriptContextInfo::functionName() const
    {16, 143, 0, 0, Smoke::mf_const, 23, 11},	//82 QScriptContextInfo::functionType() const
    {16, 141, 0, 0, Smoke::mf_const, 52, 12},	//83 QScriptContextInfo::functionParameterNames() const
    {16, 142, 0, 0, Smoke::mf_const, 152, 13},	//84 QScriptContextInfo::functionStartLineNumber() const
    {16, 134, 0, 0, Smoke::mf_const, 152, 14},	//85 QScriptContextInfo::functionEndLineNumber() const
    {16, 139, 0, 0, Smoke::mf_const, 152, 15},	//86 QScriptContextInfo::functionMetaIndex() const
    {16, 225, 55, 1, Smoke::mf_const, 128, 16},	//87 QScriptContextInfo::operator==(const QScriptContextInfo&) const
    {16, 221, 55, 1, Smoke::mf_const, 128, 17},	//88 QScriptContextInfo::operator!=(const QScriptContextInfo&) const
    {16, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 18},	//89 QScriptContextInfo::ScriptFunction (enum)
    {16, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 19},	//90 QScriptContextInfo::QtFunction (enum)
    {16, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 20},	//91 QScriptContextInfo::QtPropertyFunction (enum)
    {16, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 23, 21},	//92 QScriptContextInfo::NativeFunction (enum)
    {16, 355, 0, 0, Smoke::mf_dtor, 0, 22 },	//93 QScriptContextInfo::~QScriptContextInfo()
    {17, 180, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 137, 1},	//94 QScriptEngine::metaObject() const
    {17, 254, 15, 1, Smoke::mf_virtual, 157, 2},	//95 QScriptEngine::qt_metacast(const char*)
    {17, 339, 57, 2, Smoke::mf_static, 51, 3},	//96 QScriptEngine::tr(const char*, const char*)
    {17, 343, 57, 2, Smoke::mf_static, 51, 4},	//97 QScriptEngine::trUtf8(const char*, const char*)
    {17, 339, 60, 3, Smoke::mf_static, 51, 5},	//98 QScriptEngine::tr(const char*, const char*, int)
    {17, 343, 60, 3, Smoke::mf_static, 51, 6},	//99 QScriptEngine::trUtf8(const char*, const char*, int)
    {17, 252, 64, 3, Smoke::mf_virtual, 152, 7},	//100 QScriptEngine::qt_metacall(QMetaObject::Call, int, void**)
    {17, 33, 0, 0, Smoke::mf_ctor, 24, 8},	//101 QScriptEngine::QScriptEngine()
    {17, 33, 68, 1, Smoke::mf_ctor, 24, 9},	//102 QScriptEngine::QScriptEngine(QObject*)
    {17, 144, 0, 0, Smoke::mf_const, 40, 10},	//103 QScriptEngine::globalObject() const
    {17, 279, 33, 1, 0, 0, 11},	//104 QScriptEngine::setGlobalObject(const QScriptValue&)
    {17, 106, 0, 0, Smoke::mf_const, 18, 12},	//105 QScriptEngine::currentContext() const
    {17, 247, 0, 0, 0, 18, 13},	//106 QScriptEngine::pushContext()
    {17, 228, 0, 0, 0, 0, 14},	//107 QScriptEngine::popContext()
    {17, 91, 51, 1, Smoke::mf_const, 128, 15},	//108 QScriptEngine::canEvaluate(const QString&) const
    {17, 93, 51, 1, Smoke::mf_static, 36, 16},	//109 QScriptEngine::checkSyntax(const QString&)
    {17, 118, 70, 3, 0, 40, 17},	//110 QScriptEngine::evaluate(const QString&, const QString&, int)
    {17, 118, 74, 1, 0, 40, 18},	//111 QScriptEngine::evaluate(const QScriptProgram&)
    {17, 164, 0, 0, Smoke::mf_const, 128, 19},	//112 QScriptEngine::isEvaluating() const
    {17, 76, 33, 1, 0, 0, 20},	//113 QScriptEngine::abortEvaluation(const QScriptValue&)
    {17, 147, 0, 0, Smoke::mf_const, 128, 21},	//114 QScriptEngine::hasUncaughtException() const
    {17, 347, 0, 0, Smoke::mf_const, 40, 22},	//115 QScriptEngine::uncaughtException() const
    {17, 349, 0, 0, Smoke::mf_const, 152, 23},	//116 QScriptEngine::uncaughtExceptionLineNumber() const
    {17, 348, 0, 0, Smoke::mf_const, 52, 24},	//117 QScriptEngine::uncaughtExceptionBacktrace() const
    {17, 96, 0, 0, 0, 0, 25},	//118 QScriptEngine::clearExceptions()
    {17, 215, 0, 0, 0, 40, 26},	//119 QScriptEngine::nullValue()
    {17, 350, 0, 0, 0, 40, 27},	//120 QScriptEngine::undefinedValue()
    {17, 188, 76, 2, 0, 40, 28},	//121 QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*), int)
    {17, 188, 79, 3, 0, 40, 29},	//122 QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*), const QScriptValue&, int)
    {17, 188, 83, 2, 0, 40, 30},	//123 QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*,void*), void*)
    {17, 211, 86, 1, 0, 40, 31},	//124 QScriptEngine::newVariant(const QVariant&)
    {17, 211, 88, 2, 0, 40, 32},	//125 QScriptEngine::newVariant(const QScriptValue&, const QVariant&)
    {17, 208, 91, 1, 0, 40, 33},	//126 QScriptEngine::newRegExp(const QRegExp&)
    {17, 195, 0, 0, 0, 40, 34},	//127 QScriptEngine::newObject()
    {17, 195, 93, 2, 0, 40, 35},	//128 QScriptEngine::newObject(QScriptClass*, const QScriptValue&)
    {17, 183, 96, 1, 0, 40, 36},	//129 QScriptEngine::newArray(unsigned int)
    {17, 208, 98, 2, 0, 40, 37},	//130 QScriptEngine::newRegExp(const QString&, const QString&)
    {17, 185, 101, 1, 0, 40, 38},	//131 QScriptEngine::newDate(double)
    {17, 185, 103, 1, 0, 40, 39},	//132 QScriptEngine::newDate(const QDateTime&)
    {17, 182, 0, 0, 0, 40, 40},	//133 QScriptEngine::newActivationObject()
    {17, 201, 105, 3, 0, 40, 41},	//134 QScriptEngine::newQObject(QObject*, QScriptEngine::ValueOwnership, const QFlags<QScriptEngine::QObjectWrapOption>&)
    {17, 201, 109, 4, 0, 40, 42},	//135 QScriptEngine::newQObject(const QScriptValue&, QObject*, QScriptEngine::ValueOwnership, const QFlags<QScriptEngine::QObjectWrapOption>&)
    {17, 198, 114, 2, 0, 40, 43},	//136 QScriptEngine::newQMetaObject(const QMetaObject*, const QScriptValue&)
    {17, 109, 46, 1, Smoke::mf_const, 40, 44},	//137 QScriptEngine::defaultPrototype(int) const
    {17, 277, 117, 2, 0, 0, 45},	//138 QScriptEngine::setDefaultPrototype(int, const QScriptValue&)
    {17, 154, 33, 1, 0, 0, 46},	//139 QScriptEngine::installTranslatorFunctions(const QScriptValue&)
    {17, 149, 51, 1, 0, 40, 47},	//140 QScriptEngine::importExtension(const QString&)
    {17, 84, 0, 0, Smoke::mf_const, 52, 48},	//141 QScriptEngine::availableExtensions() const
    {17, 151, 0, 0, Smoke::mf_const, 52, 49},	//142 QScriptEngine::importedExtensions() const
    {17, 97, 0, 0, 0, 0, 50},	//143 QScriptEngine::collectGarbage()
    {17, 259, 46, 1, 0, 0, 51},	//144 QScriptEngine::reportAdditionalMemoryCost(int)
    {17, 281, 46, 1, 0, 0, 52},	//145 QScriptEngine::setProcessEventsInterval(int)
    {17, 233, 0, 0, Smoke::mf_const, 152, 53},	//146 QScriptEngine::processEventsInterval() const
    {17, 273, 120, 1, 0, 0, 54},	//147 QScriptEngine::setAgent(QScriptEngineAgent*)
    {17, 79, 0, 0, Smoke::mf_const, 27, 55},	//148 QScriptEngine::agent() const
    {17, 334, 51, 1, 0, 33, 56},	//149 QScriptEngine::toStringHandle(const QString&)
    {17, 328, 33, 1, 0, 40, 57},	//150 QScriptEngine::toObject(const QScriptValue&)
    {17, 217, 122, 1, Smoke::mf_const, 40, 58},	//151 QScriptEngine::objectById(long long) const
    {17, 303, 33, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 59},	//152 QScriptEngine::signalHandlerException(const QScriptValue&)
    {17, 33, 124, 2, Smoke::mf_ctor|Smoke::mf_protected, 24, 60},	//153 QScriptEngine::QScriptEngine(QScriptEnginePrivate&, QObject*)
    {17, 339, 15, 1, Smoke::mf_static, 51, 61},	//154 QScriptEngine::tr(const char*)
    {17, 343, 15, 1, Smoke::mf_static, 51, 62},	//155 QScriptEngine::trUtf8(const char*)
    {17, 118, 51, 1, 0, 40, 63},	//156 QScriptEngine::evaluate(const QString&)
    {17, 118, 98, 2, 0, 40, 64},	//157 QScriptEngine::evaluate(const QString&, const QString&)
    {17, 76, 0, 0, 0, 0, 65},	//158 QScriptEngine::abortEvaluation()
    {17, 188, 127, 1, 0, 40, 66},	//159 QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*))
    {17, 188, 129, 2, 0, 40, 67},	//160 QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*), const QScriptValue&)
    {17, 195, 132, 1, 0, 40, 68},	//161 QScriptEngine::newObject(QScriptClass*)
    {17, 183, 0, 0, 0, 40, 69},	//162 QScriptEngine::newArray()
    {17, 201, 68, 1, 0, 40, 70},	//163 QScriptEngine::newQObject(QObject*)
    {17, 201, 134, 2, 0, 40, 71},	//164 QScriptEngine::newQObject(QObject*, QScriptEngine::ValueOwnership)
    {17, 201, 137, 2, 0, 40, 72},	//165 QScriptEngine::newQObject(const QScriptValue&, QObject*)
    {17, 201, 140, 3, 0, 40, 73},	//166 QScriptEngine::newQObject(const QScriptValue&, QObject*, QScriptEngine::ValueOwnership)
    {17, 198, 144, 1, 0, 40, 74},	//167 QScriptEngine::newQMetaObject(const QMetaObject*)
    {17, 154, 0, 0, 0, 0, 75},	//168 QScriptEngine::installTranslatorFunctions()
    {17, 33, 146, 1, Smoke::mf_ctor|Smoke::mf_protected, 24, 76},	//169 QScriptEngine::QScriptEngine(QScriptEnginePrivate&)
    {17, 306, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 136, 77},	//170 QScriptEngine::staticMetaObject() const
    {17, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 78},	//171 QScriptEngine::QtOwnership (enum)
    {17, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 79},	//172 QScriptEngine::ScriptOwnership (enum)
    {17, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 80},	//173 QScriptEngine::AutoOwnership (enum)
    {17, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 81},	//174 QScriptEngine::ExcludeChildObjects (enum)
    {17, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 82},	//175 QScriptEngine::ExcludeSuperClassMethods (enum)
    {17, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 83},	//176 QScriptEngine::ExcludeSuperClassProperties (enum)
    {17, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 84},	//177 QScriptEngine::ExcludeSuperClassContents (enum)
    {17, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 85},	//178 QScriptEngine::SkipMethodsInEnumeration (enum)
    {17, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 86},	//179 QScriptEngine::ExcludeDeleteLater (enum)
    {17, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 87},	//180 QScriptEngine::ExcludeSlots (enum)
    {17, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 88},	//181 QScriptEngine::AutoCreateDynamicProperties (enum)
    {17, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 25, 89},	//182 QScriptEngine::PreferExistingWrapperObject (enum)
    {17, 356, 0, 0, Smoke::mf_dtor, 0, 90 },	//183 QScriptEngine::~QScriptEngine()
    {18, 36, 17, 1, Smoke::mf_ctor, 27, 1},	//184 QScriptEngineAgent::QScriptEngineAgent(QScriptEngine*)
    {18, 266, 148, 4, Smoke::mf_virtual, 0, 2},	//185 QScriptEngineAgent::scriptLoad(long long, const QString&, const QString&, int)
    {18, 269, 122, 1, Smoke::mf_virtual, 0, 3},	//186 QScriptEngineAgent::scriptUnload(long long)
    {18, 105, 0, 0, Smoke::mf_virtual, 0, 4},	//187 QScriptEngineAgent::contextPush()
    {18, 104, 0, 0, Smoke::mf_virtual, 0, 5},	//188 QScriptEngineAgent::contextPop()
    {18, 135, 122, 1, Smoke::mf_virtual, 0, 6},	//189 QScriptEngineAgent::functionEntry(long long)
    {18, 137, 153, 2, Smoke::mf_virtual, 0, 7},	//190 QScriptEngineAgent::functionExit(long long, const QScriptValue&)
    {18, 230, 156, 3, Smoke::mf_virtual, 0, 8},	//191 QScriptEngineAgent::positionChange(long long, int, int)
    {18, 127, 160, 3, Smoke::mf_virtual, 0, 9},	//192 QScriptEngineAgent::exceptionThrow(long long, const QScriptValue&, bool)
    {18, 125, 153, 2, Smoke::mf_virtual, 0, 10},	//193 QScriptEngineAgent::exceptionCatch(long long, const QScriptValue&)
    {18, 309, 164, 1, Smoke::mf_const|Smoke::mf_virtual, 128, 11},	//194 QScriptEngineAgent::supportsExtension(QScriptEngineAgent::Extension) const
    {18, 129, 166, 2, Smoke::mf_virtual, 55, 12},	//195 QScriptEngineAgent::extension(QScriptEngineAgent::Extension, const QVariant&)
    {18, 112, 0, 0, Smoke::mf_const, 24, 13},	//196 QScriptEngineAgent::engine() const
    {18, 36, 169, 2, Smoke::mf_ctor|Smoke::mf_protected, 27, 14},	//197 QScriptEngineAgent::QScriptEngineAgent(QScriptEngineAgentPrivate&, QScriptEngine*)
    {18, 129, 164, 1, 0, 55, 15},	//198 QScriptEngineAgent::extension(QScriptEngineAgent::Extension)
    {18, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 28, 16},	//199 QScriptEngineAgent::DebuggerInvocationRequest (enum)
    {18, 357, 0, 0, Smoke::mf_dtor, 0, 17 },	//200 QScriptEngineAgent::~QScriptEngineAgent()
    {21, 152, 172, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//201 QScriptExtensionInterface::initialize(const QString&, QScriptEngine*) [pure virtual]
    {21, 39, 0, 0, Smoke::mf_ctor, 31, 2},	//202 QScriptExtensionInterface::QScriptExtensionInterface()
    {21, 39, 175, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 31, 3},	//203 QScriptExtensionInterface::QScriptExtensionInterface(const QScriptExtensionInterface&)
    {21, 358, 0, 0, Smoke::mf_dtor, 0, 4 },	//204 QScriptExtensionInterface::~QScriptExtensionInterface()
    {22, 180, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 137, 1},	//205 QScriptExtensionPlugin::metaObject() const
    {22, 254, 15, 1, Smoke::mf_virtual, 157, 2},	//206 QScriptExtensionPlugin::qt_metacast(const char*)
    {22, 339, 57, 2, Smoke::mf_static, 51, 3},	//207 QScriptExtensionPlugin::tr(const char*, const char*)
    {22, 343, 57, 2, Smoke::mf_static, 51, 4},	//208 QScriptExtensionPlugin::trUtf8(const char*, const char*)
    {22, 339, 60, 3, Smoke::mf_static, 51, 5},	//209 QScriptExtensionPlugin::tr(const char*, const char*, int)
    {22, 343, 60, 3, Smoke::mf_static, 51, 6},	//210 QScriptExtensionPlugin::trUtf8(const char*, const char*, int)
    {22, 252, 64, 3, Smoke::mf_virtual, 152, 7},	//211 QScriptExtensionPlugin::qt_metacall(QMetaObject::Call, int, void**)
    {22, 41, 68, 1, Smoke::mf_ctor, 32, 8},	//212 QScriptExtensionPlugin::QScriptExtensionPlugin(QObject*)
    {22, 176, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 52, 9},	//213 QScriptExtensionPlugin::keys() const [pure virtual]
    {22, 152, 172, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 10},	//214 QScriptExtensionPlugin::initialize(const QString&, QScriptEngine*) [pure virtual]
    {22, 301, 172, 2, Smoke::mf_const, 40, 11},	//215 QScriptExtensionPlugin::setupPackage(const QString&, QScriptEngine*) const
    {22, 339, 15, 1, Smoke::mf_static, 51, 12},	//216 QScriptExtensionPlugin::tr(const char*)
    {22, 343, 15, 1, Smoke::mf_static, 51, 13},	//217 QScriptExtensionPlugin::trUtf8(const char*)
    {22, 41, 0, 0, Smoke::mf_ctor, 32, 14},	//218 QScriptExtensionPlugin::QScriptExtensionPlugin()
    {22, 306, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 136, 15},	//219 QScriptExtensionPlugin::staticMetaObject() const
    {22, 359, 0, 0, Smoke::mf_dtor, 0, 16 },	//220 QScriptExtensionPlugin::~QScriptExtensionPlugin()
    {24, 43, 0, 0, Smoke::mf_ctor, 35, 1},	//221 QScriptString::QScriptString()
    {24, 43, 177, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 35, 2},	//222 QScriptString::QScriptString(const QScriptString&)
    {24, 223, 177, 1, 0, 34, 3},	//223 QScriptString::operator=(const QScriptString&)
    {24, 174, 0, 0, Smoke::mf_const, 128, 4},	//224 QScriptString::isValid() const
    {24, 225, 177, 1, Smoke::mf_const, 128, 5},	//225 QScriptString::operator==(const QScriptString&) const
    {24, 221, 177, 1, Smoke::mf_const, 128, 6},	//226 QScriptString::operator!=(const QScriptString&) const
    {24, 318, 179, 1, Smoke::mf_const, 154, 7},	//227 QScriptString::toArrayIndex(bool*) const
    {24, 333, 0, 0, Smoke::mf_const, 51, 8},	//228 QScriptString::toString() const
    {24, 220, 0, 0, Smoke::mf_const, 51, 9},	//229 QScriptString::operator QString() const
    {24, 318, 0, 0, Smoke::mf_const, 154, 10},	//230 QScriptString::toArrayIndex() const
    {24, 360, 0, 0, Smoke::mf_dtor, 0, 11 },	//231 QScriptString::~QScriptString()
    {25, 45, 181, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 38, 1},	//232 QScriptSyntaxCheckResult::QScriptSyntaxCheckResult(const QScriptSyntaxCheckResult&)
    {25, 305, 0, 0, Smoke::mf_const, 39, 2},	//233 QScriptSyntaxCheckResult::state() const
    {25, 116, 0, 0, Smoke::mf_const, 152, 3},	//234 QScriptSyntaxCheckResult::errorLineNumber() const
    {25, 115, 0, 0, Smoke::mf_const, 152, 4},	//235 QScriptSyntaxCheckResult::errorColumnNumber() const
    {25, 117, 0, 0, Smoke::mf_const, 51, 5},	//236 QScriptSyntaxCheckResult::errorMessage() const
    {25, 223, 181, 1, 0, 37, 6},	//237 QScriptSyntaxCheckResult::operator=(const QScriptSyntaxCheckResult&)
    {25, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 7},	//238 QScriptSyntaxCheckResult::Error (enum)
    {25, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 8},	//239 QScriptSyntaxCheckResult::Intermediate (enum)
    {25, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 39, 9},	//240 QScriptSyntaxCheckResult::Valid (enum)
    {25, 361, 0, 0, Smoke::mf_dtor, 0, 10 },	//241 QScriptSyntaxCheckResult::~QScriptSyntaxCheckResult()
    {26, 47, 0, 0, Smoke::mf_ctor, 44, 1},	//242 QScriptValue::QScriptValue()
    {26, 47, 33, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 44, 2},	//243 QScriptValue::QScriptValue(const QScriptValue&)
    {26, 47, 183, 2, Smoke::mf_ctor, 44, 3},	//244 QScriptValue::QScriptValue(QScriptEngine*, QScriptValue::SpecialValue)
    {26, 47, 186, 2, Smoke::mf_ctor, 44, 4},	//245 QScriptValue::QScriptValue(QScriptEngine*, bool)
    {26, 47, 189, 2, Smoke::mf_ctor, 44, 5},	//246 QScriptValue::QScriptValue(QScriptEngine*, int)
    {26, 47, 192, 2, Smoke::mf_ctor, 44, 6},	//247 QScriptValue::QScriptValue(QScriptEngine*, unsigned int)
    {26, 47, 195, 2, Smoke::mf_ctor, 44, 7},	//248 QScriptValue::QScriptValue(QScriptEngine*, double)
    {26, 47, 198, 2, Smoke::mf_ctor, 44, 8},	//249 QScriptValue::QScriptValue(QScriptEngine*, const QString&)
    {26, 47, 201, 1, Smoke::mf_ctor, 44, 9},	//250 QScriptValue::QScriptValue(QScriptValue::SpecialValue)
    {26, 47, 203, 1, Smoke::mf_ctor, 44, 10},	//251 QScriptValue::QScriptValue(bool)
    {26, 47, 46, 1, Smoke::mf_ctor, 44, 11},	//252 QScriptValue::QScriptValue(int)
    {26, 47, 96, 1, Smoke::mf_ctor, 44, 12},	//253 QScriptValue::QScriptValue(unsigned int)
    {26, 47, 101, 1, Smoke::mf_ctor, 44, 13},	//254 QScriptValue::QScriptValue(double)
    {26, 47, 51, 1, Smoke::mf_ctor, 44, 14},	//255 QScriptValue::QScriptValue(const QString&)
    {26, 47, 205, 1, Smoke::mf_ctor, 44, 15},	//256 QScriptValue::QScriptValue(const QLatin1String&)
    {26, 223, 33, 1, 0, 41, 16},	//257 QScriptValue::operator=(const QScriptValue&)
    {26, 112, 0, 0, Smoke::mf_const, 24, 17},	//258 QScriptValue::engine() const
    {26, 174, 0, 0, Smoke::mf_const, 128, 18},	//259 QScriptValue::isValid() const
    {26, 159, 0, 0, Smoke::mf_const, 128, 19},	//260 QScriptValue::isBool() const
    {26, 160, 0, 0, Smoke::mf_const, 128, 20},	//261 QScriptValue::isBoolean() const
    {26, 167, 0, 0, Smoke::mf_const, 128, 21},	//262 QScriptValue::isNumber() const
    {26, 165, 0, 0, Smoke::mf_const, 128, 22},	//263 QScriptValue::isFunction() const
    {26, 166, 0, 0, Smoke::mf_const, 128, 23},	//264 QScriptValue::isNull() const
    {26, 172, 0, 0, Smoke::mf_const, 128, 24},	//265 QScriptValue::isString() const
    {26, 173, 0, 0, Smoke::mf_const, 128, 25},	//266 QScriptValue::isUndefined() const
    {26, 175, 0, 0, Smoke::mf_const, 128, 26},	//267 QScriptValue::isVariant() const
    {26, 170, 0, 0, Smoke::mf_const, 128, 27},	//268 QScriptValue::isQObject() const
    {26, 169, 0, 0, Smoke::mf_const, 128, 28},	//269 QScriptValue::isQMetaObject() const
    {26, 168, 0, 0, Smoke::mf_const, 128, 29},	//270 QScriptValue::isObject() const
    {26, 162, 0, 0, Smoke::mf_const, 128, 30},	//271 QScriptValue::isDate() const
    {26, 171, 0, 0, Smoke::mf_const, 128, 31},	//272 QScriptValue::isRegExp() const
    {26, 158, 0, 0, Smoke::mf_const, 128, 32},	//273 QScriptValue::isArray() const
    {26, 163, 0, 0, Smoke::mf_const, 128, 33},	//274 QScriptValue::isError() const
    {26, 333, 0, 0, Smoke::mf_const, 51, 34},	//275 QScriptValue::toString() const
    {26, 327, 0, 0, Smoke::mf_const, 151, 35},	//276 QScriptValue::toNumber() const
    {26, 321, 0, 0, Smoke::mf_const, 128, 36},	//277 QScriptValue::toBool() const
    {26, 322, 0, 0, Smoke::mf_const, 128, 37},	//278 QScriptValue::toBoolean() const
    {26, 326, 0, 0, Smoke::mf_const, 151, 38},	//279 QScriptValue::toInteger() const
    {26, 325, 0, 0, Smoke::mf_const, 152, 39},	//280 QScriptValue::toInt32() const
    {26, 337, 0, 0, Smoke::mf_const, 154, 40},	//281 QScriptValue::toUInt32() const
    {26, 336, 0, 0, Smoke::mf_const, 156, 41},	//282 QScriptValue::toUInt16() const
    {26, 338, 0, 0, Smoke::mf_const, 55, 42},	//283 QScriptValue::toVariant() const
    {26, 331, 0, 0, Smoke::mf_const, 9, 43},	//284 QScriptValue::toQObject() const
    {26, 330, 0, 0, Smoke::mf_const, 137, 44},	//285 QScriptValue::toQMetaObject() const
    {26, 328, 0, 0, Smoke::mf_const, 40, 45},	//286 QScriptValue::toObject() const
    {26, 323, 0, 0, Smoke::mf_const, 3, 46},	//287 QScriptValue::toDateTime() const
    {26, 332, 0, 0, Smoke::mf_const, 10, 47},	//288 QScriptValue::toRegExp() const
    {26, 156, 33, 1, Smoke::mf_const, 128, 48},	//289 QScriptValue::instanceOf(const QScriptValue&) const
    {26, 177, 33, 1, Smoke::mf_const, 128, 49},	//290 QScriptValue::lessThan(const QScriptValue&) const
    {26, 113, 33, 1, Smoke::mf_const, 128, 50},	//291 QScriptValue::equals(const QScriptValue&) const
    {26, 307, 33, 1, Smoke::mf_const, 128, 51},	//292 QScriptValue::strictlyEquals(const QScriptValue&) const
    {26, 246, 0, 0, Smoke::mf_const, 40, 52},	//293 QScriptValue::prototype() const
    {26, 289, 33, 1, 0, 0, 53},	//294 QScriptValue::setPrototype(const QScriptValue&)
    {26, 262, 0, 0, Smoke::mf_const, 40, 54},	//295 QScriptValue::scope() const
    {26, 293, 33, 1, 0, 0, 55},	//296 QScriptValue::setScope(const QScriptValue&)
    {26, 234, 207, 2, Smoke::mf_const, 40, 56},	//297 QScriptValue::property(const QString&, const QFlags<QScriptValue::ResolveFlag>&) const
    {26, 283, 210, 3, 0, 0, 57},	//298 QScriptValue::setProperty(const QString&, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&)
    {26, 234, 214, 2, Smoke::mf_const, 40, 58},	//299 QScriptValue::property(unsigned int, const QFlags<QScriptValue::ResolveFlag>&) const
    {26, 283, 217, 3, 0, 0, 59},	//300 QScriptValue::setProperty(unsigned int, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&)
    {26, 234, 221, 2, Smoke::mf_const, 40, 60},	//301 QScriptValue::property(const QScriptString&, const QFlags<QScriptValue::ResolveFlag>&) const
    {26, 283, 224, 3, 0, 0, 61},	//302 QScriptValue::setProperty(const QScriptString&, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&)
    {26, 240, 207, 2, Smoke::mf_const, 6, 62},	//303 QScriptValue::propertyFlags(const QString&, const QFlags<QScriptValue::ResolveFlag>&) const
    {26, 240, 221, 2, Smoke::mf_const, 6, 63},	//304 QScriptValue::propertyFlags(const QScriptString&, const QFlags<QScriptValue::ResolveFlag>&) const
    {26, 86, 228, 2, 0, 40, 64},	//305 QScriptValue::call(const QScriptValue&, const QList<QScriptValue>&)
    {26, 86, 231, 2, 0, 40, 65},	//306 QScriptValue::call(const QScriptValue&, const QScriptValue&)
    {26, 100, 234, 1, 0, 40, 66},	//307 QScriptValue::construct(const QList<QScriptValue>&)
    {26, 100, 33, 1, 0, 40, 67},	//308 QScriptValue::construct(const QScriptValue&)
    {26, 108, 0, 0, Smoke::mf_const, 40, 68},	//309 QScriptValue::data() const
    {26, 275, 33, 1, 0, 0, 69},	//310 QScriptValue::setData(const QScriptValue&)
    {26, 264, 0, 0, Smoke::mf_const, 12, 70},	//311 QScriptValue::scriptClass() const
    {26, 295, 132, 1, 0, 0, 71},	//312 QScriptValue::setScriptClass(QScriptClass*)
    {26, 219, 0, 0, Smoke::mf_const, 153, 72},	//313 QScriptValue::objectId() const
    {26, 234, 51, 1, Smoke::mf_const, 40, 73},	//314 QScriptValue::property(const QString&) const
    {26, 283, 236, 2, 0, 0, 74},	//315 QScriptValue::setProperty(const QString&, const QScriptValue&)
    {26, 234, 96, 1, Smoke::mf_const, 40, 75},	//316 QScriptValue::property(unsigned int) const
    {26, 283, 239, 2, 0, 0, 76},	//317 QScriptValue::setProperty(unsigned int, const QScriptValue&)
    {26, 234, 177, 1, Smoke::mf_const, 40, 77},	//318 QScriptValue::property(const QScriptString&) const
    {26, 283, 242, 2, 0, 0, 78},	//319 QScriptValue::setProperty(const QScriptString&, const QScriptValue&)
    {26, 240, 51, 1, Smoke::mf_const, 6, 79},	//320 QScriptValue::propertyFlags(const QString&) const
    {26, 240, 177, 1, Smoke::mf_const, 6, 80},	//321 QScriptValue::propertyFlags(const QScriptString&) const
    {26, 86, 0, 0, 0, 40, 81},	//322 QScriptValue::call()
    {26, 86, 33, 1, 0, 40, 82},	//323 QScriptValue::call(const QScriptValue&)
    {26, 100, 0, 0, 0, 40, 83},	//324 QScriptValue::construct()
    {26, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 84},	//325 QScriptValue::ResolveLocal (enum)
    {26, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 85},	//326 QScriptValue::ResolvePrototype (enum)
    {26, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 86},	//327 QScriptValue::ResolveScope (enum)
    {26, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 87},	//328 QScriptValue::ResolveFull (enum)
    {26, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 88},	//329 QScriptValue::ReadOnly (enum)
    {26, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 89},	//330 QScriptValue::Undeletable (enum)
    {26, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 90},	//331 QScriptValue::SkipInEnumeration (enum)
    {26, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 91},	//332 QScriptValue::PropertyGetter (enum)
    {26, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 92},	//333 QScriptValue::PropertySetter (enum)
    {26, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 93},	//334 QScriptValue::QObjectMember (enum)
    {26, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 94},	//335 QScriptValue::KeepExistingFlags (enum)
    {26, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 95},	//336 QScriptValue::UserRange (enum)
    {26, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 96},	//337 QScriptValue::NullValue (enum)
    {26, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 97},	//338 QScriptValue::UndefinedValue (enum)
    {26, 362, 0, 0, Smoke::mf_dtor, 0, 98 },	//339 QScriptValue::~QScriptValue()
    {27, 51, 33, 1, Smoke::mf_ctor, 49, 1},	//340 QScriptValueIterator::QScriptValueIterator(const QScriptValue&)
    {27, 145, 0, 0, Smoke::mf_const, 128, 2},	//341 QScriptValueIterator::hasNext() const
    {27, 214, 0, 0, 0, 0, 3},	//342 QScriptValueIterator::next()
    {27, 146, 0, 0, Smoke::mf_const, 128, 4},	//343 QScriptValueIterator::hasPrevious() const
    {27, 232, 0, 0, 0, 0, 5},	//344 QScriptValueIterator::previous()
    {27, 181, 0, 0, Smoke::mf_const, 51, 6},	//345 QScriptValueIterator::name() const
    {27, 268, 0, 0, Smoke::mf_const, 33, 7},	//346 QScriptValueIterator::scriptName() const
    {27, 351, 0, 0, Smoke::mf_const, 40, 8},	//347 QScriptValueIterator::value() const
    {27, 299, 33, 1, 0, 0, 9},	//348 QScriptValueIterator::setValue(const QScriptValue&)
    {27, 133, 0, 0, Smoke::mf_const, 6, 10},	//349 QScriptValueIterator::flags() const
    {27, 258, 0, 0, 0, 0, 11},	//350 QScriptValueIterator::remove()
    {27, 324, 0, 0, 0, 0, 12},	//351 QScriptValueIterator::toFront()
    {27, 320, 0, 0, 0, 0, 13},	//352 QScriptValueIterator::toBack()
    {27, 223, 245, 1, 0, 48, 14},	//353 QScriptValueIterator::operator=(QScriptValue&)
    {27, 363, 0, 0, Smoke::mf_dtor, 0, 15 },	//354 QScriptValueIterator::~QScriptValueIterator()
    {28, 53, 0, 0, Smoke::mf_ctor, 50, 1},	//355 QScriptable::QScriptable()
    {28, 112, 0, 0, Smoke::mf_const, 24, 2},	//356 QScriptable::engine() const
    {28, 103, 0, 0, Smoke::mf_const, 18, 3},	//357 QScriptable::context() const
    {28, 311, 0, 0, Smoke::mf_const, 40, 4},	//358 QScriptable::thisObject() const
    {28, 82, 0, 0, Smoke::mf_const, 152, 5},	//359 QScriptable::argumentCount() const
    {28, 80, 46, 1, Smoke::mf_const, 40, 6},	//360 QScriptable::argument(int) const
    {28, 364, 0, 0, Smoke::mf_dtor, 0, 7 },	//361 QScriptable::~QScriptable()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    102,  // QScriptEngine::QScriptEngine(QObject*)
    169,  // QScriptEngine::QScriptEngine(QScriptEnginePrivate&)
    0,
    121,  // QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*), int)
    123,  // QScriptEngine::newFunction(QScriptValue(*)(QScriptContext*,QScriptEngine*,void*), void*)
    0,
    72,  // QScriptContextInfo::QScriptContextInfo(const QScriptContext*)
    73,  // QScriptContextInfo::QScriptContextInfo(const QScriptContextInfo&)
    0,
    243,  // QScriptValue::QScriptValue(const QScriptValue&)
    256,  // QScriptValue::QScriptValue(const QLatin1String&)
    0,
    244,  // QScriptValue::QScriptValue(QScriptEngine*, QScriptValue::SpecialValue)
    245,  // QScriptValue::QScriptValue(QScriptEngine*, bool)
    246,  // QScriptValue::QScriptValue(QScriptEngine*, int)
    247,  // QScriptValue::QScriptValue(QScriptEngine*, unsigned int)
    248,  // QScriptValue::QScriptValue(QScriptEngine*, double)
    249,  // QScriptValue::QScriptValue(QScriptEngine*, const QString&)
    0,
    250,  // QScriptValue::QScriptValue(QScriptValue::SpecialValue)
    251,  // QScriptValue::QScriptValue(bool)
    252,  // QScriptValue::QScriptValue(int)
    253,  // QScriptValue::QScriptValue(unsigned int)
    254,  // QScriptValue::QScriptValue(double)
    255,  // QScriptValue::QScriptValue(const QString&)
    0,
    314,  // QScriptValue::property(const QString&) const
    316,  // QScriptValue::property(unsigned int) const
    0,
    297,  // QScriptValue::property(const QString&, const QFlags<QScriptValue::ResolveFlag>&) const
    299,  // QScriptValue::property(unsigned int, const QFlags<QScriptValue::ResolveFlag>&) const
    0,
    315,  // QScriptValue::setProperty(const QString&, const QScriptValue&)
    317,  // QScriptValue::setProperty(unsigned int, const QScriptValue&)
    0,
    298,  // QScriptValue::setProperty(const QString&, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&)
    300,  // QScriptValue::setProperty(unsigned int, const QScriptValue&, const QFlags<QScriptValue::PropertyFlag>&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {6, 251, 2},	// QGlobalSpace::qScriptConnect#$##
    {11, 3, 25},	// QScriptClass::Callable
    {11, 13, 23},	// QScriptClass::HandlesReadAccess
    {11, 14, 24},	// QScriptClass::HandlesWriteAccess
    {11, 15, 26},	// QScriptClass::HasInstance
    {11, 26, 10},	// QScriptClass::QScriptClass#
    {11, 27, 21},	// QScriptClass::QScriptClass##
    {11, 112, 11},	// QScriptClass::engine
    {11, 130, 22},	// QScriptClass::extension$
    {11, 131, 20},	// QScriptClass::extension$#
    {11, 181, 18},	// QScriptClass::name
    {11, 194, 16},	// QScriptClass::newIterator#
    {11, 237, 13},	// QScriptClass::property##$
    {11, 243, 15},	// QScriptClass::propertyFlags##$
    {11, 246, 17},	// QScriptClass::prototype
    {11, 257, 12},	// QScriptClass::queryProperty##$$
    {11, 286, 14},	// QScriptClass::setProperty##$#
    {11, 310, 19},	// QScriptClass::supportsExtension$
    {11, 352, 27},	// QScriptClass::~QScriptClass
    {13, 29, 28},	// QScriptClassPropertyIterator::QScriptClassPropertyIterator#
    {13, 30, 39},	// QScriptClassPropertyIterator::QScriptClassPropertyIterator##
    {13, 133, 38},	// QScriptClassPropertyIterator::flags
    {13, 145, 30},	// QScriptClassPropertyIterator::hasNext
    {13, 146, 32},	// QScriptClassPropertyIterator::hasPrevious
    {13, 148, 37},	// QScriptClassPropertyIterator::id
    {13, 181, 36},	// QScriptClassPropertyIterator::name
    {13, 214, 31},	// QScriptClassPropertyIterator::next
    {13, 216, 29},	// QScriptClassPropertyIterator::object
    {13, 232, 33},	// QScriptClassPropertyIterator::previous
    {13, 320, 35},	// QScriptClassPropertyIterator::toBack
    {13, 324, 34},	// QScriptClassPropertyIterator::toFront
    {13, 353, 40},	// QScriptClassPropertyIterator::~QScriptClassPropertyIterator
    {15, 6, 64},	// QScriptContext::ExceptionState
    {15, 19, 63},	// QScriptContext::NormalState
    {15, 57, 69},	// QScriptContext::RangeError
    {15, 59, 66},	// QScriptContext::ReferenceError
    {15, 68, 67},	// QScriptContext::SyntaxError
    {15, 69, 68},	// QScriptContext::TypeError
    {15, 70, 70},	// QScriptContext::URIError
    {15, 73, 65},	// QScriptContext::UnknownError
    {15, 78, 53},	// QScriptContext::activationObject
    {15, 81, 46},	// QScriptContext::argument$
    {15, 82, 45},	// QScriptContext::argumentCount
    {15, 83, 47},	// QScriptContext::argumentsObject
    {15, 85, 61},	// QScriptContext::backtrace
    {15, 90, 44},	// QScriptContext::callee
    {15, 112, 42},	// QScriptContext::engine
    {15, 161, 57},	// QScriptContext::isCalledAsConstructor
    {15, 227, 41},	// QScriptContext::parentContext
    {15, 229, 50},	// QScriptContext::popScope
    {15, 249, 49},	// QScriptContext::pushScope#
    {15, 261, 51},	// QScriptContext::returnValue
    {15, 263, 48},	// QScriptContext::scopeChain
    {15, 272, 54},	// QScriptContext::setActivationObject#
    {15, 292, 52},	// QScriptContext::setReturnValue#
    {15, 298, 56},	// QScriptContext::setThisObject#
    {15, 305, 43},	// QScriptContext::state
    {15, 311, 55},	// QScriptContext::thisObject
    {15, 313, 60},	// QScriptContext::throwError$
    {15, 314, 59},	// QScriptContext::throwError$$
    {15, 316, 58},	// QScriptContext::throwValue#
    {15, 333, 62},	// QScriptContext::toString
    {15, 354, 71},	// QScriptContext::~QScriptContext
    {16, 18, 92},	// QScriptContextInfo::NativeFunction
    {16, 31, 74},	// QScriptContextInfo::QScriptContextInfo
    {16, 32, -7},	// QScriptContextInfo::QScriptContextInfo#
    {16, 54, 90},	// QScriptContextInfo::QtFunction
    {16, 56, 91},	// QScriptContextInfo::QtPropertyFunction
    {16, 64, 89},	// QScriptContextInfo::ScriptFunction
    {16, 98, 80},	// QScriptContextInfo::columnNumber
    {16, 132, 78},	// QScriptContextInfo::fileName
    {16, 134, 85},	// QScriptContextInfo::functionEndLineNumber
    {16, 139, 86},	// QScriptContextInfo::functionMetaIndex
    {16, 140, 81},	// QScriptContextInfo::functionName
    {16, 141, 83},	// QScriptContextInfo::functionParameterNames
    {16, 142, 84},	// QScriptContextInfo::functionStartLineNumber
    {16, 143, 82},	// QScriptContextInfo::functionType
    {16, 166, 76},	// QScriptContextInfo::isNull
    {16, 179, 79},	// QScriptContextInfo::lineNumber
    {16, 222, 88},	// QScriptContextInfo::operator!=#
    {16, 224, 75},	// QScriptContextInfo::operator=#
    {16, 226, 87},	// QScriptContextInfo::operator==#
    {16, 265, 77},	// QScriptContextInfo::scriptId
    {16, 355, 93},	// QScriptContextInfo::~QScriptContextInfo
    {17, 1, 181},	// QScriptEngine::AutoCreateDynamicProperties
    {17, 2, 173},	// QScriptEngine::AutoOwnership
    {17, 7, 174},	// QScriptEngine::ExcludeChildObjects
    {17, 8, 179},	// QScriptEngine::ExcludeDeleteLater
    {17, 9, 180},	// QScriptEngine::ExcludeSlots
    {17, 10, 177},	// QScriptEngine::ExcludeSuperClassContents
    {17, 11, 175},	// QScriptEngine::ExcludeSuperClassMethods
    {17, 12, 176},	// QScriptEngine::ExcludeSuperClassProperties
    {17, 21, 182},	// QScriptEngine::PreferExistingWrapperObject
    {17, 33, 101},	// QScriptEngine::QScriptEngine
    {17, 34, -1},	// QScriptEngine::QScriptEngine#
    {17, 35, 153},	// QScriptEngine::QScriptEngine##
    {17, 55, 171},	// QScriptEngine::QtOwnership
    {17, 65, 172},	// QScriptEngine::ScriptOwnership
    {17, 67, 178},	// QScriptEngine::SkipMethodsInEnumeration
    {17, 76, 158},	// QScriptEngine::abortEvaluation
    {17, 77, 113},	// QScriptEngine::abortEvaluation#
    {17, 79, 148},	// QScriptEngine::agent
    {17, 84, 141},	// QScriptEngine::availableExtensions
    {17, 92, 108},	// QScriptEngine::canEvaluate$
    {17, 94, 109},	// QScriptEngine::checkSyntax$
    {17, 96, 118},	// QScriptEngine::clearExceptions
    {17, 97, 143},	// QScriptEngine::collectGarbage
    {17, 106, 105},	// QScriptEngine::currentContext
    {17, 110, 137},	// QScriptEngine::defaultPrototype$
    {17, 119, 111},	// QScriptEngine::evaluate#
    {17, 120, 156},	// QScriptEngine::evaluate$
    {17, 121, 157},	// QScriptEngine::evaluate$$
    {17, 122, 110},	// QScriptEngine::evaluate$$$
    {17, 144, 103},	// QScriptEngine::globalObject
    {17, 147, 114},	// QScriptEngine::hasUncaughtException
    {17, 150, 140},	// QScriptEngine::importExtension$
    {17, 151, 142},	// QScriptEngine::importedExtensions
    {17, 154, 168},	// QScriptEngine::installTranslatorFunctions
    {17, 155, 139},	// QScriptEngine::installTranslatorFunctions#
    {17, 164, 112},	// QScriptEngine::isEvaluating
    {17, 180, 94},	// QScriptEngine::metaObject
    {17, 182, 133},	// QScriptEngine::newActivationObject
    {17, 183, 162},	// QScriptEngine::newArray
    {17, 184, 129},	// QScriptEngine::newArray$
    {17, 186, 132},	// QScriptEngine::newDate#
    {17, 187, 131},	// QScriptEngine::newDate$
    {17, 189, 159},	// QScriptEngine::newFunction#
    {17, 190, 160},	// QScriptEngine::newFunction##
    {17, 191, 122},	// QScriptEngine::newFunction##$
    {17, 192, -4},	// QScriptEngine::newFunction#$
    {17, 195, 127},	// QScriptEngine::newObject
    {17, 196, 161},	// QScriptEngine::newObject#
    {17, 197, 128},	// QScriptEngine::newObject##
    {17, 199, 167},	// QScriptEngine::newQMetaObject#
    {17, 200, 136},	// QScriptEngine::newQMetaObject##
    {17, 202, 163},	// QScriptEngine::newQObject#
    {17, 203, 165},	// QScriptEngine::newQObject##
    {17, 204, 166},	// QScriptEngine::newQObject##$
    {17, 205, 135},	// QScriptEngine::newQObject##$#
    {17, 206, 164},	// QScriptEngine::newQObject#$
    {17, 207, 134},	// QScriptEngine::newQObject#$#
    {17, 209, 126},	// QScriptEngine::newRegExp#
    {17, 210, 130},	// QScriptEngine::newRegExp$$
    {17, 212, 124},	// QScriptEngine::newVariant#
    {17, 213, 125},	// QScriptEngine::newVariant##
    {17, 215, 119},	// QScriptEngine::nullValue
    {17, 218, 151},	// QScriptEngine::objectById$
    {17, 228, 107},	// QScriptEngine::popContext
    {17, 233, 146},	// QScriptEngine::processEventsInterval
    {17, 247, 106},	// QScriptEngine::pushContext
    {17, 253, 100},	// QScriptEngine::qt_metacall$$?
    {17, 255, 95},	// QScriptEngine::qt_metacast$
    {17, 260, 144},	// QScriptEngine::reportAdditionalMemoryCost$
    {17, 274, 147},	// QScriptEngine::setAgent#
    {17, 278, 138},	// QScriptEngine::setDefaultPrototype$#
    {17, 280, 104},	// QScriptEngine::setGlobalObject#
    {17, 282, 145},	// QScriptEngine::setProcessEventsInterval$
    {17, 304, 152},	// QScriptEngine::signalHandlerException#
    {17, 306, 170},	// QScriptEngine::staticMetaObject
    {17, 329, 150},	// QScriptEngine::toObject#
    {17, 335, 149},	// QScriptEngine::toStringHandle$
    {17, 340, 154},	// QScriptEngine::tr$
    {17, 341, 96},	// QScriptEngine::tr$$
    {17, 342, 98},	// QScriptEngine::tr$$$
    {17, 344, 155},	// QScriptEngine::trUtf8$
    {17, 345, 97},	// QScriptEngine::trUtf8$$
    {17, 346, 99},	// QScriptEngine::trUtf8$$$
    {17, 347, 115},	// QScriptEngine::uncaughtException
    {17, 348, 117},	// QScriptEngine::uncaughtExceptionBacktrace
    {17, 349, 116},	// QScriptEngine::uncaughtExceptionLineNumber
    {17, 350, 120},	// QScriptEngine::undefinedValue
    {17, 356, 183},	// QScriptEngine::~QScriptEngine
    {18, 4, 199},	// QScriptEngineAgent::DebuggerInvocationRequest
    {18, 37, 184},	// QScriptEngineAgent::QScriptEngineAgent#
    {18, 38, 197},	// QScriptEngineAgent::QScriptEngineAgent##
    {18, 104, 188},	// QScriptEngineAgent::contextPop
    {18, 105, 187},	// QScriptEngineAgent::contextPush
    {18, 112, 196},	// QScriptEngineAgent::engine
    {18, 126, 193},	// QScriptEngineAgent::exceptionCatch$#
    {18, 128, 192},	// QScriptEngineAgent::exceptionThrow$#$
    {18, 130, 198},	// QScriptEngineAgent::extension$
    {18, 131, 195},	// QScriptEngineAgent::extension$#
    {18, 136, 189},	// QScriptEngineAgent::functionEntry$
    {18, 138, 190},	// QScriptEngineAgent::functionExit$#
    {18, 231, 191},	// QScriptEngineAgent::positionChange$$$
    {18, 267, 185},	// QScriptEngineAgent::scriptLoad$$$$
    {18, 270, 186},	// QScriptEngineAgent::scriptUnload$
    {18, 310, 194},	// QScriptEngineAgent::supportsExtension$
    {18, 357, 200},	// QScriptEngineAgent::~QScriptEngineAgent
    {21, 39, 202},	// QScriptExtensionInterface::QScriptExtensionInterface
    {21, 40, 203},	// QScriptExtensionInterface::QScriptExtensionInterface#
    {21, 153, 201},	// QScriptExtensionInterface::initialize$#
    {21, 358, 204},	// QScriptExtensionInterface::~QScriptExtensionInterface
    {22, 41, 218},	// QScriptExtensionPlugin::QScriptExtensionPlugin
    {22, 42, 212},	// QScriptExtensionPlugin::QScriptExtensionPlugin#
    {22, 153, 214},	// QScriptExtensionPlugin::initialize$#
    {22, 176, 213},	// QScriptExtensionPlugin::keys
    {22, 180, 205},	// QScriptExtensionPlugin::metaObject
    {22, 253, 211},	// QScriptExtensionPlugin::qt_metacall$$?
    {22, 255, 206},	// QScriptExtensionPlugin::qt_metacast$
    {22, 302, 215},	// QScriptExtensionPlugin::setupPackage$#
    {22, 306, 219},	// QScriptExtensionPlugin::staticMetaObject
    {22, 340, 216},	// QScriptExtensionPlugin::tr$
    {22, 341, 207},	// QScriptExtensionPlugin::tr$$
    {22, 342, 209},	// QScriptExtensionPlugin::tr$$$
    {22, 344, 217},	// QScriptExtensionPlugin::trUtf8$
    {22, 345, 208},	// QScriptExtensionPlugin::trUtf8$$
    {22, 346, 210},	// QScriptExtensionPlugin::trUtf8$$$
    {22, 359, 220},	// QScriptExtensionPlugin::~QScriptExtensionPlugin
    {24, 43, 221},	// QScriptString::QScriptString
    {24, 44, 222},	// QScriptString::QScriptString#
    {24, 174, 224},	// QScriptString::isValid
    {24, 220, 229},	// QScriptString::operator QString
    {24, 222, 226},	// QScriptString::operator!=#
    {24, 224, 223},	// QScriptString::operator=#
    {24, 226, 225},	// QScriptString::operator==#
    {24, 318, 230},	// QScriptString::toArrayIndex
    {24, 319, 227},	// QScriptString::toArrayIndex$
    {24, 333, 228},	// QScriptString::toString
    {24, 360, 231},	// QScriptString::~QScriptString
    {25, 5, 238},	// QScriptSyntaxCheckResult::Error
    {25, 16, 239},	// QScriptSyntaxCheckResult::Intermediate
    {25, 46, 232},	// QScriptSyntaxCheckResult::QScriptSyntaxCheckResult#
    {25, 75, 240},	// QScriptSyntaxCheckResult::Valid
    {25, 115, 235},	// QScriptSyntaxCheckResult::errorColumnNumber
    {25, 116, 234},	// QScriptSyntaxCheckResult::errorLineNumber
    {25, 117, 236},	// QScriptSyntaxCheckResult::errorMessage
    {25, 224, 237},	// QScriptSyntaxCheckResult::operator=#
    {25, 305, 233},	// QScriptSyntaxCheckResult::state
    {25, 361, 241},	// QScriptSyntaxCheckResult::~QScriptSyntaxCheckResult
    {26, 17, 335},	// QScriptValue::KeepExistingFlags
    {26, 20, 337},	// QScriptValue::NullValue
    {26, 22, 332},	// QScriptValue::PropertyGetter
    {26, 23, 333},	// QScriptValue::PropertySetter
    {26, 24, 334},	// QScriptValue::QObjectMember
    {26, 47, 242},	// QScriptValue::QScriptValue
    {26, 48, -10},	// QScriptValue::QScriptValue#
    {26, 49, -13},	// QScriptValue::QScriptValue#$
    {26, 50, -20},	// QScriptValue::QScriptValue$
    {26, 58, 329},	// QScriptValue::ReadOnly
    {26, 60, 328},	// QScriptValue::ResolveFull
    {26, 61, 325},	// QScriptValue::ResolveLocal
    {26, 62, 326},	// QScriptValue::ResolvePrototype
    {26, 63, 327},	// QScriptValue::ResolveScope
    {26, 66, 331},	// QScriptValue::SkipInEnumeration
    {26, 71, 338},	// QScriptValue::UndefinedValue
    {26, 72, 330},	// QScriptValue::Undeletable
    {26, 74, 336},	// QScriptValue::UserRange
    {26, 86, 322},	// QScriptValue::call
    {26, 87, 323},	// QScriptValue::call#
    {26, 88, 306},	// QScriptValue::call##
    {26, 89, 305},	// QScriptValue::call#?
    {26, 100, 324},	// QScriptValue::construct
    {26, 101, 308},	// QScriptValue::construct#
    {26, 102, 307},	// QScriptValue::construct?
    {26, 108, 309},	// QScriptValue::data
    {26, 112, 258},	// QScriptValue::engine
    {26, 114, 291},	// QScriptValue::equals#
    {26, 157, 289},	// QScriptValue::instanceOf#
    {26, 158, 273},	// QScriptValue::isArray
    {26, 159, 260},	// QScriptValue::isBool
    {26, 160, 261},	// QScriptValue::isBoolean
    {26, 162, 271},	// QScriptValue::isDate
    {26, 163, 274},	// QScriptValue::isError
    {26, 165, 263},	// QScriptValue::isFunction
    {26, 166, 264},	// QScriptValue::isNull
    {26, 167, 262},	// QScriptValue::isNumber
    {26, 168, 270},	// QScriptValue::isObject
    {26, 169, 269},	// QScriptValue::isQMetaObject
    {26, 170, 268},	// QScriptValue::isQObject
    {26, 171, 272},	// QScriptValue::isRegExp
    {26, 172, 265},	// QScriptValue::isString
    {26, 173, 266},	// QScriptValue::isUndefined
    {26, 174, 259},	// QScriptValue::isValid
    {26, 175, 267},	// QScriptValue::isVariant
    {26, 178, 290},	// QScriptValue::lessThan#
    {26, 219, 313},	// QScriptValue::objectId
    {26, 224, 257},	// QScriptValue::operator=#
    {26, 235, 318},	// QScriptValue::property#
    {26, 236, 301},	// QScriptValue::property##
    {26, 238, -27},	// QScriptValue::property$
    {26, 239, -30},	// QScriptValue::property$#
    {26, 241, 321},	// QScriptValue::propertyFlags#
    {26, 242, 304},	// QScriptValue::propertyFlags##
    {26, 244, 320},	// QScriptValue::propertyFlags$
    {26, 245, 303},	// QScriptValue::propertyFlags$#
    {26, 246, 293},	// QScriptValue::prototype
    {26, 262, 295},	// QScriptValue::scope
    {26, 264, 311},	// QScriptValue::scriptClass
    {26, 276, 310},	// QScriptValue::setData#
    {26, 284, 319},	// QScriptValue::setProperty##
    {26, 285, 302},	// QScriptValue::setProperty###
    {26, 287, -33},	// QScriptValue::setProperty$#
    {26, 288, -36},	// QScriptValue::setProperty$##
    {26, 290, 294},	// QScriptValue::setPrototype#
    {26, 294, 296},	// QScriptValue::setScope#
    {26, 296, 312},	// QScriptValue::setScriptClass#
    {26, 308, 292},	// QScriptValue::strictlyEquals#
    {26, 321, 277},	// QScriptValue::toBool
    {26, 322, 278},	// QScriptValue::toBoolean
    {26, 323, 287},	// QScriptValue::toDateTime
    {26, 325, 280},	// QScriptValue::toInt32
    {26, 326, 279},	// QScriptValue::toInteger
    {26, 327, 276},	// QScriptValue::toNumber
    {26, 328, 286},	// QScriptValue::toObject
    {26, 330, 285},	// QScriptValue::toQMetaObject
    {26, 331, 284},	// QScriptValue::toQObject
    {26, 332, 288},	// QScriptValue::toRegExp
    {26, 333, 275},	// QScriptValue::toString
    {26, 336, 282},	// QScriptValue::toUInt16
    {26, 337, 281},	// QScriptValue::toUInt32
    {26, 338, 283},	// QScriptValue::toVariant
    {26, 362, 339},	// QScriptValue::~QScriptValue
    {27, 52, 340},	// QScriptValueIterator::QScriptValueIterator#
    {27, 133, 349},	// QScriptValueIterator::flags
    {27, 145, 341},	// QScriptValueIterator::hasNext
    {27, 146, 343},	// QScriptValueIterator::hasPrevious
    {27, 181, 345},	// QScriptValueIterator::name
    {27, 214, 342},	// QScriptValueIterator::next
    {27, 224, 353},	// QScriptValueIterator::operator=#
    {27, 232, 344},	// QScriptValueIterator::previous
    {27, 258, 350},	// QScriptValueIterator::remove
    {27, 268, 346},	// QScriptValueIterator::scriptName
    {27, 300, 348},	// QScriptValueIterator::setValue#
    {27, 320, 352},	// QScriptValueIterator::toBack
    {27, 324, 351},	// QScriptValueIterator::toFront
    {27, 351, 347},	// QScriptValueIterator::value
    {27, 363, 354},	// QScriptValueIterator::~QScriptValueIterator
    {28, 53, 355},	// QScriptable::QScriptable
    {28, 81, 360},	// QScriptable::argument$
    {28, 82, 359},	// QScriptable::argumentCount
    {28, 103, 357},	// QScriptable::context
    {28, 112, 356},	// QScriptable::engine
    {28, 311, 358},	// QScriptable::thisObject
    {28, 364, 361},	// QScriptable::~QScriptable
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *qtscript_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtscript_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    qtscript_Smoke = new Smoke(
        "qtscript",
        __smokeqtscript::classes, 30,
        __smokeqtscript::methods, 362,
        __smokeqtscript::methodMaps, 336,
        __smokeqtscript::methodNames, 364,
        __smokeqtscript::types, 159,
        __smokeqtscript::inheritanceList,
        __smokeqtscript::argumentList,
        __smokeqtscript::ambiguousMethodList,
        __smokeqtscript::cast );
    initialized = true;
}

void delete_qtscript_Smoke() { delete qtscript_Smoke; }

}
