#include <qttest_includes.h>

#include <smoke.h>
#include <qttest_smoke.h>

namespace __smokeqttest {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QBool
      switch(to) {
        case 1: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 2:   //QByteArray
      switch(to) {
        case 2: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 3:   //QChildEvent
      switch(to) {
        case 4: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 3: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 4:   //QEvent
      switch(to) {
        case 4: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QMetaObject
      switch(to) {
        case 6: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 7:   //QObject
      switch(to) {
        case 7: return (void*)(QObject*)xptr;
        case 18: return (void*)(QTestEventLoop*)(QObject*)xptr;
        case 10: return (void*)(QSignalSpy*)(QObject*)xptr;
        default: return xptr;
      }
    case 8:   //QPoint
      switch(to) {
        case 8: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 9:   //QRegExp
      switch(to) {
        case 9: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 10:   //QSignalSpy
      switch(to) {
        case 7: return (void*)(QObject*)(QSignalSpy*)xptr;
        case 10: return (void*)(QSignalSpy*)xptr;
        default: return xptr;
      }
    case 12:   //QTestAccessibility
      switch(to) {
        case 12: return (void*)(QTestAccessibility*)xptr;
        default: return xptr;
      }
    case 13:   //QTestAccessibilityEvent
      switch(to) {
        case 13: return (void*)(QTestAccessibilityEvent*)xptr;
        default: return xptr;
      }
    case 14:   //QTestData
      switch(to) {
        case 14: return (void*)(QTestData*)xptr;
        default: return xptr;
      }
    case 15:   //QTestDelayEvent
      switch(to) {
        case 16: return (void*)(QTestEvent*)(QTestDelayEvent*)xptr;
        case 15: return (void*)(QTestDelayEvent*)xptr;
        default: return xptr;
      }
    case 16:   //QTestEvent
      switch(to) {
        case 16: return (void*)(QTestEvent*)xptr;
        case 20: return (void*)(QTestKeyEvent*)(QTestEvent*)xptr;
        case 21: return (void*)(QTestMouseEvent*)(QTestEvent*)xptr;
        case 15: return (void*)(QTestDelayEvent*)(QTestEvent*)xptr;
        case 19: return (void*)(QTestKeyClicksEvent*)(QTestEvent*)xptr;
        default: return xptr;
      }
    case 17:   //QTestEventList
      switch(to) {
        case 17: return (void*)(QTestEventList*)xptr;
        default: return xptr;
      }
    case 18:   //QTestEventLoop
      switch(to) {
        case 7: return (void*)(QObject*)(QTestEventLoop*)xptr;
        case 18: return (void*)(QTestEventLoop*)xptr;
        default: return xptr;
      }
    case 19:   //QTestKeyClicksEvent
      switch(to) {
        case 16: return (void*)(QTestEvent*)(QTestKeyClicksEvent*)xptr;
        case 19: return (void*)(QTestKeyClicksEvent*)xptr;
        default: return xptr;
      }
    case 20:   //QTestKeyEvent
      switch(to) {
        case 16: return (void*)(QTestEvent*)(QTestKeyEvent*)xptr;
        case 20: return (void*)(QTestKeyEvent*)xptr;
        default: return xptr;
      }
    case 21:   //QTestMouseEvent
      switch(to) {
        case 16: return (void*)(QTestEvent*)(QTestMouseEvent*)xptr;
        case 21: return (void*)(QTestMouseEvent*)xptr;
        default: return xptr;
      }
    case 22:   //QTestTable
      switch(to) {
        case 22: return (void*)(QTestTable*)xptr;
        default: return xptr;
      }
    case 23:   //QTimerEvent
      switch(to) {
        case 4: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 23: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 24:   //QWidget
      switch(to) {
        case 7: return (void*)(QObject*)(QWidget*)xptr;
        case 24: return (void*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    7, 0, 0,	// 1: QObject, QList
    16, 0,	// 4: QTestEvent
    0, 0,	// 6: QList
    7, 0,	// 8: QObject
};

// These are the xenum functions for manipulating enum pointers
void xenum_QTest(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QSignalSpy(Smoke::Index, void*, Smoke::Stack);
void xcall_QTest(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestAccessibility(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestAccessibilityEvent(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestData(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestDelayEvent(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestEvent(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestEventList(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestEventLoop(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestKeyClicksEvent(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestKeyEvent(Smoke::Index, void*, Smoke::Stack);
void xcall_QTestMouseEvent(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QBool", true, 0, 0, 0, 0, 0 },	//1
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//2
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//3
    { "QEvent", true, 0, 0, 0, 0, 0 },	//4
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//5
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//6
    { "QObject", true, 0, 0, 0, 0, 0 },	//7
    { "QPoint", true, 0, 0, 0, 0, 0 },	//8
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//9
    { "QSignalSpy", false, 1, xcall_QSignalSpy, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QSignalSpy) },	//10
    { "QTest", false, 0, xcall_QTest, xenum_QTest, Smoke::cf_namespace, 0 },	//11
    { "QTestAccessibility", false, 0, xcall_QTestAccessibility, 0, Smoke::cf_deepcopy, sizeof(QTestAccessibility) },	//12
    { "QTestAccessibilityEvent", false, 0, xcall_QTestAccessibilityEvent, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QTestAccessibilityEvent) },	//13
    { "QTestData", false, 0, xcall_QTestData, 0, 0, sizeof(QTestData) },	//14
    { "QTestDelayEvent", false, 4, xcall_QTestDelayEvent, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QTestDelayEvent) },	//15
    { "QTestEvent", false, 0, xcall_QTestEvent, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QTestEvent) },	//16
    { "QTestEventList", false, 6, xcall_QTestEventList, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QTestEventList) },	//17
    { "QTestEventLoop", false, 8, xcall_QTestEventLoop, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QTestEventLoop) },	//18
    { "QTestKeyClicksEvent", false, 4, xcall_QTestKeyClicksEvent, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QTestKeyClicksEvent) },	//19
    { "QTestKeyEvent", false, 4, xcall_QTestKeyEvent, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QTestKeyEvent) },	//20
    { "QTestMouseEvent", false, 4, xcall_QTestMouseEvent, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(QTestMouseEvent) },	//21
    { "QTestTable", true, 0, 0, 0, 0, 0 },	//22
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//23
    { "QWidget", true, 0, 0, 0, 0, 0 },	//24
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAccessible2::InterfaceType", 0, Smoke::t_enum|Smoke::tf_stack },	//1
    { "QBool", 1, Smoke::t_class|Smoke::tf_stack },	//2
    { "QByteArray", 2, Smoke::t_class|Smoke::tf_stack },	//3
    { "QChildEvent*", 3, Smoke::t_class|Smoke::tf_ptr },	//4
    { "QEvent*", 4, Smoke::t_class|Smoke::tf_ptr },	//5
    { "QFlags<Qt::KeyboardModifier>", 0, Smoke::t_uint|Smoke::tf_stack },	//6
    { "QList<QTestAccessibilityEvent>", 0, Smoke::t_voidp|Smoke::tf_stack },	//7
    { "QMetaObject::Call", 6, Smoke::t_enum|Smoke::tf_stack },	//8
    { "QObject*", 7, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QPoint", 8, Smoke::t_class|Smoke::tf_stack },	//10
    { "QRegExp&", 9, Smoke::t_class|Smoke::tf_ref },	//11
    { "QSignalSpy*", 10, Smoke::t_class|Smoke::tf_ptr },	//12
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//13
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//14
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//15
    { "QTest::KeyAction", 11, Smoke::t_enum|Smoke::tf_stack },	//16
    { "QTest::MouseAction", 11, Smoke::t_enum|Smoke::tf_stack },	//17
    { "QTest::QBenchmarkMetric", 11, Smoke::t_enum|Smoke::tf_stack },	//18
    { "QTest::SkipMode", 11, Smoke::t_enum|Smoke::tf_stack },	//19
    { "QTest::TestFailMode", 11, Smoke::t_enum|Smoke::tf_stack },	//20
    { "QTestAccessibilityEvent", 13, Smoke::t_class|Smoke::tf_stack },	//21
    { "QTestAccessibilityEvent*", 13, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QTestData&", 14, Smoke::t_class|Smoke::tf_ref },	//23
    { "QTestDelayEvent*", 15, Smoke::t_class|Smoke::tf_ptr },	//24
    { "QTestEvent*", 16, Smoke::t_class|Smoke::tf_ptr },	//25
    { "QTestEventList*", 17, Smoke::t_class|Smoke::tf_ptr },	//26
    { "QTestEventLoop&", 18, Smoke::t_class|Smoke::tf_ref },	//27
    { "QTestEventLoop*", 18, Smoke::t_class|Smoke::tf_ptr },	//28
    { "QTestKeyClicksEvent*", 19, Smoke::t_class|Smoke::tf_ptr },	//29
    { "QTestKeyEvent*", 20, Smoke::t_class|Smoke::tf_ptr },	//30
    { "QTestMouseEvent*", 21, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QTestTable*", 22, Smoke::t_class|Smoke::tf_ptr },	//32
    { "QTimerEvent*", 23, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QWidget*", 24, Smoke::t_class|Smoke::tf_ptr },	//34
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//35
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//36
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//37
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//38
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//40
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//41
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//42
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//43
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//44
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//45
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//46
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//47
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//48
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//49
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//50
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//51
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//52
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//53
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//54
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//55
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//56
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//57
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//58
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//59
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//100
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//102
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//103
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//106
    { "QtMsgType", 5, Smoke::t_enum|Smoke::tf_stack },	//107
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//108
    { "char", 0, Smoke::t_char|Smoke::tf_stack },	//109
    { "char*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//110
    { "char**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//111
    { "const QMetaObject&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//112
    { "const QMetaObject*", 6, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//113
    { "const QRegExp&", 9, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//114
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//115
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//116
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//117
    { "const QTestAccessibilityEvent&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//118
    { "const QTestDelayEvent&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//119
    { "const QTestEvent&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//120
    { "const QTestEventList&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//121
    { "const QTestKeyClicksEvent&", 19, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//122
    { "const QTestKeyEvent&", 20, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//123
    { "const QTestMouseEvent&", 21, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//124
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//125
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//126
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//127
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//128
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//129
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//130
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//131
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    125, 0,	//1  const char*
    5, 0,	//3  QEvent*
    9, 5, 0,	//5  QObject*, QEvent*
    33, 0,	//8  QTimerEvent*
    4, 0,	//10  QChildEvent*
    9, 125, 0,	//12  QObject*, const char*
    8, 128, 130, 0,	//15  QMetaObject::Call, int, void**
    128, 125, 0,	//19  int, const char*
    125, 128, 0,	//22  const char*, int
    108, 125, 110, 110, 125, 125, 125, 128, 0,	//25  bool, const char*, char*, char*, const char*, const char*, const char*, int
    34, 73, 6, 128, 0,	//34  QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int
    34, 73, 0,	//39  QWidget*, Qt::Key
    34, 73, 6, 0,	//42  QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>
    107, 125, 0,	//46  QtMsgType, const char*
    34, 109, 6, 128, 0,	//49  QWidget*, char, QFlags<Qt::KeyboardModifier>, int
    34, 109, 0,	//54  QWidget*, char
    34, 109, 6, 0,	//57  QWidget*, char, QFlags<Qt::KeyboardModifier>
    73, 0,	//61  Qt::Key
    17, 34, 79, 6, 10, 128, 0,	//63  QTest::MouseAction, QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int
    17, 34, 79, 6, 10, 0,	//70  QTest::MouseAction, QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint
    108, 125, 125, 125, 128, 0,	//76  bool, const char*, const char*, const char*, int
    127, 18, 0,	//82  double, QTest::QBenchmarkMetric
    109, 0,	//85  char
    128, 0,	//87  int
    16, 34, 109, 6, 128, 0,	//89  QTest::KeyAction, QWidget*, char, QFlags<Qt::KeyboardModifier>, int
    16, 34, 109, 0,	//95  QTest::KeyAction, QWidget*, char
    16, 34, 109, 6, 0,	//99  QTest::KeyAction, QWidget*, char, QFlags<Qt::KeyboardModifier>
    34, 115, 6, 128, 0,	//104  QWidget*, const QString&, QFlags<Qt::KeyboardModifier>, int
    34, 115, 0,	//109  QWidget*, const QString&
    34, 115, 6, 0,	//112  QWidget*, const QString&, QFlags<Qt::KeyboardModifier>
    16, 34, 73, 109, 6, 128, 0,	//116  QTest::KeyAction, QWidget*, Qt::Key, char, QFlags<Qt::KeyboardModifier>, int
    16, 34, 73, 109, 6, 0,	//123  QTest::KeyAction, QWidget*, Qt::Key, char, QFlags<Qt::KeyboardModifier>
    126, 126, 125, 125, 125, 128, 0,	//129  const void*, const void*, const char*, const char*, const char*, int
    125, 125, 125, 125, 125, 128, 0,	//136  const char*, const char*, const char*, const char*, const char*, int
    34, 79, 6, 10, 128, 0,	//143  QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int
    34, 79, 0,	//149  QWidget*, Qt::MouseButton
    34, 79, 6, 0,	//152  QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>
    34, 79, 6, 10, 0,	//156  QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint
    16, 34, 73, 13, 6, 128, 0,	//161  QTest::KeyAction, QWidget*, Qt::Key, QString, QFlags<Qt::KeyboardModifier>, int
    16, 34, 73, 13, 6, 0,	//168  QTest::KeyAction, QWidget*, Qt::Key, QString, QFlags<Qt::KeyboardModifier>
    126, 0,	//174  const void*
    108, 125, 125, 128, 0,	//176  bool, const char*, const char*, int
    34, 0,	//181  QWidget*
    125, 125, 20, 125, 128, 0,	//183  const char*, const char*, QTest::TestFailMode, const char*, int
    125, 19, 125, 128, 0,	//189  const char*, QTest::SkipMode, const char*, int
    125, 125, 128, 0,	//194  const char*, const char*, int
    34, 10, 128, 0,	//198  QWidget*, QPoint, int
    34, 10, 0,	//202  QWidget*, QPoint
    34, 108, 128, 6, 13, 108, 128, 0,	//205  QWidget*, bool, int, QFlags<Qt::KeyboardModifier>, QString, bool, int
    34, 108, 128, 6, 13, 108, 0,	//213  QWidget*, bool, int, QFlags<Qt::KeyboardModifier>, QString, bool
    9, 128, 111, 0,	//220  QObject*, int, char**
    9, 0,	//224  QObject*
    9, 128, 0,	//226  QObject*, int
    16, 34, 73, 6, 128, 0,	//229  QTest::KeyAction, QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int
    16, 34, 73, 0,	//235  QTest::KeyAction, QWidget*, Qt::Key
    16, 34, 73, 6, 0,	//239  QTest::KeyAction, QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>
    9, 116, 0,	//244  QObject*, const QStringList&
    118, 0,	//247  const QTestAccessibilityEvent&
    9, 128, 128, 0,	//249  QObject*, int, int
    128, 126, 0,	//253  int, const void*
    119, 0,	//256  const QTestDelayEvent&
    120, 0,	//258  const QTestEvent&
    121, 0,	//260  const QTestEventList&
    73, 6, 128, 0,	//262  Qt::Key, QFlags<Qt::KeyboardModifier>, int
    16, 73, 6, 128, 0,	//266  QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>, int
    109, 6, 128, 0,	//271  char, QFlags<Qt::KeyboardModifier>, int
    115, 6, 128, 0,	//275  const QString&, QFlags<Qt::KeyboardModifier>, int
    16, 109, 6, 128, 0,	//279  QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>, int
    79, 6, 10, 128, 0,	//284  Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int
    10, 128, 0,	//289  QPoint, int
    73, 6, 0,	//292  Qt::Key, QFlags<Qt::KeyboardModifier>
    16, 73, 0,	//295  QTest::KeyAction, Qt::Key
    16, 73, 6, 0,	//298  QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>
    109, 6, 0,	//302  char, QFlags<Qt::KeyboardModifier>
    115, 0,	//305  const QString&
    115, 6, 0,	//307  const QString&, QFlags<Qt::KeyboardModifier>
    16, 109, 0,	//310  QTest::KeyAction, char
    16, 109, 6, 0,	//313  QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>
    79, 0,	//317  Qt::MouseButton
    79, 6, 0,	//319  Qt::MouseButton, QFlags<Qt::KeyboardModifier>
    79, 6, 10, 0,	//322  Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint
    10, 0,	//326  QPoint
    125, 125, 0,	//328  const char*, const char*
    122, 0,	//331  const QTestKeyClicksEvent&
    123, 0,	//333  const QTestKeyEvent&
    16, 0,	//335  QTest::KeyAction
    6, 0,	//337  QFlags<Qt::KeyboardModifier>
    17, 79, 6, 10, 128, 0,	//339  QTest::MouseAction, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int
    124, 0,	//345  const QTestMouseEvent&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "Abort",	//1
    "BitsPerSecond",	//2
    "BytesPerSecond",	//3
    "CPUTicks",	//4
    "Click",	//5
    "Continue",	//6
    "Events",	//7
    "FramesPerSecond",	//8
    "InstructionReads",	//9
    "MouseClick",	//10
    "MouseDClick",	//11
    "MouseMove",	//12
    "MousePress",	//13
    "MouseRelease",	//14
    "Press",	//15
    "QSignalSpy",	//16
    "QSignalSpy#$",	//17
    "QTestAccessibilityEvent",	//18
    "QTestAccessibilityEvent#",	//19
    "QTestAccessibilityEvent#$",	//20
    "QTestAccessibilityEvent#$$",	//21
    "QTestDelayEvent",	//22
    "QTestDelayEvent#",	//23
    "QTestDelayEvent$",	//24
    "QTestEvent",	//25
    "QTestEvent#",	//26
    "QTestEventList",	//27
    "QTestEventList#",	//28
    "QTestEventLoop",	//29
    "QTestEventLoop#",	//30
    "QTestKeyClicksEvent",	//31
    "QTestKeyClicksEvent#",	//32
    "QTestKeyClicksEvent$$$",	//33
    "QTestKeyEvent",	//34
    "QTestKeyEvent#",	//35
    "QTestKeyEvent$$$$",	//36
    "QTestMouseEvent",	//37
    "QTestMouseEvent#",	//38
    "QTestMouseEvent$$$#$",	//39
    "Release",	//40
    "SkipAll",	//41
    "SkipSingle",	//42
    "WalltimeMilliseconds",	//43
    "_action",	//44
    "_ascii",	//45
    "_delay",	//46
    "_key",	//47
    "_modifiers",	//48
    "addColumnInternal",	//49
    "addColumnInternal$$",	//50
    "addDelay",	//51
    "addDelay$",	//52
    "addKeyClick",	//53
    "addKeyClick$",	//54
    "addKeyClick$$",	//55
    "addKeyClick$$$",	//56
    "addKeyClicks",	//57
    "addKeyClicks$",	//58
    "addKeyClicks$$",	//59
    "addKeyClicks$$$",	//60
    "addKeyEvent",	//61
    "addKeyEvent$$",	//62
    "addKeyEvent$$$",	//63
    "addKeyEvent$$$$",	//64
    "addKeyPress",	//65
    "addKeyPress$",	//66
    "addKeyPress$$",	//67
    "addKeyPress$$$",	//68
    "addKeyRelease",	//69
    "addKeyRelease$",	//70
    "addKeyRelease$$",	//71
    "addKeyRelease$$$",	//72
    "addMouseClick",	//73
    "addMouseClick$",	//74
    "addMouseClick$$",	//75
    "addMouseClick$$#",	//76
    "addMouseClick$$#$",	//77
    "addMouseDClick",	//78
    "addMouseDClick$",	//79
    "addMouseDClick$$",	//80
    "addMouseDClick$$#",	//81
    "addMouseDClick$$#$",	//82
    "addMouseMove",	//83
    "addMouseMove#",	//84
    "addMouseMove#$",	//85
    "addMousePress",	//86
    "addMousePress$",	//87
    "addMousePress$$",	//88
    "addMousePress$$#",	//89
    "addMousePress$$#$",	//90
    "addMouseRelease",	//91
    "addMouseRelease$",	//92
    "addMouseRelease$$",	//93
    "addMouseRelease$$#",	//94
    "addMouseRelease$$#$",	//95
    "append",	//96
    "append$$",	//97
    "asciiToKey",	//98
    "asciiToKey$",	//99
    "changeInterval",	//100
    "changeInterval$",	//101
    "child",	//102
    "childEvent",	//103
    "cleanup",	//104
    "clear",	//105
    "clearEvents",	//106
    "clone",	//107
    "compare_helper",	//108
    "compare_helper$$$$",	//109
    "compare_helper$$$$$$$$",	//110
    "compare_ptr_helper",	//111
    "compare_ptr_helper$$$$$$",	//112
    "compare_string_helper",	//113
    "compare_string_helper$$$$$$",	//114
    "connectNotify",	//115
    "currentAppName",	//116
    "currentDataTag",	//117
    "currentTestFailed",	//118
    "currentTestFunction",	//119
    "customEvent",	//120
    "data",	//121
    "data$",	//122
    "dataCount",	//123
    "dataTag",	//124
    "disconnectNotify",	//125
    "enterLoop",	//126
    "enterLoop$",	//127
    "event",	//128
    "eventFilter",	//129
    "events",	//130
    "exitLoop",	//131
    "ignoreMessage",	//132
    "ignoreMessage$$",	//133
    "initialize",	//134
    "instance",	//135
    "isValid",	//136
    "keyClick",	//137
    "keyClick#$",	//138
    "keyClick#$$",	//139
    "keyClick#$$$",	//140
    "keyClicks",	//141
    "keyClicks#$",	//142
    "keyClicks#$$",	//143
    "keyClicks#$$$",	//144
    "keyEvent",	//145
    "keyEvent$#$",	//146
    "keyEvent$#$$",	//147
    "keyEvent$#$$$",	//148
    "keyPress",	//149
    "keyPress#$",	//150
    "keyPress#$$",	//151
    "keyPress#$$$",	//152
    "keyRelease",	//153
    "keyRelease#$",	//154
    "keyRelease#$$",	//155
    "keyRelease#$$$",	//156
    "keyToAscii",	//157
    "keyToAscii$",	//158
    "metaObject",	//159
    "mouseClick",	//160
    "mouseClick#$",	//161
    "mouseClick#$$",	//162
    "mouseClick#$$#",	//163
    "mouseClick#$$#$",	//164
    "mouseDClick",	//165
    "mouseDClick#$",	//166
    "mouseDClick#$$",	//167
    "mouseDClick#$$#",	//168
    "mouseDClick#$$#$",	//169
    "mouseEvent",	//170
    "mouseEvent$#$$#",	//171
    "mouseEvent$#$$#$",	//172
    "mouseMove",	//173
    "mouseMove#",	//174
    "mouseMove##",	//175
    "mouseMove##$",	//176
    "mousePress",	//177
    "mousePress#$",	//178
    "mousePress#$$",	//179
    "mousePress#$$#",	//180
    "mousePress#$$#$",	//181
    "mouseRelease",	//182
    "mouseRelease#$",	//183
    "mouseRelease#$$",	//184
    "mouseRelease#$$#",	//185
    "mouseRelease#$$#$",	//186
    "newRow",	//187
    "newRow$",	//188
    "object",	//189
    "operator==",	//190
    "operator==#",	//191
    "parent",	//192
    "qData",	//193
    "qData$$",	//194
    "qElementData",	//195
    "qElementData$$",	//196
    "qExec",	//197
    "qExec#",	//198
    "qExec#$",	//199
    "qExec#$?",	//200
    "qExec#?",	//201
    "qExpectFail",	//202
    "qExpectFail$$$$$",	//203
    "qFail",	//204
    "qFail$$$",	//205
    "qGlobalData",	//206
    "qGlobalData$$",	//207
    "qSkip",	//208
    "qSkip$$$$",	//209
    "qSleep",	//210
    "qSleep$",	//211
    "qVerify",	//212
    "qVerify$$$$$",	//213
    "qWait",	//214
    "qWait$",	//215
    "qWaitForWindowShown",	//216
    "qWaitForWindowShown#",	//217
    "qWarn",	//218
    "qWarn$",	//219
    "qt_metacall",	//220
    "qt_metacall$$?",	//221
    "qt_metacast",	//222
    "qt_metacast$",	//223
    "sendKeyEvent",	//224
    "sendKeyEvent$#$$$",	//225
    "sendKeyEvent$#$$$$",	//226
    "setBenchmarkResult",	//227
    "setBenchmarkResult$$",	//228
    "setChild",	//229
    "setChild$",	//230
    "setEvent",	//231
    "setEvent$",	//232
    "setObject",	//233
    "setObject#",	//234
    "set_action",	//235
    "set_action$",	//236
    "set_ascii",	//237
    "set_ascii$",	//238
    "set_delay",	//239
    "set_delay$",	//240
    "set_key",	//241
    "set_key$",	//242
    "set_modifiers",	//243
    "set_modifiers$",	//244
    "signal",	//245
    "simulate",	//246
    "simulate#",	//247
    "simulateEvent",	//248
    "simulateEvent#$$$$$",	//249
    "simulateEvent#$$$$$$",	//250
    "staticMetaObject",	//251
    "testObject",	//252
    "timeout",	//253
    "timerEvent",	//254
    "timerEvent#",	//255
    "toHexRepresentation",	//256
    "toHexRepresentation$$",	//257
    "toString",	//258
    "toString$",	//259
    "tr",	//260
    "tr$",	//261
    "tr$$",	//262
    "tr$$$",	//263
    "trUtf8",	//264
    "trUtf8$",	//265
    "trUtf8$$",	//266
    "trUtf8$$$",	//267
    "verifyEvent",	//268
    "verifyEvent#",	//269
    "verifyEvent#$$",	//270
    "~QSignalSpy",	//271
    "~QTestAccessibilityEvent",	//272
    "~QTestData",	//273
    "~QTestDelayEvent",	//274
    "~QTestEvent",	//275
    "~QTestEventList",	//276
    "~QTestEventLoop",	//277
    "~QTestKeyClicksEvent",	//278
    "~QTestKeyEvent",	//279
    "~QTestMouseEvent",	//280
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {7, 159, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 113, 0},	//1 QObject::metaObject() const
    {7, 222, 1, 1, Smoke::mf_virtual, 129, 0},	//2 QObject::qt_metacast(const char*)
    {7, 128, 3, 1, Smoke::mf_virtual, 108, 0},	//3 QObject::event(QEvent*)
    {7, 129, 5, 2, Smoke::mf_virtual, 108, 0},	//4 QObject::eventFilter(QObject*, QEvent*)
    {7, 254, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//5 QObject::timerEvent(QTimerEvent*)
    {7, 103, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 QObject::childEvent(QChildEvent*)
    {7, 120, 3, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 QObject::customEvent(QEvent*)
    {7, 115, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//8 QObject::connectNotify(const char*)
    {7, 125, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//9 QObject::disconnectNotify(const char*)
    {10, 16, 12, 2, Smoke::mf_ctor, 12, 1},	//10 QSignalSpy::QSignalSpy(QObject*, const char*)
    {10, 136, 0, 0, Smoke::mf_const, 108, 2},	//11 QSignalSpy::isValid() const
    {10, 245, 0, 0, Smoke::mf_const, 3, 3},	//12 QSignalSpy::signal() const
    {10, 220, 15, 3, Smoke::mf_virtual, 128, 4},	//13 QSignalSpy::qt_metacall(QMetaObject::Call, int, void**)
    {10, 271, 0, 0, Smoke::mf_dtor, 0, 5 },	//14 QSignalSpy::~QSignalSpy()
    {11, 49, 19, 2, Smoke::mf_static, 0, 1},	//15 QTest::addColumnInternal(int, const char*)
    {11, 206, 22, 2, Smoke::mf_static, 129, 2},	//16 QTest::qGlobalData(const char*, int)
    {11, 108, 25, 8, Smoke::mf_static, 108, 3},	//17 QTest::compare_helper(bool, const char*, char*, char*, const char*, const char*, const char*, int)
    {11, 149, 34, 4, Smoke::mf_static, 0, 4},	//18 QTest::keyPress(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {11, 149, 39, 2, Smoke::mf_static, 0, 5},	//19 QTest::keyPress(QWidget*, Qt::Key)
    {11, 149, 42, 3, Smoke::mf_static, 0, 6},	//20 QTest::keyPress(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    {11, 132, 46, 2, Smoke::mf_static, 0, 7},	//21 QTest::ignoreMessage(QtMsgType, const char*)
    {11, 149, 49, 4, Smoke::mf_static, 0, 8},	//22 QTest::keyPress(QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    {11, 149, 54, 2, Smoke::mf_static, 0, 9},	//23 QTest::keyPress(QWidget*, char)
    {11, 149, 57, 3, Smoke::mf_static, 0, 10},	//24 QTest::keyPress(QWidget*, char, QFlags<Qt::KeyboardModifier>)
    {11, 157, 61, 1, Smoke::mf_static, 109, 11},	//25 QTest::keyToAscii(Qt::Key)
    {11, 170, 63, 6, Smoke::mf_static, 0, 12},	//26 QTest::mouseEvent(QTest::MouseAction, QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {11, 170, 70, 5, Smoke::mf_static, 0, 13},	//27 QTest::mouseEvent(QTest::MouseAction, QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {11, 212, 76, 5, Smoke::mf_static, 108, 14},	//28 QTest::qVerify(bool, const char*, const char*, const char*, int)
    {11, 227, 82, 2, Smoke::mf_static, 0, 15},	//29 QTest::setBenchmarkResult(double, QTest::QBenchmarkMetric)
    {11, 117, 0, 0, Smoke::mf_static, 125, 16},	//30 QTest::currentDataTag()
    {11, 98, 85, 1, Smoke::mf_static, 73, 17},	//31 QTest::asciiToKey(char)
    {11, 210, 87, 1, Smoke::mf_static, 0, 18},	//32 QTest::qSleep(int)
    {11, 218, 1, 1, Smoke::mf_static, 0, 19},	//33 QTest::qWarn(const char*)
    {11, 145, 89, 5, Smoke::mf_static, 0, 20},	//34 QTest::keyEvent(QTest::KeyAction, QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    {11, 145, 95, 3, Smoke::mf_static, 0, 21},	//35 QTest::keyEvent(QTest::KeyAction, QWidget*, char)
    {11, 145, 99, 4, Smoke::mf_static, 0, 22},	//36 QTest::keyEvent(QTest::KeyAction, QWidget*, char, QFlags<Qt::KeyboardModifier>)
    {11, 141, 104, 4, Smoke::mf_static, 0, 23},	//37 QTest::keyClicks(QWidget*, const QString&, QFlags<Qt::KeyboardModifier>, int)
    {11, 141, 109, 2, Smoke::mf_static, 0, 24},	//38 QTest::keyClicks(QWidget*, const QString&)
    {11, 141, 112, 3, Smoke::mf_static, 0, 25},	//39 QTest::keyClicks(QWidget*, const QString&, QFlags<Qt::KeyboardModifier>)
    {11, 153, 34, 4, Smoke::mf_static, 0, 26},	//40 QTest::keyRelease(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {11, 153, 39, 2, Smoke::mf_static, 0, 27},	//41 QTest::keyRelease(QWidget*, Qt::Key)
    {11, 153, 42, 3, Smoke::mf_static, 0, 28},	//42 QTest::keyRelease(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    {11, 119, 0, 0, Smoke::mf_static, 125, 29},	//43 QTest::currentTestFunction()
    {11, 252, 0, 0, Smoke::mf_static, 9, 30},	//44 QTest::testObject()
    {11, 224, 116, 6, Smoke::mf_static, 0, 31},	//45 QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, char, QFlags<Qt::KeyboardModifier>, int)
    {11, 224, 123, 5, Smoke::mf_static, 0, 32},	//46 QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, char, QFlags<Qt::KeyboardModifier>)
    {11, 111, 129, 6, Smoke::mf_static, 108, 33},	//47 QTest::compare_ptr_helper(const void*, const void*, const char*, const char*, const char*, int)
    {11, 116, 0, 0, Smoke::mf_static, 125, 34},	//48 QTest::currentAppName()
    {11, 113, 136, 6, Smoke::mf_static, 108, 35},	//49 QTest::compare_string_helper(const char*, const char*, const char*, const char*, const char*, int)
    {11, 177, 143, 5, Smoke::mf_static, 0, 36},	//50 QTest::mousePress(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {11, 177, 149, 2, Smoke::mf_static, 0, 37},	//51 QTest::mousePress(QWidget*, Qt::MouseButton)
    {11, 177, 152, 3, Smoke::mf_static, 0, 38},	//52 QTest::mousePress(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {11, 177, 156, 4, Smoke::mf_static, 0, 39},	//53 QTest::mousePress(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {11, 214, 87, 1, Smoke::mf_static, 0, 40},	//54 QTest::qWait(int)
    {11, 224, 161, 6, Smoke::mf_static, 0, 41},	//55 QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, QString, QFlags<Qt::KeyboardModifier>, int)
    {11, 224, 168, 5, Smoke::mf_static, 0, 42},	//56 QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, QString, QFlags<Qt::KeyboardModifier>)
    {11, 137, 34, 4, Smoke::mf_static, 0, 43},	//57 QTest::keyClick(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {11, 137, 39, 2, Smoke::mf_static, 0, 44},	//58 QTest::keyClick(QWidget*, Qt::Key)
    {11, 137, 42, 3, Smoke::mf_static, 0, 45},	//59 QTest::keyClick(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    {11, 258, 174, 1, Smoke::mf_static, 110, 46},	//60 QTest::toString(const void*)
    {11, 187, 1, 1, Smoke::mf_static, 23, 47},	//61 QTest::newRow(const char*)
    {11, 160, 143, 5, Smoke::mf_static, 0, 48},	//62 QTest::mouseClick(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {11, 160, 149, 2, Smoke::mf_static, 0, 49},	//63 QTest::mouseClick(QWidget*, Qt::MouseButton)
    {11, 160, 152, 3, Smoke::mf_static, 0, 50},	//64 QTest::mouseClick(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {11, 160, 156, 4, Smoke::mf_static, 0, 51},	//65 QTest::mouseClick(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {11, 256, 22, 2, Smoke::mf_static, 110, 52},	//66 QTest::toHexRepresentation(const char*, int)
    {11, 108, 176, 4, Smoke::mf_static, 108, 53},	//67 QTest::compare_helper(bool, const char*, const char*, int)
    {11, 216, 181, 1, Smoke::mf_static, 108, 54},	//68 QTest::qWaitForWindowShown(QWidget*)
    {11, 153, 49, 4, Smoke::mf_static, 0, 55},	//69 QTest::keyRelease(QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    {11, 153, 54, 2, Smoke::mf_static, 0, 56},	//70 QTest::keyRelease(QWidget*, char)
    {11, 153, 57, 3, Smoke::mf_static, 0, 57},	//71 QTest::keyRelease(QWidget*, char, QFlags<Qt::KeyboardModifier>)
    {11, 165, 143, 5, Smoke::mf_static, 0, 58},	//72 QTest::mouseDClick(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {11, 165, 149, 2, Smoke::mf_static, 0, 59},	//73 QTest::mouseDClick(QWidget*, Qt::MouseButton)
    {11, 165, 152, 3, Smoke::mf_static, 0, 60},	//74 QTest::mouseDClick(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {11, 165, 156, 4, Smoke::mf_static, 0, 61},	//75 QTest::mouseDClick(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {11, 193, 22, 2, Smoke::mf_static, 129, 62},	//76 QTest::qData(const char*, int)
    {11, 202, 183, 5, Smoke::mf_static, 108, 63},	//77 QTest::qExpectFail(const char*, const char*, QTest::TestFailMode, const char*, int)
    {11, 118, 0, 0, Smoke::mf_static, 108, 64},	//78 QTest::currentTestFailed()
    {11, 208, 189, 4, Smoke::mf_static, 0, 65},	//79 QTest::qSkip(const char*, QTest::SkipMode, const char*, int)
    {11, 204, 194, 3, Smoke::mf_static, 0, 66},	//80 QTest::qFail(const char*, const char*, int)
    {11, 173, 198, 3, Smoke::mf_static, 0, 67},	//81 QTest::mouseMove(QWidget*, QPoint, int)
    {11, 173, 181, 1, Smoke::mf_static, 0, 68},	//82 QTest::mouseMove(QWidget*)
    {11, 173, 202, 2, Smoke::mf_static, 0, 69},	//83 QTest::mouseMove(QWidget*, QPoint)
    {11, 248, 205, 7, Smoke::mf_static, 0, 70},	//84 QTest::simulateEvent(QWidget*, bool, int, QFlags<Qt::KeyboardModifier>, QString, bool, int)
    {11, 248, 213, 6, Smoke::mf_static, 0, 71},	//85 QTest::simulateEvent(QWidget*, bool, int, QFlags<Qt::KeyboardModifier>, QString, bool)
    {11, 195, 22, 2, Smoke::mf_static, 129, 72},	//86 QTest::qElementData(const char*, int)
    {11, 182, 143, 5, Smoke::mf_static, 0, 73},	//87 QTest::mouseRelease(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {11, 182, 149, 2, Smoke::mf_static, 0, 74},	//88 QTest::mouseRelease(QWidget*, Qt::MouseButton)
    {11, 182, 152, 3, Smoke::mf_static, 0, 75},	//89 QTest::mouseRelease(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {11, 182, 156, 4, Smoke::mf_static, 0, 76},	//90 QTest::mouseRelease(QWidget*, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {11, 197, 220, 3, Smoke::mf_static, 128, 77},	//91 QTest::qExec(QObject*, int, char**)
    {11, 197, 224, 1, Smoke::mf_static, 128, 78},	//92 QTest::qExec(QObject*)
    {11, 197, 226, 2, Smoke::mf_static, 128, 79},	//93 QTest::qExec(QObject*, int)
    {11, 137, 49, 4, Smoke::mf_static, 0, 80},	//94 QTest::keyClick(QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    {11, 137, 54, 2, Smoke::mf_static, 0, 81},	//95 QTest::keyClick(QWidget*, char)
    {11, 137, 57, 3, Smoke::mf_static, 0, 82},	//96 QTest::keyClick(QWidget*, char, QFlags<Qt::KeyboardModifier>)
    {11, 145, 229, 5, Smoke::mf_static, 0, 83},	//97 QTest::keyEvent(QTest::KeyAction, QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {11, 145, 235, 3, Smoke::mf_static, 0, 84},	//98 QTest::keyEvent(QTest::KeyAction, QWidget*, Qt::Key)
    {11, 145, 239, 4, Smoke::mf_static, 0, 85},	//99 QTest::keyEvent(QTest::KeyAction, QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    {11, 197, 244, 2, Smoke::mf_static, 128, 86},	//100 QTest::qExec(QObject*, const QStringList&)
    {11, 258, 1, 1, Smoke::mf_static, 110, 87},	//101 QTest::toString(const char*)
    {11, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 88},	//102 QTest::Abort (enum)
    {11, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 20, 89},	//103 QTest::Continue (enum)
    {11, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 90},	//104 QTest::MousePress (enum)
    {11, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 91},	//105 QTest::MouseRelease (enum)
    {11, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 92},	//106 QTest::MouseClick (enum)
    {11, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 93},	//107 QTest::MouseDClick (enum)
    {11, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 94},	//108 QTest::MouseMove (enum)
    {11, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 95},	//109 QTest::Press (enum)
    {11, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 96},	//110 QTest::Release (enum)
    {11, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 16, 97},	//111 QTest::Click (enum)
    {11, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 98},	//112 QTest::SkipSingle (enum)
    {11, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 19, 99},	//113 QTest::SkipAll (enum)
    {11, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 100},	//114 QTest::FramesPerSecond (enum)
    {11, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 101},	//115 QTest::BitsPerSecond (enum)
    {11, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 102},	//116 QTest::BytesPerSecond (enum)
    {11, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 103},	//117 QTest::WalltimeMilliseconds (enum)
    {11, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 104},	//118 QTest::CPUTicks (enum)
    {11, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 105},	//119 QTest::InstructionReads (enum)
    {11, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 18, 106},	//120 QTest::Events (enum)
    {12, 134, 0, 0, Smoke::mf_static, 0, 1},	//121 QTestAccessibility::initialize()
    {12, 104, 0, 0, Smoke::mf_static, 0, 2},	//122 QTestAccessibility::cleanup()
    {12, 106, 0, 0, Smoke::mf_static, 0, 3},	//123 QTestAccessibility::clearEvents()
    {12, 130, 0, 0, Smoke::mf_static, 7, 4},	//124 QTestAccessibility::events()
    {12, 268, 247, 1, Smoke::mf_static, 108, 5},	//125 QTestAccessibility::verifyEvent(const QTestAccessibilityEvent&)
    {12, 268, 249, 3, Smoke::mf_static, 108, 6},	//126 QTestAccessibility::verifyEvent(QObject*, int, int)
    {13, 18, 249, 3, Smoke::mf_ctor, 22, 1},	//127 QTestAccessibilityEvent::QTestAccessibilityEvent(QObject*, int, int)
    {13, 190, 247, 1, Smoke::mf_const, 108, 2},	//128 QTestAccessibilityEvent::operator==(const QTestAccessibilityEvent&) const
    {13, 18, 247, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 22, 3},	//129 QTestAccessibilityEvent::QTestAccessibilityEvent(const QTestAccessibilityEvent&)
    {13, 18, 0, 0, Smoke::mf_ctor, 22, 4},	//130 QTestAccessibilityEvent::QTestAccessibilityEvent()
    {13, 18, 224, 1, Smoke::mf_ctor, 22, 5},	//131 QTestAccessibilityEvent::QTestAccessibilityEvent(QObject*)
    {13, 18, 226, 2, Smoke::mf_ctor, 22, 6},	//132 QTestAccessibilityEvent::QTestAccessibilityEvent(QObject*, int)
    {13, 189, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 9, 7},	//133 QTestAccessibilityEvent::object() const
    {13, 233, 224, 1, Smoke::mf_attribute, 0, 8},	//134 QTestAccessibilityEvent::setObject(QObject*)
    {13, 102, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 128, 9},	//135 QTestAccessibilityEvent::child() const
    {13, 229, 87, 1, Smoke::mf_attribute, 0, 10},	//136 QTestAccessibilityEvent::setChild(int)
    {13, 128, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 128, 11},	//137 QTestAccessibilityEvent::event() const
    {13, 231, 87, 1, Smoke::mf_attribute, 0, 12},	//138 QTestAccessibilityEvent::setEvent(int)
    {13, 272, 0, 0, Smoke::mf_dtor, 0, 13 },	//139 QTestAccessibilityEvent::~QTestAccessibilityEvent()
    {14, 96, 253, 2, 0, 0, 1},	//140 QTestData::append(int, const void*)
    {14, 121, 87, 1, Smoke::mf_const, 129, 2},	//141 QTestData::data(int) const
    {14, 124, 0, 0, Smoke::mf_const, 125, 3},	//142 QTestData::dataTag() const
    {14, 192, 0, 0, Smoke::mf_const, 32, 4},	//143 QTestData::parent() const
    {14, 123, 0, 0, Smoke::mf_const, 128, 5},	//144 QTestData::dataCount() const
    {14, 273, 0, 0, Smoke::mf_dtor, 0, 6 },	//145 QTestData::~QTestData()
    {15, 22, 87, 1, Smoke::mf_ctor, 24, 1},	//146 QTestDelayEvent::QTestDelayEvent(int)
    {15, 107, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 25, 2},	//147 QTestDelayEvent::clone() const
    {15, 246, 181, 1, Smoke::mf_virtual, 0, 3},	//148 QTestDelayEvent::simulate(QWidget*)
    {15, 22, 256, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 24, 4},	//149 QTestDelayEvent::QTestDelayEvent(const QTestDelayEvent&)
    {15, 274, 0, 0, Smoke::mf_dtor, 0, 5 },	//150 QTestDelayEvent::~QTestDelayEvent()
    {16, 246, 181, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//151 QTestEvent::simulate(QWidget*) [pure virtual]
    {16, 107, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 25, 2},	//152 QTestEvent::clone() const [pure virtual]
    {16, 25, 0, 0, Smoke::mf_ctor, 25, 3},	//153 QTestEvent::QTestEvent()
    {16, 25, 258, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 25, 4},	//154 QTestEvent::QTestEvent(const QTestEvent&)
    {16, 275, 0, 0, Smoke::mf_dtor, 0, 5 },	//155 QTestEvent::~QTestEvent()
    {17, 27, 0, 0, Smoke::mf_ctor, 26, 1},	//156 QTestEventList::QTestEventList()
    {17, 27, 260, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 26, 2},	//157 QTestEventList::QTestEventList(const QTestEventList&)
    {17, 105, 0, 0, 0, 0, 3},	//158 QTestEventList::clear()
    {17, 53, 262, 3, 0, 0, 4},	//159 QTestEventList::addKeyClick(Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {17, 65, 262, 3, 0, 0, 5},	//160 QTestEventList::addKeyPress(Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {17, 69, 262, 3, 0, 0, 6},	//161 QTestEventList::addKeyRelease(Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {17, 61, 266, 4, 0, 0, 7},	//162 QTestEventList::addKeyEvent(QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {17, 53, 271, 3, 0, 0, 8},	//163 QTestEventList::addKeyClick(char, QFlags<Qt::KeyboardModifier>, int)
    {17, 65, 271, 3, 0, 0, 9},	//164 QTestEventList::addKeyPress(char, QFlags<Qt::KeyboardModifier>, int)
    {17, 69, 271, 3, 0, 0, 10},	//165 QTestEventList::addKeyRelease(char, QFlags<Qt::KeyboardModifier>, int)
    {17, 57, 275, 3, 0, 0, 11},	//166 QTestEventList::addKeyClicks(const QString&, QFlags<Qt::KeyboardModifier>, int)
    {17, 61, 279, 4, 0, 0, 12},	//167 QTestEventList::addKeyEvent(QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>, int)
    {17, 86, 284, 4, 0, 0, 13},	//168 QTestEventList::addMousePress(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {17, 91, 284, 4, 0, 0, 14},	//169 QTestEventList::addMouseRelease(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {17, 73, 284, 4, 0, 0, 15},	//170 QTestEventList::addMouseClick(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {17, 78, 284, 4, 0, 0, 16},	//171 QTestEventList::addMouseDClick(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {17, 83, 289, 2, 0, 0, 17},	//172 QTestEventList::addMouseMove(QPoint, int)
    {17, 51, 87, 1, 0, 0, 18},	//173 QTestEventList::addDelay(int)
    {17, 246, 181, 1, 0, 0, 19},	//174 QTestEventList::simulate(QWidget*)
    {17, 53, 61, 1, 0, 0, 20},	//175 QTestEventList::addKeyClick(Qt::Key)
    {17, 53, 292, 2, 0, 0, 21},	//176 QTestEventList::addKeyClick(Qt::Key, QFlags<Qt::KeyboardModifier>)
    {17, 65, 61, 1, 0, 0, 22},	//177 QTestEventList::addKeyPress(Qt::Key)
    {17, 65, 292, 2, 0, 0, 23},	//178 QTestEventList::addKeyPress(Qt::Key, QFlags<Qt::KeyboardModifier>)
    {17, 69, 61, 1, 0, 0, 24},	//179 QTestEventList::addKeyRelease(Qt::Key)
    {17, 69, 292, 2, 0, 0, 25},	//180 QTestEventList::addKeyRelease(Qt::Key, QFlags<Qt::KeyboardModifier>)
    {17, 61, 295, 2, 0, 0, 26},	//181 QTestEventList::addKeyEvent(QTest::KeyAction, Qt::Key)
    {17, 61, 298, 3, 0, 0, 27},	//182 QTestEventList::addKeyEvent(QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>)
    {17, 53, 85, 1, 0, 0, 28},	//183 QTestEventList::addKeyClick(char)
    {17, 53, 302, 2, 0, 0, 29},	//184 QTestEventList::addKeyClick(char, QFlags<Qt::KeyboardModifier>)
    {17, 65, 85, 1, 0, 0, 30},	//185 QTestEventList::addKeyPress(char)
    {17, 65, 302, 2, 0, 0, 31},	//186 QTestEventList::addKeyPress(char, QFlags<Qt::KeyboardModifier>)
    {17, 69, 85, 1, 0, 0, 32},	//187 QTestEventList::addKeyRelease(char)
    {17, 69, 302, 2, 0, 0, 33},	//188 QTestEventList::addKeyRelease(char, QFlags<Qt::KeyboardModifier>)
    {17, 57, 305, 1, 0, 0, 34},	//189 QTestEventList::addKeyClicks(const QString&)
    {17, 57, 307, 2, 0, 0, 35},	//190 QTestEventList::addKeyClicks(const QString&, QFlags<Qt::KeyboardModifier>)
    {17, 61, 310, 2, 0, 0, 36},	//191 QTestEventList::addKeyEvent(QTest::KeyAction, char)
    {17, 61, 313, 3, 0, 0, 37},	//192 QTestEventList::addKeyEvent(QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>)
    {17, 86, 317, 1, 0, 0, 38},	//193 QTestEventList::addMousePress(Qt::MouseButton)
    {17, 86, 319, 2, 0, 0, 39},	//194 QTestEventList::addMousePress(Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {17, 86, 322, 3, 0, 0, 40},	//195 QTestEventList::addMousePress(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {17, 91, 317, 1, 0, 0, 41},	//196 QTestEventList::addMouseRelease(Qt::MouseButton)
    {17, 91, 319, 2, 0, 0, 42},	//197 QTestEventList::addMouseRelease(Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {17, 91, 322, 3, 0, 0, 43},	//198 QTestEventList::addMouseRelease(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {17, 73, 317, 1, 0, 0, 44},	//199 QTestEventList::addMouseClick(Qt::MouseButton)
    {17, 73, 319, 2, 0, 0, 45},	//200 QTestEventList::addMouseClick(Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {17, 73, 322, 3, 0, 0, 46},	//201 QTestEventList::addMouseClick(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {17, 78, 317, 1, 0, 0, 47},	//202 QTestEventList::addMouseDClick(Qt::MouseButton)
    {17, 78, 319, 2, 0, 0, 48},	//203 QTestEventList::addMouseDClick(Qt::MouseButton, QFlags<Qt::KeyboardModifier>)
    {17, 78, 322, 3, 0, 0, 49},	//204 QTestEventList::addMouseDClick(Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint)
    {17, 83, 0, 0, 0, 0, 50},	//205 QTestEventList::addMouseMove()
    {17, 83, 326, 1, 0, 0, 51},	//206 QTestEventList::addMouseMove(QPoint)
    {17, 276, 0, 0, Smoke::mf_dtor, 0, 52 },	//207 QTestEventList::~QTestEventList()
    {18, 159, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 113, 1},	//208 QTestEventLoop::metaObject() const
    {18, 222, 1, 1, Smoke::mf_virtual, 129, 2},	//209 QTestEventLoop::qt_metacast(const char*)
    {18, 260, 328, 2, Smoke::mf_static, 13, 3},	//210 QTestEventLoop::tr(const char*, const char*)
    {18, 264, 328, 2, Smoke::mf_static, 13, 4},	//211 QTestEventLoop::trUtf8(const char*, const char*)
    {18, 260, 194, 3, Smoke::mf_static, 13, 5},	//212 QTestEventLoop::tr(const char*, const char*, int)
    {18, 264, 194, 3, Smoke::mf_static, 13, 6},	//213 QTestEventLoop::trUtf8(const char*, const char*, int)
    {18, 220, 15, 3, Smoke::mf_virtual, 128, 7},	//214 QTestEventLoop::qt_metacall(QMetaObject::Call, int, void**)
    {18, 29, 224, 1, Smoke::mf_ctor, 28, 8},	//215 QTestEventLoop::QTestEventLoop(QObject*)
    {18, 126, 87, 1, 0, 0, 9},	//216 QTestEventLoop::enterLoop(int)
    {18, 100, 87, 1, 0, 0, 10},	//217 QTestEventLoop::changeInterval(int)
    {18, 253, 0, 0, Smoke::mf_const, 108, 11},	//218 QTestEventLoop::timeout() const
    {18, 135, 0, 0, Smoke::mf_static, 27, 12},	//219 QTestEventLoop::instance()
    {18, 131, 0, 0, Smoke::mf_slot, 0, 13},	//220 QTestEventLoop::exitLoop()
    {18, 254, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//221 QTestEventLoop::timerEvent(QTimerEvent*)
    {18, 260, 1, 1, Smoke::mf_static, 13, 15},	//222 QTestEventLoop::tr(const char*)
    {18, 264, 1, 1, Smoke::mf_static, 13, 16},	//223 QTestEventLoop::trUtf8(const char*)
    {18, 29, 0, 0, Smoke::mf_ctor, 28, 17},	//224 QTestEventLoop::QTestEventLoop()
    {18, 251, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 112, 18},	//225 QTestEventLoop::staticMetaObject() const
    {18, 277, 0, 0, Smoke::mf_dtor, 0, 19 },	//226 QTestEventLoop::~QTestEventLoop()
    {19, 31, 275, 3, Smoke::mf_ctor, 29, 1},	//227 QTestKeyClicksEvent::QTestKeyClicksEvent(const QString&, QFlags<Qt::KeyboardModifier>, int)
    {19, 107, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 25, 2},	//228 QTestKeyClicksEvent::clone() const
    {19, 246, 181, 1, Smoke::mf_virtual, 0, 3},	//229 QTestKeyClicksEvent::simulate(QWidget*)
    {19, 31, 331, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 29, 4},	//230 QTestKeyClicksEvent::QTestKeyClicksEvent(const QTestKeyClicksEvent&)
    {19, 278, 0, 0, Smoke::mf_dtor, 0, 5 },	//231 QTestKeyClicksEvent::~QTestKeyClicksEvent()
    {20, 34, 266, 4, Smoke::mf_ctor, 30, 1},	//232 QTestKeyEvent::QTestKeyEvent(QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    {20, 34, 279, 4, Smoke::mf_ctor, 30, 2},	//233 QTestKeyEvent::QTestKeyEvent(QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>, int)
    {20, 107, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 25, 3},	//234 QTestKeyEvent::clone() const
    {20, 246, 181, 1, Smoke::mf_virtual, 0, 4},	//235 QTestKeyEvent::simulate(QWidget*)
    {20, 34, 333, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 30, 5},	//236 QTestKeyEvent::QTestKeyEvent(const QTestKeyEvent&)
    {20, 44, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 16, 6},	//237 QTestKeyEvent::_action() const
    {20, 235, 335, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 7},	//238 QTestKeyEvent::set_action(QTest::KeyAction)
    {20, 46, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 128, 8},	//239 QTestKeyEvent::_delay() const
    {20, 239, 87, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 9},	//240 QTestKeyEvent::set_delay(int)
    {20, 48, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 6, 10},	//241 QTestKeyEvent::_modifiers() const
    {20, 243, 337, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 11},	//242 QTestKeyEvent::set_modifiers(QFlags<Qt::KeyboardModifier>)
    {20, 45, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 109, 12},	//243 QTestKeyEvent::_ascii() const
    {20, 237, 85, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 13},	//244 QTestKeyEvent::set_ascii(char)
    {20, 47, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 73, 14},	//245 QTestKeyEvent::_key() const
    {20, 241, 61, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 15},	//246 QTestKeyEvent::set_key(Qt::Key)
    {20, 279, 0, 0, Smoke::mf_dtor, 0, 16 },	//247 QTestKeyEvent::~QTestKeyEvent()
    {21, 37, 339, 5, Smoke::mf_ctor, 31, 1},	//248 QTestMouseEvent::QTestMouseEvent(QTest::MouseAction, Qt::MouseButton, QFlags<Qt::KeyboardModifier>, QPoint, int)
    {21, 107, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 25, 2},	//249 QTestMouseEvent::clone() const
    {21, 246, 181, 1, Smoke::mf_virtual, 0, 3},	//250 QTestMouseEvent::simulate(QWidget*)
    {21, 37, 345, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 31, 4},	//251 QTestMouseEvent::QTestMouseEvent(const QTestMouseEvent&)
    {21, 280, 0, 0, Smoke::mf_dtor, 0, 5 },	//252 QTestMouseEvent::~QTestMouseEvent()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    129,  // QTestAccessibilityEvent::QTestAccessibilityEvent(const QTestAccessibilityEvent&)
    131,  // QTestAccessibilityEvent::QTestAccessibilityEvent(QObject*)
    0,
    232,  // QTestKeyEvent::QTestKeyEvent(QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    233,  // QTestKeyEvent::QTestKeyEvent(QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>, int)
    0,
    58,  // QTest::keyClick(QWidget*, Qt::Key)
    95,  // QTest::keyClick(QWidget*, char)
    0,
    59,  // QTest::keyClick(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    96,  // QTest::keyClick(QWidget*, char, QFlags<Qt::KeyboardModifier>)
    0,
    57,  // QTest::keyClick(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    94,  // QTest::keyClick(QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    0,
    35,  // QTest::keyEvent(QTest::KeyAction, QWidget*, char)
    98,  // QTest::keyEvent(QTest::KeyAction, QWidget*, Qt::Key)
    0,
    36,  // QTest::keyEvent(QTest::KeyAction, QWidget*, char, QFlags<Qt::KeyboardModifier>)
    99,  // QTest::keyEvent(QTest::KeyAction, QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    0,
    34,  // QTest::keyEvent(QTest::KeyAction, QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    97,  // QTest::keyEvent(QTest::KeyAction, QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    0,
    19,  // QTest::keyPress(QWidget*, Qt::Key)
    23,  // QTest::keyPress(QWidget*, char)
    0,
    20,  // QTest::keyPress(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    24,  // QTest::keyPress(QWidget*, char, QFlags<Qt::KeyboardModifier>)
    0,
    18,  // QTest::keyPress(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    22,  // QTest::keyPress(QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    0,
    41,  // QTest::keyRelease(QWidget*, Qt::Key)
    70,  // QTest::keyRelease(QWidget*, char)
    0,
    42,  // QTest::keyRelease(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>)
    71,  // QTest::keyRelease(QWidget*, char, QFlags<Qt::KeyboardModifier>)
    0,
    40,  // QTest::keyRelease(QWidget*, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    69,  // QTest::keyRelease(QWidget*, char, QFlags<Qt::KeyboardModifier>, int)
    0,
    46,  // QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, char, QFlags<Qt::KeyboardModifier>)
    56,  // QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, QString, QFlags<Qt::KeyboardModifier>)
    0,
    45,  // QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, char, QFlags<Qt::KeyboardModifier>, int)
    55,  // QTest::sendKeyEvent(QTest::KeyAction, QWidget*, Qt::Key, QString, QFlags<Qt::KeyboardModifier>, int)
    0,
    60,  // QTest::toString(const void*)
    101,  // QTest::toString(const char*)
    0,
    175,  // QTestEventList::addKeyClick(Qt::Key)
    183,  // QTestEventList::addKeyClick(char)
    0,
    176,  // QTestEventList::addKeyClick(Qt::Key, QFlags<Qt::KeyboardModifier>)
    184,  // QTestEventList::addKeyClick(char, QFlags<Qt::KeyboardModifier>)
    0,
    159,  // QTestEventList::addKeyClick(Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    163,  // QTestEventList::addKeyClick(char, QFlags<Qt::KeyboardModifier>, int)
    0,
    181,  // QTestEventList::addKeyEvent(QTest::KeyAction, Qt::Key)
    191,  // QTestEventList::addKeyEvent(QTest::KeyAction, char)
    0,
    182,  // QTestEventList::addKeyEvent(QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>)
    192,  // QTestEventList::addKeyEvent(QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>)
    0,
    162,  // QTestEventList::addKeyEvent(QTest::KeyAction, Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    167,  // QTestEventList::addKeyEvent(QTest::KeyAction, char, QFlags<Qt::KeyboardModifier>, int)
    0,
    177,  // QTestEventList::addKeyPress(Qt::Key)
    185,  // QTestEventList::addKeyPress(char)
    0,
    178,  // QTestEventList::addKeyPress(Qt::Key, QFlags<Qt::KeyboardModifier>)
    186,  // QTestEventList::addKeyPress(char, QFlags<Qt::KeyboardModifier>)
    0,
    160,  // QTestEventList::addKeyPress(Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    164,  // QTestEventList::addKeyPress(char, QFlags<Qt::KeyboardModifier>, int)
    0,
    179,  // QTestEventList::addKeyRelease(Qt::Key)
    187,  // QTestEventList::addKeyRelease(char)
    0,
    180,  // QTestEventList::addKeyRelease(Qt::Key, QFlags<Qt::KeyboardModifier>)
    188,  // QTestEventList::addKeyRelease(char, QFlags<Qt::KeyboardModifier>)
    0,
    161,  // QTestEventList::addKeyRelease(Qt::Key, QFlags<Qt::KeyboardModifier>, int)
    165,  // QTestEventList::addKeyRelease(char, QFlags<Qt::KeyboardModifier>, int)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {10, 17, 10},	// QSignalSpy::QSignalSpy#$
    {10, 136, 11},	// QSignalSpy::isValid
    {10, 221, 13},	// QSignalSpy::qt_metacall$$?
    {10, 245, 12},	// QSignalSpy::signal
    {10, 271, 14},	// QSignalSpy::~QSignalSpy
    {11, 1, 102},	// QTest::Abort
    {11, 2, 115},	// QTest::BitsPerSecond
    {11, 3, 116},	// QTest::BytesPerSecond
    {11, 4, 118},	// QTest::CPUTicks
    {11, 5, 111},	// QTest::Click
    {11, 6, 103},	// QTest::Continue
    {11, 7, 120},	// QTest::Events
    {11, 8, 114},	// QTest::FramesPerSecond
    {11, 9, 119},	// QTest::InstructionReads
    {11, 10, 106},	// QTest::MouseClick
    {11, 11, 107},	// QTest::MouseDClick
    {11, 12, 108},	// QTest::MouseMove
    {11, 13, 104},	// QTest::MousePress
    {11, 14, 105},	// QTest::MouseRelease
    {11, 15, 109},	// QTest::Press
    {11, 40, 110},	// QTest::Release
    {11, 41, 113},	// QTest::SkipAll
    {11, 42, 112},	// QTest::SkipSingle
    {11, 43, 117},	// QTest::WalltimeMilliseconds
    {11, 50, 15},	// QTest::addColumnInternal$$
    {11, 99, 31},	// QTest::asciiToKey$
    {11, 109, 67},	// QTest::compare_helper$$$$
    {11, 110, 17},	// QTest::compare_helper$$$$$$$$
    {11, 112, 47},	// QTest::compare_ptr_helper$$$$$$
    {11, 114, 49},	// QTest::compare_string_helper$$$$$$
    {11, 116, 48},	// QTest::currentAppName
    {11, 117, 30},	// QTest::currentDataTag
    {11, 118, 78},	// QTest::currentTestFailed
    {11, 119, 43},	// QTest::currentTestFunction
    {11, 133, 21},	// QTest::ignoreMessage$$
    {11, 138, -7},	// QTest::keyClick#$
    {11, 139, -10},	// QTest::keyClick#$$
    {11, 140, -13},	// QTest::keyClick#$$$
    {11, 142, 38},	// QTest::keyClicks#$
    {11, 143, 39},	// QTest::keyClicks#$$
    {11, 144, 37},	// QTest::keyClicks#$$$
    {11, 146, -16},	// QTest::keyEvent$#$
    {11, 147, -19},	// QTest::keyEvent$#$$
    {11, 148, -22},	// QTest::keyEvent$#$$$
    {11, 150, -25},	// QTest::keyPress#$
    {11, 151, -28},	// QTest::keyPress#$$
    {11, 152, -31},	// QTest::keyPress#$$$
    {11, 154, -34},	// QTest::keyRelease#$
    {11, 155, -37},	// QTest::keyRelease#$$
    {11, 156, -40},	// QTest::keyRelease#$$$
    {11, 158, 25},	// QTest::keyToAscii$
    {11, 161, 63},	// QTest::mouseClick#$
    {11, 162, 64},	// QTest::mouseClick#$$
    {11, 163, 65},	// QTest::mouseClick#$$#
    {11, 164, 62},	// QTest::mouseClick#$$#$
    {11, 166, 73},	// QTest::mouseDClick#$
    {11, 167, 74},	// QTest::mouseDClick#$$
    {11, 168, 75},	// QTest::mouseDClick#$$#
    {11, 169, 72},	// QTest::mouseDClick#$$#$
    {11, 171, 27},	// QTest::mouseEvent$#$$#
    {11, 172, 26},	// QTest::mouseEvent$#$$#$
    {11, 174, 82},	// QTest::mouseMove#
    {11, 175, 83},	// QTest::mouseMove##
    {11, 176, 81},	// QTest::mouseMove##$
    {11, 178, 51},	// QTest::mousePress#$
    {11, 179, 52},	// QTest::mousePress#$$
    {11, 180, 53},	// QTest::mousePress#$$#
    {11, 181, 50},	// QTest::mousePress#$$#$
    {11, 183, 88},	// QTest::mouseRelease#$
    {11, 184, 89},	// QTest::mouseRelease#$$
    {11, 185, 90},	// QTest::mouseRelease#$$#
    {11, 186, 87},	// QTest::mouseRelease#$$#$
    {11, 188, 61},	// QTest::newRow$
    {11, 194, 76},	// QTest::qData$$
    {11, 196, 86},	// QTest::qElementData$$
    {11, 198, 92},	// QTest::qExec#
    {11, 199, 93},	// QTest::qExec#$
    {11, 200, 91},	// QTest::qExec#$?
    {11, 201, 100},	// QTest::qExec#?
    {11, 203, 77},	// QTest::qExpectFail$$$$$
    {11, 205, 80},	// QTest::qFail$$$
    {11, 207, 16},	// QTest::qGlobalData$$
    {11, 209, 79},	// QTest::qSkip$$$$
    {11, 211, 32},	// QTest::qSleep$
    {11, 213, 28},	// QTest::qVerify$$$$$
    {11, 215, 54},	// QTest::qWait$
    {11, 217, 68},	// QTest::qWaitForWindowShown#
    {11, 219, 33},	// QTest::qWarn$
    {11, 225, -43},	// QTest::sendKeyEvent$#$$$
    {11, 226, -46},	// QTest::sendKeyEvent$#$$$$
    {11, 228, 29},	// QTest::setBenchmarkResult$$
    {11, 249, 85},	// QTest::simulateEvent#$$$$$
    {11, 250, 84},	// QTest::simulateEvent#$$$$$$
    {11, 252, 44},	// QTest::testObject
    {11, 257, 66},	// QTest::toHexRepresentation$$
    {11, 259, -49},	// QTest::toString$
    {12, 104, 122},	// QTestAccessibility::cleanup
    {12, 106, 123},	// QTestAccessibility::clearEvents
    {12, 130, 124},	// QTestAccessibility::events
    {12, 134, 121},	// QTestAccessibility::initialize
    {12, 269, 125},	// QTestAccessibility::verifyEvent#
    {12, 270, 126},	// QTestAccessibility::verifyEvent#$$
    {13, 18, 130},	// QTestAccessibilityEvent::QTestAccessibilityEvent
    {13, 19, -1},	// QTestAccessibilityEvent::QTestAccessibilityEvent#
    {13, 20, 132},	// QTestAccessibilityEvent::QTestAccessibilityEvent#$
    {13, 21, 127},	// QTestAccessibilityEvent::QTestAccessibilityEvent#$$
    {13, 102, 135},	// QTestAccessibilityEvent::child
    {13, 128, 137},	// QTestAccessibilityEvent::event
    {13, 189, 133},	// QTestAccessibilityEvent::object
    {13, 191, 128},	// QTestAccessibilityEvent::operator==#
    {13, 230, 136},	// QTestAccessibilityEvent::setChild$
    {13, 232, 138},	// QTestAccessibilityEvent::setEvent$
    {13, 234, 134},	// QTestAccessibilityEvent::setObject#
    {13, 272, 139},	// QTestAccessibilityEvent::~QTestAccessibilityEvent
    {14, 97, 140},	// QTestData::append$$
    {14, 122, 141},	// QTestData::data$
    {14, 123, 144},	// QTestData::dataCount
    {14, 124, 142},	// QTestData::dataTag
    {14, 192, 143},	// QTestData::parent
    {14, 273, 145},	// QTestData::~QTestData
    {15, 23, 149},	// QTestDelayEvent::QTestDelayEvent#
    {15, 24, 146},	// QTestDelayEvent::QTestDelayEvent$
    {15, 107, 147},	// QTestDelayEvent::clone
    {15, 247, 148},	// QTestDelayEvent::simulate#
    {15, 274, 150},	// QTestDelayEvent::~QTestDelayEvent
    {16, 25, 153},	// QTestEvent::QTestEvent
    {16, 26, 154},	// QTestEvent::QTestEvent#
    {16, 107, 152},	// QTestEvent::clone
    {16, 247, 151},	// QTestEvent::simulate#
    {16, 275, 155},	// QTestEvent::~QTestEvent
    {17, 27, 156},	// QTestEventList::QTestEventList
    {17, 28, 157},	// QTestEventList::QTestEventList#
    {17, 52, 173},	// QTestEventList::addDelay$
    {17, 54, -52},	// QTestEventList::addKeyClick$
    {17, 55, -55},	// QTestEventList::addKeyClick$$
    {17, 56, -58},	// QTestEventList::addKeyClick$$$
    {17, 58, 189},	// QTestEventList::addKeyClicks$
    {17, 59, 190},	// QTestEventList::addKeyClicks$$
    {17, 60, 166},	// QTestEventList::addKeyClicks$$$
    {17, 62, -61},	// QTestEventList::addKeyEvent$$
    {17, 63, -64},	// QTestEventList::addKeyEvent$$$
    {17, 64, -67},	// QTestEventList::addKeyEvent$$$$
    {17, 66, -70},	// QTestEventList::addKeyPress$
    {17, 67, -73},	// QTestEventList::addKeyPress$$
    {17, 68, -76},	// QTestEventList::addKeyPress$$$
    {17, 70, -79},	// QTestEventList::addKeyRelease$
    {17, 71, -82},	// QTestEventList::addKeyRelease$$
    {17, 72, -85},	// QTestEventList::addKeyRelease$$$
    {17, 74, 199},	// QTestEventList::addMouseClick$
    {17, 75, 200},	// QTestEventList::addMouseClick$$
    {17, 76, 201},	// QTestEventList::addMouseClick$$#
    {17, 77, 170},	// QTestEventList::addMouseClick$$#$
    {17, 79, 202},	// QTestEventList::addMouseDClick$
    {17, 80, 203},	// QTestEventList::addMouseDClick$$
    {17, 81, 204},	// QTestEventList::addMouseDClick$$#
    {17, 82, 171},	// QTestEventList::addMouseDClick$$#$
    {17, 83, 205},	// QTestEventList::addMouseMove
    {17, 84, 206},	// QTestEventList::addMouseMove#
    {17, 85, 172},	// QTestEventList::addMouseMove#$
    {17, 87, 193},	// QTestEventList::addMousePress$
    {17, 88, 194},	// QTestEventList::addMousePress$$
    {17, 89, 195},	// QTestEventList::addMousePress$$#
    {17, 90, 168},	// QTestEventList::addMousePress$$#$
    {17, 92, 196},	// QTestEventList::addMouseRelease$
    {17, 93, 197},	// QTestEventList::addMouseRelease$$
    {17, 94, 198},	// QTestEventList::addMouseRelease$$#
    {17, 95, 169},	// QTestEventList::addMouseRelease$$#$
    {17, 105, 158},	// QTestEventList::clear
    {17, 247, 174},	// QTestEventList::simulate#
    {17, 276, 207},	// QTestEventList::~QTestEventList
    {18, 29, 224},	// QTestEventLoop::QTestEventLoop
    {18, 30, 215},	// QTestEventLoop::QTestEventLoop#
    {18, 101, 217},	// QTestEventLoop::changeInterval$
    {18, 127, 216},	// QTestEventLoop::enterLoop$
    {18, 131, 220},	// QTestEventLoop::exitLoop
    {18, 135, 219},	// QTestEventLoop::instance
    {18, 159, 208},	// QTestEventLoop::metaObject
    {18, 221, 214},	// QTestEventLoop::qt_metacall$$?
    {18, 223, 209},	// QTestEventLoop::qt_metacast$
    {18, 251, 225},	// QTestEventLoop::staticMetaObject
    {18, 253, 218},	// QTestEventLoop::timeout
    {18, 255, 221},	// QTestEventLoop::timerEvent#
    {18, 261, 222},	// QTestEventLoop::tr$
    {18, 262, 210},	// QTestEventLoop::tr$$
    {18, 263, 212},	// QTestEventLoop::tr$$$
    {18, 265, 223},	// QTestEventLoop::trUtf8$
    {18, 266, 211},	// QTestEventLoop::trUtf8$$
    {18, 267, 213},	// QTestEventLoop::trUtf8$$$
    {18, 277, 226},	// QTestEventLoop::~QTestEventLoop
    {19, 32, 230},	// QTestKeyClicksEvent::QTestKeyClicksEvent#
    {19, 33, 227},	// QTestKeyClicksEvent::QTestKeyClicksEvent$$$
    {19, 107, 228},	// QTestKeyClicksEvent::clone
    {19, 247, 229},	// QTestKeyClicksEvent::simulate#
    {19, 278, 231},	// QTestKeyClicksEvent::~QTestKeyClicksEvent
    {20, 35, 236},	// QTestKeyEvent::QTestKeyEvent#
    {20, 36, -4},	// QTestKeyEvent::QTestKeyEvent$$$$
    {20, 44, 237},	// QTestKeyEvent::_action
    {20, 45, 243},	// QTestKeyEvent::_ascii
    {20, 46, 239},	// QTestKeyEvent::_delay
    {20, 47, 245},	// QTestKeyEvent::_key
    {20, 48, 241},	// QTestKeyEvent::_modifiers
    {20, 107, 234},	// QTestKeyEvent::clone
    {20, 236, 238},	// QTestKeyEvent::set_action$
    {20, 238, 244},	// QTestKeyEvent::set_ascii$
    {20, 240, 240},	// QTestKeyEvent::set_delay$
    {20, 242, 246},	// QTestKeyEvent::set_key$
    {20, 244, 242},	// QTestKeyEvent::set_modifiers$
    {20, 247, 235},	// QTestKeyEvent::simulate#
    {20, 279, 247},	// QTestKeyEvent::~QTestKeyEvent
    {21, 38, 251},	// QTestMouseEvent::QTestMouseEvent#
    {21, 39, 248},	// QTestMouseEvent::QTestMouseEvent$$$#$
    {21, 107, 249},	// QTestMouseEvent::clone
    {21, 247, 250},	// QTestMouseEvent::simulate#
    {21, 280, 252},	// QTestMouseEvent::~QTestMouseEvent
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *qttest_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qttest_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    qttest_Smoke = new Smoke(
        "qttest",
        __smokeqttest::classes, 24,
        __smokeqttest::methods, 253,
        __smokeqttest::methodMaps, 215,
        __smokeqttest::methodNames, 280,
        __smokeqttest::types, 131,
        __smokeqttest::inheritanceList,
        __smokeqttest::argumentList,
        __smokeqttest::ambiguousMethodList,
        __smokeqttest::cast );
    initialized = true;
}

void delete_qttest_Smoke() { delete qttest_Smoke; }

}
