#include <qtuitools_includes.h>

#include <smoke.h>
#include <qtuitools_smoke.h>

namespace __smokeqtuitools {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAction
      switch(to) {
        case 1: return (void*)(QAction*)xptr;
        default: return xptr;
      }
    case 2:   //QActionGroup
      switch(to) {
        case 2: return (void*)(QActionGroup*)xptr;
        default: return xptr;
      }
    case 3:   //QBool
      switch(to) {
        case 3: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 4:   //QChildEvent
      switch(to) {
        case 6: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 4: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 5:   //QDir
      switch(to) {
        case 5: return (void*)(QDir*)xptr;
        default: return xptr;
      }
    case 6:   //QEvent
      switch(to) {
        case 6: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QIODevice
      switch(to) {
        case 12: return (void*)(QObject*)(QIODevice*)xptr;
        case 8: return (void*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 9:   //QIncompatibleFlag
      switch(to) {
        case 9: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 10:   //QLayout
      switch(to) {
        case 10: return (void*)(QLayout*)xptr;
        default: return xptr;
      }
    case 11:   //QMetaObject
      switch(to) {
        case 11: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 12:   //QObject
      switch(to) {
        case 12: return (void*)(QObject*)xptr;
        case 15: return (void*)(QUiLoader*)(QObject*)xptr;
        default: return xptr;
      }
    case 13:   //QRegExp
      switch(to) {
        case 13: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 14:   //QTimerEvent
      switch(to) {
        case 6: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 14: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 15:   //QUiLoader
      switch(to) {
        case 12: return (void*)(QObject*)(QUiLoader*)xptr;
        case 15: return (void*)(QUiLoader*)xptr;
        default: return xptr;
      }
    case 16:   //QWidget
      switch(to) {
        case 16: return (void*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    12, 0,	// 1: QObject
};

// These are the xenum functions for manipulating enum pointers

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QUiLoader(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAction", true, 0, 0, 0, 0, 0 },	//1
    { "QActionGroup", true, 0, 0, 0, 0, 0 },	//2
    { "QBool", true, 0, 0, 0, 0, 0 },	//3
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//4
    { "QDir", true, 0, 0, 0, 0, 0 },	//5
    { "QEvent", true, 0, 0, 0, 0, 0 },	//6
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//7
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//8
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//9
    { "QLayout", true, 0, 0, 0, 0, 0 },	//10
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//11
    { "QObject", true, 0, 0, 0, 0, 0 },	//12
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//13
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//14
    { "QUiLoader", false, 1, xcall_QUiLoader, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QUiLoader) },	//15
    { "QWidget", true, 0, 0, 0, 0, 0 },	//16
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAction*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "QActionGroup*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "QBool", 3, Smoke::t_class|Smoke::tf_stack },	//3
    { "QChildEvent*", 4, Smoke::t_class|Smoke::tf_ptr },	//4
    { "QDir", 5, Smoke::t_class|Smoke::tf_stack },	//5
    { "QEvent*", 6, Smoke::t_class|Smoke::tf_ptr },	//6
    { "QFlags<QtConcurrent::ReduceOptions::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//7
    { "QIODevice*", 8, Smoke::t_class|Smoke::tf_ptr },	//8
    { "QIncompatibleFlag", 9, Smoke::t_class|Smoke::tf_stack },	//9
    { "QLayout*", 10, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QMetaObject::Call", 11, Smoke::t_enum|Smoke::tf_stack },	//11
    { "QObject*", 12, Smoke::t_class|Smoke::tf_ptr },	//12
    { "QRegExp&", 13, Smoke::t_class|Smoke::tf_ref },	//13
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//14
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//15
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//16
    { "QTimerEvent*", 14, Smoke::t_class|Smoke::tf_ptr },	//17
    { "QUiLoader*", 15, Smoke::t_class|Smoke::tf_ptr },	//18
    { "QWidget*", 16, Smoke::t_class|Smoke::tf_ptr },	//19
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//20
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//21
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//22
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//23
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//24
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//25
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//26
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//27
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//28
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//29
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//30
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//31
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//32
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//33
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//34
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//35
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//36
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//37
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//38
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//40
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//41
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//42
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//43
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//44
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//45
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//46
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//47
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//48
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//49
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//50
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//51
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//52
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//53
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//54
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//55
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//56
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//57
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//58
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//59
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "QtConcurrent::ReduceOptions::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//93
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//94
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//95
    { "const QDir&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//96
    { "const QMetaObject&", 11, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//97
    { "const QMetaObject*", 11, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//98
    { "const QRegExp&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//99
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//100
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//101
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//102
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//103
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//104
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//105
    { "std::bidirectional_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//106
    { "std::forward_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//107
    { "std::random_access_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//108
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//109
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//110
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//111
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    6, 0,	//1  QEvent*
    12, 6, 0,	//3  QObject*, QEvent*
    17, 0,	//6  QTimerEvent*
    4, 0,	//8  QChildEvent*
    102, 0,	//10  const char*
    102, 102, 0,	//12  const char*, const char*
    102, 102, 104, 0,	//15  const char*, const char*, int
    11, 104, 110, 0,	//19  QMetaObject::Call, int, void**
    12, 0,	//23  QObject*
    100, 0,	//25  const QString&
    8, 19, 0,	//27  QIODevice*, QWidget*
    100, 19, 100, 0,	//30  const QString&, QWidget*, const QString&
    100, 12, 100, 0,	//34  const QString&, QObject*, const QString&
    12, 100, 0,	//38  QObject*, const QString&
    96, 0,	//41  const QDir&
    95, 0,	//43  bool
    8, 0,	//45  QIODevice*
    100, 19, 0,	//47  const QString&, QWidget*
    100, 12, 0,	//50  const QString&, QObject*
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "QUiLoader",	//1
    "QUiLoader#",	//2
    "addPluginPath",	//3
    "addPluginPath$",	//4
    "availableLayouts",	//5
    "availableWidgets",	//6
    "childEvent",	//7
    "clearPluginPaths",	//8
    "connectNotify",	//9
    "createAction",	//10
    "createAction#",	//11
    "createAction#$",	//12
    "createActionGroup",	//13
    "createActionGroup#",	//14
    "createActionGroup#$",	//15
    "createLayout",	//16
    "createLayout$",	//17
    "createLayout$#",	//18
    "createLayout$#$",	//19
    "createWidget",	//20
    "createWidget$",	//21
    "createWidget$#",	//22
    "createWidget$#$",	//23
    "customEvent",	//24
    "disconnectNotify",	//25
    "event",	//26
    "eventFilter",	//27
    "isLanguageChangeEnabled",	//28
    "isScriptingEnabled",	//29
    "isTranslationEnabled",	//30
    "load",	//31
    "load#",	//32
    "load##",	//33
    "metaObject",	//34
    "pluginPaths",	//35
    "qt_metacall",	//36
    "qt_metacall$$?",	//37
    "qt_metacast",	//38
    "qt_metacast$",	//39
    "setLanguageChangeEnabled",	//40
    "setLanguageChangeEnabled$",	//41
    "setScriptingEnabled",	//42
    "setScriptingEnabled$",	//43
    "setTranslationEnabled",	//44
    "setTranslationEnabled$",	//45
    "setWorkingDirectory",	//46
    "setWorkingDirectory#",	//47
    "staticMetaObject",	//48
    "timerEvent",	//49
    "tr",	//50
    "tr$",	//51
    "tr$$",	//52
    "tr$$$",	//53
    "trUtf8",	//54
    "trUtf8$",	//55
    "trUtf8$$",	//56
    "trUtf8$$$",	//57
    "workingDirectory",	//58
    "~QUiLoader",	//59
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {12, 26, 1, 1, Smoke::mf_virtual, 95, 0},	//1 QObject::event(QEvent*)
    {12, 27, 3, 2, Smoke::mf_virtual, 95, 0},	//2 QObject::eventFilter(QObject*, QEvent*)
    {12, 49, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3 QObject::timerEvent(QTimerEvent*)
    {12, 7, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//4 QObject::childEvent(QChildEvent*)
    {12, 24, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//5 QObject::customEvent(QEvent*)
    {12, 9, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 QObject::connectNotify(const char*)
    {12, 25, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 QObject::disconnectNotify(const char*)
    {15, 34, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 98, 1},	//8 QUiLoader::metaObject() const
    {15, 38, 10, 1, Smoke::mf_virtual, 109, 2},	//9 QUiLoader::qt_metacast(const char*)
    {15, 50, 12, 2, Smoke::mf_static, 14, 3},	//10 QUiLoader::tr(const char*, const char*)
    {15, 54, 12, 2, Smoke::mf_static, 14, 4},	//11 QUiLoader::trUtf8(const char*, const char*)
    {15, 50, 15, 3, Smoke::mf_static, 14, 5},	//12 QUiLoader::tr(const char*, const char*, int)
    {15, 54, 15, 3, Smoke::mf_static, 14, 6},	//13 QUiLoader::trUtf8(const char*, const char*, int)
    {15, 36, 19, 3, Smoke::mf_virtual, 104, 7},	//14 QUiLoader::qt_metacall(QMetaObject::Call, int, void**)
    {15, 1, 23, 1, Smoke::mf_ctor, 18, 8},	//15 QUiLoader::QUiLoader(QObject*)
    {15, 35, 0, 0, Smoke::mf_const, 15, 9},	//16 QUiLoader::pluginPaths() const
    {15, 8, 0, 0, 0, 0, 10},	//17 QUiLoader::clearPluginPaths()
    {15, 3, 25, 1, 0, 0, 11},	//18 QUiLoader::addPluginPath(const QString&)
    {15, 31, 27, 2, 0, 19, 12},	//19 QUiLoader::load(QIODevice*, QWidget*)
    {15, 6, 0, 0, Smoke::mf_const, 15, 13},	//20 QUiLoader::availableWidgets() const
    {15, 5, 0, 0, Smoke::mf_const, 15, 14},	//21 QUiLoader::availableLayouts() const
    {15, 20, 30, 3, Smoke::mf_virtual, 19, 15},	//22 QUiLoader::createWidget(const QString&, QWidget*, const QString&)
    {15, 16, 34, 3, Smoke::mf_virtual, 10, 16},	//23 QUiLoader::createLayout(const QString&, QObject*, const QString&)
    {15, 13, 38, 2, Smoke::mf_virtual, 2, 17},	//24 QUiLoader::createActionGroup(QObject*, const QString&)
    {15, 10, 38, 2, Smoke::mf_virtual, 1, 18},	//25 QUiLoader::createAction(QObject*, const QString&)
    {15, 46, 41, 1, 0, 0, 19},	//26 QUiLoader::setWorkingDirectory(const QDir&)
    {15, 58, 0, 0, Smoke::mf_const, 5, 20},	//27 QUiLoader::workingDirectory() const
    {15, 42, 43, 1, 0, 0, 21},	//28 QUiLoader::setScriptingEnabled(bool)
    {15, 29, 0, 0, Smoke::mf_const, 95, 22},	//29 QUiLoader::isScriptingEnabled() const
    {15, 40, 43, 1, 0, 0, 23},	//30 QUiLoader::setLanguageChangeEnabled(bool)
    {15, 28, 0, 0, Smoke::mf_const, 95, 24},	//31 QUiLoader::isLanguageChangeEnabled() const
    {15, 44, 43, 1, 0, 0, 25},	//32 QUiLoader::setTranslationEnabled(bool)
    {15, 30, 0, 0, Smoke::mf_const, 95, 26},	//33 QUiLoader::isTranslationEnabled() const
    {15, 50, 10, 1, Smoke::mf_static, 14, 27},	//34 QUiLoader::tr(const char*)
    {15, 54, 10, 1, Smoke::mf_static, 14, 28},	//35 QUiLoader::trUtf8(const char*)
    {15, 1, 0, 0, Smoke::mf_ctor, 18, 29},	//36 QUiLoader::QUiLoader()
    {15, 31, 45, 1, 0, 19, 30},	//37 QUiLoader::load(QIODevice*)
    {15, 20, 25, 1, 0, 19, 31},	//38 QUiLoader::createWidget(const QString&)
    {15, 20, 47, 2, 0, 19, 32},	//39 QUiLoader::createWidget(const QString&, QWidget*)
    {15, 16, 25, 1, 0, 10, 33},	//40 QUiLoader::createLayout(const QString&)
    {15, 16, 50, 2, 0, 10, 34},	//41 QUiLoader::createLayout(const QString&, QObject*)
    {15, 13, 0, 0, 0, 2, 35},	//42 QUiLoader::createActionGroup()
    {15, 13, 23, 1, 0, 2, 36},	//43 QUiLoader::createActionGroup(QObject*)
    {15, 10, 0, 0, 0, 1, 37},	//44 QUiLoader::createAction()
    {15, 10, 23, 1, 0, 1, 38},	//45 QUiLoader::createAction(QObject*)
    {15, 48, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 97, 39},	//46 QUiLoader::staticMetaObject() const
    {15, 59, 0, 0, Smoke::mf_dtor, 0, 40 },	//47 QUiLoader::~QUiLoader()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {15, 1, 36},	// QUiLoader::QUiLoader
    {15, 2, 15},	// QUiLoader::QUiLoader#
    {15, 4, 18},	// QUiLoader::addPluginPath$
    {15, 5, 21},	// QUiLoader::availableLayouts
    {15, 6, 20},	// QUiLoader::availableWidgets
    {15, 8, 17},	// QUiLoader::clearPluginPaths
    {15, 10, 44},	// QUiLoader::createAction
    {15, 11, 45},	// QUiLoader::createAction#
    {15, 12, 25},	// QUiLoader::createAction#$
    {15, 13, 42},	// QUiLoader::createActionGroup
    {15, 14, 43},	// QUiLoader::createActionGroup#
    {15, 15, 24},	// QUiLoader::createActionGroup#$
    {15, 17, 40},	// QUiLoader::createLayout$
    {15, 18, 41},	// QUiLoader::createLayout$#
    {15, 19, 23},	// QUiLoader::createLayout$#$
    {15, 21, 38},	// QUiLoader::createWidget$
    {15, 22, 39},	// QUiLoader::createWidget$#
    {15, 23, 22},	// QUiLoader::createWidget$#$
    {15, 28, 31},	// QUiLoader::isLanguageChangeEnabled
    {15, 29, 29},	// QUiLoader::isScriptingEnabled
    {15, 30, 33},	// QUiLoader::isTranslationEnabled
    {15, 32, 37},	// QUiLoader::load#
    {15, 33, 19},	// QUiLoader::load##
    {15, 34, 8},	// QUiLoader::metaObject
    {15, 35, 16},	// QUiLoader::pluginPaths
    {15, 37, 14},	// QUiLoader::qt_metacall$$?
    {15, 39, 9},	// QUiLoader::qt_metacast$
    {15, 41, 30},	// QUiLoader::setLanguageChangeEnabled$
    {15, 43, 28},	// QUiLoader::setScriptingEnabled$
    {15, 45, 32},	// QUiLoader::setTranslationEnabled$
    {15, 47, 26},	// QUiLoader::setWorkingDirectory#
    {15, 48, 46},	// QUiLoader::staticMetaObject
    {15, 51, 34},	// QUiLoader::tr$
    {15, 52, 10},	// QUiLoader::tr$$
    {15, 53, 12},	// QUiLoader::tr$$$
    {15, 55, 35},	// QUiLoader::trUtf8$
    {15, 56, 11},	// QUiLoader::trUtf8$$
    {15, 57, 13},	// QUiLoader::trUtf8$$$
    {15, 58, 27},	// QUiLoader::workingDirectory
    {15, 59, 47},	// QUiLoader::~QUiLoader
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *qtuitools_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtuitools_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    qtuitools_Smoke = new Smoke(
        "qtuitools",
        __smokeqtuitools::classes, 16,
        __smokeqtuitools::methods, 48,
        __smokeqtuitools::methodMaps, 41,
        __smokeqtuitools::methodNames, 59,
        __smokeqtuitools::types, 111,
        __smokeqtuitools::inheritanceList,
        __smokeqtuitools::argumentList,
        __smokeqtuitools::ambiguousMethodList,
        __smokeqtuitools::cast );
    initialized = true;
}

void delete_qtuitools_Smoke() { delete qtuitools_Smoke; }

}
