#include <qtwebkit_includes.h>

#include <smoke.h>
#include <qtwebkit_smoke.h>

namespace __smokeqtwebkit {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QAction
      switch(to) {
        case 1: return (void*)(QAction*)xptr;
        default: return xptr;
      }
    case 2:   //QActionEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QActionEvent*)xptr;
        case 2: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 3:   //QBool
      switch(to) {
        case 3: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 4:   //QByteArray
      switch(to) {
        case 4: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 5:   //QChildEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 5: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 6:   //QCloseEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QCloseEvent*)xptr;
        case 6: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 7:   //QContextMenuEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QContextMenuEvent*)xptr;
        case 7: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 8:   //QDateTime
      switch(to) {
        case 8: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 9:   //QDragEnterEvent
      switch(to) {
        case 11: return (void*)(QDragMoveEvent*)(QDragEnterEvent*)xptr;
        case 12: return (void*)(QDropEvent*)(QDragEnterEvent*)xptr;
        case 13: return (void*)(QEvent*)(QDragEnterEvent*)xptr;
        case 9: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 10:   //QDragLeaveEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QDragLeaveEvent*)xptr;
        case 10: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 11:   //QDragMoveEvent
      switch(to) {
        case 12: return (void*)(QDropEvent*)(QDragMoveEvent*)xptr;
        case 13: return (void*)(QEvent*)(QDragMoveEvent*)xptr;
        case 11: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 12:   //QDropEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QDropEvent*)xptr;
        case 12: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 13:   //QEvent
      switch(to) {
        case 13: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 14:   //QFocusEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QFocusEvent*)xptr;
        case 14: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 15:   //QFont
      switch(to) {
        case 15: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 17:   //QHideEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QHideEvent*)xptr;
        case 17: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 18:   //QIcon
      switch(to) {
        case 18: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 19:   //QIncompatibleFlag
      switch(to) {
        case 19: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 20:   //QInputMethodEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QInputMethodEvent*)xptr;
        case 20: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 21:   //QKeyEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QKeyEvent*)xptr;
        case 21: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 22:   //QMenu
      switch(to) {
        case 22: return (void*)(QMenu*)xptr;
        default: return xptr;
      }
    case 23:   //QMetaObject
      switch(to) {
        case 23: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 24:   //QMouseEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QMouseEvent*)xptr;
        case 24: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 25:   //QMoveEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QMoveEvent*)xptr;
        case 25: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 26:   //QNetworkAccessManager
      switch(to) {
        case 29: return (void*)(QObject*)(QNetworkAccessManager*)xptr;
        case 26: return (void*)(QNetworkAccessManager*)xptr;
        default: return xptr;
      }
    case 27:   //QNetworkReply
      switch(to) {
        case 29: return (void*)(QObject*)(QNetworkReply*)xptr;
        case 27: return (void*)(QNetworkReply*)xptr;
        default: return xptr;
      }
    case 28:   //QNetworkRequest
      switch(to) {
        case 28: return (void*)(QNetworkRequest*)xptr;
        default: return xptr;
      }
    case 29:   //QObject
      switch(to) {
        case 29: return (void*)(QObject*)xptr;
        case 77: return (void*)(QWebView*)(QObject*)xptr;
        case 54: return (void*)(QWebFrame*)(QObject*)xptr;
        case 60: return (void*)(QWebPage*)(QObject*)xptr;
        case 69: return (void*)(QWebPluginFactory*)(QObject*)xptr;
        case 56: return (void*)(QWebHistoryInterface*)(QObject*)xptr;
        case 59: return (void*)(QWebInspector*)(QObject*)xptr;
        default: return xptr;
      }
    case 30:   //QPaintEngine
      switch(to) {
        case 30: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 31:   //QPaintEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QPaintEvent*)xptr;
        case 31: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 32:   //QPainter
      switch(to) {
        case 32: return (void*)(QPainter*)xptr;
        default: return xptr;
      }
    case 33:   //QPalette
      switch(to) {
        case 33: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 34:   //QPixmap
      switch(to) {
        case 34: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 35:   //QPoint
      switch(to) {
        case 35: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 36:   //QPrinter
      switch(to) {
        case 36: return (void*)(QPrinter*)xptr;
        default: return xptr;
      }
    case 37:   //QRect
      switch(to) {
        case 37: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 38:   //QRegExp
      switch(to) {
        case 38: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 39:   //QRegion
      switch(to) {
        case 39: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 40:   //QResizeEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QResizeEvent*)xptr;
        case 40: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 41:   //QShowEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QShowEvent*)xptr;
        case 41: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 42:   //QSize
      switch(to) {
        case 42: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 43:   //QStyle
      switch(to) {
        case 43: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 44:   //QTabletEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QTabletEvent*)xptr;
        case 44: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 45:   //QTimerEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 45: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 46:   //QUndoStack
      switch(to) {
        case 46: return (void*)(QUndoStack*)xptr;
        default: return xptr;
      }
    case 47:   //QUrl
      switch(to) {
        case 47: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 48:   //QVariant
      switch(to) {
        case 48: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 49:   //QWebDatabase
      switch(to) {
        case 49: return (void*)(QWebDatabase*)xptr;
        default: return xptr;
      }
    case 50:   //QWebElement
      switch(to) {
        case 50: return (void*)(QWebElement*)xptr;
        default: return xptr;
      }
    case 51:   //QWebElementCollection
      switch(to) {
        case 51: return (void*)(QWebElementCollection*)xptr;
        default: return xptr;
      }
    case 52:   //QWebElementCollection::const_iterator
      switch(to) {
        case 52: return (void*)(QWebElementCollection::const_iterator*)xptr;
        default: return xptr;
      }
    case 53:   //QWebElementCollection::iterator
      switch(to) {
        case 53: return (void*)(QWebElementCollection::iterator*)xptr;
        default: return xptr;
      }
    case 54:   //QWebFrame
      switch(to) {
        case 29: return (void*)(QObject*)(QWebFrame*)xptr;
        case 54: return (void*)(QWebFrame*)xptr;
        default: return xptr;
      }
    case 55:   //QWebHistory
      switch(to) {
        case 55: return (void*)(QWebHistory*)xptr;
        default: return xptr;
      }
    case 56:   //QWebHistoryInterface
      switch(to) {
        case 29: return (void*)(QObject*)(QWebHistoryInterface*)xptr;
        case 56: return (void*)(QWebHistoryInterface*)xptr;
        default: return xptr;
      }
    case 57:   //QWebHistoryItem
      switch(to) {
        case 57: return (void*)(QWebHistoryItem*)xptr;
        default: return xptr;
      }
    case 58:   //QWebHitTestResult
      switch(to) {
        case 58: return (void*)(QWebHitTestResult*)xptr;
        default: return xptr;
      }
    case 59:   //QWebInspector
      switch(to) {
        case 79: return (void*)(QWidget*)(QWebInspector*)xptr;
        case 29: return (void*)(QObject*)(QWebInspector*)xptr;
        case 59: return (void*)(QWebInspector*)xptr;
        default: return xptr;
      }
    case 60:   //QWebPage
      switch(to) {
        case 29: return (void*)(QObject*)(QWebPage*)xptr;
        case 60: return (void*)(QWebPage*)xptr;
        default: return xptr;
      }
    case 61:   //QWebPage::ChooseMultipleFilesExtensionOption
      switch(to) {
        case 65: return (void*)(QWebPage::ExtensionOption*)(QWebPage::ChooseMultipleFilesExtensionOption*)xptr;
        case 61: return (void*)(QWebPage::ChooseMultipleFilesExtensionOption*)xptr;
        default: return xptr;
      }
    case 62:   //QWebPage::ChooseMultipleFilesExtensionReturn
      switch(to) {
        case 66: return (void*)(QWebPage::ExtensionReturn*)(QWebPage::ChooseMultipleFilesExtensionReturn*)xptr;
        case 62: return (void*)(QWebPage::ChooseMultipleFilesExtensionReturn*)xptr;
        default: return xptr;
      }
    case 63:   //QWebPage::ErrorPageExtensionOption
      switch(to) {
        case 65: return (void*)(QWebPage::ExtensionOption*)(QWebPage::ErrorPageExtensionOption*)xptr;
        case 63: return (void*)(QWebPage::ErrorPageExtensionOption*)xptr;
        default: return xptr;
      }
    case 64:   //QWebPage::ErrorPageExtensionReturn
      switch(to) {
        case 66: return (void*)(QWebPage::ExtensionReturn*)(QWebPage::ErrorPageExtensionReturn*)xptr;
        case 64: return (void*)(QWebPage::ErrorPageExtensionReturn*)xptr;
        default: return xptr;
      }
    case 65:   //QWebPage::ExtensionOption
      switch(to) {
        case 65: return (void*)(QWebPage::ExtensionOption*)xptr;
        case 61: return (void*)(QWebPage::ChooseMultipleFilesExtensionOption*)(QWebPage::ExtensionOption*)xptr;
        case 63: return (void*)(QWebPage::ErrorPageExtensionOption*)(QWebPage::ExtensionOption*)xptr;
        default: return xptr;
      }
    case 66:   //QWebPage::ExtensionReturn
      switch(to) {
        case 66: return (void*)(QWebPage::ExtensionReturn*)xptr;
        case 64: return (void*)(QWebPage::ErrorPageExtensionReturn*)(QWebPage::ExtensionReturn*)xptr;
        case 62: return (void*)(QWebPage::ChooseMultipleFilesExtensionReturn*)(QWebPage::ExtensionReturn*)xptr;
        default: return xptr;
      }
    case 67:   //QWebPage::ViewportAttributes
      switch(to) {
        case 67: return (void*)(QWebPage::ViewportAttributes*)xptr;
        default: return xptr;
      }
    case 68:   //QWebPagePrivate
      switch(to) {
        case 68: return (void*)(QWebPagePrivate*)xptr;
        default: return xptr;
      }
    case 69:   //QWebPluginFactory
      switch(to) {
        case 29: return (void*)(QObject*)(QWebPluginFactory*)xptr;
        case 69: return (void*)(QWebPluginFactory*)xptr;
        default: return xptr;
      }
    case 70:   //QWebPluginFactory::ExtensionOption
      switch(to) {
        case 70: return (void*)(QWebPluginFactory::ExtensionOption*)xptr;
        default: return xptr;
      }
    case 71:   //QWebPluginFactory::ExtensionReturn
      switch(to) {
        case 71: return (void*)(QWebPluginFactory::ExtensionReturn*)xptr;
        default: return xptr;
      }
    case 72:   //QWebPluginFactory::MimeType
      switch(to) {
        case 72: return (void*)(QWebPluginFactory::MimeType*)xptr;
        default: return xptr;
      }
    case 73:   //QWebPluginFactory::Plugin
      switch(to) {
        case 73: return (void*)(QWebPluginFactory::Plugin*)xptr;
        default: return xptr;
      }
    case 74:   //QWebSecurityOrigin
      switch(to) {
        case 74: return (void*)(QWebSecurityOrigin*)xptr;
        default: return xptr;
      }
    case 75:   //QWebSettings
      switch(to) {
        case 75: return (void*)(QWebSettings*)xptr;
        default: return xptr;
      }
    case 76:   //QWebSettingsPrivate
      switch(to) {
        case 76: return (void*)(QWebSettingsPrivate*)xptr;
        default: return xptr;
      }
    case 77:   //QWebView
      switch(to) {
        case 79: return (void*)(QWidget*)(QWebView*)xptr;
        case 29: return (void*)(QObject*)(QWebView*)xptr;
        case 77: return (void*)(QWebView*)xptr;
        default: return xptr;
      }
    case 78:   //QWheelEvent
      switch(to) {
        case 13: return (void*)(QEvent*)(QWheelEvent*)xptr;
        case 78: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 79:   //QWidget
      switch(to) {
        case 29: return (void*)(QObject*)(QWidget*)xptr;
        case 79: return (void*)(QWidget*)xptr;
        case 77: return (void*)(QWebView*)(QWidget*)xptr;
        case 59: return (void*)(QWebInspector*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    29, 0,	// 1: QObject
    79, 0,	// 3: QWidget
    65, 0,	// 5: QWebPage::ExtensionOption
    66, 0,	// 7: QWebPage::ExtensionReturn
};

// These are the xenum functions for manipulating enum pointers
void xenum_QWebPage(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebSettings(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebElement(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebFrame(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QWebPluginFactory(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebDatabase(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElement(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElementCollection(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElementCollection__const_iterator(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebElementCollection__iterator(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebFrame(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHistory(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHistoryInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHistoryItem(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebHitTestResult(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebInspector(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ChooseMultipleFilesExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ChooseMultipleFilesExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ErrorPageExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ErrorPageExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPage__ViewportAttributes(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__ExtensionOption(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__ExtensionReturn(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__MimeType(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebPluginFactory__Plugin(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebSecurityOrigin(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebSettings(Smoke::Index, void*, Smoke::Stack);
void xcall_QWebView(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QAction", true, 0, 0, 0, 0, 0 },	//1
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//2
    { "QBool", true, 0, 0, 0, 0, 0 },	//3
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//4
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//5
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//6
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//7
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//8
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//9
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//10
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//11
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//12
    { "QEvent", true, 0, 0, 0, 0, 0 },	//13
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//14
    { "QFont", true, 0, 0, 0, 0, 0 },	//15
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//16
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//17
    { "QIcon", true, 0, 0, 0, 0, 0 },	//18
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//19
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//20
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//21
    { "QMenu", true, 0, 0, 0, 0, 0 },	//22
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//23
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//24
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//25
    { "QNetworkAccessManager", true, 0, 0, 0, 0, 0 },	//26
    { "QNetworkReply", true, 0, 0, 0, 0, 0 },	//27
    { "QNetworkRequest", true, 0, 0, 0, 0, 0 },	//28
    { "QObject", true, 0, 0, 0, 0, 0 },	//29
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//30
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//31
    { "QPainter", true, 0, 0, 0, 0, 0 },	//32
    { "QPalette", true, 0, 0, 0, 0, 0 },	//33
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//34
    { "QPoint", true, 0, 0, 0, 0, 0 },	//35
    { "QPrinter", true, 0, 0, 0, 0, 0 },	//36
    { "QRect", true, 0, 0, 0, 0, 0 },	//37
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//38
    { "QRegion", true, 0, 0, 0, 0, 0 },	//39
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//40
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//41
    { "QSize", true, 0, 0, 0, 0, 0 },	//42
    { "QStyle", true, 0, 0, 0, 0, 0 },	//43
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//44
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//45
    { "QUndoStack", true, 0, 0, 0, 0, 0 },	//46
    { "QUrl", true, 0, 0, 0, 0, 0 },	//47
    { "QVariant", true, 0, 0, 0, 0, 0 },	//48
    { "QWebDatabase", false, 0, xcall_QWebDatabase, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebDatabase) },	//49
    { "QWebElement", false, 0, xcall_QWebElement, xenum_QWebElement, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElement) },	//50
    { "QWebElementCollection", false, 0, xcall_QWebElementCollection, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElementCollection) },	//51
    { "QWebElementCollection::const_iterator", false, 0, xcall_QWebElementCollection__const_iterator, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElementCollection::const_iterator) },	//52
    { "QWebElementCollection::iterator", false, 0, xcall_QWebElementCollection__iterator, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebElementCollection::iterator) },	//53
    { "QWebFrame", false, 1, xcall_QWebFrame, xenum_QWebFrame, Smoke::cf_virtual, sizeof(QWebFrame) },	//54
    { "QWebHistory", false, 0, xcall_QWebHistory, 0, 0, sizeof(QWebHistory) },	//55
    { "QWebHistoryInterface", false, 1, xcall_QWebHistoryInterface, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebHistoryInterface) },	//56
    { "QWebHistoryItem", false, 0, xcall_QWebHistoryItem, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebHistoryItem) },	//57
    { "QWebHitTestResult", false, 0, xcall_QWebHitTestResult, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebHitTestResult) },	//58
    { "QWebInspector", false, 3, xcall_QWebInspector, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebInspector) },	//59
    { "QWebPage", false, 1, xcall_QWebPage, xenum_QWebPage, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebPage) },	//60
    { "QWebPage::ChooseMultipleFilesExtensionOption", false, 5, xcall_QWebPage__ChooseMultipleFilesExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ChooseMultipleFilesExtensionOption) },	//61
    { "QWebPage::ChooseMultipleFilesExtensionReturn", false, 7, xcall_QWebPage__ChooseMultipleFilesExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ChooseMultipleFilesExtensionReturn) },	//62
    { "QWebPage::ErrorPageExtensionOption", false, 5, xcall_QWebPage__ErrorPageExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ErrorPageExtensionOption) },	//63
    { "QWebPage::ErrorPageExtensionReturn", false, 7, xcall_QWebPage__ErrorPageExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ErrorPageExtensionReturn) },	//64
    { "QWebPage::ExtensionOption", false, 0, xcall_QWebPage__ExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ExtensionOption) },	//65
    { "QWebPage::ExtensionReturn", false, 0, xcall_QWebPage__ExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ExtensionReturn) },	//66
    { "QWebPage::ViewportAttributes", false, 0, xcall_QWebPage__ViewportAttributes, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPage::ViewportAttributes) },	//67
    { "QWebPagePrivate", true, 0, 0, 0, 0, 0 },	//68
    { "QWebPluginFactory", false, 1, xcall_QWebPluginFactory, xenum_QWebPluginFactory, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebPluginFactory) },	//69
    { "QWebPluginFactory::ExtensionOption", false, 0, xcall_QWebPluginFactory__ExtensionOption, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::ExtensionOption) },	//70
    { "QWebPluginFactory::ExtensionReturn", false, 0, xcall_QWebPluginFactory__ExtensionReturn, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::ExtensionReturn) },	//71
    { "QWebPluginFactory::MimeType", false, 0, xcall_QWebPluginFactory__MimeType, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::MimeType) },	//72
    { "QWebPluginFactory::Plugin", false, 0, xcall_QWebPluginFactory__Plugin, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebPluginFactory::Plugin) },	//73
    { "QWebSecurityOrigin", false, 0, xcall_QWebSecurityOrigin, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(QWebSecurityOrigin) },	//74
    { "QWebSettings", false, 0, xcall_QWebSettings, xenum_QWebSettings, 0, sizeof(QWebSettings) },	//75
    { "QWebSettingsPrivate", true, 0, 0, 0, 0, 0 },	//76
    { "QWebView", false, 3, xcall_QWebView, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(QWebView) },	//77
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//78
    { "QWidget", true, 0, 0, 0, 0, 0 },	//79
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QAction*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "QActionEvent*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "QBool", 3, Smoke::t_class|Smoke::tf_stack },	//3
    { "QByteArray&", 4, Smoke::t_class|Smoke::tf_ref },	//4
    { "QChildEvent*", 5, Smoke::t_class|Smoke::tf_ptr },	//5
    { "QCloseEvent*", 6, Smoke::t_class|Smoke::tf_ptr },	//6
    { "QContextMenuEvent*", 7, Smoke::t_class|Smoke::tf_ptr },	//7
    { "QDateTime", 8, Smoke::t_class|Smoke::tf_stack },	//8
    { "QDragEnterEvent*", 9, Smoke::t_class|Smoke::tf_ptr },	//9
    { "QDragLeaveEvent*", 10, Smoke::t_class|Smoke::tf_ptr },	//10
    { "QDragMoveEvent*", 11, Smoke::t_class|Smoke::tf_ptr },	//11
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//12
    { "QDropEvent*", 12, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QEvent*", 13, Smoke::t_class|Smoke::tf_ptr },	//14
    { "QFlags<QPainter::RenderHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//15
    { "QFlags<QWebPage::FindFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//16
    { "QFlags<QtConcurrent::ReduceOptions::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//17
    { "QFocusEvent*", 14, Smoke::t_class|Smoke::tf_ptr },	//18
    { "QHideEvent*", 17, Smoke::t_class|Smoke::tf_ptr },	//19
    { "QIcon", 18, Smoke::t_class|Smoke::tf_stack },	//20
    { "QIncompatibleFlag", 19, Smoke::t_class|Smoke::tf_stack },	//21
    { "QInputMethodEvent*", 20, Smoke::t_class|Smoke::tf_ptr },	//22
    { "QKeyEvent*", 21, Smoke::t_class|Smoke::tf_ptr },	//23
    { "QList<QWebDatabase>", 0, Smoke::t_voidp|Smoke::tf_stack },	//24
    { "QList<QWebElement>", 0, Smoke::t_voidp|Smoke::tf_stack },	//25
    { "QList<QWebFrame*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//26
    { "QList<QWebHistoryItem>", 0, Smoke::t_voidp|Smoke::tf_stack },	//27
    { "QList<QWebPluginFactory::MimeType>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//28
    { "QList<QWebPluginFactory::Plugin>", 0, Smoke::t_voidp|Smoke::tf_stack },	//29
    { "QList<QWebSecurityOrigin>", 0, Smoke::t_voidp|Smoke::tf_stack },	//30
    { "QMenu*", 22, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QMetaObject::Call", 23, Smoke::t_enum|Smoke::tf_stack },	//32
    { "QMouseEvent*", 24, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QMoveEvent*", 25, Smoke::t_class|Smoke::tf_ptr },	//34
    { "QMultiMap<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//35
    { "QNetworkAccessManager*", 26, Smoke::t_class|Smoke::tf_ptr },	//36
    { "QNetworkAccessManager::Operation", 26, Smoke::t_enum|Smoke::tf_stack },	//37
    { "QNetworkReply*", 27, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QNetworkRequest", 28, Smoke::t_class|Smoke::tf_stack },	//39
    { "QObject*", 29, Smoke::t_class|Smoke::tf_ptr },	//40
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//41
    { "QPaintEngine*", 30, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QPaintEvent*", 31, Smoke::t_class|Smoke::tf_ptr },	//43
    { "QPainter*", 32, Smoke::t_class|Smoke::tf_ptr },	//44
    { "QPainter::RenderHint", 32, Smoke::t_enum|Smoke::tf_stack },	//45
    { "QPalette", 33, Smoke::t_class|Smoke::tf_stack },	//46
    { "QPixmap", 34, Smoke::t_class|Smoke::tf_stack },	//47
    { "QPoint", 35, Smoke::t_class|Smoke::tf_stack },	//48
    { "QPrinter*", 36, Smoke::t_class|Smoke::tf_ptr },	//49
    { "QRect", 37, Smoke::t_class|Smoke::tf_stack },	//50
    { "QRegExp&", 38, Smoke::t_class|Smoke::tf_ref },	//51
    { "QResizeEvent*", 40, Smoke::t_class|Smoke::tf_ptr },	//52
    { "QScriptEngine::ValueOwnership", 0, Smoke::t_enum|Smoke::tf_stack },	//53
    { "QShowEvent*", 41, Smoke::t_class|Smoke::tf_ptr },	//54
    { "QSize", 42, Smoke::t_class|Smoke::tf_stack },	//55
    { "QSsl::AlternateNameEntryType", 0, Smoke::t_enum|Smoke::tf_stack },	//56
    { "QSsl::EncodingFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//57
    { "QSsl::KeyAlgorithm", 0, Smoke::t_enum|Smoke::tf_stack },	//58
    { "QSsl::KeyType", 0, Smoke::t_enum|Smoke::tf_stack },	//59
    { "QSsl::SslOption", 0, Smoke::t_enum|Smoke::tf_stack },	//60
    { "QSsl::SslProtocol", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//62
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//63
    { "QString*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//64
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//65
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//66
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//67
    { "QStyle&", 43, Smoke::t_class|Smoke::tf_ref },	//68
    { "QTabletEvent*", 44, Smoke::t_class|Smoke::tf_ptr },	//69
    { "QTimerEvent*", 45, Smoke::t_class|Smoke::tf_ptr },	//70
    { "QUndoStack*", 46, Smoke::t_class|Smoke::tf_ptr },	//71
    { "QUrl", 47, Smoke::t_class|Smoke::tf_stack },	//72
    { "QUrl&", 47, Smoke::t_class|Smoke::tf_ref },	//73
    { "QVariant", 48, Smoke::t_class|Smoke::tf_stack },	//74
    { "QWebDatabase", 49, Smoke::t_class|Smoke::tf_stack },	//75
    { "QWebDatabase&", 49, Smoke::t_class|Smoke::tf_ref },	//76
    { "QWebDatabase*", 49, Smoke::t_class|Smoke::tf_ptr },	//77
    { "QWebElement", 50, Smoke::t_class|Smoke::tf_stack },	//78
    { "QWebElement&", 50, Smoke::t_class|Smoke::tf_ref },	//79
    { "QWebElement*", 50, Smoke::t_class|Smoke::tf_ptr },	//80
    { "QWebElement::StyleResolveStrategy", 50, Smoke::t_enum|Smoke::tf_stack },	//81
    { "QWebElementCollection", 51, Smoke::t_class|Smoke::tf_stack },	//82
    { "QWebElementCollection&", 51, Smoke::t_class|Smoke::tf_ref },	//83
    { "QWebElementCollection*", 51, Smoke::t_class|Smoke::tf_ptr },	//84
    { "QWebElementCollection::const_iterator", 52, Smoke::t_class|Smoke::tf_stack },	//85
    { "QWebElementCollection::const_iterator&", 52, Smoke::t_class|Smoke::tf_ref },	//86
    { "QWebElementCollection::const_iterator*", 52, Smoke::t_class|Smoke::tf_ptr },	//87
    { "QWebElementCollection::iterator", 53, Smoke::t_class|Smoke::tf_stack },	//88
    { "QWebElementCollection::iterator&", 53, Smoke::t_class|Smoke::tf_ref },	//89
    { "QWebElementCollection::iterator*", 53, Smoke::t_class|Smoke::tf_ptr },	//90
    { "QWebFrame*", 54, Smoke::t_class|Smoke::tf_ptr },	//91
    { "QWebFrame::RenderLayer", 54, Smoke::t_enum|Smoke::tf_stack },	//92
    { "QWebHistory*", 55, Smoke::t_class|Smoke::tf_ptr },	//93
    { "QWebHistoryInterface*", 56, Smoke::t_class|Smoke::tf_ptr },	//94
    { "QWebHistoryItem", 57, Smoke::t_class|Smoke::tf_stack },	//95
    { "QWebHistoryItem&", 57, Smoke::t_class|Smoke::tf_ref },	//96
    { "QWebHistoryItem*", 57, Smoke::t_class|Smoke::tf_ptr },	//97
    { "QWebHitTestResult", 58, Smoke::t_class|Smoke::tf_stack },	//98
    { "QWebHitTestResult&", 58, Smoke::t_class|Smoke::tf_ref },	//99
    { "QWebHitTestResult*", 58, Smoke::t_class|Smoke::tf_ptr },	//100
    { "QWebInspector*", 59, Smoke::t_class|Smoke::tf_ptr },	//101
    { "QWebPage*", 60, Smoke::t_class|Smoke::tf_ptr },	//102
    { "QWebPage::ChooseMultipleFilesExtensionOption*", 61, Smoke::t_class|Smoke::tf_ptr },	//103
    { "QWebPage::ChooseMultipleFilesExtensionReturn*", 62, Smoke::t_class|Smoke::tf_ptr },	//104
    { "QWebPage::ErrorDomain", 60, Smoke::t_enum|Smoke::tf_stack },	//105
    { "QWebPage::ErrorPageExtensionOption*", 63, Smoke::t_class|Smoke::tf_ptr },	//106
    { "QWebPage::ErrorPageExtensionReturn*", 64, Smoke::t_class|Smoke::tf_ptr },	//107
    { "QWebPage::Extension", 60, Smoke::t_enum|Smoke::tf_stack },	//108
    { "QWebPage::ExtensionOption*", 65, Smoke::t_class|Smoke::tf_ptr },	//109
    { "QWebPage::ExtensionReturn*", 66, Smoke::t_class|Smoke::tf_ptr },	//110
    { "QWebPage::Feature", 60, Smoke::t_enum|Smoke::tf_stack },	//111
    { "QWebPage::FindFlag", 60, Smoke::t_enum|Smoke::tf_stack },	//112
    { "QWebPage::LinkDelegationPolicy", 60, Smoke::t_enum|Smoke::tf_stack },	//113
    { "QWebPage::NavigationType", 60, Smoke::t_enum|Smoke::tf_stack },	//114
    { "QWebPage::PermissionPolicy", 60, Smoke::t_enum|Smoke::tf_stack },	//115
    { "QWebPage::ViewportAttributes", 67, Smoke::t_class|Smoke::tf_stack },	//116
    { "QWebPage::ViewportAttributes&", 67, Smoke::t_class|Smoke::tf_ref },	//117
    { "QWebPage::ViewportAttributes*", 67, Smoke::t_class|Smoke::tf_ptr },	//118
    { "QWebPage::WebAction", 60, Smoke::t_enum|Smoke::tf_stack },	//119
    { "QWebPage::WebWindowType", 60, Smoke::t_enum|Smoke::tf_stack },	//120
    { "QWebPagePrivate*", 68, Smoke::t_class|Smoke::tf_ptr },	//121
    { "QWebPluginFactory*", 69, Smoke::t_class|Smoke::tf_ptr },	//122
    { "QWebPluginFactory::Extension", 69, Smoke::t_enum|Smoke::tf_stack },	//123
    { "QWebPluginFactory::ExtensionOption*", 70, Smoke::t_class|Smoke::tf_ptr },	//124
    { "QWebPluginFactory::ExtensionReturn*", 71, Smoke::t_class|Smoke::tf_ptr },	//125
    { "QWebPluginFactory::MimeType", 72, Smoke::t_class|Smoke::tf_stack },	//126
    { "QWebPluginFactory::MimeType*", 72, Smoke::t_class|Smoke::tf_ptr },	//127
    { "QWebPluginFactory::Plugin", 73, Smoke::t_class|Smoke::tf_stack },	//128
    { "QWebPluginFactory::Plugin*", 73, Smoke::t_class|Smoke::tf_ptr },	//129
    { "QWebSecurityOrigin", 74, Smoke::t_class|Smoke::tf_stack },	//130
    { "QWebSecurityOrigin&", 74, Smoke::t_class|Smoke::tf_ref },	//131
    { "QWebSecurityOrigin*", 74, Smoke::t_class|Smoke::tf_ptr },	//132
    { "QWebSettings*", 75, Smoke::t_class|Smoke::tf_ptr },	//133
    { "QWebSettings::FontFamily", 75, Smoke::t_enum|Smoke::tf_stack },	//134
    { "QWebSettings::FontSize", 75, Smoke::t_enum|Smoke::tf_stack },	//135
    { "QWebSettings::WebAttribute", 75, Smoke::t_enum|Smoke::tf_stack },	//136
    { "QWebSettings::WebGraphic", 75, Smoke::t_enum|Smoke::tf_stack },	//137
    { "QWebSettingsPrivate*", 76, Smoke::t_class|Smoke::tf_ptr },	//138
    { "QWebView*", 77, Smoke::t_class|Smoke::tf_ptr },	//139
    { "QWheelEvent*", 78, Smoke::t_class|Smoke::tf_ptr },	//140
    { "QWidget*", 79, Smoke::t_class|Smoke::tf_ptr },	//141
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//159
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//162
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//164
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//166
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//167
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//168
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//169
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//170
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//175
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//214
    { "QtConcurrent::ReduceOptions::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//215
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//216
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//217
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//218
    { "const QByteArray&", 4, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//219
    { "const QFont&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//220
    { "const QList<QWebPluginFactory::MimeType>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//221
    { "const QMetaObject&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//222
    { "const QMetaObject*", 23, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//223
    { "const QNetworkRequest&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//224
    { "const QPalette&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//225
    { "const QPixmap&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//226
    { "const QPoint&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//227
    { "const QRect&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//228
    { "const QRegExp&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//229
    { "const QRegion&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//230
    { "const QSize&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//231
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//232
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//233
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//234
    { "const QUrl&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//235
    { "const QVariant&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//236
    { "const QWebDatabase&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//237
    { "const QWebElement", 50, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//238
    { "const QWebElement&", 50, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//239
    { "const QWebElementCollection&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//240
    { "const QWebElementCollection*", 51, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//241
    { "const QWebElementCollection::const_iterator&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//242
    { "const QWebElementCollection::iterator&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//243
    { "const QWebHistoryItem&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//244
    { "const QWebHitTestResult&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//245
    { "const QWebPage::ChooseMultipleFilesExtensionOption&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//246
    { "const QWebPage::ChooseMultipleFilesExtensionReturn&", 62, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//247
    { "const QWebPage::ErrorPageExtensionOption&", 63, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//248
    { "const QWebPage::ErrorPageExtensionReturn&", 64, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//249
    { "const QWebPage::ExtensionOption&", 65, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//250
    { "const QWebPage::ExtensionOption*", 65, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//251
    { "const QWebPage::ExtensionReturn&", 66, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//252
    { "const QWebPage::ViewportAttributes&", 67, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//253
    { "const QWebPluginFactory::ExtensionOption&", 70, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//254
    { "const QWebPluginFactory::ExtensionOption*", 70, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//255
    { "const QWebPluginFactory::ExtensionReturn&", 71, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//256
    { "const QWebPluginFactory::MimeType&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//257
    { "const QWebPluginFactory::Plugin&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//258
    { "const QWebSecurityOrigin&", 74, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//259
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//260
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//261
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//262
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//263
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//264
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//265
    { "quint64", 0, Smoke::t_voidp|Smoke::tf_stack },	//266
    { "std::bidirectional_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//267
    { "std::forward_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//268
    { "std::random_access_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//269
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//270
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//271
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//272
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//273
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    14, 0,	//1  QEvent*
    40, 14, 0,	//3  QObject*, QEvent*
    70, 0,	//6  QTimerEvent*
    5, 0,	//8  QChildEvent*
    260, 0,	//10  const char*
    237, 0,	//12  const QWebDatabase&
    239, 0,	//14  const QWebElement&
    232, 0,	//16  const QString&
    232, 232, 0,	//18  const QString&, const QString&
    232, 232, 232, 0,	//21  const QString&, const QString&, const QString&
    232, 81, 0,	//25  const QString&, QWebElement::StyleResolveStrategy
    44, 0,	//28  QPainter*
    44, 228, 0,	//30  QPainter*, const QRect&
    239, 232, 0,	//33  const QWebElement&, const QString&
    240, 0,	//36  const QWebElementCollection&
    263, 0,	//38  int
    241, 263, 0,	//40  const QWebElementCollection*, int
    242, 0,	//43  const QWebElementCollection::const_iterator&
    85, 0,	//45  QWebElementCollection::const_iterator
    243, 0,	//47  const QWebElementCollection::iterator&
    88, 0,	//49  QWebElementCollection::iterator
    260, 260, 0,	//51  const char*, const char*
    260, 260, 263, 0,	//54  const char*, const char*, int
    32, 263, 272, 0,	//58  QMetaObject::Call, int, void**
    235, 0,	//62  const QUrl&
    224, 37, 219, 0,	//64  const QNetworkRequest&, QNetworkAccessManager::Operation, const QByteArray&
    232, 235, 0,	//68  const QString&, const QUrl&
    219, 232, 235, 0,	//71  const QByteArray&, const QString&, const QUrl&
    232, 40, 0,	//75  const QString&, QObject*
    232, 40, 53, 0,	//78  const QString&, QObject*, QScriptEngine::ValueOwnership
    188, 0,	//82  Qt::Orientation
    188, 192, 0,	//84  Qt::Orientation, Qt::ScrollBarPolicy
    188, 263, 0,	//87  Qt::Orientation, int
    263, 263, 0,	//90  int, int
    227, 0,	//93  const QPoint&
    44, 230, 0,	//95  QPainter*, const QRegion&
    44, 92, 230, 0,	//98  QPainter*, QWebFrame::RenderLayer, const QRegion&
    262, 0,	//102  double
    49, 0,	//104  QPrinter*
    231, 0,	//106  const QSize&
    218, 0,	//108  bool
    224, 0,	//110  const QNetworkRequest&
    224, 37, 0,	//112  const QNetworkRequest&, QNetworkAccessManager::Operation
    219, 0,	//115  const QByteArray&
    219, 232, 0,	//117  const QByteArray&, const QString&
    44, 92, 0,	//120  QPainter*, QWebFrame::RenderLayer
    244, 0,	//123  const QWebHistoryItem&
    40, 0,	//125  QObject*
    94, 0,	//127  QWebHistoryInterface*
    236, 0,	//129  const QVariant&
    245, 0,	//131  const QWebHitTestResult&
    141, 0,	//133  QWidget*
    102, 0,	//135  QWebPage*
    52, 0,	//137  QResizeEvent*
    54, 0,	//139  QShowEvent*
    19, 0,	//141  QHideEvent*
    6, 0,	//143  QCloseEvent*
    36, 0,	//145  QNetworkAccessManager*
    122, 0,	//147  QWebPluginFactory*
    119, 0,	//149  QWebPage::WebAction
    119, 218, 0,	//151  QWebPage::WebAction, bool
    228, 0,	//154  const QRect&
    176, 0,	//156  Qt::InputMethodQuery
    232, 16, 0,	//158  const QString&, QFlags<QWebPage::FindFlag>
    113, 0,	//161  QWebPage::LinkDelegationPolicy
    225, 0,	//163  const QPalette&
    7, 0,	//165  QContextMenuEvent*
    91, 111, 115, 0,	//167  QWebFrame*, QWebPage::Feature, QWebPage::PermissionPolicy
    108, 251, 110, 0,	//171  QWebPage::Extension, const QWebPage::ExtensionOption*, QWebPage::ExtensionReturn*
    108, 0,	//175  QWebPage::Extension
    91, 0,	//177  QWebFrame*
    263, 263, 228, 0,	//179  int, int, const QRect&
    38, 0,	//183  QNetworkReply*
    91, 62, 0,	//185  QWebFrame*, QString
    132, 266, 0,	//188  QWebSecurityOrigin*, quint64
    91, 97, 0,	//191  QWebFrame*, QWebHistoryItem*
    91, 111, 0,	//194  QWebFrame*, QWebPage::Feature
    120, 0,	//197  QWebPage::WebWindowType
    232, 235, 233, 233, 0,	//199  const QString&, const QUrl&, const QStringList&, const QStringList&
    91, 224, 114, 0,	//204  QWebFrame*, const QNetworkRequest&, QWebPage::NavigationType
    91, 232, 0,	//208  QWebFrame*, const QString&
    91, 232, 232, 64, 0,	//211  QWebFrame*, const QString&, const QString&, QString*
    232, 263, 232, 0,	//216  const QString&, int, const QString&
    108, 251, 0,	//220  QWebPage::Extension, const QWebPage::ExtensionOption*
    246, 0,	//223  const QWebPage::ChooseMultipleFilesExtensionOption&
    233, 0,	//225  const QStringList&
    247, 0,	//227  const QWebPage::ChooseMultipleFilesExtensionReturn&
    248, 0,	//229  const QWebPage::ErrorPageExtensionOption&
    105, 0,	//231  QWebPage::ErrorDomain
    249, 0,	//233  const QWebPage::ErrorPageExtensionReturn&
    250, 0,	//235  const QWebPage::ExtensionOption&
    252, 0,	//237  const QWebPage::ExtensionReturn&
    253, 0,	//239  const QWebPage::ViewportAttributes&
    123, 255, 125, 0,	//241  QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*, QWebPluginFactory::ExtensionReturn*
    123, 0,	//245  QWebPluginFactory::Extension
    123, 255, 0,	//247  QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*
    254, 0,	//250  const QWebPluginFactory::ExtensionOption&
    256, 0,	//252  const QWebPluginFactory::ExtensionReturn&
    257, 0,	//254  const QWebPluginFactory::MimeType&
    258, 0,	//256  const QWebPluginFactory::Plugin&
    221, 0,	//258  const QList<QWebPluginFactory::MimeType>&
    265, 0,	//260  long long
    259, 0,	//262  const QWebSecurityOrigin&
    134, 232, 0,	//264  QWebSettings::FontFamily, const QString&
    134, 0,	//267  QWebSettings::FontFamily
    135, 263, 0,	//269  QWebSettings::FontSize, int
    135, 0,	//272  QWebSettings::FontSize
    136, 218, 0,	//274  QWebSettings::WebAttribute, bool
    136, 0,	//277  QWebSettings::WebAttribute
    137, 226, 0,	//279  QWebSettings::WebGraphic, const QPixmap&
    137, 0,	//282  QWebSettings::WebGraphic
    263, 263, 263, 0,	//284  int, int, int
    15, 0,	//288  QFlags<QPainter::RenderHint>
    45, 218, 0,	//290  QPainter::RenderHint, bool
    43, 0,	//293  QPaintEvent*
    33, 0,	//295  QMouseEvent*
    140, 0,	//297  QWheelEvent*
    23, 0,	//299  QKeyEvent*
    9, 0,	//301  QDragEnterEvent*
    10, 0,	//303  QDragLeaveEvent*
    11, 0,	//305  QDragMoveEvent*
    13, 0,	//307  QDropEvent*
    18, 0,	//309  QFocusEvent*
    22, 0,	//311  QInputMethodEvent*
    45, 0,	//313  QPainter::RenderHint
    34, 0,	//315  QMoveEvent*
    69, 0,	//317  QTabletEvent*
    2, 0,	//319  QActionEvent*
    217, 0,	//321  _XEvent*
    41, 0,	//323  QPaintDevice::PaintDeviceMetric
    68, 0,	//325  QStyle&
    220, 0,	//327  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AcceleratedCompositingEnabled",	//1
    "AlignCenter",	//2
    "AlignJustified",	//3
    "AlignLeft",	//4
    "AlignRight",	//5
    "AllLayers",	//6
    "AutoLoadImages",	//7
    "Back",	//8
    "CascadedStyle",	//9
    "ChooseMultipleFilesExtension",	//10
    "ChooseMultipleFilesExtensionOption",	//11
    "ChooseMultipleFilesExtensionOption#",	//12
    "ChooseMultipleFilesExtensionReturn",	//13
    "ChooseMultipleFilesExtensionReturn#",	//14
    "ComputedStyle",	//15
    "ContentsLayer",	//16
    "Copy",	//17
    "CopyImageToClipboard",	//18
    "CopyImageUrlToClipboard",	//19
    "CopyLinkToClipboard",	//20
    "CursiveFont",	//21
    "Cut",	//22
    "DefaultFixedFontSize",	//23
    "DefaultFontSize",	//24
    "DefaultFrameIconGraphic",	//25
    "DelegateAllLinks",	//26
    "DelegateExternalLinks",	//27
    "DeleteButtonGraphic",	//28
    "DeleteEndOfWord",	//29
    "DeleteStartOfWord",	//30
    "DeveloperExtrasEnabled",	//31
    "DnsPrefetchEnabled",	//32
    "DontDelegateLinks",	//33
    "DownloadImageToDisk",	//34
    "DownloadLinkToDisk",	//35
    "DrawChildren",	//36
    "DrawWindowBackground",	//37
    "ErrorPageExtension",	//38
    "ErrorPageExtensionOption",	//39
    "ErrorPageExtensionOption#",	//40
    "ErrorPageExtensionReturn",	//41
    "ErrorPageExtensionReturn#",	//42
    "ExtensionOption",	//43
    "ExtensionOption#",	//44
    "ExtensionReturn",	//45
    "ExtensionReturn#",	//46
    "FantasyFont",	//47
    "FindBackward",	//48
    "FindCaseSensitively",	//49
    "FindWrapsAroundDocument",	//50
    "FixedFont",	//51
    "Forward",	//52
    "FrameFlatteningEnabled",	//53
    "Geolocation",	//54
    "HighlightAllOccurrences",	//55
    "Http",	//56
    "HyperlinkAuditingEnabled",	//57
    "IgnoreMask",	//58
    "Indent",	//59
    "InlineStyle",	//60
    "InputSpeechButtonGraphic",	//61
    "InsertLineSeparator",	//62
    "InsertOrderedList",	//63
    "InsertParagraphSeparator",	//64
    "InsertUnorderedList",	//65
    "InspectElement",	//66
    "JavaEnabled",	//67
    "JavascriptCanAccessClipboard",	//68
    "JavascriptCanCloseWindows",	//69
    "JavascriptCanOpenWindows",	//70
    "JavascriptEnabled",	//71
    "LinksIncludedInFocusChain",	//72
    "LocalContentCanAccessFileUrls",	//73
    "LocalContentCanAccessRemoteUrls",	//74
    "LocalStorageDatabaseEnabled",	//75
    "LocalStorageEnabled",	//76
    "MimeType",	//77
    "MimeType#",	//78
    "MinimumFontSize",	//79
    "MinimumLogicalFontSize",	//80
    "MissingImageGraphic",	//81
    "MissingPluginGraphic",	//82
    "MoveToEndOfBlock",	//83
    "MoveToEndOfDocument",	//84
    "MoveToEndOfLine",	//85
    "MoveToNextChar",	//86
    "MoveToNextLine",	//87
    "MoveToNextWord",	//88
    "MoveToPreviousChar",	//89
    "MoveToPreviousLine",	//90
    "MoveToPreviousWord",	//91
    "MoveToStartOfBlock",	//92
    "MoveToStartOfDocument",	//93
    "MoveToStartOfLine",	//94
    "NavigationTypeBackOrForward",	//95
    "NavigationTypeFormResubmitted",	//96
    "NavigationTypeFormSubmitted",	//97
    "NavigationTypeLinkClicked",	//98
    "NavigationTypeOther",	//99
    "NavigationTypeReload",	//100
    "NoWebAction",	//101
    "Notifications",	//102
    "OfflineStorageDatabaseEnabled",	//103
    "OfflineWebApplicationCacheEnabled",	//104
    "OpenFrameInNewWindow",	//105
    "OpenImageInNewWindow",	//106
    "OpenLink",	//107
    "OpenLinkInNewWindow",	//108
    "Outdent",	//109
    "PanIconLayer",	//110
    "Paste",	//111
    "PasteAndMatchStyle",	//112
    "PermissionDeniedByUser",	//113
    "PermissionGrantedByUser",	//114
    "PermissionUnknown",	//115
    "Plugin",	//116
    "Plugin#",	//117
    "PluginsEnabled",	//118
    "PrintElementBackgrounds",	//119
    "PrivateBrowsingEnabled",	//120
    "QWebDatabase",	//121
    "QWebDatabase#",	//122
    "QWebElement",	//123
    "QWebElement#",	//124
    "QWebElementCollection",	//125
    "QWebElementCollection#",	//126
    "QWebElementCollection#$",	//127
    "QWebHistoryInterface",	//128
    "QWebHistoryInterface#",	//129
    "QWebHistoryItem",	//130
    "QWebHistoryItem#",	//131
    "QWebHitTestResult",	//132
    "QWebHitTestResult#",	//133
    "QWebInspector",	//134
    "QWebInspector#",	//135
    "QWebPage",	//136
    "QWebPage#",	//137
    "QWebPluginFactory",	//138
    "QWebPluginFactory#",	//139
    "QWebSecurityOrigin",	//140
    "QWebSecurityOrigin#",	//141
    "QWebView",	//142
    "QWebView#",	//143
    "QtNetwork",	//144
    "Redo",	//145
    "Reload",	//146
    "ReloadAndBypassCache",	//147
    "RemoveFormat",	//148
    "SansSerifFont",	//149
    "ScrollBarLayer",	//150
    "SearchCancelButtonGraphic",	//151
    "SearchCancelButtonPressedGraphic",	//152
    "SelectAll",	//153
    "SelectEndOfBlock",	//154
    "SelectEndOfDocument",	//155
    "SelectEndOfLine",	//156
    "SelectNextChar",	//157
    "SelectNextLine",	//158
    "SelectNextWord",	//159
    "SelectPreviousChar",	//160
    "SelectPreviousLine",	//161
    "SelectPreviousWord",	//162
    "SelectStartOfBlock",	//163
    "SelectStartOfDocument",	//164
    "SelectStartOfLine",	//165
    "SerifFont",	//166
    "SetTextDirectionDefault",	//167
    "SetTextDirectionLeftToRight",	//168
    "SetTextDirectionRightToLeft",	//169
    "SiteSpecificQuirksEnabled",	//170
    "SpatialNavigationEnabled",	//171
    "StandardFont",	//172
    "Stop",	//173
    "StopScheduledPageRefresh",	//174
    "TextAreaSizeGripCornerGraphic",	//175
    "TiledBackingStoreEnabled",	//176
    "ToggleBold",	//177
    "ToggleItalic",	//178
    "ToggleStrikethrough",	//179
    "ToggleSubscript",	//180
    "ToggleSuperscript",	//181
    "ToggleUnderline",	//182
    "Undo",	//183
    "ViewportAttributes",	//184
    "ViewportAttributes#",	//185
    "WebActionCount",	//186
    "WebBrowserWindow",	//187
    "WebGLEnabled",	//188
    "WebKit",	//189
    "WebModalDialog",	//190
    "XSSAuditingEnabled",	//191
    "ZoomTextOnly",	//192
    "acceptNavigationRequest",	//193
    "acceptNavigationRequest##$",	//194
    "action",	//195
    "action$",	//196
    "actionEvent",	//197
    "addClass",	//198
    "addClass$",	//199
    "addHistoryEntry",	//200
    "addHistoryEntry$",	//201
    "addLocalScheme",	//202
    "addLocalScheme$",	//203
    "addToJavaScriptWindowObject",	//204
    "addToJavaScriptWindowObject$#",	//205
    "addToJavaScriptWindowObject$#$",	//206
    "allOrigins",	//207
    "alternateText",	//208
    "append",	//209
    "append#",	//210
    "appendInside",	//211
    "appendInside#",	//212
    "appendInside$",	//213
    "appendOutside",	//214
    "appendOutside#",	//215
    "appendOutside$",	//216
    "applicationCacheQuotaExceeded",	//217
    "applicationCacheQuotaExceeded#$",	//218
    "at",	//219
    "at$",	//220
    "attribute",	//221
    "attribute$",	//222
    "attribute$$",	//223
    "attributeNS",	//224
    "attributeNS$$",	//225
    "attributeNS$$$",	//226
    "attributeNames",	//227
    "attributeNames$",	//228
    "back",	//229
    "backItem",	//230
    "backItems",	//231
    "backItems$",	//232
    "baseUrl",	//233
    "begin",	//234
    "boundingRect",	//235
    "bytesReceived",	//236
    "canGoBack",	//237
    "canGoForward",	//238
    "changeEvent",	//239
    "changeEvent#",	//240
    "childEvent",	//241
    "childFrames",	//242
    "chooseFile",	//243
    "chooseFile#$",	//244
    "classes",	//245
    "clear",	//246
    "clearIconDatabase",	//247
    "clearMemoryCaches",	//248
    "clone",	//249
    "closeEvent",	//250
    "closeEvent#",	//251
    "connectNotify",	//252
    "constBegin",	//253
    "constEnd",	//254
    "const_iterator",	//255
    "const_iterator#",	//256
    "const_iterator#$",	//257
    "content",	//258
    "contentType",	//259
    "contentsChanged",	//260
    "contentsSize",	//261
    "contentsSizeChanged",	//262
    "contentsSizeChanged#",	//263
    "contextMenuEvent",	//264
    "contextMenuEvent#",	//265
    "count",	//266
    "create",	//267
    "create$#??",	//268
    "createPlugin",	//269
    "createPlugin$#??",	//270
    "createStandardContextMenu",	//271
    "createWindow",	//272
    "createWindow$",	//273
    "currentFrame",	//274
    "currentItem",	//275
    "currentItemIndex",	//276
    "customEvent",	//277
    "databaseQuota",	//278
    "databaseQuotaExceeded",	//279
    "databaseQuotaExceeded#$",	//280
    "databaseUsage",	//281
    "databases",	//282
    "defaultInterface",	//283
    "defaultTextEncoding",	//284
    "description",	//285
    "devType",	//286
    "devicePixelRatio",	//287
    "disconnectNotify",	//288
    "displayName",	//289
    "document",	//290
    "documentElement",	//291
    "domain",	//292
    "downloadRequested",	//293
    "downloadRequested#",	//294
    "dragEnterEvent",	//295
    "dragEnterEvent#",	//296
    "dragLeaveEvent",	//297
    "dragLeaveEvent#",	//298
    "dragMoveEvent",	//299
    "dragMoveEvent#",	//300
    "dropEvent",	//301
    "dropEvent#",	//302
    "element",	//303
    "enablePersistentStorage",	//304
    "enablePersistentStorage$",	//305
    "enabledChange",	//306
    "encloseContentsWith",	//307
    "encloseContentsWith#",	//308
    "encloseContentsWith$",	//309
    "encloseWith",	//310
    "encloseWith#",	//311
    "encloseWith$",	//312
    "enclosingBlockElement",	//313
    "encoding",	//314
    "end",	//315
    "enterEvent",	//316
    "error",	//317
    "errorString",	//318
    "evaluateJavaScript",	//319
    "evaluateJavaScript$",	//320
    "event",	//321
    "event#",	//322
    "eventFilter",	//323
    "expectedSize",	//324
    "extension",	//325
    "extension$",	//326
    "extension$#",	//327
    "extension$##",	//328
    "featurePermissionRequestCanceled",	//329
    "featurePermissionRequestCanceled#$",	//330
    "featurePermissionRequested",	//331
    "featurePermissionRequested#$",	//332
    "fileExtensions",	//333
    "fileName",	//334
    "fileNames",	//335
    "findAll",	//336
    "findAll$",	//337
    "findAllElements",	//338
    "findAllElements$",	//339
    "findFirst",	//340
    "findFirst$",	//341
    "findFirstElement",	//342
    "findFirstElement$",	//343
    "findText",	//344
    "findText$",	//345
    "findText$$",	//346
    "first",	//347
    "firstChild",	//348
    "focusInEvent",	//349
    "focusInEvent#",	//350
    "focusNextPrevChild",	//351
    "focusNextPrevChild$",	//352
    "focusOutEvent",	//353
    "focusOutEvent#",	//354
    "fontChange",	//355
    "fontFamily",	//356
    "fontFamily$",	//357
    "fontSize",	//358
    "fontSize$",	//359
    "forward",	//360
    "forwardItem",	//361
    "forwardItems",	//362
    "forwardItems$",	//363
    "forwardUnsupportedContent",	//364
    "frame",	//365
    "frameAt",	//366
    "frameAt#",	//367
    "frameCreated",	//368
    "frameCreated#",	//369
    "frameName",	//370
    "geometry",	//371
    "geometryChangeRequested",	//372
    "geometryChangeRequested#",	//373
    "globalSettings",	//374
    "goToItem",	//375
    "goToItem#",	//376
    "handle",	//377
    "hasAttribute",	//378
    "hasAttribute$",	//379
    "hasAttributeNS",	//380
    "hasAttributeNS$$",	//381
    "hasAttributes",	//382
    "hasClass",	//383
    "hasClass$",	//384
    "hasFocus",	//385
    "hasSelection",	//386
    "heightForWidth",	//387
    "hideEvent",	//388
    "hideEvent#",	//389
    "history",	//390
    "historyContains",	//391
    "historyContains$",	//392
    "hitTestContent",	//393
    "hitTestContent#",	//394
    "host",	//395
    "icon",	//396
    "iconChanged",	//397
    "iconDatabasePath",	//398
    "iconForUrl",	//399
    "iconForUrl#",	//400
    "imageUrl",	//401
    "initialLayoutCompleted",	//402
    "initialScaleFactor",	//403
    "inputMethodEvent",	//404
    "inputMethodEvent#",	//405
    "inputMethodQuery",	//406
    "inputMethodQuery$",	//407
    "isContentEditable",	//408
    "isContentSelected",	//409
    "isModified",	//410
    "isNull",	//411
    "isUserScalable",	//412
    "isValid",	//413
    "itemAt",	//414
    "itemAt$",	//415
    "items",	//416
    "iterator",	//417
    "iterator#",	//418
    "iterator#$",	//419
    "javaScriptAlert",	//420
    "javaScriptAlert#$",	//421
    "javaScriptConfirm",	//422
    "javaScriptConfirm#$",	//423
    "javaScriptConsoleMessage",	//424
    "javaScriptConsoleMessage$$$",	//425
    "javaScriptPrompt",	//426
    "javaScriptPrompt#$$$",	//427
    "javaScriptWindowObjectCleared",	//428
    "keyPressEvent",	//429
    "keyPressEvent#",	//430
    "keyReleaseEvent",	//431
    "keyReleaseEvent#",	//432
    "languageChange",	//433
    "last",	//434
    "lastChild",	//435
    "lastVisited",	//436
    "leaveEvent",	//437
    "linkClicked",	//438
    "linkClicked#",	//439
    "linkDelegationPolicy",	//440
    "linkElement",	//441
    "linkHovered",	//442
    "linkHovered$$$",	//443
    "linkTargetFrame",	//444
    "linkText",	//445
    "linkTitle",	//446
    "linkUrl",	//447
    "load",	//448
    "load#",	//449
    "load#$",	//450
    "load#$#",	//451
    "loadFinished",	//452
    "loadFinished$",	//453
    "loadProgress",	//454
    "loadProgress$",	//455
    "loadStarted",	//456
    "localName",	//457
    "localSchemes",	//458
    "localStoragePath",	//459
    "mainFrame",	//460
    "maximumItemCount",	//461
    "maximumPagesInCache",	//462
    "maximumScaleFactor",	//463
    "menuBarVisibilityChangeRequested",	//464
    "menuBarVisibilityChangeRequested$",	//465
    "metaData",	//466
    "metaObject",	//467
    "metric",	//468
    "microFocusChanged",	//469
    "mimeTypes",	//470
    "minimumScaleFactor",	//471
    "minimumSizeHint",	//472
    "mouseDoubleClickEvent",	//473
    "mouseDoubleClickEvent#",	//474
    "mouseMoveEvent",	//475
    "mouseMoveEvent#",	//476
    "mousePressEvent",	//477
    "mousePressEvent#",	//478
    "mouseReleaseEvent",	//479
    "mouseReleaseEvent#",	//480
    "moveEvent",	//481
    "name",	//482
    "namespaceUri",	//483
    "networkAccessManager",	//484
    "nextSibling",	//485
    "offlineStorageDefaultQuota",	//486
    "offlineStoragePath",	//487
    "offlineWebApplicationCachePath",	//488
    "offlineWebApplicationCacheQuota",	//489
    "operator!=",	//490
    "operator!=#",	//491
    "operator*",	//492
    "operator+",	//493
    "operator+#",	//494
    "operator+$",	//495
    "operator++",	//496
    "operator++$",	//497
    "operator+=",	//498
    "operator+=#",	//499
    "operator+=$",	//500
    "operator-",	//501
    "operator-#",	//502
    "operator-$",	//503
    "operator--",	//504
    "operator--$",	//505
    "operator-=",	//506
    "operator-=$",	//507
    "operator<",	//508
    "operator<#",	//509
    "operator<=",	//510
    "operator<=#",	//511
    "operator=",	//512
    "operator=#",	//513
    "operator==",	//514
    "operator==#",	//515
    "operator>",	//516
    "operator>#",	//517
    "operator>=",	//518
    "operator>=#",	//519
    "operator[]",	//520
    "operator[]$",	//521
    "origin",	//522
    "originalUrl",	//523
    "page",	//524
    "pageAction",	//525
    "pageAction$",	//526
    "pageChanged",	//527
    "paintEngine",	//528
    "paintEvent",	//529
    "paintEvent#",	//530
    "palette",	//531
    "paletteChange",	//532
    "parent",	//533
    "parentFrame",	//534
    "pixmap",	//535
    "pluginFactory",	//536
    "plugins",	//537
    "port",	//538
    "pos",	//539
    "preferredContentsSize",	//540
    "prefix",	//541
    "prependInside",	//542
    "prependInside#",	//543
    "prependInside$",	//544
    "prependOutside",	//545
    "prependOutside#",	//546
    "prependOutside$",	//547
    "previousSibling",	//548
    "print",	//549
    "print#",	//550
    "printRequested",	//551
    "printRequested#",	//552
    "provisionalLoad",	//553
    "qt_metacall",	//554
    "qt_metacall$$?",	//555
    "qt_metacast",	//556
    "qt_metacast$",	//557
    "refreshPlugins",	//558
    "reload",	//559
    "removeAllChildren",	//560
    "removeAllDatabases",	//561
    "removeAttribute",	//562
    "removeAttribute$",	//563
    "removeAttributeNS",	//564
    "removeAttributeNS$$",	//565
    "removeClass",	//566
    "removeClass$",	//567
    "removeDatabase",	//568
    "removeDatabase#",	//569
    "removeFromDocument",	//570
    "removeLocalScheme",	//571
    "removeLocalScheme$",	//572
    "render",	//573
    "render#",	//574
    "render##",	//575
    "render#$",	//576
    "render#$#",	//577
    "renderHints",	//578
    "renderTreeDump",	//579
    "repaintRequested",	//580
    "repaintRequested#",	//581
    "replace",	//582
    "replace#",	//583
    "replace$",	//584
    "requestedUrl",	//585
    "resetAttribute",	//586
    "resetAttribute$",	//587
    "resetFontFamily",	//588
    "resetFontFamily$",	//589
    "resetFontSize",	//590
    "resetFontSize$",	//591
    "resizeEvent",	//592
    "resizeEvent#",	//593
    "restoreFrameStateRequested",	//594
    "restoreFrameStateRequested#",	//595
    "saveFrameStateRequested",	//596
    "saveFrameStateRequested##",	//597
    "scheme",	//598
    "scroll",	//599
    "scroll$$",	//600
    "scrollBarGeometry",	//601
    "scrollBarGeometry$",	//602
    "scrollBarMaximum",	//603
    "scrollBarMaximum$",	//604
    "scrollBarMinimum",	//605
    "scrollBarMinimum$",	//606
    "scrollBarPolicy",	//607
    "scrollBarPolicy$",	//608
    "scrollBarValue",	//609
    "scrollBarValue$",	//610
    "scrollPosition",	//611
    "scrollRequested",	//612
    "scrollRequested$$#",	//613
    "scrollToAnchor",	//614
    "scrollToAnchor$",	//615
    "securityOrigin",	//616
    "selectedHtml",	//617
    "selectedText",	//618
    "selectionChanged",	//619
    "setActualVisibleContentRect",	//620
    "setActualVisibleContentRect#",	//621
    "setApplicationCacheQuota",	//622
    "setApplicationCacheQuota$",	//623
    "setAttribute",	//624
    "setAttribute$$",	//625
    "setAttributeNS",	//626
    "setAttributeNS$$$",	//627
    "setBaseUrl",	//628
    "setBaseUrl#",	//629
    "setContent",	//630
    "setContent#",	//631
    "setContent#$",	//632
    "setContent#$#",	//633
    "setContentEditable",	//634
    "setContentEditable$",	//635
    "setContentType",	//636
    "setContentType$",	//637
    "setDatabaseQuota",	//638
    "setDatabaseQuota$",	//639
    "setDefaultInterface",	//640
    "setDefaultInterface#",	//641
    "setDefaultTextEncoding",	//642
    "setDefaultTextEncoding$",	//643
    "setDescription",	//644
    "setDescription$",	//645
    "setDomain",	//646
    "setDomain$",	//647
    "setEncoding",	//648
    "setEncoding$",	//649
    "setError",	//650
    "setError$",	//651
    "setErrorString",	//652
    "setErrorString$",	//653
    "setFeaturePermission",	//654
    "setFeaturePermission#$$",	//655
    "setFileExtensions",	//656
    "setFileExtensions?",	//657
    "setFileNames",	//658
    "setFileNames?",	//659
    "setFocus",	//660
    "setFontFamily",	//661
    "setFontFamily$$",	//662
    "setFontSize",	//663
    "setFontSize$$",	//664
    "setForwardUnsupportedContent",	//665
    "setForwardUnsupportedContent$",	//666
    "setFrame",	//667
    "setFrame#",	//668
    "setHtml",	//669
    "setHtml$",	//670
    "setHtml$#",	//671
    "setIconDatabasePath",	//672
    "setIconDatabasePath$",	//673
    "setInnerXml",	//674
    "setInnerXml$",	//675
    "setLinkDelegationPolicy",	//676
    "setLinkDelegationPolicy$",	//677
    "setLocalStoragePath",	//678
    "setLocalStoragePath$",	//679
    "setMaximumItemCount",	//680
    "setMaximumItemCount$",	//681
    "setMaximumPagesInCache",	//682
    "setMaximumPagesInCache$",	//683
    "setMimeTypes",	//684
    "setMimeTypes?",	//685
    "setName",	//686
    "setName$",	//687
    "setNetworkAccessManager",	//688
    "setNetworkAccessManager#",	//689
    "setObjectCacheCapacities",	//690
    "setObjectCacheCapacities$$$",	//691
    "setOfflineStorageDefaultQuota",	//692
    "setOfflineStorageDefaultQuota$",	//693
    "setOfflineStoragePath",	//694
    "setOfflineStoragePath$",	//695
    "setOfflineWebApplicationCachePath",	//696
    "setOfflineWebApplicationCachePath$",	//697
    "setOfflineWebApplicationCacheQuota",	//698
    "setOfflineWebApplicationCacheQuota$",	//699
    "setOuterXml",	//700
    "setOuterXml$",	//701
    "setPage",	//702
    "setPage#",	//703
    "setPalette",	//704
    "setPalette#",	//705
    "setParentFrame",	//706
    "setParentFrame#",	//707
    "setPlainText",	//708
    "setPlainText$",	//709
    "setPluginFactory",	//710
    "setPluginFactory#",	//711
    "setPreferredContentsSize",	//712
    "setPreferredContentsSize#",	//713
    "setRenderHint",	//714
    "setRenderHint$",	//715
    "setRenderHint$$",	//716
    "setRenderHints",	//717
    "setRenderHints$",	//718
    "setScrollBarPolicy",	//719
    "setScrollBarPolicy$$",	//720
    "setScrollBarValue",	//721
    "setScrollBarValue$$",	//722
    "setScrollPosition",	//723
    "setScrollPosition#",	//724
    "setStyleProperty",	//725
    "setStyleProperty$$",	//726
    "setSuggestedFileNames",	//727
    "setSuggestedFileNames?",	//728
    "setTextSizeMultiplier",	//729
    "setTextSizeMultiplier$",	//730
    "setUrl",	//731
    "setUrl#",	//732
    "setUserData",	//733
    "setUserData#",	//734
    "setUserStyleSheetUrl",	//735
    "setUserStyleSheetUrl#",	//736
    "setView",	//737
    "setView#",	//738
    "setViewportSize",	//739
    "setViewportSize#",	//740
    "setVisible",	//741
    "setWebGraphic",	//742
    "setWebGraphic$#",	//743
    "setZoomFactor",	//744
    "setZoomFactor$",	//745
    "settings",	//746
    "shouldInterruptJavaScript",	//747
    "showEvent",	//748
    "showEvent#",	//749
    "size",	//750
    "sizeHint",	//751
    "staticMetaObject",	//752
    "statusBarMessage",	//753
    "statusBarMessage$",	//754
    "statusBarVisibilityChangeRequested",	//755
    "statusBarVisibilityChangeRequested$",	//756
    "stop",	//757
    "styleChange",	//758
    "styleProperty",	//759
    "styleProperty$$",	//760
    "suggestedFileNames",	//761
    "supportedContentTypes",	//762
    "supportsContentType",	//763
    "supportsContentType$",	//764
    "supportsExtension",	//765
    "supportsExtension$",	//766
    "swallowContextMenuEvent",	//767
    "swallowContextMenuEvent#",	//768
    "tabletEvent",	//769
    "tagName",	//770
    "takeFromDocument",	//771
    "testAttribute",	//772
    "testAttribute$",	//773
    "textSizeMultiplier",	//774
    "timerEvent",	//775
    "title",	//776
    "titleChanged",	//777
    "titleChanged$",	//778
    "toHtml",	//779
    "toInnerXml",	//780
    "toList",	//781
    "toOuterXml",	//782
    "toPlainText",	//783
    "toggleClass",	//784
    "toggleClass$",	//785
    "toolBarVisibilityChangeRequested",	//786
    "toolBarVisibilityChangeRequested$",	//787
    "totalBytes",	//788
    "tr",	//789
    "tr$",	//790
    "tr$$",	//791
    "tr$$$",	//792
    "trUtf8",	//793
    "trUtf8$",	//794
    "trUtf8$$",	//795
    "trUtf8$$$",	//796
    "triggerAction",	//797
    "triggerAction$",	//798
    "triggerAction$$",	//799
    "triggerPageAction",	//800
    "triggerPageAction$",	//801
    "triggerPageAction$$",	//802
    "undoStack",	//803
    "unsupportedContent",	//804
    "unsupportedContent#",	//805
    "updatePositionDependentActions",	//806
    "updatePositionDependentActions#",	//807
    "url",	//808
    "urlChanged",	//809
    "urlChanged#",	//810
    "userAgentForUrl",	//811
    "userAgentForUrl#",	//812
    "userData",	//813
    "userStyleSheetUrl",	//814
    "view",	//815
    "viewportAttributesForSize",	//816
    "viewportAttributesForSize#",	//817
    "viewportChangeRequested",	//818
    "viewportSize",	//819
    "webFrame",	//820
    "webGraphic",	//821
    "webGraphic$",	//822
    "wheelEvent",	//823
    "wheelEvent#",	//824
    "windowActivationChange",	//825
    "windowCloseRequested",	//826
    "x11Event",	//827
    "zoomFactor",	//828
    "~ChooseMultipleFilesExtensionOption",	//829
    "~ChooseMultipleFilesExtensionReturn",	//830
    "~ErrorPageExtensionOption",	//831
    "~ErrorPageExtensionReturn",	//832
    "~ExtensionOption",	//833
    "~ExtensionReturn",	//834
    "~MimeType",	//835
    "~Plugin",	//836
    "~QWebDatabase",	//837
    "~QWebElement",	//838
    "~QWebElementCollection",	//839
    "~QWebHistoryInterface",	//840
    "~QWebHistoryItem",	//841
    "~QWebHitTestResult",	//842
    "~QWebInspector",	//843
    "~QWebPage",	//844
    "~QWebPluginFactory",	//845
    "~QWebSecurityOrigin",	//846
    "~QWebView",	//847
    "~ViewportAttributes",	//848
    "~const_iterator",	//849
    "~iterator",	//850
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {29, 321, 1, 1, Smoke::mf_virtual, 218, 0},	//1 QObject::event(QEvent*)
    {29, 323, 3, 2, Smoke::mf_virtual, 218, 0},	//2 QObject::eventFilter(QObject*, QEvent*)
    {29, 775, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3 QObject::timerEvent(QTimerEvent*)
    {29, 241, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//4 QObject::childEvent(QChildEvent*)
    {29, 277, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//5 QObject::customEvent(QEvent*)
    {29, 252, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 QObject::connectNotify(const char*)
    {29, 288, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 QObject::disconnectNotify(const char*)
    {49, 121, 12, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 77, 1},	//8 QWebDatabase::QWebDatabase(const QWebDatabase&)
    {49, 512, 12, 1, 0, 76, 2},	//9 QWebDatabase::operator=(const QWebDatabase&)
    {49, 482, 0, 0, Smoke::mf_const, 62, 3},	//10 QWebDatabase::name() const
    {49, 289, 0, 0, Smoke::mf_const, 62, 4},	//11 QWebDatabase::displayName() const
    {49, 324, 0, 0, Smoke::mf_const, 265, 5},	//12 QWebDatabase::expectedSize() const
    {49, 750, 0, 0, Smoke::mf_const, 265, 6},	//13 QWebDatabase::size() const
    {49, 334, 0, 0, Smoke::mf_const, 62, 7},	//14 QWebDatabase::fileName() const
    {49, 522, 0, 0, Smoke::mf_const, 130, 8},	//15 QWebDatabase::origin() const
    {49, 568, 12, 1, Smoke::mf_static, 0, 9},	//16 QWebDatabase::removeDatabase(const QWebDatabase&)
    {49, 561, 0, 0, Smoke::mf_static, 0, 10},	//17 QWebDatabase::removeAllDatabases()
    {49, 837, 0, 0, Smoke::mf_dtor, 0, 11 },	//18 QWebDatabase::~QWebDatabase()
    {50, 123, 0, 0, Smoke::mf_ctor, 80, 1},	//19 QWebElement::QWebElement()
    {50, 123, 14, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 80, 2},	//20 QWebElement::QWebElement(const QWebElement&)
    {50, 512, 14, 1, 0, 79, 3},	//21 QWebElement::operator=(const QWebElement&)
    {50, 514, 14, 1, Smoke::mf_const, 218, 4},	//22 QWebElement::operator==(const QWebElement&) const
    {50, 490, 14, 1, Smoke::mf_const, 218, 5},	//23 QWebElement::operator!=(const QWebElement&) const
    {50, 411, 0, 0, Smoke::mf_const, 218, 6},	//24 QWebElement::isNull() const
    {50, 336, 16, 1, Smoke::mf_const, 82, 7},	//25 QWebElement::findAll(const QString&) const
    {50, 340, 16, 1, Smoke::mf_const, 78, 8},	//26 QWebElement::findFirst(const QString&) const
    {50, 708, 16, 1, 0, 0, 9},	//27 QWebElement::setPlainText(const QString&)
    {50, 783, 0, 0, Smoke::mf_const, 62, 10},	//28 QWebElement::toPlainText() const
    {50, 700, 16, 1, 0, 0, 11},	//29 QWebElement::setOuterXml(const QString&)
    {50, 782, 0, 0, Smoke::mf_const, 62, 12},	//30 QWebElement::toOuterXml() const
    {50, 674, 16, 1, 0, 0, 13},	//31 QWebElement::setInnerXml(const QString&)
    {50, 780, 0, 0, Smoke::mf_const, 62, 14},	//32 QWebElement::toInnerXml() const
    {50, 624, 18, 2, 0, 0, 15},	//33 QWebElement::setAttribute(const QString&, const QString&)
    {50, 626, 21, 3, 0, 0, 16},	//34 QWebElement::setAttributeNS(const QString&, const QString&, const QString&)
    {50, 221, 18, 2, Smoke::mf_const, 62, 17},	//35 QWebElement::attribute(const QString&, const QString&) const
    {50, 224, 21, 3, Smoke::mf_const, 62, 18},	//36 QWebElement::attributeNS(const QString&, const QString&, const QString&) const
    {50, 378, 16, 1, Smoke::mf_const, 218, 19},	//37 QWebElement::hasAttribute(const QString&) const
    {50, 380, 18, 2, Smoke::mf_const, 218, 20},	//38 QWebElement::hasAttributeNS(const QString&, const QString&) const
    {50, 562, 16, 1, 0, 0, 21},	//39 QWebElement::removeAttribute(const QString&)
    {50, 564, 18, 2, 0, 0, 22},	//40 QWebElement::removeAttributeNS(const QString&, const QString&)
    {50, 382, 0, 0, Smoke::mf_const, 218, 23},	//41 QWebElement::hasAttributes() const
    {50, 227, 16, 1, Smoke::mf_const, 65, 24},	//42 QWebElement::attributeNames(const QString&) const
    {50, 245, 0, 0, Smoke::mf_const, 65, 25},	//43 QWebElement::classes() const
    {50, 383, 16, 1, Smoke::mf_const, 218, 26},	//44 QWebElement::hasClass(const QString&) const
    {50, 198, 16, 1, 0, 0, 27},	//45 QWebElement::addClass(const QString&)
    {50, 566, 16, 1, 0, 0, 28},	//46 QWebElement::removeClass(const QString&)
    {50, 784, 16, 1, 0, 0, 29},	//47 QWebElement::toggleClass(const QString&)
    {50, 385, 0, 0, Smoke::mf_const, 218, 30},	//48 QWebElement::hasFocus() const
    {50, 660, 0, 0, 0, 0, 31},	//49 QWebElement::setFocus()
    {50, 371, 0, 0, Smoke::mf_const, 50, 32},	//50 QWebElement::geometry() const
    {50, 770, 0, 0, Smoke::mf_const, 62, 33},	//51 QWebElement::tagName() const
    {50, 541, 0, 0, Smoke::mf_const, 62, 34},	//52 QWebElement::prefix() const
    {50, 457, 0, 0, Smoke::mf_const, 62, 35},	//53 QWebElement::localName() const
    {50, 483, 0, 0, Smoke::mf_const, 62, 36},	//54 QWebElement::namespaceUri() const
    {50, 533, 0, 0, Smoke::mf_const, 78, 37},	//55 QWebElement::parent() const
    {50, 348, 0, 0, Smoke::mf_const, 78, 38},	//56 QWebElement::firstChild() const
    {50, 435, 0, 0, Smoke::mf_const, 78, 39},	//57 QWebElement::lastChild() const
    {50, 485, 0, 0, Smoke::mf_const, 78, 40},	//58 QWebElement::nextSibling() const
    {50, 548, 0, 0, Smoke::mf_const, 78, 41},	//59 QWebElement::previousSibling() const
    {50, 290, 0, 0, Smoke::mf_const, 78, 42},	//60 QWebElement::document() const
    {50, 820, 0, 0, Smoke::mf_const, 91, 43},	//61 QWebElement::webFrame() const
    {50, 211, 16, 1, 0, 0, 44},	//62 QWebElement::appendInside(const QString&)
    {50, 211, 14, 1, 0, 0, 45},	//63 QWebElement::appendInside(const QWebElement&)
    {50, 542, 16, 1, 0, 0, 46},	//64 QWebElement::prependInside(const QString&)
    {50, 542, 14, 1, 0, 0, 47},	//65 QWebElement::prependInside(const QWebElement&)
    {50, 214, 16, 1, 0, 0, 48},	//66 QWebElement::appendOutside(const QString&)
    {50, 214, 14, 1, 0, 0, 49},	//67 QWebElement::appendOutside(const QWebElement&)
    {50, 545, 16, 1, 0, 0, 50},	//68 QWebElement::prependOutside(const QString&)
    {50, 545, 14, 1, 0, 0, 51},	//69 QWebElement::prependOutside(const QWebElement&)
    {50, 307, 14, 1, 0, 0, 52},	//70 QWebElement::encloseContentsWith(const QWebElement&)
    {50, 307, 16, 1, 0, 0, 53},	//71 QWebElement::encloseContentsWith(const QString&)
    {50, 310, 16, 1, 0, 0, 54},	//72 QWebElement::encloseWith(const QString&)
    {50, 310, 14, 1, 0, 0, 55},	//73 QWebElement::encloseWith(const QWebElement&)
    {50, 582, 16, 1, 0, 0, 56},	//74 QWebElement::replace(const QString&)
    {50, 582, 14, 1, 0, 0, 57},	//75 QWebElement::replace(const QWebElement&)
    {50, 249, 0, 0, Smoke::mf_const, 78, 58},	//76 QWebElement::clone() const
    {50, 771, 0, 0, 0, 79, 59},	//77 QWebElement::takeFromDocument()
    {50, 570, 0, 0, 0, 0, 60},	//78 QWebElement::removeFromDocument()
    {50, 560, 0, 0, 0, 0, 61},	//79 QWebElement::removeAllChildren()
    {50, 319, 16, 1, 0, 74, 62},	//80 QWebElement::evaluateJavaScript(const QString&)
    {50, 759, 25, 2, Smoke::mf_const, 62, 63},	//81 QWebElement::styleProperty(const QString&, QWebElement::StyleResolveStrategy) const
    {50, 725, 18, 2, 0, 0, 64},	//82 QWebElement::setStyleProperty(const QString&, const QString&)
    {50, 573, 28, 1, 0, 0, 65},	//83 QWebElement::render(QPainter*)
    {50, 573, 30, 2, 0, 0, 66},	//84 QWebElement::render(QPainter*, const QRect&)
    {50, 221, 16, 1, Smoke::mf_const, 62, 67},	//85 QWebElement::attribute(const QString&) const
    {50, 224, 18, 2, Smoke::mf_const, 62, 68},	//86 QWebElement::attributeNS(const QString&, const QString&) const
    {50, 227, 0, 0, Smoke::mf_const, 65, 69},	//87 QWebElement::attributeNames() const
    {50, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 81, 70},	//88 QWebElement::InlineStyle (enum)
    {50, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 81, 71},	//89 QWebElement::CascadedStyle (enum)
    {50, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 81, 72},	//90 QWebElement::ComputedStyle (enum)
    {50, 838, 0, 0, Smoke::mf_dtor, 0, 73 },	//91 QWebElement::~QWebElement()
    {51, 125, 0, 0, Smoke::mf_ctor, 84, 1},	//92 QWebElementCollection::QWebElementCollection()
    {51, 125, 33, 2, Smoke::mf_ctor, 84, 2},	//93 QWebElementCollection::QWebElementCollection(const QWebElement&, const QString&)
    {51, 125, 36, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 84, 3},	//94 QWebElementCollection::QWebElementCollection(const QWebElementCollection&)
    {51, 512, 36, 1, 0, 83, 4},	//95 QWebElementCollection::operator=(const QWebElementCollection&)
    {51, 493, 36, 1, Smoke::mf_const, 82, 5},	//96 QWebElementCollection::operator+(const QWebElementCollection&) const
    {51, 498, 36, 1, 0, 83, 6},	//97 QWebElementCollection::operator+=(const QWebElementCollection&)
    {51, 209, 36, 1, 0, 0, 7},	//98 QWebElementCollection::append(const QWebElementCollection&)
    {51, 266, 0, 0, Smoke::mf_const, 263, 8},	//99 QWebElementCollection::count() const
    {51, 219, 38, 1, Smoke::mf_const, 78, 9},	//100 QWebElementCollection::at(int) const
    {51, 520, 38, 1, Smoke::mf_const, 78, 10},	//101 QWebElementCollection::operator[](int) const
    {51, 347, 0, 0, Smoke::mf_const, 78, 11},	//102 QWebElementCollection::first() const
    {51, 434, 0, 0, Smoke::mf_const, 78, 12},	//103 QWebElementCollection::last() const
    {51, 781, 0, 0, Smoke::mf_const, 25, 13},	//104 QWebElementCollection::toList() const
    {51, 234, 0, 0, Smoke::mf_const, 85, 14},	//105 QWebElementCollection::begin() const
    {51, 315, 0, 0, Smoke::mf_const, 85, 15},	//106 QWebElementCollection::end() const
    {51, 253, 0, 0, Smoke::mf_const, 85, 16},	//107 QWebElementCollection::constBegin() const
    {51, 254, 0, 0, Smoke::mf_const, 85, 17},	//108 QWebElementCollection::constEnd() const
    {51, 234, 0, 0, 0, 88, 18},	//109 QWebElementCollection::begin()
    {51, 315, 0, 0, 0, 88, 19},	//110 QWebElementCollection::end()
    {51, 839, 0, 0, Smoke::mf_dtor, 0, 20 },	//111 QWebElementCollection::~QWebElementCollection()
    {52, 255, 40, 2, Smoke::mf_ctor, 87, 1},	//112 QWebElementCollection::const_iterator::const_iterator(const QWebElementCollection*, int)
    {52, 255, 43, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 87, 2},	//113 QWebElementCollection::const_iterator::const_iterator(const QWebElementCollection::const_iterator&)
    {52, 492, 0, 0, Smoke::mf_const, 238, 3},	//114 QWebElementCollection::const_iterator::operator*() const
    {52, 514, 43, 1, Smoke::mf_const, 218, 4},	//115 QWebElementCollection::const_iterator::operator==(const QWebElementCollection::const_iterator&) const
    {52, 490, 43, 1, Smoke::mf_const, 218, 5},	//116 QWebElementCollection::const_iterator::operator!=(const QWebElementCollection::const_iterator&) const
    {52, 508, 43, 1, Smoke::mf_const, 218, 6},	//117 QWebElementCollection::const_iterator::operator<(const QWebElementCollection::const_iterator&) const
    {52, 510, 43, 1, Smoke::mf_const, 218, 7},	//118 QWebElementCollection::const_iterator::operator<=(const QWebElementCollection::const_iterator&) const
    {52, 516, 43, 1, Smoke::mf_const, 218, 8},	//119 QWebElementCollection::const_iterator::operator>(const QWebElementCollection::const_iterator&) const
    {52, 518, 43, 1, Smoke::mf_const, 218, 9},	//120 QWebElementCollection::const_iterator::operator>=(const QWebElementCollection::const_iterator&) const
    {52, 496, 0, 0, 0, 86, 10},	//121 QWebElementCollection::const_iterator::operator++()
    {52, 496, 38, 1, 0, 85, 11},	//122 QWebElementCollection::const_iterator::operator++(int)
    {52, 504, 0, 0, 0, 86, 12},	//123 QWebElementCollection::const_iterator::operator--()
    {52, 504, 38, 1, 0, 85, 13},	//124 QWebElementCollection::const_iterator::operator--(int)
    {52, 498, 38, 1, 0, 86, 14},	//125 QWebElementCollection::const_iterator::operator+=(int)
    {52, 506, 38, 1, 0, 86, 15},	//126 QWebElementCollection::const_iterator::operator-=(int)
    {52, 493, 38, 1, Smoke::mf_const, 85, 16},	//127 QWebElementCollection::const_iterator::operator+(int) const
    {52, 501, 38, 1, Smoke::mf_const, 85, 17},	//128 QWebElementCollection::const_iterator::operator-(int) const
    {52, 501, 45, 1, Smoke::mf_const, 263, 18},	//129 QWebElementCollection::const_iterator::operator-(QWebElementCollection::const_iterator) const
    {52, 849, 0, 0, Smoke::mf_dtor, 0, 19 },	//130 QWebElementCollection::const_iterator::~const_iterator()
    {53, 417, 40, 2, Smoke::mf_ctor, 90, 1},	//131 QWebElementCollection::iterator::iterator(const QWebElementCollection*, int)
    {53, 417, 47, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 90, 2},	//132 QWebElementCollection::iterator::iterator(const QWebElementCollection::iterator&)
    {53, 492, 0, 0, Smoke::mf_const, 78, 3},	//133 QWebElementCollection::iterator::operator*() const
    {53, 514, 47, 1, Smoke::mf_const, 218, 4},	//134 QWebElementCollection::iterator::operator==(const QWebElementCollection::iterator&) const
    {53, 490, 47, 1, Smoke::mf_const, 218, 5},	//135 QWebElementCollection::iterator::operator!=(const QWebElementCollection::iterator&) const
    {53, 508, 47, 1, Smoke::mf_const, 218, 6},	//136 QWebElementCollection::iterator::operator<(const QWebElementCollection::iterator&) const
    {53, 510, 47, 1, Smoke::mf_const, 218, 7},	//137 QWebElementCollection::iterator::operator<=(const QWebElementCollection::iterator&) const
    {53, 516, 47, 1, Smoke::mf_const, 218, 8},	//138 QWebElementCollection::iterator::operator>(const QWebElementCollection::iterator&) const
    {53, 518, 47, 1, Smoke::mf_const, 218, 9},	//139 QWebElementCollection::iterator::operator>=(const QWebElementCollection::iterator&) const
    {53, 496, 0, 0, 0, 89, 10},	//140 QWebElementCollection::iterator::operator++()
    {53, 496, 38, 1, 0, 88, 11},	//141 QWebElementCollection::iterator::operator++(int)
    {53, 504, 0, 0, 0, 89, 12},	//142 QWebElementCollection::iterator::operator--()
    {53, 504, 38, 1, 0, 88, 13},	//143 QWebElementCollection::iterator::operator--(int)
    {53, 498, 38, 1, 0, 89, 14},	//144 QWebElementCollection::iterator::operator+=(int)
    {53, 506, 38, 1, 0, 89, 15},	//145 QWebElementCollection::iterator::operator-=(int)
    {53, 493, 38, 1, Smoke::mf_const, 88, 16},	//146 QWebElementCollection::iterator::operator+(int) const
    {53, 501, 38, 1, Smoke::mf_const, 88, 17},	//147 QWebElementCollection::iterator::operator-(int) const
    {53, 501, 49, 1, Smoke::mf_const, 263, 18},	//148 QWebElementCollection::iterator::operator-(QWebElementCollection::iterator) const
    {53, 850, 0, 0, Smoke::mf_dtor, 0, 19 },	//149 QWebElementCollection::iterator::~iterator()
    {54, 467, 0, 0, Smoke::mf_const, 223, 1},	//150 QWebFrame::metaObject() const
    {54, 556, 10, 1, 0, 271, 2},	//151 QWebFrame::qt_metacast(const char*)
    {54, 789, 51, 2, Smoke::mf_static, 62, 3},	//152 QWebFrame::tr(const char*, const char*)
    {54, 793, 51, 2, Smoke::mf_static, 62, 4},	//153 QWebFrame::trUtf8(const char*, const char*)
    {54, 789, 54, 3, Smoke::mf_static, 62, 5},	//154 QWebFrame::tr(const char*, const char*, int)
    {54, 793, 54, 3, Smoke::mf_static, 62, 6},	//155 QWebFrame::trUtf8(const char*, const char*, int)
    {54, 554, 58, 3, 0, 263, 7},	//156 QWebFrame::qt_metacall(QMetaObject::Call, int, void**)
    {54, 524, 0, 0, Smoke::mf_const, 102, 8},	//157 QWebFrame::page() const
    {54, 448, 62, 1, 0, 0, 9},	//158 QWebFrame::load(const QUrl&)
    {54, 448, 64, 3, 0, 0, 10},	//159 QWebFrame::load(const QNetworkRequest&, QNetworkAccessManager::Operation, const QByteArray&)
    {54, 669, 68, 2, 0, 0, 11},	//160 QWebFrame::setHtml(const QString&, const QUrl&)
    {54, 630, 71, 3, 0, 0, 12},	//161 QWebFrame::setContent(const QByteArray&, const QString&, const QUrl&)
    {54, 204, 75, 2, 0, 0, 13},	//162 QWebFrame::addToJavaScriptWindowObject(const QString&, QObject*)
    {54, 204, 78, 3, 0, 0, 14},	//163 QWebFrame::addToJavaScriptWindowObject(const QString&, QObject*, QScriptEngine::ValueOwnership)
    {54, 779, 0, 0, Smoke::mf_const, 62, 15},	//164 QWebFrame::toHtml() const
    {54, 783, 0, 0, Smoke::mf_const, 62, 16},	//165 QWebFrame::toPlainText() const
    {54, 579, 0, 0, Smoke::mf_const, 62, 17},	//166 QWebFrame::renderTreeDump() const
    {54, 776, 0, 0, Smoke::mf_const|Smoke::mf_property, 62, 18},	//167 QWebFrame::title() const
    {54, 731, 62, 1, Smoke::mf_property, 0, 19},	//168 QWebFrame::setUrl(const QUrl&)
    {54, 808, 0, 0, Smoke::mf_const|Smoke::mf_property, 72, 20},	//169 QWebFrame::url() const
    {54, 585, 0, 0, Smoke::mf_const|Smoke::mf_property, 72, 21},	//170 QWebFrame::requestedUrl() const
    {54, 233, 0, 0, Smoke::mf_const|Smoke::mf_property, 72, 22},	//171 QWebFrame::baseUrl() const
    {54, 396, 0, 0, Smoke::mf_const|Smoke::mf_property, 20, 23},	//172 QWebFrame::icon() const
    {54, 466, 0, 0, Smoke::mf_const, 35, 24},	//173 QWebFrame::metaData() const
    {54, 370, 0, 0, Smoke::mf_const, 62, 25},	//174 QWebFrame::frameName() const
    {54, 534, 0, 0, Smoke::mf_const, 91, 26},	//175 QWebFrame::parentFrame() const
    {54, 242, 0, 0, Smoke::mf_const, 26, 27},	//176 QWebFrame::childFrames() const
    {54, 607, 82, 1, Smoke::mf_const, 192, 28},	//177 QWebFrame::scrollBarPolicy(Qt::Orientation) const
    {54, 719, 84, 2, 0, 0, 29},	//178 QWebFrame::setScrollBarPolicy(Qt::Orientation, Qt::ScrollBarPolicy)
    {54, 721, 87, 2, 0, 0, 30},	//179 QWebFrame::setScrollBarValue(Qt::Orientation, int)
    {54, 609, 82, 1, Smoke::mf_const, 263, 31},	//180 QWebFrame::scrollBarValue(Qt::Orientation) const
    {54, 605, 82, 1, Smoke::mf_const, 263, 32},	//181 QWebFrame::scrollBarMinimum(Qt::Orientation) const
    {54, 603, 82, 1, Smoke::mf_const, 263, 33},	//182 QWebFrame::scrollBarMaximum(Qt::Orientation) const
    {54, 601, 82, 1, Smoke::mf_const, 50, 34},	//183 QWebFrame::scrollBarGeometry(Qt::Orientation) const
    {54, 599, 90, 2, 0, 0, 35},	//184 QWebFrame::scroll(int, int)
    {54, 611, 0, 0, Smoke::mf_const|Smoke::mf_property, 48, 36},	//185 QWebFrame::scrollPosition() const
    {54, 723, 93, 1, Smoke::mf_property, 0, 37},	//186 QWebFrame::setScrollPosition(const QPoint&)
    {54, 614, 16, 1, 0, 0, 38},	//187 QWebFrame::scrollToAnchor(const QString&)
    {54, 573, 28, 1, 0, 0, 39},	//188 QWebFrame::render(QPainter*)
    {54, 573, 95, 2, 0, 0, 40},	//189 QWebFrame::render(QPainter*, const QRegion&)
    {54, 573, 98, 3, 0, 0, 41},	//190 QWebFrame::render(QPainter*, QWebFrame::RenderLayer, const QRegion&)
    {54, 729, 102, 1, 0, 0, 42},	//191 QWebFrame::setTextSizeMultiplier(double)
    {54, 774, 0, 0, Smoke::mf_const, 262, 43},	//192 QWebFrame::textSizeMultiplier() const
    {54, 828, 0, 0, Smoke::mf_const, 262, 44},	//193 QWebFrame::zoomFactor() const
    {54, 744, 102, 1, 0, 0, 45},	//194 QWebFrame::setZoomFactor(double)
    {54, 385, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 46},	//195 QWebFrame::hasFocus() const
    {54, 660, 0, 0, 0, 0, 47},	//196 QWebFrame::setFocus()
    {54, 539, 0, 0, Smoke::mf_const, 48, 48},	//197 QWebFrame::pos() const
    {54, 371, 0, 0, Smoke::mf_const, 50, 49},	//198 QWebFrame::geometry() const
    {54, 261, 0, 0, Smoke::mf_const|Smoke::mf_property, 55, 50},	//199 QWebFrame::contentsSize() const
    {54, 291, 0, 0, Smoke::mf_const, 78, 51},	//200 QWebFrame::documentElement() const
    {54, 338, 16, 1, Smoke::mf_const, 82, 52},	//201 QWebFrame::findAllElements(const QString&) const
    {54, 342, 16, 1, Smoke::mf_const, 78, 53},	//202 QWebFrame::findFirstElement(const QString&) const
    {54, 393, 93, 1, Smoke::mf_const, 98, 54},	//203 QWebFrame::hitTestContent(const QPoint&) const
    {54, 321, 1, 1, 0, 218, 55},	//204 QWebFrame::event(QEvent*)
    {54, 616, 0, 0, Smoke::mf_const, 130, 56},	//205 QWebFrame::securityOrigin() const
    {54, 319, 16, 1, Smoke::mf_slot, 74, 57},	//206 QWebFrame::evaluateJavaScript(const QString&)
    {54, 549, 104, 1, Smoke::mf_const|Smoke::mf_slot, 0, 58},	//207 QWebFrame::print(QPrinter*) const
    {54, 428, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 59},	//208 QWebFrame::javaScriptWindowObjectCleared()
    {54, 553, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 60},	//209 QWebFrame::provisionalLoad()
    {54, 777, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 61},	//210 QWebFrame::titleChanged(const QString&)
    {54, 809, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 62},	//211 QWebFrame::urlChanged(const QUrl&)
    {54, 402, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 63},	//212 QWebFrame::initialLayoutCompleted()
    {54, 397, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 64},	//213 QWebFrame::iconChanged()
    {54, 262, 106, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 65},	//214 QWebFrame::contentsSizeChanged(const QSize&)
    {54, 456, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 66},	//215 QWebFrame::loadStarted()
    {54, 452, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 67},	//216 QWebFrame::loadFinished(bool)
    {54, 527, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 68},	//217 QWebFrame::pageChanged()
    {54, 789, 10, 1, Smoke::mf_static, 62, 69},	//218 QWebFrame::tr(const char*)
    {54, 793, 10, 1, Smoke::mf_static, 62, 70},	//219 QWebFrame::trUtf8(const char*)
    {54, 448, 110, 1, 0, 0, 71},	//220 QWebFrame::load(const QNetworkRequest&)
    {54, 448, 112, 2, 0, 0, 72},	//221 QWebFrame::load(const QNetworkRequest&, QNetworkAccessManager::Operation)
    {54, 669, 16, 1, 0, 0, 73},	//222 QWebFrame::setHtml(const QString&)
    {54, 630, 115, 1, 0, 0, 74},	//223 QWebFrame::setContent(const QByteArray&)
    {54, 630, 117, 2, 0, 0, 75},	//224 QWebFrame::setContent(const QByteArray&, const QString&)
    {54, 573, 120, 2, 0, 0, 76},	//225 QWebFrame::render(QPainter*, QWebFrame::RenderLayer)
    {54, 752, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 222, 77},	//226 QWebFrame::staticMetaObject() const
    {54, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 78},	//227 QWebFrame::ContentsLayer (enum)
    {54, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 79},	//228 QWebFrame::ScrollBarLayer (enum)
    {54, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 80},	//229 QWebFrame::PanIconLayer (enum)
    {54, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 81},	//230 QWebFrame::AllLayers (enum)
    {55, 246, 0, 0, 0, 0, 1},	//231 QWebHistory::clear()
    {55, 416, 0, 0, Smoke::mf_const, 27, 2},	//232 QWebHistory::items() const
    {55, 231, 38, 1, Smoke::mf_const, 27, 3},	//233 QWebHistory::backItems(int) const
    {55, 362, 38, 1, Smoke::mf_const, 27, 4},	//234 QWebHistory::forwardItems(int) const
    {55, 237, 0, 0, Smoke::mf_const, 218, 5},	//235 QWebHistory::canGoBack() const
    {55, 238, 0, 0, Smoke::mf_const, 218, 6},	//236 QWebHistory::canGoForward() const
    {55, 229, 0, 0, 0, 0, 7},	//237 QWebHistory::back()
    {55, 360, 0, 0, 0, 0, 8},	//238 QWebHistory::forward()
    {55, 375, 123, 1, 0, 0, 9},	//239 QWebHistory::goToItem(const QWebHistoryItem&)
    {55, 230, 0, 0, Smoke::mf_const, 95, 10},	//240 QWebHistory::backItem() const
    {55, 275, 0, 0, Smoke::mf_const, 95, 11},	//241 QWebHistory::currentItem() const
    {55, 361, 0, 0, Smoke::mf_const, 95, 12},	//242 QWebHistory::forwardItem() const
    {55, 414, 38, 1, Smoke::mf_const, 95, 13},	//243 QWebHistory::itemAt(int) const
    {55, 276, 0, 0, Smoke::mf_const, 263, 14},	//244 QWebHistory::currentItemIndex() const
    {55, 266, 0, 0, Smoke::mf_const, 263, 15},	//245 QWebHistory::count() const
    {55, 461, 0, 0, Smoke::mf_const, 263, 16},	//246 QWebHistory::maximumItemCount() const
    {55, 680, 38, 1, 0, 0, 17},	//247 QWebHistory::setMaximumItemCount(int)
    {56, 467, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 223, 1},	//248 QWebHistoryInterface::metaObject() const
    {56, 556, 10, 1, Smoke::mf_virtual, 271, 2},	//249 QWebHistoryInterface::qt_metacast(const char*)
    {56, 789, 51, 2, Smoke::mf_static, 62, 3},	//250 QWebHistoryInterface::tr(const char*, const char*)
    {56, 793, 51, 2, Smoke::mf_static, 62, 4},	//251 QWebHistoryInterface::trUtf8(const char*, const char*)
    {56, 789, 54, 3, Smoke::mf_static, 62, 5},	//252 QWebHistoryInterface::tr(const char*, const char*, int)
    {56, 793, 54, 3, Smoke::mf_static, 62, 6},	//253 QWebHistoryInterface::trUtf8(const char*, const char*, int)
    {56, 554, 58, 3, Smoke::mf_virtual, 263, 7},	//254 QWebHistoryInterface::qt_metacall(QMetaObject::Call, int, void**)
    {56, 128, 125, 1, Smoke::mf_ctor, 94, 8},	//255 QWebHistoryInterface::QWebHistoryInterface(QObject*)
    {56, 640, 127, 1, Smoke::mf_static, 0, 9},	//256 QWebHistoryInterface::setDefaultInterface(QWebHistoryInterface*)
    {56, 283, 0, 0, Smoke::mf_static, 94, 10},	//257 QWebHistoryInterface::defaultInterface()
    {56, 391, 16, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 218, 11},	//258 QWebHistoryInterface::historyContains(const QString&) const [pure virtual]
    {56, 200, 16, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 12},	//259 QWebHistoryInterface::addHistoryEntry(const QString&) [pure virtual]
    {56, 789, 10, 1, Smoke::mf_static, 62, 13},	//260 QWebHistoryInterface::tr(const char*)
    {56, 793, 10, 1, Smoke::mf_static, 62, 14},	//261 QWebHistoryInterface::trUtf8(const char*)
    {56, 128, 0, 0, Smoke::mf_ctor, 94, 15},	//262 QWebHistoryInterface::QWebHistoryInterface()
    {56, 752, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 222, 16},	//263 QWebHistoryInterface::staticMetaObject() const
    {56, 840, 0, 0, Smoke::mf_dtor, 0, 17 },	//264 QWebHistoryInterface::~QWebHistoryInterface()
    {57, 130, 123, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 97, 1},	//265 QWebHistoryItem::QWebHistoryItem(const QWebHistoryItem&)
    {57, 512, 123, 1, 0, 96, 2},	//266 QWebHistoryItem::operator=(const QWebHistoryItem&)
    {57, 523, 0, 0, Smoke::mf_const, 72, 3},	//267 QWebHistoryItem::originalUrl() const
    {57, 808, 0, 0, Smoke::mf_const, 72, 4},	//268 QWebHistoryItem::url() const
    {57, 776, 0, 0, Smoke::mf_const, 62, 5},	//269 QWebHistoryItem::title() const
    {57, 436, 0, 0, Smoke::mf_const, 8, 6},	//270 QWebHistoryItem::lastVisited() const
    {57, 396, 0, 0, Smoke::mf_const, 20, 7},	//271 QWebHistoryItem::icon() const
    {57, 813, 0, 0, Smoke::mf_const, 74, 8},	//272 QWebHistoryItem::userData() const
    {57, 733, 129, 1, 0, 0, 9},	//273 QWebHistoryItem::setUserData(const QVariant&)
    {57, 413, 0, 0, Smoke::mf_const, 218, 10},	//274 QWebHistoryItem::isValid() const
    {57, 841, 0, 0, Smoke::mf_dtor, 0, 11 },	//275 QWebHistoryItem::~QWebHistoryItem()
    {58, 132, 0, 0, Smoke::mf_ctor, 100, 1},	//276 QWebHitTestResult::QWebHitTestResult()
    {58, 132, 131, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 100, 2},	//277 QWebHitTestResult::QWebHitTestResult(const QWebHitTestResult&)
    {58, 512, 131, 1, 0, 99, 3},	//278 QWebHitTestResult::operator=(const QWebHitTestResult&)
    {58, 411, 0, 0, Smoke::mf_const, 218, 4},	//279 QWebHitTestResult::isNull() const
    {58, 539, 0, 0, Smoke::mf_const, 48, 5},	//280 QWebHitTestResult::pos() const
    {58, 235, 0, 0, Smoke::mf_const, 50, 6},	//281 QWebHitTestResult::boundingRect() const
    {58, 313, 0, 0, Smoke::mf_const, 78, 7},	//282 QWebHitTestResult::enclosingBlockElement() const
    {58, 776, 0, 0, Smoke::mf_const, 62, 8},	//283 QWebHitTestResult::title() const
    {58, 445, 0, 0, Smoke::mf_const, 62, 9},	//284 QWebHitTestResult::linkText() const
    {58, 447, 0, 0, Smoke::mf_const, 72, 10},	//285 QWebHitTestResult::linkUrl() const
    {58, 446, 0, 0, Smoke::mf_const, 72, 11},	//286 QWebHitTestResult::linkTitle() const
    {58, 444, 0, 0, Smoke::mf_const, 91, 12},	//287 QWebHitTestResult::linkTargetFrame() const
    {58, 441, 0, 0, Smoke::mf_const, 78, 13},	//288 QWebHitTestResult::linkElement() const
    {58, 208, 0, 0, Smoke::mf_const, 62, 14},	//289 QWebHitTestResult::alternateText() const
    {58, 401, 0, 0, Smoke::mf_const, 72, 15},	//290 QWebHitTestResult::imageUrl() const
    {58, 535, 0, 0, Smoke::mf_const, 47, 16},	//291 QWebHitTestResult::pixmap() const
    {58, 408, 0, 0, Smoke::mf_const, 218, 17},	//292 QWebHitTestResult::isContentEditable() const
    {58, 409, 0, 0, Smoke::mf_const, 218, 18},	//293 QWebHitTestResult::isContentSelected() const
    {58, 303, 0, 0, Smoke::mf_const, 78, 19},	//294 QWebHitTestResult::element() const
    {58, 365, 0, 0, Smoke::mf_const, 91, 20},	//295 QWebHitTestResult::frame() const
    {58, 842, 0, 0, Smoke::mf_dtor, 0, 21 },	//296 QWebHitTestResult::~QWebHitTestResult()
    {59, 467, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 223, 1},	//297 QWebInspector::metaObject() const
    {59, 556, 10, 1, Smoke::mf_virtual, 271, 2},	//298 QWebInspector::qt_metacast(const char*)
    {59, 789, 51, 2, Smoke::mf_static, 62, 3},	//299 QWebInspector::tr(const char*, const char*)
    {59, 793, 51, 2, Smoke::mf_static, 62, 4},	//300 QWebInspector::trUtf8(const char*, const char*)
    {59, 789, 54, 3, Smoke::mf_static, 62, 5},	//301 QWebInspector::tr(const char*, const char*, int)
    {59, 793, 54, 3, Smoke::mf_static, 62, 6},	//302 QWebInspector::trUtf8(const char*, const char*, int)
    {59, 554, 58, 3, Smoke::mf_virtual, 263, 7},	//303 QWebInspector::qt_metacall(QMetaObject::Call, int, void**)
    {59, 134, 133, 1, Smoke::mf_ctor, 101, 8},	//304 QWebInspector::QWebInspector(QWidget*)
    {59, 702, 135, 1, 0, 0, 9},	//305 QWebInspector::setPage(QWebPage*)
    {59, 524, 0, 0, Smoke::mf_const, 102, 10},	//306 QWebInspector::page() const
    {59, 751, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 55, 11},	//307 QWebInspector::sizeHint() const
    {59, 321, 1, 1, Smoke::mf_virtual, 218, 12},	//308 QWebInspector::event(QEvent*)
    {59, 592, 137, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 13},	//309 QWebInspector::resizeEvent(QResizeEvent*)
    {59, 748, 139, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//310 QWebInspector::showEvent(QShowEvent*)
    {59, 388, 141, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//311 QWebInspector::hideEvent(QHideEvent*)
    {59, 250, 143, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//312 QWebInspector::closeEvent(QCloseEvent*)
    {59, 789, 10, 1, Smoke::mf_static, 62, 17},	//313 QWebInspector::tr(const char*)
    {59, 793, 10, 1, Smoke::mf_static, 62, 18},	//314 QWebInspector::trUtf8(const char*)
    {59, 134, 0, 0, Smoke::mf_ctor, 101, 19},	//315 QWebInspector::QWebInspector()
    {59, 752, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 222, 20},	//316 QWebInspector::staticMetaObject() const
    {59, 843, 0, 0, Smoke::mf_dtor, 0, 21 },	//317 QWebInspector::~QWebInspector()
    {60, 467, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 223, 1},	//318 QWebPage::metaObject() const
    {60, 556, 10, 1, Smoke::mf_virtual, 271, 2},	//319 QWebPage::qt_metacast(const char*)
    {60, 789, 51, 2, Smoke::mf_static, 62, 3},	//320 QWebPage::tr(const char*, const char*)
    {60, 793, 51, 2, Smoke::mf_static, 62, 4},	//321 QWebPage::trUtf8(const char*, const char*)
    {60, 789, 54, 3, Smoke::mf_static, 62, 5},	//322 QWebPage::tr(const char*, const char*, int)
    {60, 793, 54, 3, Smoke::mf_static, 62, 6},	//323 QWebPage::trUtf8(const char*, const char*, int)
    {60, 554, 58, 3, Smoke::mf_virtual, 263, 7},	//324 QWebPage::qt_metacall(QMetaObject::Call, int, void**)
    {60, 136, 125, 1, Smoke::mf_ctor, 102, 8},	//325 QWebPage::QWebPage(QObject*)
    {60, 460, 0, 0, Smoke::mf_const, 91, 9},	//326 QWebPage::mainFrame() const
    {60, 274, 0, 0, Smoke::mf_const, 91, 10},	//327 QWebPage::currentFrame() const
    {60, 366, 93, 1, Smoke::mf_const, 91, 11},	//328 QWebPage::frameAt(const QPoint&) const
    {60, 390, 0, 0, Smoke::mf_const, 93, 12},	//329 QWebPage::history() const
    {60, 746, 0, 0, Smoke::mf_const, 133, 13},	//330 QWebPage::settings() const
    {60, 737, 133, 1, 0, 0, 14},	//331 QWebPage::setView(QWidget*)
    {60, 815, 0, 0, Smoke::mf_const, 141, 15},	//332 QWebPage::view() const
    {60, 410, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 16},	//333 QWebPage::isModified() const
    {60, 803, 0, 0, Smoke::mf_const, 71, 17},	//334 QWebPage::undoStack() const
    {60, 688, 145, 1, 0, 0, 18},	//335 QWebPage::setNetworkAccessManager(QNetworkAccessManager*)
    {60, 484, 0, 0, Smoke::mf_const, 36, 19},	//336 QWebPage::networkAccessManager() const
    {60, 710, 147, 1, 0, 0, 20},	//337 QWebPage::setPluginFactory(QWebPluginFactory*)
    {60, 536, 0, 0, Smoke::mf_const, 122, 21},	//338 QWebPage::pluginFactory() const
    {60, 788, 0, 0, Smoke::mf_const, 270, 22},	//339 QWebPage::totalBytes() const
    {60, 236, 0, 0, Smoke::mf_const, 270, 23},	//340 QWebPage::bytesReceived() const
    {60, 386, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 24},	//341 QWebPage::hasSelection() const
    {60, 618, 0, 0, Smoke::mf_const|Smoke::mf_property, 62, 25},	//342 QWebPage::selectedText() const
    {60, 617, 0, 0, Smoke::mf_const|Smoke::mf_property, 62, 26},	//343 QWebPage::selectedHtml() const
    {60, 195, 149, 1, Smoke::mf_const, 1, 27},	//344 QWebPage::action(QWebPage::WebAction) const
    {60, 797, 151, 2, Smoke::mf_virtual, 0, 28},	//345 QWebPage::triggerAction(QWebPage::WebAction, bool)
    {60, 819, 0, 0, Smoke::mf_const|Smoke::mf_property, 55, 29},	//346 QWebPage::viewportSize() const
    {60, 739, 106, 1, Smoke::mf_const|Smoke::mf_property, 0, 30},	//347 QWebPage::setViewportSize(const QSize&) const
    {60, 816, 106, 1, Smoke::mf_const, 116, 31},	//348 QWebPage::viewportAttributesForSize(const QSize&) const
    {60, 540, 0, 0, Smoke::mf_const|Smoke::mf_property, 55, 32},	//349 QWebPage::preferredContentsSize() const
    {60, 712, 106, 1, Smoke::mf_const|Smoke::mf_property, 0, 33},	//350 QWebPage::setPreferredContentsSize(const QSize&) const
    {60, 620, 154, 1, Smoke::mf_const, 0, 34},	//351 QWebPage::setActualVisibleContentRect(const QRect&) const
    {60, 321, 1, 1, Smoke::mf_virtual, 218, 35},	//352 QWebPage::event(QEvent*)
    {60, 351, 108, 1, 0, 218, 36},	//353 QWebPage::focusNextPrevChild(bool)
    {60, 406, 156, 1, Smoke::mf_const, 74, 37},	//354 QWebPage::inputMethodQuery(Qt::InputMethodQuery) const
    {60, 344, 158, 2, 0, 218, 38},	//355 QWebPage::findText(const QString&, QFlags<QWebPage::FindFlag>)
    {60, 665, 108, 1, Smoke::mf_property, 0, 39},	//356 QWebPage::setForwardUnsupportedContent(bool)
    {60, 364, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 40},	//357 QWebPage::forwardUnsupportedContent() const
    {60, 676, 161, 1, Smoke::mf_property, 0, 41},	//358 QWebPage::setLinkDelegationPolicy(QWebPage::LinkDelegationPolicy)
    {60, 440, 0, 0, Smoke::mf_const|Smoke::mf_property, 113, 42},	//359 QWebPage::linkDelegationPolicy() const
    {60, 704, 163, 1, Smoke::mf_property, 0, 43},	//360 QWebPage::setPalette(const QPalette&)
    {60, 531, 0, 0, Smoke::mf_const|Smoke::mf_property, 46, 44},	//361 QWebPage::palette() const
    {60, 634, 108, 1, Smoke::mf_property, 0, 45},	//362 QWebPage::setContentEditable(bool)
    {60, 408, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 46},	//363 QWebPage::isContentEditable() const
    {60, 767, 165, 1, 0, 218, 47},	//364 QWebPage::swallowContextMenuEvent(QContextMenuEvent*)
    {60, 806, 93, 1, 0, 0, 48},	//365 QWebPage::updatePositionDependentActions(const QPoint&)
    {60, 271, 0, 0, 0, 31, 49},	//366 QWebPage::createStandardContextMenu()
    {60, 654, 167, 3, 0, 0, 50},	//367 QWebPage::setFeaturePermission(QWebFrame*, QWebPage::Feature, QWebPage::PermissionPolicy)
    {60, 762, 0, 0, Smoke::mf_const, 65, 51},	//368 QWebPage::supportedContentTypes() const
    {60, 763, 16, 1, Smoke::mf_const, 218, 52},	//369 QWebPage::supportsContentType(const QString&) const
    {60, 325, 171, 3, Smoke::mf_virtual, 218, 53},	//370 QWebPage::extension(QWebPage::Extension, const QWebPage::ExtensionOption*, QWebPage::ExtensionReturn*)
    {60, 765, 175, 1, Smoke::mf_const|Smoke::mf_virtual, 218, 54},	//371 QWebPage::supportsExtension(QWebPage::Extension) const
    {60, 377, 0, 0, Smoke::mf_const, 121, 55},	//372 QWebPage::handle() const
    {60, 747, 0, 0, Smoke::mf_slot, 218, 56},	//373 QWebPage::shouldInterruptJavaScript()
    {60, 456, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 57},	//374 QWebPage::loadStarted()
    {60, 454, 38, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 58},	//375 QWebPage::loadProgress(int)
    {60, 452, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 59},	//376 QWebPage::loadFinished(bool)
    {60, 442, 21, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 60},	//377 QWebPage::linkHovered(const QString&, const QString&, const QString&)
    {60, 753, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 61},	//378 QWebPage::statusBarMessage(const QString&)
    {60, 619, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 62},	//379 QWebPage::selectionChanged()
    {60, 368, 177, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 63},	//380 QWebPage::frameCreated(QWebFrame*)
    {60, 372, 154, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 64},	//381 QWebPage::geometryChangeRequested(const QRect&)
    {60, 580, 154, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 65},	//382 QWebPage::repaintRequested(const QRect&)
    {60, 612, 179, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 66},	//383 QWebPage::scrollRequested(int, int, const QRect&)
    {60, 826, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 67},	//384 QWebPage::windowCloseRequested()
    {60, 551, 177, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 68},	//385 QWebPage::printRequested(QWebFrame*)
    {60, 438, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 69},	//386 QWebPage::linkClicked(const QUrl&)
    {60, 786, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 70},	//387 QWebPage::toolBarVisibilityChangeRequested(bool)
    {60, 755, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 71},	//388 QWebPage::statusBarVisibilityChangeRequested(bool)
    {60, 464, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 72},	//389 QWebPage::menuBarVisibilityChangeRequested(bool)
    {60, 804, 183, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 73},	//390 QWebPage::unsupportedContent(QNetworkReply*)
    {60, 293, 110, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 74},	//391 QWebPage::downloadRequested(const QNetworkRequest&)
    {60, 469, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 75},	//392 QWebPage::microFocusChanged()
    {60, 260, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 76},	//393 QWebPage::contentsChanged()
    {60, 279, 185, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 77},	//394 QWebPage::databaseQuotaExceeded(QWebFrame*, QString)
    {60, 217, 188, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 78},	//395 QWebPage::applicationCacheQuotaExceeded(QWebSecurityOrigin*, quint64)
    {60, 596, 191, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 79},	//396 QWebPage::saveFrameStateRequested(QWebFrame*, QWebHistoryItem*)
    {60, 594, 177, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 80},	//397 QWebPage::restoreFrameStateRequested(QWebFrame*)
    {60, 818, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 81},	//398 QWebPage::viewportChangeRequested()
    {60, 331, 194, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 82},	//399 QWebPage::featurePermissionRequested(QWebFrame*, QWebPage::Feature)
    {60, 329, 194, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 83},	//400 QWebPage::featurePermissionRequestCanceled(QWebFrame*, QWebPage::Feature)
    {60, 272, 197, 1, Smoke::mf_protected|Smoke::mf_virtual, 102, 84},	//401 QWebPage::createWindow(QWebPage::WebWindowType)
    {60, 269, 199, 4, Smoke::mf_protected|Smoke::mf_virtual, 40, 85},	//402 QWebPage::createPlugin(const QString&, const QUrl&, const QStringList&, const QStringList&)
    {60, 193, 204, 3, Smoke::mf_protected|Smoke::mf_virtual, 218, 86},	//403 QWebPage::acceptNavigationRequest(QWebFrame*, const QNetworkRequest&, QWebPage::NavigationType)
    {60, 243, 208, 2, Smoke::mf_protected|Smoke::mf_virtual, 62, 87},	//404 QWebPage::chooseFile(QWebFrame*, const QString&)
    {60, 420, 208, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 88},	//405 QWebPage::javaScriptAlert(QWebFrame*, const QString&)
    {60, 422, 208, 2, Smoke::mf_protected|Smoke::mf_virtual, 218, 89},	//406 QWebPage::javaScriptConfirm(QWebFrame*, const QString&)
    {60, 426, 211, 4, Smoke::mf_protected|Smoke::mf_virtual, 218, 90},	//407 QWebPage::javaScriptPrompt(QWebFrame*, const QString&, const QString&, QString*)
    {60, 424, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 91},	//408 QWebPage::javaScriptConsoleMessage(const QString&, int, const QString&)
    {60, 811, 62, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 62, 92},	//409 QWebPage::userAgentForUrl(const QUrl&) const
    {60, 789, 10, 1, Smoke::mf_static, 62, 93},	//410 QWebPage::tr(const char*)
    {60, 793, 10, 1, Smoke::mf_static, 62, 94},	//411 QWebPage::trUtf8(const char*)
    {60, 136, 0, 0, Smoke::mf_ctor, 102, 95},	//412 QWebPage::QWebPage()
    {60, 797, 149, 1, 0, 0, 96},	//413 QWebPage::triggerAction(QWebPage::WebAction)
    {60, 344, 16, 1, 0, 218, 97},	//414 QWebPage::findText(const QString&)
    {60, 325, 175, 1, 0, 218, 98},	//415 QWebPage::extension(QWebPage::Extension)
    {60, 325, 220, 2, 0, 218, 99},	//416 QWebPage::extension(QWebPage::Extension, const QWebPage::ExtensionOption*)
    {60, 752, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 222, 100},	//417 QWebPage::staticMetaObject() const
    {60, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 101},	//418 QWebPage::NavigationTypeLinkClicked (enum)
    {60, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 102},	//419 QWebPage::NavigationTypeFormSubmitted (enum)
    {60, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 103},	//420 QWebPage::NavigationTypeBackOrForward (enum)
    {60, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 104},	//421 QWebPage::NavigationTypeReload (enum)
    {60, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 105},	//422 QWebPage::NavigationTypeFormResubmitted (enum)
    {60, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 106},	//423 QWebPage::NavigationTypeOther (enum)
    {60, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 107},	//424 QWebPage::NoWebAction (enum)
    {60, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 108},	//425 QWebPage::OpenLink (enum)
    {60, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 109},	//426 QWebPage::OpenLinkInNewWindow (enum)
    {60, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 110},	//427 QWebPage::OpenFrameInNewWindow (enum)
    {60, 35, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 111},	//428 QWebPage::DownloadLinkToDisk (enum)
    {60, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 112},	//429 QWebPage::CopyLinkToClipboard (enum)
    {60, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 113},	//430 QWebPage::OpenImageInNewWindow (enum)
    {60, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 114},	//431 QWebPage::DownloadImageToDisk (enum)
    {60, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 115},	//432 QWebPage::CopyImageToClipboard (enum)
    {60, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 116},	//433 QWebPage::Back (enum)
    {60, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 117},	//434 QWebPage::Forward (enum)
    {60, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 118},	//435 QWebPage::Stop (enum)
    {60, 146, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 119},	//436 QWebPage::Reload (enum)
    {60, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 120},	//437 QWebPage::Cut (enum)
    {60, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 121},	//438 QWebPage::Copy (enum)
    {60, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 122},	//439 QWebPage::Paste (enum)
    {60, 183, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 123},	//440 QWebPage::Undo (enum)
    {60, 145, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 124},	//441 QWebPage::Redo (enum)
    {60, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 125},	//442 QWebPage::MoveToNextChar (enum)
    {60, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 126},	//443 QWebPage::MoveToPreviousChar (enum)
    {60, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 127},	//444 QWebPage::MoveToNextWord (enum)
    {60, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 128},	//445 QWebPage::MoveToPreviousWord (enum)
    {60, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 129},	//446 QWebPage::MoveToNextLine (enum)
    {60, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 130},	//447 QWebPage::MoveToPreviousLine (enum)
    {60, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 131},	//448 QWebPage::MoveToStartOfLine (enum)
    {60, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 132},	//449 QWebPage::MoveToEndOfLine (enum)
    {60, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 133},	//450 QWebPage::MoveToStartOfBlock (enum)
    {60, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 134},	//451 QWebPage::MoveToEndOfBlock (enum)
    {60, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 135},	//452 QWebPage::MoveToStartOfDocument (enum)
    {60, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 136},	//453 QWebPage::MoveToEndOfDocument (enum)
    {60, 157, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 137},	//454 QWebPage::SelectNextChar (enum)
    {60, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 138},	//455 QWebPage::SelectPreviousChar (enum)
    {60, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 139},	//456 QWebPage::SelectNextWord (enum)
    {60, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 140},	//457 QWebPage::SelectPreviousWord (enum)
    {60, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 141},	//458 QWebPage::SelectNextLine (enum)
    {60, 161, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 142},	//459 QWebPage::SelectPreviousLine (enum)
    {60, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 143},	//460 QWebPage::SelectStartOfLine (enum)
    {60, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 144},	//461 QWebPage::SelectEndOfLine (enum)
    {60, 163, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 145},	//462 QWebPage::SelectStartOfBlock (enum)
    {60, 154, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 146},	//463 QWebPage::SelectEndOfBlock (enum)
    {60, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 147},	//464 QWebPage::SelectStartOfDocument (enum)
    {60, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 148},	//465 QWebPage::SelectEndOfDocument (enum)
    {60, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 149},	//466 QWebPage::DeleteStartOfWord (enum)
    {60, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 150},	//467 QWebPage::DeleteEndOfWord (enum)
    {60, 167, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 151},	//468 QWebPage::SetTextDirectionDefault (enum)
    {60, 168, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 152},	//469 QWebPage::SetTextDirectionLeftToRight (enum)
    {60, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 153},	//470 QWebPage::SetTextDirectionRightToLeft (enum)
    {60, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 154},	//471 QWebPage::ToggleBold (enum)
    {60, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 155},	//472 QWebPage::ToggleItalic (enum)
    {60, 182, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 156},	//473 QWebPage::ToggleUnderline (enum)
    {60, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 157},	//474 QWebPage::InspectElement (enum)
    {60, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 158},	//475 QWebPage::InsertParagraphSeparator (enum)
    {60, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 159},	//476 QWebPage::InsertLineSeparator (enum)
    {60, 153, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 160},	//477 QWebPage::SelectAll (enum)
    {60, 147, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 161},	//478 QWebPage::ReloadAndBypassCache (enum)
    {60, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 162},	//479 QWebPage::PasteAndMatchStyle (enum)
    {60, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 163},	//480 QWebPage::RemoveFormat (enum)
    {60, 179, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 164},	//481 QWebPage::ToggleStrikethrough (enum)
    {60, 180, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 165},	//482 QWebPage::ToggleSubscript (enum)
    {60, 181, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 166},	//483 QWebPage::ToggleSuperscript (enum)
    {60, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 167},	//484 QWebPage::InsertUnorderedList (enum)
    {60, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 168},	//485 QWebPage::InsertOrderedList (enum)
    {60, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 169},	//486 QWebPage::Indent (enum)
    {60, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 170},	//487 QWebPage::Outdent (enum)
    {60, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 171},	//488 QWebPage::AlignCenter (enum)
    {60, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 172},	//489 QWebPage::AlignJustified (enum)
    {60, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 173},	//490 QWebPage::AlignLeft (enum)
    {60, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 174},	//491 QWebPage::AlignRight (enum)
    {60, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 175},	//492 QWebPage::StopScheduledPageRefresh (enum)
    {60, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 176},	//493 QWebPage::CopyImageUrlToClipboard (enum)
    {60, 186, 0, 0, Smoke::mf_static|Smoke::mf_enum, 119, 177},	//494 QWebPage::WebActionCount (enum)
    {60, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 178},	//495 QWebPage::FindBackward (enum)
    {60, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 179},	//496 QWebPage::FindCaseSensitively (enum)
    {60, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 180},	//497 QWebPage::FindWrapsAroundDocument (enum)
    {60, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 181},	//498 QWebPage::HighlightAllOccurrences (enum)
    {60, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 182},	//499 QWebPage::DontDelegateLinks (enum)
    {60, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 183},	//500 QWebPage::DelegateExternalLinks (enum)
    {60, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 184},	//501 QWebPage::DelegateAllLinks (enum)
    {60, 187, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 185},	//502 QWebPage::WebBrowserWindow (enum)
    {60, 190, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 186},	//503 QWebPage::WebModalDialog (enum)
    {60, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 187},	//504 QWebPage::PermissionUnknown (enum)
    {60, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 188},	//505 QWebPage::PermissionGrantedByUser (enum)
    {60, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 189},	//506 QWebPage::PermissionDeniedByUser (enum)
    {60, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 190},	//507 QWebPage::Notifications (enum)
    {60, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 191},	//508 QWebPage::Geolocation (enum)
    {60, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 192},	//509 QWebPage::ChooseMultipleFilesExtension (enum)
    {60, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 193},	//510 QWebPage::ErrorPageExtension (enum)
    {60, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 194},	//511 QWebPage::QtNetwork (enum)
    {60, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 195},	//512 QWebPage::Http (enum)
    {60, 189, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 196},	//513 QWebPage::WebKit (enum)
    {60, 844, 0, 0, Smoke::mf_dtor, 0, 197 },	//514 QWebPage::~QWebPage()
    {61, 11, 0, 0, Smoke::mf_ctor, 103, 1},	//515 QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption()
    {61, 11, 223, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 103, 2},	//516 QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption(const QWebPage::ChooseMultipleFilesExtensionOption&)
    {61, 534, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 91, 3},	//517 QWebPage::ChooseMultipleFilesExtensionOption::parentFrame() const
    {61, 706, 177, 1, Smoke::mf_attribute, 0, 4},	//518 QWebPage::ChooseMultipleFilesExtensionOption::setParentFrame(QWebFrame*)
    {61, 761, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 66, 5},	//519 QWebPage::ChooseMultipleFilesExtensionOption::suggestedFileNames() const
    {61, 727, 225, 1, Smoke::mf_attribute, 0, 6},	//520 QWebPage::ChooseMultipleFilesExtensionOption::setSuggestedFileNames(const QStringList&)
    {61, 829, 0, 0, Smoke::mf_dtor, 0, 7 },	//521 QWebPage::ChooseMultipleFilesExtensionOption::~ChooseMultipleFilesExtensionOption()
    {62, 13, 0, 0, Smoke::mf_ctor, 104, 1},	//522 QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn()
    {62, 13, 227, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 104, 2},	//523 QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn(const QWebPage::ChooseMultipleFilesExtensionReturn&)
    {62, 335, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 66, 3},	//524 QWebPage::ChooseMultipleFilesExtensionReturn::fileNames() const
    {62, 658, 225, 1, Smoke::mf_attribute, 0, 4},	//525 QWebPage::ChooseMultipleFilesExtensionReturn::setFileNames(const QStringList&)
    {62, 830, 0, 0, Smoke::mf_dtor, 0, 5 },	//526 QWebPage::ChooseMultipleFilesExtensionReturn::~ChooseMultipleFilesExtensionReturn()
    {63, 39, 0, 0, Smoke::mf_ctor, 106, 1},	//527 QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption()
    {63, 39, 229, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 106, 2},	//528 QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption(const QWebPage::ErrorPageExtensionOption&)
    {63, 808, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 73, 3},	//529 QWebPage::ErrorPageExtensionOption::url() const
    {63, 731, 62, 1, Smoke::mf_attribute, 0, 4},	//530 QWebPage::ErrorPageExtensionOption::setUrl(const QUrl&)
    {63, 365, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 91, 5},	//531 QWebPage::ErrorPageExtensionOption::frame() const
    {63, 667, 177, 1, Smoke::mf_attribute, 0, 6},	//532 QWebPage::ErrorPageExtensionOption::setFrame(QWebFrame*)
    {63, 292, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 105, 7},	//533 QWebPage::ErrorPageExtensionOption::domain() const
    {63, 646, 231, 1, Smoke::mf_attribute, 0, 8},	//534 QWebPage::ErrorPageExtensionOption::setDomain(QWebPage::ErrorDomain)
    {63, 317, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 263, 9},	//535 QWebPage::ErrorPageExtensionOption::error() const
    {63, 650, 38, 1, Smoke::mf_attribute, 0, 10},	//536 QWebPage::ErrorPageExtensionOption::setError(int)
    {63, 318, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 11},	//537 QWebPage::ErrorPageExtensionOption::errorString() const
    {63, 652, 16, 1, Smoke::mf_attribute, 0, 12},	//538 QWebPage::ErrorPageExtensionOption::setErrorString(const QString&)
    {63, 831, 0, 0, Smoke::mf_dtor, 0, 13 },	//539 QWebPage::ErrorPageExtensionOption::~ErrorPageExtensionOption()
    {64, 41, 0, 0, Smoke::mf_ctor, 107, 1},	//540 QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn()
    {64, 41, 233, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 107, 2},	//541 QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn(const QWebPage::ErrorPageExtensionReturn&)
    {64, 259, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 3},	//542 QWebPage::ErrorPageExtensionReturn::contentType() const
    {64, 636, 16, 1, Smoke::mf_attribute, 0, 4},	//543 QWebPage::ErrorPageExtensionReturn::setContentType(const QString&)
    {64, 314, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 5},	//544 QWebPage::ErrorPageExtensionReturn::encoding() const
    {64, 648, 16, 1, Smoke::mf_attribute, 0, 6},	//545 QWebPage::ErrorPageExtensionReturn::setEncoding(const QString&)
    {64, 233, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 73, 7},	//546 QWebPage::ErrorPageExtensionReturn::baseUrl() const
    {64, 628, 62, 1, Smoke::mf_attribute, 0, 8},	//547 QWebPage::ErrorPageExtensionReturn::setBaseUrl(const QUrl&)
    {64, 258, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 4, 9},	//548 QWebPage::ErrorPageExtensionReturn::content() const
    {64, 630, 115, 1, Smoke::mf_attribute, 0, 10},	//549 QWebPage::ErrorPageExtensionReturn::setContent(const QByteArray&)
    {64, 832, 0, 0, Smoke::mf_dtor, 0, 11 },	//550 QWebPage::ErrorPageExtensionReturn::~ErrorPageExtensionReturn()
    {65, 43, 0, 0, Smoke::mf_ctor, 109, 1},	//551 QWebPage::ExtensionOption::ExtensionOption()
    {65, 43, 235, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 109, 2},	//552 QWebPage::ExtensionOption::ExtensionOption(const QWebPage::ExtensionOption&)
    {65, 833, 0, 0, Smoke::mf_dtor, 0, 3 },	//553 QWebPage::ExtensionOption::~ExtensionOption()
    {66, 45, 0, 0, Smoke::mf_ctor, 110, 1},	//554 QWebPage::ExtensionReturn::ExtensionReturn()
    {66, 45, 237, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 110, 2},	//555 QWebPage::ExtensionReturn::ExtensionReturn(const QWebPage::ExtensionReturn&)
    {66, 834, 0, 0, Smoke::mf_dtor, 0, 3 },	//556 QWebPage::ExtensionReturn::~ExtensionReturn()
    {67, 184, 0, 0, Smoke::mf_ctor, 118, 1},	//557 QWebPage::ViewportAttributes::ViewportAttributes()
    {67, 184, 239, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 118, 2},	//558 QWebPage::ViewportAttributes::ViewportAttributes(const QWebPage::ViewportAttributes&)
    {67, 512, 239, 1, 0, 117, 3},	//559 QWebPage::ViewportAttributes::operator=(const QWebPage::ViewportAttributes&)
    {67, 403, 0, 0, Smoke::mf_const, 262, 4},	//560 QWebPage::ViewportAttributes::initialScaleFactor() const
    {67, 471, 0, 0, Smoke::mf_const, 262, 5},	//561 QWebPage::ViewportAttributes::minimumScaleFactor() const
    {67, 463, 0, 0, Smoke::mf_const, 262, 6},	//562 QWebPage::ViewportAttributes::maximumScaleFactor() const
    {67, 287, 0, 0, Smoke::mf_const, 262, 7},	//563 QWebPage::ViewportAttributes::devicePixelRatio() const
    {67, 412, 0, 0, Smoke::mf_const, 218, 8},	//564 QWebPage::ViewportAttributes::isUserScalable() const
    {67, 413, 0, 0, Smoke::mf_const, 218, 9},	//565 QWebPage::ViewportAttributes::isValid() const
    {67, 750, 0, 0, Smoke::mf_const, 55, 10},	//566 QWebPage::ViewportAttributes::size() const
    {67, 848, 0, 0, Smoke::mf_dtor, 0, 11 },	//567 QWebPage::ViewportAttributes::~ViewportAttributes()
    {69, 467, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 223, 1},	//568 QWebPluginFactory::metaObject() const
    {69, 556, 10, 1, Smoke::mf_virtual, 271, 2},	//569 QWebPluginFactory::qt_metacast(const char*)
    {69, 789, 51, 2, Smoke::mf_static, 62, 3},	//570 QWebPluginFactory::tr(const char*, const char*)
    {69, 793, 51, 2, Smoke::mf_static, 62, 4},	//571 QWebPluginFactory::trUtf8(const char*, const char*)
    {69, 789, 54, 3, Smoke::mf_static, 62, 5},	//572 QWebPluginFactory::tr(const char*, const char*, int)
    {69, 793, 54, 3, Smoke::mf_static, 62, 6},	//573 QWebPluginFactory::trUtf8(const char*, const char*, int)
    {69, 554, 58, 3, Smoke::mf_virtual, 263, 7},	//574 QWebPluginFactory::qt_metacall(QMetaObject::Call, int, void**)
    {69, 138, 125, 1, Smoke::mf_ctor, 122, 8},	//575 QWebPluginFactory::QWebPluginFactory(QObject*)
    {69, 537, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 29, 9},	//576 QWebPluginFactory::plugins() const [pure virtual]
    {69, 558, 0, 0, Smoke::mf_virtual, 0, 10},	//577 QWebPluginFactory::refreshPlugins()
    {69, 267, 199, 4, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 40, 11},	//578 QWebPluginFactory::create(const QString&, const QUrl&, const QStringList&, const QStringList&) const [pure virtual]
    {69, 325, 241, 3, Smoke::mf_virtual, 218, 12},	//579 QWebPluginFactory::extension(QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*, QWebPluginFactory::ExtensionReturn*)
    {69, 765, 245, 1, Smoke::mf_const|Smoke::mf_virtual, 218, 13},	//580 QWebPluginFactory::supportsExtension(QWebPluginFactory::Extension) const
    {69, 789, 10, 1, Smoke::mf_static, 62, 14},	//581 QWebPluginFactory::tr(const char*)
    {69, 793, 10, 1, Smoke::mf_static, 62, 15},	//582 QWebPluginFactory::trUtf8(const char*)
    {69, 138, 0, 0, Smoke::mf_ctor, 122, 16},	//583 QWebPluginFactory::QWebPluginFactory()
    {69, 325, 245, 1, 0, 218, 17},	//584 QWebPluginFactory::extension(QWebPluginFactory::Extension)
    {69, 325, 247, 2, 0, 218, 18},	//585 QWebPluginFactory::extension(QWebPluginFactory::Extension, const QWebPluginFactory::ExtensionOption*)
    {69, 752, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 222, 19},	//586 QWebPluginFactory::staticMetaObject() const
    {69, 845, 0, 0, Smoke::mf_dtor, 0, 20 },	//587 QWebPluginFactory::~QWebPluginFactory()
    {70, 43, 0, 0, Smoke::mf_ctor, 124, 1},	//588 QWebPluginFactory::ExtensionOption::ExtensionOption()
    {70, 43, 250, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 124, 2},	//589 QWebPluginFactory::ExtensionOption::ExtensionOption(const QWebPluginFactory::ExtensionOption&)
    {70, 833, 0, 0, Smoke::mf_dtor, 0, 3 },	//590 QWebPluginFactory::ExtensionOption::~ExtensionOption()
    {71, 45, 0, 0, Smoke::mf_ctor, 125, 1},	//591 QWebPluginFactory::ExtensionReturn::ExtensionReturn()
    {71, 45, 252, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 125, 2},	//592 QWebPluginFactory::ExtensionReturn::ExtensionReturn(const QWebPluginFactory::ExtensionReturn&)
    {71, 834, 0, 0, Smoke::mf_dtor, 0, 3 },	//593 QWebPluginFactory::ExtensionReturn::~ExtensionReturn()
    {72, 514, 254, 1, Smoke::mf_const, 218, 1},	//594 QWebPluginFactory::MimeType::operator==(const QWebPluginFactory::MimeType&) const
    {72, 490, 254, 1, Smoke::mf_const, 218, 2},	//595 QWebPluginFactory::MimeType::operator!=(const QWebPluginFactory::MimeType&) const
    {72, 77, 0, 0, Smoke::mf_ctor, 127, 3},	//596 QWebPluginFactory::MimeType::MimeType()
    {72, 77, 254, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 127, 4},	//597 QWebPluginFactory::MimeType::MimeType(const QWebPluginFactory::MimeType&)
    {72, 482, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 5},	//598 QWebPluginFactory::MimeType::name() const
    {72, 686, 16, 1, Smoke::mf_attribute, 0, 6},	//599 QWebPluginFactory::MimeType::setName(const QString&)
    {72, 285, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 7},	//600 QWebPluginFactory::MimeType::description() const
    {72, 644, 16, 1, Smoke::mf_attribute, 0, 8},	//601 QWebPluginFactory::MimeType::setDescription(const QString&)
    {72, 333, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 66, 9},	//602 QWebPluginFactory::MimeType::fileExtensions() const
    {72, 656, 225, 1, Smoke::mf_attribute, 0, 10},	//603 QWebPluginFactory::MimeType::setFileExtensions(const QStringList&)
    {72, 835, 0, 0, Smoke::mf_dtor, 0, 11 },	//604 QWebPluginFactory::MimeType::~MimeType()
    {73, 116, 0, 0, Smoke::mf_ctor, 129, 1},	//605 QWebPluginFactory::Plugin::Plugin()
    {73, 116, 256, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 129, 2},	//606 QWebPluginFactory::Plugin::Plugin(const QWebPluginFactory::Plugin&)
    {73, 482, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 3},	//607 QWebPluginFactory::Plugin::name() const
    {73, 686, 16, 1, Smoke::mf_attribute, 0, 4},	//608 QWebPluginFactory::Plugin::setName(const QString&)
    {73, 285, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 63, 5},	//609 QWebPluginFactory::Plugin::description() const
    {73, 644, 16, 1, Smoke::mf_attribute, 0, 6},	//610 QWebPluginFactory::Plugin::setDescription(const QString&)
    {73, 470, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 28, 7},	//611 QWebPluginFactory::Plugin::mimeTypes() const
    {73, 684, 258, 1, Smoke::mf_attribute, 0, 8},	//612 QWebPluginFactory::Plugin::setMimeTypes(const QList<QWebPluginFactory::MimeType>&)
    {73, 836, 0, 0, Smoke::mf_dtor, 0, 9 },	//613 QWebPluginFactory::Plugin::~Plugin()
    {74, 207, 0, 0, Smoke::mf_static, 30, 1},	//614 QWebSecurityOrigin::allOrigins()
    {74, 202, 16, 1, Smoke::mf_static, 0, 2},	//615 QWebSecurityOrigin::addLocalScheme(const QString&)
    {74, 571, 16, 1, Smoke::mf_static, 0, 3},	//616 QWebSecurityOrigin::removeLocalScheme(const QString&)
    {74, 458, 0, 0, Smoke::mf_static, 65, 4},	//617 QWebSecurityOrigin::localSchemes()
    {74, 598, 0, 0, Smoke::mf_const, 62, 5},	//618 QWebSecurityOrigin::scheme() const
    {74, 395, 0, 0, Smoke::mf_const, 62, 6},	//619 QWebSecurityOrigin::host() const
    {74, 538, 0, 0, Smoke::mf_const, 263, 7},	//620 QWebSecurityOrigin::port() const
    {74, 281, 0, 0, Smoke::mf_const, 265, 8},	//621 QWebSecurityOrigin::databaseUsage() const
    {74, 278, 0, 0, Smoke::mf_const, 265, 9},	//622 QWebSecurityOrigin::databaseQuota() const
    {74, 638, 260, 1, 0, 0, 10},	//623 QWebSecurityOrigin::setDatabaseQuota(long long)
    {74, 622, 260, 1, 0, 0, 11},	//624 QWebSecurityOrigin::setApplicationCacheQuota(long long)
    {74, 282, 0, 0, Smoke::mf_const, 24, 12},	//625 QWebSecurityOrigin::databases() const
    {74, 140, 262, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 132, 13},	//626 QWebSecurityOrigin::QWebSecurityOrigin(const QWebSecurityOrigin&)
    {74, 512, 262, 1, 0, 131, 14},	//627 QWebSecurityOrigin::operator=(const QWebSecurityOrigin&)
    {74, 846, 0, 0, Smoke::mf_dtor, 0, 15 },	//628 QWebSecurityOrigin::~QWebSecurityOrigin()
    {75, 374, 0, 0, Smoke::mf_static, 133, 1},	//629 QWebSettings::globalSettings()
    {75, 661, 264, 2, 0, 0, 2},	//630 QWebSettings::setFontFamily(QWebSettings::FontFamily, const QString&)
    {75, 356, 267, 1, Smoke::mf_const, 62, 3},	//631 QWebSettings::fontFamily(QWebSettings::FontFamily) const
    {75, 588, 267, 1, 0, 0, 4},	//632 QWebSettings::resetFontFamily(QWebSettings::FontFamily)
    {75, 663, 269, 2, 0, 0, 5},	//633 QWebSettings::setFontSize(QWebSettings::FontSize, int)
    {75, 358, 272, 1, Smoke::mf_const, 263, 6},	//634 QWebSettings::fontSize(QWebSettings::FontSize) const
    {75, 590, 272, 1, 0, 0, 7},	//635 QWebSettings::resetFontSize(QWebSettings::FontSize)
    {75, 624, 274, 2, 0, 0, 8},	//636 QWebSettings::setAttribute(QWebSettings::WebAttribute, bool)
    {75, 772, 277, 1, Smoke::mf_const, 218, 9},	//637 QWebSettings::testAttribute(QWebSettings::WebAttribute) const
    {75, 586, 277, 1, 0, 0, 10},	//638 QWebSettings::resetAttribute(QWebSettings::WebAttribute)
    {75, 735, 62, 1, 0, 0, 11},	//639 QWebSettings::setUserStyleSheetUrl(const QUrl&)
    {75, 814, 0, 0, Smoke::mf_const, 72, 12},	//640 QWebSettings::userStyleSheetUrl() const
    {75, 642, 16, 1, 0, 0, 13},	//641 QWebSettings::setDefaultTextEncoding(const QString&)
    {75, 284, 0, 0, Smoke::mf_const, 62, 14},	//642 QWebSettings::defaultTextEncoding() const
    {75, 672, 16, 1, Smoke::mf_static, 0, 15},	//643 QWebSettings::setIconDatabasePath(const QString&)
    {75, 398, 0, 0, Smoke::mf_static, 62, 16},	//644 QWebSettings::iconDatabasePath()
    {75, 247, 0, 0, Smoke::mf_static, 0, 17},	//645 QWebSettings::clearIconDatabase()
    {75, 399, 62, 1, Smoke::mf_static, 20, 18},	//646 QWebSettings::iconForUrl(const QUrl&)
    {75, 742, 279, 2, Smoke::mf_static, 0, 19},	//647 QWebSettings::setWebGraphic(QWebSettings::WebGraphic, const QPixmap&)
    {75, 821, 282, 1, Smoke::mf_static, 47, 20},	//648 QWebSettings::webGraphic(QWebSettings::WebGraphic)
    {75, 682, 38, 1, Smoke::mf_static, 0, 21},	//649 QWebSettings::setMaximumPagesInCache(int)
    {75, 462, 0, 0, Smoke::mf_static, 263, 22},	//650 QWebSettings::maximumPagesInCache()
    {75, 690, 284, 3, Smoke::mf_static, 0, 23},	//651 QWebSettings::setObjectCacheCapacities(int, int, int)
    {75, 694, 16, 1, Smoke::mf_static, 0, 24},	//652 QWebSettings::setOfflineStoragePath(const QString&)
    {75, 487, 0, 0, Smoke::mf_static, 62, 25},	//653 QWebSettings::offlineStoragePath()
    {75, 692, 260, 1, Smoke::mf_static, 0, 26},	//654 QWebSettings::setOfflineStorageDefaultQuota(long long)
    {75, 486, 0, 0, Smoke::mf_static, 265, 27},	//655 QWebSettings::offlineStorageDefaultQuota()
    {75, 696, 16, 1, Smoke::mf_static, 0, 28},	//656 QWebSettings::setOfflineWebApplicationCachePath(const QString&)
    {75, 488, 0, 0, Smoke::mf_static, 62, 29},	//657 QWebSettings::offlineWebApplicationCachePath()
    {75, 698, 260, 1, Smoke::mf_static, 0, 30},	//658 QWebSettings::setOfflineWebApplicationCacheQuota(long long)
    {75, 489, 0, 0, Smoke::mf_static, 265, 31},	//659 QWebSettings::offlineWebApplicationCacheQuota()
    {75, 678, 16, 1, 0, 0, 32},	//660 QWebSettings::setLocalStoragePath(const QString&)
    {75, 459, 0, 0, Smoke::mf_const, 62, 33},	//661 QWebSettings::localStoragePath() const
    {75, 248, 0, 0, Smoke::mf_static, 0, 34},	//662 QWebSettings::clearMemoryCaches()
    {75, 304, 16, 1, Smoke::mf_static, 0, 35},	//663 QWebSettings::enablePersistentStorage(const QString&)
    {75, 377, 0, 0, Smoke::mf_const, 138, 36},	//664 QWebSettings::handle() const
    {75, 304, 0, 0, Smoke::mf_static, 0, 37},	//665 QWebSettings::enablePersistentStorage()
    {75, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 38},	//666 QWebSettings::StandardFont (enum)
    {75, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 39},	//667 QWebSettings::FixedFont (enum)
    {75, 166, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 40},	//668 QWebSettings::SerifFont (enum)
    {75, 149, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 41},	//669 QWebSettings::SansSerifFont (enum)
    {75, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 42},	//670 QWebSettings::CursiveFont (enum)
    {75, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 43},	//671 QWebSettings::FantasyFont (enum)
    {75, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 44},	//672 QWebSettings::AutoLoadImages (enum)
    {75, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 45},	//673 QWebSettings::JavascriptEnabled (enum)
    {75, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 46},	//674 QWebSettings::JavaEnabled (enum)
    {75, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 47},	//675 QWebSettings::PluginsEnabled (enum)
    {75, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 48},	//676 QWebSettings::PrivateBrowsingEnabled (enum)
    {75, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 49},	//677 QWebSettings::JavascriptCanOpenWindows (enum)
    {75, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 50},	//678 QWebSettings::JavascriptCanAccessClipboard (enum)
    {75, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 51},	//679 QWebSettings::DeveloperExtrasEnabled (enum)
    {75, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 52},	//680 QWebSettings::LinksIncludedInFocusChain (enum)
    {75, 192, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 53},	//681 QWebSettings::ZoomTextOnly (enum)
    {75, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 54},	//682 QWebSettings::PrintElementBackgrounds (enum)
    {75, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 55},	//683 QWebSettings::OfflineStorageDatabaseEnabled (enum)
    {75, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 56},	//684 QWebSettings::OfflineWebApplicationCacheEnabled (enum)
    {75, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 57},	//685 QWebSettings::LocalStorageEnabled (enum)
    {75, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 58},	//686 QWebSettings::LocalStorageDatabaseEnabled (enum)
    {75, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 59},	//687 QWebSettings::LocalContentCanAccessRemoteUrls (enum)
    {75, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 60},	//688 QWebSettings::DnsPrefetchEnabled (enum)
    {75, 191, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 61},	//689 QWebSettings::XSSAuditingEnabled (enum)
    {75, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 62},	//690 QWebSettings::AcceleratedCompositingEnabled (enum)
    {75, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 63},	//691 QWebSettings::SpatialNavigationEnabled (enum)
    {75, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 64},	//692 QWebSettings::LocalContentCanAccessFileUrls (enum)
    {75, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 65},	//693 QWebSettings::TiledBackingStoreEnabled (enum)
    {75, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 66},	//694 QWebSettings::FrameFlatteningEnabled (enum)
    {75, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 67},	//695 QWebSettings::SiteSpecificQuirksEnabled (enum)
    {75, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 68},	//696 QWebSettings::JavascriptCanCloseWindows (enum)
    {75, 188, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 69},	//697 QWebSettings::WebGLEnabled (enum)
    {75, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 70},	//698 QWebSettings::HyperlinkAuditingEnabled (enum)
    {75, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 71},	//699 QWebSettings::MissingImageGraphic (enum)
    {75, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 72},	//700 QWebSettings::MissingPluginGraphic (enum)
    {75, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 73},	//701 QWebSettings::DefaultFrameIconGraphic (enum)
    {75, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 74},	//702 QWebSettings::TextAreaSizeGripCornerGraphic (enum)
    {75, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 75},	//703 QWebSettings::DeleteButtonGraphic (enum)
    {75, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 76},	//704 QWebSettings::InputSpeechButtonGraphic (enum)
    {75, 151, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 77},	//705 QWebSettings::SearchCancelButtonGraphic (enum)
    {75, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 78},	//706 QWebSettings::SearchCancelButtonPressedGraphic (enum)
    {75, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 79},	//707 QWebSettings::MinimumFontSize (enum)
    {75, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 80},	//708 QWebSettings::MinimumLogicalFontSize (enum)
    {75, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 81},	//709 QWebSettings::DefaultFontSize (enum)
    {75, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 82},	//710 QWebSettings::DefaultFixedFontSize (enum)
    {77, 467, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 223, 1},	//711 QWebView::metaObject() const
    {77, 556, 10, 1, Smoke::mf_virtual, 271, 2},	//712 QWebView::qt_metacast(const char*)
    {77, 789, 51, 2, Smoke::mf_static, 62, 3},	//713 QWebView::tr(const char*, const char*)
    {77, 793, 51, 2, Smoke::mf_static, 62, 4},	//714 QWebView::trUtf8(const char*, const char*)
    {77, 789, 54, 3, Smoke::mf_static, 62, 5},	//715 QWebView::tr(const char*, const char*, int)
    {77, 793, 54, 3, Smoke::mf_static, 62, 6},	//716 QWebView::trUtf8(const char*, const char*, int)
    {77, 554, 58, 3, Smoke::mf_virtual, 263, 7},	//717 QWebView::qt_metacall(QMetaObject::Call, int, void**)
    {77, 142, 133, 1, Smoke::mf_ctor, 139, 8},	//718 QWebView::QWebView(QWidget*)
    {77, 524, 0, 0, Smoke::mf_const, 102, 9},	//719 QWebView::page() const
    {77, 702, 135, 1, 0, 0, 10},	//720 QWebView::setPage(QWebPage*)
    {77, 448, 62, 1, 0, 0, 11},	//721 QWebView::load(const QUrl&)
    {77, 448, 64, 3, 0, 0, 12},	//722 QWebView::load(const QNetworkRequest&, QNetworkAccessManager::Operation, const QByteArray&)
    {77, 669, 68, 2, 0, 0, 13},	//723 QWebView::setHtml(const QString&, const QUrl&)
    {77, 630, 71, 3, 0, 0, 14},	//724 QWebView::setContent(const QByteArray&, const QString&, const QUrl&)
    {77, 390, 0, 0, Smoke::mf_const, 93, 15},	//725 QWebView::history() const
    {77, 746, 0, 0, Smoke::mf_const, 133, 16},	//726 QWebView::settings() const
    {77, 776, 0, 0, Smoke::mf_const|Smoke::mf_property, 62, 17},	//727 QWebView::title() const
    {77, 731, 62, 1, Smoke::mf_property, 0, 18},	//728 QWebView::setUrl(const QUrl&)
    {77, 808, 0, 0, Smoke::mf_const|Smoke::mf_property, 72, 19},	//729 QWebView::url() const
    {77, 396, 0, 0, Smoke::mf_const|Smoke::mf_property, 20, 20},	//730 QWebView::icon() const
    {77, 386, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 21},	//731 QWebView::hasSelection() const
    {77, 618, 0, 0, Smoke::mf_const|Smoke::mf_property, 62, 22},	//732 QWebView::selectedText() const
    {77, 617, 0, 0, Smoke::mf_const|Smoke::mf_property, 62, 23},	//733 QWebView::selectedHtml() const
    {77, 525, 149, 1, Smoke::mf_const, 1, 24},	//734 QWebView::pageAction(QWebPage::WebAction) const
    {77, 800, 151, 2, 0, 0, 25},	//735 QWebView::triggerPageAction(QWebPage::WebAction, bool)
    {77, 410, 0, 0, Smoke::mf_const|Smoke::mf_property, 218, 26},	//736 QWebView::isModified() const
    {77, 406, 156, 1, Smoke::mf_const|Smoke::mf_virtual, 74, 27},	//737 QWebView::inputMethodQuery(Qt::InputMethodQuery) const
    {77, 751, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 55, 28},	//738 QWebView::sizeHint() const
    {77, 828, 0, 0, Smoke::mf_const, 262, 29},	//739 QWebView::zoomFactor() const
    {77, 744, 102, 1, 0, 0, 30},	//740 QWebView::setZoomFactor(double)
    {77, 729, 102, 1, 0, 0, 31},	//741 QWebView::setTextSizeMultiplier(double)
    {77, 774, 0, 0, Smoke::mf_const, 262, 32},	//742 QWebView::textSizeMultiplier() const
    {77, 578, 0, 0, Smoke::mf_const, 15, 33},	//743 QWebView::renderHints() const
    {77, 717, 288, 1, 0, 0, 34},	//744 QWebView::setRenderHints(QFlags<QPainter::RenderHint>)
    {77, 714, 290, 2, 0, 0, 35},	//745 QWebView::setRenderHint(QPainter::RenderHint, bool)
    {77, 344, 158, 2, 0, 218, 36},	//746 QWebView::findText(const QString&, QFlags<QWebPage::FindFlag>)
    {77, 321, 1, 1, Smoke::mf_virtual, 218, 37},	//747 QWebView::event(QEvent*)
    {77, 757, 0, 0, Smoke::mf_slot, 0, 38},	//748 QWebView::stop()
    {77, 229, 0, 0, Smoke::mf_slot, 0, 39},	//749 QWebView::back()
    {77, 360, 0, 0, Smoke::mf_slot, 0, 40},	//750 QWebView::forward()
    {77, 559, 0, 0, Smoke::mf_slot, 0, 41},	//751 QWebView::reload()
    {77, 549, 104, 1, Smoke::mf_const|Smoke::mf_slot, 0, 42},	//752 QWebView::print(QPrinter*) const
    {77, 456, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//753 QWebView::loadStarted()
    {77, 454, 38, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 44},	//754 QWebView::loadProgress(int)
    {77, 452, 108, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//755 QWebView::loadFinished(bool)
    {77, 777, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//756 QWebView::titleChanged(const QString&)
    {77, 753, 16, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//757 QWebView::statusBarMessage(const QString&)
    {77, 438, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//758 QWebView::linkClicked(const QUrl&)
    {77, 619, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//759 QWebView::selectionChanged()
    {77, 397, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//760 QWebView::iconChanged()
    {77, 809, 62, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//761 QWebView::urlChanged(const QUrl&)
    {77, 592, 137, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 52},	//762 QWebView::resizeEvent(QResizeEvent*)
    {77, 529, 293, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 53},	//763 QWebView::paintEvent(QPaintEvent*)
    {77, 272, 197, 1, Smoke::mf_protected|Smoke::mf_virtual, 139, 54},	//764 QWebView::createWindow(QWebPage::WebWindowType)
    {77, 239, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 55},	//765 QWebView::changeEvent(QEvent*)
    {77, 475, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 56},	//766 QWebView::mouseMoveEvent(QMouseEvent*)
    {77, 477, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 57},	//767 QWebView::mousePressEvent(QMouseEvent*)
    {77, 473, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 58},	//768 QWebView::mouseDoubleClickEvent(QMouseEvent*)
    {77, 479, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 59},	//769 QWebView::mouseReleaseEvent(QMouseEvent*)
    {77, 264, 165, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 60},	//770 QWebView::contextMenuEvent(QContextMenuEvent*)
    {77, 823, 297, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 61},	//771 QWebView::wheelEvent(QWheelEvent*)
    {77, 429, 299, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 62},	//772 QWebView::keyPressEvent(QKeyEvent*)
    {77, 431, 299, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 63},	//773 QWebView::keyReleaseEvent(QKeyEvent*)
    {77, 295, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 64},	//774 QWebView::dragEnterEvent(QDragEnterEvent*)
    {77, 297, 303, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 65},	//775 QWebView::dragLeaveEvent(QDragLeaveEvent*)
    {77, 299, 305, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 66},	//776 QWebView::dragMoveEvent(QDragMoveEvent*)
    {77, 301, 307, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 67},	//777 QWebView::dropEvent(QDropEvent*)
    {77, 349, 309, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 68},	//778 QWebView::focusInEvent(QFocusEvent*)
    {77, 353, 309, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 69},	//779 QWebView::focusOutEvent(QFocusEvent*)
    {77, 404, 311, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 70},	//780 QWebView::inputMethodEvent(QInputMethodEvent*)
    {77, 351, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 218, 71},	//781 QWebView::focusNextPrevChild(bool)
    {77, 789, 10, 1, Smoke::mf_static, 62, 72},	//782 QWebView::tr(const char*)
    {77, 793, 10, 1, Smoke::mf_static, 62, 73},	//783 QWebView::trUtf8(const char*)
    {77, 142, 0, 0, Smoke::mf_ctor, 139, 74},	//784 QWebView::QWebView()
    {77, 448, 110, 1, 0, 0, 75},	//785 QWebView::load(const QNetworkRequest&)
    {77, 448, 112, 2, 0, 0, 76},	//786 QWebView::load(const QNetworkRequest&, QNetworkAccessManager::Operation)
    {77, 669, 16, 1, 0, 0, 77},	//787 QWebView::setHtml(const QString&)
    {77, 630, 115, 1, 0, 0, 78},	//788 QWebView::setContent(const QByteArray&)
    {77, 630, 117, 2, 0, 0, 79},	//789 QWebView::setContent(const QByteArray&, const QString&)
    {77, 800, 149, 1, 0, 0, 80},	//790 QWebView::triggerPageAction(QWebPage::WebAction)
    {77, 714, 313, 1, 0, 0, 81},	//791 QWebView::setRenderHint(QPainter::RenderHint)
    {77, 344, 16, 1, 0, 218, 82},	//792 QWebView::findText(const QString&)
    {77, 752, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 222, 83},	//793 QWebView::staticMetaObject() const
    {77, 847, 0, 0, Smoke::mf_dtor, 0, 84 },	//794 QWebView::~QWebView()
    {79, 286, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 263, 0},	//795 QWidget::devType() const
    {79, 741, 108, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//796 QWidget::setVisible(bool)
    {79, 472, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 55, 0},	//797 QWidget::minimumSizeHint() const
    {79, 387, 38, 1, Smoke::mf_const|Smoke::mf_virtual, 263, 0},	//798 QWidget::heightForWidth(int) const
    {79, 528, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 42, 0},	//799 QWidget::paintEngine() const
    {79, 477, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//800 QWidget::mousePressEvent(QMouseEvent*)
    {79, 479, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//801 QWidget::mouseReleaseEvent(QMouseEvent*)
    {79, 473, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//802 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {79, 475, 295, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//803 QWidget::mouseMoveEvent(QMouseEvent*)
    {79, 823, 297, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//804 QWidget::wheelEvent(QWheelEvent*)
    {79, 429, 299, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//805 QWidget::keyPressEvent(QKeyEvent*)
    {79, 431, 299, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//806 QWidget::keyReleaseEvent(QKeyEvent*)
    {79, 349, 309, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//807 QWidget::focusInEvent(QFocusEvent*)
    {79, 353, 309, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//808 QWidget::focusOutEvent(QFocusEvent*)
    {79, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//809 QWidget::enterEvent(QEvent*)
    {79, 437, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//810 QWidget::leaveEvent(QEvent*)
    {79, 529, 293, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//811 QWidget::paintEvent(QPaintEvent*)
    {79, 481, 315, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//812 QWidget::moveEvent(QMoveEvent*)
    {79, 250, 143, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//813 QWidget::closeEvent(QCloseEvent*)
    {79, 264, 165, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//814 QWidget::contextMenuEvent(QContextMenuEvent*)
    {79, 769, 317, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//815 QWidget::tabletEvent(QTabletEvent*)
    {79, 197, 319, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//816 QWidget::actionEvent(QActionEvent*)
    {79, 295, 301, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//817 QWidget::dragEnterEvent(QDragEnterEvent*)
    {79, 299, 305, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//818 QWidget::dragMoveEvent(QDragMoveEvent*)
    {79, 297, 303, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//819 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {79, 301, 307, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//820 QWidget::dropEvent(QDropEvent*)
    {79, 748, 139, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//821 QWidget::showEvent(QShowEvent*)
    {79, 388, 141, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//822 QWidget::hideEvent(QHideEvent*)
    {79, 827, 321, 1, Smoke::mf_protected|Smoke::mf_virtual, 218, 0},	//823 QWidget::x11Event(_XEvent*)
    {79, 239, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//824 QWidget::changeEvent(QEvent*)
    {79, 468, 323, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 263, 0},	//825 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {79, 404, 311, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//826 QWidget::inputMethodEvent(QInputMethodEvent*)
    {79, 406, 156, 1, Smoke::mf_const|Smoke::mf_virtual, 74, 0},	//827 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {79, 351, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 218, 0},	//828 QWidget::focusNextPrevChild(bool)
    {79, 758, 325, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//829 QWidget::styleChange(QStyle&)
    {79, 306, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//830 QWidget::enabledChange(bool)
    {79, 532, 163, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//831 QWidget::paletteChange(const QPalette&)
    {79, 355, 327, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//832 QWidget::fontChange(const QFont&)
    {79, 825, 108, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//833 QWidget::windowActivationChange(bool)
    {79, 433, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//834 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    105,  // QWebElementCollection::begin() const
    109,  // QWebElementCollection::begin()
    0,
    106,  // QWebElementCollection::end() const
    110,  // QWebElementCollection::end()
    0,
    158,  // QWebFrame::load(const QUrl&)
    220,  // QWebFrame::load(const QNetworkRequest&)
    0,
    721,  // QWebView::load(const QUrl&)
    785,  // QWebView::load(const QNetworkRequest&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {49, 122, 8},	// QWebDatabase::QWebDatabase#
    {49, 289, 11},	// QWebDatabase::displayName
    {49, 324, 12},	// QWebDatabase::expectedSize
    {49, 334, 14},	// QWebDatabase::fileName
    {49, 482, 10},	// QWebDatabase::name
    {49, 513, 9},	// QWebDatabase::operator=#
    {49, 522, 15},	// QWebDatabase::origin
    {49, 561, 17},	// QWebDatabase::removeAllDatabases
    {49, 569, 16},	// QWebDatabase::removeDatabase#
    {49, 750, 13},	// QWebDatabase::size
    {49, 837, 18},	// QWebDatabase::~QWebDatabase
    {50, 9, 89},	// QWebElement::CascadedStyle
    {50, 15, 90},	// QWebElement::ComputedStyle
    {50, 60, 88},	// QWebElement::InlineStyle
    {50, 123, 19},	// QWebElement::QWebElement
    {50, 124, 20},	// QWebElement::QWebElement#
    {50, 199, 45},	// QWebElement::addClass$
    {50, 212, 63},	// QWebElement::appendInside#
    {50, 213, 62},	// QWebElement::appendInside$
    {50, 215, 67},	// QWebElement::appendOutside#
    {50, 216, 66},	// QWebElement::appendOutside$
    {50, 222, 85},	// QWebElement::attribute$
    {50, 223, 35},	// QWebElement::attribute$$
    {50, 225, 86},	// QWebElement::attributeNS$$
    {50, 226, 36},	// QWebElement::attributeNS$$$
    {50, 227, 87},	// QWebElement::attributeNames
    {50, 228, 42},	// QWebElement::attributeNames$
    {50, 245, 43},	// QWebElement::classes
    {50, 249, 76},	// QWebElement::clone
    {50, 290, 60},	// QWebElement::document
    {50, 308, 70},	// QWebElement::encloseContentsWith#
    {50, 309, 71},	// QWebElement::encloseContentsWith$
    {50, 311, 73},	// QWebElement::encloseWith#
    {50, 312, 72},	// QWebElement::encloseWith$
    {50, 320, 80},	// QWebElement::evaluateJavaScript$
    {50, 337, 25},	// QWebElement::findAll$
    {50, 341, 26},	// QWebElement::findFirst$
    {50, 348, 56},	// QWebElement::firstChild
    {50, 371, 50},	// QWebElement::geometry
    {50, 379, 37},	// QWebElement::hasAttribute$
    {50, 381, 38},	// QWebElement::hasAttributeNS$$
    {50, 382, 41},	// QWebElement::hasAttributes
    {50, 384, 44},	// QWebElement::hasClass$
    {50, 385, 48},	// QWebElement::hasFocus
    {50, 411, 24},	// QWebElement::isNull
    {50, 435, 57},	// QWebElement::lastChild
    {50, 457, 53},	// QWebElement::localName
    {50, 483, 54},	// QWebElement::namespaceUri
    {50, 485, 58},	// QWebElement::nextSibling
    {50, 491, 23},	// QWebElement::operator!=#
    {50, 513, 21},	// QWebElement::operator=#
    {50, 515, 22},	// QWebElement::operator==#
    {50, 533, 55},	// QWebElement::parent
    {50, 541, 52},	// QWebElement::prefix
    {50, 543, 65},	// QWebElement::prependInside#
    {50, 544, 64},	// QWebElement::prependInside$
    {50, 546, 69},	// QWebElement::prependOutside#
    {50, 547, 68},	// QWebElement::prependOutside$
    {50, 548, 59},	// QWebElement::previousSibling
    {50, 560, 79},	// QWebElement::removeAllChildren
    {50, 563, 39},	// QWebElement::removeAttribute$
    {50, 565, 40},	// QWebElement::removeAttributeNS$$
    {50, 567, 46},	// QWebElement::removeClass$
    {50, 570, 78},	// QWebElement::removeFromDocument
    {50, 574, 83},	// QWebElement::render#
    {50, 575, 84},	// QWebElement::render##
    {50, 583, 75},	// QWebElement::replace#
    {50, 584, 74},	// QWebElement::replace$
    {50, 625, 33},	// QWebElement::setAttribute$$
    {50, 627, 34},	// QWebElement::setAttributeNS$$$
    {50, 660, 49},	// QWebElement::setFocus
    {50, 675, 31},	// QWebElement::setInnerXml$
    {50, 701, 29},	// QWebElement::setOuterXml$
    {50, 709, 27},	// QWebElement::setPlainText$
    {50, 726, 82},	// QWebElement::setStyleProperty$$
    {50, 760, 81},	// QWebElement::styleProperty$$
    {50, 770, 51},	// QWebElement::tagName
    {50, 771, 77},	// QWebElement::takeFromDocument
    {50, 780, 32},	// QWebElement::toInnerXml
    {50, 782, 30},	// QWebElement::toOuterXml
    {50, 783, 28},	// QWebElement::toPlainText
    {50, 785, 47},	// QWebElement::toggleClass$
    {50, 820, 61},	// QWebElement::webFrame
    {50, 838, 91},	// QWebElement::~QWebElement
    {51, 125, 92},	// QWebElementCollection::QWebElementCollection
    {51, 126, 94},	// QWebElementCollection::QWebElementCollection#
    {51, 127, 93},	// QWebElementCollection::QWebElementCollection#$
    {51, 210, 98},	// QWebElementCollection::append#
    {51, 220, 100},	// QWebElementCollection::at$
    {51, 234, -1},	// QWebElementCollection::begin
    {51, 253, 107},	// QWebElementCollection::constBegin
    {51, 254, 108},	// QWebElementCollection::constEnd
    {51, 266, 99},	// QWebElementCollection::count
    {51, 315, -4},	// QWebElementCollection::end
    {51, 347, 102},	// QWebElementCollection::first
    {51, 434, 103},	// QWebElementCollection::last
    {51, 494, 96},	// QWebElementCollection::operator+#
    {51, 499, 97},	// QWebElementCollection::operator+=#
    {51, 513, 95},	// QWebElementCollection::operator=#
    {51, 521, 101},	// QWebElementCollection::operator[]$
    {51, 781, 104},	// QWebElementCollection::toList
    {51, 839, 111},	// QWebElementCollection::~QWebElementCollection
    {52, 256, 113},	// QWebElementCollection::const_iterator::const_iterator#
    {52, 257, 112},	// QWebElementCollection::const_iterator::const_iterator#$
    {52, 491, 116},	// QWebElementCollection::const_iterator::operator!=#
    {52, 492, 114},	// QWebElementCollection::const_iterator::operator*
    {52, 495, 127},	// QWebElementCollection::const_iterator::operator+$
    {52, 496, 121},	// QWebElementCollection::const_iterator::operator++
    {52, 497, 122},	// QWebElementCollection::const_iterator::operator++$
    {52, 500, 125},	// QWebElementCollection::const_iterator::operator+=$
    {52, 502, 129},	// QWebElementCollection::const_iterator::operator-#
    {52, 503, 128},	// QWebElementCollection::const_iterator::operator-$
    {52, 504, 123},	// QWebElementCollection::const_iterator::operator--
    {52, 505, 124},	// QWebElementCollection::const_iterator::operator--$
    {52, 507, 126},	// QWebElementCollection::const_iterator::operator-=$
    {52, 509, 117},	// QWebElementCollection::const_iterator::operator<#
    {52, 511, 118},	// QWebElementCollection::const_iterator::operator<=#
    {52, 515, 115},	// QWebElementCollection::const_iterator::operator==#
    {52, 517, 119},	// QWebElementCollection::const_iterator::operator>#
    {52, 519, 120},	// QWebElementCollection::const_iterator::operator>=#
    {52, 849, 130},	// QWebElementCollection::const_iterator::~const_iterator
    {53, 418, 132},	// QWebElementCollection::iterator::iterator#
    {53, 419, 131},	// QWebElementCollection::iterator::iterator#$
    {53, 491, 135},	// QWebElementCollection::iterator::operator!=#
    {53, 492, 133},	// QWebElementCollection::iterator::operator*
    {53, 495, 146},	// QWebElementCollection::iterator::operator+$
    {53, 496, 140},	// QWebElementCollection::iterator::operator++
    {53, 497, 141},	// QWebElementCollection::iterator::operator++$
    {53, 500, 144},	// QWebElementCollection::iterator::operator+=$
    {53, 502, 148},	// QWebElementCollection::iterator::operator-#
    {53, 503, 147},	// QWebElementCollection::iterator::operator-$
    {53, 504, 142},	// QWebElementCollection::iterator::operator--
    {53, 505, 143},	// QWebElementCollection::iterator::operator--$
    {53, 507, 145},	// QWebElementCollection::iterator::operator-=$
    {53, 509, 136},	// QWebElementCollection::iterator::operator<#
    {53, 511, 137},	// QWebElementCollection::iterator::operator<=#
    {53, 515, 134},	// QWebElementCollection::iterator::operator==#
    {53, 517, 138},	// QWebElementCollection::iterator::operator>#
    {53, 519, 139},	// QWebElementCollection::iterator::operator>=#
    {53, 850, 149},	// QWebElementCollection::iterator::~iterator
    {54, 6, 230},	// QWebFrame::AllLayers
    {54, 16, 227},	// QWebFrame::ContentsLayer
    {54, 110, 229},	// QWebFrame::PanIconLayer
    {54, 150, 228},	// QWebFrame::ScrollBarLayer
    {54, 205, 162},	// QWebFrame::addToJavaScriptWindowObject$#
    {54, 206, 163},	// QWebFrame::addToJavaScriptWindowObject$#$
    {54, 233, 171},	// QWebFrame::baseUrl
    {54, 242, 176},	// QWebFrame::childFrames
    {54, 261, 199},	// QWebFrame::contentsSize
    {54, 263, 214},	// QWebFrame::contentsSizeChanged#
    {54, 291, 200},	// QWebFrame::documentElement
    {54, 320, 206},	// QWebFrame::evaluateJavaScript$
    {54, 322, 204},	// QWebFrame::event#
    {54, 339, 201},	// QWebFrame::findAllElements$
    {54, 343, 202},	// QWebFrame::findFirstElement$
    {54, 370, 174},	// QWebFrame::frameName
    {54, 371, 198},	// QWebFrame::geometry
    {54, 385, 195},	// QWebFrame::hasFocus
    {54, 394, 203},	// QWebFrame::hitTestContent#
    {54, 396, 172},	// QWebFrame::icon
    {54, 397, 213},	// QWebFrame::iconChanged
    {54, 402, 212},	// QWebFrame::initialLayoutCompleted
    {54, 428, 208},	// QWebFrame::javaScriptWindowObjectCleared
    {54, 449, -7},	// QWebFrame::load#
    {54, 450, 221},	// QWebFrame::load#$
    {54, 451, 159},	// QWebFrame::load#$#
    {54, 453, 216},	// QWebFrame::loadFinished$
    {54, 456, 215},	// QWebFrame::loadStarted
    {54, 466, 173},	// QWebFrame::metaData
    {54, 467, 150},	// QWebFrame::metaObject
    {54, 524, 157},	// QWebFrame::page
    {54, 527, 217},	// QWebFrame::pageChanged
    {54, 534, 175},	// QWebFrame::parentFrame
    {54, 539, 197},	// QWebFrame::pos
    {54, 550, 207},	// QWebFrame::print#
    {54, 553, 209},	// QWebFrame::provisionalLoad
    {54, 555, 156},	// QWebFrame::qt_metacall$$?
    {54, 557, 151},	// QWebFrame::qt_metacast$
    {54, 574, 188},	// QWebFrame::render#
    {54, 575, 189},	// QWebFrame::render##
    {54, 576, 225},	// QWebFrame::render#$
    {54, 577, 190},	// QWebFrame::render#$#
    {54, 579, 166},	// QWebFrame::renderTreeDump
    {54, 585, 170},	// QWebFrame::requestedUrl
    {54, 600, 184},	// QWebFrame::scroll$$
    {54, 602, 183},	// QWebFrame::scrollBarGeometry$
    {54, 604, 182},	// QWebFrame::scrollBarMaximum$
    {54, 606, 181},	// QWebFrame::scrollBarMinimum$
    {54, 608, 177},	// QWebFrame::scrollBarPolicy$
    {54, 610, 180},	// QWebFrame::scrollBarValue$
    {54, 611, 185},	// QWebFrame::scrollPosition
    {54, 615, 187},	// QWebFrame::scrollToAnchor$
    {54, 616, 205},	// QWebFrame::securityOrigin
    {54, 631, 223},	// QWebFrame::setContent#
    {54, 632, 224},	// QWebFrame::setContent#$
    {54, 633, 161},	// QWebFrame::setContent#$#
    {54, 660, 196},	// QWebFrame::setFocus
    {54, 670, 222},	// QWebFrame::setHtml$
    {54, 671, 160},	// QWebFrame::setHtml$#
    {54, 720, 178},	// QWebFrame::setScrollBarPolicy$$
    {54, 722, 179},	// QWebFrame::setScrollBarValue$$
    {54, 724, 186},	// QWebFrame::setScrollPosition#
    {54, 730, 191},	// QWebFrame::setTextSizeMultiplier$
    {54, 732, 168},	// QWebFrame::setUrl#
    {54, 745, 194},	// QWebFrame::setZoomFactor$
    {54, 752, 226},	// QWebFrame::staticMetaObject
    {54, 774, 192},	// QWebFrame::textSizeMultiplier
    {54, 776, 167},	// QWebFrame::title
    {54, 778, 210},	// QWebFrame::titleChanged$
    {54, 779, 164},	// QWebFrame::toHtml
    {54, 783, 165},	// QWebFrame::toPlainText
    {54, 790, 218},	// QWebFrame::tr$
    {54, 791, 152},	// QWebFrame::tr$$
    {54, 792, 154},	// QWebFrame::tr$$$
    {54, 794, 219},	// QWebFrame::trUtf8$
    {54, 795, 153},	// QWebFrame::trUtf8$$
    {54, 796, 155},	// QWebFrame::trUtf8$$$
    {54, 808, 169},	// QWebFrame::url
    {54, 810, 211},	// QWebFrame::urlChanged#
    {54, 828, 193},	// QWebFrame::zoomFactor
    {55, 229, 237},	// QWebHistory::back
    {55, 230, 240},	// QWebHistory::backItem
    {55, 232, 233},	// QWebHistory::backItems$
    {55, 237, 235},	// QWebHistory::canGoBack
    {55, 238, 236},	// QWebHistory::canGoForward
    {55, 246, 231},	// QWebHistory::clear
    {55, 266, 245},	// QWebHistory::count
    {55, 275, 241},	// QWebHistory::currentItem
    {55, 276, 244},	// QWebHistory::currentItemIndex
    {55, 360, 238},	// QWebHistory::forward
    {55, 361, 242},	// QWebHistory::forwardItem
    {55, 363, 234},	// QWebHistory::forwardItems$
    {55, 376, 239},	// QWebHistory::goToItem#
    {55, 415, 243},	// QWebHistory::itemAt$
    {55, 416, 232},	// QWebHistory::items
    {55, 461, 246},	// QWebHistory::maximumItemCount
    {55, 681, 247},	// QWebHistory::setMaximumItemCount$
    {56, 128, 262},	// QWebHistoryInterface::QWebHistoryInterface
    {56, 129, 255},	// QWebHistoryInterface::QWebHistoryInterface#
    {56, 201, 259},	// QWebHistoryInterface::addHistoryEntry$
    {56, 283, 257},	// QWebHistoryInterface::defaultInterface
    {56, 392, 258},	// QWebHistoryInterface::historyContains$
    {56, 467, 248},	// QWebHistoryInterface::metaObject
    {56, 555, 254},	// QWebHistoryInterface::qt_metacall$$?
    {56, 557, 249},	// QWebHistoryInterface::qt_metacast$
    {56, 641, 256},	// QWebHistoryInterface::setDefaultInterface#
    {56, 752, 263},	// QWebHistoryInterface::staticMetaObject
    {56, 790, 260},	// QWebHistoryInterface::tr$
    {56, 791, 250},	// QWebHistoryInterface::tr$$
    {56, 792, 252},	// QWebHistoryInterface::tr$$$
    {56, 794, 261},	// QWebHistoryInterface::trUtf8$
    {56, 795, 251},	// QWebHistoryInterface::trUtf8$$
    {56, 796, 253},	// QWebHistoryInterface::trUtf8$$$
    {56, 840, 264},	// QWebHistoryInterface::~QWebHistoryInterface
    {57, 131, 265},	// QWebHistoryItem::QWebHistoryItem#
    {57, 396, 271},	// QWebHistoryItem::icon
    {57, 413, 274},	// QWebHistoryItem::isValid
    {57, 436, 270},	// QWebHistoryItem::lastVisited
    {57, 513, 266},	// QWebHistoryItem::operator=#
    {57, 523, 267},	// QWebHistoryItem::originalUrl
    {57, 734, 273},	// QWebHistoryItem::setUserData#
    {57, 776, 269},	// QWebHistoryItem::title
    {57, 808, 268},	// QWebHistoryItem::url
    {57, 813, 272},	// QWebHistoryItem::userData
    {57, 841, 275},	// QWebHistoryItem::~QWebHistoryItem
    {58, 132, 276},	// QWebHitTestResult::QWebHitTestResult
    {58, 133, 277},	// QWebHitTestResult::QWebHitTestResult#
    {58, 208, 289},	// QWebHitTestResult::alternateText
    {58, 235, 281},	// QWebHitTestResult::boundingRect
    {58, 303, 294},	// QWebHitTestResult::element
    {58, 313, 282},	// QWebHitTestResult::enclosingBlockElement
    {58, 365, 295},	// QWebHitTestResult::frame
    {58, 401, 290},	// QWebHitTestResult::imageUrl
    {58, 408, 292},	// QWebHitTestResult::isContentEditable
    {58, 409, 293},	// QWebHitTestResult::isContentSelected
    {58, 411, 279},	// QWebHitTestResult::isNull
    {58, 441, 288},	// QWebHitTestResult::linkElement
    {58, 444, 287},	// QWebHitTestResult::linkTargetFrame
    {58, 445, 284},	// QWebHitTestResult::linkText
    {58, 446, 286},	// QWebHitTestResult::linkTitle
    {58, 447, 285},	// QWebHitTestResult::linkUrl
    {58, 513, 278},	// QWebHitTestResult::operator=#
    {58, 535, 291},	// QWebHitTestResult::pixmap
    {58, 539, 280},	// QWebHitTestResult::pos
    {58, 776, 283},	// QWebHitTestResult::title
    {58, 842, 296},	// QWebHitTestResult::~QWebHitTestResult
    {59, 134, 315},	// QWebInspector::QWebInspector
    {59, 135, 304},	// QWebInspector::QWebInspector#
    {59, 251, 312},	// QWebInspector::closeEvent#
    {59, 322, 308},	// QWebInspector::event#
    {59, 389, 311},	// QWebInspector::hideEvent#
    {59, 467, 297},	// QWebInspector::metaObject
    {59, 524, 306},	// QWebInspector::page
    {59, 555, 303},	// QWebInspector::qt_metacall$$?
    {59, 557, 298},	// QWebInspector::qt_metacast$
    {59, 593, 309},	// QWebInspector::resizeEvent#
    {59, 703, 305},	// QWebInspector::setPage#
    {59, 749, 310},	// QWebInspector::showEvent#
    {59, 751, 307},	// QWebInspector::sizeHint
    {59, 752, 316},	// QWebInspector::staticMetaObject
    {59, 790, 313},	// QWebInspector::tr$
    {59, 791, 299},	// QWebInspector::tr$$
    {59, 792, 301},	// QWebInspector::tr$$$
    {59, 794, 314},	// QWebInspector::trUtf8$
    {59, 795, 300},	// QWebInspector::trUtf8$$
    {59, 796, 302},	// QWebInspector::trUtf8$$$
    {59, 843, 317},	// QWebInspector::~QWebInspector
    {60, 2, 488},	// QWebPage::AlignCenter
    {60, 3, 489},	// QWebPage::AlignJustified
    {60, 4, 490},	// QWebPage::AlignLeft
    {60, 5, 491},	// QWebPage::AlignRight
    {60, 8, 433},	// QWebPage::Back
    {60, 10, 509},	// QWebPage::ChooseMultipleFilesExtension
    {60, 17, 438},	// QWebPage::Copy
    {60, 18, 432},	// QWebPage::CopyImageToClipboard
    {60, 19, 493},	// QWebPage::CopyImageUrlToClipboard
    {60, 20, 429},	// QWebPage::CopyLinkToClipboard
    {60, 22, 437},	// QWebPage::Cut
    {60, 26, 501},	// QWebPage::DelegateAllLinks
    {60, 27, 500},	// QWebPage::DelegateExternalLinks
    {60, 29, 467},	// QWebPage::DeleteEndOfWord
    {60, 30, 466},	// QWebPage::DeleteStartOfWord
    {60, 33, 499},	// QWebPage::DontDelegateLinks
    {60, 34, 431},	// QWebPage::DownloadImageToDisk
    {60, 35, 428},	// QWebPage::DownloadLinkToDisk
    {60, 38, 510},	// QWebPage::ErrorPageExtension
    {60, 48, 495},	// QWebPage::FindBackward
    {60, 49, 496},	// QWebPage::FindCaseSensitively
    {60, 50, 497},	// QWebPage::FindWrapsAroundDocument
    {60, 52, 434},	// QWebPage::Forward
    {60, 54, 508},	// QWebPage::Geolocation
    {60, 55, 498},	// QWebPage::HighlightAllOccurrences
    {60, 56, 512},	// QWebPage::Http
    {60, 59, 486},	// QWebPage::Indent
    {60, 62, 476},	// QWebPage::InsertLineSeparator
    {60, 63, 485},	// QWebPage::InsertOrderedList
    {60, 64, 475},	// QWebPage::InsertParagraphSeparator
    {60, 65, 484},	// QWebPage::InsertUnorderedList
    {60, 66, 474},	// QWebPage::InspectElement
    {60, 83, 451},	// QWebPage::MoveToEndOfBlock
    {60, 84, 453},	// QWebPage::MoveToEndOfDocument
    {60, 85, 449},	// QWebPage::MoveToEndOfLine
    {60, 86, 442},	// QWebPage::MoveToNextChar
    {60, 87, 446},	// QWebPage::MoveToNextLine
    {60, 88, 444},	// QWebPage::MoveToNextWord
    {60, 89, 443},	// QWebPage::MoveToPreviousChar
    {60, 90, 447},	// QWebPage::MoveToPreviousLine
    {60, 91, 445},	// QWebPage::MoveToPreviousWord
    {60, 92, 450},	// QWebPage::MoveToStartOfBlock
    {60, 93, 452},	// QWebPage::MoveToStartOfDocument
    {60, 94, 448},	// QWebPage::MoveToStartOfLine
    {60, 95, 420},	// QWebPage::NavigationTypeBackOrForward
    {60, 96, 422},	// QWebPage::NavigationTypeFormResubmitted
    {60, 97, 419},	// QWebPage::NavigationTypeFormSubmitted
    {60, 98, 418},	// QWebPage::NavigationTypeLinkClicked
    {60, 99, 423},	// QWebPage::NavigationTypeOther
    {60, 100, 421},	// QWebPage::NavigationTypeReload
    {60, 101, 424},	// QWebPage::NoWebAction
    {60, 102, 507},	// QWebPage::Notifications
    {60, 105, 427},	// QWebPage::OpenFrameInNewWindow
    {60, 106, 430},	// QWebPage::OpenImageInNewWindow
    {60, 107, 425},	// QWebPage::OpenLink
    {60, 108, 426},	// QWebPage::OpenLinkInNewWindow
    {60, 109, 487},	// QWebPage::Outdent
    {60, 111, 439},	// QWebPage::Paste
    {60, 112, 479},	// QWebPage::PasteAndMatchStyle
    {60, 113, 506},	// QWebPage::PermissionDeniedByUser
    {60, 114, 505},	// QWebPage::PermissionGrantedByUser
    {60, 115, 504},	// QWebPage::PermissionUnknown
    {60, 136, 412},	// QWebPage::QWebPage
    {60, 137, 325},	// QWebPage::QWebPage#
    {60, 144, 511},	// QWebPage::QtNetwork
    {60, 145, 441},	// QWebPage::Redo
    {60, 146, 436},	// QWebPage::Reload
    {60, 147, 478},	// QWebPage::ReloadAndBypassCache
    {60, 148, 480},	// QWebPage::RemoveFormat
    {60, 153, 477},	// QWebPage::SelectAll
    {60, 154, 463},	// QWebPage::SelectEndOfBlock
    {60, 155, 465},	// QWebPage::SelectEndOfDocument
    {60, 156, 461},	// QWebPage::SelectEndOfLine
    {60, 157, 454},	// QWebPage::SelectNextChar
    {60, 158, 458},	// QWebPage::SelectNextLine
    {60, 159, 456},	// QWebPage::SelectNextWord
    {60, 160, 455},	// QWebPage::SelectPreviousChar
    {60, 161, 459},	// QWebPage::SelectPreviousLine
    {60, 162, 457},	// QWebPage::SelectPreviousWord
    {60, 163, 462},	// QWebPage::SelectStartOfBlock
    {60, 164, 464},	// QWebPage::SelectStartOfDocument
    {60, 165, 460},	// QWebPage::SelectStartOfLine
    {60, 167, 468},	// QWebPage::SetTextDirectionDefault
    {60, 168, 469},	// QWebPage::SetTextDirectionLeftToRight
    {60, 169, 470},	// QWebPage::SetTextDirectionRightToLeft
    {60, 173, 435},	// QWebPage::Stop
    {60, 174, 492},	// QWebPage::StopScheduledPageRefresh
    {60, 177, 471},	// QWebPage::ToggleBold
    {60, 178, 472},	// QWebPage::ToggleItalic
    {60, 179, 481},	// QWebPage::ToggleStrikethrough
    {60, 180, 482},	// QWebPage::ToggleSubscript
    {60, 181, 483},	// QWebPage::ToggleSuperscript
    {60, 182, 473},	// QWebPage::ToggleUnderline
    {60, 183, 440},	// QWebPage::Undo
    {60, 186, 494},	// QWebPage::WebActionCount
    {60, 187, 502},	// QWebPage::WebBrowserWindow
    {60, 189, 513},	// QWebPage::WebKit
    {60, 190, 503},	// QWebPage::WebModalDialog
    {60, 194, 403},	// QWebPage::acceptNavigationRequest##$
    {60, 196, 344},	// QWebPage::action$
    {60, 218, 395},	// QWebPage::applicationCacheQuotaExceeded#$
    {60, 236, 340},	// QWebPage::bytesReceived
    {60, 244, 404},	// QWebPage::chooseFile#$
    {60, 260, 393},	// QWebPage::contentsChanged
    {60, 270, 402},	// QWebPage::createPlugin$#??
    {60, 271, 366},	// QWebPage::createStandardContextMenu
    {60, 273, 401},	// QWebPage::createWindow$
    {60, 274, 327},	// QWebPage::currentFrame
    {60, 280, 394},	// QWebPage::databaseQuotaExceeded#$
    {60, 294, 391},	// QWebPage::downloadRequested#
    {60, 322, 352},	// QWebPage::event#
    {60, 326, 415},	// QWebPage::extension$
    {60, 327, 416},	// QWebPage::extension$#
    {60, 328, 370},	// QWebPage::extension$##
    {60, 330, 400},	// QWebPage::featurePermissionRequestCanceled#$
    {60, 332, 399},	// QWebPage::featurePermissionRequested#$
    {60, 345, 414},	// QWebPage::findText$
    {60, 346, 355},	// QWebPage::findText$$
    {60, 352, 353},	// QWebPage::focusNextPrevChild$
    {60, 364, 357},	// QWebPage::forwardUnsupportedContent
    {60, 367, 328},	// QWebPage::frameAt#
    {60, 369, 380},	// QWebPage::frameCreated#
    {60, 373, 381},	// QWebPage::geometryChangeRequested#
    {60, 377, 372},	// QWebPage::handle
    {60, 386, 341},	// QWebPage::hasSelection
    {60, 390, 329},	// QWebPage::history
    {60, 407, 354},	// QWebPage::inputMethodQuery$
    {60, 408, 363},	// QWebPage::isContentEditable
    {60, 410, 333},	// QWebPage::isModified
    {60, 421, 405},	// QWebPage::javaScriptAlert#$
    {60, 423, 406},	// QWebPage::javaScriptConfirm#$
    {60, 425, 408},	// QWebPage::javaScriptConsoleMessage$$$
    {60, 427, 407},	// QWebPage::javaScriptPrompt#$$$
    {60, 439, 386},	// QWebPage::linkClicked#
    {60, 440, 359},	// QWebPage::linkDelegationPolicy
    {60, 443, 377},	// QWebPage::linkHovered$$$
    {60, 453, 376},	// QWebPage::loadFinished$
    {60, 455, 375},	// QWebPage::loadProgress$
    {60, 456, 374},	// QWebPage::loadStarted
    {60, 460, 326},	// QWebPage::mainFrame
    {60, 465, 389},	// QWebPage::menuBarVisibilityChangeRequested$
    {60, 467, 318},	// QWebPage::metaObject
    {60, 469, 392},	// QWebPage::microFocusChanged
    {60, 484, 336},	// QWebPage::networkAccessManager
    {60, 531, 361},	// QWebPage::palette
    {60, 536, 338},	// QWebPage::pluginFactory
    {60, 540, 349},	// QWebPage::preferredContentsSize
    {60, 552, 385},	// QWebPage::printRequested#
    {60, 555, 324},	// QWebPage::qt_metacall$$?
    {60, 557, 319},	// QWebPage::qt_metacast$
    {60, 581, 382},	// QWebPage::repaintRequested#
    {60, 595, 397},	// QWebPage::restoreFrameStateRequested#
    {60, 597, 396},	// QWebPage::saveFrameStateRequested##
    {60, 613, 383},	// QWebPage::scrollRequested$$#
    {60, 617, 343},	// QWebPage::selectedHtml
    {60, 618, 342},	// QWebPage::selectedText
    {60, 619, 379},	// QWebPage::selectionChanged
    {60, 621, 351},	// QWebPage::setActualVisibleContentRect#
    {60, 635, 362},	// QWebPage::setContentEditable$
    {60, 655, 367},	// QWebPage::setFeaturePermission#$$
    {60, 666, 356},	// QWebPage::setForwardUnsupportedContent$
    {60, 677, 358},	// QWebPage::setLinkDelegationPolicy$
    {60, 689, 335},	// QWebPage::setNetworkAccessManager#
    {60, 705, 360},	// QWebPage::setPalette#
    {60, 711, 337},	// QWebPage::setPluginFactory#
    {60, 713, 350},	// QWebPage::setPreferredContentsSize#
    {60, 738, 331},	// QWebPage::setView#
    {60, 740, 347},	// QWebPage::setViewportSize#
    {60, 746, 330},	// QWebPage::settings
    {60, 747, 373},	// QWebPage::shouldInterruptJavaScript
    {60, 752, 417},	// QWebPage::staticMetaObject
    {60, 754, 378},	// QWebPage::statusBarMessage$
    {60, 756, 388},	// QWebPage::statusBarVisibilityChangeRequested$
    {60, 762, 368},	// QWebPage::supportedContentTypes
    {60, 764, 369},	// QWebPage::supportsContentType$
    {60, 766, 371},	// QWebPage::supportsExtension$
    {60, 768, 364},	// QWebPage::swallowContextMenuEvent#
    {60, 787, 387},	// QWebPage::toolBarVisibilityChangeRequested$
    {60, 788, 339},	// QWebPage::totalBytes
    {60, 790, 410},	// QWebPage::tr$
    {60, 791, 320},	// QWebPage::tr$$
    {60, 792, 322},	// QWebPage::tr$$$
    {60, 794, 411},	// QWebPage::trUtf8$
    {60, 795, 321},	// QWebPage::trUtf8$$
    {60, 796, 323},	// QWebPage::trUtf8$$$
    {60, 798, 413},	// QWebPage::triggerAction$
    {60, 799, 345},	// QWebPage::triggerAction$$
    {60, 803, 334},	// QWebPage::undoStack
    {60, 805, 390},	// QWebPage::unsupportedContent#
    {60, 807, 365},	// QWebPage::updatePositionDependentActions#
    {60, 812, 409},	// QWebPage::userAgentForUrl#
    {60, 815, 332},	// QWebPage::view
    {60, 817, 348},	// QWebPage::viewportAttributesForSize#
    {60, 818, 398},	// QWebPage::viewportChangeRequested
    {60, 819, 346},	// QWebPage::viewportSize
    {60, 826, 384},	// QWebPage::windowCloseRequested
    {60, 844, 514},	// QWebPage::~QWebPage
    {61, 11, 515},	// QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption
    {61, 12, 516},	// QWebPage::ChooseMultipleFilesExtensionOption::ChooseMultipleFilesExtensionOption#
    {61, 534, 517},	// QWebPage::ChooseMultipleFilesExtensionOption::parentFrame
    {61, 707, 518},	// QWebPage::ChooseMultipleFilesExtensionOption::setParentFrame#
    {61, 728, 520},	// QWebPage::ChooseMultipleFilesExtensionOption::setSuggestedFileNames?
    {61, 761, 519},	// QWebPage::ChooseMultipleFilesExtensionOption::suggestedFileNames
    {61, 829, 521},	// QWebPage::ChooseMultipleFilesExtensionOption::~ChooseMultipleFilesExtensionOption
    {62, 13, 522},	// QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn
    {62, 14, 523},	// QWebPage::ChooseMultipleFilesExtensionReturn::ChooseMultipleFilesExtensionReturn#
    {62, 335, 524},	// QWebPage::ChooseMultipleFilesExtensionReturn::fileNames
    {62, 659, 525},	// QWebPage::ChooseMultipleFilesExtensionReturn::setFileNames?
    {62, 830, 526},	// QWebPage::ChooseMultipleFilesExtensionReturn::~ChooseMultipleFilesExtensionReturn
    {63, 39, 527},	// QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption
    {63, 40, 528},	// QWebPage::ErrorPageExtensionOption::ErrorPageExtensionOption#
    {63, 292, 533},	// QWebPage::ErrorPageExtensionOption::domain
    {63, 317, 535},	// QWebPage::ErrorPageExtensionOption::error
    {63, 318, 537},	// QWebPage::ErrorPageExtensionOption::errorString
    {63, 365, 531},	// QWebPage::ErrorPageExtensionOption::frame
    {63, 647, 534},	// QWebPage::ErrorPageExtensionOption::setDomain$
    {63, 651, 536},	// QWebPage::ErrorPageExtensionOption::setError$
    {63, 653, 538},	// QWebPage::ErrorPageExtensionOption::setErrorString$
    {63, 668, 532},	// QWebPage::ErrorPageExtensionOption::setFrame#
    {63, 732, 530},	// QWebPage::ErrorPageExtensionOption::setUrl#
    {63, 808, 529},	// QWebPage::ErrorPageExtensionOption::url
    {63, 831, 539},	// QWebPage::ErrorPageExtensionOption::~ErrorPageExtensionOption
    {64, 41, 540},	// QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn
    {64, 42, 541},	// QWebPage::ErrorPageExtensionReturn::ErrorPageExtensionReturn#
    {64, 233, 546},	// QWebPage::ErrorPageExtensionReturn::baseUrl
    {64, 258, 548},	// QWebPage::ErrorPageExtensionReturn::content
    {64, 259, 542},	// QWebPage::ErrorPageExtensionReturn::contentType
    {64, 314, 544},	// QWebPage::ErrorPageExtensionReturn::encoding
    {64, 629, 547},	// QWebPage::ErrorPageExtensionReturn::setBaseUrl#
    {64, 631, 549},	// QWebPage::ErrorPageExtensionReturn::setContent#
    {64, 637, 543},	// QWebPage::ErrorPageExtensionReturn::setContentType$
    {64, 649, 545},	// QWebPage::ErrorPageExtensionReturn::setEncoding$
    {64, 832, 550},	// QWebPage::ErrorPageExtensionReturn::~ErrorPageExtensionReturn
    {65, 43, 551},	// QWebPage::ExtensionOption::ExtensionOption
    {65, 44, 552},	// QWebPage::ExtensionOption::ExtensionOption#
    {65, 833, 553},	// QWebPage::ExtensionOption::~ExtensionOption
    {66, 45, 554},	// QWebPage::ExtensionReturn::ExtensionReturn
    {66, 46, 555},	// QWebPage::ExtensionReturn::ExtensionReturn#
    {66, 834, 556},	// QWebPage::ExtensionReturn::~ExtensionReturn
    {67, 184, 557},	// QWebPage::ViewportAttributes::ViewportAttributes
    {67, 185, 558},	// QWebPage::ViewportAttributes::ViewportAttributes#
    {67, 287, 563},	// QWebPage::ViewportAttributes::devicePixelRatio
    {67, 403, 560},	// QWebPage::ViewportAttributes::initialScaleFactor
    {67, 412, 564},	// QWebPage::ViewportAttributes::isUserScalable
    {67, 413, 565},	// QWebPage::ViewportAttributes::isValid
    {67, 463, 562},	// QWebPage::ViewportAttributes::maximumScaleFactor
    {67, 471, 561},	// QWebPage::ViewportAttributes::minimumScaleFactor
    {67, 513, 559},	// QWebPage::ViewportAttributes::operator=#
    {67, 750, 566},	// QWebPage::ViewportAttributes::size
    {67, 848, 567},	// QWebPage::ViewportAttributes::~ViewportAttributes
    {69, 138, 583},	// QWebPluginFactory::QWebPluginFactory
    {69, 139, 575},	// QWebPluginFactory::QWebPluginFactory#
    {69, 268, 578},	// QWebPluginFactory::create$#??
    {69, 326, 584},	// QWebPluginFactory::extension$
    {69, 327, 585},	// QWebPluginFactory::extension$#
    {69, 328, 579},	// QWebPluginFactory::extension$##
    {69, 467, 568},	// QWebPluginFactory::metaObject
    {69, 537, 576},	// QWebPluginFactory::plugins
    {69, 555, 574},	// QWebPluginFactory::qt_metacall$$?
    {69, 557, 569},	// QWebPluginFactory::qt_metacast$
    {69, 558, 577},	// QWebPluginFactory::refreshPlugins
    {69, 752, 586},	// QWebPluginFactory::staticMetaObject
    {69, 766, 580},	// QWebPluginFactory::supportsExtension$
    {69, 790, 581},	// QWebPluginFactory::tr$
    {69, 791, 570},	// QWebPluginFactory::tr$$
    {69, 792, 572},	// QWebPluginFactory::tr$$$
    {69, 794, 582},	// QWebPluginFactory::trUtf8$
    {69, 795, 571},	// QWebPluginFactory::trUtf8$$
    {69, 796, 573},	// QWebPluginFactory::trUtf8$$$
    {69, 845, 587},	// QWebPluginFactory::~QWebPluginFactory
    {70, 43, 588},	// QWebPluginFactory::ExtensionOption::ExtensionOption
    {70, 44, 589},	// QWebPluginFactory::ExtensionOption::ExtensionOption#
    {70, 833, 590},	// QWebPluginFactory::ExtensionOption::~ExtensionOption
    {71, 45, 591},	// QWebPluginFactory::ExtensionReturn::ExtensionReturn
    {71, 46, 592},	// QWebPluginFactory::ExtensionReturn::ExtensionReturn#
    {71, 834, 593},	// QWebPluginFactory::ExtensionReturn::~ExtensionReturn
    {72, 77, 596},	// QWebPluginFactory::MimeType::MimeType
    {72, 78, 597},	// QWebPluginFactory::MimeType::MimeType#
    {72, 285, 600},	// QWebPluginFactory::MimeType::description
    {72, 333, 602},	// QWebPluginFactory::MimeType::fileExtensions
    {72, 482, 598},	// QWebPluginFactory::MimeType::name
    {72, 491, 595},	// QWebPluginFactory::MimeType::operator!=#
    {72, 515, 594},	// QWebPluginFactory::MimeType::operator==#
    {72, 645, 601},	// QWebPluginFactory::MimeType::setDescription$
    {72, 657, 603},	// QWebPluginFactory::MimeType::setFileExtensions?
    {72, 687, 599},	// QWebPluginFactory::MimeType::setName$
    {72, 835, 604},	// QWebPluginFactory::MimeType::~MimeType
    {73, 116, 605},	// QWebPluginFactory::Plugin::Plugin
    {73, 117, 606},	// QWebPluginFactory::Plugin::Plugin#
    {73, 285, 609},	// QWebPluginFactory::Plugin::description
    {73, 470, 611},	// QWebPluginFactory::Plugin::mimeTypes
    {73, 482, 607},	// QWebPluginFactory::Plugin::name
    {73, 645, 610},	// QWebPluginFactory::Plugin::setDescription$
    {73, 685, 612},	// QWebPluginFactory::Plugin::setMimeTypes?
    {73, 687, 608},	// QWebPluginFactory::Plugin::setName$
    {73, 836, 613},	// QWebPluginFactory::Plugin::~Plugin
    {74, 141, 626},	// QWebSecurityOrigin::QWebSecurityOrigin#
    {74, 203, 615},	// QWebSecurityOrigin::addLocalScheme$
    {74, 207, 614},	// QWebSecurityOrigin::allOrigins
    {74, 278, 622},	// QWebSecurityOrigin::databaseQuota
    {74, 281, 621},	// QWebSecurityOrigin::databaseUsage
    {74, 282, 625},	// QWebSecurityOrigin::databases
    {74, 395, 619},	// QWebSecurityOrigin::host
    {74, 458, 617},	// QWebSecurityOrigin::localSchemes
    {74, 513, 627},	// QWebSecurityOrigin::operator=#
    {74, 538, 620},	// QWebSecurityOrigin::port
    {74, 572, 616},	// QWebSecurityOrigin::removeLocalScheme$
    {74, 598, 618},	// QWebSecurityOrigin::scheme
    {74, 623, 624},	// QWebSecurityOrigin::setApplicationCacheQuota$
    {74, 639, 623},	// QWebSecurityOrigin::setDatabaseQuota$
    {74, 846, 628},	// QWebSecurityOrigin::~QWebSecurityOrigin
    {75, 1, 690},	// QWebSettings::AcceleratedCompositingEnabled
    {75, 7, 672},	// QWebSettings::AutoLoadImages
    {75, 21, 670},	// QWebSettings::CursiveFont
    {75, 23, 710},	// QWebSettings::DefaultFixedFontSize
    {75, 24, 709},	// QWebSettings::DefaultFontSize
    {75, 25, 701},	// QWebSettings::DefaultFrameIconGraphic
    {75, 28, 703},	// QWebSettings::DeleteButtonGraphic
    {75, 31, 679},	// QWebSettings::DeveloperExtrasEnabled
    {75, 32, 688},	// QWebSettings::DnsPrefetchEnabled
    {75, 47, 671},	// QWebSettings::FantasyFont
    {75, 51, 667},	// QWebSettings::FixedFont
    {75, 53, 694},	// QWebSettings::FrameFlatteningEnabled
    {75, 57, 698},	// QWebSettings::HyperlinkAuditingEnabled
    {75, 61, 704},	// QWebSettings::InputSpeechButtonGraphic
    {75, 67, 674},	// QWebSettings::JavaEnabled
    {75, 68, 678},	// QWebSettings::JavascriptCanAccessClipboard
    {75, 69, 696},	// QWebSettings::JavascriptCanCloseWindows
    {75, 70, 677},	// QWebSettings::JavascriptCanOpenWindows
    {75, 71, 673},	// QWebSettings::JavascriptEnabled
    {75, 72, 680},	// QWebSettings::LinksIncludedInFocusChain
    {75, 73, 692},	// QWebSettings::LocalContentCanAccessFileUrls
    {75, 74, 687},	// QWebSettings::LocalContentCanAccessRemoteUrls
    {75, 75, 686},	// QWebSettings::LocalStorageDatabaseEnabled
    {75, 76, 685},	// QWebSettings::LocalStorageEnabled
    {75, 79, 707},	// QWebSettings::MinimumFontSize
    {75, 80, 708},	// QWebSettings::MinimumLogicalFontSize
    {75, 81, 699},	// QWebSettings::MissingImageGraphic
    {75, 82, 700},	// QWebSettings::MissingPluginGraphic
    {75, 103, 683},	// QWebSettings::OfflineStorageDatabaseEnabled
    {75, 104, 684},	// QWebSettings::OfflineWebApplicationCacheEnabled
    {75, 118, 675},	// QWebSettings::PluginsEnabled
    {75, 119, 682},	// QWebSettings::PrintElementBackgrounds
    {75, 120, 676},	// QWebSettings::PrivateBrowsingEnabled
    {75, 149, 669},	// QWebSettings::SansSerifFont
    {75, 151, 705},	// QWebSettings::SearchCancelButtonGraphic
    {75, 152, 706},	// QWebSettings::SearchCancelButtonPressedGraphic
    {75, 166, 668},	// QWebSettings::SerifFont
    {75, 170, 695},	// QWebSettings::SiteSpecificQuirksEnabled
    {75, 171, 691},	// QWebSettings::SpatialNavigationEnabled
    {75, 172, 666},	// QWebSettings::StandardFont
    {75, 175, 702},	// QWebSettings::TextAreaSizeGripCornerGraphic
    {75, 176, 693},	// QWebSettings::TiledBackingStoreEnabled
    {75, 188, 697},	// QWebSettings::WebGLEnabled
    {75, 191, 689},	// QWebSettings::XSSAuditingEnabled
    {75, 192, 681},	// QWebSettings::ZoomTextOnly
    {75, 247, 645},	// QWebSettings::clearIconDatabase
    {75, 248, 662},	// QWebSettings::clearMemoryCaches
    {75, 284, 642},	// QWebSettings::defaultTextEncoding
    {75, 304, 665},	// QWebSettings::enablePersistentStorage
    {75, 305, 663},	// QWebSettings::enablePersistentStorage$
    {75, 357, 631},	// QWebSettings::fontFamily$
    {75, 359, 634},	// QWebSettings::fontSize$
    {75, 374, 629},	// QWebSettings::globalSettings
    {75, 377, 664},	// QWebSettings::handle
    {75, 398, 644},	// QWebSettings::iconDatabasePath
    {75, 400, 646},	// QWebSettings::iconForUrl#
    {75, 459, 661},	// QWebSettings::localStoragePath
    {75, 462, 650},	// QWebSettings::maximumPagesInCache
    {75, 486, 655},	// QWebSettings::offlineStorageDefaultQuota
    {75, 487, 653},	// QWebSettings::offlineStoragePath
    {75, 488, 657},	// QWebSettings::offlineWebApplicationCachePath
    {75, 489, 659},	// QWebSettings::offlineWebApplicationCacheQuota
    {75, 587, 638},	// QWebSettings::resetAttribute$
    {75, 589, 632},	// QWebSettings::resetFontFamily$
    {75, 591, 635},	// QWebSettings::resetFontSize$
    {75, 625, 636},	// QWebSettings::setAttribute$$
    {75, 643, 641},	// QWebSettings::setDefaultTextEncoding$
    {75, 662, 630},	// QWebSettings::setFontFamily$$
    {75, 664, 633},	// QWebSettings::setFontSize$$
    {75, 673, 643},	// QWebSettings::setIconDatabasePath$
    {75, 679, 660},	// QWebSettings::setLocalStoragePath$
    {75, 683, 649},	// QWebSettings::setMaximumPagesInCache$
    {75, 691, 651},	// QWebSettings::setObjectCacheCapacities$$$
    {75, 693, 654},	// QWebSettings::setOfflineStorageDefaultQuota$
    {75, 695, 652},	// QWebSettings::setOfflineStoragePath$
    {75, 697, 656},	// QWebSettings::setOfflineWebApplicationCachePath$
    {75, 699, 658},	// QWebSettings::setOfflineWebApplicationCacheQuota$
    {75, 736, 639},	// QWebSettings::setUserStyleSheetUrl#
    {75, 743, 647},	// QWebSettings::setWebGraphic$#
    {75, 773, 637},	// QWebSettings::testAttribute$
    {75, 814, 640},	// QWebSettings::userStyleSheetUrl
    {75, 822, 648},	// QWebSettings::webGraphic$
    {77, 142, 784},	// QWebView::QWebView
    {77, 143, 718},	// QWebView::QWebView#
    {77, 229, 749},	// QWebView::back
    {77, 240, 765},	// QWebView::changeEvent#
    {77, 265, 770},	// QWebView::contextMenuEvent#
    {77, 273, 764},	// QWebView::createWindow$
    {77, 296, 774},	// QWebView::dragEnterEvent#
    {77, 298, 775},	// QWebView::dragLeaveEvent#
    {77, 300, 776},	// QWebView::dragMoveEvent#
    {77, 302, 777},	// QWebView::dropEvent#
    {77, 322, 747},	// QWebView::event#
    {77, 345, 792},	// QWebView::findText$
    {77, 346, 746},	// QWebView::findText$$
    {77, 350, 778},	// QWebView::focusInEvent#
    {77, 352, 781},	// QWebView::focusNextPrevChild$
    {77, 354, 779},	// QWebView::focusOutEvent#
    {77, 360, 750},	// QWebView::forward
    {77, 386, 731},	// QWebView::hasSelection
    {77, 390, 725},	// QWebView::history
    {77, 396, 730},	// QWebView::icon
    {77, 397, 760},	// QWebView::iconChanged
    {77, 405, 780},	// QWebView::inputMethodEvent#
    {77, 407, 737},	// QWebView::inputMethodQuery$
    {77, 410, 736},	// QWebView::isModified
    {77, 430, 772},	// QWebView::keyPressEvent#
    {77, 432, 773},	// QWebView::keyReleaseEvent#
    {77, 439, 758},	// QWebView::linkClicked#
    {77, 449, -10},	// QWebView::load#
    {77, 450, 786},	// QWebView::load#$
    {77, 451, 722},	// QWebView::load#$#
    {77, 453, 755},	// QWebView::loadFinished$
    {77, 455, 754},	// QWebView::loadProgress$
    {77, 456, 753},	// QWebView::loadStarted
    {77, 467, 711},	// QWebView::metaObject
    {77, 474, 768},	// QWebView::mouseDoubleClickEvent#
    {77, 476, 766},	// QWebView::mouseMoveEvent#
    {77, 478, 767},	// QWebView::mousePressEvent#
    {77, 480, 769},	// QWebView::mouseReleaseEvent#
    {77, 524, 719},	// QWebView::page
    {77, 526, 734},	// QWebView::pageAction$
    {77, 530, 763},	// QWebView::paintEvent#
    {77, 550, 752},	// QWebView::print#
    {77, 555, 717},	// QWebView::qt_metacall$$?
    {77, 557, 712},	// QWebView::qt_metacast$
    {77, 559, 751},	// QWebView::reload
    {77, 578, 743},	// QWebView::renderHints
    {77, 593, 762},	// QWebView::resizeEvent#
    {77, 617, 733},	// QWebView::selectedHtml
    {77, 618, 732},	// QWebView::selectedText
    {77, 619, 759},	// QWebView::selectionChanged
    {77, 631, 788},	// QWebView::setContent#
    {77, 632, 789},	// QWebView::setContent#$
    {77, 633, 724},	// QWebView::setContent#$#
    {77, 670, 787},	// QWebView::setHtml$
    {77, 671, 723},	// QWebView::setHtml$#
    {77, 703, 720},	// QWebView::setPage#
    {77, 715, 791},	// QWebView::setRenderHint$
    {77, 716, 745},	// QWebView::setRenderHint$$
    {77, 718, 744},	// QWebView::setRenderHints$
    {77, 730, 741},	// QWebView::setTextSizeMultiplier$
    {77, 732, 728},	// QWebView::setUrl#
    {77, 745, 740},	// QWebView::setZoomFactor$
    {77, 746, 726},	// QWebView::settings
    {77, 751, 738},	// QWebView::sizeHint
    {77, 752, 793},	// QWebView::staticMetaObject
    {77, 754, 757},	// QWebView::statusBarMessage$
    {77, 757, 748},	// QWebView::stop
    {77, 774, 742},	// QWebView::textSizeMultiplier
    {77, 776, 727},	// QWebView::title
    {77, 778, 756},	// QWebView::titleChanged$
    {77, 790, 782},	// QWebView::tr$
    {77, 791, 713},	// QWebView::tr$$
    {77, 792, 715},	// QWebView::tr$$$
    {77, 794, 783},	// QWebView::trUtf8$
    {77, 795, 714},	// QWebView::trUtf8$$
    {77, 796, 716},	// QWebView::trUtf8$$$
    {77, 801, 790},	// QWebView::triggerPageAction$
    {77, 802, 735},	// QWebView::triggerPageAction$$
    {77, 808, 729},	// QWebView::url
    {77, 810, 761},	// QWebView::urlChanged#
    {77, 824, 771},	// QWebView::wheelEvent#
    {77, 828, 739},	// QWebView::zoomFactor
    {77, 847, 794},	// QWebView::~QWebView
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtgui_Smoke();

static bool initialized = false;
Smoke *qtwebkit_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_qtwebkit_Smoke() {
    init_qtcore_Smoke();
    init_qtgui_Smoke();
    if (initialized) return;
    qtwebkit_Smoke = new Smoke(
        "qtwebkit",
        __smokeqtwebkit::classes, 79,
        __smokeqtwebkit::methods, 835,
        __smokeqtwebkit::methodMaps, 784,
        __smokeqtwebkit::methodNames, 850,
        __smokeqtwebkit::types, 273,
        __smokeqtwebkit::inheritanceList,
        __smokeqtwebkit::argumentList,
        __smokeqtwebkit::ambiguousMethodList,
        __smokeqtwebkit::cast );
    initialized = true;
}

void delete_qtwebkit_Smoke() { delete qtwebkit_Smoke; }

}
