/*
 * tkIntDecls.h --
 *
 *	This file contains the declarations for all unsupported
 *	functions that are exported by the Tk library.  These
 *	interfaces are not guaranteed to remain the same between
 *	versions.  Use at your own risk.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#ifndef _TKINTDECLS
#define _TKINTDECLS

#ifdef BUILD_tk
#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLEXPORT
#endif

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tkInt.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Exported function declarations:
 */

#ifndef TkAllocWindow_TCL_DECLARED
#define TkAllocWindow_TCL_DECLARED
/* 0 */
EXTERN TkWindow *	TkAllocWindow(TkDisplay *dispPtr, int screenNum,
				TkWindow *parentPtr);
#endif
#ifndef TkBezierPoints_TCL_DECLARED
#define TkBezierPoints_TCL_DECLARED
/* 1 */
EXTERN void		TkBezierPoints(double control[], int numSteps,
				double *coordPtr);
#endif
#ifndef TkBezierScreenPoints_TCL_DECLARED
#define TkBezierScreenPoints_TCL_DECLARED
/* 2 */
EXTERN void		TkBezierScreenPoints(Tk_Canvas canvas,
				double control[], int numSteps,
				XPoint *xPointPtr);
#endif
#ifndef TkBindDeadWindow_TCL_DECLARED
#define TkBindDeadWindow_TCL_DECLARED
/* 3 */
EXTERN void		TkBindDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkBindEventProc_TCL_DECLARED
#define TkBindEventProc_TCL_DECLARED
/* 4 */
EXTERN void		TkBindEventProc(TkWindow *winPtr, XEvent *eventPtr);
#endif
#ifndef TkBindFree_TCL_DECLARED
#define TkBindFree_TCL_DECLARED
/* 5 */
EXTERN void		TkBindFree(TkMainInfo *mainPtr);
#endif
#ifndef TkBindInit_TCL_DECLARED
#define TkBindInit_TCL_DECLARED
/* 6 */
EXTERN void		TkBindInit(TkMainInfo *mainPtr);
#endif
#ifndef TkChangeEventWindow_TCL_DECLARED
#define TkChangeEventWindow_TCL_DECLARED
/* 7 */
EXTERN void		TkChangeEventWindow(XEvent *eventPtr,
				TkWindow *winPtr);
#endif
#ifndef TkClipInit_TCL_DECLARED
#define TkClipInit_TCL_DECLARED
/* 8 */
EXTERN int		TkClipInit(Tcl_Interp *interp, TkDisplay *dispPtr);
#endif
#ifndef TkComputeAnchor_TCL_DECLARED
#define TkComputeAnchor_TCL_DECLARED
/* 9 */
EXTERN void		TkComputeAnchor(Tk_Anchor anchor, Tk_Window tkwin,
				int padX, int padY, int innerWidth,
				int innerHeight, int *xPtr, int *yPtr);
#endif
#ifndef TkCopyAndGlobalEval_TCL_DECLARED
#define TkCopyAndGlobalEval_TCL_DECLARED
/* 10 */
EXTERN int		TkCopyAndGlobalEval(Tcl_Interp *interp, char *script);
#endif
#ifndef TkCreateBindingProcedure_TCL_DECLARED
#define TkCreateBindingProcedure_TCL_DECLARED
/* 11 */
EXTERN unsigned long	TkCreateBindingProcedure(Tcl_Interp *interp,
				Tk_BindingTable bindingTable,
				ClientData object, CONST char *eventString,
				TkBindEvalProc *evalProc,
				TkBindFreeProc *freeProc,
				ClientData clientData);
#endif
#ifndef TkCreateCursorFromData_TCL_DECLARED
#define TkCreateCursorFromData_TCL_DECLARED
/* 12 */
EXTERN TkCursor *	TkCreateCursorFromData(Tk_Window tkwin,
				CONST char *source, CONST char *mask,
				int width, int height, int xHot, int yHot,
				XColor fg, XColor bg);
#endif
#ifndef TkCreateFrame_TCL_DECLARED
#define TkCreateFrame_TCL_DECLARED
/* 13 */
EXTERN int		TkCreateFrame(ClientData clientData,
				Tcl_Interp *interp, int argc, char **argv,
				int toplevel, char *appName);
#endif
#ifndef TkCreateMainWindow_TCL_DECLARED
#define TkCreateMainWindow_TCL_DECLARED
/* 14 */
EXTERN Tk_Window	TkCreateMainWindow(Tcl_Interp *interp,
				CONST char *screenName, char *baseName);
#endif
#ifndef TkCurrentTime_TCL_DECLARED
#define TkCurrentTime_TCL_DECLARED
/* 15 */
EXTERN Time		TkCurrentTime(TkDisplay *dispPtr);
#endif
#ifndef TkDeleteAllImages_TCL_DECLARED
#define TkDeleteAllImages_TCL_DECLARED
/* 16 */
EXTERN void		TkDeleteAllImages(TkMainInfo *mainPtr);
#endif
#ifndef TkDoConfigureNotify_TCL_DECLARED
#define TkDoConfigureNotify_TCL_DECLARED
/* 17 */
EXTERN void		TkDoConfigureNotify(TkWindow *winPtr);
#endif
#ifndef TkDrawInsetFocusHighlight_TCL_DECLARED
#define TkDrawInsetFocusHighlight_TCL_DECLARED
/* 18 */
EXTERN void		TkDrawInsetFocusHighlight(Tk_Window tkwin, GC gc,
				int width, Drawable drawable, int padding);
#endif
#ifndef TkEventDeadWindow_TCL_DECLARED
#define TkEventDeadWindow_TCL_DECLARED
/* 19 */
EXTERN void		TkEventDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkFillPolygon_TCL_DECLARED
#define TkFillPolygon_TCL_DECLARED
/* 20 */
EXTERN void		TkFillPolygon(Tk_Canvas canvas, double *coordPtr,
				int numPoints, Display *display,
				Drawable drawable, GC gc, GC outlineGC);
#endif
#ifndef TkFindStateNum_TCL_DECLARED
#define TkFindStateNum_TCL_DECLARED
/* 21 */
EXTERN int		TkFindStateNum(Tcl_Interp *interp,
				CONST char *option, CONST TkStateMap *mapPtr,
				CONST char *strKey);
#endif
#ifndef TkFindStateString_TCL_DECLARED
#define TkFindStateString_TCL_DECLARED
/* 22 */
EXTERN char *		TkFindStateString(CONST TkStateMap *mapPtr,
				int numKey);
#endif
#ifndef TkFocusDeadWindow_TCL_DECLARED
#define TkFocusDeadWindow_TCL_DECLARED
/* 23 */
EXTERN void		TkFocusDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkFocusFilterEvent_TCL_DECLARED
#define TkFocusFilterEvent_TCL_DECLARED
/* 24 */
EXTERN int		TkFocusFilterEvent(TkWindow *winPtr,
				XEvent *eventPtr);
#endif
#ifndef TkFocusKeyEvent_TCL_DECLARED
#define TkFocusKeyEvent_TCL_DECLARED
/* 25 */
EXTERN TkWindow *	TkFocusKeyEvent(TkWindow *winPtr, XEvent *eventPtr);
#endif
#ifndef TkFontPkgInit_TCL_DECLARED
#define TkFontPkgInit_TCL_DECLARED
/* 26 */
EXTERN void		TkFontPkgInit(TkMainInfo *mainPtr);
#endif
#ifndef TkFontPkgFree_TCL_DECLARED
#define TkFontPkgFree_TCL_DECLARED
/* 27 */
EXTERN void		TkFontPkgFree(TkMainInfo *mainPtr);
#endif
#ifndef TkFreeBindingTags_TCL_DECLARED
#define TkFreeBindingTags_TCL_DECLARED
/* 28 */
EXTERN void		TkFreeBindingTags(TkWindow *winPtr);
#endif
#ifndef TkpFreeCursor_TCL_DECLARED
#define TkpFreeCursor_TCL_DECLARED
/* 29 */
EXTERN void		TkpFreeCursor(TkCursor *cursorPtr);
#endif
#ifndef TkGetBitmapData_TCL_DECLARED
#define TkGetBitmapData_TCL_DECLARED
/* 30 */
EXTERN char *		TkGetBitmapData(Tcl_Interp *interp, char *string,
				char *fileName, int *widthPtr,
				int *heightPtr, int *hotXPtr, int *hotYPtr);
#endif
#ifndef TkGetButtPoints_TCL_DECLARED
#define TkGetButtPoints_TCL_DECLARED
/* 31 */
EXTERN void		TkGetButtPoints(double p1[], double p2[],
				double width, int project, double m1[],
				double m2[]);
#endif
#ifndef TkGetCursorByName_TCL_DECLARED
#define TkGetCursorByName_TCL_DECLARED
/* 32 */
EXTERN TkCursor *	TkGetCursorByName(Tcl_Interp *interp,
				Tk_Window tkwin, Tk_Uid string);
#endif
#ifndef TkGetDefaultScreenName_TCL_DECLARED
#define TkGetDefaultScreenName_TCL_DECLARED
/* 33 */
EXTERN CONST84_RETURN char * TkGetDefaultScreenName(Tcl_Interp *interp,
				CONST char *screenName);
#endif
#ifndef TkGetDisplay_TCL_DECLARED
#define TkGetDisplay_TCL_DECLARED
/* 34 */
EXTERN TkDisplay *	TkGetDisplay(Display *display);
#endif
#ifndef TkGetDisplayOf_TCL_DECLARED
#define TkGetDisplayOf_TCL_DECLARED
/* 35 */
EXTERN int		TkGetDisplayOf(Tcl_Interp *interp, int objc,
				Tcl_Obj *CONST objv[], Tk_Window *tkwinPtr);
#endif
#ifndef TkGetFocusWin_TCL_DECLARED
#define TkGetFocusWin_TCL_DECLARED
/* 36 */
EXTERN TkWindow *	TkGetFocusWin(TkWindow *winPtr);
#endif
#ifndef TkGetInterpNames_TCL_DECLARED
#define TkGetInterpNames_TCL_DECLARED
/* 37 */
EXTERN int		TkGetInterpNames(Tcl_Interp *interp, Tk_Window tkwin);
#endif
#ifndef TkGetMiterPoints_TCL_DECLARED
#define TkGetMiterPoints_TCL_DECLARED
/* 38 */
EXTERN int		TkGetMiterPoints(double p1[], double p2[],
				double p3[], double width, double m1[],
				double m2[]);
#endif
#ifndef TkGetPointerCoords_TCL_DECLARED
#define TkGetPointerCoords_TCL_DECLARED
/* 39 */
EXTERN void		TkGetPointerCoords(Tk_Window tkwin, int *xPtr,
				int *yPtr);
#endif
#ifndef TkGetServerInfo_TCL_DECLARED
#define TkGetServerInfo_TCL_DECLARED
/* 40 */
EXTERN void		TkGetServerInfo(Tcl_Interp *interp, Tk_Window tkwin);
#endif
#ifndef TkGrabDeadWindow_TCL_DECLARED
#define TkGrabDeadWindow_TCL_DECLARED
/* 41 */
EXTERN void		TkGrabDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkGrabState_TCL_DECLARED
#define TkGrabState_TCL_DECLARED
/* 42 */
EXTERN int		TkGrabState(TkWindow *winPtr);
#endif
#ifndef TkIncludePoint_TCL_DECLARED
#define TkIncludePoint_TCL_DECLARED
/* 43 */
EXTERN void		TkIncludePoint(Tk_Item *itemPtr, double *pointPtr);
#endif
#ifndef TkInOutEvents_TCL_DECLARED
#define TkInOutEvents_TCL_DECLARED
/* 44 */
EXTERN void		TkInOutEvents(XEvent *eventPtr, TkWindow *sourcePtr,
				TkWindow *destPtr, int leaveType,
				int enterType, Tcl_QueuePosition position);
#endif
#ifndef TkInstallFrameMenu_TCL_DECLARED
#define TkInstallFrameMenu_TCL_DECLARED
/* 45 */
EXTERN void		TkInstallFrameMenu(Tk_Window tkwin);
#endif
#ifndef TkKeysymToString_TCL_DECLARED
#define TkKeysymToString_TCL_DECLARED
/* 46 */
EXTERN char *		TkKeysymToString(KeySym keysym);
#endif
#ifndef TkLineToArea_TCL_DECLARED
#define TkLineToArea_TCL_DECLARED
/* 47 */
EXTERN int		TkLineToArea(double end1Ptr[], double end2Ptr[],
				double rectPtr[]);
#endif
#ifndef TkLineToPoint_TCL_DECLARED
#define TkLineToPoint_TCL_DECLARED
/* 48 */
EXTERN double		TkLineToPoint(double end1Ptr[], double end2Ptr[],
				double pointPtr[]);
#endif
#ifndef TkMakeBezierCurve_TCL_DECLARED
#define TkMakeBezierCurve_TCL_DECLARED
/* 49 */
EXTERN int		TkMakeBezierCurve(Tk_Canvas canvas, double *pointPtr,
				int numPoints, int numSteps,
				XPoint xPoints[], double dblPoints[]);
#endif
#ifndef TkMakeBezierPostscript_TCL_DECLARED
#define TkMakeBezierPostscript_TCL_DECLARED
/* 50 */
EXTERN void		TkMakeBezierPostscript(Tcl_Interp *interp,
				Tk_Canvas canvas, double *pointPtr,
				int numPoints);
#endif
#ifndef TkOptionClassChanged_TCL_DECLARED
#define TkOptionClassChanged_TCL_DECLARED
/* 51 */
EXTERN void		TkOptionClassChanged(TkWindow *winPtr);
#endif
#ifndef TkOptionDeadWindow_TCL_DECLARED
#define TkOptionDeadWindow_TCL_DECLARED
/* 52 */
EXTERN void		TkOptionDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkOvalToArea_TCL_DECLARED
#define TkOvalToArea_TCL_DECLARED
/* 53 */
EXTERN int		TkOvalToArea(double *ovalPtr, double *rectPtr);
#endif
#ifndef TkOvalToPoint_TCL_DECLARED
#define TkOvalToPoint_TCL_DECLARED
/* 54 */
EXTERN double		TkOvalToPoint(double ovalPtr[], double width,
				int filled, double pointPtr[]);
#endif
#ifndef TkpChangeFocus_TCL_DECLARED
#define TkpChangeFocus_TCL_DECLARED
/* 55 */
EXTERN int		TkpChangeFocus(TkWindow *winPtr, int force);
#endif
#ifndef TkpCloseDisplay_TCL_DECLARED
#define TkpCloseDisplay_TCL_DECLARED
/* 56 */
EXTERN void		TkpCloseDisplay(TkDisplay *dispPtr);
#endif
#ifndef TkpClaimFocus_TCL_DECLARED
#define TkpClaimFocus_TCL_DECLARED
/* 57 */
EXTERN void		TkpClaimFocus(TkWindow *topLevelPtr, int force);
#endif
#ifndef TkpDisplayWarning_TCL_DECLARED
#define TkpDisplayWarning_TCL_DECLARED
/* 58 */
EXTERN void		TkpDisplayWarning(CONST char *msg, CONST char *title);
#endif
#ifndef TkpGetAppName_TCL_DECLARED
#define TkpGetAppName_TCL_DECLARED
/* 59 */
EXTERN void		TkpGetAppName(Tcl_Interp *interp, Tcl_DString *name);
#endif
#ifndef TkpGetOtherWindow_TCL_DECLARED
#define TkpGetOtherWindow_TCL_DECLARED
/* 60 */
EXTERN TkWindow *	TkpGetOtherWindow(TkWindow *winPtr);
#endif
#ifndef TkpGetWrapperWindow_TCL_DECLARED
#define TkpGetWrapperWindow_TCL_DECLARED
/* 61 */
EXTERN TkWindow *	TkpGetWrapperWindow(TkWindow *winPtr);
#endif
#ifndef TkpInit_TCL_DECLARED
#define TkpInit_TCL_DECLARED
/* 62 */
EXTERN int		TkpInit(Tcl_Interp *interp);
#endif
#ifndef TkpInitializeMenuBindings_TCL_DECLARED
#define TkpInitializeMenuBindings_TCL_DECLARED
/* 63 */
EXTERN void		TkpInitializeMenuBindings(Tcl_Interp *interp,
				Tk_BindingTable bindingTable);
#endif
#ifndef TkpMakeContainer_TCL_DECLARED
#define TkpMakeContainer_TCL_DECLARED
/* 64 */
EXTERN void		TkpMakeContainer(Tk_Window tkwin);
#endif
#ifndef TkpMakeMenuWindow_TCL_DECLARED
#define TkpMakeMenuWindow_TCL_DECLARED
/* 65 */
EXTERN void		TkpMakeMenuWindow(Tk_Window tkwin, int transient);
#endif
#ifndef TkpMakeWindow_TCL_DECLARED
#define TkpMakeWindow_TCL_DECLARED
/* 66 */
EXTERN Window		TkpMakeWindow(TkWindow *winPtr, Window parent);
#endif
#ifndef TkpMenuNotifyToplevelCreate_TCL_DECLARED
#define TkpMenuNotifyToplevelCreate_TCL_DECLARED
/* 67 */
EXTERN void		TkpMenuNotifyToplevelCreate(Tcl_Interp *interp,
				char *menuName);
#endif
#ifndef TkpOpenDisplay_TCL_DECLARED
#define TkpOpenDisplay_TCL_DECLARED
/* 68 */
EXTERN TkDisplay *	TkpOpenDisplay(CONST char *display_name);
#endif
#ifndef TkPointerEvent_TCL_DECLARED
#define TkPointerEvent_TCL_DECLARED
/* 69 */
EXTERN int		TkPointerEvent(XEvent *eventPtr, TkWindow *winPtr);
#endif
#ifndef TkPolygonToArea_TCL_DECLARED
#define TkPolygonToArea_TCL_DECLARED
/* 70 */
EXTERN int		TkPolygonToArea(double *polyPtr, int numPoints,
				double *rectPtr);
#endif
#ifndef TkPolygonToPoint_TCL_DECLARED
#define TkPolygonToPoint_TCL_DECLARED
/* 71 */
EXTERN double		TkPolygonToPoint(double *polyPtr, int numPoints,
				double *pointPtr);
#endif
#ifndef TkPositionInTree_TCL_DECLARED
#define TkPositionInTree_TCL_DECLARED
/* 72 */
EXTERN int		TkPositionInTree(TkWindow *winPtr, TkWindow *treePtr);
#endif
#ifndef TkpRedirectKeyEvent_TCL_DECLARED
#define TkpRedirectKeyEvent_TCL_DECLARED
/* 73 */
EXTERN void		TkpRedirectKeyEvent(TkWindow *winPtr,
				XEvent *eventPtr);
#endif
#ifndef TkpSetMainMenubar_TCL_DECLARED
#define TkpSetMainMenubar_TCL_DECLARED
/* 74 */
EXTERN void		TkpSetMainMenubar(Tcl_Interp *interp,
				Tk_Window tkwin, char *menuName);
#endif
#ifndef TkpUseWindow_TCL_DECLARED
#define TkpUseWindow_TCL_DECLARED
/* 75 */
EXTERN int		TkpUseWindow(Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *string);
#endif
#ifndef TkpWindowWasRecentlyDeleted_TCL_DECLARED
#define TkpWindowWasRecentlyDeleted_TCL_DECLARED
/* 76 */
EXTERN int		TkpWindowWasRecentlyDeleted(Window win,
				TkDisplay *dispPtr);
#endif
#ifndef TkQueueEventForAllChildren_TCL_DECLARED
#define TkQueueEventForAllChildren_TCL_DECLARED
/* 77 */
EXTERN void		TkQueueEventForAllChildren(TkWindow *winPtr,
				XEvent *eventPtr);
#endif
#ifndef TkReadBitmapFile_TCL_DECLARED
#define TkReadBitmapFile_TCL_DECLARED
/* 78 */
EXTERN int		TkReadBitmapFile(Display *display, Drawable d,
				CONST char *filename,
				unsigned int *width_return,
				unsigned int *height_return,
				Pixmap *bitmap_return, int *x_hot_return,
				int *y_hot_return);
#endif
#ifndef TkScrollWindow_TCL_DECLARED
#define TkScrollWindow_TCL_DECLARED
/* 79 */
EXTERN int		TkScrollWindow(Tk_Window tkwin, GC gc, int x, int y,
				int width, int height, int dx, int dy,
				TkRegion damageRgn);
#endif
#ifndef TkSelDeadWindow_TCL_DECLARED
#define TkSelDeadWindow_TCL_DECLARED
/* 80 */
EXTERN void		TkSelDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkSelEventProc_TCL_DECLARED
#define TkSelEventProc_TCL_DECLARED
/* 81 */
EXTERN void		TkSelEventProc(Tk_Window tkwin, XEvent *eventPtr);
#endif
#ifndef TkSelInit_TCL_DECLARED
#define TkSelInit_TCL_DECLARED
/* 82 */
EXTERN void		TkSelInit(Tk_Window tkwin);
#endif
#ifndef TkSelPropProc_TCL_DECLARED
#define TkSelPropProc_TCL_DECLARED
/* 83 */
EXTERN void		TkSelPropProc(XEvent *eventPtr);
#endif
/* Slot 84 is reserved */
#ifndef TkSetWindowMenuBar_TCL_DECLARED
#define TkSetWindowMenuBar_TCL_DECLARED
/* 85 */
EXTERN void		TkSetWindowMenuBar(Tcl_Interp *interp,
				Tk_Window tkwin, char *oldMenuName,
				char *menuName);
#endif
#ifndef TkStringToKeysym_TCL_DECLARED
#define TkStringToKeysym_TCL_DECLARED
/* 86 */
EXTERN KeySym		TkStringToKeysym(char *name);
#endif
#ifndef TkThickPolyLineToArea_TCL_DECLARED
#define TkThickPolyLineToArea_TCL_DECLARED
/* 87 */
EXTERN int		TkThickPolyLineToArea(double *coordPtr,
				int numPoints, double width, int capStyle,
				int joinStyle, double *rectPtr);
#endif
#ifndef TkWmAddToColormapWindows_TCL_DECLARED
#define TkWmAddToColormapWindows_TCL_DECLARED
/* 88 */
EXTERN void		TkWmAddToColormapWindows(TkWindow *winPtr);
#endif
#ifndef TkWmDeadWindow_TCL_DECLARED
#define TkWmDeadWindow_TCL_DECLARED
/* 89 */
EXTERN void		TkWmDeadWindow(TkWindow *winPtr);
#endif
#ifndef TkWmFocusToplevel_TCL_DECLARED
#define TkWmFocusToplevel_TCL_DECLARED
/* 90 */
EXTERN TkWindow *	TkWmFocusToplevel(TkWindow *winPtr);
#endif
#ifndef TkWmMapWindow_TCL_DECLARED
#define TkWmMapWindow_TCL_DECLARED
/* 91 */
EXTERN void		TkWmMapWindow(TkWindow *winPtr);
#endif
#ifndef TkWmNewWindow_TCL_DECLARED
#define TkWmNewWindow_TCL_DECLARED
/* 92 */
EXTERN void		TkWmNewWindow(TkWindow *winPtr);
#endif
#ifndef TkWmProtocolEventProc_TCL_DECLARED
#define TkWmProtocolEventProc_TCL_DECLARED
/* 93 */
EXTERN void		TkWmProtocolEventProc(TkWindow *winPtr,
				XEvent *evenvPtr);
#endif
#ifndef TkWmRemoveFromColormapWindows_TCL_DECLARED
#define TkWmRemoveFromColormapWindows_TCL_DECLARED
/* 94 */
EXTERN void		TkWmRemoveFromColormapWindows(TkWindow *winPtr);
#endif
#ifndef TkWmRestackToplevel_TCL_DECLARED
#define TkWmRestackToplevel_TCL_DECLARED
/* 95 */
EXTERN void		TkWmRestackToplevel(TkWindow *winPtr, int aboveBelow,
				TkWindow *otherPtr);
#endif
#ifndef TkWmSetClass_TCL_DECLARED
#define TkWmSetClass_TCL_DECLARED
/* 96 */
EXTERN void		TkWmSetClass(TkWindow *winPtr);
#endif
#ifndef TkWmUnmapWindow_TCL_DECLARED
#define TkWmUnmapWindow_TCL_DECLARED
/* 97 */
EXTERN void		TkWmUnmapWindow(TkWindow *winPtr);
#endif
#ifndef TkDebugBitmap_TCL_DECLARED
#define TkDebugBitmap_TCL_DECLARED
/* 98 */
EXTERN Tcl_Obj *	TkDebugBitmap(Tk_Window tkwin, char *name);
#endif
#ifndef TkDebugBorder_TCL_DECLARED
#define TkDebugBorder_TCL_DECLARED
/* 99 */
EXTERN Tcl_Obj *	TkDebugBorder(Tk_Window tkwin, char *name);
#endif
#ifndef TkDebugCursor_TCL_DECLARED
#define TkDebugCursor_TCL_DECLARED
/* 100 */
EXTERN Tcl_Obj *	TkDebugCursor(Tk_Window tkwin, char *name);
#endif
#ifndef TkDebugColor_TCL_DECLARED
#define TkDebugColor_TCL_DECLARED
/* 101 */
EXTERN Tcl_Obj *	TkDebugColor(Tk_Window tkwin, char *name);
#endif
#ifndef TkDebugConfig_TCL_DECLARED
#define TkDebugConfig_TCL_DECLARED
/* 102 */
EXTERN Tcl_Obj *	TkDebugConfig(Tcl_Interp *interp,
				Tk_OptionTable table);
#endif
#ifndef TkDebugFont_TCL_DECLARED
#define TkDebugFont_TCL_DECLARED
/* 103 */
EXTERN Tcl_Obj *	TkDebugFont(Tk_Window tkwin, char *name);
#endif
#ifndef TkFindStateNumObj_TCL_DECLARED
#define TkFindStateNumObj_TCL_DECLARED
/* 104 */
EXTERN int		TkFindStateNumObj(Tcl_Interp *interp,
				Tcl_Obj *optionPtr, CONST TkStateMap *mapPtr,
				Tcl_Obj *keyPtr);
#endif
#ifndef TkGetBitmapPredefTable_TCL_DECLARED
#define TkGetBitmapPredefTable_TCL_DECLARED
/* 105 */
EXTERN Tcl_HashTable *	TkGetBitmapPredefTable(void);
#endif
#ifndef TkGetDisplayList_TCL_DECLARED
#define TkGetDisplayList_TCL_DECLARED
/* 106 */
EXTERN TkDisplay *	TkGetDisplayList(void);
#endif
#ifndef TkGetMainInfoList_TCL_DECLARED
#define TkGetMainInfoList_TCL_DECLARED
/* 107 */
EXTERN TkMainInfo *	TkGetMainInfoList(void);
#endif
#ifndef TkGetWindowFromObj_TCL_DECLARED
#define TkGetWindowFromObj_TCL_DECLARED
/* 108 */
EXTERN int		TkGetWindowFromObj(Tcl_Interp *interp,
				Tk_Window tkwin, Tcl_Obj *objPtr,
				Tk_Window *windowPtr);
#endif
#ifndef TkpGetString_TCL_DECLARED
#define TkpGetString_TCL_DECLARED
/* 109 */
EXTERN char *		TkpGetString(TkWindow *winPtr, XEvent *eventPtr,
				Tcl_DString *dsPtr);
#endif
#ifndef TkpGetSubFonts_TCL_DECLARED
#define TkpGetSubFonts_TCL_DECLARED
/* 110 */
EXTERN void		TkpGetSubFonts(Tcl_Interp *interp, Tk_Font tkfont);
#endif
#ifndef TkpGetSystemDefault_TCL_DECLARED
#define TkpGetSystemDefault_TCL_DECLARED
/* 111 */
EXTERN Tcl_Obj *	TkpGetSystemDefault(Tk_Window tkwin,
				CONST char *dbName, CONST char *className);
#endif
#ifndef TkpMenuThreadInit_TCL_DECLARED
#define TkpMenuThreadInit_TCL_DECLARED
/* 112 */
EXTERN void		TkpMenuThreadInit(void);
#endif
#ifndef TkClipBox_TCL_DECLARED
#define TkClipBox_TCL_DECLARED
/* 113 */
EXTERN void		TkClipBox(TkRegion rgn, XRectangle *rect_return);
#endif
#ifndef TkCreateRegion_TCL_DECLARED
#define TkCreateRegion_TCL_DECLARED
/* 114 */
EXTERN TkRegion		TkCreateRegion(void);
#endif
#ifndef TkDestroyRegion_TCL_DECLARED
#define TkDestroyRegion_TCL_DECLARED
/* 115 */
EXTERN void		TkDestroyRegion(TkRegion rgn);
#endif
#ifndef TkIntersectRegion_TCL_DECLARED
#define TkIntersectRegion_TCL_DECLARED
/* 116 */
EXTERN void		TkIntersectRegion(TkRegion sra, TkRegion srcb,
				TkRegion dr_return);
#endif
#ifndef TkRectInRegion_TCL_DECLARED
#define TkRectInRegion_TCL_DECLARED
/* 117 */
EXTERN int		TkRectInRegion(TkRegion rgn, int x, int y,
				unsigned int width, unsigned int height);
#endif
#ifndef TkSetRegion_TCL_DECLARED
#define TkSetRegion_TCL_DECLARED
/* 118 */
EXTERN void		TkSetRegion(Display *display, GC gc, TkRegion rgn);
#endif
#ifndef TkUnionRectWithRegion_TCL_DECLARED
#define TkUnionRectWithRegion_TCL_DECLARED
/* 119 */
EXTERN void		TkUnionRectWithRegion(XRectangle *rect, TkRegion src,
				TkRegion dr_return);
#endif
/* Slot 120 is reserved */
#ifdef MAC_OSX_TK /* AQUA */
#ifndef TkpCreateNativeBitmap_TCL_DECLARED
#define TkpCreateNativeBitmap_TCL_DECLARED
/* 121 */
EXTERN Pixmap		TkpCreateNativeBitmap(Display *display,
				CONST char *source);
#endif
#endif /* AQUA */
#ifdef MAC_OSX_TK /* AQUA */
#ifndef TkpDefineNativeBitmaps_TCL_DECLARED
#define TkpDefineNativeBitmaps_TCL_DECLARED
/* 122 */
EXTERN void		TkpDefineNativeBitmaps(void);
#endif
#endif /* AQUA */
/* Slot 123 is reserved */
#ifdef MAC_OSX_TK /* AQUA */
#ifndef TkpGetNativeAppBitmap_TCL_DECLARED
#define TkpGetNativeAppBitmap_TCL_DECLARED
/* 124 */
EXTERN Pixmap		TkpGetNativeAppBitmap(Display *display,
				CONST char *name, int *width, int *height);
#endif
#endif /* AQUA */
/* Slot 125 is reserved */
/* Slot 126 is reserved */
/* Slot 127 is reserved */
/* Slot 128 is reserved */
/* Slot 129 is reserved */
/* Slot 130 is reserved */
/* Slot 131 is reserved */
/* Slot 132 is reserved */
/* Slot 133 is reserved */
/* Slot 134 is reserved */
#ifndef TkpDrawHighlightBorder_TCL_DECLARED
#define TkpDrawHighlightBorder_TCL_DECLARED
/* 135 */
EXTERN void		TkpDrawHighlightBorder(Tk_Window tkwin, GC fgGC,
				GC bgGC, int highlightWidth,
				Drawable drawable);
#endif
#ifndef TkSetFocusWin_TCL_DECLARED
#define TkSetFocusWin_TCL_DECLARED
/* 136 */
EXTERN void		TkSetFocusWin(TkWindow *winPtr, int force);
#endif
#ifndef TkpSetKeycodeAndState_TCL_DECLARED
#define TkpSetKeycodeAndState_TCL_DECLARED
/* 137 */
EXTERN void		TkpSetKeycodeAndState(Tk_Window tkwin, KeySym keySym,
				XEvent *eventPtr);
#endif
#ifndef TkpGetKeySym_TCL_DECLARED
#define TkpGetKeySym_TCL_DECLARED
/* 138 */
EXTERN KeySym		TkpGetKeySym(TkDisplay *dispPtr, XEvent *eventPtr);
#endif
#ifndef TkpInitKeymapInfo_TCL_DECLARED
#define TkpInitKeymapInfo_TCL_DECLARED
/* 139 */
EXTERN void		TkpInitKeymapInfo(TkDisplay *dispPtr);
#endif
#ifndef TkPhotoGetValidRegion_TCL_DECLARED
#define TkPhotoGetValidRegion_TCL_DECLARED
/* 140 */
EXTERN TkRegion		TkPhotoGetValidRegion(Tk_PhotoHandle handle);
#endif
#ifndef TkWmStackorderToplevel_TCL_DECLARED
#define TkWmStackorderToplevel_TCL_DECLARED
/* 141 */
EXTERN TkWindow **	TkWmStackorderToplevel(TkWindow *parentPtr);
#endif
#ifndef TkFocusFree_TCL_DECLARED
#define TkFocusFree_TCL_DECLARED
/* 142 */
EXTERN void		TkFocusFree(TkMainInfo *mainPtr);
#endif
#ifndef TkClipCleanup_TCL_DECLARED
#define TkClipCleanup_TCL_DECLARED
/* 143 */
EXTERN void		TkClipCleanup(TkDisplay *dispPtr);
#endif
#ifndef TkGCCleanup_TCL_DECLARED
#define TkGCCleanup_TCL_DECLARED
/* 144 */
EXTERN void		TkGCCleanup(TkDisplay *dispPtr);
#endif
#ifndef TkSubtractRegion_TCL_DECLARED
#define TkSubtractRegion_TCL_DECLARED
/* 145 */
EXTERN void		TkSubtractRegion(TkRegion sra, TkRegion srcb,
				TkRegion dr_return);
#endif
#ifndef TkStylePkgInit_TCL_DECLARED
#define TkStylePkgInit_TCL_DECLARED
/* 146 */
EXTERN void		TkStylePkgInit(TkMainInfo *mainPtr);
#endif
#ifndef TkStylePkgFree_TCL_DECLARED
#define TkStylePkgFree_TCL_DECLARED
/* 147 */
EXTERN void		TkStylePkgFree(TkMainInfo *mainPtr);
#endif
#ifndef TkToplevelWindowForCommand_TCL_DECLARED
#define TkToplevelWindowForCommand_TCL_DECLARED
/* 148 */
EXTERN Tk_Window	TkToplevelWindowForCommand(Tcl_Interp *interp,
				CONST char *cmdName);
#endif
#ifndef TkGetOptionSpec_TCL_DECLARED
#define TkGetOptionSpec_TCL_DECLARED
/* 149 */
EXTERN CONST Tk_OptionSpec * TkGetOptionSpec(CONST char *name,
				Tk_OptionTable optionTable);
#endif
#ifndef TkMakeRawCurve_TCL_DECLARED
#define TkMakeRawCurve_TCL_DECLARED
/* 150 */
EXTERN int		TkMakeRawCurve(Tk_Canvas canvas, double *pointPtr,
				int numPoints, int numSteps,
				XPoint xPoints[], double dblPoints[]);
#endif
#ifndef TkMakeRawCurvePostscript_TCL_DECLARED
#define TkMakeRawCurvePostscript_TCL_DECLARED
/* 151 */
EXTERN void		TkMakeRawCurvePostscript(Tcl_Interp *interp,
				Tk_Canvas canvas, double *pointPtr,
				int numPoints);
#endif
#ifndef TkpDrawFrame_TCL_DECLARED
#define TkpDrawFrame_TCL_DECLARED
/* 152 */
EXTERN void		TkpDrawFrame(Tk_Window tkwin, Tk_3DBorder border,
				int highlightWidth, int borderWidth,
				int relief);
#endif
#ifndef TkCreateThreadExitHandler_TCL_DECLARED
#define TkCreateThreadExitHandler_TCL_DECLARED
/* 153 */
EXTERN void		TkCreateThreadExitHandler(Tcl_ExitProc *proc,
				ClientData clientData);
#endif
#ifndef TkDeleteThreadExitHandler_TCL_DECLARED
#define TkDeleteThreadExitHandler_TCL_DECLARED
/* 154 */
EXTERN void		TkDeleteThreadExitHandler(Tcl_ExitProc *proc,
				ClientData clientData);
#endif
/* Slot 155 is reserved */
#ifndef TkpTestembedCmd_TCL_DECLARED
#define TkpTestembedCmd_TCL_DECLARED
/* 156 */
EXTERN int		TkpTestembedCmd(ClientData clientData,
				Tcl_Interp *interp, int argc,
				CONST char **argv);
#endif
#ifndef TkpTesttextCmd_TCL_DECLARED
#define TkpTesttextCmd_TCL_DECLARED
/* 157 */
EXTERN int		TkpTesttextCmd(ClientData dummy, Tcl_Interp *interp,
				int argc, CONST char **argv);
#endif
/* Slot 158 is reserved */
/* Slot 159 is reserved */
/* Slot 160 is reserved */
/* Slot 161 is reserved */
/* Slot 162 is reserved */
/* Slot 163 is reserved */
/* Slot 164 is reserved */
/* Slot 165 is reserved */
/* Slot 166 is reserved */
/* Slot 167 is reserved */
/* Slot 168 is reserved */
#ifndef TkStateParseProc_TCL_DECLARED
#define TkStateParseProc_TCL_DECLARED
/* 169 */
EXTERN int		TkStateParseProc(ClientData clientData,
				Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *value, char *widgRec, int offset);
#endif
#ifndef TkStatePrintProc_TCL_DECLARED
#define TkStatePrintProc_TCL_DECLARED
/* 170 */
EXTERN char *		TkStatePrintProc(ClientData clientData,
				Tk_Window tkwin, char *widgRec, int offset,
				Tcl_FreeProc **freeProcPtr);
#endif
#ifndef TkCanvasDashParseProc_TCL_DECLARED
#define TkCanvasDashParseProc_TCL_DECLARED
/* 171 */
EXTERN int		TkCanvasDashParseProc(ClientData clientData,
				Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *value, char *widgRec, int offset);
#endif
#ifndef TkCanvasDashPrintProc_TCL_DECLARED
#define TkCanvasDashPrintProc_TCL_DECLARED
/* 172 */
EXTERN char *		TkCanvasDashPrintProc(ClientData clientData,
				Tk_Window tkwin, char *widgRec, int offset,
				Tcl_FreeProc **freeProcPtr);
#endif
#ifndef TkOffsetParseProc_TCL_DECLARED
#define TkOffsetParseProc_TCL_DECLARED
/* 173 */
EXTERN int		TkOffsetParseProc(ClientData clientData,
				Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *value, char *widgRec, int offset);
#endif
#ifndef TkOffsetPrintProc_TCL_DECLARED
#define TkOffsetPrintProc_TCL_DECLARED
/* 174 */
EXTERN char *		TkOffsetPrintProc(ClientData clientData,
				Tk_Window tkwin, char *widgRec, int offset,
				Tcl_FreeProc **freeProcPtr);
#endif
#ifndef TkPixelParseProc_TCL_DECLARED
#define TkPixelParseProc_TCL_DECLARED
/* 175 */
EXTERN int		TkPixelParseProc(ClientData clientData,
				Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *value, char *widgRec, int offset);
#endif
#ifndef TkPixelPrintProc_TCL_DECLARED
#define TkPixelPrintProc_TCL_DECLARED
/* 176 */
EXTERN char *		TkPixelPrintProc(ClientData clientData,
				Tk_Window tkwin, char *widgRec, int offset,
				Tcl_FreeProc **freeProcPtr);
#endif
#ifndef TkOrientParseProc_TCL_DECLARED
#define TkOrientParseProc_TCL_DECLARED
/* 177 */
EXTERN int		TkOrientParseProc(ClientData clientData,
				Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *value, char *widgRec, int offset);
#endif
#ifndef TkOrientPrintProc_TCL_DECLARED
#define TkOrientPrintProc_TCL_DECLARED
/* 178 */
EXTERN char *		TkOrientPrintProc(ClientData clientData,
				Tk_Window tkwin, char *widgRec, int offset,
				Tcl_FreeProc **freeProcPtr);
#endif
#ifndef TkSmoothParseProc_TCL_DECLARED
#define TkSmoothParseProc_TCL_DECLARED
/* 179 */
EXTERN int		TkSmoothParseProc(ClientData clientData,
				Tcl_Interp *interp, Tk_Window tkwin,
				CONST char *value, char *widgRec, int offset);
#endif
#ifndef TkSmoothPrintProc_TCL_DECLARED
#define TkSmoothPrintProc_TCL_DECLARED
/* 180 */
EXTERN char *		TkSmoothPrintProc(ClientData clientData,
				Tk_Window tkwin, char *widgRec, int offset,
				Tcl_FreeProc **freeProcPtr);
#endif
/* Slot 181 is reserved */
/* Slot 182 is reserved */
/* Slot 183 is reserved */
#ifndef TkUnusedStubEntry_TCL_DECLARED
#define TkUnusedStubEntry_TCL_DECLARED
/* 184 */
EXTERN void		TkUnusedStubEntry(void);
#endif

typedef struct TkIntStubs {
    int magic;
    struct TkIntStubHooks *hooks;

    TkWindow * (*tkAllocWindow) (TkDisplay *dispPtr, int screenNum, TkWindow *parentPtr); /* 0 */
    void (*tkBezierPoints) (double control[], int numSteps, double *coordPtr); /* 1 */
    void (*tkBezierScreenPoints) (Tk_Canvas canvas, double control[], int numSteps, XPoint *xPointPtr); /* 2 */
    void (*tkBindDeadWindow) (TkWindow *winPtr); /* 3 */
    void (*tkBindEventProc) (TkWindow *winPtr, XEvent *eventPtr); /* 4 */
    void (*tkBindFree) (TkMainInfo *mainPtr); /* 5 */
    void (*tkBindInit) (TkMainInfo *mainPtr); /* 6 */
    void (*tkChangeEventWindow) (XEvent *eventPtr, TkWindow *winPtr); /* 7 */
    int (*tkClipInit) (Tcl_Interp *interp, TkDisplay *dispPtr); /* 8 */
    void (*tkComputeAnchor) (Tk_Anchor anchor, Tk_Window tkwin, int padX, int padY, int innerWidth, int innerHeight, int *xPtr, int *yPtr); /* 9 */
    int (*tkCopyAndGlobalEval) (Tcl_Interp *interp, char *script); /* 10 */
    unsigned long (*tkCreateBindingProcedure) (Tcl_Interp *interp, Tk_BindingTable bindingTable, ClientData object, CONST char *eventString, TkBindEvalProc *evalProc, TkBindFreeProc *freeProc, ClientData clientData); /* 11 */
    TkCursor * (*tkCreateCursorFromData) (Tk_Window tkwin, CONST char *source, CONST char *mask, int width, int height, int xHot, int yHot, XColor fg, XColor bg); /* 12 */
    int (*tkCreateFrame) (ClientData clientData, Tcl_Interp *interp, int argc, char **argv, int toplevel, char *appName); /* 13 */
    Tk_Window (*tkCreateMainWindow) (Tcl_Interp *interp, CONST char *screenName, char *baseName); /* 14 */
    Time (*tkCurrentTime) (TkDisplay *dispPtr); /* 15 */
    void (*tkDeleteAllImages) (TkMainInfo *mainPtr); /* 16 */
    void (*tkDoConfigureNotify) (TkWindow *winPtr); /* 17 */
    void (*tkDrawInsetFocusHighlight) (Tk_Window tkwin, GC gc, int width, Drawable drawable, int padding); /* 18 */
    void (*tkEventDeadWindow) (TkWindow *winPtr); /* 19 */
    void (*tkFillPolygon) (Tk_Canvas canvas, double *coordPtr, int numPoints, Display *display, Drawable drawable, GC gc, GC outlineGC); /* 20 */
    int (*tkFindStateNum) (Tcl_Interp *interp, CONST char *option, CONST TkStateMap *mapPtr, CONST char *strKey); /* 21 */
    char * (*tkFindStateString) (CONST TkStateMap *mapPtr, int numKey); /* 22 */
    void (*tkFocusDeadWindow) (TkWindow *winPtr); /* 23 */
    int (*tkFocusFilterEvent) (TkWindow *winPtr, XEvent *eventPtr); /* 24 */
    TkWindow * (*tkFocusKeyEvent) (TkWindow *winPtr, XEvent *eventPtr); /* 25 */
    void (*tkFontPkgInit) (TkMainInfo *mainPtr); /* 26 */
    void (*tkFontPkgFree) (TkMainInfo *mainPtr); /* 27 */
    void (*tkFreeBindingTags) (TkWindow *winPtr); /* 28 */
    void (*tkpFreeCursor) (TkCursor *cursorPtr); /* 29 */
    char * (*tkGetBitmapData) (Tcl_Interp *interp, char *string, char *fileName, int *widthPtr, int *heightPtr, int *hotXPtr, int *hotYPtr); /* 30 */
    void (*tkGetButtPoints) (double p1[], double p2[], double width, int project, double m1[], double m2[]); /* 31 */
    TkCursor * (*tkGetCursorByName) (Tcl_Interp *interp, Tk_Window tkwin, Tk_Uid string); /* 32 */
    CONST84_RETURN char * (*tkGetDefaultScreenName) (Tcl_Interp *interp, CONST char *screenName); /* 33 */
    TkDisplay * (*tkGetDisplay) (Display *display); /* 34 */
    int (*tkGetDisplayOf) (Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[], Tk_Window *tkwinPtr); /* 35 */
    TkWindow * (*tkGetFocusWin) (TkWindow *winPtr); /* 36 */
    int (*tkGetInterpNames) (Tcl_Interp *interp, Tk_Window tkwin); /* 37 */
    int (*tkGetMiterPoints) (double p1[], double p2[], double p3[], double width, double m1[], double m2[]); /* 38 */
    void (*tkGetPointerCoords) (Tk_Window tkwin, int *xPtr, int *yPtr); /* 39 */
    void (*tkGetServerInfo) (Tcl_Interp *interp, Tk_Window tkwin); /* 40 */
    void (*tkGrabDeadWindow) (TkWindow *winPtr); /* 41 */
    int (*tkGrabState) (TkWindow *winPtr); /* 42 */
    void (*tkIncludePoint) (Tk_Item *itemPtr, double *pointPtr); /* 43 */
    void (*tkInOutEvents) (XEvent *eventPtr, TkWindow *sourcePtr, TkWindow *destPtr, int leaveType, int enterType, Tcl_QueuePosition position); /* 44 */
    void (*tkInstallFrameMenu) (Tk_Window tkwin); /* 45 */
    char * (*tkKeysymToString) (KeySym keysym); /* 46 */
    int (*tkLineToArea) (double end1Ptr[], double end2Ptr[], double rectPtr[]); /* 47 */
    double (*tkLineToPoint) (double end1Ptr[], double end2Ptr[], double pointPtr[]); /* 48 */
    int (*tkMakeBezierCurve) (Tk_Canvas canvas, double *pointPtr, int numPoints, int numSteps, XPoint xPoints[], double dblPoints[]); /* 49 */
    void (*tkMakeBezierPostscript) (Tcl_Interp *interp, Tk_Canvas canvas, double *pointPtr, int numPoints); /* 50 */
    void (*tkOptionClassChanged) (TkWindow *winPtr); /* 51 */
    void (*tkOptionDeadWindow) (TkWindow *winPtr); /* 52 */
    int (*tkOvalToArea) (double *ovalPtr, double *rectPtr); /* 53 */
    double (*tkOvalToPoint) (double ovalPtr[], double width, int filled, double pointPtr[]); /* 54 */
    int (*tkpChangeFocus) (TkWindow *winPtr, int force); /* 55 */
    void (*tkpCloseDisplay) (TkDisplay *dispPtr); /* 56 */
    void (*tkpClaimFocus) (TkWindow *topLevelPtr, int force); /* 57 */
    void (*tkpDisplayWarning) (CONST char *msg, CONST char *title); /* 58 */
    void (*tkpGetAppName) (Tcl_Interp *interp, Tcl_DString *name); /* 59 */
    TkWindow * (*tkpGetOtherWindow) (TkWindow *winPtr); /* 60 */
    TkWindow * (*tkpGetWrapperWindow) (TkWindow *winPtr); /* 61 */
    int (*tkpInit) (Tcl_Interp *interp); /* 62 */
    void (*tkpInitializeMenuBindings) (Tcl_Interp *interp, Tk_BindingTable bindingTable); /* 63 */
    void (*tkpMakeContainer) (Tk_Window tkwin); /* 64 */
    void (*tkpMakeMenuWindow) (Tk_Window tkwin, int transient); /* 65 */
    Window (*tkpMakeWindow) (TkWindow *winPtr, Window parent); /* 66 */
    void (*tkpMenuNotifyToplevelCreate) (Tcl_Interp *interp, char *menuName); /* 67 */
    TkDisplay * (*tkpOpenDisplay) (CONST char *display_name); /* 68 */
    int (*tkPointerEvent) (XEvent *eventPtr, TkWindow *winPtr); /* 69 */
    int (*tkPolygonToArea) (double *polyPtr, int numPoints, double *rectPtr); /* 70 */
    double (*tkPolygonToPoint) (double *polyPtr, int numPoints, double *pointPtr); /* 71 */
    int (*tkPositionInTree) (TkWindow *winPtr, TkWindow *treePtr); /* 72 */
    void (*tkpRedirectKeyEvent) (TkWindow *winPtr, XEvent *eventPtr); /* 73 */
    void (*tkpSetMainMenubar) (Tcl_Interp *interp, Tk_Window tkwin, char *menuName); /* 74 */
    int (*tkpUseWindow) (Tcl_Interp *interp, Tk_Window tkwin, CONST char *string); /* 75 */
    int (*tkpWindowWasRecentlyDeleted) (Window win, TkDisplay *dispPtr); /* 76 */
    void (*tkQueueEventForAllChildren) (TkWindow *winPtr, XEvent *eventPtr); /* 77 */
    int (*tkReadBitmapFile) (Display *display, Drawable d, CONST char *filename, unsigned int *width_return, unsigned int *height_return, Pixmap *bitmap_return, int *x_hot_return, int *y_hot_return); /* 78 */
    int (*tkScrollWindow) (Tk_Window tkwin, GC gc, int x, int y, int width, int height, int dx, int dy, TkRegion damageRgn); /* 79 */
    void (*tkSelDeadWindow) (TkWindow *winPtr); /* 80 */
    void (*tkSelEventProc) (Tk_Window tkwin, XEvent *eventPtr); /* 81 */
    void (*tkSelInit) (Tk_Window tkwin); /* 82 */
    void (*tkSelPropProc) (XEvent *eventPtr); /* 83 */
    VOID *reserved84;
    void (*tkSetWindowMenuBar) (Tcl_Interp *interp, Tk_Window tkwin, char *oldMenuName, char *menuName); /* 85 */
    KeySym (*tkStringToKeysym) (char *name); /* 86 */
    int (*tkThickPolyLineToArea) (double *coordPtr, int numPoints, double width, int capStyle, int joinStyle, double *rectPtr); /* 87 */
    void (*tkWmAddToColormapWindows) (TkWindow *winPtr); /* 88 */
    void (*tkWmDeadWindow) (TkWindow *winPtr); /* 89 */
    TkWindow * (*tkWmFocusToplevel) (TkWindow *winPtr); /* 90 */
    void (*tkWmMapWindow) (TkWindow *winPtr); /* 91 */
    void (*tkWmNewWindow) (TkWindow *winPtr); /* 92 */
    void (*tkWmProtocolEventProc) (TkWindow *winPtr, XEvent *evenvPtr); /* 93 */
    void (*tkWmRemoveFromColormapWindows) (TkWindow *winPtr); /* 94 */
    void (*tkWmRestackToplevel) (TkWindow *winPtr, int aboveBelow, TkWindow *otherPtr); /* 95 */
    void (*tkWmSetClass) (TkWindow *winPtr); /* 96 */
    void (*tkWmUnmapWindow) (TkWindow *winPtr); /* 97 */
    Tcl_Obj * (*tkDebugBitmap) (Tk_Window tkwin, char *name); /* 98 */
    Tcl_Obj * (*tkDebugBorder) (Tk_Window tkwin, char *name); /* 99 */
    Tcl_Obj * (*tkDebugCursor) (Tk_Window tkwin, char *name); /* 100 */
    Tcl_Obj * (*tkDebugColor) (Tk_Window tkwin, char *name); /* 101 */
    Tcl_Obj * (*tkDebugConfig) (Tcl_Interp *interp, Tk_OptionTable table); /* 102 */
    Tcl_Obj * (*tkDebugFont) (Tk_Window tkwin, char *name); /* 103 */
    int (*tkFindStateNumObj) (Tcl_Interp *interp, Tcl_Obj *optionPtr, CONST TkStateMap *mapPtr, Tcl_Obj *keyPtr); /* 104 */
    Tcl_HashTable * (*tkGetBitmapPredefTable) (void); /* 105 */
    TkDisplay * (*tkGetDisplayList) (void); /* 106 */
    TkMainInfo * (*tkGetMainInfoList) (void); /* 107 */
    int (*tkGetWindowFromObj) (Tcl_Interp *interp, Tk_Window tkwin, Tcl_Obj *objPtr, Tk_Window *windowPtr); /* 108 */
    char * (*tkpGetString) (TkWindow *winPtr, XEvent *eventPtr, Tcl_DString *dsPtr); /* 109 */
    void (*tkpGetSubFonts) (Tcl_Interp *interp, Tk_Font tkfont); /* 110 */
    Tcl_Obj * (*tkpGetSystemDefault) (Tk_Window tkwin, CONST char *dbName, CONST char *className); /* 111 */
    void (*tkpMenuThreadInit) (void); /* 112 */
    void (*tkClipBox) (TkRegion rgn, XRectangle *rect_return); /* 113 */
    TkRegion (*tkCreateRegion) (void); /* 114 */
    void (*tkDestroyRegion) (TkRegion rgn); /* 115 */
    void (*tkIntersectRegion) (TkRegion sra, TkRegion srcb, TkRegion dr_return); /* 116 */
    int (*tkRectInRegion) (TkRegion rgn, int x, int y, unsigned int width, unsigned int height); /* 117 */
    void (*tkSetRegion) (Display *display, GC gc, TkRegion rgn); /* 118 */
    void (*tkUnionRectWithRegion) (XRectangle *rect, TkRegion src, TkRegion dr_return); /* 119 */
    VOID *reserved120;
#if !(defined(__WIN32__) || defined(MAC_OSX_TK)) /* X11 */
    VOID *reserved121;
#endif /* X11 */
#if defined(__WIN32__) /* WIN */
    VOID *reserved121;
#endif /* WIN */
#ifdef MAC_OSX_TK /* AQUA */
    VOID *reserved121; /* Dummy entry for stubs table backwards compatibility */
    Pixmap (*tkpCreateNativeBitmap) (Display *display, CONST char *source); /* 121 */
#endif /* AQUA */
#if !(defined(__WIN32__) || defined(MAC_OSX_TK)) /* X11 */
    VOID *reserved122;
#endif /* X11 */
#if defined(__WIN32__) /* WIN */
    VOID *reserved122;
#endif /* WIN */
#ifdef MAC_OSX_TK /* AQUA */
    VOID *reserved122; /* Dummy entry for stubs table backwards compatibility */
    void (*tkpDefineNativeBitmaps) (void); /* 122 */
#endif /* AQUA */
    VOID *reserved123;
#if !(defined(__WIN32__) || defined(MAC_OSX_TK)) /* X11 */
    VOID *reserved124;
#endif /* X11 */
#if defined(__WIN32__) /* WIN */
    VOID *reserved124;
#endif /* WIN */
#ifdef MAC_OSX_TK /* AQUA */
    VOID *reserved124; /* Dummy entry for stubs table backwards compatibility */
    Pixmap (*tkpGetNativeAppBitmap) (Display *display, CONST char *name, int *width, int *height); /* 124 */
#endif /* AQUA */
    VOID *reserved125;
    VOID *reserved126;
    VOID *reserved127;
    VOID *reserved128;
    VOID *reserved129;
    VOID *reserved130;
    VOID *reserved131;
    VOID *reserved132;
    VOID *reserved133;
    VOID *reserved134;
    void (*tkpDrawHighlightBorder) (Tk_Window tkwin, GC fgGC, GC bgGC, int highlightWidth, Drawable drawable); /* 135 */
    void (*tkSetFocusWin) (TkWindow *winPtr, int force); /* 136 */
    void (*tkpSetKeycodeAndState) (Tk_Window tkwin, KeySym keySym, XEvent *eventPtr); /* 137 */
    KeySym (*tkpGetKeySym) (TkDisplay *dispPtr, XEvent *eventPtr); /* 138 */
    void (*tkpInitKeymapInfo) (TkDisplay *dispPtr); /* 139 */
    TkRegion (*tkPhotoGetValidRegion) (Tk_PhotoHandle handle); /* 140 */
    TkWindow ** (*tkWmStackorderToplevel) (TkWindow *parentPtr); /* 141 */
    void (*tkFocusFree) (TkMainInfo *mainPtr); /* 142 */
    void (*tkClipCleanup) (TkDisplay *dispPtr); /* 143 */
    void (*tkGCCleanup) (TkDisplay *dispPtr); /* 144 */
    void (*tkSubtractRegion) (TkRegion sra, TkRegion srcb, TkRegion dr_return); /* 145 */
    void (*tkStylePkgInit) (TkMainInfo *mainPtr); /* 146 */
    void (*tkStylePkgFree) (TkMainInfo *mainPtr); /* 147 */
    Tk_Window (*tkToplevelWindowForCommand) (Tcl_Interp *interp, CONST char *cmdName); /* 148 */
    CONST Tk_OptionSpec * (*tkGetOptionSpec) (CONST char *name, Tk_OptionTable optionTable); /* 149 */
    int (*tkMakeRawCurve) (Tk_Canvas canvas, double *pointPtr, int numPoints, int numSteps, XPoint xPoints[], double dblPoints[]); /* 150 */
    void (*tkMakeRawCurvePostscript) (Tcl_Interp *interp, Tk_Canvas canvas, double *pointPtr, int numPoints); /* 151 */
    void (*tkpDrawFrame) (Tk_Window tkwin, Tk_3DBorder border, int highlightWidth, int borderWidth, int relief); /* 152 */
    void (*tkCreateThreadExitHandler) (Tcl_ExitProc *proc, ClientData clientData); /* 153 */
    void (*tkDeleteThreadExitHandler) (Tcl_ExitProc *proc, ClientData clientData); /* 154 */
    VOID *reserved155;
    int (*tkpTestembedCmd) (ClientData clientData, Tcl_Interp *interp, int argc, CONST char **argv); /* 156 */
    int (*tkpTesttextCmd) (ClientData dummy, Tcl_Interp *interp, int argc, CONST char **argv); /* 157 */
    VOID *reserved158;
    VOID *reserved159;
    VOID *reserved160;
    VOID *reserved161;
    VOID *reserved162;
    VOID *reserved163;
    VOID *reserved164;
    VOID *reserved165;
    VOID *reserved166;
    VOID *reserved167;
    VOID *reserved168;
    int (*tkStateParseProc) (ClientData clientData, Tcl_Interp *interp, Tk_Window tkwin, CONST char *value, char *widgRec, int offset); /* 169 */
    char * (*tkStatePrintProc) (ClientData clientData, Tk_Window tkwin, char *widgRec, int offset, Tcl_FreeProc **freeProcPtr); /* 170 */
    int (*tkCanvasDashParseProc) (ClientData clientData, Tcl_Interp *interp, Tk_Window tkwin, CONST char *value, char *widgRec, int offset); /* 171 */
    char * (*tkCanvasDashPrintProc) (ClientData clientData, Tk_Window tkwin, char *widgRec, int offset, Tcl_FreeProc **freeProcPtr); /* 172 */
    int (*tkOffsetParseProc) (ClientData clientData, Tcl_Interp *interp, Tk_Window tkwin, CONST char *value, char *widgRec, int offset); /* 173 */
    char * (*tkOffsetPrintProc) (ClientData clientData, Tk_Window tkwin, char *widgRec, int offset, Tcl_FreeProc **freeProcPtr); /* 174 */
    int (*tkPixelParseProc) (ClientData clientData, Tcl_Interp *interp, Tk_Window tkwin, CONST char *value, char *widgRec, int offset); /* 175 */
    char * (*tkPixelPrintProc) (ClientData clientData, Tk_Window tkwin, char *widgRec, int offset, Tcl_FreeProc **freeProcPtr); /* 176 */
    int (*tkOrientParseProc) (ClientData clientData, Tcl_Interp *interp, Tk_Window tkwin, CONST char *value, char *widgRec, int offset); /* 177 */
    char * (*tkOrientPrintProc) (ClientData clientData, Tk_Window tkwin, char *widgRec, int offset, Tcl_FreeProc **freeProcPtr); /* 178 */
    int (*tkSmoothParseProc) (ClientData clientData, Tcl_Interp *interp, Tk_Window tkwin, CONST char *value, char *widgRec, int offset); /* 179 */
    char * (*tkSmoothPrintProc) (ClientData clientData, Tk_Window tkwin, char *widgRec, int offset, Tcl_FreeProc **freeProcPtr); /* 180 */
    VOID *reserved181;
    VOID *reserved182;
    VOID *reserved183;
    void (*tkUnusedStubEntry) (void); /* 184 */
} TkIntStubs;

extern TkIntStubs *tkIntStubsPtr;

#ifdef __cplusplus
}
#endif

#if defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS)

/*
 * Inline function declarations:
 */

#ifndef TkAllocWindow
#define TkAllocWindow \
	(tkIntStubsPtr->tkAllocWindow) /* 0 */
#endif
#ifndef TkBezierPoints
#define TkBezierPoints \
	(tkIntStubsPtr->tkBezierPoints) /* 1 */
#endif
#ifndef TkBezierScreenPoints
#define TkBezierScreenPoints \
	(tkIntStubsPtr->tkBezierScreenPoints) /* 2 */
#endif
#ifndef TkBindDeadWindow
#define TkBindDeadWindow \
	(tkIntStubsPtr->tkBindDeadWindow) /* 3 */
#endif
#ifndef TkBindEventProc
#define TkBindEventProc \
	(tkIntStubsPtr->tkBindEventProc) /* 4 */
#endif
#ifndef TkBindFree
#define TkBindFree \
	(tkIntStubsPtr->tkBindFree) /* 5 */
#endif
#ifndef TkBindInit
#define TkBindInit \
	(tkIntStubsPtr->tkBindInit) /* 6 */
#endif
#ifndef TkChangeEventWindow
#define TkChangeEventWindow \
	(tkIntStubsPtr->tkChangeEventWindow) /* 7 */
#endif
#ifndef TkClipInit
#define TkClipInit \
	(tkIntStubsPtr->tkClipInit) /* 8 */
#endif
#ifndef TkComputeAnchor
#define TkComputeAnchor \
	(tkIntStubsPtr->tkComputeAnchor) /* 9 */
#endif
#ifndef TkCopyAndGlobalEval
#define TkCopyAndGlobalEval \
	(tkIntStubsPtr->tkCopyAndGlobalEval) /* 10 */
#endif
#ifndef TkCreateBindingProcedure
#define TkCreateBindingProcedure \
	(tkIntStubsPtr->tkCreateBindingProcedure) /* 11 */
#endif
#ifndef TkCreateCursorFromData
#define TkCreateCursorFromData \
	(tkIntStubsPtr->tkCreateCursorFromData) /* 12 */
#endif
#ifndef TkCreateFrame
#define TkCreateFrame \
	(tkIntStubsPtr->tkCreateFrame) /* 13 */
#endif
#ifndef TkCreateMainWindow
#define TkCreateMainWindow \
	(tkIntStubsPtr->tkCreateMainWindow) /* 14 */
#endif
#ifndef TkCurrentTime
#define TkCurrentTime \
	(tkIntStubsPtr->tkCurrentTime) /* 15 */
#endif
#ifndef TkDeleteAllImages
#define TkDeleteAllImages \
	(tkIntStubsPtr->tkDeleteAllImages) /* 16 */
#endif
#ifndef TkDoConfigureNotify
#define TkDoConfigureNotify \
	(tkIntStubsPtr->tkDoConfigureNotify) /* 17 */
#endif
#ifndef TkDrawInsetFocusHighlight
#define TkDrawInsetFocusHighlight \
	(tkIntStubsPtr->tkDrawInsetFocusHighlight) /* 18 */
#endif
#ifndef TkEventDeadWindow
#define TkEventDeadWindow \
	(tkIntStubsPtr->tkEventDeadWindow) /* 19 */
#endif
#ifndef TkFillPolygon
#define TkFillPolygon \
	(tkIntStubsPtr->tkFillPolygon) /* 20 */
#endif
#ifndef TkFindStateNum
#define TkFindStateNum \
	(tkIntStubsPtr->tkFindStateNum) /* 21 */
#endif
#ifndef TkFindStateString
#define TkFindStateString \
	(tkIntStubsPtr->tkFindStateString) /* 22 */
#endif
#ifndef TkFocusDeadWindow
#define TkFocusDeadWindow \
	(tkIntStubsPtr->tkFocusDeadWindow) /* 23 */
#endif
#ifndef TkFocusFilterEvent
#define TkFocusFilterEvent \
	(tkIntStubsPtr->tkFocusFilterEvent) /* 24 */
#endif
#ifndef TkFocusKeyEvent
#define TkFocusKeyEvent \
	(tkIntStubsPtr->tkFocusKeyEvent) /* 25 */
#endif
#ifndef TkFontPkgInit
#define TkFontPkgInit \
	(tkIntStubsPtr->tkFontPkgInit) /* 26 */
#endif
#ifndef TkFontPkgFree
#define TkFontPkgFree \
	(tkIntStubsPtr->tkFontPkgFree) /* 27 */
#endif
#ifndef TkFreeBindingTags
#define TkFreeBindingTags \
	(tkIntStubsPtr->tkFreeBindingTags) /* 28 */
#endif
#ifndef TkpFreeCursor
#define TkpFreeCursor \
	(tkIntStubsPtr->tkpFreeCursor) /* 29 */
#endif
#ifndef TkGetBitmapData
#define TkGetBitmapData \
	(tkIntStubsPtr->tkGetBitmapData) /* 30 */
#endif
#ifndef TkGetButtPoints
#define TkGetButtPoints \
	(tkIntStubsPtr->tkGetButtPoints) /* 31 */
#endif
#ifndef TkGetCursorByName
#define TkGetCursorByName \
	(tkIntStubsPtr->tkGetCursorByName) /* 32 */
#endif
#ifndef TkGetDefaultScreenName
#define TkGetDefaultScreenName \
	(tkIntStubsPtr->tkGetDefaultScreenName) /* 33 */
#endif
#ifndef TkGetDisplay
#define TkGetDisplay \
	(tkIntStubsPtr->tkGetDisplay) /* 34 */
#endif
#ifndef TkGetDisplayOf
#define TkGetDisplayOf \
	(tkIntStubsPtr->tkGetDisplayOf) /* 35 */
#endif
#ifndef TkGetFocusWin
#define TkGetFocusWin \
	(tkIntStubsPtr->tkGetFocusWin) /* 36 */
#endif
#ifndef TkGetInterpNames
#define TkGetInterpNames \
	(tkIntStubsPtr->tkGetInterpNames) /* 37 */
#endif
#ifndef TkGetMiterPoints
#define TkGetMiterPoints \
	(tkIntStubsPtr->tkGetMiterPoints) /* 38 */
#endif
#ifndef TkGetPointerCoords
#define TkGetPointerCoords \
	(tkIntStubsPtr->tkGetPointerCoords) /* 39 */
#endif
#ifndef TkGetServerInfo
#define TkGetServerInfo \
	(tkIntStubsPtr->tkGetServerInfo) /* 40 */
#endif
#ifndef TkGrabDeadWindow
#define TkGrabDeadWindow \
	(tkIntStubsPtr->tkGrabDeadWindow) /* 41 */
#endif
#ifndef TkGrabState
#define TkGrabState \
	(tkIntStubsPtr->tkGrabState) /* 42 */
#endif
#ifndef TkIncludePoint
#define TkIncludePoint \
	(tkIntStubsPtr->tkIncludePoint) /* 43 */
#endif
#ifndef TkInOutEvents
#define TkInOutEvents \
	(tkIntStubsPtr->tkInOutEvents) /* 44 */
#endif
#ifndef TkInstallFrameMenu
#define TkInstallFrameMenu \
	(tkIntStubsPtr->tkInstallFrameMenu) /* 45 */
#endif
#ifndef TkKeysymToString
#define TkKeysymToString \
	(tkIntStubsPtr->tkKeysymToString) /* 46 */
#endif
#ifndef TkLineToArea
#define TkLineToArea \
	(tkIntStubsPtr->tkLineToArea) /* 47 */
#endif
#ifndef TkLineToPoint
#define TkLineToPoint \
	(tkIntStubsPtr->tkLineToPoint) /* 48 */
#endif
#ifndef TkMakeBezierCurve
#define TkMakeBezierCurve \
	(tkIntStubsPtr->tkMakeBezierCurve) /* 49 */
#endif
#ifndef TkMakeBezierPostscript
#define TkMakeBezierPostscript \
	(tkIntStubsPtr->tkMakeBezierPostscript) /* 50 */
#endif
#ifndef TkOptionClassChanged
#define TkOptionClassChanged \
	(tkIntStubsPtr->tkOptionClassChanged) /* 51 */
#endif
#ifndef TkOptionDeadWindow
#define TkOptionDeadWindow \
	(tkIntStubsPtr->tkOptionDeadWindow) /* 52 */
#endif
#ifndef TkOvalToArea
#define TkOvalToArea \
	(tkIntStubsPtr->tkOvalToArea) /* 53 */
#endif
#ifndef TkOvalToPoint
#define TkOvalToPoint \
	(tkIntStubsPtr->tkOvalToPoint) /* 54 */
#endif
#ifndef TkpChangeFocus
#define TkpChangeFocus \
	(tkIntStubsPtr->tkpChangeFocus) /* 55 */
#endif
#ifndef TkpCloseDisplay
#define TkpCloseDisplay \
	(tkIntStubsPtr->tkpCloseDisplay) /* 56 */
#endif
#ifndef TkpClaimFocus
#define TkpClaimFocus \
	(tkIntStubsPtr->tkpClaimFocus) /* 57 */
#endif
#ifndef TkpDisplayWarning
#define TkpDisplayWarning \
	(tkIntStubsPtr->tkpDisplayWarning) /* 58 */
#endif
#ifndef TkpGetAppName
#define TkpGetAppName \
	(tkIntStubsPtr->tkpGetAppName) /* 59 */
#endif
#ifndef TkpGetOtherWindow
#define TkpGetOtherWindow \
	(tkIntStubsPtr->tkpGetOtherWindow) /* 60 */
#endif
#ifndef TkpGetWrapperWindow
#define TkpGetWrapperWindow \
	(tkIntStubsPtr->tkpGetWrapperWindow) /* 61 */
#endif
#ifndef TkpInit
#define TkpInit \
	(tkIntStubsPtr->tkpInit) /* 62 */
#endif
#ifndef TkpInitializeMenuBindings
#define TkpInitializeMenuBindings \
	(tkIntStubsPtr->tkpInitializeMenuBindings) /* 63 */
#endif
#ifndef TkpMakeContainer
#define TkpMakeContainer \
	(tkIntStubsPtr->tkpMakeContainer) /* 64 */
#endif
#ifndef TkpMakeMenuWindow
#define TkpMakeMenuWindow \
	(tkIntStubsPtr->tkpMakeMenuWindow) /* 65 */
#endif
#ifndef TkpMakeWindow
#define TkpMakeWindow \
	(tkIntStubsPtr->tkpMakeWindow) /* 66 */
#endif
#ifndef TkpMenuNotifyToplevelCreate
#define TkpMenuNotifyToplevelCreate \
	(tkIntStubsPtr->tkpMenuNotifyToplevelCreate) /* 67 */
#endif
#ifndef TkpOpenDisplay
#define TkpOpenDisplay \
	(tkIntStubsPtr->tkpOpenDisplay) /* 68 */
#endif
#ifndef TkPointerEvent
#define TkPointerEvent \
	(tkIntStubsPtr->tkPointerEvent) /* 69 */
#endif
#ifndef TkPolygonToArea
#define TkPolygonToArea \
	(tkIntStubsPtr->tkPolygonToArea) /* 70 */
#endif
#ifndef TkPolygonToPoint
#define TkPolygonToPoint \
	(tkIntStubsPtr->tkPolygonToPoint) /* 71 */
#endif
#ifndef TkPositionInTree
#define TkPositionInTree \
	(tkIntStubsPtr->tkPositionInTree) /* 72 */
#endif
#ifndef TkpRedirectKeyEvent
#define TkpRedirectKeyEvent \
	(tkIntStubsPtr->tkpRedirectKeyEvent) /* 73 */
#endif
#ifndef TkpSetMainMenubar
#define TkpSetMainMenubar \
	(tkIntStubsPtr->tkpSetMainMenubar) /* 74 */
#endif
#ifndef TkpUseWindow
#define TkpUseWindow \
	(tkIntStubsPtr->tkpUseWindow) /* 75 */
#endif
#ifndef TkpWindowWasRecentlyDeleted
#define TkpWindowWasRecentlyDeleted \
	(tkIntStubsPtr->tkpWindowWasRecentlyDeleted) /* 76 */
#endif
#ifndef TkQueueEventForAllChildren
#define TkQueueEventForAllChildren \
	(tkIntStubsPtr->tkQueueEventForAllChildren) /* 77 */
#endif
#ifndef TkReadBitmapFile
#define TkReadBitmapFile \
	(tkIntStubsPtr->tkReadBitmapFile) /* 78 */
#endif
#ifndef TkScrollWindow
#define TkScrollWindow \
	(tkIntStubsPtr->tkScrollWindow) /* 79 */
#endif
#ifndef TkSelDeadWindow
#define TkSelDeadWindow \
	(tkIntStubsPtr->tkSelDeadWindow) /* 80 */
#endif
#ifndef TkSelEventProc
#define TkSelEventProc \
	(tkIntStubsPtr->tkSelEventProc) /* 81 */
#endif
#ifndef TkSelInit
#define TkSelInit \
	(tkIntStubsPtr->tkSelInit) /* 82 */
#endif
#ifndef TkSelPropProc
#define TkSelPropProc \
	(tkIntStubsPtr->tkSelPropProc) /* 83 */
#endif
/* Slot 84 is reserved */
#ifndef TkSetWindowMenuBar
#define TkSetWindowMenuBar \
	(tkIntStubsPtr->tkSetWindowMenuBar) /* 85 */
#endif
#ifndef TkStringToKeysym
#define TkStringToKeysym \
	(tkIntStubsPtr->tkStringToKeysym) /* 86 */
#endif
#ifndef TkThickPolyLineToArea
#define TkThickPolyLineToArea \
	(tkIntStubsPtr->tkThickPolyLineToArea) /* 87 */
#endif
#ifndef TkWmAddToColormapWindows
#define TkWmAddToColormapWindows \
	(tkIntStubsPtr->tkWmAddToColormapWindows) /* 88 */
#endif
#ifndef TkWmDeadWindow
#define TkWmDeadWindow \
	(tkIntStubsPtr->tkWmDeadWindow) /* 89 */
#endif
#ifndef TkWmFocusToplevel
#define TkWmFocusToplevel \
	(tkIntStubsPtr->tkWmFocusToplevel) /* 90 */
#endif
#ifndef TkWmMapWindow
#define TkWmMapWindow \
	(tkIntStubsPtr->tkWmMapWindow) /* 91 */
#endif
#ifndef TkWmNewWindow
#define TkWmNewWindow \
	(tkIntStubsPtr->tkWmNewWindow) /* 92 */
#endif
#ifndef TkWmProtocolEventProc
#define TkWmProtocolEventProc \
	(tkIntStubsPtr->tkWmProtocolEventProc) /* 93 */
#endif
#ifndef TkWmRemoveFromColormapWindows
#define TkWmRemoveFromColormapWindows \
	(tkIntStubsPtr->tkWmRemoveFromColormapWindows) /* 94 */
#endif
#ifndef TkWmRestackToplevel
#define TkWmRestackToplevel \
	(tkIntStubsPtr->tkWmRestackToplevel) /* 95 */
#endif
#ifndef TkWmSetClass
#define TkWmSetClass \
	(tkIntStubsPtr->tkWmSetClass) /* 96 */
#endif
#ifndef TkWmUnmapWindow
#define TkWmUnmapWindow \
	(tkIntStubsPtr->tkWmUnmapWindow) /* 97 */
#endif
#ifndef TkDebugBitmap
#define TkDebugBitmap \
	(tkIntStubsPtr->tkDebugBitmap) /* 98 */
#endif
#ifndef TkDebugBorder
#define TkDebugBorder \
	(tkIntStubsPtr->tkDebugBorder) /* 99 */
#endif
#ifndef TkDebugCursor
#define TkDebugCursor \
	(tkIntStubsPtr->tkDebugCursor) /* 100 */
#endif
#ifndef TkDebugColor
#define TkDebugColor \
	(tkIntStubsPtr->tkDebugColor) /* 101 */
#endif
#ifndef TkDebugConfig
#define TkDebugConfig \
	(tkIntStubsPtr->tkDebugConfig) /* 102 */
#endif
#ifndef TkDebugFont
#define TkDebugFont \
	(tkIntStubsPtr->tkDebugFont) /* 103 */
#endif
#ifndef TkFindStateNumObj
#define TkFindStateNumObj \
	(tkIntStubsPtr->tkFindStateNumObj) /* 104 */
#endif
#ifndef TkGetBitmapPredefTable
#define TkGetBitmapPredefTable \
	(tkIntStubsPtr->tkGetBitmapPredefTable) /* 105 */
#endif
#ifndef TkGetDisplayList
#define TkGetDisplayList \
	(tkIntStubsPtr->tkGetDisplayList) /* 106 */
#endif
#ifndef TkGetMainInfoList
#define TkGetMainInfoList \
	(tkIntStubsPtr->tkGetMainInfoList) /* 107 */
#endif
#ifndef TkGetWindowFromObj
#define TkGetWindowFromObj \
	(tkIntStubsPtr->tkGetWindowFromObj) /* 108 */
#endif
#ifndef TkpGetString
#define TkpGetString \
	(tkIntStubsPtr->tkpGetString) /* 109 */
#endif
#ifndef TkpGetSubFonts
#define TkpGetSubFonts \
	(tkIntStubsPtr->tkpGetSubFonts) /* 110 */
#endif
#ifndef TkpGetSystemDefault
#define TkpGetSystemDefault \
	(tkIntStubsPtr->tkpGetSystemDefault) /* 111 */
#endif
#ifndef TkpMenuThreadInit
#define TkpMenuThreadInit \
	(tkIntStubsPtr->tkpMenuThreadInit) /* 112 */
#endif
#ifndef TkClipBox
#define TkClipBox \
	(tkIntStubsPtr->tkClipBox) /* 113 */
#endif
#ifndef TkCreateRegion
#define TkCreateRegion \
	(tkIntStubsPtr->tkCreateRegion) /* 114 */
#endif
#ifndef TkDestroyRegion
#define TkDestroyRegion \
	(tkIntStubsPtr->tkDestroyRegion) /* 115 */
#endif
#ifndef TkIntersectRegion
#define TkIntersectRegion \
	(tkIntStubsPtr->tkIntersectRegion) /* 116 */
#endif
#ifndef TkRectInRegion
#define TkRectInRegion \
	(tkIntStubsPtr->tkRectInRegion) /* 117 */
#endif
#ifndef TkSetRegion
#define TkSetRegion \
	(tkIntStubsPtr->tkSetRegion) /* 118 */
#endif
#ifndef TkUnionRectWithRegion
#define TkUnionRectWithRegion \
	(tkIntStubsPtr->tkUnionRectWithRegion) /* 119 */
#endif
/* Slot 120 is reserved */
#ifdef MAC_OSX_TK /* AQUA */
#ifndef TkpCreateNativeBitmap
#define TkpCreateNativeBitmap \
	(tkIntStubsPtr->tkpCreateNativeBitmap) /* 121 */
#endif
#endif /* AQUA */
#ifdef MAC_OSX_TK /* AQUA */
#ifndef TkpDefineNativeBitmaps
#define TkpDefineNativeBitmaps \
	(tkIntStubsPtr->tkpDefineNativeBitmaps) /* 122 */
#endif
#endif /* AQUA */
/* Slot 123 is reserved */
#ifdef MAC_OSX_TK /* AQUA */
#ifndef TkpGetNativeAppBitmap
#define TkpGetNativeAppBitmap \
	(tkIntStubsPtr->tkpGetNativeAppBitmap) /* 124 */
#endif
#endif /* AQUA */
/* Slot 125 is reserved */
/* Slot 126 is reserved */
/* Slot 127 is reserved */
/* Slot 128 is reserved */
/* Slot 129 is reserved */
/* Slot 130 is reserved */
/* Slot 131 is reserved */
/* Slot 132 is reserved */
/* Slot 133 is reserved */
/* Slot 134 is reserved */
#ifndef TkpDrawHighlightBorder
#define TkpDrawHighlightBorder \
	(tkIntStubsPtr->tkpDrawHighlightBorder) /* 135 */
#endif
#ifndef TkSetFocusWin
#define TkSetFocusWin \
	(tkIntStubsPtr->tkSetFocusWin) /* 136 */
#endif
#ifndef TkpSetKeycodeAndState
#define TkpSetKeycodeAndState \
	(tkIntStubsPtr->tkpSetKeycodeAndState) /* 137 */
#endif
#ifndef TkpGetKeySym
#define TkpGetKeySym \
	(tkIntStubsPtr->tkpGetKeySym) /* 138 */
#endif
#ifndef TkpInitKeymapInfo
#define TkpInitKeymapInfo \
	(tkIntStubsPtr->tkpInitKeymapInfo) /* 139 */
#endif
#ifndef TkPhotoGetValidRegion
#define TkPhotoGetValidRegion \
	(tkIntStubsPtr->tkPhotoGetValidRegion) /* 140 */
#endif
#ifndef TkWmStackorderToplevel
#define TkWmStackorderToplevel \
	(tkIntStubsPtr->tkWmStackorderToplevel) /* 141 */
#endif
#ifndef TkFocusFree
#define TkFocusFree \
	(tkIntStubsPtr->tkFocusFree) /* 142 */
#endif
#ifndef TkClipCleanup
#define TkClipCleanup \
	(tkIntStubsPtr->tkClipCleanup) /* 143 */
#endif
#ifndef TkGCCleanup
#define TkGCCleanup \
	(tkIntStubsPtr->tkGCCleanup) /* 144 */
#endif
#ifndef TkSubtractRegion
#define TkSubtractRegion \
	(tkIntStubsPtr->tkSubtractRegion) /* 145 */
#endif
#ifndef TkStylePkgInit
#define TkStylePkgInit \
	(tkIntStubsPtr->tkStylePkgInit) /* 146 */
#endif
#ifndef TkStylePkgFree
#define TkStylePkgFree \
	(tkIntStubsPtr->tkStylePkgFree) /* 147 */
#endif
#ifndef TkToplevelWindowForCommand
#define TkToplevelWindowForCommand \
	(tkIntStubsPtr->tkToplevelWindowForCommand) /* 148 */
#endif
#ifndef TkGetOptionSpec
#define TkGetOptionSpec \
	(tkIntStubsPtr->tkGetOptionSpec) /* 149 */
#endif
#ifndef TkMakeRawCurve
#define TkMakeRawCurve \
	(tkIntStubsPtr->tkMakeRawCurve) /* 150 */
#endif
#ifndef TkMakeRawCurvePostscript
#define TkMakeRawCurvePostscript \
	(tkIntStubsPtr->tkMakeRawCurvePostscript) /* 151 */
#endif
#ifndef TkpDrawFrame
#define TkpDrawFrame \
	(tkIntStubsPtr->tkpDrawFrame) /* 152 */
#endif
#ifndef TkCreateThreadExitHandler
#define TkCreateThreadExitHandler \
	(tkIntStubsPtr->tkCreateThreadExitHandler) /* 153 */
#endif
#ifndef TkDeleteThreadExitHandler
#define TkDeleteThreadExitHandler \
	(tkIntStubsPtr->tkDeleteThreadExitHandler) /* 154 */
#endif
/* Slot 155 is reserved */
#ifndef TkpTestembedCmd
#define TkpTestembedCmd \
	(tkIntStubsPtr->tkpTestembedCmd) /* 156 */
#endif
#ifndef TkpTesttextCmd
#define TkpTesttextCmd \
	(tkIntStubsPtr->tkpTesttextCmd) /* 157 */
#endif
/* Slot 158 is reserved */
/* Slot 159 is reserved */
/* Slot 160 is reserved */
/* Slot 161 is reserved */
/* Slot 162 is reserved */
/* Slot 163 is reserved */
/* Slot 164 is reserved */
/* Slot 165 is reserved */
/* Slot 166 is reserved */
/* Slot 167 is reserved */
/* Slot 168 is reserved */
#ifndef TkStateParseProc
#define TkStateParseProc \
	(tkIntStubsPtr->tkStateParseProc) /* 169 */
#endif
#ifndef TkStatePrintProc
#define TkStatePrintProc \
	(tkIntStubsPtr->tkStatePrintProc) /* 170 */
#endif
#ifndef TkCanvasDashParseProc
#define TkCanvasDashParseProc \
	(tkIntStubsPtr->tkCanvasDashParseProc) /* 171 */
#endif
#ifndef TkCanvasDashPrintProc
#define TkCanvasDashPrintProc \
	(tkIntStubsPtr->tkCanvasDashPrintProc) /* 172 */
#endif
#ifndef TkOffsetParseProc
#define TkOffsetParseProc \
	(tkIntStubsPtr->tkOffsetParseProc) /* 173 */
#endif
#ifndef TkOffsetPrintProc
#define TkOffsetPrintProc \
	(tkIntStubsPtr->tkOffsetPrintProc) /* 174 */
#endif
#ifndef TkPixelParseProc
#define TkPixelParseProc \
	(tkIntStubsPtr->tkPixelParseProc) /* 175 */
#endif
#ifndef TkPixelPrintProc
#define TkPixelPrintProc \
	(tkIntStubsPtr->tkPixelPrintProc) /* 176 */
#endif
#ifndef TkOrientParseProc
#define TkOrientParseProc \
	(tkIntStubsPtr->tkOrientParseProc) /* 177 */
#endif
#ifndef TkOrientPrintProc
#define TkOrientPrintProc \
	(tkIntStubsPtr->tkOrientPrintProc) /* 178 */
#endif
#ifndef TkSmoothParseProc
#define TkSmoothParseProc \
	(tkIntStubsPtr->tkSmoothParseProc) /* 179 */
#endif
#ifndef TkSmoothPrintProc
#define TkSmoothPrintProc \
	(tkIntStubsPtr->tkSmoothPrintProc) /* 180 */
#endif
/* Slot 181 is reserved */
/* Slot 182 is reserved */
/* Slot 183 is reserved */
#ifndef TkUnusedStubEntry
#define TkUnusedStubEntry \
	(tkIntStubsPtr->tkUnusedStubEntry) /* 184 */
#endif

#endif /* defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS) */

/* !END!: Do not edit above this line. */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#if !defined(__WIN32__) /* && !defined(__CYGWIN__) */ && !defined(MAC_OSX_TK)

/*
 * These macros are just wrappers for the equivalent X Region calls.
 */
#   undef TkClipBox
#   undef TkCreateRegion
#   undef TkDestroyRegion
#   undef TkIntersectRegion
#   undef TkRectInRegion
#   undef TkSetRegion
#   undef TkSubtractRegion
#   undef TkUnionRectWithRegion

#   define TkClipBox(rgn, rect) XClipBox((Region) (rgn), (rect))
#   define TkCreateRegion() (TkRegion) XCreateRegion()
#   define TkDestroyRegion(rgn) XDestroyRegion((Region) (rgn))
#   define TkIntersectRegion(a, b, r) XIntersectRegion((Region) (a), \
(Region) (b), (Region) (r))
#   define TkRectInRegion(r, x, y, w, h) XRectInRegion((Region) (r), (x), (y), (w), (h))
#   define TkSetRegion(d, gc, rgn) XSetRegion((d), (gc), (Region) (rgn))
#   define TkSubtractRegion(a, b, r) XSubtractRegion((Region) (a), \
(Region) (b), (Region) (r))
#   define TkUnionRectWithRegion(rect, src, ret) XUnionRectWithRegion((rect), \
(Region) (src), (Region) (ret))
#endif /* !__CYGWIN__*/

#undef TkUnusedStubEntry
#if 0 // defined(__CYGWIN__) && defined(USE_TK_STUBS) && !defined(USE_TK_STUB_PROCS)
#   undef TkBindDeadWindow
#   define TkBindDeadWindow(winPtr) /* Removed from Cygwins stub table, just do nothing */
#endif

#endif /* _TKINTDECLS */

