/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.List;

public class OnConsoleStatusListener
extends ContextAwareBase
implements StatusListener,
LifeCycle {
    static final long DEFAULT_RESTROSPECTIVE = 300L;
    boolean isStarted = false;
    long retrospective = 300L;

    private void print(Status status) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStr(sb, "", status);
        System.out.print(sb);
    }

    public void addStatusEvent(Status status) {
        if (!this.isStarted) {
            return;
        }
        this.print(status);
    }

    private void retrospectivePrint() {
        long now = System.currentTimeMillis();
        StatusManager sm = this.context.getStatusManager();
        List<Status> statusList = sm.getCopyOfStatusList();
        for (Status status : statusList) {
            long timestamp = status.getDate();
            if (now - timestamp >= this.retrospective) continue;
            this.print(status);
        }
    }

    public void start() {
        this.isStarted = true;
        if (this.retrospective > 0L) {
            this.retrospectivePrint();
        }
    }

    public void setRetrospective(long retrospective) {
        this.retrospective = retrospective;
    }

    public long getRetrospective() {
        return this.retrospective;
    }

    public void stop() {
        this.isStarted = false;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public static void addNewInstanceToContext(Context context) {
        OnConsoleStatusListener onConsoleStatusListener = new OnConsoleStatusListener();
        onConsoleStatusListener.setContext(context);
        context.getStatusManager().add(onConsoleStatusListener);
    }
}

