
%% DocBy.\TeX{} -- nstroj na dokumentovn zdrojovch kd

\def\projectversion{\dbtversion}
\def\headtitle{DocBy.\TeX}

\showboxbreadth=1500 \showboxdepth=2

\input docby.tex

\title DocBy.\TeX{} -- nstroj na dokumentovn zdrojovch kd

\author Petr Olk

\centerline{\ulink[http://www.olsak.net/docbytex.html]%
                         {www.olsak.net/docbytex.html}}

\def\db{\dg\nb}
\def\du#1{\api{\nb#1}}
\let\quotehook=\langleactive
\def\insdef#1 {\ifirst{docby.tex}{def\nb#1 }{^^B\cbrace}{++}}
\def\inssdef#1 {\ifirst{docby.tex}{def\nb#1}{\empty}{+-}}
\bgroup
   \catcode`\[=1 \catcode`]=2 \catcode`\{=12 \catcode`\}=12
   \gdef\obrace[{] \gdef\cbrace[}]
\egroup
\def\indexhook{Kontroln sekvence oznaen ipkou ($\succ$) jsou
   uivatelskmi pkazy. Ostatn kontroln sekvence jsou 
   v~DocBy.\TeX{}u intern. Tun je oznaena strana, kde je slovo
   dokumentovno, pak nsleduje seznam stran s vskyty slova.
   Uivatelsk pkazy maj v seznamu strnek podtren slo, 
   co je strnka, kde je pkaz vyloen na uivatelsk rovni. 
   \medskip}
\def\nn#1 {\noactive{\nb#1}} \nn insert \nn undefined

\def\cnvbookmark#1{\lowercase{\lowercase{#1}}}
\def\bookmarkshook{\lo e \lo s \lo c \lo r \lo z \lo y
   \lo a \lo i \lo e \lo u \lo u \lo o \lo n }
\def\lo #1#2{\lccode`#1=`#2}

\dotoc \bookmarks

\sec vod
%%%%%%%%%

DocBy.\TeX{} umouje jednodue dokumentovat pomoc \TeX{}u 
zdrojov kdy programu napsanm v~jazyce~C ppadn v jakmkoli
jinm jazyce.

Na rozdl od Knuthova literrnho programovn tento nstroj nepouv
dn preprocesory nebo filtry pro oddlen informace pro lovka a
pro pota. Vychzm z toho, e programtor je zvykl pst tyto
informace oddlen a chce mt vci pod vlastn kontrolou. Rovn mnoz
programtoi uvtaj, e mohou pst dokumentaci dodaten, a pitom
skoro nezasahovat do u napsanho (a mon odladnho) zdrojovho
kdu.  Doba, kdy Knuth navrhoval literrn programovn, pokroila a
tvrce dokumentace dnes me mt zrove ve vce oknech oteveno vce
text.  Nkter jsou ureny pro lovka a jin pro pota. Nevnmm
tedy tak hlasitou potebu tyto informace sluovat do jednoho
souboru, jako tomu bylo kdysi.

V prvn sti (sekce~\cite[uziv]) dokumentu seznamujeme tene
s pouitm \docbytex{}u na uivatelsk rovni. V dal sekci jsou
dokumentovan vchoz makra \docbytex{}u, u nich se pedpokld, e
je bude chtt nron uivatel mnit, aby pizpsobil chovn \docbytex{}u
obrazu svmu. Dle nsleduje sekce~\cite[design] s dokumentac
maker, kter rovn budou mnna, pokud uivatel bude chtt jin
vzhled dokumentu. V~posledn sekci~\cite[implementace] 
je dokumentovn kompletn \docbytex{} na implementan rovni. 
Take se tam mete dost, jak makra funguj. 

Tento dokument je zpracovn \docbytex{}em, take slou mimo jin jako
ukzka, co je mon tmto nstrojem vytvoit.

\sec [uziv] Pro uivatele
%%%%%%%%%%%%%%%%%%%%%%%%%

\subsec [cleneni] lenn soubor
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\docbytex{} je implicitn navren pro dokumentovn zdrojovch kd 
v~jazyce~C. Proto i nsledujc ukzka dokumentuje hypotetick program
napsan v tomto jazyce. Chcete-li dokumentovat jin jazyk, mete
implicitn chovn \docbytex{}u pozmnit. Tomu je vnovna 
sekce~\cite[zmeny].

Pedpokld se, e zdrojov kdy programu jsou lenny na moduly. Kad modul
je mylenkov samostatn zleitost. Alespo pro programtora. Kad modul
m sv jmno (napklad "cosi") a je napsn v souborech "cosi.h" a "cosi.c",
ppadn v dalch. Tyto soubory se kompiluj, aby vznikl "cosi.o" a 
v~zvru kompilace se linkuj vechny kompilovan moduly do vslednho
programu.

Chceme-li takov zdrojov kdy dokumentovat, pipeme ke kadmu
modulu soubor s pponou ".d", napklad "cosi.d", kter obsahuje
dokumentaci k danmu modulu.  Dle zalome teba soubor
"program.tex", ze kterho postupn natme dokumentace jednotlivch
modul pomoc pkazu "\module"\du{module}. V \uv{hlavnm souboru} "program.tex"
meme t pout pkazy "\title" pro vyznaen nzvu programu,
"\author" se jmnem autora programu a teba "\dotoc" pro vytvoen
obsahu a "\doindex" pro vygenerovn rejstku. Samozejm zde meme
napsat teba vodn poznmky ke zdrojovm kdm programu a pout plno
dalch vymezovacch pkaz (viz dle). Obsah souboru "program.tex"
me vypadat teba takto:

\begtt
\input docby.tex
\title   Program lup -- dokumentace ke zdrojovm textm

\author  Progr a Mtor

\dotoc  % tady bude obsah

\sec lenn zdrojovch text

Zdrojov texty programu "lup" jsou rozdleny do t modul. 
V "base.c" jsou definovny pomocn funkce a v "base.h" jsou jejich
prototypy. Podobn ve "win.c" jsou funkce pro okenn zleitosti a
"win.h" obsahuje jejich prototypy. Konen "main.c" obsahuje hlavn
funkci programu.
\module base
\module win
\module main
\doindex  % v tomto mst bude sestaven rejstk
\bye
\endtt

V tomto pklad jsme se rozhodli tene dokumentace seznamovat s
programem \uv{zdola nahoru}, tedy od elementrnch funkc a k hotovmu
programu. Nkdo mon preferuje cestu \uv{shora dol} a me mt v
dokumentaci napsno:

\begtt
\module main
\module win
\module base
\doindex
\bye
\endtt

Oba pstupy jsou mon, protoe dokumentace je automaticky provzna
hyperlinky. ten se kdykoli me podvat na dokumentaci t funkce,
jej pouit zrovna te, a obrcen me projt vskyty vekerho
pouit funkce, kdy te jej dokumentaci.

\subsec [priklad] Pklad dokumentace modulu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Soubor s dokumentac jednotlivho modulu budu pro tento 
ppad znait "cosi.d". Ten je naten pkazem "\module"~"cosi ".
V souboru "cosi.d" je mono se literrn vydit a kdykoli vloit st 
existujcho zdrojovho kdu programu se stejnm jmnem modulu.
To provedeme pkazem "\ins"~"c keyword "\du{ins}, kter vlo do dokumentace
st zdrojovho kdu ze souboru "cosi.c", kter je vymezena pomoc slova 
"keyword". Msto psmene "c" je mono pout "h" nebo jakoukoli jinou
pponu souboru, ze kterho chceme vloit st do dokumentace. K
vymezen st, kter se maj vloit, je nutno mt ve zdrojovm
souboru text "//: keyword". Ve vysvtl nsledujc pklad.

Pedpokldejme, e v souboru "cosi.d" mme napsnu tuto dokumentaci:

\begtt
Struktura \dg dvojice se pouv jako nvratov hodnota funkce
"uzasna_funkce" a sdruuje dv hodnoty typu "float".
\ins c dvojice

Funkce \dg [struct dvojice] uzasna_funkce() si vezme jeden parametr "p" 
a vrt ve struktue "dvojice" dvojnsobek a trojnsobek tohoto parametru.
\ins c uzasna_funkce
\endtt

V tomto ppad je nutn, aby v souboru "cosi.c" existoval vymezujc
text "//: "{\tt dvojice} a text "//: "{\tt uzasna\_funkce}. 
Tyto texty vymezuj seky,
kter se maj do dokumentace vloit. Soubor "cosi.c" me vypadat
teba takto:

\begtt
#include <stdio.h>

//: dvojice

struct dvojice {
  float x, y;
};

//: uzasna_funkce

struct dvojice uzasna_funkce (float p)
{
  struct dvojice navrat;
  navrat.x = 2*p; // tady nasobim p dvema
  navrat.y = 3*p; // tady nasobim p tremi
  return navrat;
} 
\endtt

Vsledek po zpracovn sti dokumentace z "cosi.d" pak vypad takto:

\bigskip

Struktura \dg [struct] dvojice se pouv jako nvratov hodnota funkce
"uzasna_funkce" a sdruuje dv hodnoty typu "float".
\def\modulename{cosi}
\ins c dvojice

Funkce \dg [struct dvojice] uzasna_funkce() si vezme jeden parametr "p" a vrt
ve struktue "dvojice" dvojnsobek a trojnsobek tohoto parametru.
\ins c uzasna_funkce

V ukzkovm zdrojovm kdu je prvn vloen sek vymezen na
zatku textem "//: "{\tt dvojice} a na konci textem "//:". Druh sek je
vymezen textem "//: "{\tt uzasna\_funkce} a kon na konci souboru.

Na poad sek, kter zahrnujeme ze zdrojovho textu do dokumentace,
nezle. Klidn jsme mohli dokumentaci zat od povdn o asn
funkci (vetn vloen jejho kdu) a potom jet dopsat, co to je ta 
struktura "dvojice" a nsledn vloit deklaraci tto struktury.

Kdybychom ped dek "#include "{\tt<stdio.h>} vloili teba text
"//: start", bylo by mon pkazem "\ins"~"c start " vloit 
do dokumentace zatek souboru "cosi.c", kter v ukzce vloen nen.

Vimnme si, e \TeX{} zapsal sla dk pesn podle toho, jak
jsou ve zdrojovm kdu. Tj. potal i peskakovan dek 
"#include "{\tt<stdio.h>} i peskakovan przdn a vymezujc dky.

Vymezen "//: keyword" se me v dku nachzet kdekoli, nen nutn,
aby se vyskytovalo na zatku dku. dek s~tmto vymezenm nen do
dokumentace zahrnut a pokud nsleduje za dkem s~vymezenm przdn
dek, ani ten nen do dokumentace zahrnut. 

Stejn tak koncov vymezen "//:" se me v dku nachzet kdekoli a
cel dek s tmto vymezenm nen do dokumentace zahrnut. 
Pokud ped tmto koncovm dkem je przdn dek, ani ten 
nen do dokumentace zahrnut.

Konen za povimnut stoj pouit pkazu "\dg" v dokumentaci. Za
nm nsleduje slovo (separovan mezerou), kter dokumentujeme. Toto
slovo se v dokumentaci vrazn ozna (v PDF verzi ervenou barvou
navc v barevnm rmeku) a jakkoli jin vskyt takovho slova ve
zdrojovm textu nebo mezi uvozovkami {\tt\char`\"...\char`\"} bude
automaticky oznaen modrou barvou a bude klikac. Kliknut na modr
vskyt slova kdekoli v dokumentaci vrt tene na erven vskyt,
kde je slovo dokumentovno.

Dokumentovan slovo me mt ped sebou v hranatch zvorkch text,
kter nap. oznauje typ funkce a za sebou me mt kulat zvorky
"()".  Tm meme dt najevo, e dokumentujeme funkci. V mst
dokumentace se neobjev ani tento nepovinn text ani zvorky, ale v
poznmce pod arou a v~rejstku se tyto informace vytisknou.

\uv{Palcov uvozovky} {\tt\char`\"...\char`\"} vymezuj kusy kdu
uvnit odstavce. Text takto uvozen je psn strojopisem a pokud se 
v nm vyskutuj deklarovan slova, tato slova automaticky modraj
a stvaj se klikatelnmi odkazy.
Text mezi tmito uvozovkami je navc pepisovn ve \uv{verbatim}
mdu \TeX{}u, tj. dn znaky nemaj speciln vlastnosti (s vjimkou
koncov palcov uvozovky). 

Na strnce, kde je slovo dokumentovno (pomoc "\dg"), je v poznnkch
pod arou slovo znovu zmnno a vedle tto zmnky je seznam vech
strnek, na kterch se kdekoli v textu vyskytuje pouit tohoto slova.
Dle jsou vechna dokumentovan slova zahrnuta do zvrenho
abecednho rejstku, kter odkazuje jednak na strnku, kde je
slovo dokumentovno, i na strnky se vemi vskyty slova.


\subsec Jak \TeX{} pro \docbytex{}?
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Aby fungovaly vechny ve uveden vlastnosti, je poteba pout
pdf\TeX{} rozen o enc\TeX{}. Formt me bt "plain" nebo
"csplain". V takovm ppad se \docbytex{} ohls na terminlu
tmito slovy:

\def\begtthook{\catcode`\!=0}
\begtt
This is DocBy.TeX, version !dbtversion, modes: enc+PDF+plain
nebo:
This is DocBy.TeX, version !dbtversion, modes: enc+PDF+csplain
\endtt

\def\begtthook{}

\docbytex{} rozliuje ti mdy, kad me nabvat dvou stav:
md "enc/NOenc", dle md "PDF/DVI" a konen md "plain/csplain".

Md "enc"\api{enc} se zapne, je-li detekovna ptomnost enc\TeX{}u.
Pokud enc\TeX{} nen dostupn, vype o~tom \docbytex{} varovn a
pejde do "NOenc"\api{NOenc} mdu. V tomto mdu nefunguje automatick detekce
slov, kter jsou dokumentovna, take tato slova nemodraj a nestvaj
se klikacmi odkazy. V rejstku pak tak nen seznam strnek se vemi
vskyty slova, ale jen msto, kde je slovo dokumentovno.
V~tomto ppad tedy je deaktivovna nejdleitj vlastnost
\docbytex{}u, take je douc vynaloit jist sil a enc\TeX{}
zprovoznit. V souasnch distribucch \TeX{}u bv enc\TeX{}
zahrnut. Poznte to podle monosti pout pepna "-enc" v ppad
generovn formtu. Zajistte ve sv \TeX{}ov distribuci, aby byl v dob
generovn formtu tento pepna pouit. Jak to udlat zvis na
distribuci. Univerzln, ale ne pli elegantn postup, me vypadat
takto:

\begtt
generovn formtu:
pdfetex -enc -ini -jobname pdfcsplain csplain.ini
zpracovn dokumentu:
pdfetex -fmt pdfcsplain dokument.tex
\endtt

Formt samozejm mete generovat jen jednou a pkaz na zpracovn
dokumentu pak mete opakovat. Pokud postupujete podle ve uveden
ukzky, ulo se formt "pdfcsplain.fmt" s podporou enc\TeX{}u do
aktulnho adrese, odkud jej pkaz "pdfetex -fmt pdfcsplain" te.
Elegantnj asi je uloit formt nkam do \TeX{}ov distribuce, ovem
to je zvisl na pouit distribuci.

Md "PDF"\api{PDF} je detekovn, pokud je pouit pdf\TeX{}, jinak \docbytex{}
pejde do mdu "DVI"\api{DVI} a nape o tom varovn na terminl. V mdu "DVI"
nefunguj barvy ani klikac odkazy. Ovem seznam strnek s~pouitm
dokumentovanho slova se generuje, je-li ptomen enc\TeX.

\docbytex{} detekuje md "csplain"\api{csplain}, je-li pouit tento 
formt. V takovm ppad se zapne esk dlen slov a nkter nzvy
(nap. \uv{Rejstk}) jsou vypisovny v etin. Slovci mohou po
naten "docby.tex" pepnout do sloventiny pomoc "\shyph" a mohou si
tyto nzvy pedefinovat (viz sekci~\cite[nazvy]).
Pokud je pouit formt "plain",\api{plain} \docbytex{} zstane u vzor dlen
pro anglitinu a nzvy (nap. \uv{Index}) zstvaj anglick.

\subsec Vyhledvn slov enc\TeX{}em
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Slova, kter se stvaj klikatelnmi odkazy vyhledv enc\TeX{}. Ten
m zabudovn tzv. \uv{hladov algoritmus}. To znamen, e jsou-li
dokumentovna nap. slova "abc" a "abcde", pak text "abcdefgh" zmodr
a po psmeno "e" a odkazuje na "abcde", zatmco "abcdx" zmodr a po
psmeno "c" a odkazuje na "abc". To bv obvykle douc. 
%
V enc\TeX{}u nen mono programovat vyhledvn podle regulrnch
vraz, take nen mon jednodue ci, aby enc\TeX{} hledal jen
slova, kter jsou ohraniena mezerou, tekou, zvorkou, stednkem,
atd. Msto toho enc\TeX{} tup vyhled slovo teba uvnit jinho slova.

Me se tedy stt, e mme dokumentovno krat slovo, kter se
objevuje jako st jinch nedokumentovanch slov. Napklad je
dokumentovna struktura "turn", ale ve vpisech programu nechceme, aby
v kadm vskytu klovho slova "return" zmodrala jeho st. V
takovm ppad je poteba explicitn definovat "return" jako 
\uv{normln} nedokumentovan slovo. K tomu slou pkaz
"\noactive{<slovo>}"\du{noactive}, tedy napklad 
"\noactive{return}". Tento pkaz globln
deklaruje "<slovo>" jako vyhledvan slovo (pro enc\TeX), ale 
specifikuje jej jako neaktivn.

Me se tak stt, e mme dokumentovno slovo, kter se objevuje ve
zdrojovch textech i v jinm (nedokumentovanm) vznamu. Pitom dokumentovan
slovo poznme podle toho, jak vypad text ped slovem a za slovem.
Pak lze pout deklaraci "\onlyactive{<ped>}{<slovo>}{<za>}"\du{onlyactive}, 
kter sama o sob nedl nic. Pokud ale vyzname "<slovo>" pomoc
"\dg" (nebo podobnho makra na dokumentovn slov, viz
sekce~\cite[ddsl]), pak bude "<slovo>" automaticky modrat jen tehdy,
pedchz-li mu text "<ped>" a nsleduje text "<za>". Texty "<ped>"
nebo "<za>" mohou bt przdn (ne oba souasn) a k jednomu "<slovu>"
meme napsat vce rznch deklarac "\onlyactive".
 
\docbytex{} aktivuje enc\TeX{} (pomoc "\mubytein=1") jen uvnit
skupiny, kdy zpracovv text mezi palcovmi uvozovkami
({\tt\char`\"...\char`\"}) nebo pi natn zdrojovho textu
programu. Pedpokld se, e nepouvte enc\TeX{} k~dekdovn UTF-8
kdu. Pokud pouvte, zkuste si zapnout "\mubytein=1" pro cel dokument,
ale na {\it vlastn riziko}. V takovm ppad vm budou modrat slova
nebo jejich sti i v~bnm textu a pokud je dokumentovan slovo
podmnoinou njak \TeX{}ov sekvence, kterou pouvte, pak se
dokte nepjemnch chyb.

\subsec Generovn rejstku, obsahu, poznmek pod arou a zloek
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Generovn rejstku i obsahu probh v \docbytex{}u zcela
automaticky. Pro vytvoen rejstku nen nutn pouvat extern
program (\docbytex{} si slova abecedn zatd sm).
Sta tedy vloit na poadovan msta pkazy "\dotoc"\du{dotoc} a
"\doindex"\du{doindex}. Upozoruji, e rejstk ani obsah nejsou sprvn
vygenerovny po prvnm prchodu \TeX{}u. Je poteba \TeX{}ovat
dvakrt. Po druhm prchodu dojde zejm k pestrnkovn textu
(protoe je napklad vloen obsah). Je tedy nutn \TeX{}ovat jet
jednou. Ti prchody \TeX{}em jsou (snad) dostaujc.
Slovo \uv{snad} vychz z problmu s poznmkami pod arou podrobn
popsanm v sekci~\cite[specfootnote].
Poznmky pod arou se toti prbn v prchodech mn a ovlivuj
zptn vertikln sazbu. \docbytex{} proto provd na konci zpracovn
v pkaze "\bye"\du{bye} kontrolu, zda nedolo ke zmnm v referencch.
Je proto uiten pouvat "\bye" msto "\end".
V zvru zpracovn pak \docbytex{} vype zprvu 
"OK, all references are consistent" nebo vype
varovn, e nkter reference jsou nekonzistentn a 
e je tedy poteba \TeX{}ovat znovu.

Dal test konzistence meme provst napklad nsledujcm skriptem:

\begtt
#!/bin/bash
cp dokument.ref dokument.r0
pdfcsplain dokument.d
diff dokument.r0 dokument.ref
\endtt

\docbytex{} se sna (z dvodu zruky konvergence dokumentu) fixovat 
zpracovn poznmek pod arou po druhm prchodu. Pokud pot mnte
rozshle dokument, take seznamy strnek vedle poznmek pod arou jsou
vrazn jin dlky, \docbytex{} to nepozn a me dochzet 
k peplnn nebo nenaplnn strnek. V takovm ppad je rozumn
vymazat soubor {\tt.ref} a znovu spustit ti prchody.

Pro vytvoen zloek se strukturovanm obsahem v PDF vstupu slou
pkaz "\bookmarks"\du{bookmarks}. Je zcela jedno, v kter sti
dokumentu je tento pkaz napsan, nebo sestav stukturovan seznam
zloek prolinkovan s dokumentem na zklad daj ze souboru~{\tt.ref}.
Me se stt, e nkter texty v zlokch nejsou optimln iteln. O
monostech, jak toto eit, pojednv sekce~\cite[hooky].

\subsec [vkladani] Vkldn zdrojovch text podrobnji
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Krom jednoduchho pkazu "\ins" na vkldn zdrojovch text jsou 
k dispozici pkazy "\ifirst"\du{ifirst} a "\inext"\du{inext}, 
kter nabzej uivateli
daleko vce monost.

Pkaz "\ifirst{<soubor>}{<odkud>}{<kam>}{<jak>}" vlo do 
dokumentu st souboru "<soubor>" (pln nzev souboru vetn ppony)
od prvnho dku, na kterm se vyskytuje text "<odkud>" po
dek, na kterm se vyskytuje text "<kam>", nebo (pokud text "<kam>"
nelze nalzt) po konec souboru. Neexistuje-li ani dek s textem
"<odkud>", \docbytex{} vype pouze varovn na terminl.

Pkaz "\ifirst" si sv parametry nejprve 
expanduje a pak teprve pouije. 
Aktivn vlnka v parametru expanduje na mezeru.

Parametr "<jak>" udv, zda se bude tisknout vchoz dek (s~textem
"<odkud>") a koncov dek (s~textem "<kam>"). Tento parametr obsahuje
prv dva znaky (plus nebo mnus) s nsledujcm vznamem:

\begtt
jak:  --   netiskne se vchoz ani koncov dek
jak:  +-   tiskne se vchoz dek a netiskne se koncov dek
jak:  -+   netiskne se vchoz dek, tiskne se koncov dek
jak:  ++   tisknou se oba dky
\endtt

Je-li parametr "<odkud>" przdn (zapeme pomoc "{}"), tiskne se od
zatku souboru. Je-li parametr "<kam>" przdn, tiskne se jedin dek.
Je-li parametr "<kam>=\end",\du{end} tiskne se a do konce souboru.
Koncov dek v tomto ppad neexistuje. 

M-li parametr "<odkud>" (nebo "<kam>") hodnotu "\empty"\du{empty} 
(zapeme pomoc "{\empty}"), tiskne se od (nebo do) prvnho przdnho dku.
Parametr "<jak>" ovlivn jeho tisk.

Parametry "<odkud>" nebo "<kam>" mohou mt na svm zatku znak "^^B"
(tm dvme najevo, e text mus na dku zanat) nebo na svm konci
znak "^^E" (tm dvme najevo, e text mus na dku konit). Take
teba "^^Btext^^E" znamen, e se vyhledv dek, ve kterm je pouze
"text" a nic jinho.

V parametrech "<odkud>" a "<kam>" se nesmj vyskytovat speciln
\TeX{}ov znaky (speciln kategorie). Pro pouit znak
"\", "{", "}", "%" a {\tt\char`\"} v tchto parametrech jsou 
v~\docbytex{}u pipraveny zstupn kontroln
sekvence "\nb"\du{nb}, "\obrace"\du{obrace}, "\cbrace"\du{cbrace},
"\percent"\du{percent} a "\inchquote"\du{inchquote}. 
Sekvence pro dal speciln 
znaky "#", "$", atd. si muste vytvoit nap. pomoc:

\begtt
{\catcode`\#=12 \gdef\vezeni{#}}
\endtt

Jsou-li parametry "<odkud>" a "<kam>" stejn, nebo oba texty jsou na
stejnm dku, pak se pi "<jak>=++" nebo "<jak>=+-" vytiskne 
tento jeden dek. Pi "<jak>=-+" nebo "<jak>=--" se tiskne a 
do konce souboru nebo do dalho vskytu textu "<kam>". 

Pkaz "\ifirst" si zapamatuje nzev tenho souboru a pozici
poslednho petenho dku v~danm souboru. Pak je mon pout
pkaz "\inext{<odkud>}{<kam>}{<jak>}", kter zan hledat vchoz dek 
s textem "<odkud>" od msta v souboru, kde naposledy skonilo ten
pkazem "\ifirst" nebo "\inext". Parametry "<odkud>", "<kam>" a "<jak>"
maj stejn vznam, jako u pkazu "\ifirst".

V registru "\lineno"\du{lineno} je po ukonen pkazu "\ifirst" nebo "\inext"
slo dku, kter bylo naposledy peteno (tebae tento dek nebyl
vytitn). Pokud bylo dosaeno konce souboru, obsahuje "\lineno"
poet dk souboru. Pomoc "\ifeof\infile" je mon se zeptat, zda
bylo dosaeno konce souboru.

Pklady

\begtt
\ifirst {soubor.txt}{textik}{textik}{++}    % vytiskne prvn vskyt dku
                                            % obsahujc slovo textik
\inext {textik}{textik}{++}                 % vytiskne nsledujc vskyt
                                            % dku obsahujc slovo textk
\ifirst {soubor.c}{//: odkud}{//:}{--}      % analogie pkazu \ins
\ifirst {soubor.c}{funkce(}{)}{++}          % tisk prototypu funkce
\ifirst {soubor.c}{funkce(}{^^B\cbrace}{++} % tisk celho kdu funkce
\ifirst {soubor.txt}{}{\end}{++}            % tisk celho souboru
\ifirst {soubor.txt}{}{\empty}{+-}          % tisk po przdn dek
\endtt

Je-li prvn dek, kter se m tisknout, przdn, netiskne se. Je-li
posledn dek, kter se m tisknout, przdn, tak se netiskne. Toto
je implicitn chovn. Pokud napete "\skippingfalse",\du{skippingfalse} 
uveden inteligence je zruena a pepisuj se i przdn dky vpedu a vzadu.
Pkazem "\skippingtrue"\du{skippingtrue} se vrtte k pvodnmu nastaven.

Parametrm "<odkud>" a "<kam>" me pedchzet text 
"\count=<slo> ".\du{count} Hodnota "<slo>" oznauje,
kolikt vskyt textu "<odkud>" nebo "<kam>" se m pout.
Napklad "{\count=3 <odkud>}" znamen, e se m
pi vyhledvn "<odkud>" peskoit dva jeho vskyty a zat
pepisovat soubor a od vskytu tetho. Podobn "{\count=5 <kam>}"
zna, e se pi pepisovn souboru ignoruj tyi vskyty "<kam>" a
pepisovn se zastav a u vskytu ptho.

Implicitn, nen-li "\count=<slo> " uvedeno, pedpokld se
"\count=1 ". 

Pokud je text "<odkud>" przdn, pak
"\count" oznauje slo dku, na kterm se m zahjit vpis. Je-li
przdn parametr "<kam>", pak "\count" oznauje poet pepisovanch
dk. Toto plat pro "<jak>=++" a pro "\skippingfalse". 
Pi jinch hodnotch "<jak>" se
uveden sla logicky posunou o jedniku. Pi przdnm "<odkud>" nebo
"<kam>" nen mezera za "\count=<slo>" povinn. Pklady:

\begtt
\skippingfalse
\ifirst {soubor.txt}{\count=20}{\count=10}{++} % tisk dk 20 a 29
\ifirst {soubor.txt}{}{\count=2 \empty}{+-} % tisk po druh przdn dek
\ifirst {soubor.txt}{\count=50}{\end}{++}  % tisk od 50. dku do konce
\ifirst {soubor.tex}{\count=5 \nb section}{\count=2 \nb section}{+-}
                                    % tisk pt sekce z TeXovho souboru 
\endtt


\subsec [lineodkazy] Odkazy na sla dk
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Pomoc "\cite[<lejblk>]" je mon odkazovat na slo dku ve vpisu
zdrojovho kdu. Tento pkaz se promn na skuten slo dku.
Ped pouitm pkazu "\ifirst" nebo "\inext" je nutn "<lejblk>"
deklarovat pkazem "\ilabel [<lejblk>]{<text>}".\du{ilabel} 
Tchto pkaz me bt ped pouitm "\ifirst" resp. "\inext" vce.
Na poad pkaz "\ilabel" ped jednm "\ifirst" nebo "\inext" nezle.

Existuj-li deklarovan "<lejblk>"y a "<text>"y, pak pkaz 
"\ifirst" nebo "\inext" si vm vskytu "<text>"u ve vkldanch
dcch. Pokud takov "<text>" najde, piad slo dku
odpovdajcmu "<lejblk>"u, take pkaz "\cite" bude fungovat, jak m.

Parametr "<lejblk>" mus bt jednoznan v celm dokumentu. Pkaz
"\cite" funguje dopedn i zptn.

Pkazy "\ilabel" maj lokln psobnost a spolupracuj jen 
s nejblim nsledujcm "\ifirst" a "\inext".
Take ped pouitm dalho "\ifirst" resp. "\inext" 
je poteba deklarovat dal vyhledvan texty 
pomoc "\ilabel" znovu. 

\docbytex{} nevype dn varovn, pokud njak "<text>"
deklarovan v "\ilabel" nenajde. Ovem pi pouit "\cite" se objev
varovn, e nen znm "<lejblk>" a toto varovn nezmiz ani pi
opakovanm \TeX{}ovn. 

Pokud se "<text>" vyskytuje ve vce dcch ukzky, je odkazovn
dek s prvnm vskytem.

V nsledujc ukzce je ten ji znm soubor "cosi.c" 
(viz kapitolu~\cite[priklad]).

\begtt
Na dku~\cite[ufunkce] je deklarovan asn funkce.

\ilabel [ufunkce] {funkce (float}
\ilabel [navratx] {navrat.x}
\ifirst {cosi.c}{}{}{++}

Zvlt upozoruji na geniln mylenku na dku~\cite[navratx], 
kde je vstupn parametr vynsoben dvma. 
\endtt

\subsec Verbatim ukzky pomoc {\tt\nb begtt}/{\tt\nb endtt} a
        palcovch uvozovek
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Verbatim ukzky mete do dokumentace vkldat pomoc "\begtt"\du{begtt} a
"\endtt"\du{endtt}. Ty jsou (na rozdl od vkldanch soubor) napsny pmo ve
zdrojovm textu \TeX{}u.
Vechny dky za "\begtt" jsou vloeny beze zmn a po
ukonovac "\endtt". dky nejsou slovny a texty v nich nemodraj a
nestvaj se klikatelnmi odkazy.

Nsledujc sekce~\cite[hooky] a~\cite[begtt] obsahuj informace,
jak je mon toto implicitn chovn zmnit.

Verbatim ukzky uvnit odstavce lze vymezit palcovmi uvozovkami
{\tt\char`\"...\char`\"}. V tomto prosted probh tisk strojopisem a
je aktivn enc\TeX{}, take dokumentovan slova se stvaj 
automaticky odkazy na msto, kde je "\dg". Doporuuje se toto
prosted pouvat na vpisy vekerch st kd dokumentovanho
programu, kter jsou vloeny uvnit textu v odstavci (analogie
matematickho prosted "$...$").

\subsec [ddsl] Deklarace dokumentovanho slova
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Na deklaraci slova, kter dokumentujeme, lze pout pkaz "\dg",\du{dg}
"\dgn",\du{dgn} "\dgh",\du{dgh} "\dl",\du{dl} "\dln"\du{dln} 
nebo "\dlh"\du{dlh}. Vznamy jednotlivch
pkaz vysvtlme pozdji. Nejprve se vnujme syntaxi parametr.
Vechny pkazy maj stejnou syntaxi, take nebude vadit, kdy bude
vyloena jen v souvislosti s pkazem "\dg". Syntaxe je ponkud
zvltn. elem toti bylo minimalizovat prci psae, take jsem se
vyhnul kueravm zvorkm, parametr separuji podle mezery nebo neho
jinho, atd.

Existuj tyto monosti syntaxe parametr:

\def\begtthook{\langleactive \mubytein=1}
\begtt
\dg <slovo>            % <slovo> separovan mezerou
\dg [<text>] <slovo>    % navc nepovinn "pedn" <text>
\dg [<text>]<slovo>     % <slovo> me na [<text>] navazovat bez mezery
\dg <slovo>()          % <slovo> s dvojic "()" separovan mezerou
\dg [<text>]<slovo>()   % kombinace pedchozho
\dg <slovo>,           % <slovo> separovan rkou
\dg [<text>] <slovo>,   % kombinace pedchozho
\dg <slovo>(),         % <slovo> s dvojic "()" separovan rkou
\dg [<text>]<slovo>(),  % kombinace pedchozho
\dg <slovo>.           % slovo separovan tekou
atd...
\endtt
\def\begtthook{}

Obecn: za pkazem "\dg" me nsledovat nepovinn "[". Pokud
nsleduje, pak se pete "<text>" a po ukonovac "]". Parametr
"<text>" me obsahovat mezery. Za ukonovac "]" me a nemus bt
mezera. Pokud tam je, pak ji makro pesune ped koncovou zvorku "]",
take "\dg"~"[aha] slovo" je tot jako "\dg"~"[aha ]slovo".
Dle nsleduje ten parametru "<slovo>". 
Tento parametr nesm obsahovat mezeru, rku, teku, stednk
a dvojteku. ten parametru je ukoneno, jakmile se objev mezera
nebo rka nebo teka nebo stednk nebo dvojteka. Uveden
interpunkce nen soust parametru "<slovo>" a po zpracovn parametru
se vrt do vstupn fronty, take se bn vytiskne.
Nakonec se zjist, zda peten parametr a po separtor nen ve tvaru
"<slovo>()". Pokud je, pak symbol "()" se nepovauje za soust
parametru "<slovo>", ale mluvme o "<slovu>" nsledovanm dvojic~"()".

Pozor, za separtorem typu rka, teka, stednk a dvojteka se mus
vyskytnout mezera. Ne nutn ihned, ale dve, ne se objev sek
textu, kter m bt peten s jinmi kategoriemi 
(nap.~{\tt\char`\"...\char`\"}). Nen tedy mon pst 
"\dg" {\tt text,\char`\"...\char`\"}.
Pokud za separtorem mezera nsleduje znak {\tt\char`\`} (obrcen
apostrof), mezera ani tento znak se netiskne. To je mon vyut
napklad pro vloen nezlomiteln mezery nebo pro jin ely: 
"\dg"~"<slovo> `~<pilepen text>"
nebo "\dg"~"<slovo> `"{\tt\char`\"...\char`\"}.

Pkazy "\dgh", "\dgn", "\dln", "\dlh" separujc mezeru 
netisknou nikdy, protoe tyto pkazy vtinou netisknou nic (viz ne).

Parametr "<slovo>" je dokumentovan slovo. Pokud se takov "<slovo>"
vyskytne nkde jinde v dokumentu mezi {\tt\char`\"...\char`\"} nebo ve
vloenm zdrojovm kdu, automaticky zmodr a stv se klikatelnm
odkazem na msto, kde je pouito "\dg". V mst pouit "\dg" je slovo
zvraznno ervenou barvou. Je vytitno samotn bez parametru
"<text>" a bez ppadnch zvorek "()". V poznmce pod arou se vype
"<slovo>" (erven). Tam je i ppadn "<text>" (ped slovem) a za nm
je ppadn dvojice "()". Vedle tohoto vpisu je
seznam strnek s vskyty "<slova>". V rejstku se objev nco podobnho,
jako v poznmce pod arou. Rejstk je azen abecedn podle "<slovo>",
nikoli podle "<text>".

Pkaz "\dg" deklaruje "<slovo>" globln. Bude na nj odkazovno v celm
dokumentu. 

Pkaz "\dgh" pracuje jako "\dg", ale slovo nebude v mst "\dgh"
vypsno ("\dg" hidden). Bude tam jen cl odkaz a "<slovo>" 
se objev v poznmce a v rejstku. 

Pkaz "\dgn" zpsob, e prvn nsledujc vskyt
"<slova>" ve vypisovanm zdrojovm kdu 
se stane clem vech ostatnch odkaz, zerven (tedy
nezmodr) a v mst tohoto vskytu se objev pslun poznmka pod
arou. Pkaz "\dgn" teme jako "\dg" next, nebo "\dg" nsledujc.

Pkaz "\dl" deklaruje "<slovo>" lokln. Bude na nj odkazovno svm
krtkm jmnem "<slovo>" jen v mst stejnho jmennho prostoru,
typicky pi dokumentaci jednoho modulu. Kad modul zahjen pkazem
"\module" zavd jmenn prostor tvaru "<slovo>./<nzev>", kde
"<nzev>" je jmno modulu. Slovo deklarovan pomoc "\dl" ije ve dvou
variantch. V krtk variant jako "<slovo>" jen v rozsahu jednoho
jmennho prostoru a v dlouh variant "<slovo>./<nzev>" ije globln
v celm dokumentu. Ppadn vskyt dlouhho nzvu odke na msto
deklarace nap celm dokumentem.

Podrobnji o jmennch prostorech a monosti jejich zmny najdete 
v~sekci~\cite[jmenneprostory]. 

Kad "<slovo>" mus bt v dokumentu deklarovno nejve jednou, jinak
\docbytex{} ohls chybu. V ppad "\dl" mus existovat
jednoznan dlouh nzev.

Pkaz "\dlh" je skryt "\dl". Pkaz "\dln" znamen "\dl" next.
Analogicky, jako pkazy "\dgh" a "\dgn".

Pokud nkoho irituje vysok inteligence tchto pkaz pi ten
parametr, me pout intern verzi pkaz s povinnmi temi
parametry obalenmi do kueravch zvorek: "\iidg",\du{iidg} 
"\iidgh",\du{iidgh} "\iidgn",\du{iidgn} 
"\iidl",\du{iidl} "\iidlh",\du{iidlh} "\iidln".\du{iidln} 
Parametry vypadaj
takto: "\iidg{<ped>}{<slovo>}{<za>}". Pravda, tyto pkazy umouj
vce ne jejich krtk verze: umouj do parametru "<slovo>"
propaovat rku, mezeru, stednk atd. a do parametru "<za>" napsat
cokoli, nejen kulat zvorky.
 

\subsec [jmenneprostory] Jmenn prostory
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Jmenn prostor je pravidlo, podle kterho se krtk nzev
dokumentovanho "<slova>" transformuje pi pouit "\dl"
na nzev dlouh. Je mon jej nastavit nebo zmnit pomoc pkazu
"\namespace"\du{namespace}, kter se pouije takto:
"\namespace" "{<text1>#1<text2>}...\endnamespace".\du{endnamespace} 
Pokud je uvnit tohoto prosted pouit pkaz 
"\dl<slovo>", je slovu pidlen krtk nzev "<slovo>" a dlouh nzev 
"<text1><slovo><text2>". 
Uvnit takto deklarovanho prosted se vechny vskyty
krtkho nzvu "<slovo>" transformuj na dlouh nzev a jsou
prolinkovny s odpovdajcm mstem "\dl". Jmenn prostor je lokln
uvnit svho prosted, take vn prosted se "<slovo>"
chov, jakoby nebyl dn pkaz "\dl" pouit.
Napklad uvnit prosted "\namespace"~"{#1//uff}...\endnamespace" je ke
kadmu slovu deklarovanmu pomoc "\dl<slovo>" pidlen dlouh nzev 
"<slovo>//uff" a vskyty "<slovo>" odkazuj na msto "\dl<slovo>". 

Vn vech prosted "\namespace...\endnamespace" nen jmenn prostor definovn, 
take tam nen mon pout pkaz "\dl". 
Ovem pkaz "\module"~"<nzev> " nastav jmenn
prostor na "{#1./<nzev>}", take uvnit dokumentace modulu
je mon pouvat pkaz~"\dl".

V rejstku a v poznmce pod arou se tisknou dlouh nzvy. Rejstk
abecedn ad podle dlouhch~nzv. V obsahu se tisknou nzvy krtk.

Pklad prce se jmennmi prostory:

\begtt
\namespace {ju::#1}   %% nastavuji namespace ju
Tady deklaruji slovo \dl aha.
Tady slovo "aha" automaticky odkazuje na msto deklarace.
Slovo "ju::aha" tak odkazuje na msto deklarace.
\endnamespace
\namespace {hele::#1} %% nastavuji namespace hele
Tady znovu deklaruji slovo \dl aha.
Zde slovo "aha" odkazuje na lokln deklaraci uvnit "hele"
\endnamespace         %% rum namespace
Zde slovo "aha" neodkazuje nikam, ale slova "ju::aha"
a "hele::aha"  stle odkazuj na msta, kde byla deklarovna.
\endtt

Prosted "\namespace...\endnamespace" je mon vnoovat, ovem vnoen 
prosted musej mt jin jmenn prostor ne prosted vnj. Prosted 
jmennch prostor pracuj globln nezvisle na "\bgroup", "\egroup".
Pkaz "\endnamespace" pouit vn vech prosted 
"\namespace...\endnamespace" neudl nic. Prosted nen nutn ped 
pkazem "\bye" ukonovat.


\subsec Msto pro dokumentaci aplikanho rozhran
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Me se stt, e peme dokumentaci jednak pro uivatele, kter zajm
zpsob pouit dokumentovanch funkc a co zhruba dlaj (tzv.~API),
ale nezajm je, jak je funkce naprogramovan. Druhak chceme mt
dokumentovn i zpsob, jak funkce funguje uvnit. V takovm ppad
mus dokumentovan "<slovo>" odkazovat na dv msta v dokumentu. 

Msto, kde je podrobn "<slovo>" popsno, je vymezeno pkazem "\dg"
nebo podobnm. Msto, kde slovo dokumentujeme pro uivatele (je-li
toto msto odlin od prvnho msta), lze vyznait pkazem
"\api{<slovo>}"\du{api}. V mst pouit "\api{<slovo>}" se nestane
nic, jen se tam umst neviditeln cl odkaz. V obsahu se pak
"<slovo>" objev s odkazem na toto msto. V rejstku se v seznamu
strnek objev jedna strnka podtren: to je strnka, kde byl pouit
pkaz~"\api{<slovo>}". Ovem, aby se v rejstku "<slovo>" vbec
objevilo, mus se nkde v dokumentu vyskytovat i jeho pln deklarace
pomoc "\dg" nebo podobnch pkaz. Na strnce, kde je pouito "\dg",
je pod arou vedle slova seznam strnek a rovn je tam jedna strnka
podtren. Kdy tete implementan popis pro "<slovo>", snadno se
tedy dostanete na strnku, kde je API k tomuto "<slovu>".  V~rejstku
a obsahu jsou tak slova, kter byla deklarovan pomoc "\api", zleva
vyznaena textem "\apitext"\du{apitext}. Ten je implicitn nastaven na
ipku. Mete se podvat do rejstku a do obsahu tohoto dokumentu. V
tomto mst bylo pouito "\api{\nb api}", zatmco skuten definice
pkazu "\api" je v sekci~\cite[reference].

Je-li pouito "\api{<slovo>}", pak je mon se na msto odkazovat tak
pomoc "\cite[+<slovo>]". Tato konstrukce se promn v slo strnky,
kde je dokumentovno API danho slova. Napklad v tomto dokumentu
se "\cite[+\nb api]" promn na:~\cite[+\nb api]. 

Pokud toto slovo m tak svj API cl (vytvoen pomoc
"\api"), pak se erven text (titn v mst "\dg") 
stv aktivnm odkazem na API cl. Tam
typicky ten najde vskyt slova, kter je zase klikatelnm odkazem
na "\dg" cl. Take tyto dva cle jsou prolinkovny kem.

\subsec [kapsec] Sekce, sekciky, st, titul
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Sekce se uvozuj pkazem "\sec"~"<nzev sekce>\par"\du{sec}. Kad
sekce me mt nkolik podsekc (sekciek), kter lze vyznait
pkazem "\subsec"~"<nzev podsekce>\par"\du{subsec}. 
Symbol "\par" zde znamen,
e nzev sekce i podsekce je oddlen od dalho textu przdnm
dkem (viz ukzku v~\cite[cleneni]).

Nkolik sekc me tvoit st. st je uvozena pkazem
"\part"~"<nzev sti>\par"\du{part}. sti jsou automaticky oznaeny
psmeny A,B,C,\dots a jsou vyznaeny vraznji ne sekce v~mst
zatku sti i v~obsahu. sti ale nenaruuj slovn
sekc. Tj. sekce jsou slovny od jedn nap celm dokumentem bez
ohledu na to, zda jsou nebo nejsou rozdleny na sti.

Pkaz "\module <soubor> " automaticky zalo sekci s nzvem
"Modul <soubor>" a deklaruje svj jmenn prostor.
Toto chovn lze zmnit, viz~\cite[nazvy], \cite[module].

Pkaz "\title<nzev>\par"\du{title} vytiskne nzev dokumentu vtm psmem a v
rmeku. Je-li definovno makro "\projectversion"\du{projectversion},
bude jeho obsah vytitn drobn vpravo nahoe doplnn zepedu textem 
"verze".  Pokud v projekt nem verzi, me se hodit teba: 

\begtt
\def\projectversion{\the\day. \the\month. \the\year}
\endtt

Pkaz "\author<text>\par"\du{author} nape do 
stedu dku tun "<text>",
co bv obvykle jmno autora (jmna autor).

Do zhlav kad strnky se zane pepisovat zleva nzev aktuln
sekce a zprava nzev dokumentu. Uivatel me text pro prav zhlav
zmnit zmnou makra "\headtitle"\du{headtitle}.

Pkazy "\sec" a "\subsec" mohou mt v hranat zvorce nepovinn
parametr "<lejblk>". V takovm ppad vypadaj parametry takto:
"\sec"~"[<lejblk>] <nzev sekce>\par". Po takovm pouit je mon
se na sekci (podsekci) odkazovat pkazem "\cite[<lejblk>]". Tento pkaz se
promn v slo odkazovan sekce (podsekce) a navc se stane
aktivnm odkazem.

Pomoc pkazu "\savetocfalse"\du{savetocfalse} lze ped pouitm 
pkazu "\sec" nebo "\subsec" zajistit, e nzev sekce se 
nedostane do obsahu a nebude mt sv slo. Msto sla se 
vytiskne obsah makra "\emptynumber"\du{emptynumber}, kter je
implicitn przdn. Pkaz "\savetocfalse" ovlivn jen
prvn nsledujc "\sec" nebo "\subsec".

\subsec [krizodkaz] Kov odkazy
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Cl, kam smuje odkaz, je poteba vyznait pomoc "<lejblku>".
To je mon udlat v pkaze "\sec", "\subsec" (viz pedchoz 
sekci~\cite[kapsec]) nebo kdekoli v textu samostatnm pkazem
"\label[<lejblk>]"\du{label}. Tak je mon odkazovat na slo dku
(viz sekci~\cite[lineodkazy]).
Vechny lejblky musej bt jednoznan (bez ohledu na jejich typ)
nap celm dokumentem.

Pkaz "\pgref[<lejblk>]"\du{pgref} expanduje na slo strany, na kter se
vyskytuje cl odkazu. Pkaz "\numref[<lejblk>]"\du{numref} expanduje 
v~zvislosti na typu cle na:

\begitems
\item * slo sekce, je-li clem sekce,
\item * dvojsl "<sekce>.<podsekce>", je-li clem podsekce,
\item * slo dku, je-li clem dek zdrojovho kdu,
\item * przdn makro, je-li "<lejblk>" deklarovan pomoc "\label".
\enditems

Oba pkazy "\pgref" a "\numref" expanduj na uveden texty bez dal
inteligence. Tj. vstupn text se nestv klikatelnm odkazem. 

K aktivaci odkazu v PDF mdu slou 
makro "\ilink"~"[<lejblk>]{<text>}"\du{ilink}. Toto makro vytiskne mode
"<text>", kter se stv klikatelnm odkazem na cl, deklarovan
pomoc "<lejblku>". Take ji znm pkaz "\cite[<lejblk>]"\du{cite}
udl zhruba to sam, jako "\ilink[<lejblk>]{\numref[<lejblk>]}".
Skuten pkaz "\cite" navc ov, zda nen "\numref[<lejblk>]"
przdn makro. Pokud je, obarv namsto vstupu "\numref" 
vstup makra "\pgref".

Pokud "<lejblk>" jako argument pkazu "\pgref", "\numref" nem svj
cl, pkaz "\pgref" expanduje na hodnotu $-1000$ a "\numref"
expanduje na przdn vstup. Jsou to expanzn makra, take v nich nen
implementovn napklad tisk varovn. Podvejte se na definici
pkazu "\cite" (na stran~\cite[@\nb cite]), jak se d tisk varovn
implementovat.

Makro "\module"~"<jmno> " zalo sekci s lejblkem "m:<jmno>", take
lze na n pak odkazovat. Napklad si mete vytvoit makro

\begtt
\def\refmodul[#1]{\ilink[m:#1]{\tt#1}}
\endtt
%
kter aktivizuje svj parametr, pokud tento je nzvem njakho
modulu. Teba "\refmodul[base]" vytiskne slovo "base" strojopisem a
mode a stv se klikatelnm odkazem na zatek sekce
\uv{Modul base}, pokud je tato sekce zaloena pkazem "\module".

Makra "\dg", "\dgn", "\dgh" intern provedou pkaz "\label[@<slovo>]"
a makra "\dl", "\dln", "\dlh" provedou pkaz 
"\label[@<dlouh slovo>]", kde "<dlouh slovo>" je "<slovo>" 
po transformaci podle aktulnho jmennho prostoru.
Na msta, kde jsou slova dokumentovan, je tedy mon odkazovat
napklad pomoc 
"\link[@<slovo>]{<slovo> dokumentovan na stran~\pgref[@<slovo>]}". 

Makro "\api{<slovo>}" intern provede "\label[+<slovo>]", take je
mon na toto msto odkazovat teba pomoc 
"\ilink[+<slovo>]{API: <slovo>}".

\docbytex{} nenabz krom sel sekc, podsekc a sel dk dn dal
automatick slovn. Pokud tedy chcete implementovat nap. slovn
obrzk, sla publikac atd., muste si napsat makra vlastn.
K tomu mete vyut makro
"\labeltext[<lejblk>]{<text>}"\du{labeltext}, kter ulo v
horizontlnm mdu do sazby neviditeln cl odkazu, a pi dalm
prchodu \TeX{}em expanduje makro "\numref" na "<text>".
Pouit makra ukeme na pklad, ve kterm definujeme makro 
"\bib[<lejblk>]". Toto makro zahj sazbu dal poloky v seznamu
literatury. Odkazovat na knihu pak lze pomoc "\cite[b:<lejblk>]".

\begtt
\newcount\bibnum
\def\bib [#1]{\par\advance\bibnum by1 \indent
    \llap{[\the\bibnum] }\labeltext[b:#1]{[\the\bibnum]}\ignorespaces}
\endtt

\subsec Vkldn obrzk
%%%%%%%%%%%%%%%%%%%%%%%%

Pkazem "\ifig" "<ka> <jmno obrzku> "\du{ifig} je mon vloit obrzek.
Obrzek mus bt pipraven v souboru "fig/<jmno obrzku>.eps" (v ppad
DVI mdu) a v souboru "fig/<jmno obrzku>.pdf" (v~ppad PDF mdu). 
Adres, kde \docbytex{} vyhledv obrzky ("fig/"), lze zmnit 
pedefinovnm sekvence "\figdir"\du{figdir} . Rozmr "<ka>" 
je bez jednotky a udv pomr poadovan ky obrzku ku 
ce sazby. Obrzek je umstn zarovnn doleva na odstavcovou zarku.

Mte-li pipraven obrzek ve formtu "eps", pak jej do "pdf" pevedete
pkazem

{\def\begtthook{\langleactive}
\begtt 
ps2pdf -dEPSCrop <jmno obrzku>.eps
\endtt
\par}

\subsec Vty
%%%%%%%%%%%%%

Seznam poloek obklopte "\begitems"\du{begitems} a
"\enditems"\du{enditems}. V tomto prosted je text odsazen zleva 
o~odstavcovou zarku. Prosted lze vnoovat. Jednotlivou poloku
zahjte pomoc "\item"~"<znaka> <text>",\du{item} 
pitom "<znaka>" se
vystr vlevo od "<textu>". Je-li "<znaka>" hvzdika, promn se v
puntk. Dal monost: "\item"~"\the\itemno) <text>",\du{itemno} 
co vytvo slovan vty, v kadm prosted slovny od jedn.

Makro plainu "\item" nen pedefinovno globln, ale jen uvnit
"\begitems...\enditems". Mete tedy pout i makro plainu,
pokud se vm koncept poloek nabzen \docbytex{}em nelb.


\noactive{/*}\noactive{*/}\noactive{//} 
\setlinecomment{\percent} \noactive{\nb\percent} \noactive{\percent\cbrace}


\sec [zmeny] Pro nron
%%%%%%%%%%%%%%%%%%%%%%%%

V tto sekci jsou uvedeny a vysvtleny definice zkladnch 
pkaz \docbytex{}u. Uivatel si me tyto definice zmnit, pokud chce
zmnit chovn \docbytex{}u. Pokud napklad pracuje s jinm
programovacm jazykem, me si zmnit makro "\docsuffix" nebo
kompletn pedefinovat makra "\module" a "\ins".

\subsec [nazvy] Intern nzvy
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Pkazem "\doindex" vytvo \docbytex{} automaticky novou
sekci s nzvem \uv{Rejstk}. Podobn pi tvorb obsahu nebo nataen
modulu vznik nzev \uv{Obsah} nebo \uv{Modul}. Ped nzvem verze 
v~titulu pi pouit "\projectversion" se objev slvko \uv{verze}.
st (vytvoen pomoc "\part") m v zlokch uvozujc text 
">> CAST".
Tyto texty jsou definovny v makrech
\db titindex, \db tittoc, \db titmodule, \db titversion a \db opartname.

\ifirst {docby.tex}{Intern}{\empty}{--}

Za povimnut stoj, e jsou jinak tato makra definovna pi pouit
klasickho "plain"u a jinak pi pouit "csplain"u. To ovem
neznamen, e uivatel si tyto nzvy neme pedefinovat jet jinak,
nezvisle na pouitm formtu.

\subsec [hooky] Vloen skupiny pkaz (hooks)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nkter sloitj makra ("\begtt", palcov uvozovky, "\ifirst",
"\inext", "\doindex", "\dotoc") dovoluj vkldat uivateli na zatku
zpracovn rzn pkazy (tzv.~hooks). Implicitn
jsou tyto vloky przdn:

\ifirst {docby.tex}{begtthook}{\empty}{+-}

Makro \db begtthook je vloeno po zaloen skupiny a nastaven vech
kategori tsn ped zatkem zpracovn prosted "\begtt...\endtt".
Makro \db quotehook je vloeno po zaloen skupiny a nastaven vech
kategori tsn ped zatkem zpracovn prosted {\tt\char`\"...\char`\"}.
Makro \db indexhook je vloeno makrem "\doindex" po zaloen sekce
a ped pechodem do sazby ve dvou sloupcch. V tomto dokumentu je v
nm vodn povdn k rejstku. 
Makro \db tochook je vloeno makrem "\dotoc" po zaloen sekce
ped sazbou prvnho dku obsahu.
Makro \db bookmarkshook je vloeno uvnit skupiny na zatku
zpracovn zloek. Je mon v nm nastavit expanze maker
vyskytujcch se v nadpisech na rozumnou hodnotu pro zloky.
Pokud navc nastavte "\let\cnvbookmark=\lowercase", budou vechny
znaky pro zloky prochzet filtrem "\lowercase". Uvnit
"\bookmarkshook" je pak mon nastavit "\lccode" vybranm znakm
(napklad pro odstrann hk a rek).
Makro \db outputhook je vloeno na zatek vstupn rutiny. Je vhodn
v nm nastavit vybran pkazy na hodnotu "\relax", aby se
neexpandovaly do souboru {\tt.ref}.

Pklady pouit

\bgroup
\catcode`'13 \def'{\nb} \catcode`?=13 \def?{<} 
\def\begtthook{\langleactive\mubytein=1}
\begtt
\def\quotehook{\obeyspaces}   % ve vpisech "..." budou normln mezery
\def\quotehook{\langleactive} % ?text> se promn na <text>
\def\begtthook{\mubytein=1}   % mezi 'begtt...'endtt bude aktivn encTeX
\def\begtthook{\setsmallprinting} % ukzky 'begtt...'endtt budou mal
\def\begtthook{\catcode`\!=0} % mezi 'begtt...'endtt funguj !prikazy
\def\indexhook{To ubrnte, jak tu mm rejstk.}
\def\outputhook{\let\mylogo=\relax} % \mylogo nebude expandovat
\endtt
\par
\egroup

\subsec [module] Pkaz {\tt\nb module} a {\tt\nb ins}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Uivatelsk dokumentace k tmto pkazm je v sekci~\cite[cleneni].
Pkaz \db module "<soubor> " nate soubor s nzvem 
"<soubor>\docsuffix", kde makro
\db docsuffix obsahuje pponu souboru vetn teky.

\ilabel [linkincomment] {extension}
\insdef docsuffix  

Pkaz "\module" vlo nzev tenho souboru (bez ppony) 
do pomocnho makra
\db modulename. Toto makro pak vyuv pkaz 
\db ins "<pripona> <text> ".

\inssdef ins

\subsec Zelenajc komente
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Pkazy "\ifirst" a "\inext" si tak vmaj (implicitn) C koment
tvaru "//..<eol>" a "/* .. */". Tyto komente barv ve vpisu
programu zelen. Zruit tuto vlastnost lze pkazem "\noactive<string>".
Pomoc \db setlinecomment "{<string>}" lze nastavit nov typ koment, 
kter budou barveny zelen od "<string>" do konce dku. Pkazy maj globln
platnost. Napklad

{\def\begtthook{\mubytein=1}
\begtt
\noactive{/*}\noactive{*/}\noactive{//} 
\setlinecomment{\percent} \noactive{\nb\percent}}
\endtt
\par}
\noindent
nastav komente podle zvyklost v \TeX{}u a PostScriptu.

Pkazem \db setlrcomment "{<lev>}{<prav>}"
lze nastavit komente typu "/*...*/".

Pro zmnu vlastnost obarvovn koment sta uveden makra
pout. Kdo chce vdt, jak jsou implementovan, nech te dle.

\inext {mubyte}{\empty}{+-}

Uveden pkazy jsou przdn v mdu bez enc\TeX{}u a pi
detekci enc\TeX{}u zap informace do enc\TeX{}ov tabulky
prostednictvm primitiv "\mubyte...\endmubyte".

Pkazy \db linecomment a \db leftcomment se dky enc\TeX{}u
automaticky vlo ped detekovanou sekvenci znak. Tyto 
pkazy nastav barvu textu na zelenou:

\inext {linecomment}{\empty}{+-}

Na druh stran pkaz \db rightcomment potebuje vypnout zelenou barvu
a po peskoen detekovan sekvence. Proto enc\TeX{} v tomto ppad
detekovanou sekvenci zru a pkaz "\rightcomment" m za kol ji vrtit
do sazby zpt a teprve pot pomoc \db returntoBlack se vrtit 
k~ern barv.

\inext {returntoBlack}{\empty}{+-}

Je poteba vysvtlit, pro pepnae barev jsou tak komplikovan
zapsny. Pepna toti v PDF zapn barvu nezvisle na skupin a
barva textu se dr tak dlouho, dokud nen pouit jin pepna barvy.
Kad tisk dku kdu je uveden pepnaem "\Black", take pi
poznmce \uv{do konce dku} sta jen pepnout na "\Green". Ovem
uvnit komente se me objevit link obalen
pkazy "\Blue...\Black" (viz nap. dek~\cite[linkincomment] v
pedchoz sekci). Pak ale chceme, aby "\Black" vrtil barvu
"\Green". Proto je provedeno pedefinovn pomoc "\let". Toto
pedefinovn je lokln. Protoe dek je titn uvnit skupiny, je
dal dek u ern.

Pi tisku komente, kter m vodn a koncov znak a me peshnout
jeden dek, musme globln pedefinovat "\Black" na "\Green", aby i
dal dky (uvozen pkazem "\Black") byly zelen. Koncov znak 
komente pak mus uvst barvy do pvodnho stavu. 

\docbytex{} inicializuje poznmky podle pravidel jazyka C:

\inext {setlinecomment}{\empty}{+-}

\sec [design] Pro designry
%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nsleduje dokumentace definic maker ovlivujc vzhled dokumentu.
Jejich pedefinovn me zpsobit zmnu vzhledu podle poadavku
uivatele. Msto komplikovanch maker s mnostvm parametr pro zen
vzhledu jsou zde jednoduch dobe dokumentovan makra pro jedno
pouit.  Pedpokld se, e pi poteb jinho vzhledu dokumentu je
uivatel pedefinuje.

Makra zabvajc se vzhledem dokumentu jsou
pokud mono oddlena od sloitosti ostatnch maker, ve kterch probh
hlavn zpracovn \docbytex{}u. To umouje designrovi zamit se
jen na programovn vzhledu a neutopit se v rznch cyklech a
rekurzch internch maker \docbytex{}u.

Typicky jsou makra pro vzhled ve dvou verzch: pro pdf\TeX{} a bez
pdf\TeX{}u. To je dvod, pro ve vpisech se asto vyskytuje test
"\ifx\pdfoutput\undefined".

\subsec Parametry a pomocn makra pro nastaven vzhledu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Velikost \db hsize ani \db vsize nemnme. Bu si ji nastav uivatel,
nebo se pevezme velikost z~plainu (vhodn pro papr letter) i
csplainu (vhodn pro papr A4). Nastavujeme ale vt \db parindent,
nebo chceme do prouku vymezenho "\parindent" dt podbarven
tvereky u nzv sekc. 

\ifirst {docby.tex}{parindent=}{\empty}{+-}

Pipravme si \uv{zenou ku} \db nwidth vyuitou nap. jako ka zhlav:

\inext {nwidth}{\empty}{+-}

Pkazem plainu "\raggedbottom"
nastavme prunost strnky dole, a ne mezi jednotlivmi dky.
Nastavenm "\exhyphenpenalty=10000" zakeme zlom za pomlkou
(v~tisku rozsahu strnek, nap. 11--13, takov zlom psob ruiv).

\inext {raggedbottom}{\empty}{+-}

Zavedeme potebn fonty 
\db bbf, \db bbbf, \db btt,
\db ttsmall, \db rmsmall, \db itsmall a \db partfont.

\inext {bbf=}{\empty}{+-}

Makro \db setsmallprinting pepne do malho strojopisu, piprav
\db ttstrut vhodn velikosti a pomoc "\offinterlineskip" piprav tisk
dk v reimu, kdy se o sebe opraj. Hodnota "\parskip" je nastavena
na "-1pt", aby dochzelo k mrnmu pekrvn a nevznikaly v tisku
nebo na obrazovce pruhy. Analogicky pracuje makro \db setnormalprinting.

\inext {setsmallprinting}{\empty}{+-}

V nvrhu vzhledu pracuji jen s barvami
\db Blue, \db Red, \db Brown, \db Green, \db Yellow a \db Black.
Pokud budete chtt dal barvy, definujte si je.\par\penalty1234

\inext {pdfoutput}{\empty}{+-}

Barvy jsou definovny pomoc makra \db setcmykcolor, kter je v
ppad DVI vstupu nastaveno na przdn makro a v ppad PDF vstupu
je pouit PDF~"\special". Take pkazy "\Brown" atd. je mon pout i
ve verzi maker pro DVI, ovem v tto verzi neudlaj nic.
Barva \db oriBlack je konstantn ern barva. Nkter makra toti
normln "\Black" pedefinovvaj a pak se potebuj vrtit pomoc
"\oriBlack" ke skuten ern barv.

Makro \db rectangle "{<vka>}{<hloubka>}{<ka>}{<obsah>}"
vytvo rmeek o stanovench rozmrech se stanovenm obsahem.
V PDF verzi je rmeek ve tvaru plnho lutho obdlnku na kterm
se nachz "<obsah>" zatmco v~DVI verzi se vytvo obrysov rmeek.
Pozor: parametr "<obsah>" mus obsahovat pepna barvy, jinak nebude v
PDF verzi viditeln. Na druh stran makro "\rectangle" se postar 
o nvrat do \uv{normln} ern barvy.

\inext {pdfoutput}{\empty}{+-}

Nakonec pipravme makro \db docbytex jako zkratku pro logo \docbytex{}u.

\inext {def\nb docbytex}{\empty}{+-}

\subsec Vzhled sekc a podsekc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Makra \db printsec "{<nadpis>}" a \db printsecbelow,
jsou volna z makra pro vytvoen sekce "\sec" a maj za kol
vytisknout nadpis. Ostatn problematika, kterou mus eit makro
"\sec" (reference do obsahu, clov reference, sla sekc, plovouc
zhlav atd.) je zde odstnna a nemusme se j v tuto chvli zabvat.

Musme ale dodret nsledujc mluvu: Na zatku makra "\printsec"
pejdeme pro jistotu do vertiklnho mdu, pak vlome potebn
mezery, pak vlome text nadpisu. V okamiku, kdy pejdeme do
horizontlnho mdu, vlome makro "\makelinks", kter zajist
umstn cl odkaz. Nakonec pejdeme do vertiklnho mdu pkazem
"\par" a {\it nevkldme dn dal vertikln mezery}. Makro "\sec" vlo pod
vytitn nadpis do horizontlnho seznamu dal prvky a poslze 
zavol "\printsecbelow". Tam teprve vlome mezery obvykle blokovan
proti zlomu pomoc "\nobreak". Zkladn azen vertiklnho seznamu 
v \TeX{}u toti vypad takto: box, (whatsit, mark, atd.), penalty, glue. 
O objekty uveden v~zvorce se postar "\sec", my zde eme jen box
(v makru "\printsec"), a dle penaltu a glue (v makru "\printsecbelow").

K dispozici mme hodnotu "\secnum" a "\subsecnum" a dle meme pout
test "\ifsavetoc", kterm se ptme, zda dan nadpis bude v
obsahu. Nebude-li, mli bychom msto "\the\secnum" tisknout
"\emptynumber". V makru "\seclabel" je obsah lejblku sekce, nebo
je makro przdn. To meme vyut pi tisku v reimu \uv{nahrubo},
napklad tisknout tyto lejblky do okraj. \docbytex{} tuto
vlastnost implicitn neimplementuje.

\ifirst {docby.tex}{def\nb printsec }{\empty}{+-}

Makra \db printsubsec a \db printsubsecbelow funguj analogicky jako prv
zmnn, ale spolupracuj s makrem "\subsec".

\inext {def\nb printsubsec }{\empty}{+-}

Makro \db printpart vytiskne nadpis sti a dopedu d velik 
psmeno. Makro \db printpartbelow tiskne mezeru pod nadpisem sti.

\inext {def\nb printpart }{\empty}{+-}

Makro \db emptynumber, kter se pouije pi "\savetocfalse", je
implicitn nastaveno na przdnou hodnotu.

\inext {emptynumber}{\empty}{+-}

\subsec Titul, autor
%%%%%%%%%%%%%%%%%%%%

Makro \db title "<titul>\par" te parametr "<titul>"
pomoc makra "\secparam", kter se postar o~ppadn 
ignorovn mezery na konci parametru (viz~sekci~\cite[secsec]). 
Makro "\secparam" ulo parametr
"<titul>" do tokenlistu "\sectitle" a spust intern
\db iititle. Toto makro pracuje ve dvou mdech
(DVI a PDF). V~obou mdech "\iititle" ulo "<titul>" do makra 
"\headtitle" (pokud je toto makro przdn, tedy neinicializovan
uivatelem) a pomoc pkazu "\noheadline" potla na aktuln strnce
tisk zhlav.

\inext {def\nb title}{\empty}{+-}

Makro "\title" v DVI verzi je prost "\centerline", zatmco v PDF
verzi tiskne podkladov obdlnk ky "\nwidth".

Pokud nen makro \db projectversion definovno, nastavme mu vchoz
hodnotu jako przdn makro:

\inext {ifx\nb project}{\empty}{+-}

Makro \db author "<autor>\par" je spolen v obou mdech. 
Umst jmno autora tun a na sted.

\inssdef author

\subsec Hlaviky a patiky
%%%%%%%%%%%%%%%%%%%%%%%%%%

\docbytex{} nemn vstupn rutinu plainu. Vyuv tedy klasick
nstroje na modifikaci vzhledu, tj. text "\footline" a "\headline".

Nvrh vzhledu strnky nepot s pravou a levou
stranou, protoe dokumentaci vtinou teme na monitoru a kdy ji
tiskneme, tak kdo v, na em...

Text \db footline je nastaven tak, aby byla strnkov slice uprosted
podbarvena ppadn ormovna pomoc "\rectangle".

\inext {footline}{\empty}{+-}

Text \db headline se mn. Implicitn obsahuje jen makro \db normalhead,
ale pi pouit pkazu "\noheadline" na chvli zmn svj obsah.

\ilabel[headlinebox] {headlinebox}
\inext {headline}{\empty}{+-}

Makro "\normalhead" ulo strnkov link pomoc "\savepglink"
a "\vbox/\hbox" gymnastikou vytvo potebn zhlav. Zleva je titn
nzev sekce ("\firstmark") a zprava konstantn text "\headtitle".

Makro \db noheadline nastav "\headline" pechodn na text, podle
kterho se vlo jen strnkov odkaz a provede zmna obsahu
"\headline" na standardn hodnotu. Operace musme provdt globln,
protoe jsme uvnit vstupn rutiny.

\inssdef noheadline

Makro \db headtitle obsahuje text shodn v celm dokumentu titn
vpravo v zhlav. Implicitn je makro przdn, po pouit pkazu
"\title" obsahuje nzev dokumentu, pokud si uivatel makro nedefinoval sm.

\inext {headtitle}{\empty}{+-}

Pomocn makro \db headlinebox udl v DVI mdu przdn tvereek a
v PDF mdu pln (lut) tvereek. Je pouito na dku~\cite[headlinebox]
pro vytvoen tverekovan ry v zhlav,

\inext {ifx\nb pdfoutput}{\empty}{+-}

\subsec Tisk cle odkazu a odkaz pod arou
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Cl odkazu vytvoen makry "\dg" nebo "\dl" je poteba vytisknout
vrazn, aby jej ten pokud mono rychle nael. Tisk
probh v makru \db printdg "{<ped>}{<slovo>}{<za>}", kde "<ped>" je
text ped slovem a "<za>" je przdn parametr nebo obsahuje "()",
pokud tyto zvorky uivatel v pkaze "\dg", "\dl" pouil.

Souasn nvrh \docbytex{}u tiskne z tchto t parametr jen jeden,
sice "<slovo>". V DVI mdu tiskne "<slovo>" v rmeku a v PDF mdu
tiskne "<slovo>" erven a na pozad je lut obdlnk.

\inext {ifx\nb pdfoutput}{\empty}{+-}

erven text se tiskne pomocnm makrem \db printdginside, kter tiskne
jednodue erven, pokud ke slovu neexistuje "\api" cl a tiskne
erven pomoc "\ilink", jestlie existuje "\api" cl.

\inext {def\nb printdginside}{\empty}{+-}

daj pod ru tiskneme makrem 
\db printfnote "{<ped>}{<d-slovo>}{<za>}{<k-slovo>}", 
kde parametry "<ped>" a "<za>" maj stejn vznam, jako u makra "\printdg".
Parametr "<k-slovo>" (krtk verze slova) tiskneme erven, 
ostatn parametry ern. Parametr "<d-slovo>" (dlouh verze slova) nen
pouit.

K naprogramovn tohoto makra vyuiji makro
"\specfootnote"~"{<text>}", kter pole text do speciln poznmky pod
arou. Dle je poteba vdt, e "\pgref[+<slovo>]" vrt slo
strany, kde je "\api" deklarace "<slova>" nebo vrt $-1000$. 
Toto slo vlome do "\apinum" a je-li nezporn, tak jej uvedeme
jako prvn v seznamu strnek a podtren. 
Seznam strnek vytiskneme pomoc
"\listofpages{<slovo>}". V seznamu bude chybt strnka "\apinum", protoe
makro "\listofpages" ji vynechv. Przdn seznam strnek (pi kterm
netiskneme dvojteku ani rku) poznme podle toho, e "\box0" m
nulovou ku.

\inext {def\nb printfnote}{\empty}{+-}

\subsec Tisk daje v obsahu a v rejstku
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Pkaz \db ptocline "{<slo>}{<text>}{<strana>}" se postar o tisk
daje o sekci nebo sti do obsahu. Dle pkaz \db ptocsubline
"{<slo>}{<text>}{<strana>}" vytiskne daj o subsekci. Jak je patrn,
tyto dva pkazy se li jen o jeden "\indent":

\inext {def\nb ptocline}{\empty}{+-}

Pkaz \db mydotfill vytiskne teky do obsahu tak, aby byly pod sebou
zarovnny.

Pkaz \db ptocentry "<typ>{<slovo>}{<k-slovo>}" vytiskne jednu poloku
o dokumentovanm slov do obsahu. Parametr "<typ>=+", pokud je v danm
mst "\api" dokumentace, a "<typ>=@", je-li v danm mst "\dg"
dokumentace. "<k-slovo>" je przdn, ale pi pouit "\dl" je v nm
krtk verze slova, zatmco ve "<slovo>" je dlouh verze slova.
Dlouhou verz odkazujeme, krtkou verzi tiskneme. 

\inext {def\nb ptocentry}{\empty}{+-}

Kdyby bylo poteba tisknout text ped slovem nebo zvorky za slovem,
je mon vyut kontroln sekvenci "\csname-<slovo>\endcsname" jako
v nsledujcm makru "\printindexentry".

Makro \db myldots vytvo ti teky, kter jsou zarovnny s ostatnmi
tekami v obsahu.

Makro \db printindexentry "{<slovo>}" tiskne daj o slov do
rejstku. Zan ve vertiklnm mdu uvnit sloupce, vytiskne daj a
pomoc "\par" se mus vrtit do vertiklnho mdu.

\inext {def\nb printindexentry}{\empty}{+-}

Pomoc \db separeright ulom do "\tmpa" text vlevo od slova a do
"\tmpb" text vpravo od slova. Makro "\refdg" tyto daje uloilo do
makra "\csname-<slovo>\endcsname" oddlen od sebe znakou "\right".
Pomoc makra "\pgref[@<slovo>]" zskm strnku s "\dg" deklarac
slova. Pomoc "\pgref[+<slovo>]" zskm strnku s "\api" deklarac
slova. Tuto strnku (pokud existuje) tisknu podtren.

\subsec Tisk zdrojovho textu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Makra "\ifirst" a "\inext" petisknou poadovanou st zdrojovho
textu. Pi een nvrhu vzhledu tisku ns nyn pouze zajm, e tato
makra zalo skupinu, pak zavolaj pkaz \db printiabove, pak pro tisk
kadho dku zavolaj \db printiline "{<slo>}{<text dku>}" a nakonec ped
ukonenm skupiny se spust \db printibelow. Prv tato ti makra si
nyn naprogramujeme. Budeme rozliovat mezi DVI a PDF
mdem.

\ilabel [isnameprinted]  {raise8}
\ilabel [isnameprinted2] {pt \nb inputfilename}
\inext {ifx\nb pdfoutput}{\empty}{+-}

V DVI mdu tiskneme nahoe ru se jmnem souboru pomoc "\leaders"
a makra \db specrule. Dole pak tiskneme jen jednoduchou ru.
V~PDF mdu nahoe pouze nastavme "\setsmallprinting" 
a vlome malou mezeru. Dole vlome stedn mezeru.

Makro "\printiline" pejde nejprve do horizontlnho mdu, tam vlo v
DVI mdu podpru a dle box s slem a box s dkem. Mezi dky
vkldm penaltu~11. V PDF mdu se msto podpry tiskne cel lut
prouek v~"\rlap". Protoe pes prvn dek je poteba vpravo nahoru
vytisknout jmno souboru (pozdji ne lut prouek), je poteba
zjistit, zda tisknu prvn dek nebo dal dky. K tomu slou
kontroln sekvence \db isnameprinted, kter je typicky "\undefined".
Po vytitn jmna souboru (dky~\cite[isnameprinted] a~\cite[isnameprinted2]) 
nastavm "\isnameprinted" na "\relax" a tm poznm, e u je prce
provedena. A makro "\ifirst" nebo "\inext" ukon skupinu, bude zase
mt "\isnameprinted" hodnotu "\undefined".

\subsec [begtt] Tisk z prosted {\tt\nb begtt}/{\tt\nb endtt}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Makro "\begtt" zalo skupinu a zavol \db printvabove.
Dle pro kad titn dek vol makro \db printvline "{<slo>}{<text dku>}"
a nakonec zavol \db printvbelow. slo dku jsme se rozhodli
nevyut. V DVI verzi kreslme jen ry nahoe a dole. V~PDF verzi 
kreslme lut ry nahoe a dole a v~kadm dku pomoc "\rlap" kreslme 
lut obdlnky vpravo a vlevo.

\inext {ifx\nb pdfoutput}{\empty}{+-} 

\subsec Vkldn obrzk
%%%%%%%%%%%%%%%%%%%%%%%%

Obrzky jsou vkldny nalevo podle odstavcov zarky. Tato
zarka je dostaten velk, take to psob docela dobe.
Celkovou ku prostoru pro obrzek \db figwidth spotm jako
"\hsize" mnus "\parindent"

\inext {newdimen\nb figwidth}{\empty}{+-}

Makro \db ifig "<pomr ky> <nzev> " v DVI mdu vlo "<nzev>.eps" a
vyuije k tomu makrobalk {\tt epsf.tex}. V PDF mdu vlo
"<nzev>.pdf" a vyuije k tomu pdf\TeX{}ov primitivy "\pdfximage",
"\pdfrefximage", "\pdflastximage".

\inext {ifx\nb pdfoutput}{\empty}{+-}

Makro \db figdir obsahuje adres, ze kterho se obrzky lov.

\subsec Vty
%%%%%%%%%%%%%

Makra pro vty jsou natolik jednoduch, e asi nepotebuj dalho
konimente. \db begitems zahj prosted s vty, \db enditems ukon
toto prosted, \db itemno sluje a \db dbtitem "<znaka> " zahajuje poloku,
piem se uvnit prosted pevtl na \db item.

\inext {newcount\nb itemno}{def\nb enditems}{++}


\sec [implementace] Pro otrl
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Zde je dokumentovna implementace \docbytex{}u. Je zde vpis 
vech jeho internch maker vetn podrobnho
komente, jak funguj. Asi nen rozumn tato makra mnit, ledae by
si chtl ten naprogramovat \docbytex{} vlastn.

\subsec Pomocn makra
%%%%%%%%%%%%%%%%%%%%%

Makro \db dbtwarning zprostedkuje tisk varovnch hlek:

\inext {def\nb dbtwarning}{\empty}{+-}

Makra \db defsec "{<text>}", \db edefsec "{<text>}" a \db undef "{<text>}"
jsou zkratky za ast operace s~"\csname<text>\endcsname".

\inext {def\nb defsec}{\empty}{+-}

Makro "\undef" je poteba pout takto:

{\def\begtthook{\langleactive\mubytein=1}
\begtt
\undef{<text>}\iftrue <sekvence nedefinovan> \else <sekvence definovan> \fi
\endtt
\par}

Nutnost pouit "\iftrue" se bohat vyplat, a budeme "\undef" peskakovat
vnjmi podmnkami typu~"\if".

Definuji makro \db nb (normln backslash). Toto makro je pak mon
pouvat pi vyhledvn textu s tmto znakem. Rovn definuji aktivn
tabeltor a zstupn sekvence \db obrace, \db cbrace, \db percent
a \db inchquote.

{\catcode`\%=12 \noactive{\nb %} \noactive{[%} }

\inext {catcode}{\empty}{+-}

Makro \db softinput je vysvtleno v \TeX{}booku naruby na stran 288,
take bez komente.

\inext {def\nb softinput}{\empty}{+-}

Makro \db setverb nastav kategorie vech specilnch znak na
normln. Viz \TeX{}book naruby, stranu~28. 

\inext {def\nb setverb}{\empty}{+-}

\subsec Inicializace
%%%%%%%%%%%%%%%%%%%%

Ohlsme se na terminl:

\inext {This is DocBy}{\empty}{+-}

Makro \db dbtversion obsahuje verzi \docbytex{}u a je definovno 
na zatku souboru {\tt docby.tex}. Tam je autor \docbytex{}u pozmn, 
pokud pejde na novou verzi.

\inssdef dbtversion

Inicializujeme csplain md:

\inext {^^B\nb ifx\nb chyph\nb undefined \nb else}{\empty}{+-}

Inicializujeme enc\TeX{}ov md:

\inext {ifx\nb mubyte}{\empty}{+-}

Makro \db enctextable "{<slovo>}{<tlo makra>}" vlo do enc\TeX{}ov
tabulky vzor "<slovo>". Jakmile takov vzor enc\TeX{}
objev, zru jej ze vstupnho proudu a promn jej v kontroln
sekvenci "\.<slovo>", kter expanduje na "<tlo makra>". 
Napklad makro "\dg"~"<slovo>" aktivuje pro enc\TeX{} "<slovo>", take
provede (mimo jin) 
"\enctextable{<slovo>}{\sword{<slovo>}}", co zpsob,
e se "<slovo>" v natanm zdrojovm kdu promn na "\sword{<slovo>}".

Makro "\enctextable" odmt uloit do enc\TeX{}ov tabulky slova,
kter jsou v seznamu \uv{zakzanch} slov \db owordbuffer. Tam jsou
slova (oddlen z obou stran rkou), kter se nesmj aktivovat kvli 
"\onlyactive". Pro takov slova provede "\enctextable" jen definici
sekvence "\.<slovo>".

Makro \db noactive "{<text>}" vlo do enc\TeX{}ov tabulky vyhledvan 
text, kter ve vstupu zstane a ped nj bude vloena sekvence \db emptysec.
Protoe enc\TeX{} neum ze sv tabulky zruit daj (um jen pepsat
informaci, na co se m vyhledvan text promnit), je poteba texty,
kter u v encTeXov tabulce nepotebujeme, deaktivovat alespo pomoc 
"\noactive".

Na \db sword "{<text>}" se dky enc\TeX{}u promuj texty, kter se maj
automaticky stt klikatelnmi linky. 

\inext {def\nb sword}{\empty}{+-}

Makro \db onlyactive "{<ped>}{<slovo>}{<za>}" zake vkldat
"<slovo>" do enc\TeX{}ov tabulky (vlo je do "\owordbuffer", 
ovem jen za pedpokladu, e u tam nen),
a nech cel text "<ped><slovo><za>" promnit v~"\oword{#1}{#2}{#3}".
Dle pomoc "\noactive" dekativuje "<slovo>" (pi ten "\reffile" 
toti pravdpodobn bylo aktivovno).
Makro \db oword "{<ped>}{<slovo>}{<za>}"
tiskne normln "<ped>", dle, pokud je definovno "\.<slovo>", tak
je spust, jinak tiskne normln "<slovo>". Konen tiskne vdy
normln text "<za>".

\inext {def\nb onlyactive}{\empty}{+-}

Nakonec inicializujeme DVI/PDF md:

\inext {ifx\nb pdfoutput}{\empty}{+-}

\subsec Makra {\tt\nb ifirst}, {\tt\nb inext}, {\tt\nb ilabel}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Deklarujeme \db lineno jako slo dku, \db ttlineno jako slo dku
pro "\begtt...\endtt" vpisy, \db ifcontinue pro zen cyklu a 
\db infile je deskriptor souboru otevenho ke ten.
\db ifskipping implementuje uivatelsk \db skippingfalse a 
\db skippingtrue.

\inext {newcount\nb lineno}{\empty}{+-}

%Makra "\ifirst", "\inext" jsou pro uivatele popsna
%v~sekci~\cite[vkladani] a makro "\ilabel" m sv povdn 
%v~sekci~\cite[lineodkazy].

Pkaz \db ifirst "{<soubor>}{<odkud>}{<kam>}{<jak>}" nejprve
pomoc "\readiparamwhy" analyzuje parametr "<jak>", pak oteve soubor
ke ten primitivem "\openin". Je-li oteven nespn, vype
varovn, jinak si ulo nzev souboru do makra \db inputfilename 
a analyzuje parametry pomoc "\scaniparam": "<odkud>" je uloeno do
"\tmpa" a "<kam>" do "\tmpb". Do "\tmpA" a "\tmbB" se ulo poet
opakovn (z konstruktoru "\count=<num>"). Nakonec se spust makro 
"\insinternal" s expandovanmi parametry "<odkud>", "<kam>".
K tomu je pouit znm trik s makrem "\act".

\insdef ifirst 

Pkaz \db inext "{<odkud>}{<kam>}{<jak>}" pracuje analogicky, jako
"\ifirst", pouze neotevr soubor, ale pomoc testu na definovanost
makra "\inputfilename" kontroluje, zda nhodou nebyl  sputn pkaz
"\inext" bez pedchozho "\ifirst".

\insdef inext

V rmci expanze parametr chceme, aby zmizely vechny kontroln sekvence, kter
nm do textu vloil automaticky enc\TeX{}. To provede makro
\db noswords.

\inssdef noswords

Makro \db readiparamwhy nate znaky "+" nebo "-" z parametru "<jak>" a
ulo je do sekvenc \db startline a \db stopline.

\inssdef readiparamwhy

Makro \db scaniparam "<param>^^X<out><outnum>" te "<param>" 
ve tvaru "\count=<num> <text>". Do sekvence "<out>" ulo "<text>"
a do sekvence "<outnum>" ulo "<num>". Protoe konstruktor
"\count=<num>" je nepovinn, d trochu vce prce parametr analyzovat.
K tomu slou i pomocn makra \db scaniparamA, \db scaniparamB, \db scaniparamC.
V ppad neptomnosti "\count=<num>" je v~"<outnum>" jednika.

\inssdef scaniparam

Hlavn prci pi vkldn zdrojovho textu do dokumentace dl makro
\db insinternal s parametry "{<odkud>}{<kam>}".

\ilabel [prvniloop]       {preskakovani}
\ilabel [konec:prvniloop] {ifcontinue \nb repeat}
\ilabel [druhyloop]       {pretisk}
\ilabel [konec:druhyloop] {readnewline \nb repeat}
\ilabel [insinternal:end] {printibelow}
\insdef insinternal

Makro "\insinternal" se skld ze dvou hlavnch cykl. Prvn (na
dcch~\cite[prvniloop] a~\cite[konec:prvniloop]) te postupn 
dky ze vstupnho souboru (makrem
"\readnewline") a ulo je do makra "\etext". V tomto cyklu hled
vskyt textu "<odkud>" a nic netiskne.

Druh cyklus na dku~\cite[druhyloop] a~\cite[konec:druhyloop] 
te postupn dky ze vstupnho
souboru a hled vskyt textu "<kam>". V tto chvli tiskne pomoc
makra "\printilineA".

Ped prvnm cyklem jsou provedeny ppravn prce: nastaven
kategori, font, "\mubytein".
Dle je v ppravn fzi definovno makro \db testline se separtorem
"<odkud>", pomoc nho budeme testovat ptomnost textu "<odkud>".
Variantn definice makra "\testline" nsleduj pro speciln ppad
parametru "<odkud>" (viz uivatelsk dokumentace v~sekci~\cite[vkladani]).
Ukonen cyklu je zeno podmnkou "\ifcontinue". Pkaz \db nocontinue
provede "\continuefalse", ovem ne vdy. Pokud je zadno "\count>1", tj. 
"\tempnum>1", pak pkaz pouze zaznamen vskyt hledanho textu a sn 
"\tempnum" o jedniku.

\inssdef nocontinue

Ped druhm cyklem v makru "\insinternal" jsou provedeny podobn ppravn 
prce jako ped
prvnm, znovu je definovno makro "\testline", tentokrt se separtorem 
"<kam>". Vyhledvn probh podobn, jako kdy jsme hledali "<odkud>".

Pomoc "\ifx+\startline" testujeme, zda tisknout vchoz dek.
Pomoc "\ifx+\stopline" testujeme, zda tisknout ukonovac dek.

Makro "\ilabellist" obsahuje testovn ptomnosti lejblk
deklarovanch pkazem "\ilabel".

Trikoidn je makro \db returninsinternal "{<text>}{<mon fi>}{<ignoruj>}",
kter se spust pi dosaen konce tenho souboru. Marko opust svj
cyklus pomoc parametru "<ignoruj>", kter je separovn textem
"\printibelow", take to pesko vt st obsahu makra "\insinternal" a
po dek~\cite[insinternal:end]. Abychom sprvn opustili vnoen
podmnky, jsou petena v druhm parametru ppadn "\fi" a v makru pouita.
Prvn parametr obsahuje varovac hlku, chceme-li vypsat varovn.
Chceme-li bt zticha, je parametr przdn.

\insdef returninsinternal

Makro \db readnewline je naproti tomu jednoduch:

\inssdef readnewline

Pracujeme s dkem tenho souboru ve dvou verzch: neexpandovanm
\db text a expandovanm \db etext pi "\noswords". Tm mme zarueno,
e v "\etext" nejsou kontroln sekvence vytvoen enc\TeX{}em (pro
test ptomnosti "<odkud>" nebo "<kam>" by tam ty sekvence pekely). 
Verze s enc\TeX{}ovmi sekvencemi "\text" se pouije pi tisku.

Makro \db printilineA mus mt svou inteligenci: nesm bezhlav tisknout
przdn dky, ale ty tiskne a se zpodnm, nsleduje-li tisk
neprzdnho dku. Tm je zarueno, e se pi "\skippingtrue" nevytiskne posledn
przdn dek. Makro \db lastline m ti stavy: "\empty" (na zatku), 
"\relax" (po vytitn dku), "<slo dku>" (je-li pedchoz dek 
przdn).

\insdef printilineA

Pro uloen deklarac pomoc \db ilabel "[<lejblk>]{<text>}"
slou makro \db ilabellist, kter musme nastavit nejprve na przdnou
hodnotu. 

\insdef ilabellist

Makro "\ilabel" nejprve expanduje sv parametry (pomoc
"\act") a zavol intern \db ilabelee. Toto makro pid do
"\ilabellist" toto: 

\def\begtthook{\langleactive\mubytein=1}
\begtt
\expandafter\testilabel\etext\end{<lejblk>}{<text>}
\endtt

Makro \db testilabel "<dek>\end{<lejblk>}{<text>}"
si definuje pomocn makro "\tmp" se separtorem "<text>", aby
zjistilo, zda je "<text>" uvnit "<dek>". Pokud se to povede, 
registruje cl odkazu pomoc "\labeltext".

\inext {testilabel}{\empty}{+-}
 
\def\begtthook{}

\subsec Pkazy {\tt\nb begtt}, {\tt\nb endtt}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Makro \db begtt a "\endtt" 
je podrobn popsno v \TeX{}booku naruby
na stranch~27 a~30.  Makru \db startverb dodme kompletn
verbatim text separovan "\endtt". 
Tento text je dlen znakem "^^M" (kategorie 12) na dky a koncov dek
obsahuje token "\end". Makro spust ve spoluprci s makrem \db runttloop
cyklus a dky rozebere, kad dek zvlṻ ped makru "\printvline".
Na konci cyklu se provede makro \db endttloop. To udl zvren
innosti (zavol "\printvbelow", ukon skupinu) a pomoc makra
\db scannexttoken otestuje prvn nsledujc
token. Pokud to nen "\par", nen pod "\endtt" przdn dek, 
take se provede "\noindent".

\ifirst {docby.tex}{def\nb begtt }{\empty}{+-}

V numerickm registru "\ttlineno" je slo dku prbn zvtovan
v celm dokumentu. Pokud by nkdo chtl toto slo vyut, me jej
nulovat napklad na zatku kad sekce.

\subsec [ns] Jmenn prostory
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Kad jmenn prostor si udruje sv \db namespacemacro, co je makro 
s jednm parametrem, kter pkazem "\namespace{<tlo makra>}" mimodk
definuje uivatel. Na potku je "\namespacemacro" przdn:

\ifirst {docby.tex}{def\nb namespacemacro}{\empty}{+-}

Ke kadmu jmennmu prostoru budeme chtt piadit lejblk. Rozhodl
jsem se za lejblk povaovat vsledek expanze "\namespacemacro{@!}".
Budu jej nadle znait "<nslejblk>".
Existuje sice urit riziko nejednoznanosti "<nslejblku>", ale 
pedpokldm, e v praxi nenastane.

Kad jmenn prostor u na potku mus vdt, jak vechna lokln
slova obsahuje, aby jejich vskyt mohl smovat na msto, kde je
deklarace "\dl", kter me bt teba pozdji ne vskyt.  Jmenn
prostor na svm startu mus tedy do enc\TeX{}ovch tabulek uloit
vechna lokln slova a na svm konci vrtit ve pokud mono do
pvodnho stavu.  Je tedy zejm, e nen vhodn ekat a na pkaz
"\dl", ale e je teba vyut soubor "\reffile". V prvnm prchodu
tedy jmenn prostory nemohou bt aktivn.

Po peten "\reffile" m kad jmenn prostor k dispozici makro
"\ns:<nslejblk>", kter obsahuje seznam vech svch 
lokln deklarovanch slov ve formtu 

{\def\begtthook{\mubytein=1\langleactive}
\begtt
\locword{<slovo1>}\locword{<slovo2>}\locword{<slovo3>}...
\endtt
\par}

Protoe ukldn do enc\TeX{}ov tabulky je globln, definujeme 
v rmci duevn hygieny vechna makra s tm spojen globln. Proto je
prosted "\namespace...\endnamespace" nezvisl na skupinch \TeX{}u.

Pi startu \db namespace je teba definovat "\namespacemacro". 
Pvodn hodnotu "\namespacemacro" ulome do "\no:<nslejblk>",
abychom se k nmu mohli na konci prosted
"\namespace...\endnamespace" vrtit. Dle definujeme makro \db locword
tak, aby uloilo potebn daje do enc\TeX{}ov tabulky a ped tm
jet si uloilo stvajc vznamy pedefinovvanch kontrolnch
sekvenc. Pak se prost spust "\ns:<nslejblk>". 

\inext {def\nb namespace }{^^B\cbrace}{++}

Na konci \db endnamespace znovu definujeme makro "\locword" tentokrt tak, aby
vrtilo pozmnnm sekvencm pvodn vznam. Pokud pvodn vznam byl
\uv{nedefinovan sekvence}, je poteba do enc\TeX{}ov tabulky vloit
aspo "\nword", protoe zcela odstranit daj z tabulky nelze. 
Dle se vrtme k~pvodn hodnot "\namespacemacro", kterou mme
uloenu v "\no:<nslejblk>".

\inext {def\nb endnamespace}{^^B\cbrace}{++}

Uveden makra pracuj s uitenou zkratkou \db ewrite, kter zape
text do "\reffile" se zpodnm (primitivem "\write"), ale expanzi 
udl hned. Pitom neexpanduje "\nb".

\inext {def\nb ewrite}{\empty}{+-}

Enc\TeX{} od startu jmennho prostoru vkld tedy msto kadho
loklnho "<slova>" kontroln sekvenci "\.<slovo>", kter expanduje
na "\lword{<slovo>}". Jakmile se tedy objev vskyt loklnho slova,
pracuje \db lword takto:

\inext {def\nb lword}{\empty}{+-}

Makro \db genlongword "<tmp>{<slovo>}" 
vytvo z krtk verze slova dlouhou verzi slova a ulo ji do "<tmp>".
Vskyt "<slova>" dv o sob vdt v parametru "\ilink" i pi zpisu
do souboru svm dlouhm (jednoznanm) jmnem, zatmco krtk jmno 
se tiskne.

Zbv zadit ten ze souboru "\reffile". Makro 
\db refns "{<nslejblk>}" se objev v souboru v mst zatku jmennho
prostoru a \db refnsend "{<nslejblk>}" na konci jmennho prostoru. Mezi
nimi se vyskytuj "\refdg{<ped>}{<slovo>}{<za>}{<k-slovo>}", piem
si nyn vmme jen takovch vskyt, kter maj neprzdn
"<k-slovo>". Prv tyto vskyty zanesl do "\reffile" pkaz "\dl".

\inext {def\nb refns}{\empty}{+-}

Makro "\refns" si zapamatuje pedchoz "<nslejblk>", kter je uloen 
v makru \db currns, do sekvence "\o:<nov nslejblk>" a definuje pak "\currns"
jako "<nov nslejblk>". Piprav tak vchoz stav makra "\ns:<nslejblk>"
na przdnou hodnotu. Makro "\refdg" pak postupn pln buffer
"\ns:<nslejblk>" (viz dky~\cite[ns1] a~\cite[ns2] v~definici makra
"\refdg" v~sekci~\cite[reference]). Konen makro "\refnsend" vrt
"\currns" do stavu, v jakm bylo ped vstupem do stvajcho jmennho 
prostoru. 


\subsec {\tt\nb dg} a ptel
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Makra \db dg, \db dl, \db dgn, \db dgh, \db dln, \db dlh 
ulo do "\tmpA" svj nzev, spust sken parametr pomoc \db dgpar
a nakonec se promn ve svou intern verzi pomoc
"\csname ii\tmpA\endcsname".

\inext {def\nb dg}{\count=2 \empty}{+-}

Pedchoz makra piprav ten nepovinnho parametru. Hlavn prci
provede makro \db dparam.

\ilabel [managebrackets] {managebrackets}
\ilabel [ii] {csname ii}
\inext {def\nb dparam}{\empty}{+-}

Je-li za ukonovac zvorkou "]" mezera, pak je parametr "#2" przdn (je
separovan mezerou). V~tto situaci se makro "\dparam" proto jet
jednou prostednictvm makra \db nextdparam, kter seere obsah zbytku
makra "\dparam", vlo mezeru dovnit zvorky a spust "\dparam" jet
jednou. Nyn u je mon zat parametr "#2", tj. "<slovo>" rozdlit
na st ped prvn rkou, tekou, stednkem nebo dvojtekou a za za
tmto znakem. st ped bude v "\tmpa" a st za (vetn separtoru)
bude v "\tmpb". Tuto prci vykon postupn voln makra \db varparam:

\inext {def\nb varparam}{\empty}{+-}

Makro "\varparam<separ>" definuje pomocn makro "\tmp#1<separ>#2 ", ktermu
je pedloeno "<slovo><separ> ". Je-li "#2" przdn, pak zabral a
"<separ>" na konci, take uvnit "<slova>" nen "<separ>". Pak v
"\tmpa" zstv "<slovo>". Je-li uvnit "<slova>" separtor, pak je
poteba doplnit k "\tmpb" zbytek za separtorem vetn tohoto
separtoru. V "#2" mme "<zbytek><separ>" a my potebujeme do "\tmpb"
uloit stvajc obsah "\tmpb" ped kterm pedchz "<separ><zbytek>".
Tuto prci udl \db gobblelast, ktermu je pedloen
"<obsah tmpb>\end<separ><zbytek><separ>". Makro definuje 
"\tmp#1<separ>" a pedlo mu "<zbytek><separ>". Je tedy v "#1" hol
"<zbytek>" a do "\tmpb" se dostv "<separ><zbytek><star obsah tmpb>". 

Po rozdlen vyhledn separtoru mme n "\tmpa" <slovo>, ovem me
obsahovat na konci "()". Proto spustme na dku~\cite[managebrackets]
makro \db managebrackets, kter se postar o ppadn oddlen tchto
zvorek.  Pokud se zvorky skuten oddlily od "\tmpa", zstvaj
v~\db printbrackets.

\inext {def\nb managebrackets}{\empty}{+-}

Makro \db maybespace v zvru innosti makra "\dparam" vytiskne za
obsahem "\tmpb" mezeru, ale jen tehdy, kdy je jmno makra
dvoupsmenkov ("\dg", "\dl") a nensleduje znak "`".

\inext {def\nb maybespace}{\empty}{+-}

Na dku~\cite[ii] vytvo makro "\dparam" z pvodnho pkazu
"\dg*" resp. "\dl*" jeho intern verzi "\iidg*" resp. "\iidl*".
Parametry ped expandovny, aby s nimi bylo mn prce.
Sta tedy naprogramovat uveden intern makra.

Makro \db iidg vlo do enc\TeX{}ov tabulky "\sword" (je to mrn
nadbyten, tot se provede na zatku zpracovn pi ten
"\reffile" pkazem "\refdg"). Dle makro vytvo cl
odkazu tvaru "@<slovo>", ulo informaci do "\reffile"
ve formtu "\refdg{<ped>}{<slovo>}{<za>}{}",
vytiskne "<slovo>" zvraznn pomoc "\printdg" a vlo poznmku pod
ru pomoc "\printfnote".

\inext {def\nb iidg }{^^B\cbrace}{++}

Makro \db iidl nevkld nic do enc\TeX{}ov tabulky, 
vytvo cl pomoc "\label [@<dlouh slovo>]", zape info do
"\reffile" ve formtu "\refdg{<ped>}{<d-slovo>}{<za>}{<k-slovo>}",
vytiskne "<k-slovo>" zvraznn pomoc "\printdg" a vlo poznmku
pomoc "\printfnote{<ped>}{<d-slovo>}{<za>}".

\inext {def\nb iidl }{^^B\cbrace}{++}

Makra \db iidgh a \db iidlh dlaj to sam jako jejich non-"h"
protjky, jen netisknou slovo v mst vskytu. Lokln tedy
pedefinujeme, aby "\printdg" nedlalo nic.

\inext {def\nb iidgh}{\empty}{+-}

Makro \db iidgn pedefinuje makro "\.<slovo>", kter vyrb enc\TeX,
tak, e vsledkem expanze je "\fword{<ped>}{<slovo>}{<za>}" 
(namsto obvyklho "\sword{<slovo>}").

\inext {def\nb iidgn}{\empty}{+-}

A se \db fword spust (pi prvnm nsledujcm vskytu "<slova>"), m
za kol provst "\iidgh", vytisknout "<slovo>" erven a vrtit 
"\.<slovo>" do pvodnho stavu. 

\inext {def\nb fword}{\empty}{+-}

Makro \db iidln si ulo stvajc vznam "\.<slovo>" do 
sekvence "\;<slovo>" a pedefinuje makro "\.<slovo>", 
kter vyrb enc\TeX, tak, e vsledkem je 
"\flword{<ped>}{<slovo>}{<za>}".

\inext {def\nb iidln}{\empty}{+-}

Makro \db flword m za kol provst "\iidlh", vytisknout "<slovo>"
erven a vrtit vznam makra "\.<slovo>" do pvodnho stavu (kter je uloen
v sekvenci "\;<slovo>". Byl-li tento pvodn vznam nedefinovn, je
poteba potlait dal innost makra "\.<slovo>" registrovnm jako
"\nword{<slovo>}", protoe z enc\TeX{}ov tabulky u zznam nelze
odebrat.  

\inext {def\nb flword}{\empty}{+-}

\subsec [specfootnote] Speciln poznmky pod arou
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Poznmky pod arou jsou azeny vedle sebe a obsahuj jen slova, kter
maj na strnce sv "\dg". Protoe toto een je vizuln
nekompatibiln s uivatelskmi poznmkami pod arou, jednodue je
zakeme:

\inext {let\nb footnote=}{\empty}{+-}

Pro speciln poznmky pod arou vyuiji u deklarovan insert
"\footins". Problm je, jak odhadnout, kolik zabere vertiklnho msta
v poznmkch jedno slovo, kdy jich me bt vedle sebe
vce. Dirty trick z \TeX{}booku (vkldat inserty ve vce rovn jistmu
procentu sv ky) se neujal, nebo zlom asto nekonvergoval, ale osciloval.
V druhm prchodu poznmky teprve dostvaj sv seznamy strnek a tyto
seznamy se pak mohou dle upesovat, co zptn ovlivn vertikln
sazbu. Po jej zmn se mn seznamy strnek a tak pod dokola.

Rozhodl jsem se tedy pracovat pouze s prmrnm koeficientem
poznmek, kter budou mt vechny poznmky spolen. Tento koeficient 
zskm jako celkov poet dk poznmek v celm dokumentu dlen
potem poznmek. Kad poznmka pak \uv{pek} v hlavnm vertiklnm
seznamu vkou dku poznmek (10pt) nsobenou tmto koeficientem.
Sta tedy nastavit "\count\footins".

Aby problm urit konvergoval, bylo nutn fixovat ve uveden
koeficient po druhm prchodu. Kdybych jej kad nsledujc prchod
mnil, zase se nedokme konvergence. Zskat uveden koeficient hned
po prvnm prchodu nen rozumn, protoe v t dob poznmky jet
nemaj vedle sebe seznamy strnek. Vchoz koeficient pro prvn a
druh prchod je tedy nastaven na "\count\footins=200" (pedpokldm
zhruba pt poznmek na dku).

Pracovat s prmrem msto s kadou jednotlivou poznmkou me
samozejm zpsobit, e nkter strnky jsou plnj a nkter
przdnj. Proto je poteba mt rezervu ve "\skip\footins" a
vertikln pruit kolem poznmkov ry.

\inext {skip\nb footins}{\empty}{+-}

V registru \db totalfoocount se bude postupn pitat jednika za kadou
poznmku a na konci zpracovn tam tedy je celkov poet poznmek.
V registru \db totalfoodim bude na konci zpracovn celkov vka 
vech dk s poznmkami. 

\inext {newcount\nb totalfoocount}{\empty}{+-}

Makro \db specfootnote "{<text>}" 
vlo do insertu "\footins" jedin "\hbox{<text>}" a pipote
jedniku do "\totalfoocount".

\inext {def\nb specfootnote}{\empty}{+-} 

Protoe jsem se rozhodl nemnit vstupn rutinu plainu, musel jsem se
\uv{nabourat} aspo do jej sti na tisk poznmek pod arou. Je to
provedeno pedefinovnm makra "\footnoterule" vstupn rutiny plainu.
Separtor "\unvbox\footins" zpsob odstrann stejnho textu 
z output rutiny plainu.

\inext {def\nb footnoterule}{\empty}{+-}

Makro rozebere vertikln seznam insert "\footins" a poskld je
vedle sebe do boxu~4. Pak nastav parametry sazby na praporek a
vypust box~4 do horizontlnho seznamu ("\noindent") ukonenm
"\endgraf". Tm jsou ve vstupn rutin poznmky pod arou vyszeny.
Nakonec pipoteme "\totalfoodim".

V zvru zpracovn v makru "\bye" (viz dek~\cite[write]) zapeme
do souboru "\reffile" informaci o~potu poznmek "<poet>", o celkov
vce dk poznmek v dokumentu "<vka>" a pidme aktuln
koeficient pspvku poznmek do vertiklnho seznamu "<koeficient>".
Informaci zapisujeme jen tehdy, kdy je "\indexbuffer" neprzdn,
tj. kdy probh aspo druh prchod. Kdybychom zapisovali i prvn
prchod, dostali bychom velmi zkreslen informace (poznmky v~tu
chvli nemaj vedle sebe seznamy strnek).
%
Uvedenou informaci zapsanou v pedchozm prchodu 
peteme na zatku zpracovn makrem
\db refcoef "{<koeficient>}{<poet>}{<vka>}" a 
nastavme podle toho spolen koeficient vech poznmek
"\count\footins". Makro zmn koeficient z vchoz 
hodnoty 200 na vypotenou jen jednou. Pi dalch prchodech u
zstv u vypoten hodnoty.
Pomocn makro \db gobblerest odstran cifry za desetinou
tekou vetn npisu~"pt".

\inext {def\nb refcoef}{\empty}{+-}

Vstupn rutina "\plainoutput" nen zmnna. Potebuji ale uvnit
"\output" potlait expanzi nkterch maker, kter se objev v argumentu
"\write". Tato makra jsou tedy uvnit "\output" nastavena na "\relax".
Aby toto nastaven nezmnilo sazbu zhlav, je poteba "\makeheadline" 
provst ped zmnou maker a uloit si vsledek do boxu.

\inext {\nb output=}{\empty}{+-}

\subsec [secsec] Sekce, podsekce
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Nejprve zapeme deklarace \db secnum, \db subsecnum, 
\db sectitle, \db ifsavetoc. Posledn deklarace piprav
uivatelsk \db savetocfalse.

\ifirst {docby.tex}{newcount\nb secnum}{\empty}{+-}

Makra \db sec a \db subsec maj monost nepovinnho parametru
"[<lejblk>]", za nm me a nemus bt mezera, kterou musme ignorovat. 
Na konci parametru "<titul>" ped "\par" rovn me a nemus bt
mezera, kterou musme ignorovat. D tedy prci parametry sprvn
nast. Makra si ulo svj nzev do "\tmpA" a spust proces natn
parametr pomoc "\secparam".

\inext {def\nb sec}{\empty}{+-}

Makro \db secparam se vypod s ppadnm nepovinnm parametrem
"[<lejblk>]". Pokud je ptomen, ulo "<lejblk>" do pomocnho makra
\db seclabel, jinak tam je przdno. Makro \db secparamA se vypodv
s ppadnou mezerou za hranatou zvorkou "]" a odstran ji.
Makro \db secparamB "<titul>\par" nate "<titul>", ale ten me mt
nedouc mezeru zcela na konci. S tm se vypod makro 
\db nolastspace ve spoluprci s makrem \db setparamC. Posledn jmenovan
makro ulo u od nedouc mezery oeten "<titul>" do "\sectitle" a
spust "\iisec" resp. "\iisubsec".

\inext {def\nb secparam}{\empty}{+-}

Makro \db iisec nejprve nastav hodnoty "\secnum" a "\subsecnum",
dle definuje \db makelinks, kde je pipravena tvorba odkaz (to
pouije makro "\printsec").
Dle zavol "\printsec" na vytitn nzvu sekce.
Pot ulo informace do "\reffile" ve tvaru
"\reftocline"~"{<secnum>}{<titul>}{<strana>}" 
Nakonec se provede "\mark{<secnum> <titul>}" a 
vlo se zvren mezera pomoc "\printsecbelow".

\inext {def\nb iisec}{^^B\cbrace}{++}

Makro \db iisubsec, kter vytv podsekci, pracuje analogicky, jako
makro "\iisec".

\inext {def\nb iisubsec}{^^B\cbrace}{++}

Makro "\part" bylo zapracovno dodaten ve verzi Jan. 2009. 
Registr \db partnum uchovv slo sti a makro \db thepart
toto slo konvertuje na psmeno.

\inext {newcount\nb partnum}{\empty}{+-}

Makro \db part m svou implementaci v makru \db iipart
podobn jako napklad makro "\sec".

\inext {def\nb part}{\empty}{+-}

\subsec [reference] Odkazy, reference
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Klikac odkazy e makra \db savelink "[<lejblk>]" a a \db ilink
"[<lejblk>]{<text>}". Makro "\savelink" ulo do sazby cl
odkazu. Cl odkazu vystr do
vky \db linkskip nad a. Makro "\ilink" (ti intern link) je
dokumentovno v~sekci~\cite[krizodkaz]. Konen makro "\savepglink"
ulo cl numerickho typu (slo strnky), kter bude vyuit makrem
"\pglink" pi odkazech na strnky.

\ifirst {docby.tex}{Odkazy, ref}{\empty}{--}

Uveden makra jsem definoval zvlṻ pro DVI vstup (jako przdn
makra) a zvlṻ pro PDF vstup. A zase tvrci pdf\TeX{}u zmn
syntaxi nebo nzvy primitiv, bude stait pozmnit uveden makra.
V makru "\ilink" je pmo eeno, e se m pout modr barva pro
vytvoen odkaz a e odkaz m bt bez rmeku. Pokud to nkomu
nevyhovuje, me si makro pedefinovat.

Trik s pedefinovnm "\nb" (normln backslash) pi tvorb PDF link
vychz ze zkuenosti, e pokud se v nzvu linku objev backslash,
nkter PDF prohlee si s tm neporad a chovaj se podivn. Je tedy
nutn, aby argument pkaz "\savelink" a "\ilink" byl neexpandovan.

Makro \db savepglink (definice je v pedchozm vpisu) je pouito v
"\headline" kad strnky, take vytvo cl \uv{nahoe} na kad
strnce. Makro \db pglink "<number>" pete "<number>" (me bt ve
tvaru numerickho registru i pmo jako slo) a vytvo link na
strnku s tmto slem. slo samotn je vytitno mode a d se na n
kliknout. Ke ten numerickho registru je pouit primitiv "\afterassignment"
a pomocn makro \db dopglink.

V souboru "\jobname.ref" se prostednictvm makra
"\labeltext[<lejblk>]{<text>}" ulo dek, kter obsahuje
"\reflabel"~"{<lejblk>}{<text>}{<strana>}".  Makrem \db reflabel tyto
daje petu a zapu do kontrolnch sekvenc "^^X<lejblk>" a
"^^Y<lejblk>". Tyto kontroln sekvence jsou nsledn vyuity
v~makrech \db numref a \db pgref.  
Za povimnut stoj, e pokud je "<text>" przdn
(to jsou napklad vechny ppady dokumentovanch slov), pak
kontroln sekvenci "^^X<lejblk>" vbec nedefinuji, abych etil
pamt, kterou m \TeX{} rezervovnu na kontroln sekvence.

\inext {reflabel}{\empty}{+-}

Makro \db labeltext "[<lejblk>]{<text>}", jak bylo ped chvl
eeno, ulo do souboru potebn daje. Jednak zape PDF link pomoc
makra "\savelink" a dle ulo do souboru "\reffile" potebn daje.
K tomu je makro \db writelabel "[<lejblk>]{<text>}", kter 
pracuje se zpodnm "\write" (aby slo strany bylo sprvn). 
V okamiku naten parametru
"<text>" jej potebuji expandovat, protoe tam obvykle bv nco jako
"\the\secnum". Pro vyeen tohoto problmu jsem
na chvli prohodil parametry ("<lejblk>" toti nechci
expandovat) a zavedl pomocn makro 
\db writelabelinternal "{<text>}{<lejblk>}".
Prvn st, tj. "\writelabel{<text>}" expanduji pomoc "\edef".

\inext {labeltext}{\empty}{+-}

Makro \db label je u definovno jednodue jako \uv{przdn}
"\labeltext".

\inext {label}{\empty}{+-}

Makro \db cite "[<lejblk>]" vytiskne klikateln text. Pi chybnm
"<lejblku>" vytiskne varovn na terminl. Makro je dokumentovno 
v~sekci~\cite[krizodkaz].

\inext {cite}{\empty}{+-}

S odkazy souvis makro \db api "{<slovo>}", kter vlo
"\label[+<slovo>]" d o sob vdt jet jednou do "\reffile".

\inext {def\nb api}{\empty}{+-}

Makro \db apitext obsahuje text titn vedle "<slova>" do obsahu a
rejstku. 

Pi innosti makra \db bye zapeme do souboru "\reffile" daje 
pro "\refcoef" (dek~\cite[write]) a dle se zabvme testem
konzistence referenc.

\ilabel [texttoc] {text\nb tocbuffer}
\ilabel [vypust] {indexbuffer}
\ilabel [write] {write\nb reffile}
\inext {def\nb bye}{^^B\cbrace}{++}

Test konzistence vypad nsledovn: nejprve
uzaveme zpis do souboru "\reffile", pak
pomoc "\setrefchecking" pedefinujeme
kontroln sekvence vyskytujc se v "\reffile" a soubor znovu
nateme. Nyn makra v nm napsan dlaj test a pokud naraz na
problm, provedou "\continuefalse". Meme tedy pomoc "\ifcontinue"
zjistit, jak test dopadl. Po peten souboru je poteba udlat jet
dkladnou kontrolu vech automatickch odkaz. Pro je tato kontrola 
vyeena vyputnm "\indexbuffer" do vstupn fronty bude jasn po prostudovn
makra \db setrefchecking.

\ilabel[jerelax] {=\nb relax}
\inext {def\nb setrefchecking}{\empty}{+-}

Zde pedefinujeme makro "\refcoef", aby nedlalo nic. 
Dle nov verze "\reflabel" kontroluje, zda odkaz je na stejn strnce, jako byl
a m stejn text. 
Nov makro "\refuseword" pracuje jako jeho originln protjek, jen msto
sekvenc "w:<slovo>" pln sekvence "-<slovo>". Tyto sekvence u znme,
nyn je vyuijeme jinak. etme pamt \TeX{}u, proto nezakldme
sekvence nov. Nejprve je nutn tmto sekvencm nastavit vchoz
hodnotu "\relax", co je provedeno na dku~\cite[jerelax].
Pak znovu pedefinuji sekvenci "\,", aby provedla test shodnosti sekvence
"w:<slovo>" se sekvenc "-<slovo>" a v makru "\bye" na
dku~\cite[vypust] spustm tento test expandovnm makra 
"\indexbuffer\relax". Kdy makro najde nekonzistenci, ohls chybu a
utee pomoc \db ignoretorelax.
Dle je pedefinovno makro "\refdg", aby pouze
zapisovalo do "\tocbuffer". Ostatn makra z "\reffile" tak zapisuj
do "\tocbuffer". Stvajc verzi "\tocbuffer" ulome do "\text" a
"\tocbuffer" se pi naten "\reffile" vytvo znovu. Na
dku~\cite[texttoc], zda se nezmnil obsah.

\subsec Tvorba obsahu, rejstku a zloek
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Obsah i rejstk se mohou pomoc "\dotoc" a "\doindex" objevit kdekoli
v dokumentu (teba na zatku, na konci, uprosted...). Musme bt
pipraveni je kdykoli vytisknout. Soubor "\reffile" z minulho bhu 
meme otevt ke ten jen na zatku, pak jej maeme a zanme
znova zapisovat. Pi ten ze souboru "\reffile" tedy musme uloit
vechny potebn informace k sazb obsahu i rejstku. Pouvme na to
makro "\tocbuffer" a "\indexbuffer". Na zatku tyto \uv{buffery}
vyprzdnme. Makro \db addtext "<text>\to<buffer>" budeme pouvat na
vkldn "<textu>" do "<bufferu>", m buffery postupn naplnme.

\inext {def\nb tocbuffer}{\empty}{+-}

V souboru \db reffile se vyskytuj tyto pkazy:

{\def\begtthook{\langleactive\catcode`\!=0\mubytein=1}
\begtt
\reftocline{<slo>}{<nzev>}{<strana>}  % daje o sekci a subsekci pro obsah
\refdg{<ped>}{<slovo>}{<za>}{<k-slovo>}  % daj o pouit \dg, \dl
\refapiword{<slovo>}                   % daj o vskytu \api{<slovo>}
\refuseword{<slovo>}{<strana>}          % daj o pmm vskytu <slova>
\reflabel{<lejblk>}{<text>}{<strana>}     % viz sekci !cite[reference], odkazy, reference
\refcoef{<koeficient>}{<poet>}{<vka>}  % viz sekci !cite[specfootnote], spec. poznmky
\refns{<nslejblk>}                     % viz sekci !cite[ns], jmenn prostory
\refnsend{<nslejblk>}                  % viz sekci !cite[ns], jmenn prostory
\endtt
\par}

Pi ten souboru "\reffile" ukldme potebn daje do
buffer. Nejprve se zamme na {\bf obsah} a definujeme 
\db reftocline "{<slo>}{<nzev>}{<strana>}".

\inext {def\nb reftocline}{\empty}{+-}

V \db tocbuffer tedy mme postupn daje o vech sekcch a podsekcch v
za sebou jdoucch sekvencch \db dotocline "{<slo>}{<nzev>}{<strana>}".
Mezi sekc a subsekc rozlime jen podle toho, zda
parametr "<slo>" obsahuje teku. K tomu slou pomocn makro 
\db istocsec.

\inext {def\nb dotocline}{\empty}{+-}

Kdybychom spustili makro "\tocbuffer", dostaneme obsah. Ale ten se
neskld jen z daj o~sekcch a podsekcch. Jet je poteba pest
\db refdg a \db refapiword, abychom mohli vkldat do obsahu i daje 
o~dokumentovanch slovech.

\ilabel [right] {right}
\ilabel [ns1] {\nb dl}
\ilabel [ns2] {locword}
\inext {def\nb refdg}{\empty}{+-}

Makro "\refdg" pracuje s parametry "{<ped>}{<slovo>}{<za>}{<k-slovo>}",
kde "<ped>" je text ped slovem, "<slovo>" je dlouh slovo, "<za>" obsahuje
ppadn zvorky "()". Je-li dlouh slovo rozdln od krtkho slova
(pi pouit "\dl"), obsahuje "<k-slovo>" krtk slovo, jinak je tento
parametr przdn.
Makro "\refdg" ukld informace nejen do "\tocbuffer",
ale tak do "\indexbuffer". Rovn pi przdnm "<k-slovo>" makro
ukld "\sword" do enc\TeX{}ov tabulky a pi
neprzdnm "<k-slovo>" makro cosi kut se jmennmi prostory. 
Nyn je ale nae pozornost vnovna tvorb
obsahu.  Ten vytvo makro \db dotoc.

\inext {def\nb dotoc}{\empty}{+-}

{\bf Rejstk} je vybudovn z bufferu \db indexbuffer, ve kterm je seznam
deklarovanch slov v dokumentu. Kad slovo je v bufferu zapsno jako
kontroln sekvence (to zabere v pamti \TeX{}u nejm msta) a je
oddleno od dal sekvence oddlovaem. Ped zatdnm podle abecedy
jsou poloky v~"\indexbuffer" oddleny rkami za polokami, po
zatdn jsou poloky oddleny "\," ped polokami. Take obsah
"\indexbuffer" vypad zhruba takto:

{\def\begtthook{\langleactive}
\begtt
ped zatdnm:  \-<slovo1> , \-<slovo2> , \-<slovo3> , \-<slovo4> , ...
po zatdn:     \, \-<slovoA> \, \-<slovoB> \, \-<slovoC> \, \-<slovoD> ...
\endtt
\par}

\noindent Zde zpis "\-<slovo>" znamen jednu kontroln sekvenci.
Kad takov kontroln sekvence je makrem tvaru "<ped>\right<za>".
To zad dek~\cite[right]. Rejstk vytiskneme makrem \db doindex.

\ilabel [calculatedimone] {calculatedimone}
\inext {def\nb doindex }{^^B\cbrace}{++}

Pkaz "\calculatedimone" s nsledujcm testem "\dimen1" souvis se
sazbou do dvou sloupc, co nechme na sekci~\cite[dvasloupce].  Makro
tedy zalo pkazem "\sec" sekci nazvanou "\titindex" a pokud je
"\indexbuffer" neprzdn, spust sazbu rejstku. Nejprve se pkazem
"\sortindex" setd "\indexbuffer" podle abecedy (viz sekci~\cite[abeceda]). 
Pak makro "\doindex" zalo
dvousloupcovou sazbu ("\begmulti 2") a oddlovai "\," pidl vznam
"\doindexentry". Nakonec vypust "\indexbuffer" do vstupn fronty,
take dal prci opakovan provede makro \db doindexentry
"\-<slovo>", kter se postar o tisk slova v~rejstku.

\inext {def\nb doindexentry}{\empty}{+-}

Makro "\doindexentry" pomoc \db ignoretwo odstran z kontroln
sekvence "\-<slovo>" vodn dva znaky "\-", take v "\tmp" zstane "<slovo>".
Pokud "<slovo>" zan backslashem, udlme z nj makrem 
\db remakebackslash sekvenci "\nb", nebo pm backslash nen uloen
v PDF odkazech (zlob nkter PDF prohlee, viz sekci~\cite[reference].
Nakonec se vytiskne poloka v rejstku u znmm makrem "\printindexentry".

Pi tvorb {\bf strukturovanch zloek} je poteba vdt, kolik m
kad uzel potomk. Tento daj je potan pi ten "\reffile"
volnm makra \db addbookmark "<uzel>" (viz makra "\reftocline" a "\refdg").
Parametr "<uzel>" me bt slo sekce, nebo dvojsl "<sekce>.<podsekce>".
V makru \db currb je "<uzel>", ke ktermu je poteba pitat potomka
a \db currsecb je ppadn nadazen "<uzel>" sekce.
Makro "\addbookmark" pipote jedniku k hodnot makra "\bk:<uzel>".

\inext {def\nb addbookmark}{\empty}{+-}

Makro \db bookmarks zalo skupinu, pedefinuje "\dotocline" a
"\ptocentry" (tj.~makra obsaen v~"\tocbuffer") vlo prvn zloku 
s nzvem dokumentu a spust "\tocbuffer".

\inext {def\nb bookmarks}{^^B\cbrace}{++}

Makro \db setoutline "[<lejblk>]{<text>}{<prefix>}" vytvo zloku 
"<prefix><text>" a prolinkuje ji s clem oznaenm "<lejblk>". 
V "\tempnum" mus bt uloen poet potomk zloky.

\inext {def\nb setoutline}{\empty}{+-}

V tomto makru je pouito konverzn makro \db cnvbookmark, kter je
implicitn neaktivn. Uivatel me napklad nastavit 
"\let\cnvbookmark=\lowercase"
a nechat konvertovat pomoc "\lccode" znak "" na "c", znak "" na
"z", atd. Nastaven "\lccode" mus mt v "\bookmarkshook".

Dle je text ped vloenm do zloky podroben konverzi \db nobraces, 
kter ve spoluprci s makrem \db nobrA sund ppadn zvorky "{}". 
Take, pokud mme teba "{\tt text} v \TeX{}u",
po konverzi dostvme "text v TeXu".

\subsec [abeceda] Abecedn azen rejstku
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Tuto prci provede makro "\sortindex". Pvodn bylo v \docbytex{}u
implementovno algoritmem bubblesort, co vylo na est dk makrokdu
(prezentovno na tutorilu \TeX{}perience~2008), ale pro vt
rejstky to bylo pomal. Nap. pro rejstk tohoto dokumentu to
vygenerovalo 52 tisc dotaz na porovnn a trvalo to asi dv
vteiny. Mj syn Mirek byl pozorn
poslucha tutorilu, take nabyt znalosti okamit vyuil a pepsal
tdic makro na mergesort. Ten na stejn velkm rejstku generuje 
1600 dotaz na porovnn, tedy ticetkrt mn. Cena za to je
skutenost, e makro u nem jen est dk, ale je mrn
komplikovanj. Od monosti pout quicksort jsme upustili, protoe
implementace by vyadovala vy pamov nroky na inputstack
\TeX{}u.

Nejprve deklarujeme podmnku pro vsledek srovnn dvou poloek
\db ifAleB a vytvome pomocn makra \db nullbuf, \db return a 
\db fif. Pomocn makro "\return" ve spoluprci se zakrytm "\fi"
uvnit "\fif" budeme pouvat pro nik z koatch hluboce vnoench
podmnek typu "\if..\else..\fi". Jak uvidte, makro pracuje na rovni
expandprocesoru a nebude poteba pst dn "\expandafter".

\inext {newif\nb ifAleB}{\empty}{+-}

Makro \db sortindex vypust do vstupn fronty cel "\indexbuffer",
pimaluje k nmu "\end,\end", pronuluje "\indexbuffer" a spust 
"\mergesort".

\inext {def\nb sortindex}{^^B\cbrace}{++}

Makro \db mergesort pracuje tak, e bere ze vstupn fronty vdy dvojici skupin
poloek, kad skupina je zatdn. Skupiny jsou od sebe oddleny
rkami. Tyto dv skupiny spoj do jedn a zatd. Pak pejde na
nsledujc dvojici skupin poloek. Jedno zatdn tedy vypad
napklad takto: dv skupiny: "eimn,bdkz," promn v~jedinou 
skupinu "bdeikmnz,". V tomto pklad jsou poloky jednotliv psmena,
ve skutenosti jsou to kontroln sekvence, kter obsahuj cel slova.

Na potku jsou skupiny jednoprvkov ("\indexbuffer" oddluje kadou
poloku rkou). Makro "\mergesort" v tomto ppad projde seznam a vytvo
seznam zatdnch dvoupolokovch skupin, uloen zptn v
"\indexbuffer". V dalm prchodu znovu vyvrhne "\indexbuffer" do vstupn fronty,
vyprzdn ho a startuje znovu. Nyn vznikaj typolokov zatdn
skupiny. Pak osmipolokov~atd. V~zvru (na dku~\cite[konecsortu]) 
je prvn skupina cel setdn a druh obsahuje "\end", tj. 
vechny poloky jsou u setdn v prvn skupin, take sta 
ji uloit do "\indexbuffer" a ukonit innost. Pomoc "\gobblerest"
odstranme druh "\end" ze vstupnho proudu.

\noactive{dvojice}
\ilabel [merge:porovnani] {isAleB}
\ilabel [merge:trojka] {mergesort p1+}
\ilabel [merge:p1] {ifx,}
\ilabel [merge:p2] {fif\nb mergesort\cbrace}
\ilabel [konecsortu] {empty\nb indexbuffer}
\ilabel [napercarky] {napercarky}
\inext {def\nb mergesort }{^^B\cbrace}{++}

{\def\quotehook{\catcode`\<12}
Jdro "\mergesort" vidme na dcch~\cite[merge:porovnani]
a~\cite[merge:trojka]. Makro "\mergesort" sejme ze vstupnho proudu
do "#1" prvn poloku prvn skupiny, do "#2" zbytek prvn skupiny a do 
"#3" prvn poloku druh skupiny. Je-li "#1<#3", je do vstupnho
zatdnho seznamu "\indexbuffer" vloen "#1", ze vstupnho proudu je
"#1" odebrn a "\mergesort" je zavoln znovu. V ppad "#3<#1"
je do "\indexbuffer" vloen "#3", ze vstupnho proudu je "#3" odebrn a 
"\mergesort" je zavoln znovu. dky~\cite[merge:p1]
a~\cite[merge:p2] e ppady, kdy je jedna ze skupin przdn: 
je poteba vloit do "\indexbuffer" zbytek neprzdn skupiny a pejt 
na dal dvojici skupin. Ostatn dky makra se vyrovnvaj se
skutenost, e zpracovn narazilo na zarku "\end,\end" a je tedy
poteba vystartovat dal prchod.
\par}

Vlastn srovnn dvou poloek dl makro 
\db isAleB "<polA><polB>". Poloky jsou tvaru kontroln
sekvence "\-<slovoA>" a "\-<slovoB>". 
Makro konvertuje sv parametry pomoc "\string" na adu znak a
expanduje na "\testAleB"~"<slovoA>\relax<slovoB>\relax".
Navc je na tento test aplikovno "\lowercase", 
nebo nerozliujeme pi azen mezi velkmi a malmi psmeny.

\ilabel [teckanula] {0\nb relax}
%\ilabel [teckajedna] {2.1}
\inext {def\nb isAleB }{^^B\cbrace}{++}

Makro \db testAleB "<slovoA>\relax<slovoB>\relax" zjist, zda je 
"<slovoA>" men ne "<slovoB>". Makro vol 
samo sebe, pokud jsou prvn porovnvan znaky stejn. Rekurze urit
skon, nebo na dku~\cite[teckanula]
jsou k porovnvanm slovm pipojeny rzn ocasy.

\inext {def\nb testAleB}{^^B\cbrace}{++}

Makro \db napercarky vlo mezi poloky do "\indexbuffer" separtory "\,".
To se provede uvnit "\edef\indexbuffer" na dku~\cite[napercarky].

\inext {def\nb napercarky}{\empty}{+-}


\subsec Transformace seznamu strnek
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Kad vskyt "<slova>"
ulo do "\reffile" daj \db refuseword "{<slovo>}{<strana>}", kter
peteme na zatku zpracovn v dalm prchodu:

\inext {def\nb refuseword}{^^B\cbrace}{++}

V sekvenci "\w:<slovo>" tedy mme seznam strnek s vskyty "<slova>",
strnky jsou oddleny rkami. Seznam me vypadat teba takto:

\begtt
2,5,5,10,11,12,12,13,13,13,27
\endtt

Clem je takovto seznam strnek vytisknout ve formtu 
"2, 5, 10--13, 27", tj. odstranit duplicity a nahradit souvisle jdouc
adu strnek zpisem ve tvaru "<od>--<do>". Tuto prci dl makro
\db listofpages "{<slovo>}", kter pedhod makru "\transf" expandovan seznam
strnek ukonen ",0,".

\inext {def\nb listofpages}{^^B\cbrace}{++}

Makro "\transf" vylou ze seznamu strnek ty, kter jsou rovny
\db dgnum a \db apinum. Nechceme toti, aby se v seznamu opakovala hlavn
strnka "<slova>" a podtren strnka. Tyto strnky jsou vytitny u
dve. Deklarujeme uveden registry:

\inext {newcount\nb apinum}{\empty}{+-}

Krom toho jsme deklarovali pomocn \db tempnum (aktuln zpracovvan
strnka), \db ifdash (zda zpracovvme souvislou skupinu strnek 
a vytiskli jsme "--") a 
\db iffirst  (zda vkldme prvn slo, tj. nen nutn vloit rku).

Makro \db transf "<seznam strnek>,0," spust cyklus pomoc \db cykltransf.

\inext {def\nb transf}{def\nb carka}{++}

Makro "\cykltransf" je takov mal stavov automat. Vm, e mu ten
porozum bez dalho komente. 

\subsec [dvasloupce] Vce sloupc
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Sazba do vce sloupc je kompletn pevzata z \TeX{}booku naruby,
strany 244--246. 

\ilabel [dimen1] {dimen1<2}
\inext {newdimen\nb colsep}{TBN}{++}

Zde navc eme problm, e na zatku pepnut do
dvou sloupc pomoc \db begmulti "2" si makro na dku~\cite[dimen1]
zkontroluje, zda nen blzko dna strnky a v takovm ppad zahj
dva sloupce a na nov strnce. Ovem vypad hloup, pokud se kvli
tomu ulom nadpis \uv{Rejstk} od jeho obsahu. Je tedy poteba
provst podobn men strnky u ped tiskem nadpisu \uv{Rejstk}.
K tomu slou makro \db calculatedimone sputn na 
dku~\cite[calculatedimone] v makru "\doindex".

\inext {def\nb calculatedimone}{\empty}{+-}

\subsec Zvren nastaven, kategorie
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Kategorie je rozumn nastavit a na konci souboru {\tt docby.tex}.
Na rozdl od plainu pidvme aktivn kategorii pro znak palce a
nastavujeme podtrtko na obyejnou kategorii, protoe se ve
zdrojovch kdech program asto pouv a vbec ne ve vznamu
matematickho indexu. Kdyby mu tento vznam zstal, byly by jen
pote.

Podtrtko je dal problm. Skoro vdy chceme, aby se ve 
vnitnch makrech chovalo jako normln podtrtko, ale kdy tiskneme text s
podtrtkem fontem, kter na dan pozici podtrtko nem (to je Knuthv
odkaz), pak by se to mlo udlat plainovskm makrem "\_", Toto makro tedy
schovme do \db subori a pak ho probudme k~ivotu jen v~okamiku tisku
v~makrech "\printsec", "\printsubsec", "\title" a "\normalhead".
Uivatel tedy me napsat "\sec moje\_funkce" a v~makrech se bude "\_" jako
obyejn podtrtko, zatmco pi tisku v nadpise se pouije "\subori".

\inext {catcode`\nb_}{\empty}{+-}

Nastavenm "\everymath" a "\everydisplay" zarume matematikm stle
monost pouvat podtrtko ve vznamu indexu.

Aktivn palec spust lokln verbatim prosted uvnit odstavce:

\inext {catcode`\nb}{\empty}{+-}

Makro \db langleactive nastav aktivn kategorii pro znak je men
({\tt<}), take bude mon zapisovat {\tt<text>} a vytiskne se
"<text>". 

\inext {def\nb langleactive}{\empty}{+-}

V tomto dokumentu jsem "\langleactive" pouil v makru
"\quotehook", protoe nechat znak {\tt<} aktivn vude nedlalo dobrotu.

\doindex

\bye


