/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `./tablue.dat'.                         */

/* tablue.h */

/*
 * Copyright (C) 2013-2015 by Werner Lemberg.
 *
 * This file is part of the ttfautohint library, and may only be used,
 * modified, and distributed under the terms given in `COPYING'.  By
 * continuing to use, modify, or distribute this file you indicate that you
 * have read `COPYING' and understand and accept it fully.
 *
 * The file `COPYING' mentioned in the previous paragraph is distributed
 * with the ttfautohint library.
 */


/* originally file `afblue.h' (2013-Sep-11) from FreeType */


#ifndef __TABLUE_H__
#define __TABLUE_H__


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed */
#define GET_UTF8_CHAR(ch, p) \
  ch = (unsigned char)*p++; \
  if (ch >= 0x80) \
  { \
    FT_UInt len; \
\
\
    if (ch < 0xE0) \
    { \
      len = 1; \
      ch &= 0x1F; \
    } \
    else if (ch < 0xF0) \
    { \
      len = 2; \
      ch &= 0x0F; \
    } \
    else \
    { \
      len = 3;\
      ch &= 0x07; \
    } \
\
    for (; len > 0; len--) \
      ch = (ch << 6) | (*p++ & 0x3F); \
  }


/****************************************************************
 *
 *                        BLUE STRINGS
 *
 ****************************************************************/

/* At the bottommost level, we define strings for finding blue zones. */


#define TA_BLUE_STRING_MAX_LEN 8

/* The TA_Blue_String enumeration values are offsets into the */
/* `ta_blue_strings' array. */

typedef enum TA_Blue_String_
{
    TA_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 0,
    TA_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 17,
    TA_BLUE_STRING_CYRILLIC_SMALL = 34,
    TA_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 51,
    TA_BLUE_STRING_DEVANAGARI_BASE = 58,
    TA_BLUE_STRING_DEVANAGARI_TOP = 83,
    TA_BLUE_STRING_DEVANAGARI_HEAD = 108,
    TA_BLUE_STRING_DEVANAGARI_BOTTOM = 133,
    TA_BLUE_STRING_GREEK_CAPITAL_TOP = 140,
    TA_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 155,
    TA_BLUE_STRING_GREEK_SMALL_BETA_TOP = 168,
    TA_BLUE_STRING_GREEK_SMALL = 181,
    TA_BLUE_STRING_GREEK_SMALL_DESCENDER = 198,
    TA_BLUE_STRING_HEBREW_TOP = 215,
    TA_BLUE_STRING_HEBREW_BOTTOM = 232,
    TA_BLUE_STRING_HEBREW_DESCENDER = 245,
    TA_BLUE_STRING_LATIN_CAPITAL_TOP = 256,
    TA_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 265,
    TA_BLUE_STRING_LATIN_SMALL_F_TOP = 274,
    TA_BLUE_STRING_LATIN_SMALL = 282,
    TA_BLUE_STRING_LATIN_SMALL_DESCENDER = 290,
    TA_BLUE_STRING_TELUGU_TOP = 296,
    TA_BLUE_STRING_TELUGU_BOTTOM = 318,


  TA_BLUE_STRING_MAX   /* do not remove */
} TA_Blue_String;


extern const char ta_blue_strings[];


/****************************************************************
 *
 *                      BLUE STRINGSETS
 *
 ****************************************************************/

/* The next level is to group blue strings into style-specific sets. */


/* Properties are specific to a writing system.  We assume that a given */
/* blue string can't be used in more than a single writing system, which */
/* is a safe bet. */
#define TA_BLUE_PROPERTY_LATIN_TOP (1 << 0) /* must have value 1 */
#define TA_BLUE_PROPERTY_LATIN_NEUTRAL (1 << 1)
#define TA_BLUE_PROPERTY_LATIN_X_HEIGHT (1 << 2)
#define TA_BLUE_PROPERTY_LATIN_LONG (1 << 3)


#define TA_BLUE_STRINGSET_MAX_LEN 7

/* The TA_Blue_Stringset enumeration values are offsets into the */
/* `ta_blue_stringsets' array. */

typedef enum TA_Blue_Stringset_
{
    TA_BLUE_STRINGSET_CYRL = 0,
    TA_BLUE_STRINGSET_DEVA = 6,
    TA_BLUE_STRINGSET_GREK = 12,
    TA_BLUE_STRINGSET_HEBR = 19,
    TA_BLUE_STRINGSET_LATN = 23,
    TA_BLUE_STRINGSET_TELU = 30,


  TA_BLUE_STRINGSET_MAX   /* do not remove */
} TA_Blue_Stringset;


typedef struct TA_Blue_StringRec_
{
  TA_Blue_String string;
  FT_UShort properties;
} TA_Blue_StringRec;


extern const TA_Blue_StringRec ta_blue_stringsets[];

#endif /* __TABLUE_H__ */

/* end of tablue.h */
