;;; pkginfo/bitmap-mule/auto-autoloads.el

;;; Copyright (C) 2002 The Meadow Team

;; Author: KOSEKI Yoshinori <kose@meadowy.org>

;; Make bitmap16 font and set to all fontsets.
;; Using Meadow/fonts/intlfonts/bmp16-etl.bdf.

(defvar bdf-use-intlfonts16 nil "\
*If no-nil Make intlfonts 16 dot fontsets, and use it")

;;
(add-to-list 'bdf-directory-list 
	     (expand-file-name "../../fonts/intlfonts" data-directory))

(when bdf-use-intlfonts16
  (defvar intlfonts-file-16dot-alist
    (append '((ascii 
       ;; normal         bold
      ("lt1-16-etl.bdf" "lt1-16b-etl.bdf" 
	;; italic           bold-italic
	"lt1-16i-etl.bdf" "lt1-16bi-etl.bdf") 0)
      (katakana-jisx0201 ("8x16rk.bdf") 1)     ;; JISX0201
      (latin-jisx0201 ("8x16rk.bdf") 0)        ;; JISX0201
      (japanese-jisx0208 ("j90-16.bdf" "j90-16b.bdf" 
			  "j90-16i.bdf" "j90-16bi.bdf") 0);;JISX0208.1990
      (japanese-jisx0208-1978 ("j78-16.bdf") 0);; JISX0208.1978
      (latin-iso8859-1 ("lt1-16-etl.bdf") 1);; ISO8859-1
      (latin-iso8859-2 ("lt2-16-etl.bdf") 1);; ISO8859-2
      (latin-iso8859-3 ("lt3-16-etl.bdf") 1);; ISO8859-3
      (latin-iso8859-4 ("lt4-16-etl.bdf") 1);; ISO8859-4
      (thai-tis620 ("thai16.bdf") 1);; TIS620
      (greek-iso8859-7 ("grk16-etl.bdf") 1);; ISO8859-7
      (arabic-iso8859-6 ("arab16-0-etl.bdf") 0);; ISO8859-6 ???
      (hebrew-iso8859-8 ("heb16-etl.bdf") 1);; ISO8859-8
      (cyrillic-iso8859-5 ("cyr16-etl.bdf") 1);; ISO8859-5
      (latin-iso8859-9 ("lt5-16-etl.bdf") 1);; ISO8859-9
      (chinese-gb2312 ("gb16fs.bdf") 0 );; GB2312  ???
      (korean-ksc5601 ("hanglm16.bdf") 0);; KSC5601   mincho
      ;;(korean-ksc5601 "hanglg16.bdf" 0)    ;; KSC5601   gothic
      (japanese-jisx0212 ("jksp16.bdf") 0);; JISX0212
      (chinese-cns11643-1 ("cns1-16.bdf") 0);; CNS11643.1992-1
      (chinese-cns11643-2 ("cns2-16.bdf") 0);; CNS11643.1992-2
      (chinese-cns11643-3 ("cns3-16.bdf") 0);; CNS11643.1992-3
      (chinese-cns11643-4 ("cns4-16.bdf") 0);; CNS11643.1992-4
      (chinese-cns11643-5 ("cns5-16.bdf") 0);; CNS11643.1992-5
      (chinese-cns11643-6 ("cns6-16.bdf") 0);; CNS11643.1992-6
      (chinese-cns11643-7 ("cns7-16.bdf") 0);; CNS11643.1992-7
      (chinese-big5-1 ("taipei16.bdf") encode-big5-font);; Big5
      (chinese-big5-2 ("taipei16.bdf") encode-big5-font);; Big5
      (chinese-sisheng ("sish16-etl.bdf") 0);; sisheng_cwnn ???
      (vietnamese-viscii-lower ("visc16-etl.bdf") encode-viscii-font);;VISCII1.1
      (vietnamese-viscii-upper ("visc16-etl.bdf") encode-viscii-font);;VISCII1.1
      (arabic-digit ("arab16-0-etl.bdf") 0);; MuleArabic-0
      (arabic-1-column ("arab16-1-etl.bdf") 0);; MuleArabic-1
      (arabic-2-column ("arab16-2-etl.bdf") 0);; MuleArabic-2
      (ipa ("ipa16-etl.bdf") 1);; MuleIPA
      (ethiopic ("ethio16f-uni.bdf") encode-ethio-font);; Ethiopic-Unicode
      ;;(ascii-right-to-left "lt1-16-etl.bdf" 0) ;; ISO8859-1 ;; ???
      (indian-is13194 ("isci16-mule.bdf") 0);; IS13194-Devanagari
      (indian-2-column ("ind16-mule.bdf") 0);; MuleIndian-2
      (indian-1-column ("ind1c16-mule.bdf") 0);; MuleIndian-1
      (lao ("lao16-mule.bdf") 1);; MuleLao-1
      (tibetan ("tib16-mule.bdf") 0);; MuleTibetan-0
      ;;(tibetan-1-column ("tib1c16-mule.bdf") 0);; MuleTibetan-1
      )
    (if (memq 'japanese-jisx0213-1 charset-list)
	'((japanese-jisx0213-1 ("j00-1-16.bdf") 0) ;; JIS X 0123-1
	  (japanese-jisx0213-2 ("j00-2-16.bdf") 0))) ;; JIS X 0123-2
    ))
  (require 'bdf)
  (bdf-configure-fontset "intlfonts16" intlfonts-file-16dot-alist))

;;; auto-autoloads.el ends here
