;;;; -*- mode: lisp-interaction; syntax: elisp; coding: iso-2022-7bit -*-
;;;;
;;;; Copyright (C) 2001 The Meadow Team

;; Author: KOSEKI Yoshinori <kose@meadowy.org>

;; dictionary dir.
(setenv "ISPELLDICTDIR" (expand-file-name 
	      "../../site-lisp/etc/ispell" data-directory))

;; default dictionary.
(setenv "DICTIONARY" (expand-file-name 
	      "../../site-lisp/etc/ispell/US-xlg.hash" data-directory))

;; Alternate dictionary.
(setq ispell-alternate-dictionary
    (expand-file-name "../../site-lisp/etc/ispell/word" data-directory))

(setq ispell-local-dictionary-alist
    '((nil				; default (english.aff)
       "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil iso-8859-1)
      ("UK-xlg"				; english large version
       "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B" "-d" "UK-xlg") nil iso-8859-1)
      ("US-xlg"				; american large version
       "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B" "-d" "US-xlg") nil iso-8859-1)))

;; escape Japanese char.
(eval-after-load "ispell"
  '(setq ispell-skip-region-alist (cons '("[^\000-\377]")
					ispell-skip-region-alist)))
;; end
