;;; pkginfo/intlfonts/auto-autoloads.el
;;;
;;; $Id: auto-autoloads.el 628 2005-02-19 02:28:58Z kose $
;;;
;;; Copyright (C) 2002-2005 The Meadow Team
;;;
;;; Author: KOSEKI Yoshinori <kose@meadowy.org>

;;
(when (eq system-type 'windows-nt)
  (add-to-list 'bdf-directory-list 
	       (expand-file-name "fonts/intlfonts" netinstall-pkg-dir))
  (eval-after-load "ps-bdf"
    '(add-to-list 'bdf-directory-list 
	  (expand-file-name "fonts/intlfonts" netinstall-pkg-dir))))

(cond
 ((featurep 'meadow)
;;; for Meadow

;; 0 -> nil($B$J$7(B)    1 -> 1-byte-set-msb
  (defvar intlfonts-file-16dot-alist
    (append '((ascii 
       ;; normal         bold
      ("lt1-16-etl.bdf" "lt1-16b-etl.bdf" 
	;; italic           bold-italic
	"lt1-16i-etl.bdf" "lt1-16bi-etl.bdf"))
      (katakana-jisx0201 ("8x16rk.bdf") 1-byte-set-msb)     ;; JISX0201
      (latin-jisx0201 ("8x16rk.bdf"))        ;; JISX0201
      (japanese-jisx0208 ("j90-16.bdf" "j90-16b.bdf" 
			  "j90-16i.bdf" "j90-16bi.bdf"));;JISX0208.1990
      (japanese-jisx0208-1978 ("j78-16.bdf"));; JISX0208.1978
      (latin-iso8859-1 ("lt1-16-etl.bdf") 1-byte-set-msb);; ISO8859-1
      (latin-iso8859-2 ("lt2-16-etl.bdf") 1-byte-set-msb);; ISO8859-2
      (latin-iso8859-3 ("lt3-16-etl.bdf") 1-byte-set-msb);; ISO8859-3
      (latin-iso8859-4 ("lt4-16-etl.bdf") 1-byte-set-msb);; ISO8859-4
      (thai-tis620 ("thai16.bdf") 1-byte-set-msb);; TIS620
      (greek-iso8859-7 ("grk16-etl.bdf") 1-byte-set-msb);; ISO8859-7
      (arabic-iso8859-6 ("arab16-0-etl.bdf"));; ISO8859-6 ???
      (hebrew-iso8859-8 ("heb16-etl.bdf") 1-byte-set-msb);; ISO8859-8
      (cyrillic-iso8859-5 ("cyr16-etl.bdf") 1-byte-set-msb);; ISO8859-5
      (latin-iso8859-9 ("lt5-16-etl.bdf") 1-byte-set-msb);; ISO8859-9
      (chinese-gb2312 ("gb16fs.bdf"));; GB2312  ???
      (korean-ksc5601 ("hanglm16.bdf"));; KSC5601   mincho
      ;;(korean-ksc5601 "hanglg16.bdf")    ;; KSC5601   gothic
      (japanese-jisx0212 ("jksp16.bdf"));; JISX0212
      (chinese-cns11643-1 ("cns1-16.bdf"));; CNS11643.1992-1
      (chinese-cns11643-2 ("cns2-16.bdf"));; CNS11643.1992-2
      (chinese-cns11643-3 ("cns3-16.bdf"));; CNS11643.1992-3
      (chinese-cns11643-4 ("cns4-16.bdf"));; CNS11643.1992-4
      (chinese-cns11643-5 ("cns5-16.bdf"));; CNS11643.1992-5
      (chinese-cns11643-6 ("cns6-16.bdf"));; CNS11643.1992-6
      (chinese-cns11643-7 ("cns7-16.bdf"));; CNS11643.1992-7
      (chinese-big5-1 ("taipei16.bdf") encode-big5-font);; Big5
      (chinese-big5-2 ("taipei16.bdf") encode-big5-font);; Big5
      (chinese-sisheng ("sish16-etl.bdf"));; sisheng_cwnn ???
      (vietnamese-viscii-lower ("visc16-etl.bdf") encode-viscii-font);;VISCII1.1
      (vietnamese-viscii-upper ("visc16-etl.bdf") encode-viscii-font);;VISCII1.1
      (arabic-digit ("arab16-0-etl.bdf"));; MuleArabic-0
      (arabic-1-column ("arab16-1-etl.bdf"));; MuleArabic-1
      (arabic-2-column ("arab16-2-etl.bdf"));; MuleArabic-2
      (ipa ("ipa16-etl.bdf") 1-byte-set-msb);; MuleIPA
      (ethiopic ("ethio16f-uni.bdf") encode-ethio-font);; Ethiopic-Unicode
      ;;(ascii-right-to-left "lt1-16-etl.bdf") ;; ISO8859-1 ;; ???
      (indian-is13194 ("isci16-mule.bdf"));; IS13194-Devanagari
      (indian-2-column ("ind16-mule.bdf"));; MuleIndian-2
      (indian-1-column ("ind1c16-mule.bdf"));; MuleIndian-1
      (lao ("lao16-mule.bdf") 1-byte-set-msb);; MuleLao-1
      (tibetan ("tib16-mule.bdf"));; MuleTibetan-0
      ;;(tibetan-1-column ("tib1c16-mule.bdf"));; MuleTibetan-1
      )
   (if (memq 'japanese-jisx0213-1 charset-list)
       '((japanese-jisx0213-1 
	  (;;"j00-1-16.bdf"
	   "jiskan16-2000-1.bdf"
	   "jiskan16-2000-1b.bdf"
	   "jiskan16-2000-1i.bdf"
	   "jiskan16-2000-1bi.bdf")) ;; JIS X 0123-1
	 (japanese-jisx0213-2 
	  (;;"j00-2-16.bdf"
	   "jiskan16-2000-2.bdf"
	   "jiskan16-2000-2b.bdf"
	   "jiskan16-2000-2i.bdf"
	   "jiskan16-2000-2bi.bdf")))) ;; JIS X 0123-2
    ))
  (require 'bdf)
  (bdf-configure-fontset "intlfonts16" intlfonts-file-16dot-alist)
  ;;
  (unless (assoc 'font default-frame-alist)
    (setq default-frame-alist 
	  (add-to-list 'default-frame-alist `(font . "intlfonts16")))))

 ((eq system-type 'windows-nt)
;;; for NTEmacs
  (setq w32-bdf-filename-alist
	(w32-find-bdf-fonts (list (expand-file-name "../packages/fonts/intlfonts" data-directory))))

  (setq font-encoding-alist
	(append '(("jisx0201"        (latin-jisx0201 . 0))
		  ("jisx0201"        (katakana-jisx0201 . 1))
		  ("JISX0208"        (japanese-jisx0208 . 0))
		  ("JISC6226.1978"   (japanese-jisx0208-1978 . 0))
		  ("JISX0213.2000-1" (japanese-jisx0213-1 . 0))
		  ("JISX0213.2000-2" (japanese-jisx0213-2 . 0))
		  ) font-encoding-alist))

  (create-fontset-from-fontset-spec
   "-*-fixed-medium-r-normal-*-16-*-*-*-*-*-fontset-intlfonts16,
latin-jisx0201:-sony-fixed-medium-r-normal--16-*-*-*-*-*-jisx0201.1976-0,
katakana-jisx0201:-sony-fixed-medium-r-normal--16-*-*-*-*-*-jisx0201.1976-0,
japanese-jisx0208-1978:-misc-fixed-medium-r-normal--16-*-*-*-*-*-jisc6226.1978-0,
japanese-jisx0208:-misc-fixed-medium-r-normal--16-*-*-*-*-*-jisx0208.1990-0"
 t t)
  ;;
  (unless (assoc 'font default-frame-alist)
    (setq default-frame-alist 
	  (add-to-list 'default-frame-alist `(font . "fontset-intlfonts16")))))
 (t
  ;; not Meadow, not NTEmacs
  ))


;;; auto-autoloads.el ends here
