/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.OperatingSystem;
import installer.Progress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class InstallThread
extends Thread {
    private Install installer;
    private Progress progress;
    private String installDir;
    private String binDir;
    private int size;
    private Vector components;
    private byte[] buf;
    private boolean killed = false;

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void run() {
        this.progress.setMaximum(this.size * 1024);
        try {
            int i = 0;
            while (i < this.components.size()) {
                if (this.killed) {
                    return;
                }
                this.installComponent((String)this.components.elementAt(i));
                ++i;
            }
            if (this.binDir != null) {
                if (this.killed) {
                    return;
                }
                OperatingSystem.getOperatingSystem().mkdirs(this.binDir);
            }
            if (this.killed) {
                return;
            }
            OperatingSystem.getOperatingSystem().createScript(this.installer, this.installDir, this.binDir);
        }
        catch (IOException io) {
            this.progress.error(io.toString());
            return;
        }
        this.progress.done();
    }

    public void kill() {
        this.killed = true;
    }

    /*
     * WARNING - void declaration
     */
    private void installComponent(String name) throws IOException {
        String fileName;
        BufferedReader fileList = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(name)));
        OperatingSystem os = OperatingSystem.getOperatingSystem();
        String execExtension = os.getExecScriptExtension();
        while ((fileName = fileList.readLine()) != null) {
            void var5_5;
            if (this.killed) {
                return;
            }
            String outfile = this.installDir + File.separatorChar + var5_5.replace('/', File.separatorChar);
            BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream("/" + (String)var5_5));
            if (in == null) {
                throw new FileNotFoundException((String)var5_5);
            }
            this.copy(in, outfile);
            if (execExtension != null && var5_5.endsWith(execExtension)) {
                os.chmodScript(outfile);
            }
            ((InputStream)in).close();
        }
        fileList.close();
    }

    private void copy(InputStream in, String outfile) throws IOException {
        int count;
        File outFile = new File(outfile);
        OperatingSystem.getOperatingSystem().mkdirs(outFile.getParent());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        while ((count = in.read(this.buf, 0, this.buf.length)) != -1) {
            out.write(this.buf, 0, count);
            this.progress.advance(count);
        }
        in.close();
        out.close();
    }

    public InstallThread(Install installer, Progress progress, String installDir, String binDir, int size, Vector components) {
        super("Install thread");
        this.installer = installer;
        this.progress = progress;
        this.installDir = installDir;
        this.binDir = binDir;
        this.size = size;
        this.components = components;
        this.buf = new byte[32768];
    }
}

