/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.MySQLBlob;

class BlobOutputStream
extends OutputStream {
    int pos;
    MySQLBlob blob;

    public BlobOutputStream(MySQLBlob blob, int pos) {
        this.blob = blob;
        this.pos = pos;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos >= this.blob.blobContent.length) {
            byte[] tmp = new byte[2 * this.blob.blobContent.length + 1];
            System.arraycopy(this.blob.blobContent, 0, tmp, 0, this.blob.blobContent.length);
            this.blob.blobContent = tmp;
        }
        this.blob.blobContent[this.pos] = (byte)b;
        ++this.pos;
        if (this.pos > this.blob.actualSize) {
            this.blob.actualSize = this.pos;
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        if (this.pos + len >= this.blob.blobContent.length) {
            int newLen = Math.max(2 * (this.pos + len + 1), 1024);
            byte[] tmp = new byte[newLen];
            System.arraycopy(this.blob.blobContent, 0, tmp, 0, this.blob.blobContent.length);
            this.blob.blobContent = tmp;
        }
        System.arraycopy(buf, off, this.blob.blobContent, this.pos, len);
        this.pos += len;
        if (this.pos > this.blob.actualSize) {
            this.blob.actualSize = this.pos;
        }
    }

    @Override
    public void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }
}

