/*
  IBM PC screen. Written by K. Asayama Aug, 1995.
 
  This code requires DJ's gpp, and libgr.a or libgrx.a.
 */

#define EXTERN extern
#include "../mfd.h"

#ifdef IBMPCWIN

#ifdef DJGPP
#  if DJGPP >= 2
#    define DJGPP_VERSION_2
#  endif
#endif

#ifdef DJGPP_VERSION_2
#    include "grx20.h"
#else
#  ifdef HAVE_LIBGRX
#    include "grx.h"
#  else
#    include "graphics.h"
#  endif
#endif

#define WHITE 200

static int black_index,white_index;
static int screen_bottom, screen_right;
static void term_graphics(void);

/* public routines */

mf_ibmpc_initscreen()
{
	GrSetMode(GR_default_graphics);
	black_index = GrBlack();
	white_index = GrAllocColor(WHITE,WHITE,WHITE);
	if (white_index < 0)
		white_index = GrWhite();
	screen_right = GrMaxX();
	screen_bottom = GrMaxY();
	atexit(term_graphics);
	return 1;
}

mf_ibmpc_updatescreen()
{
}

mf_ibmpc_blankrectangle(left, right, top, bottom)
screencol left, right;
screenrow top, bottom;
{
#if HAVE_LIBGRX
	GrFilledBox(left,top,right,bottom,white_index);
#else
	if (right >= 0 && bottom >= 0) {
		if (left < 0) left = 0;
		if (top < 0) top = 0;
		if (right > screen_right) right = screen_right;
		if (bottom > screen_bottom) bottom = screen_bottom;
		while (top <= bottom) {
			GrLine(left, top, right, top, white_index);
			top++;
		}
	}
#endif
}

mf_ibmpc_paintrow(row, init_color, tvect, vector_size)
screenrow row;
pixelcolor init_color;
transspec tvect;
register screencol vector_size;
{
	if (row >= 0 && row < screen_bottom) {
		int c = init_color ? black_index : white_index;
		int col;
		do {
			col = *tvect++;
			GrLine(col, row, *tvect-1, row, c);
			c = (c == black_index) ? white_index : black_index;
		} while (--vector_size > 0 && col <= screen_right);
	}
}

/* internal routines */
static void term_graphics(void)
{
	GrSetMode(GR_default_text);
}
#else
int mf_ibmpc_dummy;
#endif
