#include "maketex.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>

#include <kpathsea/cnf.h>
#include <kpathsea/lib.h>
#include <kpathsea/progname.h>
#include <kpathsea/variable.h>

#define KPSE_VAR_DEFINED(var) ( getenv(var) || kpse_cnf_get(var) )

static unsigned int mode_dpi,dpi;
static char *font,*mode,*mag;

static char *gf_filename,*pk_filename;
static char *filename_temp;

static int tfm_only_f = 0;

static char *get_mode(unsigned int dpi)
{
  char *var = xmalloc(30);
  sprintf(var,"$MAKETEXPK_MODE_%u",dpi);
  return KPSE_VAR_DEFINED(var+1) ? kpse_var_expand(var) : NULL;
}

static int exec_metafont(void)
{
  int code;
  char *mfarg;
  char *prog_argv[10];

  mfarg = xmalloc(strlen(font) + strlen(mag) + strlen(mode) + 50);
  sprintf(mfarg,"\\mode:=%s;mag:=%s;input %s",mode,mag,font);
  prog_argv[0] = "mf.exe";
  prog_argv[1] = mfarg;
  prog_argv[2] = NULL;
  code = spawnvp_silently(prog_argv);
  free(mfarg);
  if (code < 0 || (tfm_only_f && code)) return -1;
  sprintf(filename_temp,"%s.log",font);
  unlink(filename_temp);
  if (tfm_only_f) return 0;
  if (access(gf_filename,0)) return -1;

  prog_argv[0] = "gftopk.exe";
  prog_argv[1] = gf_filename;
  prog_argv[2] = pk_filename;
  prog_argv[3] = NULL;
  code = spawnvp_silently(prog_argv);
  if (code) return -1;
  unlink(gf_filename);

  return 0;
}

int main(int argc,char *argv[])
{
  int code;
  char *prog_name;
  char *texmf;
  char *cwd,*tmp_dir,*tmp_disk_cwd;

  prog_name = remove_suffix(xstrdup(basename(argv[0])));

  kpse_set_progname(argv[0]);

  if (strcmp(prog_name,"MakeTeXTFM") == 0) {
    tfm_only_f = 1;
    if (argc != 2) {
      fprintf(stderr,"Usage: %s <FONT>\n",
  		prog_name);
      exit(1);
    }
    dpi = mode_dpi = 300; /* dummy */
    mag = "1.0";
    mode = "nullmode";
  }
  else {
    if (argc < 5 || argc > 6) {
      fprintf(stderr,"Usage: %s <FONT> <DPI> <MODE-DPI> <MAG> [<MODE>]\n",
		prog_name);
      exit(1);
    }
    dpi = atoi(argv[2]);
    mode_dpi = atoi(argv[3]);
    mag = argv[4];
    if (argc <= 5) {
      mode = get_mode(mode_dpi);
      if (mode == NULL) {
        fprintf(stderr,"Could not guess the METAFONT mode for DPI %u.\n",
		  mode_dpi);
	    exit(1);
      }
    }
    else mode = argv[5];
  }

  font = remove_suffix(xstrdup(argv[1]));

  xputenv("MAKETEX_MODE",mode); /* defined in kpathsea lib. */

  filename_temp = xmalloc(strlen(font)+30);
  gf_filename = xmalloc(strlen(font)+30);
  sprintf(gf_filename,"%s.%ugf",font,dpi);
  pk_filename = xmalloc(strlen(font)+30);
  if (truncate_fontname_p()) {
    sprintf(pk_filename,"%s.pk",font);
    pk_filename = truncate_fontname(pk_filename);
  }
  else sprintf(pk_filename,"%s.%upk",font,dpi);

  texmf = kpse_var_expand("$TEXMF");

  signal(SIGINT,SIG_IGN);

  tmp_dir = xmalloc(strlen(texmf)+30);
  sprintf(tmp_dir,"%s/fonts/tmp",texmf);
  cwd = getcwd(NULL,MAXPATHLEN);
  if (access(tmp_dir,0)) {
    code = mkdir_recursively(tmp_dir);
    if (code < 0) tmp_dir = cwd;
  }
  if (isalpha(tmp_dir[0]) && tmp_dir[1] == ':') {
    chdisk(tolower(tmp_dir[0])-'a');
  }
  tmp_disk_cwd = getcwd(NULL,MAXPATHLEN);
  chdir(tmp_dir);

  code = exec_metafont();

  if (code >= 0) {
    char *pk_dir,*pk_pathname;
    char *tfm_dir,*tfm_pathname,*tfm_filename;
    if (!tfm_only_f) {
      if (KPSE_VAR_DEFINED("MAKETEX_PKDIR")) {
        pk_dir = kpse_var_expand("$MAKETEX_PKDIR");
      }
      else {
        pk_dir = xmalloc(strlen(texmf)+20);
        strcpy(pk_dir,texmf);
       strcat(pk_dir,"/fonts/pk");
      }
      if (truncate_fontname_p()) {
        char *pk_dir_base = pk_dir;
        pk_dir = xmalloc(strlen(pk_dir_base)+20);
        sprintf(pk_dir,"%s/dpi%u",pk_dir_base,dpi);
      }
      pk_pathname = xmalloc(strlen(pk_filename)+strlen(pk_dir)+2);
      sprintf(pk_pathname,"%s/%s",pk_dir,pk_filename);
      if (access(pk_dir,0)) code = mkdir_recursively(pk_dir);
      if (code >= 0) code = copy_file(pk_pathname,pk_filename);
      if (code >= 0) {
        puts(pk_pathname);
        unlink(pk_filename);
      }
    }
    if (KPSE_VAR_DEFINED("MAKETEX_TFMDIR")) {
      tfm_dir = kpse_var_expand("$MAKETEX_TFMDIR");
    }
    else {
      tfm_dir = xmalloc(strlen(texmf)+20);
      strcpy(tfm_dir,texmf);
      strcat(tfm_dir,"/fonts/tfm");
    }
    tfm_filename = xmalloc(strlen(font)+5);
    strcpy(tfm_filename,font);
    strcat(tfm_filename,".tfm");
    tfm_pathname = xmalloc(strlen(tfm_dir)+strlen(tfm_filename)+2);
    sprintf(tfm_pathname,"%s/%s",tfm_dir,tfm_filename);
    if (access(tfm_pathname,0)) {
      int tcode = 0;
      if (access(tfm_dir,0)) tcode = mkdir_recursively(tfm_dir);
      if (tcode >= 0) tcode = copy_file(tfm_pathname,tfm_filename);
    }
    unlink(tfm_filename);
  }

  chdir(tmp_disk_cwd);
  chdisk(tolower(cwd[0])-'a');
  chdir(cwd);

  return code < 0 ? 1 : 0;
}
